<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$production_add = new production_add();

// Run the page
$production_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$production_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fproductionadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fproductionadd = currentForm = new ew.Form("fproductionadd", "add");

	// Validate form
	fproductionadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($production_add->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->idemp->caption(), $production_add->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_add->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->dept->caption(), $production_add->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_add->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->type->caption(), $production_add->type->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_add->idop->Required) { ?>
				elm = this.getElements("x" + infix + "_idop");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->idop->caption(), $production_add->idop->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($production_add->lot->Required) { ?>
				elm = this.getElements("x" + infix + "_lot");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->lot->caption(), $production_add->lot->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_lot");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_add->lot->errorMessage()) ?>");
			<?php if ($production_add->dateprod->Required) { ?>
				elm = this.getElements("x" + infix + "_dateprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->dateprod->caption(), $production_add->dateprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dateprod");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_add->dateprod->errorMessage()) ?>");
			<?php if ($production_add->qtyprod->Required) { ?>
				elm = this.getElements("x" + infix + "_qtyprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->qtyprod->caption(), $production_add->qtyprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_qtyprod");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_add->qtyprod->errorMessage()) ?>");
			<?php if ($production_add->tauxprod->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxprod");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->tauxprod->caption(), $production_add->tauxprod->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxprod");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_add->tauxprod->errorMessage()) ?>");
			<?php if ($production_add->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $production_add->SubTotal->caption(), $production_add->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($production_add->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fproductionadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fproductionadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fproductionadd.lists["x_idemp"] = <?php echo $production_add->idemp->Lookup->toClientList($production_add) ?>;
	fproductionadd.lists["x_idemp"].options = <?php echo JsonEncode($production_add->idemp->lookupOptions()) ?>;
	fproductionadd.lists["x_dept"] = <?php echo $production_add->dept->Lookup->toClientList($production_add) ?>;
	fproductionadd.lists["x_dept"].options = <?php echo JsonEncode($production_add->dept->lookupOptions()) ?>;
	fproductionadd.lists["x_type"] = <?php echo $production_add->type->Lookup->toClientList($production_add) ?>;
	fproductionadd.lists["x_type"].options = <?php echo JsonEncode($production_add->type->lookupOptions()) ?>;
	fproductionadd.lists["x_idop"] = <?php echo $production_add->idop->Lookup->toClientList($production_add) ?>;
	fproductionadd.lists["x_idop"].options = <?php echo JsonEncode($production_add->idop->lookupOptions()) ?>;
	loadjs.done("fproductionadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $production_add->showPageHeader(); ?>
<?php
$production_add->showMessage();
?>
<form name="fproductionadd" id="fproductionadd" class="<?php echo $production_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="production">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$production_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($production_add->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_production_idemp" for="x_idemp" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->idemp->caption() ?><?php echo $production_add->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->idemp->cellAttributes() ?>>
<span id="el_production_idemp">
<?php $production_add->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($production_add->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_add->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_add->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_add->idemp->ReadOnly || $production_add->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_add->idemp->Lookup->getParamTag($production_add, "p_x_idemp") ?>
<input type="hidden" data-table="production" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_add->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $production_add->idemp->CurrentValue ?>"<?php echo $production_add->idemp->editAttributes() ?>>
</span>
<?php echo $production_add->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->dept->Visible) { // dept ?>
	<div id="r_dept" class="form-group row">
		<label id="elh_production_dept" for="x_dept" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->dept->caption() ?><?php echo $production_add->dept->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->dept->cellAttributes() ?>>
<span id="el_production_dept">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_dept" data-value-separator="<?php echo $production_add->dept->displayValueSeparatorAttribute() ?>" id="x_dept" name="x_dept"<?php echo $production_add->dept->editAttributes() ?>>
			<?php echo $production_add->dept->selectOptionListHtml("x_dept") ?>
		</select>
</div>
<?php echo $production_add->dept->Lookup->getParamTag($production_add, "p_x_dept") ?>
</span>
<?php echo $production_add->dept->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_production_type" for="x_type" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->type->caption() ?><?php echo $production_add->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->type->cellAttributes() ?>>
<span id="el_production_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="production" data-field="x_type" data-value-separator="<?php echo $production_add->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $production_add->type->editAttributes() ?>>
			<?php echo $production_add->type->selectOptionListHtml("x_type") ?>
		</select>
</div>
<?php echo $production_add->type->Lookup->getParamTag($production_add, "p_x_type") ?>
</span>
<?php echo $production_add->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->idop->Visible) { // idop ?>
	<div id="r_idop" class="form-group row">
		<label id="elh_production_idop" for="x_idop" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->idop->caption() ?><?php echo $production_add->idop->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->idop->cellAttributes() ?>>
<span id="el_production_idop">
<?php $production_add->idop->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idop"><?php echo EmptyValue(strval($production_add->idop->ViewValue)) ? $Language->phrase("PleaseSelect") : $production_add->idop->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($production_add->idop->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($production_add->idop->ReadOnly || $production_add->idop->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idop',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $production_add->idop->Lookup->getParamTag($production_add, "p_x_idop") ?>
<input type="hidden" data-table="production" data-field="x_idop" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $production_add->idop->displayValueSeparatorAttribute() ?>" name="x_idop" id="x_idop" value="<?php echo $production_add->idop->CurrentValue ?>"<?php echo $production_add->idop->editAttributes() ?>>
</span>
<?php echo $production_add->idop->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->lot->Visible) { // lot ?>
	<div id="r_lot" class="form-group row">
		<label id="elh_production_lot" for="x_lot" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->lot->caption() ?><?php echo $production_add->lot->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->lot->cellAttributes() ?>>
<span id="el_production_lot">
<input type="text" data-table="production" data-field="x_lot" name="x_lot" id="x_lot" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_add->lot->getPlaceHolder()) ?>" value="<?php echo $production_add->lot->EditValue ?>"<?php echo $production_add->lot->editAttributes() ?>>
</span>
<?php echo $production_add->lot->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->dateprod->Visible) { // dateprod ?>
	<div id="r_dateprod" class="form-group row">
		<label id="elh_production_dateprod" for="x_dateprod" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->dateprod->caption() ?><?php echo $production_add->dateprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->dateprod->cellAttributes() ?>>
<span id="el_production_dateprod">
<input type="text" data-table="production" data-field="x_dateprod" data-format="7" name="x_dateprod" id="x_dateprod" maxlength="10" placeholder="<?php echo HtmlEncode($production_add->dateprod->getPlaceHolder()) ?>" value="<?php echo $production_add->dateprod->EditValue ?>"<?php echo $production_add->dateprod->editAttributes() ?>>
<?php if (!$production_add->dateprod->ReadOnly && !$production_add->dateprod->Disabled && !isset($production_add->dateprod->EditAttrs["readonly"]) && !isset($production_add->dateprod->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproductionadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fproductionadd", "x_dateprod", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $production_add->dateprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->qtyprod->Visible) { // qtyprod ?>
	<div id="r_qtyprod" class="form-group row">
		<label id="elh_production_qtyprod" for="x_qtyprod" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->qtyprod->caption() ?><?php echo $production_add->qtyprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->qtyprod->cellAttributes() ?>>
<span id="el_production_qtyprod">
<input type="text" data-table="production" data-field="x_qtyprod" name="x_qtyprod" id="x_qtyprod" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($production_add->qtyprod->getPlaceHolder()) ?>" value="<?php echo $production_add->qtyprod->EditValue ?>"<?php echo $production_add->qtyprod->editAttributes() ?>>
</span>
<?php echo $production_add->qtyprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->tauxprod->Visible) { // tauxprod ?>
	<div id="r_tauxprod" class="form-group row">
		<label id="elh_production_tauxprod" for="x_tauxprod" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->tauxprod->caption() ?><?php echo $production_add->tauxprod->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->tauxprod->cellAttributes() ?>>
<span id="el_production_tauxprod">
<input type="text" data-table="production" data-field="x_tauxprod" name="x_tauxprod" id="x_tauxprod" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($production_add->tauxprod->getPlaceHolder()) ?>" value="<?php echo $production_add->tauxprod->EditValue ?>"<?php echo $production_add->tauxprod->editAttributes() ?>>
</span>
<?php echo $production_add->tauxprod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($production_add->SubTotal->Visible) { // SubTotal ?>
	<div id="r_SubTotal" class="form-group row">
		<label id="elh_production_SubTotal" for="x_SubTotal" class="<?php echo $production_add->LeftColumnClass ?>"><?php echo $production_add->SubTotal->caption() ?><?php echo $production_add->SubTotal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $production_add->RightColumnClass ?>"><div <?php echo $production_add->SubTotal->cellAttributes() ?>>
<span id="el_production_SubTotal">
<input type="text" data-table="production" data-field="x_SubTotal" name="x_SubTotal" id="x_SubTotal" size="30" maxlength="23" placeholder="<?php echo HtmlEncode($production_add->SubTotal->getPlaceHolder()) ?>" value="<?php echo $production_add->SubTotal->EditValue ?>"<?php echo $production_add->SubTotal->editAttributes() ?>>
</span>
<?php echo $production_add->SubTotal->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$production_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $production_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $production_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$production_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

	$(".ew-add-div").addClass("row row-cols-2");
});
</script>
<?php include_once "footer.php"; ?>
<?php
$production_add->terminate();
?>