<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policy_view = new policy_view();

// Run the page
$policy_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policy_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$policy_view->isExport()) { ?>
<script>
var fpolicyview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fpolicyview = currentForm = new ew.Form("fpolicyview", "view");
	loadjs.done("fpolicyview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$policy_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $policy_view->ExportOptions->render("body") ?>
<?php $policy_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $policy_view->showPageHeader(); ?>
<?php
$policy_view->showMessage();
?>
<?php if (!$policy_view->IsModal) { ?>
<?php if (!$policy_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policy_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fpolicyview" id="fpolicyview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policy">
<input type="hidden" name="modal" value="<?php echo (int)$policy_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($policy_view->idpo->Visible) { // idpo ?>
	<tr id="r_idpo">
		<td class="<?php echo $policy_view->TableLeftColumnClass ?>"><span id="elh_policy_idpo"><?php echo $policy_view->idpo->caption() ?></span></td>
		<td data-name="idpo" <?php echo $policy_view->idpo->cellAttributes() ?>>
<span id="el_policy_idpo">
<span<?php echo $policy_view->idpo->viewAttributes() ?>><?php echo $policy_view->idpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policy_view->titlepo->Visible) { // titlepo ?>
	<tr id="r_titlepo">
		<td class="<?php echo $policy_view->TableLeftColumnClass ?>"><span id="elh_policy_titlepo"><?php echo $policy_view->titlepo->caption() ?></span></td>
		<td data-name="titlepo" <?php echo $policy_view->titlepo->cellAttributes() ?>>
<span id="el_policy_titlepo">
<span<?php echo $policy_view->titlepo->viewAttributes() ?>><?php echo $policy_view->titlepo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policy_view->amountpo->Visible) { // amountpo ?>
	<tr id="r_amountpo">
		<td class="<?php echo $policy_view->TableLeftColumnClass ?>"><span id="elh_policy_amountpo"><?php echo $policy_view->amountpo->caption() ?></span></td>
		<td data-name="amountpo" <?php echo $policy_view->amountpo->cellAttributes() ?>>
<span id="el_policy_amountpo">
<span<?php echo $policy_view->amountpo->viewAttributes() ?>><?php echo $policy_view->amountpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policy_view->per->Visible) { // per ?>
	<tr id="r_per">
		<td class="<?php echo $policy_view->TableLeftColumnClass ?>"><span id="elh_policy_per"><?php echo $policy_view->per->caption() ?></span></td>
		<td data-name="per" <?php echo $policy_view->per->cellAttributes() ?>>
<span id="el_policy_per">
<span<?php echo $policy_view->per->viewAttributes() ?>><?php echo $policy_view->per->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policy_view->typepo->Visible) { // typepo ?>
	<tr id="r_typepo">
		<td class="<?php echo $policy_view->TableLeftColumnClass ?>"><span id="elh_policy_typepo"><?php echo $policy_view->typepo->caption() ?></span></td>
		<td data-name="typepo" <?php echo $policy_view->typepo->cellAttributes() ?>>
<span id="el_policy_typepo">
<span<?php echo $policy_view->typepo->viewAttributes() ?>><?php echo $policy_view->typepo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policy_view->peramountpo->Visible) { // peramountpo ?>
	<tr id="r_peramountpo">
		<td class="<?php echo $policy_view->TableLeftColumnClass ?>"><span id="elh_policy_peramountpo"><?php echo $policy_view->peramountpo->caption() ?></span></td>
		<td data-name="peramountpo" <?php echo $policy_view->peramountpo->cellAttributes() ?>>
<span id="el_policy_peramountpo">
<span<?php echo $policy_view->peramountpo->viewAttributes() ?>><?php echo $policy_view->peramountpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$policy_view->IsModal) { ?>
<?php if (!$policy_view->isExport()) { ?>
<?php echo $policy_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$policy_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$policy_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$policy_view->terminate();
?>