<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policy_list = new policy_list();

// Run the page
$policy_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policy_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$policy_list->isExport()) { ?>
<script>
var fpolicylist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fpolicylist = currentForm = new ew.Form("fpolicylist", "list");
	fpolicylist.formKeyCountName = '<?php echo $policy_list->FormKeyCountName ?>';
	loadjs.done("fpolicylist");
});
var fpolicylistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fpolicylistsrch = currentSearchForm = new ew.Form("fpolicylistsrch");

	// Dynamic selection lists
	// Filters

	fpolicylistsrch.filterList = <?php echo $policy_list->getFilterList() ?>;
	loadjs.done("fpolicylistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$policy_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($policy_list->TotalRecords > 0 && $policy_list->ExportOptions->visible()) { ?>
<?php $policy_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($policy_list->ImportOptions->visible()) { ?>
<?php $policy_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($policy_list->SearchOptions->visible()) { ?>
<?php $policy_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($policy_list->FilterOptions->visible()) { ?>
<?php $policy_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$policy_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$policy_list->isExport() && !$policy->CurrentAction) { ?>
<form name="fpolicylistsrch" id="fpolicylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fpolicylistsrch-search-panel" class="<?php echo $policy_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="policy">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $policy_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($policy_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($policy_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $policy_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($policy_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($policy_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($policy_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($policy_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $policy_list->showPageHeader(); ?>
<?php
$policy_list->showMessage();
?>
<?php if ($policy_list->TotalRecords > 0 || $policy->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($policy_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> policy">
<?php if (!$policy_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$policy_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policy_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $policy_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpolicylist" id="fpolicylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policy">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_policy" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($policy_list->TotalRecords > 0 || $policy_list->isGridEdit()) { ?>
<table id="tbl_policylist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$policy->RowType = ROWTYPE_HEADER;

// Render list options
$policy_list->renderListOptions();

// Render list options (header, left)
$policy_list->ListOptions->render("header", "left");
?>
<?php if ($policy_list->idpo->Visible) { // idpo ?>
	<?php if ($policy_list->SortUrl($policy_list->idpo) == "") { ?>
		<th data-name="idpo" class="<?php echo $policy_list->idpo->headerCellClass() ?>"><div id="elh_policy_idpo" class="policy_idpo"><div class="ew-table-header-caption"><?php echo $policy_list->idpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpo" class="<?php echo $policy_list->idpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policy_list->SortUrl($policy_list->idpo) ?>', 1);"><div id="elh_policy_idpo" class="policy_idpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policy_list->idpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policy_list->idpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policy_list->idpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policy_list->titlepo->Visible) { // titlepo ?>
	<?php if ($policy_list->SortUrl($policy_list->titlepo) == "") { ?>
		<th data-name="titlepo" class="<?php echo $policy_list->titlepo->headerCellClass() ?>"><div id="elh_policy_titlepo" class="policy_titlepo"><div class="ew-table-header-caption"><?php echo $policy_list->titlepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titlepo" class="<?php echo $policy_list->titlepo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policy_list->SortUrl($policy_list->titlepo) ?>', 1);"><div id="elh_policy_titlepo" class="policy_titlepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policy_list->titlepo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($policy_list->titlepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policy_list->titlepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policy_list->amountpo->Visible) { // amountpo ?>
	<?php if ($policy_list->SortUrl($policy_list->amountpo) == "") { ?>
		<th data-name="amountpo" class="<?php echo $policy_list->amountpo->headerCellClass() ?>"><div id="elh_policy_amountpo" class="policy_amountpo"><div class="ew-table-header-caption"><?php echo $policy_list->amountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amountpo" class="<?php echo $policy_list->amountpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policy_list->SortUrl($policy_list->amountpo) ?>', 1);"><div id="elh_policy_amountpo" class="policy_amountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policy_list->amountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policy_list->amountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policy_list->amountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policy_list->per->Visible) { // per ?>
	<?php if ($policy_list->SortUrl($policy_list->per) == "") { ?>
		<th data-name="per" class="<?php echo $policy_list->per->headerCellClass() ?>"><div id="elh_policy_per" class="policy_per"><div class="ew-table-header-caption"><?php echo $policy_list->per->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per" class="<?php echo $policy_list->per->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policy_list->SortUrl($policy_list->per) ?>', 1);"><div id="elh_policy_per" class="policy_per">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policy_list->per->caption() ?></span><span class="ew-table-header-sort"><?php if ($policy_list->per->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policy_list->per->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policy_list->typepo->Visible) { // typepo ?>
	<?php if ($policy_list->SortUrl($policy_list->typepo) == "") { ?>
		<th data-name="typepo" class="<?php echo $policy_list->typepo->headerCellClass() ?>"><div id="elh_policy_typepo" class="policy_typepo"><div class="ew-table-header-caption"><?php echo $policy_list->typepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="typepo" class="<?php echo $policy_list->typepo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policy_list->SortUrl($policy_list->typepo) ?>', 1);"><div id="elh_policy_typepo" class="policy_typepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policy_list->typepo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($policy_list->typepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policy_list->typepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policy_list->peramountpo->Visible) { // peramountpo ?>
	<?php if ($policy_list->SortUrl($policy_list->peramountpo) == "") { ?>
		<th data-name="peramountpo" class="<?php echo $policy_list->peramountpo->headerCellClass() ?>"><div id="elh_policy_peramountpo" class="policy_peramountpo"><div class="ew-table-header-caption"><?php echo $policy_list->peramountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="peramountpo" class="<?php echo $policy_list->peramountpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policy_list->SortUrl($policy_list->peramountpo) ?>', 1);"><div id="elh_policy_peramountpo" class="policy_peramountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policy_list->peramountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policy_list->peramountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policy_list->peramountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$policy_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($policy_list->ExportAll && $policy_list->isExport()) {
	$policy_list->StopRecord = $policy_list->TotalRecords;
} else {

	// Set the last record to display
	if ($policy_list->TotalRecords > $policy_list->StartRecord + $policy_list->DisplayRecords - 1)
		$policy_list->StopRecord = $policy_list->StartRecord + $policy_list->DisplayRecords - 1;
	else
		$policy_list->StopRecord = $policy_list->TotalRecords;
}
$policy_list->RecordCount = $policy_list->StartRecord - 1;
if ($policy_list->Recordset && !$policy_list->Recordset->EOF) {
	$policy_list->Recordset->moveFirst();
	$selectLimit = $policy_list->UseSelectLimit;
	if (!$selectLimit && $policy_list->StartRecord > 1)
		$policy_list->Recordset->move($policy_list->StartRecord - 1);
} elseif (!$policy->AllowAddDeleteRow && $policy_list->StopRecord == 0) {
	$policy_list->StopRecord = $policy->GridAddRowCount;
}

// Initialize aggregate
$policy->RowType = ROWTYPE_AGGREGATEINIT;
$policy->resetAttributes();
$policy_list->renderRow();
while ($policy_list->RecordCount < $policy_list->StopRecord) {
	$policy_list->RecordCount++;
	if ($policy_list->RecordCount >= $policy_list->StartRecord) {
		$policy_list->RowCount++;

		// Set up key count
		$policy_list->KeyCount = $policy_list->RowIndex;

		// Init row class and style
		$policy->resetAttributes();
		$policy->CssClass = "";
		if ($policy_list->isGridAdd()) {
		} else {
			$policy_list->loadRowValues($policy_list->Recordset); // Load row values
		}
		$policy->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$policy->RowAttrs->merge(["data-rowindex" => $policy_list->RowCount, "id" => "r" . $policy_list->RowCount . "_policy", "data-rowtype" => $policy->RowType]);

		// Render row
		$policy_list->renderRow();

		// Render list options
		$policy_list->renderListOptions();
?>
	<tr <?php echo $policy->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policy_list->ListOptions->render("body", "left", $policy_list->RowCount);
?>
	<?php if ($policy_list->idpo->Visible) { // idpo ?>
		<td data-name="idpo" <?php echo $policy_list->idpo->cellAttributes() ?>>
<span id="el<?php echo $policy_list->RowCount ?>_policy_idpo">
<span<?php echo $policy_list->idpo->viewAttributes() ?>><?php echo $policy_list->idpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policy_list->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo" <?php echo $policy_list->titlepo->cellAttributes() ?>>
<span id="el<?php echo $policy_list->RowCount ?>_policy_titlepo">
<span<?php echo $policy_list->titlepo->viewAttributes() ?>><?php echo $policy_list->titlepo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policy_list->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo" <?php echo $policy_list->amountpo->cellAttributes() ?>>
<span id="el<?php echo $policy_list->RowCount ?>_policy_amountpo">
<span<?php echo $policy_list->amountpo->viewAttributes() ?>><?php echo $policy_list->amountpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policy_list->per->Visible) { // per ?>
		<td data-name="per" <?php echo $policy_list->per->cellAttributes() ?>>
<span id="el<?php echo $policy_list->RowCount ?>_policy_per">
<span<?php echo $policy_list->per->viewAttributes() ?>><?php echo $policy_list->per->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policy_list->typepo->Visible) { // typepo ?>
		<td data-name="typepo" <?php echo $policy_list->typepo->cellAttributes() ?>>
<span id="el<?php echo $policy_list->RowCount ?>_policy_typepo">
<span<?php echo $policy_list->typepo->viewAttributes() ?>><?php echo $policy_list->typepo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policy_list->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo" <?php echo $policy_list->peramountpo->cellAttributes() ?>>
<span id="el<?php echo $policy_list->RowCount ?>_policy_peramountpo">
<span<?php echo $policy_list->peramountpo->viewAttributes() ?>><?php echo $policy_list->peramountpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policy_list->ListOptions->render("body", "right", $policy_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$policy_list->isGridAdd())
		$policy_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$policy->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($policy_list->Recordset)
	$policy_list->Recordset->Close();
?>
<?php if (!$policy_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$policy_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policy_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $policy_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($policy_list->TotalRecords == 0 && !$policy->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $policy_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$policy_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$policy_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$policy_list->terminate();
?>