<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policyemp_view = new policyemp_view();

// Run the page
$policyemp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policyemp_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$policyemp_view->isExport()) { ?>
<script>
var fpolicyempview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fpolicyempview = currentForm = new ew.Form("fpolicyempview", "view");
	loadjs.done("fpolicyempview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$policyemp_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $policyemp_view->ExportOptions->render("body") ?>
<?php $policyemp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $policyemp_view->showPageHeader(); ?>
<?php
$policyemp_view->showMessage();
?>
<?php if (!$policyemp_view->IsModal) { ?>
<?php if (!$policyemp_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policyemp_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fpolicyempview" id="fpolicyempview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policyemp">
<input type="hidden" name="modal" value="<?php echo (int)$policyemp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($policyemp_view->idpe->Visible) { // idpe ?>
	<tr id="r_idpe">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_idpe"><?php echo $policyemp_view->idpe->caption() ?></span></td>
		<td data-name="idpe" <?php echo $policyemp_view->idpe->cellAttributes() ?>>
<span id="el_policyemp_idpe">
<span<?php echo $policyemp_view->idpe->viewAttributes() ?>><?php echo $policyemp_view->idpe->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_idemp"><?php echo $policyemp_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $policyemp_view->idemp->cellAttributes() ?>>
<span id="el_policyemp_idemp">
<span<?php echo $policyemp_view->idemp->viewAttributes() ?>><?php echo $policyemp_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->idpo->Visible) { // idpo ?>
	<tr id="r_idpo">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_idpo"><?php echo $policyemp_view->idpo->caption() ?></span></td>
		<td data-name="idpo" <?php echo $policyemp_view->idpo->cellAttributes() ?>>
<span id="el_policyemp_idpo">
<span<?php echo $policyemp_view->idpo->viewAttributes() ?>><?php echo $policyemp_view->idpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->titlepo->Visible) { // titlepo ?>
	<tr id="r_titlepo">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_titlepo"><?php echo $policyemp_view->titlepo->caption() ?></span></td>
		<td data-name="titlepo" <?php echo $policyemp_view->titlepo->cellAttributes() ?>>
<span id="el_policyemp_titlepo">
<span<?php echo $policyemp_view->titlepo->viewAttributes() ?>><?php echo $policyemp_view->titlepo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->amountpo->Visible) { // amountpo ?>
	<tr id="r_amountpo">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_amountpo"><?php echo $policyemp_view->amountpo->caption() ?></span></td>
		<td data-name="amountpo" <?php echo $policyemp_view->amountpo->cellAttributes() ?>>
<span id="el_policyemp_amountpo">
<span<?php echo $policyemp_view->amountpo->viewAttributes() ?>><?php echo $policyemp_view->amountpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->per->Visible) { // per ?>
	<tr id="r_per">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_per"><?php echo $policyemp_view->per->caption() ?></span></td>
		<td data-name="per" <?php echo $policyemp_view->per->cellAttributes() ?>>
<span id="el_policyemp_per">
<span<?php echo $policyemp_view->per->viewAttributes() ?>><?php echo $policyemp_view->per->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->typepo->Visible) { // typepo ?>
	<tr id="r_typepo">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_typepo"><?php echo $policyemp_view->typepo->caption() ?></span></td>
		<td data-name="typepo" <?php echo $policyemp_view->typepo->cellAttributes() ?>>
<span id="el_policyemp_typepo">
<span<?php echo $policyemp_view->typepo->viewAttributes() ?>><?php echo $policyemp_view->typepo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policyemp_view->peramountpo->Visible) { // peramountpo ?>
	<tr id="r_peramountpo">
		<td class="<?php echo $policyemp_view->TableLeftColumnClass ?>"><span id="elh_policyemp_peramountpo"><?php echo $policyemp_view->peramountpo->caption() ?></span></td>
		<td data-name="peramountpo" <?php echo $policyemp_view->peramountpo->cellAttributes() ?>>
<span id="el_policyemp_peramountpo">
<span<?php echo $policyemp_view->peramountpo->viewAttributes() ?>><?php echo $policyemp_view->peramountpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$policyemp_view->IsModal) { ?>
<?php if (!$policyemp_view->isExport()) { ?>
<?php echo $policyemp_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$policyemp_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$policyemp_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$policyemp_view->terminate();
?>