<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policyemp_list = new policyemp_list();

// Run the page
$policyemp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policyemp_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$policyemp_list->isExport()) { ?>
<script>
var fpolicyemplist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fpolicyemplist = currentForm = new ew.Form("fpolicyemplist", "list");
	fpolicyemplist.formKeyCountName = '<?php echo $policyemp_list->FormKeyCountName ?>';
	loadjs.done("fpolicyemplist");
});
var fpolicyemplistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fpolicyemplistsrch = currentSearchForm = new ew.Form("fpolicyemplistsrch");

	// Dynamic selection lists
	// Filters

	fpolicyemplistsrch.filterList = <?php echo $policyemp_list->getFilterList() ?>;
	loadjs.done("fpolicyemplistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$policyemp_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($policyemp_list->TotalRecords > 0 && $policyemp_list->ExportOptions->visible()) { ?>
<?php $policyemp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($policyemp_list->ImportOptions->visible()) { ?>
<?php $policyemp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($policyemp_list->SearchOptions->visible()) { ?>
<?php $policyemp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($policyemp_list->FilterOptions->visible()) { ?>
<?php $policyemp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$policyemp_list->isExport() || Config("EXPORT_MASTER_RECORD") && $policyemp_list->isExport("print")) { ?>
<?php
if ($policyemp_list->DbMasterFilter != "" && $policyemp->getCurrentMasterTable() == "employee") {
	if ($policyemp_list->MasterRecordExists) {
		include_once "employeemaster.php";
	}
}
?>
<?php } ?>
<?php
$policyemp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$policyemp_list->isExport() && !$policyemp->CurrentAction) { ?>
<form name="fpolicyemplistsrch" id="fpolicyemplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fpolicyemplistsrch-search-panel" class="<?php echo $policyemp_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="policyemp">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $policyemp_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($policyemp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($policyemp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $policyemp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($policyemp_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($policyemp_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($policyemp_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($policyemp_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $policyemp_list->showPageHeader(); ?>
<?php
$policyemp_list->showMessage();
?>
<?php if ($policyemp_list->TotalRecords > 0 || $policyemp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($policyemp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> policyemp">
<?php if (!$policyemp_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$policyemp_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policyemp_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $policyemp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpolicyemplist" id="fpolicyemplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policyemp">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($policyemp->getCurrentMasterTable() == "employee" && $policyemp->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employee">
<input type="hidden" name="fk_idemp" value="<?php echo HtmlEncode($policyemp_list->idemp->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_policyemp" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($policyemp_list->TotalRecords > 0 || $policyemp_list->isGridEdit()) { ?>
<table id="tbl_policyemplist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$policyemp->RowType = ROWTYPE_HEADER;

// Render list options
$policyemp_list->renderListOptions();

// Render list options (header, left)
$policyemp_list->ListOptions->render("header", "left");
?>
<?php if ($policyemp_list->idpe->Visible) { // idpe ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->idpe) == "") { ?>
		<th data-name="idpe" class="<?php echo $policyemp_list->idpe->headerCellClass() ?>"><div id="elh_policyemp_idpe" class="policyemp_idpe"><div class="ew-table-header-caption"><?php echo $policyemp_list->idpe->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpe" class="<?php echo $policyemp_list->idpe->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->idpe) ?>', 1);"><div id="elh_policyemp_idpe" class="policyemp_idpe">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->idpe->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->idpe->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->idpe->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->idemp->Visible) { // idemp ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $policyemp_list->idemp->headerCellClass() ?>"><div id="elh_policyemp_idemp" class="policyemp_idemp"><div class="ew-table-header-caption"><?php echo $policyemp_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $policyemp_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->idemp) ?>', 1);"><div id="elh_policyemp_idemp" class="policyemp_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->idpo->Visible) { // idpo ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->idpo) == "") { ?>
		<th data-name="idpo" class="<?php echo $policyemp_list->idpo->headerCellClass() ?>"><div id="elh_policyemp_idpo" class="policyemp_idpo"><div class="ew-table-header-caption"><?php echo $policyemp_list->idpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpo" class="<?php echo $policyemp_list->idpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->idpo) ?>', 1);"><div id="elh_policyemp_idpo" class="policyemp_idpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->idpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->idpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->idpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->titlepo->Visible) { // titlepo ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->titlepo) == "") { ?>
		<th data-name="titlepo" class="<?php echo $policyemp_list->titlepo->headerCellClass() ?>"><div id="elh_policyemp_titlepo" class="policyemp_titlepo"><div class="ew-table-header-caption"><?php echo $policyemp_list->titlepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titlepo" class="<?php echo $policyemp_list->titlepo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->titlepo) ?>', 1);"><div id="elh_policyemp_titlepo" class="policyemp_titlepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->titlepo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->titlepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->titlepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->amountpo->Visible) { // amountpo ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->amountpo) == "") { ?>
		<th data-name="amountpo" class="<?php echo $policyemp_list->amountpo->headerCellClass() ?>"><div id="elh_policyemp_amountpo" class="policyemp_amountpo"><div class="ew-table-header-caption"><?php echo $policyemp_list->amountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amountpo" class="<?php echo $policyemp_list->amountpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->amountpo) ?>', 1);"><div id="elh_policyemp_amountpo" class="policyemp_amountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->amountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->amountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->amountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->per->Visible) { // per ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->per) == "") { ?>
		<th data-name="per" class="<?php echo $policyemp_list->per->headerCellClass() ?>"><div id="elh_policyemp_per" class="policyemp_per"><div class="ew-table-header-caption"><?php echo $policyemp_list->per->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per" class="<?php echo $policyemp_list->per->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->per) ?>', 1);"><div id="elh_policyemp_per" class="policyemp_per">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->per->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->per->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->per->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->typepo->Visible) { // typepo ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->typepo) == "") { ?>
		<th data-name="typepo" class="<?php echo $policyemp_list->typepo->headerCellClass() ?>"><div id="elh_policyemp_typepo" class="policyemp_typepo"><div class="ew-table-header-caption"><?php echo $policyemp_list->typepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="typepo" class="<?php echo $policyemp_list->typepo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->typepo) ?>', 1);"><div id="elh_policyemp_typepo" class="policyemp_typepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->typepo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->typepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->typepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_list->peramountpo->Visible) { // peramountpo ?>
	<?php if ($policyemp_list->SortUrl($policyemp_list->peramountpo) == "") { ?>
		<th data-name="peramountpo" class="<?php echo $policyemp_list->peramountpo->headerCellClass() ?>"><div id="elh_policyemp_peramountpo" class="policyemp_peramountpo"><div class="ew-table-header-caption"><?php echo $policyemp_list->peramountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="peramountpo" class="<?php echo $policyemp_list->peramountpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policyemp_list->SortUrl($policyemp_list->peramountpo) ?>', 1);"><div id="elh_policyemp_peramountpo" class="policyemp_peramountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_list->peramountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_list->peramountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_list->peramountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$policyemp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($policyemp_list->ExportAll && $policyemp_list->isExport()) {
	$policyemp_list->StopRecord = $policyemp_list->TotalRecords;
} else {

	// Set the last record to display
	if ($policyemp_list->TotalRecords > $policyemp_list->StartRecord + $policyemp_list->DisplayRecords - 1)
		$policyemp_list->StopRecord = $policyemp_list->StartRecord + $policyemp_list->DisplayRecords - 1;
	else
		$policyemp_list->StopRecord = $policyemp_list->TotalRecords;
}
$policyemp_list->RecordCount = $policyemp_list->StartRecord - 1;
if ($policyemp_list->Recordset && !$policyemp_list->Recordset->EOF) {
	$policyemp_list->Recordset->moveFirst();
	$selectLimit = $policyemp_list->UseSelectLimit;
	if (!$selectLimit && $policyemp_list->StartRecord > 1)
		$policyemp_list->Recordset->move($policyemp_list->StartRecord - 1);
} elseif (!$policyemp->AllowAddDeleteRow && $policyemp_list->StopRecord == 0) {
	$policyemp_list->StopRecord = $policyemp->GridAddRowCount;
}

// Initialize aggregate
$policyemp->RowType = ROWTYPE_AGGREGATEINIT;
$policyemp->resetAttributes();
$policyemp_list->renderRow();
while ($policyemp_list->RecordCount < $policyemp_list->StopRecord) {
	$policyemp_list->RecordCount++;
	if ($policyemp_list->RecordCount >= $policyemp_list->StartRecord) {
		$policyemp_list->RowCount++;

		// Set up key count
		$policyemp_list->KeyCount = $policyemp_list->RowIndex;

		// Init row class and style
		$policyemp->resetAttributes();
		$policyemp->CssClass = "";
		if ($policyemp_list->isGridAdd()) {
		} else {
			$policyemp_list->loadRowValues($policyemp_list->Recordset); // Load row values
		}
		$policyemp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$policyemp->RowAttrs->merge(["data-rowindex" => $policyemp_list->RowCount, "id" => "r" . $policyemp_list->RowCount . "_policyemp", "data-rowtype" => $policyemp->RowType]);

		// Render row
		$policyemp_list->renderRow();

		// Render list options
		$policyemp_list->renderListOptions();
?>
	<tr <?php echo $policyemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policyemp_list->ListOptions->render("body", "left", $policyemp_list->RowCount);
?>
	<?php if ($policyemp_list->idpe->Visible) { // idpe ?>
		<td data-name="idpe" <?php echo $policyemp_list->idpe->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_idpe">
<span<?php echo $policyemp_list->idpe->viewAttributes() ?>><?php echo $policyemp_list->idpe->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $policyemp_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_idemp">
<span<?php echo $policyemp_list->idemp->viewAttributes() ?>><?php echo $policyemp_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->idpo->Visible) { // idpo ?>
		<td data-name="idpo" <?php echo $policyemp_list->idpo->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_idpo">
<span<?php echo $policyemp_list->idpo->viewAttributes() ?>><?php echo $policyemp_list->idpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo" <?php echo $policyemp_list->titlepo->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_titlepo">
<span<?php echo $policyemp_list->titlepo->viewAttributes() ?>><?php echo $policyemp_list->titlepo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo" <?php echo $policyemp_list->amountpo->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_amountpo">
<span<?php echo $policyemp_list->amountpo->viewAttributes() ?>><?php echo $policyemp_list->amountpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->per->Visible) { // per ?>
		<td data-name="per" <?php echo $policyemp_list->per->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_per">
<span<?php echo $policyemp_list->per->viewAttributes() ?>><?php echo $policyemp_list->per->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->typepo->Visible) { // typepo ?>
		<td data-name="typepo" <?php echo $policyemp_list->typepo->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_typepo">
<span<?php echo $policyemp_list->typepo->viewAttributes() ?>><?php echo $policyemp_list->typepo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policyemp_list->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo" <?php echo $policyemp_list->peramountpo->cellAttributes() ?>>
<span id="el<?php echo $policyemp_list->RowCount ?>_policyemp_peramountpo">
<span<?php echo $policyemp_list->peramountpo->viewAttributes() ?>><?php echo $policyemp_list->peramountpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policyemp_list->ListOptions->render("body", "right", $policyemp_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$policyemp_list->isGridAdd())
		$policyemp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$policyemp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($policyemp_list->Recordset)
	$policyemp_list->Recordset->Close();
?>
<?php if (!$policyemp_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$policyemp_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policyemp_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $policyemp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($policyemp_list->TotalRecords == 0 && !$policyemp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $policyemp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$policyemp_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$policyemp_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$policyemp_list->terminate();
?>