<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($policyemp_grid))
	$policyemp_grid = new policyemp_grid();

// Run the page
$policyemp_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policyemp_grid->Page_Render();
?>
<?php if (!$policyemp_grid->isExport()) { ?>
<script>
var fpolicyempgrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fpolicyempgrid = new ew.Form("fpolicyempgrid", "grid");
	fpolicyempgrid.formKeyCountName = '<?php echo $policyemp_grid->FormKeyCountName ?>';

	// Validate form
	fpolicyempgrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($policyemp_grid->idpe->Required) { ?>
				elm = this.getElements("x" + infix + "_idpe");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->idpe->caption(), $policyemp_grid->idpe->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_grid->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->idemp->caption(), $policyemp_grid->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_grid->idpo->Required) { ?>
				elm = this.getElements("x" + infix + "_idpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->idpo->caption(), $policyemp_grid->idpo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_grid->titlepo->Required) { ?>
				elm = this.getElements("x" + infix + "_titlepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->titlepo->caption(), $policyemp_grid->titlepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_grid->amountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->amountpo->caption(), $policyemp_grid->amountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policyemp_grid->amountpo->errorMessage()) ?>");
			<?php if ($policyemp_grid->per->Required) { ?>
				elm = this.getElements("x" + infix + "_per");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->per->caption(), $policyemp_grid->per->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_grid->typepo->Required) { ?>
				elm = this.getElements("x" + infix + "_typepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->typepo->caption(), $policyemp_grid->typepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_grid->peramountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_grid->peramountpo->caption(), $policyemp_grid->peramountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policyemp_grid->peramountpo->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fpolicyempgrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "idpo", false)) return false;
		if (ew.valueChanged(fobj, infix, "titlepo", false)) return false;
		if (ew.valueChanged(fobj, infix, "amountpo", false)) return false;
		if (ew.valueChanged(fobj, infix, "per", false)) return false;
		if (ew.valueChanged(fobj, infix, "typepo", false)) return false;
		if (ew.valueChanged(fobj, infix, "peramountpo", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fpolicyempgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpolicyempgrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpolicyempgrid.lists["x_idemp"] = <?php echo $policyemp_grid->idemp->Lookup->toClientList($policyemp_grid) ?>;
	fpolicyempgrid.lists["x_idemp"].options = <?php echo JsonEncode($policyemp_grid->idemp->lookupOptions()) ?>;
	fpolicyempgrid.lists["x_idpo"] = <?php echo $policyemp_grid->idpo->Lookup->toClientList($policyemp_grid) ?>;
	fpolicyempgrid.lists["x_idpo"].options = <?php echo JsonEncode($policyemp_grid->idpo->lookupOptions()) ?>;
	fpolicyempgrid.lists["x_per"] = <?php echo $policyemp_grid->per->Lookup->toClientList($policyemp_grid) ?>;
	fpolicyempgrid.lists["x_per"].options = <?php echo JsonEncode($policyemp_grid->per->options(FALSE, TRUE)) ?>;
	fpolicyempgrid.lists["x_typepo"] = <?php echo $policyemp_grid->typepo->Lookup->toClientList($policyemp_grid) ?>;
	fpolicyempgrid.lists["x_typepo"].options = <?php echo JsonEncode($policyemp_grid->typepo->options(FALSE, TRUE)) ?>;
	loadjs.done("fpolicyempgrid");
});
</script>
<?php } ?>
<?php
$policyemp_grid->renderOtherOptions();
?>
<?php if ($policyemp_grid->TotalRecords > 0 || $policyemp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($policyemp_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> policyemp">
<?php if ($policyemp_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $policyemp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fpolicyempgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_policyemp" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_policyempgrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$policyemp->RowType = ROWTYPE_HEADER;

// Render list options
$policyemp_grid->renderListOptions();

// Render list options (header, left)
$policyemp_grid->ListOptions->render("header", "left");
?>
<?php if ($policyemp_grid->idpe->Visible) { // idpe ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->idpe) == "") { ?>
		<th data-name="idpe" class="<?php echo $policyemp_grid->idpe->headerCellClass() ?>"><div id="elh_policyemp_idpe" class="policyemp_idpe"><div class="ew-table-header-caption"><?php echo $policyemp_grid->idpe->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpe" class="<?php echo $policyemp_grid->idpe->headerCellClass() ?>"><div><div id="elh_policyemp_idpe" class="policyemp_idpe">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->idpe->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->idpe->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->idpe->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->idemp->Visible) { // idemp ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $policyemp_grid->idemp->headerCellClass() ?>"><div id="elh_policyemp_idemp" class="policyemp_idemp"><div class="ew-table-header-caption"><?php echo $policyemp_grid->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $policyemp_grid->idemp->headerCellClass() ?>"><div><div id="elh_policyemp_idemp" class="policyemp_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->idpo->Visible) { // idpo ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->idpo) == "") { ?>
		<th data-name="idpo" class="<?php echo $policyemp_grid->idpo->headerCellClass() ?>"><div id="elh_policyemp_idpo" class="policyemp_idpo"><div class="ew-table-header-caption"><?php echo $policyemp_grid->idpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpo" class="<?php echo $policyemp_grid->idpo->headerCellClass() ?>"><div><div id="elh_policyemp_idpo" class="policyemp_idpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->idpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->idpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->idpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->titlepo->Visible) { // titlepo ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->titlepo) == "") { ?>
		<th data-name="titlepo" class="<?php echo $policyemp_grid->titlepo->headerCellClass() ?>"><div id="elh_policyemp_titlepo" class="policyemp_titlepo"><div class="ew-table-header-caption"><?php echo $policyemp_grid->titlepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titlepo" class="<?php echo $policyemp_grid->titlepo->headerCellClass() ?>"><div><div id="elh_policyemp_titlepo" class="policyemp_titlepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->titlepo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->titlepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->titlepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->amountpo->Visible) { // amountpo ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->amountpo) == "") { ?>
		<th data-name="amountpo" class="<?php echo $policyemp_grid->amountpo->headerCellClass() ?>"><div id="elh_policyemp_amountpo" class="policyemp_amountpo"><div class="ew-table-header-caption"><?php echo $policyemp_grid->amountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amountpo" class="<?php echo $policyemp_grid->amountpo->headerCellClass() ?>"><div><div id="elh_policyemp_amountpo" class="policyemp_amountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->amountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->amountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->amountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->per->Visible) { // per ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->per) == "") { ?>
		<th data-name="per" class="<?php echo $policyemp_grid->per->headerCellClass() ?>"><div id="elh_policyemp_per" class="policyemp_per"><div class="ew-table-header-caption"><?php echo $policyemp_grid->per->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per" class="<?php echo $policyemp_grid->per->headerCellClass() ?>"><div><div id="elh_policyemp_per" class="policyemp_per">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->per->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->per->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->per->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->typepo->Visible) { // typepo ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->typepo) == "") { ?>
		<th data-name="typepo" class="<?php echo $policyemp_grid->typepo->headerCellClass() ?>"><div id="elh_policyemp_typepo" class="policyemp_typepo"><div class="ew-table-header-caption"><?php echo $policyemp_grid->typepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="typepo" class="<?php echo $policyemp_grid->typepo->headerCellClass() ?>"><div><div id="elh_policyemp_typepo" class="policyemp_typepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->typepo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->typepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->typepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policyemp_grid->peramountpo->Visible) { // peramountpo ?>
	<?php if ($policyemp_grid->SortUrl($policyemp_grid->peramountpo) == "") { ?>
		<th data-name="peramountpo" class="<?php echo $policyemp_grid->peramountpo->headerCellClass() ?>"><div id="elh_policyemp_peramountpo" class="policyemp_peramountpo"><div class="ew-table-header-caption"><?php echo $policyemp_grid->peramountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="peramountpo" class="<?php echo $policyemp_grid->peramountpo->headerCellClass() ?>"><div><div id="elh_policyemp_peramountpo" class="policyemp_peramountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policyemp_grid->peramountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policyemp_grid->peramountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policyemp_grid->peramountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$policyemp_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$policyemp_grid->StartRecord = 1;
$policyemp_grid->StopRecord = $policyemp_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($policyemp->isConfirm() || $policyemp_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($policyemp_grid->FormKeyCountName) && ($policyemp_grid->isGridAdd() || $policyemp_grid->isGridEdit() || $policyemp->isConfirm())) {
		$policyemp_grid->KeyCount = $CurrentForm->getValue($policyemp_grid->FormKeyCountName);
		$policyemp_grid->StopRecord = $policyemp_grid->StartRecord + $policyemp_grid->KeyCount - 1;
	}
}
$policyemp_grid->RecordCount = $policyemp_grid->StartRecord - 1;
if ($policyemp_grid->Recordset && !$policyemp_grid->Recordset->EOF) {
	$policyemp_grid->Recordset->moveFirst();
	$selectLimit = $policyemp_grid->UseSelectLimit;
	if (!$selectLimit && $policyemp_grid->StartRecord > 1)
		$policyemp_grid->Recordset->move($policyemp_grid->StartRecord - 1);
} elseif (!$policyemp->AllowAddDeleteRow && $policyemp_grid->StopRecord == 0) {
	$policyemp_grid->StopRecord = $policyemp->GridAddRowCount;
}

// Initialize aggregate
$policyemp->RowType = ROWTYPE_AGGREGATEINIT;
$policyemp->resetAttributes();
$policyemp_grid->renderRow();
if ($policyemp_grid->isGridAdd())
	$policyemp_grid->RowIndex = 0;
if ($policyemp_grid->isGridEdit())
	$policyemp_grid->RowIndex = 0;
while ($policyemp_grid->RecordCount < $policyemp_grid->StopRecord) {
	$policyemp_grid->RecordCount++;
	if ($policyemp_grid->RecordCount >= $policyemp_grid->StartRecord) {
		$policyemp_grid->RowCount++;
		if ($policyemp_grid->isGridAdd() || $policyemp_grid->isGridEdit() || $policyemp->isConfirm()) {
			$policyemp_grid->RowIndex++;
			$CurrentForm->Index = $policyemp_grid->RowIndex;
			if ($CurrentForm->hasValue($policyemp_grid->FormActionName) && ($policyemp->isConfirm() || $policyemp_grid->EventCancelled))
				$policyemp_grid->RowAction = strval($CurrentForm->getValue($policyemp_grid->FormActionName));
			elseif ($policyemp_grid->isGridAdd())
				$policyemp_grid->RowAction = "insert";
			else
				$policyemp_grid->RowAction = "";
		}

		// Set up key count
		$policyemp_grid->KeyCount = $policyemp_grid->RowIndex;

		// Init row class and style
		$policyemp->resetAttributes();
		$policyemp->CssClass = "";
		if ($policyemp_grid->isGridAdd()) {
			if ($policyemp->CurrentMode == "copy") {
				$policyemp_grid->loadRowValues($policyemp_grid->Recordset); // Load row values
				$policyemp_grid->setRecordKey($policyemp_grid->RowOldKey, $policyemp_grid->Recordset); // Set old record key
			} else {
				$policyemp_grid->loadRowValues(); // Load default values
				$policyemp_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$policyemp_grid->loadRowValues($policyemp_grid->Recordset); // Load row values
		}
		$policyemp->RowType = ROWTYPE_VIEW; // Render view
		if ($policyemp_grid->isGridAdd()) // Grid add
			$policyemp->RowType = ROWTYPE_ADD; // Render add
		if ($policyemp_grid->isGridAdd() && $policyemp->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$policyemp_grid->restoreCurrentRowFormValues($policyemp_grid->RowIndex); // Restore form values
		if ($policyemp_grid->isGridEdit()) { // Grid edit
			if ($policyemp->EventCancelled)
				$policyemp_grid->restoreCurrentRowFormValues($policyemp_grid->RowIndex); // Restore form values
			if ($policyemp_grid->RowAction == "insert")
				$policyemp->RowType = ROWTYPE_ADD; // Render add
			else
				$policyemp->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($policyemp_grid->isGridEdit() && ($policyemp->RowType == ROWTYPE_EDIT || $policyemp->RowType == ROWTYPE_ADD) && $policyemp->EventCancelled) // Update failed
			$policyemp_grid->restoreCurrentRowFormValues($policyemp_grid->RowIndex); // Restore form values
		if ($policyemp->RowType == ROWTYPE_EDIT) // Edit row
			$policyemp_grid->EditRowCount++;
		if ($policyemp->isConfirm()) // Confirm row
			$policyemp_grid->restoreCurrentRowFormValues($policyemp_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$policyemp->RowAttrs->merge(["data-rowindex" => $policyemp_grid->RowCount, "id" => "r" . $policyemp_grid->RowCount . "_policyemp", "data-rowtype" => $policyemp->RowType]);

		// Render row
		$policyemp_grid->renderRow();

		// Render list options
		$policyemp_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($policyemp_grid->RowAction != "delete" && $policyemp_grid->RowAction != "insertdelete" && !($policyemp_grid->RowAction == "insert" && $policyemp->isConfirm() && $policyemp_grid->emptyRow())) {
?>
	<tr <?php echo $policyemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policyemp_grid->ListOptions->render("body", "left", $policyemp_grid->RowCount);
?>
	<?php if ($policyemp_grid->idpe->Visible) { // idpe ?>
		<td data-name="idpe" <?php echo $policyemp_grid->idpe->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idpe" class="form-group"></span>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="o<?php echo $policyemp_grid->RowIndex ?>_idpe" id="o<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idpe" class="form-group">
<span<?php echo $policyemp_grid->idpe->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idpe->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="x<?php echo $policyemp_grid->RowIndex ?>_idpe" id="x<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->CurrentValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idpe">
<span<?php echo $policyemp_grid->idpe->viewAttributes() ?>><?php echo $policyemp_grid->idpe->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="x<?php echo $policyemp_grid->RowIndex ?>_idpe" id="x<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="o<?php echo $policyemp_grid->RowIndex ?>_idpe" id="o<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_idpe" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_idpe" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $policyemp_grid->idemp->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($policyemp_grid->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idemp" class="form-group">
<span<?php echo $policyemp_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idemp" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policyemp_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($policyemp_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_grid->idemp->ReadOnly || $policyemp_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policyemp_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_grid->idemp->Lookup->getParamTag($policyemp_grid, "p_x" . $policyemp_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo $policyemp_grid->idemp->CurrentValue ?>"<?php echo $policyemp_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="o<?php echo $policyemp_grid->RowIndex ?>_idemp" id="o<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($policyemp_grid->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idemp" class="form-group">
<span<?php echo $policyemp_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idemp" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policyemp_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($policyemp_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_grid->idemp->ReadOnly || $policyemp_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policyemp_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_grid->idemp->Lookup->getParamTag($policyemp_grid, "p_x" . $policyemp_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo $policyemp_grid->idemp->CurrentValue ?>"<?php echo $policyemp_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idemp">
<span<?php echo $policyemp_grid->idemp->viewAttributes() ?>><?php echo $policyemp_grid->idemp->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="o<?php echo $policyemp_grid->RowIndex ?>_idemp" id="o<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_idemp" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_idemp" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->idpo->Visible) { // idpo ?>
		<td data-name="idpo" <?php echo $policyemp_grid->idpo->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idpo" class="form-group">
<?php $policyemp_grid->idpo->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policyemp_grid->RowIndex ?>_idpo"><?php echo EmptyValue(strval($policyemp_grid->idpo->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_grid->idpo->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_grid->idpo->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_grid->idpo->ReadOnly || $policyemp_grid->idpo->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policyemp_grid->RowIndex ?>_idpo',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_grid->idpo->Lookup->getParamTag($policyemp_grid, "p_x" . $policyemp_grid->RowIndex . "_idpo") ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_grid->idpo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_idpo" id="x<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo $policyemp_grid->idpo->CurrentValue ?>"<?php echo $policyemp_grid->idpo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="o<?php echo $policyemp_grid->RowIndex ?>_idpo" id="o<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idpo" class="form-group">
<?php $policyemp_grid->idpo->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policyemp_grid->RowIndex ?>_idpo"><?php echo EmptyValue(strval($policyemp_grid->idpo->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_grid->idpo->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_grid->idpo->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_grid->idpo->ReadOnly || $policyemp_grid->idpo->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policyemp_grid->RowIndex ?>_idpo',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_grid->idpo->Lookup->getParamTag($policyemp_grid, "p_x" . $policyemp_grid->RowIndex . "_idpo") ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_grid->idpo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_idpo" id="x<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo $policyemp_grid->idpo->CurrentValue ?>"<?php echo $policyemp_grid->idpo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_idpo">
<span<?php echo $policyemp_grid->idpo->viewAttributes() ?>><?php echo $policyemp_grid->idpo->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="x<?php echo $policyemp_grid->RowIndex ?>_idpo" id="x<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="o<?php echo $policyemp_grid->RowIndex ?>_idpo" id="o<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_idpo" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_idpo" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo" <?php echo $policyemp_grid->titlepo->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_titlepo" class="form-group">
<input type="text" data-table="policyemp" data-field="x_titlepo" name="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policyemp_grid->titlepo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->titlepo->EditValue ?>"<?php echo $policyemp_grid->titlepo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="o<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="o<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_titlepo" class="form-group">
<input type="text" data-table="policyemp" data-field="x_titlepo" name="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policyemp_grid->titlepo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->titlepo->EditValue ?>"<?php echo $policyemp_grid->titlepo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_titlepo">
<span<?php echo $policyemp_grid->titlepo->viewAttributes() ?>><?php echo $policyemp_grid->titlepo->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="o<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="o<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo" <?php echo $policyemp_grid->amountpo->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_amountpo" class="form-group">
<input type="text" data-table="policyemp" data-field="x_amountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_grid->amountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->amountpo->EditValue ?>"<?php echo $policyemp_grid->amountpo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="o<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="o<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_amountpo" class="form-group">
<input type="text" data-table="policyemp" data-field="x_amountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_grid->amountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->amountpo->EditValue ?>"<?php echo $policyemp_grid->amountpo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_amountpo">
<span<?php echo $policyemp_grid->amountpo->viewAttributes() ?>><?php echo $policyemp_grid->amountpo->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="o<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="o<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->per->Visible) { // per ?>
		<td data-name="per" <?php echo $policyemp_grid->per->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_per" class="form-group">
<div id="tp_x<?php echo $policyemp_grid->RowIndex ?>_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_per" data-value-separator="<?php echo $policyemp_grid->per->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_per" id="x<?php echo $policyemp_grid->RowIndex ?>_per" value="{value}"<?php echo $policyemp_grid->per->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policyemp_grid->RowIndex ?>_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_grid->per->radioButtonListHtml(FALSE, "x{$policyemp_grid->RowIndex}_per") ?>
</div></div>
</span>
<input type="hidden" data-table="policyemp" data-field="x_per" name="o<?php echo $policyemp_grid->RowIndex ?>_per" id="o<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_per" class="form-group">
<div id="tp_x<?php echo $policyemp_grid->RowIndex ?>_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_per" data-value-separator="<?php echo $policyemp_grid->per->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_per" id="x<?php echo $policyemp_grid->RowIndex ?>_per" value="{value}"<?php echo $policyemp_grid->per->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policyemp_grid->RowIndex ?>_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_grid->per->radioButtonListHtml(FALSE, "x{$policyemp_grid->RowIndex}_per") ?>
</div></div>
</span>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_per">
<span<?php echo $policyemp_grid->per->viewAttributes() ?>><?php echo $policyemp_grid->per->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_per" name="x<?php echo $policyemp_grid->RowIndex ?>_per" id="x<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_per" name="o<?php echo $policyemp_grid->RowIndex ?>_per" id="o<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_per" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_per" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_per" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_per" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->typepo->Visible) { // typepo ?>
		<td data-name="typepo" <?php echo $policyemp_grid->typepo->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_typepo" class="form-group">
<div id="tp_x<?php echo $policyemp_grid->RowIndex ?>_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_typepo" data-value-separator="<?php echo $policyemp_grid->typepo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_typepo" id="x<?php echo $policyemp_grid->RowIndex ?>_typepo" value="{value}"<?php echo $policyemp_grid->typepo->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policyemp_grid->RowIndex ?>_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_grid->typepo->radioButtonListHtml(FALSE, "x{$policyemp_grid->RowIndex}_typepo") ?>
</div></div>
</span>
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="o<?php echo $policyemp_grid->RowIndex ?>_typepo" id="o<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_typepo" class="form-group">
<div id="tp_x<?php echo $policyemp_grid->RowIndex ?>_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_typepo" data-value-separator="<?php echo $policyemp_grid->typepo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_typepo" id="x<?php echo $policyemp_grid->RowIndex ?>_typepo" value="{value}"<?php echo $policyemp_grid->typepo->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policyemp_grid->RowIndex ?>_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_grid->typepo->radioButtonListHtml(FALSE, "x{$policyemp_grid->RowIndex}_typepo") ?>
</div></div>
</span>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_typepo">
<span<?php echo $policyemp_grid->typepo->viewAttributes() ?>><?php echo $policyemp_grid->typepo->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="x<?php echo $policyemp_grid->RowIndex ?>_typepo" id="x<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="o<?php echo $policyemp_grid->RowIndex ?>_typepo" id="o<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_typepo" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_typepo" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policyemp_grid->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo" <?php echo $policyemp_grid->peramountpo->cellAttributes() ?>>
<?php if ($policyemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_peramountpo" class="form-group">
<input type="text" data-table="policyemp" data-field="x_peramountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_grid->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->peramountpo->EditValue ?>"<?php echo $policyemp_grid->peramountpo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->OldValue) ?>">
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_peramountpo" class="form-group">
<input type="text" data-table="policyemp" data-field="x_peramountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_grid->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->peramountpo->EditValue ?>"<?php echo $policyemp_grid->peramountpo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policyemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policyemp_grid->RowCount ?>_policyemp_peramountpo">
<span<?php echo $policyemp_grid->peramountpo->viewAttributes() ?>><?php echo $policyemp_grid->peramountpo->getViewValue() ?></span>
</span>
<?php if (!$policyemp->isConfirm()) { ?>
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="fpolicyempgrid$x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->FormValue) ?>">
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="fpolicyempgrid$o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policyemp_grid->ListOptions->render("body", "right", $policyemp_grid->RowCount);
?>
	</tr>
<?php if ($policyemp->RowType == ROWTYPE_ADD || $policyemp->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fpolicyempgrid", "load"], function() {
	fpolicyempgrid.updateLists(<?php echo $policyemp_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$policyemp_grid->isGridAdd() || $policyemp->CurrentMode == "copy")
		if (!$policyemp_grid->Recordset->EOF)
			$policyemp_grid->Recordset->moveNext();
}
?>
<?php
	if ($policyemp->CurrentMode == "add" || $policyemp->CurrentMode == "copy" || $policyemp->CurrentMode == "edit") {
		$policyemp_grid->RowIndex = '$rowindex$';
		$policyemp_grid->loadRowValues();

		// Set row properties
		$policyemp->resetAttributes();
		$policyemp->RowAttrs->merge(["data-rowindex" => $policyemp_grid->RowIndex, "id" => "r0_policyemp", "data-rowtype" => ROWTYPE_ADD]);
		$policyemp->RowAttrs->appendClass("ew-template");
		$policyemp->RowType = ROWTYPE_ADD;

		// Render row
		$policyemp_grid->renderRow();

		// Render list options
		$policyemp_grid->renderListOptions();
		$policyemp_grid->StartRowCount = 0;
?>
	<tr <?php echo $policyemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policyemp_grid->ListOptions->render("body", "left", $policyemp_grid->RowIndex);
?>
	<?php if ($policyemp_grid->idpe->Visible) { // idpe ?>
		<td data-name="idpe">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_idpe" class="form-group policyemp_idpe"></span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_idpe" class="form-group policyemp_idpe">
<span<?php echo $policyemp_grid->idpe->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idpe->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="x<?php echo $policyemp_grid->RowIndex ?>_idpe" id="x<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="o<?php echo $policyemp_grid->RowIndex ?>_idpe" id="o<?php echo $policyemp_grid->RowIndex ?>_idpe" value="<?php echo HtmlEncode($policyemp_grid->idpe->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if (!$policyemp->isConfirm()) { ?>
<?php if ($policyemp_grid->idemp->getSessionValue() != "") { ?>
<span id="el$rowindex$_policyemp_idemp" class="form-group policyemp_idemp">
<span<?php echo $policyemp_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_policyemp_idemp" class="form-group policyemp_idemp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policyemp_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($policyemp_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_grid->idemp->ReadOnly || $policyemp_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policyemp_grid->RowIndex ?>_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_grid->idemp->Lookup->getParamTag($policyemp_grid, "p_x" . $policyemp_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo $policyemp_grid->idemp->CurrentValue ?>"<?php echo $policyemp_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_policyemp_idemp" class="form-group policyemp_idemp">
<span<?php echo $policyemp_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="x<?php echo $policyemp_grid->RowIndex ?>_idemp" id="x<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" name="o<?php echo $policyemp_grid->RowIndex ?>_idemp" id="o<?php echo $policyemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($policyemp_grid->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->idpo->Visible) { // idpo ?>
		<td data-name="idpo">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_idpo" class="form-group policyemp_idpo">
<?php $policyemp_grid->idpo->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policyemp_grid->RowIndex ?>_idpo"><?php echo EmptyValue(strval($policyemp_grid->idpo->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_grid->idpo->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_grid->idpo->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_grid->idpo->ReadOnly || $policyemp_grid->idpo->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policyemp_grid->RowIndex ?>_idpo',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_grid->idpo->Lookup->getParamTag($policyemp_grid, "p_x" . $policyemp_grid->RowIndex . "_idpo") ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_grid->idpo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_idpo" id="x<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo $policyemp_grid->idpo->CurrentValue ?>"<?php echo $policyemp_grid->idpo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_idpo" class="form-group policyemp_idpo">
<span<?php echo $policyemp_grid->idpo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->idpo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="x<?php echo $policyemp_grid->RowIndex ?>_idpo" id="x<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" name="o<?php echo $policyemp_grid->RowIndex ?>_idpo" id="o<?php echo $policyemp_grid->RowIndex ?>_idpo" value="<?php echo HtmlEncode($policyemp_grid->idpo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_titlepo" class="form-group policyemp_titlepo">
<input type="text" data-table="policyemp" data-field="x_titlepo" name="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policyemp_grid->titlepo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->titlepo->EditValue ?>"<?php echo $policyemp_grid->titlepo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_titlepo" class="form-group policyemp_titlepo">
<span<?php echo $policyemp_grid->titlepo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->titlepo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="x<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_titlepo" name="o<?php echo $policyemp_grid->RowIndex ?>_titlepo" id="o<?php echo $policyemp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policyemp_grid->titlepo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_amountpo" class="form-group policyemp_amountpo">
<input type="text" data-table="policyemp" data-field="x_amountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_grid->amountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->amountpo->EditValue ?>"<?php echo $policyemp_grid->amountpo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_amountpo" class="form-group policyemp_amountpo">
<span<?php echo $policyemp_grid->amountpo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->amountpo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_amountpo" name="o<?php echo $policyemp_grid->RowIndex ?>_amountpo" id="o<?php echo $policyemp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policyemp_grid->amountpo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->per->Visible) { // per ?>
		<td data-name="per">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_per" class="form-group policyemp_per">
<div id="tp_x<?php echo $policyemp_grid->RowIndex ?>_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_per" data-value-separator="<?php echo $policyemp_grid->per->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_per" id="x<?php echo $policyemp_grid->RowIndex ?>_per" value="{value}"<?php echo $policyemp_grid->per->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policyemp_grid->RowIndex ?>_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_grid->per->radioButtonListHtml(FALSE, "x{$policyemp_grid->RowIndex}_per") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_per" class="form-group policyemp_per">
<span<?php echo $policyemp_grid->per->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->per->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_per" name="x<?php echo $policyemp_grid->RowIndex ?>_per" id="x<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_per" name="o<?php echo $policyemp_grid->RowIndex ?>_per" id="o<?php echo $policyemp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policyemp_grid->per->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->typepo->Visible) { // typepo ?>
		<td data-name="typepo">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_typepo" class="form-group policyemp_typepo">
<div id="tp_x<?php echo $policyemp_grid->RowIndex ?>_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_typepo" data-value-separator="<?php echo $policyemp_grid->typepo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policyemp_grid->RowIndex ?>_typepo" id="x<?php echo $policyemp_grid->RowIndex ?>_typepo" value="{value}"<?php echo $policyemp_grid->typepo->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policyemp_grid->RowIndex ?>_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_grid->typepo->radioButtonListHtml(FALSE, "x{$policyemp_grid->RowIndex}_typepo") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_typepo" class="form-group policyemp_typepo">
<span<?php echo $policyemp_grid->typepo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->typepo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="x<?php echo $policyemp_grid->RowIndex ?>_typepo" id="x<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_typepo" name="o<?php echo $policyemp_grid->RowIndex ?>_typepo" id="o<?php echo $policyemp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policyemp_grid->typepo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policyemp_grid->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo">
<?php if (!$policyemp->isConfirm()) { ?>
<span id="el$rowindex$_policyemp_peramountpo" class="form-group policyemp_peramountpo">
<input type="text" data-table="policyemp" data-field="x_peramountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_grid->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_grid->peramountpo->EditValue ?>"<?php echo $policyemp_grid->peramountpo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policyemp_peramountpo" class="form-group policyemp_peramountpo">
<span<?php echo $policyemp_grid->peramountpo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_grid->peramountpo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policyemp" data-field="x_peramountpo" name="o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" id="o<?php echo $policyemp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policyemp_grid->peramountpo->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policyemp_grid->ListOptions->render("body", "right", $policyemp_grid->RowIndex);
?>
<script>
loadjs.ready(["fpolicyempgrid", "load"], function() {
	fpolicyempgrid.updateLists(<?php echo $policyemp_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($policyemp->CurrentMode == "add" || $policyemp->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $policyemp_grid->FormKeyCountName ?>" id="<?php echo $policyemp_grid->FormKeyCountName ?>" value="<?php echo $policyemp_grid->KeyCount ?>">
<?php echo $policyemp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($policyemp->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $policyemp_grid->FormKeyCountName ?>" id="<?php echo $policyemp_grid->FormKeyCountName ?>" value="<?php echo $policyemp_grid->KeyCount ?>">
<?php echo $policyemp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($policyemp->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpolicyempgrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($policyemp_grid->Recordset)
	$policyemp_grid->Recordset->Close();
?>
<?php if ($policyemp_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $policyemp_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($policyemp_grid->TotalRecords == 0 && !$policyemp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $policyemp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$policyemp_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php
$policyemp_grid->terminate();
?>