<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policyemp_edit = new policyemp_edit();

// Run the page
$policyemp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policyemp_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpolicyempedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fpolicyempedit = currentForm = new ew.Form("fpolicyempedit", "edit");

	// Validate form
	fpolicyempedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($policyemp_edit->idpe->Required) { ?>
				elm = this.getElements("x" + infix + "_idpe");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->idpe->caption(), $policyemp_edit->idpe->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->idemp->caption(), $policyemp_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_edit->idpo->Required) { ?>
				elm = this.getElements("x" + infix + "_idpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->idpo->caption(), $policyemp_edit->idpo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_edit->titlepo->Required) { ?>
				elm = this.getElements("x" + infix + "_titlepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->titlepo->caption(), $policyemp_edit->titlepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_edit->amountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->amountpo->caption(), $policyemp_edit->amountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policyemp_edit->amountpo->errorMessage()) ?>");
			<?php if ($policyemp_edit->per->Required) { ?>
				elm = this.getElements("x" + infix + "_per");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->per->caption(), $policyemp_edit->per->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_edit->typepo->Required) { ?>
				elm = this.getElements("x" + infix + "_typepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->typepo->caption(), $policyemp_edit->typepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policyemp_edit->peramountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policyemp_edit->peramountpo->caption(), $policyemp_edit->peramountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policyemp_edit->peramountpo->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpolicyempedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpolicyempedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpolicyempedit.lists["x_idemp"] = <?php echo $policyemp_edit->idemp->Lookup->toClientList($policyemp_edit) ?>;
	fpolicyempedit.lists["x_idemp"].options = <?php echo JsonEncode($policyemp_edit->idemp->lookupOptions()) ?>;
	fpolicyempedit.lists["x_idpo"] = <?php echo $policyemp_edit->idpo->Lookup->toClientList($policyemp_edit) ?>;
	fpolicyempedit.lists["x_idpo"].options = <?php echo JsonEncode($policyemp_edit->idpo->lookupOptions()) ?>;
	fpolicyempedit.lists["x_per"] = <?php echo $policyemp_edit->per->Lookup->toClientList($policyemp_edit) ?>;
	fpolicyempedit.lists["x_per"].options = <?php echo JsonEncode($policyemp_edit->per->options(FALSE, TRUE)) ?>;
	fpolicyempedit.lists["x_typepo"] = <?php echo $policyemp_edit->typepo->Lookup->toClientList($policyemp_edit) ?>;
	fpolicyempedit.lists["x_typepo"].options = <?php echo JsonEncode($policyemp_edit->typepo->options(FALSE, TRUE)) ?>;
	loadjs.done("fpolicyempedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $policyemp_edit->showPageHeader(); ?>
<?php
$policyemp_edit->showMessage();
?>
<form name="fpolicyempedit" id="fpolicyempedit" class="<?php echo $policyemp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policyemp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$policyemp_edit->IsModal ?>">
<?php if ($policyemp->getCurrentMasterTable() == "employee") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employee">
<input type="hidden" name="fk_idemp" value="<?php echo HtmlEncode($policyemp_edit->idemp->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($policyemp_edit->idpe->Visible) { // idpe ?>
	<div id="r_idpe" class="form-group row">
		<label id="elh_policyemp_idpe" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->idpe->caption() ?><?php echo $policyemp_edit->idpe->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->idpe->cellAttributes() ?>>
<span id="el_policyemp_idpe">
<span<?php echo $policyemp_edit->idpe->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_edit->idpe->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="policyemp" data-field="x_idpe" name="x_idpe" id="x_idpe" value="<?php echo HtmlEncode($policyemp_edit->idpe->CurrentValue) ?>">
<?php echo $policyemp_edit->idpe->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_policyemp_idemp" for="x_idemp" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->idemp->caption() ?><?php echo $policyemp_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->idemp->cellAttributes() ?>>
<?php if ($policyemp_edit->idemp->getSessionValue() != "") { ?>
<span id="el_policyemp_idemp">
<span<?php echo $policyemp_edit->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policyemp_edit->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idemp" name="x_idemp" value="<?php echo HtmlEncode($policyemp_edit->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_policyemp_idemp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($policyemp_edit->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_edit->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_edit->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_edit->idemp->ReadOnly || $policyemp_edit->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_edit->idemp->Lookup->getParamTag($policyemp_edit, "p_x_idemp") ?>
<input type="hidden" data-table="policyemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_edit->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $policyemp_edit->idemp->CurrentValue ?>"<?php echo $policyemp_edit->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $policyemp_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->idpo->Visible) { // idpo ?>
	<div id="r_idpo" class="form-group row">
		<label id="elh_policyemp_idpo" for="x_idpo" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->idpo->caption() ?><?php echo $policyemp_edit->idpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->idpo->cellAttributes() ?>>
<span id="el_policyemp_idpo">
<?php $policyemp_edit->idpo->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idpo"><?php echo EmptyValue(strval($policyemp_edit->idpo->ViewValue)) ? $Language->phrase("PleaseSelect") : $policyemp_edit->idpo->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policyemp_edit->idpo->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policyemp_edit->idpo->ReadOnly || $policyemp_edit->idpo->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idpo',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policyemp_edit->idpo->Lookup->getParamTag($policyemp_edit, "p_x_idpo") ?>
<input type="hidden" data-table="policyemp" data-field="x_idpo" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policyemp_edit->idpo->displayValueSeparatorAttribute() ?>" name="x_idpo" id="x_idpo" value="<?php echo $policyemp_edit->idpo->CurrentValue ?>"<?php echo $policyemp_edit->idpo->editAttributes() ?>>
</span>
<?php echo $policyemp_edit->idpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->titlepo->Visible) { // titlepo ?>
	<div id="r_titlepo" class="form-group row">
		<label id="elh_policyemp_titlepo" for="x_titlepo" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->titlepo->caption() ?><?php echo $policyemp_edit->titlepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->titlepo->cellAttributes() ?>>
<span id="el_policyemp_titlepo">
<input type="text" data-table="policyemp" data-field="x_titlepo" name="x_titlepo" id="x_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policyemp_edit->titlepo->getPlaceHolder()) ?>" value="<?php echo $policyemp_edit->titlepo->EditValue ?>"<?php echo $policyemp_edit->titlepo->editAttributes() ?>>
</span>
<?php echo $policyemp_edit->titlepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->amountpo->Visible) { // amountpo ?>
	<div id="r_amountpo" class="form-group row">
		<label id="elh_policyemp_amountpo" for="x_amountpo" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->amountpo->caption() ?><?php echo $policyemp_edit->amountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->amountpo->cellAttributes() ?>>
<span id="el_policyemp_amountpo">
<input type="text" data-table="policyemp" data-field="x_amountpo" name="x_amountpo" id="x_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_edit->amountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_edit->amountpo->EditValue ?>"<?php echo $policyemp_edit->amountpo->editAttributes() ?>>
</span>
<?php echo $policyemp_edit->amountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->per->Visible) { // per ?>
	<div id="r_per" class="form-group row">
		<label id="elh_policyemp_per" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->per->caption() ?><?php echo $policyemp_edit->per->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->per->cellAttributes() ?>>
<span id="el_policyemp_per">
<div id="tp_x_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_per" data-value-separator="<?php echo $policyemp_edit->per->displayValueSeparatorAttribute() ?>" name="x_per" id="x_per" value="{value}"<?php echo $policyemp_edit->per->editAttributes() ?>></div>
<div id="dsl_x_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_edit->per->radioButtonListHtml(FALSE, "x_per") ?>
</div></div>
</span>
<?php echo $policyemp_edit->per->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->typepo->Visible) { // typepo ?>
	<div id="r_typepo" class="form-group row">
		<label id="elh_policyemp_typepo" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->typepo->caption() ?><?php echo $policyemp_edit->typepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->typepo->cellAttributes() ?>>
<span id="el_policyemp_typepo">
<div id="tp_x_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policyemp" data-field="x_typepo" data-value-separator="<?php echo $policyemp_edit->typepo->displayValueSeparatorAttribute() ?>" name="x_typepo" id="x_typepo" value="{value}"<?php echo $policyemp_edit->typepo->editAttributes() ?>></div>
<div id="dsl_x_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policyemp_edit->typepo->radioButtonListHtml(FALSE, "x_typepo") ?>
</div></div>
</span>
<?php echo $policyemp_edit->typepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policyemp_edit->peramountpo->Visible) { // peramountpo ?>
	<div id="r_peramountpo" class="form-group row">
		<label id="elh_policyemp_peramountpo" for="x_peramountpo" class="<?php echo $policyemp_edit->LeftColumnClass ?>"><?php echo $policyemp_edit->peramountpo->caption() ?><?php echo $policyemp_edit->peramountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policyemp_edit->RightColumnClass ?>"><div <?php echo $policyemp_edit->peramountpo->cellAttributes() ?>>
<span id="el_policyemp_peramountpo">
<input type="text" data-table="policyemp" data-field="x_peramountpo" name="x_peramountpo" id="x_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policyemp_edit->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policyemp_edit->peramountpo->EditValue ?>"<?php echo $policyemp_edit->peramountpo->editAttributes() ?>>
</span>
<?php echo $policyemp_edit->peramountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$policyemp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $policyemp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $policyemp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$policyemp_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$policyemp_edit->terminate();
?>