<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policydp_view = new policydp_view();

// Run the page
$policydp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policydp_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$policydp_view->isExport()) { ?>
<script>
var fpolicydpview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fpolicydpview = currentForm = new ew.Form("fpolicydpview", "view");
	loadjs.done("fpolicydpview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$policydp_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $policydp_view->ExportOptions->render("body") ?>
<?php $policydp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $policydp_view->showPageHeader(); ?>
<?php
$policydp_view->showMessage();
?>
<?php if (!$policydp_view->IsModal) { ?>
<?php if (!$policydp_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policydp_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fpolicydpview" id="fpolicydpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policydp">
<input type="hidden" name="modal" value="<?php echo (int)$policydp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($policydp_view->idpdp->Visible) { // idpdp ?>
	<tr id="r_idpdp">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_idpdp"><?php echo $policydp_view->idpdp->caption() ?></span></td>
		<td data-name="idpdp" <?php echo $policydp_view->idpdp->cellAttributes() ?>>
<span id="el_policydp_idpdp">
<span<?php echo $policydp_view->idpdp->viewAttributes() ?>><?php echo $policydp_view->idpdp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policydp_view->titlepo->Visible) { // titlepo ?>
	<tr id="r_titlepo">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_titlepo"><?php echo $policydp_view->titlepo->caption() ?></span></td>
		<td data-name="titlepo" <?php echo $policydp_view->titlepo->cellAttributes() ?>>
<span id="el_policydp_titlepo">
<span<?php echo $policydp_view->titlepo->viewAttributes() ?>><?php echo $policydp_view->titlepo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policydp_view->amountpo->Visible) { // amountpo ?>
	<tr id="r_amountpo">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_amountpo"><?php echo $policydp_view->amountpo->caption() ?></span></td>
		<td data-name="amountpo" <?php echo $policydp_view->amountpo->cellAttributes() ?>>
<span id="el_policydp_amountpo">
<span<?php echo $policydp_view->amountpo->viewAttributes() ?>><?php echo $policydp_view->amountpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policydp_view->per->Visible) { // per ?>
	<tr id="r_per">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_per"><?php echo $policydp_view->per->caption() ?></span></td>
		<td data-name="per" <?php echo $policydp_view->per->cellAttributes() ?>>
<span id="el_policydp_per">
<span<?php echo $policydp_view->per->viewAttributes() ?>><?php echo $policydp_view->per->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policydp_view->typepo->Visible) { // typepo ?>
	<tr id="r_typepo">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_typepo"><?php echo $policydp_view->typepo->caption() ?></span></td>
		<td data-name="typepo" <?php echo $policydp_view->typepo->cellAttributes() ?>>
<span id="el_policydp_typepo">
<span<?php echo $policydp_view->typepo->viewAttributes() ?>><?php echo $policydp_view->typepo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policydp_view->peramountpo->Visible) { // peramountpo ?>
	<tr id="r_peramountpo">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_peramountpo"><?php echo $policydp_view->peramountpo->caption() ?></span></td>
		<td data-name="peramountpo" <?php echo $policydp_view->peramountpo->cellAttributes() ?>>
<span id="el_policydp_peramountpo">
<span<?php echo $policydp_view->peramountpo->viewAttributes() ?>><?php echo $policydp_view->peramountpo->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($policydp_view->iddp->Visible) { // iddp ?>
	<tr id="r_iddp">
		<td class="<?php echo $policydp_view->TableLeftColumnClass ?>"><span id="elh_policydp_iddp"><?php echo $policydp_view->iddp->caption() ?></span></td>
		<td data-name="iddp" <?php echo $policydp_view->iddp->cellAttributes() ?>>
<span id="el_policydp_iddp">
<span<?php echo $policydp_view->iddp->viewAttributes() ?>><?php echo $policydp_view->iddp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$policydp_view->IsModal) { ?>
<?php if (!$policydp_view->isExport()) { ?>
<?php echo $policydp_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$policydp_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$policydp_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$policydp_view->terminate();
?>