<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policydp_list = new policydp_list();

// Run the page
$policydp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policydp_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$policydp_list->isExport()) { ?>
<script>
var fpolicydplist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fpolicydplist = currentForm = new ew.Form("fpolicydplist", "list");
	fpolicydplist.formKeyCountName = '<?php echo $policydp_list->FormKeyCountName ?>';
	loadjs.done("fpolicydplist");
});
var fpolicydplistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fpolicydplistsrch = currentSearchForm = new ew.Form("fpolicydplistsrch");

	// Dynamic selection lists
	// Filters

	fpolicydplistsrch.filterList = <?php echo $policydp_list->getFilterList() ?>;
	loadjs.done("fpolicydplistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$policydp_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($policydp_list->TotalRecords > 0 && $policydp_list->ExportOptions->visible()) { ?>
<?php $policydp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($policydp_list->ImportOptions->visible()) { ?>
<?php $policydp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($policydp_list->SearchOptions->visible()) { ?>
<?php $policydp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($policydp_list->FilterOptions->visible()) { ?>
<?php $policydp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$policydp_list->isExport() || Config("EXPORT_MASTER_RECORD") && $policydp_list->isExport("print")) { ?>
<?php
if ($policydp_list->DbMasterFilter != "" && $policydp->getCurrentMasterTable() == "detailpayroll") {
	if ($policydp_list->MasterRecordExists) {
		include_once "detailpayrollmaster.php";
	}
}
?>
<?php } ?>
<?php
$policydp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$policydp_list->isExport() && !$policydp->CurrentAction) { ?>
<form name="fpolicydplistsrch" id="fpolicydplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fpolicydplistsrch-search-panel" class="<?php echo $policydp_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="policydp">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $policydp_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($policydp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($policydp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $policydp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($policydp_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($policydp_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($policydp_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($policydp_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $policydp_list->showPageHeader(); ?>
<?php
$policydp_list->showMessage();
?>
<?php if ($policydp_list->TotalRecords > 0 || $policydp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($policydp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> policydp">
<?php if (!$policydp_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$policydp_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policydp_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $policydp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fpolicydplist" id="fpolicydplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policydp">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($policydp->getCurrentMasterTable() == "detailpayroll" && $policydp->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="detailpayroll">
<input type="hidden" name="fk_iddp" value="<?php echo HtmlEncode($policydp_list->iddp->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_policydp" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($policydp_list->TotalRecords > 0 || $policydp_list->isGridEdit()) { ?>
<table id="tbl_policydplist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$policydp->RowType = ROWTYPE_HEADER;

// Render list options
$policydp_list->renderListOptions();

// Render list options (header, left)
$policydp_list->ListOptions->render("header", "left");
?>
<?php if ($policydp_list->idpdp->Visible) { // idpdp ?>
	<?php if ($policydp_list->SortUrl($policydp_list->idpdp) == "") { ?>
		<th data-name="idpdp" class="<?php echo $policydp_list->idpdp->headerCellClass() ?>"><div id="elh_policydp_idpdp" class="policydp_idpdp"><div class="ew-table-header-caption"><?php echo $policydp_list->idpdp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpdp" class="<?php echo $policydp_list->idpdp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->idpdp) ?>', 1);"><div id="elh_policydp_idpdp" class="policydp_idpdp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->idpdp->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->idpdp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->idpdp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_list->titlepo->Visible) { // titlepo ?>
	<?php if ($policydp_list->SortUrl($policydp_list->titlepo) == "") { ?>
		<th data-name="titlepo" class="<?php echo $policydp_list->titlepo->headerCellClass() ?>"><div id="elh_policydp_titlepo" class="policydp_titlepo"><div class="ew-table-header-caption"><?php echo $policydp_list->titlepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titlepo" class="<?php echo $policydp_list->titlepo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->titlepo) ?>', 1);"><div id="elh_policydp_titlepo" class="policydp_titlepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->titlepo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->titlepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->titlepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_list->amountpo->Visible) { // amountpo ?>
	<?php if ($policydp_list->SortUrl($policydp_list->amountpo) == "") { ?>
		<th data-name="amountpo" class="<?php echo $policydp_list->amountpo->headerCellClass() ?>"><div id="elh_policydp_amountpo" class="policydp_amountpo"><div class="ew-table-header-caption"><?php echo $policydp_list->amountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amountpo" class="<?php echo $policydp_list->amountpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->amountpo) ?>', 1);"><div id="elh_policydp_amountpo" class="policydp_amountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->amountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->amountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->amountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_list->per->Visible) { // per ?>
	<?php if ($policydp_list->SortUrl($policydp_list->per) == "") { ?>
		<th data-name="per" class="<?php echo $policydp_list->per->headerCellClass() ?>"><div id="elh_policydp_per" class="policydp_per"><div class="ew-table-header-caption"><?php echo $policydp_list->per->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per" class="<?php echo $policydp_list->per->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->per) ?>', 1);"><div id="elh_policydp_per" class="policydp_per">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->per->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->per->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->per->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_list->typepo->Visible) { // typepo ?>
	<?php if ($policydp_list->SortUrl($policydp_list->typepo) == "") { ?>
		<th data-name="typepo" class="<?php echo $policydp_list->typepo->headerCellClass() ?>"><div id="elh_policydp_typepo" class="policydp_typepo"><div class="ew-table-header-caption"><?php echo $policydp_list->typepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="typepo" class="<?php echo $policydp_list->typepo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->typepo) ?>', 1);"><div id="elh_policydp_typepo" class="policydp_typepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->typepo->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->typepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->typepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_list->peramountpo->Visible) { // peramountpo ?>
	<?php if ($policydp_list->SortUrl($policydp_list->peramountpo) == "") { ?>
		<th data-name="peramountpo" class="<?php echo $policydp_list->peramountpo->headerCellClass() ?>"><div id="elh_policydp_peramountpo" class="policydp_peramountpo"><div class="ew-table-header-caption"><?php echo $policydp_list->peramountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="peramountpo" class="<?php echo $policydp_list->peramountpo->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->peramountpo) ?>', 1);"><div id="elh_policydp_peramountpo" class="policydp_peramountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->peramountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->peramountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->peramountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_list->iddp->Visible) { // iddp ?>
	<?php if ($policydp_list->SortUrl($policydp_list->iddp) == "") { ?>
		<th data-name="iddp" class="<?php echo $policydp_list->iddp->headerCellClass() ?>"><div id="elh_policydp_iddp" class="policydp_iddp"><div class="ew-table-header-caption"><?php echo $policydp_list->iddp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddp" class="<?php echo $policydp_list->iddp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $policydp_list->SortUrl($policydp_list->iddp) ?>', 1);"><div id="elh_policydp_iddp" class="policydp_iddp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_list->iddp->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_list->iddp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_list->iddp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$policydp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($policydp_list->ExportAll && $policydp_list->isExport()) {
	$policydp_list->StopRecord = $policydp_list->TotalRecords;
} else {

	// Set the last record to display
	if ($policydp_list->TotalRecords > $policydp_list->StartRecord + $policydp_list->DisplayRecords - 1)
		$policydp_list->StopRecord = $policydp_list->StartRecord + $policydp_list->DisplayRecords - 1;
	else
		$policydp_list->StopRecord = $policydp_list->TotalRecords;
}
$policydp_list->RecordCount = $policydp_list->StartRecord - 1;
if ($policydp_list->Recordset && !$policydp_list->Recordset->EOF) {
	$policydp_list->Recordset->moveFirst();
	$selectLimit = $policydp_list->UseSelectLimit;
	if (!$selectLimit && $policydp_list->StartRecord > 1)
		$policydp_list->Recordset->move($policydp_list->StartRecord - 1);
} elseif (!$policydp->AllowAddDeleteRow && $policydp_list->StopRecord == 0) {
	$policydp_list->StopRecord = $policydp->GridAddRowCount;
}

// Initialize aggregate
$policydp->RowType = ROWTYPE_AGGREGATEINIT;
$policydp->resetAttributes();
$policydp_list->renderRow();
while ($policydp_list->RecordCount < $policydp_list->StopRecord) {
	$policydp_list->RecordCount++;
	if ($policydp_list->RecordCount >= $policydp_list->StartRecord) {
		$policydp_list->RowCount++;

		// Set up key count
		$policydp_list->KeyCount = $policydp_list->RowIndex;

		// Init row class and style
		$policydp->resetAttributes();
		$policydp->CssClass = "";
		if ($policydp_list->isGridAdd()) {
		} else {
			$policydp_list->loadRowValues($policydp_list->Recordset); // Load row values
		}
		$policydp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$policydp->RowAttrs->merge(["data-rowindex" => $policydp_list->RowCount, "id" => "r" . $policydp_list->RowCount . "_policydp", "data-rowtype" => $policydp->RowType]);

		// Render row
		$policydp_list->renderRow();

		// Render list options
		$policydp_list->renderListOptions();
?>
	<tr <?php echo $policydp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policydp_list->ListOptions->render("body", "left", $policydp_list->RowCount);
?>
	<?php if ($policydp_list->idpdp->Visible) { // idpdp ?>
		<td data-name="idpdp" <?php echo $policydp_list->idpdp->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_idpdp">
<span<?php echo $policydp_list->idpdp->viewAttributes() ?>><?php echo $policydp_list->idpdp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policydp_list->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo" <?php echo $policydp_list->titlepo->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_titlepo">
<span<?php echo $policydp_list->titlepo->viewAttributes() ?>><?php echo $policydp_list->titlepo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policydp_list->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo" <?php echo $policydp_list->amountpo->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_amountpo">
<span<?php echo $policydp_list->amountpo->viewAttributes() ?>><?php echo $policydp_list->amountpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policydp_list->per->Visible) { // per ?>
		<td data-name="per" <?php echo $policydp_list->per->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_per">
<span<?php echo $policydp_list->per->viewAttributes() ?>><?php echo $policydp_list->per->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policydp_list->typepo->Visible) { // typepo ?>
		<td data-name="typepo" <?php echo $policydp_list->typepo->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_typepo">
<span<?php echo $policydp_list->typepo->viewAttributes() ?>><?php echo $policydp_list->typepo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policydp_list->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo" <?php echo $policydp_list->peramountpo->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_peramountpo">
<span<?php echo $policydp_list->peramountpo->viewAttributes() ?>><?php echo $policydp_list->peramountpo->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($policydp_list->iddp->Visible) { // iddp ?>
		<td data-name="iddp" <?php echo $policydp_list->iddp->cellAttributes() ?>>
<span id="el<?php echo $policydp_list->RowCount ?>_policydp_iddp">
<span<?php echo $policydp_list->iddp->viewAttributes() ?>><?php echo $policydp_list->iddp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policydp_list->ListOptions->render("body", "right", $policydp_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$policydp_list->isGridAdd())
		$policydp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$policydp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($policydp_list->Recordset)
	$policydp_list->Recordset->Close();
?>
<?php if (!$policydp_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$policydp_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $policydp_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $policydp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($policydp_list->TotalRecords == 0 && !$policydp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $policydp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$policydp_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$policydp_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$policydp_list->terminate();
?>