<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($policydp_grid))
	$policydp_grid = new policydp_grid();

// Run the page
$policydp_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policydp_grid->Page_Render();
?>
<?php if (!$policydp_grid->isExport()) { ?>
<script>
var fpolicydpgrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fpolicydpgrid = new ew.Form("fpolicydpgrid", "grid");
	fpolicydpgrid.formKeyCountName = '<?php echo $policydp_grid->FormKeyCountName ?>';

	// Validate form
	fpolicydpgrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($policydp_grid->idpdp->Required) { ?>
				elm = this.getElements("x" + infix + "_idpdp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->idpdp->caption(), $policydp_grid->idpdp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_grid->titlepo->Required) { ?>
				elm = this.getElements("x" + infix + "_titlepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->titlepo->caption(), $policydp_grid->titlepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_grid->amountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->amountpo->caption(), $policydp_grid->amountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policydp_grid->amountpo->errorMessage()) ?>");
			<?php if ($policydp_grid->per->Required) { ?>
				elm = this.getElements("x" + infix + "_per");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->per->caption(), $policydp_grid->per->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_grid->typepo->Required) { ?>
				elm = this.getElements("x" + infix + "_typepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->typepo->caption(), $policydp_grid->typepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_grid->peramountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->peramountpo->caption(), $policydp_grid->peramountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policydp_grid->peramountpo->errorMessage()) ?>");
			<?php if ($policydp_grid->iddp->Required) { ?>
				elm = this.getElements("x" + infix + "_iddp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_grid->iddp->caption(), $policydp_grid->iddp->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fpolicydpgrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "titlepo", false)) return false;
		if (ew.valueChanged(fobj, infix, "amountpo", false)) return false;
		if (ew.valueChanged(fobj, infix, "per", false)) return false;
		if (ew.valueChanged(fobj, infix, "typepo", false)) return false;
		if (ew.valueChanged(fobj, infix, "peramountpo", false)) return false;
		if (ew.valueChanged(fobj, infix, "iddp", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fpolicydpgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpolicydpgrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpolicydpgrid.lists["x_per"] = <?php echo $policydp_grid->per->Lookup->toClientList($policydp_grid) ?>;
	fpolicydpgrid.lists["x_per"].options = <?php echo JsonEncode($policydp_grid->per->options(FALSE, TRUE)) ?>;
	fpolicydpgrid.lists["x_typepo"] = <?php echo $policydp_grid->typepo->Lookup->toClientList($policydp_grid) ?>;
	fpolicydpgrid.lists["x_typepo"].options = <?php echo JsonEncode($policydp_grid->typepo->options(FALSE, TRUE)) ?>;
	fpolicydpgrid.lists["x_iddp"] = <?php echo $policydp_grid->iddp->Lookup->toClientList($policydp_grid) ?>;
	fpolicydpgrid.lists["x_iddp"].options = <?php echo JsonEncode($policydp_grid->iddp->lookupOptions()) ?>;
	loadjs.done("fpolicydpgrid");
});
</script>
<?php } ?>
<?php
$policydp_grid->renderOtherOptions();
?>
<?php if ($policydp_grid->TotalRecords > 0 || $policydp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($policydp_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> policydp">
<?php if ($policydp_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $policydp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fpolicydpgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_policydp" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_policydpgrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$policydp->RowType = ROWTYPE_HEADER;

// Render list options
$policydp_grid->renderListOptions();

// Render list options (header, left)
$policydp_grid->ListOptions->render("header", "left");
?>
<?php if ($policydp_grid->idpdp->Visible) { // idpdp ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->idpdp) == "") { ?>
		<th data-name="idpdp" class="<?php echo $policydp_grid->idpdp->headerCellClass() ?>"><div id="elh_policydp_idpdp" class="policydp_idpdp"><div class="ew-table-header-caption"><?php echo $policydp_grid->idpdp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpdp" class="<?php echo $policydp_grid->idpdp->headerCellClass() ?>"><div><div id="elh_policydp_idpdp" class="policydp_idpdp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->idpdp->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->idpdp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->idpdp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_grid->titlepo->Visible) { // titlepo ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->titlepo) == "") { ?>
		<th data-name="titlepo" class="<?php echo $policydp_grid->titlepo->headerCellClass() ?>"><div id="elh_policydp_titlepo" class="policydp_titlepo"><div class="ew-table-header-caption"><?php echo $policydp_grid->titlepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="titlepo" class="<?php echo $policydp_grid->titlepo->headerCellClass() ?>"><div><div id="elh_policydp_titlepo" class="policydp_titlepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->titlepo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->titlepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->titlepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_grid->amountpo->Visible) { // amountpo ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->amountpo) == "") { ?>
		<th data-name="amountpo" class="<?php echo $policydp_grid->amountpo->headerCellClass() ?>"><div id="elh_policydp_amountpo" class="policydp_amountpo"><div class="ew-table-header-caption"><?php echo $policydp_grid->amountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amountpo" class="<?php echo $policydp_grid->amountpo->headerCellClass() ?>"><div><div id="elh_policydp_amountpo" class="policydp_amountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->amountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->amountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->amountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_grid->per->Visible) { // per ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->per) == "") { ?>
		<th data-name="per" class="<?php echo $policydp_grid->per->headerCellClass() ?>"><div id="elh_policydp_per" class="policydp_per"><div class="ew-table-header-caption"><?php echo $policydp_grid->per->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="per" class="<?php echo $policydp_grid->per->headerCellClass() ?>"><div><div id="elh_policydp_per" class="policydp_per">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->per->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->per->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->per->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_grid->typepo->Visible) { // typepo ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->typepo) == "") { ?>
		<th data-name="typepo" class="<?php echo $policydp_grid->typepo->headerCellClass() ?>"><div id="elh_policydp_typepo" class="policydp_typepo"><div class="ew-table-header-caption"><?php echo $policydp_grid->typepo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="typepo" class="<?php echo $policydp_grid->typepo->headerCellClass() ?>"><div><div id="elh_policydp_typepo" class="policydp_typepo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->typepo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->typepo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->typepo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_grid->peramountpo->Visible) { // peramountpo ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->peramountpo) == "") { ?>
		<th data-name="peramountpo" class="<?php echo $policydp_grid->peramountpo->headerCellClass() ?>"><div id="elh_policydp_peramountpo" class="policydp_peramountpo"><div class="ew-table-header-caption"><?php echo $policydp_grid->peramountpo->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="peramountpo" class="<?php echo $policydp_grid->peramountpo->headerCellClass() ?>"><div><div id="elh_policydp_peramountpo" class="policydp_peramountpo">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->peramountpo->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->peramountpo->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->peramountpo->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($policydp_grid->iddp->Visible) { // iddp ?>
	<?php if ($policydp_grid->SortUrl($policydp_grid->iddp) == "") { ?>
		<th data-name="iddp" class="<?php echo $policydp_grid->iddp->headerCellClass() ?>"><div id="elh_policydp_iddp" class="policydp_iddp"><div class="ew-table-header-caption"><?php echo $policydp_grid->iddp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddp" class="<?php echo $policydp_grid->iddp->headerCellClass() ?>"><div><div id="elh_policydp_iddp" class="policydp_iddp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $policydp_grid->iddp->caption() ?></span><span class="ew-table-header-sort"><?php if ($policydp_grid->iddp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($policydp_grid->iddp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$policydp_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$policydp_grid->StartRecord = 1;
$policydp_grid->StopRecord = $policydp_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($policydp->isConfirm() || $policydp_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($policydp_grid->FormKeyCountName) && ($policydp_grid->isGridAdd() || $policydp_grid->isGridEdit() || $policydp->isConfirm())) {
		$policydp_grid->KeyCount = $CurrentForm->getValue($policydp_grid->FormKeyCountName);
		$policydp_grid->StopRecord = $policydp_grid->StartRecord + $policydp_grid->KeyCount - 1;
	}
}
$policydp_grid->RecordCount = $policydp_grid->StartRecord - 1;
if ($policydp_grid->Recordset && !$policydp_grid->Recordset->EOF) {
	$policydp_grid->Recordset->moveFirst();
	$selectLimit = $policydp_grid->UseSelectLimit;
	if (!$selectLimit && $policydp_grid->StartRecord > 1)
		$policydp_grid->Recordset->move($policydp_grid->StartRecord - 1);
} elseif (!$policydp->AllowAddDeleteRow && $policydp_grid->StopRecord == 0) {
	$policydp_grid->StopRecord = $policydp->GridAddRowCount;
}

// Initialize aggregate
$policydp->RowType = ROWTYPE_AGGREGATEINIT;
$policydp->resetAttributes();
$policydp_grid->renderRow();
if ($policydp_grid->isGridAdd())
	$policydp_grid->RowIndex = 0;
if ($policydp_grid->isGridEdit())
	$policydp_grid->RowIndex = 0;
while ($policydp_grid->RecordCount < $policydp_grid->StopRecord) {
	$policydp_grid->RecordCount++;
	if ($policydp_grid->RecordCount >= $policydp_grid->StartRecord) {
		$policydp_grid->RowCount++;
		if ($policydp_grid->isGridAdd() || $policydp_grid->isGridEdit() || $policydp->isConfirm()) {
			$policydp_grid->RowIndex++;
			$CurrentForm->Index = $policydp_grid->RowIndex;
			if ($CurrentForm->hasValue($policydp_grid->FormActionName) && ($policydp->isConfirm() || $policydp_grid->EventCancelled))
				$policydp_grid->RowAction = strval($CurrentForm->getValue($policydp_grid->FormActionName));
			elseif ($policydp_grid->isGridAdd())
				$policydp_grid->RowAction = "insert";
			else
				$policydp_grid->RowAction = "";
		}

		// Set up key count
		$policydp_grid->KeyCount = $policydp_grid->RowIndex;

		// Init row class and style
		$policydp->resetAttributes();
		$policydp->CssClass = "";
		if ($policydp_grid->isGridAdd()) {
			if ($policydp->CurrentMode == "copy") {
				$policydp_grid->loadRowValues($policydp_grid->Recordset); // Load row values
				$policydp_grid->setRecordKey($policydp_grid->RowOldKey, $policydp_grid->Recordset); // Set old record key
			} else {
				$policydp_grid->loadRowValues(); // Load default values
				$policydp_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$policydp_grid->loadRowValues($policydp_grid->Recordset); // Load row values
		}
		$policydp->RowType = ROWTYPE_VIEW; // Render view
		if ($policydp_grid->isGridAdd()) // Grid add
			$policydp->RowType = ROWTYPE_ADD; // Render add
		if ($policydp_grid->isGridAdd() && $policydp->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$policydp_grid->restoreCurrentRowFormValues($policydp_grid->RowIndex); // Restore form values
		if ($policydp_grid->isGridEdit()) { // Grid edit
			if ($policydp->EventCancelled)
				$policydp_grid->restoreCurrentRowFormValues($policydp_grid->RowIndex); // Restore form values
			if ($policydp_grid->RowAction == "insert")
				$policydp->RowType = ROWTYPE_ADD; // Render add
			else
				$policydp->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($policydp_grid->isGridEdit() && ($policydp->RowType == ROWTYPE_EDIT || $policydp->RowType == ROWTYPE_ADD) && $policydp->EventCancelled) // Update failed
			$policydp_grid->restoreCurrentRowFormValues($policydp_grid->RowIndex); // Restore form values
		if ($policydp->RowType == ROWTYPE_EDIT) // Edit row
			$policydp_grid->EditRowCount++;
		if ($policydp->isConfirm()) // Confirm row
			$policydp_grid->restoreCurrentRowFormValues($policydp_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$policydp->RowAttrs->merge(["data-rowindex" => $policydp_grid->RowCount, "id" => "r" . $policydp_grid->RowCount . "_policydp", "data-rowtype" => $policydp->RowType]);

		// Render row
		$policydp_grid->renderRow();

		// Render list options
		$policydp_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($policydp_grid->RowAction != "delete" && $policydp_grid->RowAction != "insertdelete" && !($policydp_grid->RowAction == "insert" && $policydp->isConfirm() && $policydp_grid->emptyRow())) {
?>
	<tr <?php echo $policydp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policydp_grid->ListOptions->render("body", "left", $policydp_grid->RowCount);
?>
	<?php if ($policydp_grid->idpdp->Visible) { // idpdp ?>
		<td data-name="idpdp" <?php echo $policydp_grid->idpdp->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_idpdp" class="form-group"></span>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="o<?php echo $policydp_grid->RowIndex ?>_idpdp" id="o<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_idpdp" class="form-group">
<span<?php echo $policydp_grid->idpdp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->idpdp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="x<?php echo $policydp_grid->RowIndex ?>_idpdp" id="x<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->CurrentValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_idpdp">
<span<?php echo $policydp_grid->idpdp->viewAttributes() ?>><?php echo $policydp_grid->idpdp->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="x<?php echo $policydp_grid->RowIndex ?>_idpdp" id="x<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="o<?php echo $policydp_grid->RowIndex ?>_idpdp" id="o<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_idpdp" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_idpdp" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policydp_grid->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo" <?php echo $policydp_grid->titlepo->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_titlepo" class="form-group">
<input type="text" data-table="policydp" data-field="x_titlepo" name="x<?php echo $policydp_grid->RowIndex ?>_titlepo" id="x<?php echo $policydp_grid->RowIndex ?>_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policydp_grid->titlepo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->titlepo->EditValue ?>"<?php echo $policydp_grid->titlepo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="o<?php echo $policydp_grid->RowIndex ?>_titlepo" id="o<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_titlepo" class="form-group">
<input type="text" data-table="policydp" data-field="x_titlepo" name="x<?php echo $policydp_grid->RowIndex ?>_titlepo" id="x<?php echo $policydp_grid->RowIndex ?>_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policydp_grid->titlepo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->titlepo->EditValue ?>"<?php echo $policydp_grid->titlepo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_titlepo">
<span<?php echo $policydp_grid->titlepo->viewAttributes() ?>><?php echo $policydp_grid->titlepo->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="x<?php echo $policydp_grid->RowIndex ?>_titlepo" id="x<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="o<?php echo $policydp_grid->RowIndex ?>_titlepo" id="o<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_titlepo" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_titlepo" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policydp_grid->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo" <?php echo $policydp_grid->amountpo->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_amountpo" class="form-group">
<input type="text" data-table="policydp" data-field="x_amountpo" name="x<?php echo $policydp_grid->RowIndex ?>_amountpo" id="x<?php echo $policydp_grid->RowIndex ?>_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_grid->amountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->amountpo->EditValue ?>"<?php echo $policydp_grid->amountpo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="o<?php echo $policydp_grid->RowIndex ?>_amountpo" id="o<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_amountpo" class="form-group">
<input type="text" data-table="policydp" data-field="x_amountpo" name="x<?php echo $policydp_grid->RowIndex ?>_amountpo" id="x<?php echo $policydp_grid->RowIndex ?>_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_grid->amountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->amountpo->EditValue ?>"<?php echo $policydp_grid->amountpo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_amountpo">
<span<?php echo $policydp_grid->amountpo->viewAttributes() ?>><?php echo $policydp_grid->amountpo->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="x<?php echo $policydp_grid->RowIndex ?>_amountpo" id="x<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="o<?php echo $policydp_grid->RowIndex ?>_amountpo" id="o<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_amountpo" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_amountpo" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policydp_grid->per->Visible) { // per ?>
		<td data-name="per" <?php echo $policydp_grid->per->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_per" class="form-group">
<div id="tp_x<?php echo $policydp_grid->RowIndex ?>_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_per" data-value-separator="<?php echo $policydp_grid->per->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_per" id="x<?php echo $policydp_grid->RowIndex ?>_per" value="{value}"<?php echo $policydp_grid->per->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policydp_grid->RowIndex ?>_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_grid->per->radioButtonListHtml(FALSE, "x{$policydp_grid->RowIndex}_per") ?>
</div></div>
</span>
<input type="hidden" data-table="policydp" data-field="x_per" name="o<?php echo $policydp_grid->RowIndex ?>_per" id="o<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_per" class="form-group">
<div id="tp_x<?php echo $policydp_grid->RowIndex ?>_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_per" data-value-separator="<?php echo $policydp_grid->per->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_per" id="x<?php echo $policydp_grid->RowIndex ?>_per" value="{value}"<?php echo $policydp_grid->per->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policydp_grid->RowIndex ?>_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_grid->per->radioButtonListHtml(FALSE, "x{$policydp_grid->RowIndex}_per") ?>
</div></div>
</span>
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_per">
<span<?php echo $policydp_grid->per->viewAttributes() ?>><?php echo $policydp_grid->per->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_per" name="x<?php echo $policydp_grid->RowIndex ?>_per" id="x<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_per" name="o<?php echo $policydp_grid->RowIndex ?>_per" id="o<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_per" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_per" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_per" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_per" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policydp_grid->typepo->Visible) { // typepo ?>
		<td data-name="typepo" <?php echo $policydp_grid->typepo->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_typepo" class="form-group">
<div id="tp_x<?php echo $policydp_grid->RowIndex ?>_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_typepo" data-value-separator="<?php echo $policydp_grid->typepo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_typepo" id="x<?php echo $policydp_grid->RowIndex ?>_typepo" value="{value}"<?php echo $policydp_grid->typepo->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policydp_grid->RowIndex ?>_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_grid->typepo->radioButtonListHtml(FALSE, "x{$policydp_grid->RowIndex}_typepo") ?>
</div></div>
</span>
<input type="hidden" data-table="policydp" data-field="x_typepo" name="o<?php echo $policydp_grid->RowIndex ?>_typepo" id="o<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_typepo" class="form-group">
<div id="tp_x<?php echo $policydp_grid->RowIndex ?>_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_typepo" data-value-separator="<?php echo $policydp_grid->typepo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_typepo" id="x<?php echo $policydp_grid->RowIndex ?>_typepo" value="{value}"<?php echo $policydp_grid->typepo->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policydp_grid->RowIndex ?>_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_grid->typepo->radioButtonListHtml(FALSE, "x{$policydp_grid->RowIndex}_typepo") ?>
</div></div>
</span>
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_typepo">
<span<?php echo $policydp_grid->typepo->viewAttributes() ?>><?php echo $policydp_grid->typepo->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_typepo" name="x<?php echo $policydp_grid->RowIndex ?>_typepo" id="x<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_typepo" name="o<?php echo $policydp_grid->RowIndex ?>_typepo" id="o<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_typepo" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_typepo" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_typepo" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_typepo" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policydp_grid->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo" <?php echo $policydp_grid->peramountpo->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_peramountpo" class="form-group">
<input type="text" data-table="policydp" data-field="x_peramountpo" name="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_grid->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->peramountpo->EditValue ?>"<?php echo $policydp_grid->peramountpo->editAttributes() ?>>
</span>
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="o<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="o<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_peramountpo" class="form-group">
<input type="text" data-table="policydp" data-field="x_peramountpo" name="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_grid->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->peramountpo->EditValue ?>"<?php echo $policydp_grid->peramountpo->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_peramountpo">
<span<?php echo $policydp_grid->peramountpo->viewAttributes() ?>><?php echo $policydp_grid->peramountpo->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="o<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="o<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($policydp_grid->iddp->Visible) { // iddp ?>
		<td data-name="iddp" <?php echo $policydp_grid->iddp->cellAttributes() ?>>
<?php if ($policydp->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($policydp_grid->iddp->getSessionValue() != "") { ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_iddp" class="form-group">
<span<?php echo $policydp_grid->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->iddp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_iddp" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policydp_grid->RowIndex ?>_iddp"><?php echo EmptyValue(strval($policydp_grid->iddp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policydp_grid->iddp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policydp_grid->iddp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policydp_grid->iddp->ReadOnly || $policydp_grid->iddp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policydp_grid->RowIndex ?>_iddp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policydp_grid->iddp->Lookup->getParamTag($policydp_grid, "p_x" . $policydp_grid->RowIndex . "_iddp") ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policydp_grid->iddp->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo $policydp_grid->iddp->CurrentValue ?>"<?php echo $policydp_grid->iddp->editAttributes() ?>>
</span>
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" name="o<?php echo $policydp_grid->RowIndex ?>_iddp" id="o<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->OldValue) ?>">
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($policydp_grid->iddp->getSessionValue() != "") { ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_iddp" class="form-group">
<span<?php echo $policydp_grid->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->iddp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_iddp" class="form-group">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policydp_grid->RowIndex ?>_iddp"><?php echo EmptyValue(strval($policydp_grid->iddp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policydp_grid->iddp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policydp_grid->iddp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policydp_grid->iddp->ReadOnly || $policydp_grid->iddp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policydp_grid->RowIndex ?>_iddp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policydp_grid->iddp->Lookup->getParamTag($policydp_grid, "p_x" . $policydp_grid->RowIndex . "_iddp") ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policydp_grid->iddp->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo $policydp_grid->iddp->CurrentValue ?>"<?php echo $policydp_grid->iddp->editAttributes() ?>>
</span>
<?php } ?>
<?php } ?>
<?php if ($policydp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $policydp_grid->RowCount ?>_policydp_iddp">
<span<?php echo $policydp_grid->iddp->viewAttributes() ?>><?php echo $policydp_grid->iddp->getViewValue() ?></span>
</span>
<?php if (!$policydp->isConfirm()) { ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_iddp" name="o<?php echo $policydp_grid->RowIndex ?>_iddp" id="o<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" name="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_iddp" id="fpolicydpgrid$x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->FormValue) ?>">
<input type="hidden" data-table="policydp" data-field="x_iddp" name="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_iddp" id="fpolicydpgrid$o<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policydp_grid->ListOptions->render("body", "right", $policydp_grid->RowCount);
?>
	</tr>
<?php if ($policydp->RowType == ROWTYPE_ADD || $policydp->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fpolicydpgrid", "load"], function() {
	fpolicydpgrid.updateLists(<?php echo $policydp_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$policydp_grid->isGridAdd() || $policydp->CurrentMode == "copy")
		if (!$policydp_grid->Recordset->EOF)
			$policydp_grid->Recordset->moveNext();
}
?>
<?php
	if ($policydp->CurrentMode == "add" || $policydp->CurrentMode == "copy" || $policydp->CurrentMode == "edit") {
		$policydp_grid->RowIndex = '$rowindex$';
		$policydp_grid->loadRowValues();

		// Set row properties
		$policydp->resetAttributes();
		$policydp->RowAttrs->merge(["data-rowindex" => $policydp_grid->RowIndex, "id" => "r0_policydp", "data-rowtype" => ROWTYPE_ADD]);
		$policydp->RowAttrs->appendClass("ew-template");
		$policydp->RowType = ROWTYPE_ADD;

		// Render row
		$policydp_grid->renderRow();

		// Render list options
		$policydp_grid->renderListOptions();
		$policydp_grid->StartRowCount = 0;
?>
	<tr <?php echo $policydp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$policydp_grid->ListOptions->render("body", "left", $policydp_grid->RowIndex);
?>
	<?php if ($policydp_grid->idpdp->Visible) { // idpdp ?>
		<td data-name="idpdp">
<?php if (!$policydp->isConfirm()) { ?>
<span id="el$rowindex$_policydp_idpdp" class="form-group policydp_idpdp"></span>
<?php } else { ?>
<span id="el$rowindex$_policydp_idpdp" class="form-group policydp_idpdp">
<span<?php echo $policydp_grid->idpdp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->idpdp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="x<?php echo $policydp_grid->RowIndex ?>_idpdp" id="x<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="o<?php echo $policydp_grid->RowIndex ?>_idpdp" id="o<?php echo $policydp_grid->RowIndex ?>_idpdp" value="<?php echo HtmlEncode($policydp_grid->idpdp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policydp_grid->titlepo->Visible) { // titlepo ?>
		<td data-name="titlepo">
<?php if (!$policydp->isConfirm()) { ?>
<span id="el$rowindex$_policydp_titlepo" class="form-group policydp_titlepo">
<input type="text" data-table="policydp" data-field="x_titlepo" name="x<?php echo $policydp_grid->RowIndex ?>_titlepo" id="x<?php echo $policydp_grid->RowIndex ?>_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policydp_grid->titlepo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->titlepo->EditValue ?>"<?php echo $policydp_grid->titlepo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policydp_titlepo" class="form-group policydp_titlepo">
<span<?php echo $policydp_grid->titlepo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->titlepo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="x<?php echo $policydp_grid->RowIndex ?>_titlepo" id="x<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_titlepo" name="o<?php echo $policydp_grid->RowIndex ?>_titlepo" id="o<?php echo $policydp_grid->RowIndex ?>_titlepo" value="<?php echo HtmlEncode($policydp_grid->titlepo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policydp_grid->amountpo->Visible) { // amountpo ?>
		<td data-name="amountpo">
<?php if (!$policydp->isConfirm()) { ?>
<span id="el$rowindex$_policydp_amountpo" class="form-group policydp_amountpo">
<input type="text" data-table="policydp" data-field="x_amountpo" name="x<?php echo $policydp_grid->RowIndex ?>_amountpo" id="x<?php echo $policydp_grid->RowIndex ?>_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_grid->amountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->amountpo->EditValue ?>"<?php echo $policydp_grid->amountpo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policydp_amountpo" class="form-group policydp_amountpo">
<span<?php echo $policydp_grid->amountpo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->amountpo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="x<?php echo $policydp_grid->RowIndex ?>_amountpo" id="x<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_amountpo" name="o<?php echo $policydp_grid->RowIndex ?>_amountpo" id="o<?php echo $policydp_grid->RowIndex ?>_amountpo" value="<?php echo HtmlEncode($policydp_grid->amountpo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policydp_grid->per->Visible) { // per ?>
		<td data-name="per">
<?php if (!$policydp->isConfirm()) { ?>
<span id="el$rowindex$_policydp_per" class="form-group policydp_per">
<div id="tp_x<?php echo $policydp_grid->RowIndex ?>_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_per" data-value-separator="<?php echo $policydp_grid->per->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_per" id="x<?php echo $policydp_grid->RowIndex ?>_per" value="{value}"<?php echo $policydp_grid->per->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policydp_grid->RowIndex ?>_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_grid->per->radioButtonListHtml(FALSE, "x{$policydp_grid->RowIndex}_per") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_policydp_per" class="form-group policydp_per">
<span<?php echo $policydp_grid->per->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->per->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_per" name="x<?php echo $policydp_grid->RowIndex ?>_per" id="x<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_per" name="o<?php echo $policydp_grid->RowIndex ?>_per" id="o<?php echo $policydp_grid->RowIndex ?>_per" value="<?php echo HtmlEncode($policydp_grid->per->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policydp_grid->typepo->Visible) { // typepo ?>
		<td data-name="typepo">
<?php if (!$policydp->isConfirm()) { ?>
<span id="el$rowindex$_policydp_typepo" class="form-group policydp_typepo">
<div id="tp_x<?php echo $policydp_grid->RowIndex ?>_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_typepo" data-value-separator="<?php echo $policydp_grid->typepo->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_typepo" id="x<?php echo $policydp_grid->RowIndex ?>_typepo" value="{value}"<?php echo $policydp_grid->typepo->editAttributes() ?>></div>
<div id="dsl_x<?php echo $policydp_grid->RowIndex ?>_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_grid->typepo->radioButtonListHtml(FALSE, "x{$policydp_grid->RowIndex}_typepo") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el$rowindex$_policydp_typepo" class="form-group policydp_typepo">
<span<?php echo $policydp_grid->typepo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->typepo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_typepo" name="x<?php echo $policydp_grid->RowIndex ?>_typepo" id="x<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_typepo" name="o<?php echo $policydp_grid->RowIndex ?>_typepo" id="o<?php echo $policydp_grid->RowIndex ?>_typepo" value="<?php echo HtmlEncode($policydp_grid->typepo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policydp_grid->peramountpo->Visible) { // peramountpo ?>
		<td data-name="peramountpo">
<?php if (!$policydp->isConfirm()) { ?>
<span id="el$rowindex$_policydp_peramountpo" class="form-group policydp_peramountpo">
<input type="text" data-table="policydp" data-field="x_peramountpo" name="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_grid->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_grid->peramountpo->EditValue ?>"<?php echo $policydp_grid->peramountpo->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_policydp_peramountpo" class="form-group policydp_peramountpo">
<span<?php echo $policydp_grid->peramountpo->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->peramountpo->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="x<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_peramountpo" name="o<?php echo $policydp_grid->RowIndex ?>_peramountpo" id="o<?php echo $policydp_grid->RowIndex ?>_peramountpo" value="<?php echo HtmlEncode($policydp_grid->peramountpo->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($policydp_grid->iddp->Visible) { // iddp ?>
		<td data-name="iddp">
<?php if (!$policydp->isConfirm()) { ?>
<?php if ($policydp_grid->iddp->getSessionValue() != "") { ?>
<span id="el$rowindex$_policydp_iddp" class="form-group policydp_iddp">
<span<?php echo $policydp_grid->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->iddp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_policydp_iddp" class="form-group policydp_iddp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $policydp_grid->RowIndex ?>_iddp"><?php echo EmptyValue(strval($policydp_grid->iddp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policydp_grid->iddp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policydp_grid->iddp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policydp_grid->iddp->ReadOnly || $policydp_grid->iddp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $policydp_grid->RowIndex ?>_iddp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policydp_grid->iddp->Lookup->getParamTag($policydp_grid, "p_x" . $policydp_grid->RowIndex . "_iddp") ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policydp_grid->iddp->displayValueSeparatorAttribute() ?>" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo $policydp_grid->iddp->CurrentValue ?>"<?php echo $policydp_grid->iddp->editAttributes() ?>>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_policydp_iddp" class="form-group policydp_iddp">
<span<?php echo $policydp_grid->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_grid->iddp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_iddp" name="x<?php echo $policydp_grid->RowIndex ?>_iddp" id="x<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" name="o<?php echo $policydp_grid->RowIndex ?>_iddp" id="o<?php echo $policydp_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($policydp_grid->iddp->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$policydp_grid->ListOptions->render("body", "right", $policydp_grid->RowIndex);
?>
<script>
loadjs.ready(["fpolicydpgrid", "load"], function() {
	fpolicydpgrid.updateLists(<?php echo $policydp_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($policydp->CurrentMode == "add" || $policydp->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $policydp_grid->FormKeyCountName ?>" id="<?php echo $policydp_grid->FormKeyCountName ?>" value="<?php echo $policydp_grid->KeyCount ?>">
<?php echo $policydp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($policydp->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $policydp_grid->FormKeyCountName ?>" id="<?php echo $policydp_grid->FormKeyCountName ?>" value="<?php echo $policydp_grid->KeyCount ?>">
<?php echo $policydp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($policydp->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpolicydpgrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($policydp_grid->Recordset)
	$policydp_grid->Recordset->Close();
?>
<?php if ($policydp_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $policydp_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($policydp_grid->TotalRecords == 0 && !$policydp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $policydp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$policydp_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php
$policydp_grid->terminate();
?>