<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policydp_edit = new policydp_edit();

// Run the page
$policydp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policydp_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpolicydpedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fpolicydpedit = currentForm = new ew.Form("fpolicydpedit", "edit");

	// Validate form
	fpolicydpedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($policydp_edit->idpdp->Required) { ?>
				elm = this.getElements("x" + infix + "_idpdp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->idpdp->caption(), $policydp_edit->idpdp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_edit->titlepo->Required) { ?>
				elm = this.getElements("x" + infix + "_titlepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->titlepo->caption(), $policydp_edit->titlepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_edit->amountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->amountpo->caption(), $policydp_edit->amountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policydp_edit->amountpo->errorMessage()) ?>");
			<?php if ($policydp_edit->per->Required) { ?>
				elm = this.getElements("x" + infix + "_per");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->per->caption(), $policydp_edit->per->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_edit->typepo->Required) { ?>
				elm = this.getElements("x" + infix + "_typepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->typepo->caption(), $policydp_edit->typepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_edit->peramountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->peramountpo->caption(), $policydp_edit->peramountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policydp_edit->peramountpo->errorMessage()) ?>");
			<?php if ($policydp_edit->iddp->Required) { ?>
				elm = this.getElements("x" + infix + "_iddp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_edit->iddp->caption(), $policydp_edit->iddp->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpolicydpedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpolicydpedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpolicydpedit.lists["x_per"] = <?php echo $policydp_edit->per->Lookup->toClientList($policydp_edit) ?>;
	fpolicydpedit.lists["x_per"].options = <?php echo JsonEncode($policydp_edit->per->options(FALSE, TRUE)) ?>;
	fpolicydpedit.lists["x_typepo"] = <?php echo $policydp_edit->typepo->Lookup->toClientList($policydp_edit) ?>;
	fpolicydpedit.lists["x_typepo"].options = <?php echo JsonEncode($policydp_edit->typepo->options(FALSE, TRUE)) ?>;
	fpolicydpedit.lists["x_iddp"] = <?php echo $policydp_edit->iddp->Lookup->toClientList($policydp_edit) ?>;
	fpolicydpedit.lists["x_iddp"].options = <?php echo JsonEncode($policydp_edit->iddp->lookupOptions()) ?>;
	loadjs.done("fpolicydpedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $policydp_edit->showPageHeader(); ?>
<?php
$policydp_edit->showMessage();
?>
<form name="fpolicydpedit" id="fpolicydpedit" class="<?php echo $policydp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policydp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$policydp_edit->IsModal ?>">
<?php if ($policydp->getCurrentMasterTable() == "detailpayroll") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="detailpayroll">
<input type="hidden" name="fk_iddp" value="<?php echo HtmlEncode($policydp_edit->iddp->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($policydp_edit->idpdp->Visible) { // idpdp ?>
	<div id="r_idpdp" class="form-group row">
		<label id="elh_policydp_idpdp" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->idpdp->caption() ?><?php echo $policydp_edit->idpdp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->idpdp->cellAttributes() ?>>
<span id="el_policydp_idpdp">
<span<?php echo $policydp_edit->idpdp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_edit->idpdp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="policydp" data-field="x_idpdp" name="x_idpdp" id="x_idpdp" value="<?php echo HtmlEncode($policydp_edit->idpdp->CurrentValue) ?>">
<?php echo $policydp_edit->idpdp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_edit->titlepo->Visible) { // titlepo ?>
	<div id="r_titlepo" class="form-group row">
		<label id="elh_policydp_titlepo" for="x_titlepo" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->titlepo->caption() ?><?php echo $policydp_edit->titlepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->titlepo->cellAttributes() ?>>
<span id="el_policydp_titlepo">
<input type="text" data-table="policydp" data-field="x_titlepo" name="x_titlepo" id="x_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policydp_edit->titlepo->getPlaceHolder()) ?>" value="<?php echo $policydp_edit->titlepo->EditValue ?>"<?php echo $policydp_edit->titlepo->editAttributes() ?>>
</span>
<?php echo $policydp_edit->titlepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_edit->amountpo->Visible) { // amountpo ?>
	<div id="r_amountpo" class="form-group row">
		<label id="elh_policydp_amountpo" for="x_amountpo" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->amountpo->caption() ?><?php echo $policydp_edit->amountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->amountpo->cellAttributes() ?>>
<span id="el_policydp_amountpo">
<input type="text" data-table="policydp" data-field="x_amountpo" name="x_amountpo" id="x_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_edit->amountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_edit->amountpo->EditValue ?>"<?php echo $policydp_edit->amountpo->editAttributes() ?>>
</span>
<?php echo $policydp_edit->amountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_edit->per->Visible) { // per ?>
	<div id="r_per" class="form-group row">
		<label id="elh_policydp_per" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->per->caption() ?><?php echo $policydp_edit->per->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->per->cellAttributes() ?>>
<span id="el_policydp_per">
<div id="tp_x_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_per" data-value-separator="<?php echo $policydp_edit->per->displayValueSeparatorAttribute() ?>" name="x_per" id="x_per" value="{value}"<?php echo $policydp_edit->per->editAttributes() ?>></div>
<div id="dsl_x_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_edit->per->radioButtonListHtml(FALSE, "x_per") ?>
</div></div>
</span>
<?php echo $policydp_edit->per->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_edit->typepo->Visible) { // typepo ?>
	<div id="r_typepo" class="form-group row">
		<label id="elh_policydp_typepo" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->typepo->caption() ?><?php echo $policydp_edit->typepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->typepo->cellAttributes() ?>>
<span id="el_policydp_typepo">
<div id="tp_x_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_typepo" data-value-separator="<?php echo $policydp_edit->typepo->displayValueSeparatorAttribute() ?>" name="x_typepo" id="x_typepo" value="{value}"<?php echo $policydp_edit->typepo->editAttributes() ?>></div>
<div id="dsl_x_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_edit->typepo->radioButtonListHtml(FALSE, "x_typepo") ?>
</div></div>
</span>
<?php echo $policydp_edit->typepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_edit->peramountpo->Visible) { // peramountpo ?>
	<div id="r_peramountpo" class="form-group row">
		<label id="elh_policydp_peramountpo" for="x_peramountpo" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->peramountpo->caption() ?><?php echo $policydp_edit->peramountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->peramountpo->cellAttributes() ?>>
<span id="el_policydp_peramountpo">
<input type="text" data-table="policydp" data-field="x_peramountpo" name="x_peramountpo" id="x_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_edit->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_edit->peramountpo->EditValue ?>"<?php echo $policydp_edit->peramountpo->editAttributes() ?>>
</span>
<?php echo $policydp_edit->peramountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_edit->iddp->Visible) { // iddp ?>
	<div id="r_iddp" class="form-group row">
		<label id="elh_policydp_iddp" for="x_iddp" class="<?php echo $policydp_edit->LeftColumnClass ?>"><?php echo $policydp_edit->iddp->caption() ?><?php echo $policydp_edit->iddp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_edit->RightColumnClass ?>"><div <?php echo $policydp_edit->iddp->cellAttributes() ?>>
<?php if ($policydp_edit->iddp->getSessionValue() != "") { ?>
<span id="el_policydp_iddp">
<span<?php echo $policydp_edit->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_edit->iddp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_iddp" name="x_iddp" value="<?php echo HtmlEncode($policydp_edit->iddp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_policydp_iddp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_iddp"><?php echo EmptyValue(strval($policydp_edit->iddp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policydp_edit->iddp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policydp_edit->iddp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policydp_edit->iddp->ReadOnly || $policydp_edit->iddp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_iddp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policydp_edit->iddp->Lookup->getParamTag($policydp_edit, "p_x_iddp") ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policydp_edit->iddp->displayValueSeparatorAttribute() ?>" name="x_iddp" id="x_iddp" value="<?php echo $policydp_edit->iddp->CurrentValue ?>"<?php echo $policydp_edit->iddp->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $policydp_edit->iddp->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$policydp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $policydp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $policydp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$policydp_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$policydp_edit->terminate();
?>