<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policydp_add = new policydp_add();

// Run the page
$policydp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policydp_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpolicydpadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fpolicydpadd = currentForm = new ew.Form("fpolicydpadd", "add");

	// Validate form
	fpolicydpadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($policydp_add->titlepo->Required) { ?>
				elm = this.getElements("x" + infix + "_titlepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_add->titlepo->caption(), $policydp_add->titlepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_add->amountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_add->amountpo->caption(), $policydp_add->amountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policydp_add->amountpo->errorMessage()) ?>");
			<?php if ($policydp_add->per->Required) { ?>
				elm = this.getElements("x" + infix + "_per");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_add->per->caption(), $policydp_add->per->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_add->typepo->Required) { ?>
				elm = this.getElements("x" + infix + "_typepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_add->typepo->caption(), $policydp_add->typepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policydp_add->peramountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_add->peramountpo->caption(), $policydp_add->peramountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policydp_add->peramountpo->errorMessage()) ?>");
			<?php if ($policydp_add->iddp->Required) { ?>
				elm = this.getElements("x" + infix + "_iddp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policydp_add->iddp->caption(), $policydp_add->iddp->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpolicydpadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpolicydpadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpolicydpadd.lists["x_per"] = <?php echo $policydp_add->per->Lookup->toClientList($policydp_add) ?>;
	fpolicydpadd.lists["x_per"].options = <?php echo JsonEncode($policydp_add->per->options(FALSE, TRUE)) ?>;
	fpolicydpadd.lists["x_typepo"] = <?php echo $policydp_add->typepo->Lookup->toClientList($policydp_add) ?>;
	fpolicydpadd.lists["x_typepo"].options = <?php echo JsonEncode($policydp_add->typepo->options(FALSE, TRUE)) ?>;
	fpolicydpadd.lists["x_iddp"] = <?php echo $policydp_add->iddp->Lookup->toClientList($policydp_add) ?>;
	fpolicydpadd.lists["x_iddp"].options = <?php echo JsonEncode($policydp_add->iddp->lookupOptions()) ?>;
	loadjs.done("fpolicydpadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $policydp_add->showPageHeader(); ?>
<?php
$policydp_add->showMessage();
?>
<form name="fpolicydpadd" id="fpolicydpadd" class="<?php echo $policydp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policydp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$policydp_add->IsModal ?>">
<?php if ($policydp->getCurrentMasterTable() == "detailpayroll") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="detailpayroll">
<input type="hidden" name="fk_iddp" value="<?php echo HtmlEncode($policydp_add->iddp->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($policydp_add->titlepo->Visible) { // titlepo ?>
	<div id="r_titlepo" class="form-group row">
		<label id="elh_policydp_titlepo" for="x_titlepo" class="<?php echo $policydp_add->LeftColumnClass ?>"><?php echo $policydp_add->titlepo->caption() ?><?php echo $policydp_add->titlepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_add->RightColumnClass ?>"><div <?php echo $policydp_add->titlepo->cellAttributes() ?>>
<span id="el_policydp_titlepo">
<input type="text" data-table="policydp" data-field="x_titlepo" name="x_titlepo" id="x_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policydp_add->titlepo->getPlaceHolder()) ?>" value="<?php echo $policydp_add->titlepo->EditValue ?>"<?php echo $policydp_add->titlepo->editAttributes() ?>>
</span>
<?php echo $policydp_add->titlepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_add->amountpo->Visible) { // amountpo ?>
	<div id="r_amountpo" class="form-group row">
		<label id="elh_policydp_amountpo" for="x_amountpo" class="<?php echo $policydp_add->LeftColumnClass ?>"><?php echo $policydp_add->amountpo->caption() ?><?php echo $policydp_add->amountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_add->RightColumnClass ?>"><div <?php echo $policydp_add->amountpo->cellAttributes() ?>>
<span id="el_policydp_amountpo">
<input type="text" data-table="policydp" data-field="x_amountpo" name="x_amountpo" id="x_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_add->amountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_add->amountpo->EditValue ?>"<?php echo $policydp_add->amountpo->editAttributes() ?>>
</span>
<?php echo $policydp_add->amountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_add->per->Visible) { // per ?>
	<div id="r_per" class="form-group row">
		<label id="elh_policydp_per" class="<?php echo $policydp_add->LeftColumnClass ?>"><?php echo $policydp_add->per->caption() ?><?php echo $policydp_add->per->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_add->RightColumnClass ?>"><div <?php echo $policydp_add->per->cellAttributes() ?>>
<span id="el_policydp_per">
<div id="tp_x_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_per" data-value-separator="<?php echo $policydp_add->per->displayValueSeparatorAttribute() ?>" name="x_per" id="x_per" value="{value}"<?php echo $policydp_add->per->editAttributes() ?>></div>
<div id="dsl_x_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_add->per->radioButtonListHtml(FALSE, "x_per") ?>
</div></div>
</span>
<?php echo $policydp_add->per->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_add->typepo->Visible) { // typepo ?>
	<div id="r_typepo" class="form-group row">
		<label id="elh_policydp_typepo" class="<?php echo $policydp_add->LeftColumnClass ?>"><?php echo $policydp_add->typepo->caption() ?><?php echo $policydp_add->typepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_add->RightColumnClass ?>"><div <?php echo $policydp_add->typepo->cellAttributes() ?>>
<span id="el_policydp_typepo">
<div id="tp_x_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policydp" data-field="x_typepo" data-value-separator="<?php echo $policydp_add->typepo->displayValueSeparatorAttribute() ?>" name="x_typepo" id="x_typepo" value="{value}"<?php echo $policydp_add->typepo->editAttributes() ?>></div>
<div id="dsl_x_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policydp_add->typepo->radioButtonListHtml(FALSE, "x_typepo") ?>
</div></div>
</span>
<?php echo $policydp_add->typepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_add->peramountpo->Visible) { // peramountpo ?>
	<div id="r_peramountpo" class="form-group row">
		<label id="elh_policydp_peramountpo" for="x_peramountpo" class="<?php echo $policydp_add->LeftColumnClass ?>"><?php echo $policydp_add->peramountpo->caption() ?><?php echo $policydp_add->peramountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_add->RightColumnClass ?>"><div <?php echo $policydp_add->peramountpo->cellAttributes() ?>>
<span id="el_policydp_peramountpo">
<input type="text" data-table="policydp" data-field="x_peramountpo" name="x_peramountpo" id="x_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policydp_add->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policydp_add->peramountpo->EditValue ?>"<?php echo $policydp_add->peramountpo->editAttributes() ?>>
</span>
<?php echo $policydp_add->peramountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policydp_add->iddp->Visible) { // iddp ?>
	<div id="r_iddp" class="form-group row">
		<label id="elh_policydp_iddp" for="x_iddp" class="<?php echo $policydp_add->LeftColumnClass ?>"><?php echo $policydp_add->iddp->caption() ?><?php echo $policydp_add->iddp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policydp_add->RightColumnClass ?>"><div <?php echo $policydp_add->iddp->cellAttributes() ?>>
<?php if ($policydp_add->iddp->getSessionValue() != "") { ?>
<span id="el_policydp_iddp">
<span<?php echo $policydp_add->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($policydp_add->iddp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_iddp" name="x_iddp" value="<?php echo HtmlEncode($policydp_add->iddp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_policydp_iddp">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_iddp"><?php echo EmptyValue(strval($policydp_add->iddp->ViewValue)) ? $Language->phrase("PleaseSelect") : $policydp_add->iddp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($policydp_add->iddp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($policydp_add->iddp->ReadOnly || $policydp_add->iddp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_iddp',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $policydp_add->iddp->Lookup->getParamTag($policydp_add, "p_x_iddp") ?>
<input type="hidden" data-table="policydp" data-field="x_iddp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $policydp_add->iddp->displayValueSeparatorAttribute() ?>" name="x_iddp" id="x_iddp" value="<?php echo $policydp_add->iddp->CurrentValue ?>"<?php echo $policydp_add->iddp->editAttributes() ?>>
</span>
<?php } ?>
<?php echo $policydp_add->iddp->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$policydp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $policydp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $policydp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$policydp_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$policydp_add->terminate();
?>