<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$policy_add = new policy_add();

// Run the page
$policy_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$policy_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpolicyadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fpolicyadd = currentForm = new ew.Form("fpolicyadd", "add");

	// Validate form
	fpolicyadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($policy_add->titlepo->Required) { ?>
				elm = this.getElements("x" + infix + "_titlepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policy_add->titlepo->caption(), $policy_add->titlepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policy_add->amountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policy_add->amountpo->caption(), $policy_add->amountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_amountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policy_add->amountpo->errorMessage()) ?>");
			<?php if ($policy_add->per->Required) { ?>
				elm = this.getElements("x" + infix + "_per");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policy_add->per->caption(), $policy_add->per->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policy_add->typepo->Required) { ?>
				elm = this.getElements("x" + infix + "_typepo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policy_add->typepo->caption(), $policy_add->typepo->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($policy_add->peramountpo->Required) { ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $policy_add->peramountpo->caption(), $policy_add->peramountpo->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_peramountpo");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($policy_add->peramountpo->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpolicyadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpolicyadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpolicyadd.lists["x_per"] = <?php echo $policy_add->per->Lookup->toClientList($policy_add) ?>;
	fpolicyadd.lists["x_per"].options = <?php echo JsonEncode($policy_add->per->options(FALSE, TRUE)) ?>;
	fpolicyadd.lists["x_typepo"] = <?php echo $policy_add->typepo->Lookup->toClientList($policy_add) ?>;
	fpolicyadd.lists["x_typepo"].options = <?php echo JsonEncode($policy_add->typepo->options(FALSE, TRUE)) ?>;
	loadjs.done("fpolicyadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $policy_add->showPageHeader(); ?>
<?php
$policy_add->showMessage();
?>
<form name="fpolicyadd" id="fpolicyadd" class="<?php echo $policy_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="policy">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$policy_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($policy_add->titlepo->Visible) { // titlepo ?>
	<div id="r_titlepo" class="form-group row">
		<label id="elh_policy_titlepo" for="x_titlepo" class="<?php echo $policy_add->LeftColumnClass ?>"><?php echo $policy_add->titlepo->caption() ?><?php echo $policy_add->titlepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policy_add->RightColumnClass ?>"><div <?php echo $policy_add->titlepo->cellAttributes() ?>>
<span id="el_policy_titlepo">
<input type="text" data-table="policy" data-field="x_titlepo" name="x_titlepo" id="x_titlepo" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($policy_add->titlepo->getPlaceHolder()) ?>" value="<?php echo $policy_add->titlepo->EditValue ?>"<?php echo $policy_add->titlepo->editAttributes() ?>>
</span>
<?php echo $policy_add->titlepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policy_add->amountpo->Visible) { // amountpo ?>
	<div id="r_amountpo" class="form-group row">
		<label id="elh_policy_amountpo" for="x_amountpo" class="<?php echo $policy_add->LeftColumnClass ?>"><?php echo $policy_add->amountpo->caption() ?><?php echo $policy_add->amountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policy_add->RightColumnClass ?>"><div <?php echo $policy_add->amountpo->cellAttributes() ?>>
<span id="el_policy_amountpo">
<input type="text" data-table="policy" data-field="x_amountpo" name="x_amountpo" id="x_amountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policy_add->amountpo->getPlaceHolder()) ?>" value="<?php echo $policy_add->amountpo->EditValue ?>"<?php echo $policy_add->amountpo->editAttributes() ?>>
</span>
<?php echo $policy_add->amountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policy_add->per->Visible) { // per ?>
	<div id="r_per" class="form-group row">
		<label id="elh_policy_per" class="<?php echo $policy_add->LeftColumnClass ?>"><?php echo $policy_add->per->caption() ?><?php echo $policy_add->per->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policy_add->RightColumnClass ?>"><div <?php echo $policy_add->per->cellAttributes() ?>>
<span id="el_policy_per">
<div id="tp_x_per" class="ew-template"><input type="radio" class="custom-control-input" data-table="policy" data-field="x_per" data-value-separator="<?php echo $policy_add->per->displayValueSeparatorAttribute() ?>" name="x_per" id="x_per" value="{value}"<?php echo $policy_add->per->editAttributes() ?>></div>
<div id="dsl_x_per" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policy_add->per->radioButtonListHtml(FALSE, "x_per") ?>
</div></div>
</span>
<?php echo $policy_add->per->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policy_add->typepo->Visible) { // typepo ?>
	<div id="r_typepo" class="form-group row">
		<label id="elh_policy_typepo" class="<?php echo $policy_add->LeftColumnClass ?>"><?php echo $policy_add->typepo->caption() ?><?php echo $policy_add->typepo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policy_add->RightColumnClass ?>"><div <?php echo $policy_add->typepo->cellAttributes() ?>>
<span id="el_policy_typepo">
<div id="tp_x_typepo" class="ew-template"><input type="radio" class="custom-control-input" data-table="policy" data-field="x_typepo" data-value-separator="<?php echo $policy_add->typepo->displayValueSeparatorAttribute() ?>" name="x_typepo" id="x_typepo" value="{value}"<?php echo $policy_add->typepo->editAttributes() ?>></div>
<div id="dsl_x_typepo" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $policy_add->typepo->radioButtonListHtml(FALSE, "x_typepo") ?>
</div></div>
</span>
<?php echo $policy_add->typepo->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($policy_add->peramountpo->Visible) { // peramountpo ?>
	<div id="r_peramountpo" class="form-group row">
		<label id="elh_policy_peramountpo" for="x_peramountpo" class="<?php echo $policy_add->LeftColumnClass ?>"><?php echo $policy_add->peramountpo->caption() ?><?php echo $policy_add->peramountpo->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $policy_add->RightColumnClass ?>"><div <?php echo $policy_add->peramountpo->cellAttributes() ?>>
<span id="el_policy_peramountpo">
<input type="text" data-table="policy" data-field="x_peramountpo" name="x_peramountpo" id="x_peramountpo" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($policy_add->peramountpo->getPlaceHolder()) ?>" value="<?php echo $policy_add->peramountpo->EditValue ?>"<?php echo $policy_add->peramountpo->editAttributes() ?>>
</span>
<?php echo $policy_add->peramountpo->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$policy_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $policy_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $policy_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$policy_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$policy_add->terminate();
?>