<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_view = new payroll_view();

// Run the page
$payroll_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$payroll_view->isExport()) { ?>
<script>
var fpayrollview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fpayrollview = currentForm = new ew.Form("fpayrollview", "view");
	loadjs.done("fpayrollview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$payroll_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $payroll_view->ExportOptions->render("body") ?>
<?php $payroll_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $payroll_view->showPageHeader(); ?>
<?php
$payroll_view->showMessage();
?>
<?php if (!$payroll_view->IsModal) { ?>
<?php if (!$payroll_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $payroll_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fpayrollview" id="fpayrollview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<input type="hidden" name="modal" value="<?php echo (int)$payroll_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($payroll_view->idpayroll->Visible) { // idpayroll ?>
	<tr id="r_idpayroll">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_idpayroll"><?php echo $payroll_view->idpayroll->caption() ?></span></td>
		<td data-name="idpayroll" <?php echo $payroll_view->idpayroll->cellAttributes() ?>>
<span id="el_payroll_idpayroll">
<span<?php echo $payroll_view->idpayroll->viewAttributes() ?>><?php echo $payroll_view->idpayroll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_descrip"><?php echo $payroll_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $payroll_view->descrip->cellAttributes() ?>>
<span id="el_payroll_descrip">
<span<?php echo $payroll_view->descrip->viewAttributes() ?>><?php echo $payroll_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->startdate->Visible) { // startdate ?>
	<tr id="r_startdate">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_startdate"><?php echo $payroll_view->startdate->caption() ?></span></td>
		<td data-name="startdate" <?php echo $payroll_view->startdate->cellAttributes() ?>>
<span id="el_payroll_startdate">
<span<?php echo $payroll_view->startdate->viewAttributes() ?>><?php echo $payroll_view->startdate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->enddate->Visible) { // enddate ?>
	<tr id="r_enddate">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_enddate"><?php echo $payroll_view->enddate->caption() ?></span></td>
		<td data-name="enddate" <?php echo $payroll_view->enddate->cellAttributes() ?>>
<span id="el_payroll_enddate">
<span<?php echo $payroll_view->enddate->viewAttributes() ?>><?php echo $payroll_view->enddate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->typequinz->Visible) { // typequinz ?>
	<tr id="r_typequinz">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_typequinz"><?php echo $payroll_view->typequinz->caption() ?></span></td>
		<td data-name="typequinz" <?php echo $payroll_view->typequinz->cellAttributes() ?>>
<span id="el_payroll_typequinz">
<span<?php echo $payroll_view->typequinz->viewAttributes() ?>><?php echo $payroll_view->typequinz->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($payroll_view->tnetpay->Visible) { // tnetpay ?>
	<tr id="r_tnetpay">
		<td class="<?php echo $payroll_view->TableLeftColumnClass ?>"><span id="elh_payroll_tnetpay"><?php echo $payroll_view->tnetpay->caption() ?></span></td>
		<td data-name="tnetpay" <?php echo $payroll_view->tnetpay->cellAttributes() ?>>
<span id="el_payroll_tnetpay">
<span<?php echo $payroll_view->tnetpay->viewAttributes() ?>><?php echo $payroll_view->tnetpay->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$payroll_view->IsModal) { ?>
<?php if (!$payroll_view->isExport()) { ?>
<?php echo $payroll_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php
	if (in_array("detailpayroll", explode(",", $payroll->getCurrentDetailTable())) && $detailpayroll->DetailView) {
?>
<?php if ($payroll->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("detailpayroll", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $payroll_view->detailpayroll_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "detailpayrollgrid.php" ?>
<?php } ?>
</form>
<?php
$payroll_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$payroll_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$payroll_view->terminate();
?>