<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_delete = new payroll_delete();

// Run the page
$payroll_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpayrolldelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fpayrolldelete = currentForm = new ew.Form("fpayrolldelete", "delete");
	loadjs.done("fpayrolldelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $payroll_delete->showPageHeader(); ?>
<?php
$payroll_delete->showMessage();
?>
<form name="fpayrolldelete" id="fpayrolldelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($payroll_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($payroll_delete->descrip->Visible) { // descrip ?>
		<th class="<?php echo $payroll_delete->descrip->headerCellClass() ?>"><span id="elh_payroll_descrip" class="payroll_descrip"><?php echo $payroll_delete->descrip->caption() ?></span></th>
<?php } ?>
<?php if ($payroll_delete->startdate->Visible) { // startdate ?>
		<th class="<?php echo $payroll_delete->startdate->headerCellClass() ?>"><span id="elh_payroll_startdate" class="payroll_startdate"><?php echo $payroll_delete->startdate->caption() ?></span></th>
<?php } ?>
<?php if ($payroll_delete->enddate->Visible) { // enddate ?>
		<th class="<?php echo $payroll_delete->enddate->headerCellClass() ?>"><span id="elh_payroll_enddate" class="payroll_enddate"><?php echo $payroll_delete->enddate->caption() ?></span></th>
<?php } ?>
<?php if ($payroll_delete->typequinz->Visible) { // typequinz ?>
		<th class="<?php echo $payroll_delete->typequinz->headerCellClass() ?>"><span id="elh_payroll_typequinz" class="payroll_typequinz"><?php echo $payroll_delete->typequinz->caption() ?></span></th>
<?php } ?>
<?php if ($payroll_delete->tnetpay->Visible) { // tnetpay ?>
		<th class="<?php echo $payroll_delete->tnetpay->headerCellClass() ?>"><span id="elh_payroll_tnetpay" class="payroll_tnetpay"><?php echo $payroll_delete->tnetpay->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$payroll_delete->RecordCount = 0;
$i = 0;
while (!$payroll_delete->Recordset->EOF) {
	$payroll_delete->RecordCount++;
	$payroll_delete->RowCount++;

	// Set row properties
	$payroll->resetAttributes();
	$payroll->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$payroll_delete->loadRowValues($payroll_delete->Recordset);

	// Render row
	$payroll_delete->renderRow();
?>
	<tr <?php echo $payroll->rowAttributes() ?>>
<?php if ($payroll_delete->descrip->Visible) { // descrip ?>
		<td <?php echo $payroll_delete->descrip->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_descrip" class="payroll_descrip">
<span<?php echo $payroll_delete->descrip->viewAttributes() ?>><?php echo $payroll_delete->descrip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payroll_delete->startdate->Visible) { // startdate ?>
		<td <?php echo $payroll_delete->startdate->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_startdate" class="payroll_startdate">
<span<?php echo $payroll_delete->startdate->viewAttributes() ?>><?php echo $payroll_delete->startdate->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payroll_delete->enddate->Visible) { // enddate ?>
		<td <?php echo $payroll_delete->enddate->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_enddate" class="payroll_enddate">
<span<?php echo $payroll_delete->enddate->viewAttributes() ?>><?php echo $payroll_delete->enddate->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payroll_delete->typequinz->Visible) { // typequinz ?>
		<td <?php echo $payroll_delete->typequinz->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_typequinz" class="payroll_typequinz">
<span<?php echo $payroll_delete->typequinz->viewAttributes() ?>><?php echo $payroll_delete->typequinz->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($payroll_delete->tnetpay->Visible) { // tnetpay ?>
		<td <?php echo $payroll_delete->tnetpay->cellAttributes() ?>>
<span id="el<?php echo $payroll_delete->RowCount ?>_payroll_tnetpay" class="payroll_tnetpay">
<span<?php echo $payroll_delete->tnetpay->viewAttributes() ?>><?php echo $payroll_delete->tnetpay->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$payroll_delete->Recordset->moveNext();
}
$payroll_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payroll_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$payroll_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$payroll_delete->terminate();
?>