<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$payroll_add = new payroll_add();

// Run the page
$payroll_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$payroll_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fpayrolladd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fpayrolladd = currentForm = new ew.Form("fpayrolladd", "add");

	// Validate form
	fpayrolladd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($payroll_add->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_add->descrip->caption(), $payroll_add->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($payroll_add->startdate->Required) { ?>
				elm = this.getElements("x" + infix + "_startdate");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_add->startdate->caption(), $payroll_add->startdate->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_startdate");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($payroll_add->startdate->errorMessage()) ?>");
			<?php if ($payroll_add->enddate->Required) { ?>
				elm = this.getElements("x" + infix + "_enddate");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_add->enddate->caption(), $payroll_add->enddate->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_enddate");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($payroll_add->enddate->errorMessage()) ?>");
			<?php if ($payroll_add->typequinz->Required) { ?>
				elm = this.getElements("x" + infix + "_typequinz");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $payroll_add->typequinz->caption(), $payroll_add->typequinz->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fpayrolladd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fpayrolladd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fpayrolladd.lists["x_typequinz"] = <?php echo $payroll_add->typequinz->Lookup->toClientList($payroll_add) ?>;
	fpayrolladd.lists["x_typequinz"].options = <?php echo JsonEncode($payroll_add->typequinz->options(FALSE, TRUE)) ?>;
	loadjs.done("fpayrolladd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $payroll_add->showPageHeader(); ?>
<?php
$payroll_add->showMessage();
?>
<form name="fpayrolladd" id="fpayrolladd" class="<?php echo $payroll_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="payroll">
<?php if ($payroll->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?php echo (int)$payroll_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($payroll_add->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_payroll_descrip" for="x_descrip" class="<?php echo $payroll_add->LeftColumnClass ?>"><?php echo $payroll_add->descrip->caption() ?><?php echo $payroll_add->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_add->RightColumnClass ?>"><div <?php echo $payroll_add->descrip->cellAttributes() ?>>
<?php if (!$payroll->isConfirm()) { ?>
<span id="el_payroll_descrip">
<input type="text" data-table="payroll" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($payroll_add->descrip->getPlaceHolder()) ?>" value="<?php echo $payroll_add->descrip->EditValue ?>"<?php echo $payroll_add->descrip->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el_payroll_descrip">
<span<?php echo $payroll_add->descrip->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($payroll_add->descrip->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="payroll" data-field="x_descrip" name="x_descrip" id="x_descrip" value="<?php echo HtmlEncode($payroll_add->descrip->FormValue) ?>">
<?php } ?>
<?php echo $payroll_add->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payroll_add->startdate->Visible) { // startdate ?>
	<div id="r_startdate" class="form-group row">
		<label id="elh_payroll_startdate" for="x_startdate" class="<?php echo $payroll_add->LeftColumnClass ?>"><?php echo $payroll_add->startdate->caption() ?><?php echo $payroll_add->startdate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_add->RightColumnClass ?>"><div <?php echo $payroll_add->startdate->cellAttributes() ?>>
<?php if (!$payroll->isConfirm()) { ?>
<span id="el_payroll_startdate">
<input type="text" data-table="payroll" data-field="x_startdate" name="x_startdate" id="x_startdate" maxlength="19" placeholder="<?php echo HtmlEncode($payroll_add->startdate->getPlaceHolder()) ?>" value="<?php echo $payroll_add->startdate->EditValue ?>"<?php echo $payroll_add->startdate->editAttributes() ?>>
<?php if (!$payroll_add->startdate->ReadOnly && !$payroll_add->startdate->Disabled && !isset($payroll_add->startdate->EditAttrs["readonly"]) && !isset($payroll_add->startdate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayrolladd", "datetimepicker"], function() {
	ew.createDateTimePicker("fpayrolladd", "x_startdate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_payroll_startdate">
<span<?php echo $payroll_add->startdate->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($payroll_add->startdate->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="payroll" data-field="x_startdate" name="x_startdate" id="x_startdate" value="<?php echo HtmlEncode($payroll_add->startdate->FormValue) ?>">
<?php } ?>
<?php echo $payroll_add->startdate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payroll_add->enddate->Visible) { // enddate ?>
	<div id="r_enddate" class="form-group row">
		<label id="elh_payroll_enddate" for="x_enddate" class="<?php echo $payroll_add->LeftColumnClass ?>"><?php echo $payroll_add->enddate->caption() ?><?php echo $payroll_add->enddate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_add->RightColumnClass ?>"><div <?php echo $payroll_add->enddate->cellAttributes() ?>>
<?php if (!$payroll->isConfirm()) { ?>
<span id="el_payroll_enddate">
<input type="text" data-table="payroll" data-field="x_enddate" name="x_enddate" id="x_enddate" maxlength="19" placeholder="<?php echo HtmlEncode($payroll_add->enddate->getPlaceHolder()) ?>" value="<?php echo $payroll_add->enddate->EditValue ?>"<?php echo $payroll_add->enddate->editAttributes() ?>>
<?php if (!$payroll_add->enddate->ReadOnly && !$payroll_add->enddate->Disabled && !isset($payroll_add->enddate->EditAttrs["readonly"]) && !isset($payroll_add->enddate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpayrolladd", "datetimepicker"], function() {
	ew.createDateTimePicker("fpayrolladd", "x_enddate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el_payroll_enddate">
<span<?php echo $payroll_add->enddate->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($payroll_add->enddate->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="payroll" data-field="x_enddate" name="x_enddate" id="x_enddate" value="<?php echo HtmlEncode($payroll_add->enddate->FormValue) ?>">
<?php } ?>
<?php echo $payroll_add->enddate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($payroll_add->typequinz->Visible) { // typequinz ?>
	<div id="r_typequinz" class="form-group row">
		<label id="elh_payroll_typequinz" class="<?php echo $payroll_add->LeftColumnClass ?>"><?php echo $payroll_add->typequinz->caption() ?><?php echo $payroll_add->typequinz->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $payroll_add->RightColumnClass ?>"><div <?php echo $payroll_add->typequinz->cellAttributes() ?>>
<?php if (!$payroll->isConfirm()) { ?>
<span id="el_payroll_typequinz">
<div id="tp_x_typequinz" class="ew-template"><input type="radio" class="custom-control-input" data-table="payroll" data-field="x_typequinz" data-value-separator="<?php echo $payroll_add->typequinz->displayValueSeparatorAttribute() ?>" name="x_typequinz" id="x_typequinz" value="{value}"<?php echo $payroll_add->typequinz->editAttributes() ?>></div>
<div id="dsl_x_typequinz" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $payroll_add->typequinz->radioButtonListHtml(FALSE, "x_typequinz") ?>
</div></div>
</span>
<?php } else { ?>
<span id="el_payroll_typequinz">
<span<?php echo $payroll_add->typequinz->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($payroll_add->typequinz->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="payroll" data-field="x_typequinz" name="x_typequinz" id="x_typequinz" value="<?php echo HtmlEncode($payroll_add->typequinz->FormValue) ?>">
<?php } ?>
<?php echo $payroll_add->typequinz->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("detailpayroll", explode(",", $payroll->getCurrentDetailTable())) && $detailpayroll->DetailAdd) {
?>
<?php if ($payroll->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("detailpayroll", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "detailpayrollgrid.php" ?>
<?php } ?>
<?php if (!$payroll_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $payroll_add->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$payroll->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" onclick="this.form.action.value='confirm';"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $payroll_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" onclick="this.form.action.value='cancel';"><?php echo $Language->phrase("CancelBtn") ?></button>
<?php } ?>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$payroll_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$payroll_add->terminate();
?>