<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$operation_view = new operation_view();

// Run the page
$operation_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$operation_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$operation_view->isExport()) { ?>
<script>
var foperationview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	foperationview = currentForm = new ew.Form("foperationview", "view");
	loadjs.done("foperationview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$operation_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $operation_view->ExportOptions->render("body") ?>
<?php $operation_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $operation_view->showPageHeader(); ?>
<?php
$operation_view->showMessage();
?>
<?php if (!$operation_view->IsModal) { ?>
<?php if (!$operation_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $operation_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="foperationview" id="foperationview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="operation">
<input type="hidden" name="modal" value="<?php echo (int)$operation_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($operation_view->idop->Visible) { // idop ?>
	<tr id="r_idop">
		<td class="<?php echo $operation_view->TableLeftColumnClass ?>"><span id="elh_operation_idop"><?php echo $operation_view->idop->caption() ?></span></td>
		<td data-name="idop" <?php echo $operation_view->idop->cellAttributes() ?>>
<span id="el_operation_idop">
<span<?php echo $operation_view->idop->viewAttributes() ?>><?php echo $operation_view->idop->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($operation_view->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $operation_view->TableLeftColumnClass ?>"><span id="elh_operation_code"><?php echo $operation_view->code->caption() ?></span></td>
		<td data-name="code" <?php echo $operation_view->code->cellAttributes() ?>>
<span id="el_operation_code">
<span<?php echo $operation_view->code->viewAttributes() ?>><?php echo $operation_view->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($operation_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $operation_view->TableLeftColumnClass ?>"><span id="elh_operation_descrip"><?php echo $operation_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $operation_view->descrip->cellAttributes() ?>>
<span id="el_operation_descrip">
<span<?php echo $operation_view->descrip->viewAttributes() ?>><?php echo $operation_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($operation_view->tauxop->Visible) { // tauxop ?>
	<tr id="r_tauxop">
		<td class="<?php echo $operation_view->TableLeftColumnClass ?>"><span id="elh_operation_tauxop"><?php echo $operation_view->tauxop->caption() ?></span></td>
		<td data-name="tauxop" <?php echo $operation_view->tauxop->cellAttributes() ?>>
<span id="el_operation_tauxop">
<span<?php echo $operation_view->tauxop->viewAttributes() ?>><?php echo $operation_view->tauxop->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$operation_view->IsModal) { ?>
<?php if (!$operation_view->isExport()) { ?>
<?php echo $operation_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$operation_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$operation_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$operation_view->terminate();
?>