<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$operation_list = new operation_list();

// Run the page
$operation_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$operation_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$operation_list->isExport()) { ?>
<script>
var foperationlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	foperationlist = currentForm = new ew.Form("foperationlist", "list");
	foperationlist.formKeyCountName = '<?php echo $operation_list->FormKeyCountName ?>';
	loadjs.done("foperationlist");
});
var foperationlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	foperationlistsrch = currentSearchForm = new ew.Form("foperationlistsrch");

	// Dynamic selection lists
	// Filters

	foperationlistsrch.filterList = <?php echo $operation_list->getFilterList() ?>;
	loadjs.done("foperationlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$operation_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($operation_list->TotalRecords > 0 && $operation_list->ExportOptions->visible()) { ?>
<?php $operation_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($operation_list->ImportOptions->visible()) { ?>
<?php $operation_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($operation_list->SearchOptions->visible()) { ?>
<?php $operation_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($operation_list->FilterOptions->visible()) { ?>
<?php $operation_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$operation_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$operation_list->isExport() && !$operation->CurrentAction) { ?>
<form name="foperationlistsrch" id="foperationlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="foperationlistsrch-search-panel" class="<?php echo $operation_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="operation">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $operation_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($operation_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($operation_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $operation_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($operation_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($operation_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($operation_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($operation_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $operation_list->showPageHeader(); ?>
<?php
$operation_list->showMessage();
?>
<?php if ($operation_list->TotalRecords > 0 || $operation->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($operation_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> operation">
<?php if (!$operation_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$operation_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $operation_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $operation_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="foperationlist" id="foperationlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="operation">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_operation" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($operation_list->TotalRecords > 0 || $operation_list->isGridEdit()) { ?>
<table id="tbl_operationlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$operation->RowType = ROWTYPE_HEADER;

// Render list options
$operation_list->renderListOptions();

// Render list options (header, left)
$operation_list->ListOptions->render("header", "left");
?>
<?php if ($operation_list->idop->Visible) { // idop ?>
	<?php if ($operation_list->SortUrl($operation_list->idop) == "") { ?>
		<th data-name="idop" class="<?php echo $operation_list->idop->headerCellClass() ?>"><div id="elh_operation_idop" class="operation_idop"><div class="ew-table-header-caption"><?php echo $operation_list->idop->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idop" class="<?php echo $operation_list->idop->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $operation_list->SortUrl($operation_list->idop) ?>', 1);"><div id="elh_operation_idop" class="operation_idop">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $operation_list->idop->caption() ?></span><span class="ew-table-header-sort"><?php if ($operation_list->idop->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($operation_list->idop->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($operation_list->code->Visible) { // code ?>
	<?php if ($operation_list->SortUrl($operation_list->code) == "") { ?>
		<th data-name="code" class="<?php echo $operation_list->code->headerCellClass() ?>"><div id="elh_operation_code" class="operation_code"><div class="ew-table-header-caption"><?php echo $operation_list->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $operation_list->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $operation_list->SortUrl($operation_list->code) ?>', 1);"><div id="elh_operation_code" class="operation_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $operation_list->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($operation_list->code->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($operation_list->code->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($operation_list->descrip->Visible) { // descrip ?>
	<?php if ($operation_list->SortUrl($operation_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $operation_list->descrip->headerCellClass() ?>"><div id="elh_operation_descrip" class="operation_descrip"><div class="ew-table-header-caption"><?php echo $operation_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $operation_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $operation_list->SortUrl($operation_list->descrip) ?>', 1);"><div id="elh_operation_descrip" class="operation_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $operation_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($operation_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($operation_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($operation_list->tauxop->Visible) { // tauxop ?>
	<?php if ($operation_list->SortUrl($operation_list->tauxop) == "") { ?>
		<th data-name="tauxop" class="<?php echo $operation_list->tauxop->headerCellClass() ?>"><div id="elh_operation_tauxop" class="operation_tauxop"><div class="ew-table-header-caption"><?php echo $operation_list->tauxop->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tauxop" class="<?php echo $operation_list->tauxop->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $operation_list->SortUrl($operation_list->tauxop) ?>', 1);"><div id="elh_operation_tauxop" class="operation_tauxop">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $operation_list->tauxop->caption() ?></span><span class="ew-table-header-sort"><?php if ($operation_list->tauxop->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($operation_list->tauxop->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$operation_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($operation_list->ExportAll && $operation_list->isExport()) {
	$operation_list->StopRecord = $operation_list->TotalRecords;
} else {

	// Set the last record to display
	if ($operation_list->TotalRecords > $operation_list->StartRecord + $operation_list->DisplayRecords - 1)
		$operation_list->StopRecord = $operation_list->StartRecord + $operation_list->DisplayRecords - 1;
	else
		$operation_list->StopRecord = $operation_list->TotalRecords;
}
$operation_list->RecordCount = $operation_list->StartRecord - 1;
if ($operation_list->Recordset && !$operation_list->Recordset->EOF) {
	$operation_list->Recordset->moveFirst();
	$selectLimit = $operation_list->UseSelectLimit;
	if (!$selectLimit && $operation_list->StartRecord > 1)
		$operation_list->Recordset->move($operation_list->StartRecord - 1);
} elseif (!$operation->AllowAddDeleteRow && $operation_list->StopRecord == 0) {
	$operation_list->StopRecord = $operation->GridAddRowCount;
}

// Initialize aggregate
$operation->RowType = ROWTYPE_AGGREGATEINIT;
$operation->resetAttributes();
$operation_list->renderRow();
while ($operation_list->RecordCount < $operation_list->StopRecord) {
	$operation_list->RecordCount++;
	if ($operation_list->RecordCount >= $operation_list->StartRecord) {
		$operation_list->RowCount++;

		// Set up key count
		$operation_list->KeyCount = $operation_list->RowIndex;

		// Init row class and style
		$operation->resetAttributes();
		$operation->CssClass = "";
		if ($operation_list->isGridAdd()) {
		} else {
			$operation_list->loadRowValues($operation_list->Recordset); // Load row values
		}
		$operation->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$operation->RowAttrs->merge(["data-rowindex" => $operation_list->RowCount, "id" => "r" . $operation_list->RowCount . "_operation", "data-rowtype" => $operation->RowType]);

		// Render row
		$operation_list->renderRow();

		// Render list options
		$operation_list->renderListOptions();
?>
	<tr <?php echo $operation->rowAttributes() ?>>
<?php

// Render list options (body, left)
$operation_list->ListOptions->render("body", "left", $operation_list->RowCount);
?>
	<?php if ($operation_list->idop->Visible) { // idop ?>
		<td data-name="idop" <?php echo $operation_list->idop->cellAttributes() ?>>
<span id="el<?php echo $operation_list->RowCount ?>_operation_idop">
<span<?php echo $operation_list->idop->viewAttributes() ?>><?php echo $operation_list->idop->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($operation_list->code->Visible) { // code ?>
		<td data-name="code" <?php echo $operation_list->code->cellAttributes() ?>>
<span id="el<?php echo $operation_list->RowCount ?>_operation_code">
<span<?php echo $operation_list->code->viewAttributes() ?>><?php echo $operation_list->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($operation_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $operation_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $operation_list->RowCount ?>_operation_descrip">
<span<?php echo $operation_list->descrip->viewAttributes() ?>><?php echo $operation_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($operation_list->tauxop->Visible) { // tauxop ?>
		<td data-name="tauxop" <?php echo $operation_list->tauxop->cellAttributes() ?>>
<span id="el<?php echo $operation_list->RowCount ?>_operation_tauxop">
<span<?php echo $operation_list->tauxop->viewAttributes() ?>><?php echo $operation_list->tauxop->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$operation_list->ListOptions->render("body", "right", $operation_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$operation_list->isGridAdd())
		$operation_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$operation->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($operation_list->Recordset)
	$operation_list->Recordset->Close();
?>
<?php if (!$operation_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$operation_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $operation_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $operation_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($operation_list->TotalRecords == 0 && !$operation->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $operation_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$operation_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$operation_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$operation_list->terminate();
?>