<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$operation_edit = new operation_edit();

// Run the page
$operation_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$operation_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var foperationedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	foperationedit = currentForm = new ew.Form("foperationedit", "edit");

	// Validate form
	foperationedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($operation_edit->idop->Required) { ?>
				elm = this.getElements("x" + infix + "_idop");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_edit->idop->caption(), $operation_edit->idop->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($operation_edit->code->Required) { ?>
				elm = this.getElements("x" + infix + "_code");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_edit->code->caption(), $operation_edit->code->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($operation_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_edit->descrip->caption(), $operation_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($operation_edit->tauxop->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxop");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_edit->tauxop->caption(), $operation_edit->tauxop->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxop");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($operation_edit->tauxop->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	foperationedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	foperationedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("foperationedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $operation_edit->showPageHeader(); ?>
<?php
$operation_edit->showMessage();
?>
<form name="foperationedit" id="foperationedit" class="<?php echo $operation_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="operation">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$operation_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($operation_edit->idop->Visible) { // idop ?>
	<div id="r_idop" class="form-group row">
		<label id="elh_operation_idop" class="<?php echo $operation_edit->LeftColumnClass ?>"><?php echo $operation_edit->idop->caption() ?><?php echo $operation_edit->idop->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_edit->RightColumnClass ?>"><div <?php echo $operation_edit->idop->cellAttributes() ?>>
<span id="el_operation_idop">
<span<?php echo $operation_edit->idop->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($operation_edit->idop->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="operation" data-field="x_idop" name="x_idop" id="x_idop" value="<?php echo HtmlEncode($operation_edit->idop->CurrentValue) ?>">
<?php echo $operation_edit->idop->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($operation_edit->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_operation_code" for="x_code" class="<?php echo $operation_edit->LeftColumnClass ?>"><?php echo $operation_edit->code->caption() ?><?php echo $operation_edit->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_edit->RightColumnClass ?>"><div <?php echo $operation_edit->code->cellAttributes() ?>>
<span id="el_operation_code">
<input type="text" data-table="operation" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($operation_edit->code->getPlaceHolder()) ?>" value="<?php echo $operation_edit->code->EditValue ?>"<?php echo $operation_edit->code->editAttributes() ?>>
</span>
<?php echo $operation_edit->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($operation_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_operation_descrip" for="x_descrip" class="<?php echo $operation_edit->LeftColumnClass ?>"><?php echo $operation_edit->descrip->caption() ?><?php echo $operation_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_edit->RightColumnClass ?>"><div <?php echo $operation_edit->descrip->cellAttributes() ?>>
<span id="el_operation_descrip">
<input type="text" data-table="operation" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($operation_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $operation_edit->descrip->EditValue ?>"<?php echo $operation_edit->descrip->editAttributes() ?>>
</span>
<?php echo $operation_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($operation_edit->tauxop->Visible) { // tauxop ?>
	<div id="r_tauxop" class="form-group row">
		<label id="elh_operation_tauxop" for="x_tauxop" class="<?php echo $operation_edit->LeftColumnClass ?>"><?php echo $operation_edit->tauxop->caption() ?><?php echo $operation_edit->tauxop->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_edit->RightColumnClass ?>"><div <?php echo $operation_edit->tauxop->cellAttributes() ?>>
<span id="el_operation_tauxop">
<input type="text" data-table="operation" data-field="x_tauxop" name="x_tauxop" id="x_tauxop" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($operation_edit->tauxop->getPlaceHolder()) ?>" value="<?php echo $operation_edit->tauxop->EditValue ?>"<?php echo $operation_edit->tauxop->editAttributes() ?>>
</span>
<?php echo $operation_edit->tauxop->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$operation_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $operation_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $operation_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$operation_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$operation_edit->terminate();
?>