<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$operation_add = new operation_add();

// Run the page
$operation_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$operation_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var foperationadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	foperationadd = currentForm = new ew.Form("foperationadd", "add");

	// Validate form
	foperationadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($operation_add->code->Required) { ?>
				elm = this.getElements("x" + infix + "_code");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_add->code->caption(), $operation_add->code->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($operation_add->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_add->descrip->caption(), $operation_add->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($operation_add->tauxop->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxop");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $operation_add->tauxop->caption(), $operation_add->tauxop->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxop");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($operation_add->tauxop->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	foperationadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	foperationadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("foperationadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $operation_add->showPageHeader(); ?>
<?php
$operation_add->showMessage();
?>
<form name="foperationadd" id="foperationadd" class="<?php echo $operation_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="operation">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$operation_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($operation_add->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_operation_code" for="x_code" class="<?php echo $operation_add->LeftColumnClass ?>"><?php echo $operation_add->code->caption() ?><?php echo $operation_add->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_add->RightColumnClass ?>"><div <?php echo $operation_add->code->cellAttributes() ?>>
<span id="el_operation_code">
<input type="text" data-table="operation" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($operation_add->code->getPlaceHolder()) ?>" value="<?php echo $operation_add->code->EditValue ?>"<?php echo $operation_add->code->editAttributes() ?>>
</span>
<?php echo $operation_add->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($operation_add->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_operation_descrip" for="x_descrip" class="<?php echo $operation_add->LeftColumnClass ?>"><?php echo $operation_add->descrip->caption() ?><?php echo $operation_add->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_add->RightColumnClass ?>"><div <?php echo $operation_add->descrip->cellAttributes() ?>>
<span id="el_operation_descrip">
<input type="text" data-table="operation" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($operation_add->descrip->getPlaceHolder()) ?>" value="<?php echo $operation_add->descrip->EditValue ?>"<?php echo $operation_add->descrip->editAttributes() ?>>
</span>
<?php echo $operation_add->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($operation_add->tauxop->Visible) { // tauxop ?>
	<div id="r_tauxop" class="form-group row">
		<label id="elh_operation_tauxop" for="x_tauxop" class="<?php echo $operation_add->LeftColumnClass ?>"><?php echo $operation_add->tauxop->caption() ?><?php echo $operation_add->tauxop->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $operation_add->RightColumnClass ?>"><div <?php echo $operation_add->tauxop->cellAttributes() ?>>
<span id="el_operation_tauxop">
<input type="text" data-table="operation" data-field="x_tauxop" name="x_tauxop" id="x_tauxop" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($operation_add->tauxop->getPlaceHolder()) ?>" value="<?php echo $operation_add->tauxop->EditValue ?>"<?php echo $operation_add->tauxop->editAttributes() ?>>
</span>
<?php echo $operation_add->tauxop->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$operation_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $operation_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $operation_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$operation_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$operation_add->terminate();
?>