/**
 * JavaScript for PHPMaker 2020
 * @license (C)2002-2020 e.World Technology Ltd.
 */
var ew = {
	PAGE_ID: "", // Page ID // To be updated in page
	RELATIVE_PATH: "", // Relative path // To be updated in page
	GENERATE_PASSWORD_UPPERCASE: true,
	GENERATE_PASSWORD_LOWERCASE: true,
	GENERATE_PASSWORD_NUMBER: true,
	GENERATE_PASSWORD_SPECIALCHARS: true,
	CONFIRM_CANCEL: true,
	ROWTYPE_ADD: 2,
	ROWTYPE_EDIT: 3,
	UNFORMAT_YEAR: 50,
	LAZY_LOAD_RETRIES: 3,
	AJAX_DELAY: 5,
	LOOKUP_DELAY: 250,
	MAX_OPTION_COUNT: 3,
	SHOW_EXPORT_DIALOG: true,
	USE_OVERLAY_SCROLLBARS: true, // For responsive tables
	language: null,
	vars: null,
	googleMaps: [],
	addOptionDialog: null,
	emailDialog: null,
	importDialog: null,
	modalDialog: null,
	modalLookupDialog: null,
	autoSuggestSettings: {
		highlight: true,
		hint: true,
		minLength: 1,
		limit: 10,
		trigger: "click",
		delay: 0,// For loading more results
		templates: { // Custom templates for Typeahead (notFound, pending, header, footer, suggestion)
			footer: '<div class="tt-footer"><a href="#" class="tt-more"></a></div>' // "footer" template
		}
	},
	lightboxSettings: {
		transition: "none",
		photo: true,
		opacity: 0.5
	},
	importUploadOptions: {
		maxFileSize: 10000000,
		maxNumberOfFiles: 10
	},
	DOMPurifyConfig: {},
	sanitize: function(str) {
		return DOMPurify.sanitize(str, this.DOMPurifyConfig);
	},
	sanitizeFn: null, // For Bootstrap Tooltips and Popovers
	PDFObjectOptions: {},
	chartJsOptions: {},
	toastTemplate: '<div class="toast" role="alert" aria-live="assertive" aria-atomic="true"><div class="toast-header"><strong class="mr-auto"></strong><button type="button" class="ml-2 mb-1 close" data-dismiss="toast" aria-label="Close"><span aria-hidden="true">&times;</span></button></div><div class="toast-body"></div></div>',
	spinnerClass: "spinner-border text-primary", // spinner-border or spinner-grow
	jsRenderHelpers: {
		/**
		 * Get JsRender template (See https://www.jsviews.com/#tagsyntax@composition for details)
		 *
		 * @param {string} selector
		 * @returns Compiled template, or HTML markup string, or name of registered template, or selector
		 */
		getTemplate: function(selector) {
			return selector;
		}
	},
	autoHideSuccessMessage: true,
	autoHideSuccessMessageDelay: 5000,
	searchOperatorChanged: function() {},
	setLanguage: function() {},
	addOptionDialogShow: function() {},
	modalLookupShow: function() {},
	importDialogShow: function() {},
	toggleSearchOperator: function() {},
	togglePassword: function() {},
	sort: function() {},
	clickMultiCheckbox: function() {},
	clearForm: function() {},
	export: function() {},
	exportWithCharts: function() {},
	setSearchType: function() {},
	emailDialogShow: function() {},
	selectAll: function() {},
	selectAllKey: function() {},
	submitAction: function() {},
	addGridRow: function() {},
	confirmDelete: function() { return false; },
	deleteGridRow: function() { return false; }
};

/**
 * Add spinner
 */
ew.addSpinner = function() {
	if (document.getElementById("ew-page-spinner"))
		return;
	var div = document.createElement("div");
	div.id ="ew-page-spinner";
	div.setAttribute("class", ew.spinnerClass);
	div.setAttribute("role", "status");
	div.innerHTML = '<span class="sr-only">' + (ew.language ? ew.language.phrase("Loading") : "Loading...") + '</span>';
	if (document.body)
		document.body.appendChild(div);
};

/**
 * Remove spinner
 */
ew.removeSpinner = function() {
	var el = document.getElementById("ew-page-spinner");
	if (el)
		el.parentNode.removeChild(el);
};

/**
 * Init grid upper/lower panel
 *
 * @param {HTMLElement} el - Element
 */
ew.initGridPanel = function(el) {
	if (el.dataset.isset)
		return;
	var html = "";
	for (var i = 0; i < el.children.length; i++) {
		html = el.children[i].innerHTML.trim();
		if (html !== "")
			break;
	}
	if (html === "")
		el.classList.add("d-none");
	el.dataset.isset = true;
};

/**
 * Init grid upper and lower panels
 */
ew.initGridPanels = function() {
	Array.prototype.forEach.call(document.querySelectorAll(".ew-grid-upper-panel, .ew-grid-lower-panel"), this.initGridPanel);
}

// Request animation frame to init grid lower and upper panels
var _initGridPanelsReq;
function _initGridPanels(timestamp) {
	ew.initGridPanels();
	_initGridPanelsReq = requestAnimationFrame(_initGridPanels);
}
_initGridPanelsReq = requestAnimationFrame(_initGridPanels);

// DOM content loaded
document.addEventListener("DOMContentLoaded", function(event) {
	ew.addSpinner();
	ew.initGridPanels();
	cancelAnimationFrame(_initGridPanelsReq);
	window.loadjs.done("dom");
});

/**
 * Overlay scrollbars options for sidebars
 */
ew.sidebarScrollbarsOptions = {
	className: "os-theme-light",
	sizeAutoCapable: true,
	scrollbars: {
		autoHide: "leave",
		clickScrolling: true
	}
};

/**
 * Init overlay scrollbars for sidebars
 */
ew.initSidebarScrollbars = function() {
	var $ = jQuery;
	if ($("body").hasClass("layout-fixed")) {
		$(".main-sidebar .sidebar").overlayScrollbars(ew.sidebarScrollbarsOptions);
		$(".control-sidebar .control-sidebar-content").overlayScrollbars(ew.sidebarScrollbarsOptions);
	}
};

// All bundle IDs
ew.bundleIds = ["dom", "head"];

/**
 * Initiate script load (async in series) and register bundle
 * @param {(string|string[])} paths - The file paths
 * @param {string} [bundleId] - The bundleId
 * @param {Function} [success] - The success callback
 */
ew.loadjs = function(paths, bundleId, success) {
	if (bundleId && bundleId != "load" && ew.bundleIds.indexOf(bundleId) == -1)
		ew.bundleIds.push(bundleId);
	paths = Array.isArray(paths) ? paths : [paths];
	var path = paths.shift();
	if (typeof path === "undefined") { // paths = [], all done
		if (typeof success === "function")
			success();
		window.loadjs.done(bundleId);
	} else if (path && (!Array.isArray(path) || path.length)) { // Valid path
		window.loadjs(path, {
			success: function() {
				ew.loadjs(paths, bundleId, success);
			},
			error: function(pathNotFound) {
				console.log("Path not found: " + pathNotFound.join(", "));
				ew.loadjs(paths, bundleId, success); // Continue
			}
		});
	} else { // Invalid path, continue
		ew.loadjs(paths, bundleId, success);
	}
};

/**
 * Initiate script load (async in series) when dependencies have been satisfied
 * @param {(string|string[])} deps - List of bundle ids
 * @param {(string|string[])} paths - The file paths
 * @param {string} [bundleId] - The bundleId
 * @param {Function} [success] - The success callback
 */
ew.ready = function(deps, paths, bundleId, success) {
	window.loadjs.ready(deps, function() {
		ew.loadjs(paths, bundleId, success);
	});
};

/**
 * Language class
 *
 * @param {Object} obj Phrases
 */
ew.Language = function(obj) {
	this.obj = obj;
	this.phrase = function(id) {
		return this.obj[id.toLowerCase()];
	};
};

/**
 * Render client side template, use the HTML in DOM and return the HTML
 *
 * @param {jQuery} tmpl Template
 * @param {Object} data Data
 * @returns HTML string
 */
ew.renderTemplate = function(tmpl, data) {
	var $ = jQuery, $tmpl = (tmpl && tmpl.render) ? tmpl : $(tmpl);
	if (!$tmpl.render)
		return;
	var args = {$template: $tmpl, data: data};
	$(document).trigger("rendertemplate", [args])
	var html = $tmpl.render(args.data, ew.jsRenderHelpers),
		method = args.$template.data("method"),
		target = args.$template.data("target");
	if (html && method && target) // Render by specified method to target
		$(html)[method](target);
	else if (html && !method && target) // No method, render as inner HTML of target
		$(target).html(html);
	else if (html && !method && !target) // No method and target, render locally
		$tmpl.parent().append(html);
	return html;
};

/**
 * Render all client side templates
 *
 * @param {*} e Event
 */
ew.renderJsTemplates = function(e) {
	var $ = jQuery, ids = {}, el = (e && e.target) ? e.target : document;
	$(el).find(".ew-js-template").sort(function (a, b) {
		a = parseInt($(a).data("seq"), 10) || 0;
		b = parseInt($(b).data("seq"), 10) || 0;
		if (a > b) {
			return 1;
		} else if(a < b) {
			return -1;
		} else {
			return 0;
		}
	}).each(function(index) {
		var $this = $(this), name = $this.data("name"), data = $this.data("data");
		if (data && typeof data == "string") {
			data = ew.vars[data] || window[data]; // Get data from ew.vars or global
			if (!data) // Data not found (e.g. no header)
				return;
		}
		if (name) {
			if (!$.render[name]) { // Render the first template of any named template only
				$.templates(name, $this.text());
				ew.renderTemplate($this, data);
			}
		} else {
			ew.renderTemplate($this, data);
		}
	});
};