/**
 * JavaScript for PHPMaker 2020
 * @license (C)2002-2020 e.World Technology Ltd.
 */
var currentPageID, currentForm, currentSearchForm, currentAdvancedSearchForm, $rowindex$ = null;

ew.IS_SCREEN_SM_MIN = window.matchMedia("(min-width: 768px)").matches; // Should matches $screen-sm-min
ew.MOBILE_DETECT = new MobileDetect(window.navigator.userAgent);
ew.IS_MOBILE = !!ew.MOBILE_DETECT.mobile();

// Charts
window.exportCharts = {}; // Per window
window.drillDownCharts = {}; // Per window

// extend() method
ew.extend = Object.assign || jQuery.extend;

// Extend
ew.extend(ew, (function($, ew) {
	var $document = $(document),
		$body = $("body"),
		currentUrl = new URL(window.location);

	// Init spinner
	ew.addSpinner();

	// Remove spinner (immediately)
	var _removeSpinner = ew.removeSpinner;

	// Remove spinner
	function removeSpinner() {
		var timer = $body.data("_spinner");
		if (timer)
			timer.cancel();
		timer = $.later(500, null, function() {
			if ($document.data("_ajax") !== true) // Ajax not running
				_removeSpinner();
		});
		$body.data("_spinner", timer);
	}

	// Forms object/function
	var forms = function(el) { // id or element
		var id = ($.isString(el)) ? el : getForm(el).id;
		return arguments.callee[id];
	}

	// Init icon tooltip
	function initIcons(e) {
		var el = (e && e.target) ? e.target : document;
		$(el).find(".ew-icon").closest("a, button").add(".ew-tooltip").tooltip({
			container: "body",
			trigger: (ew.IS_MOBILE) ? "manual" : "hover",
			placement: "bottom",
			sanitizeFn: ew.sanitizeFn
		});
	}

	// Init password options
	function initPasswordOptions(e) {
		var el = (e && e.target) ? e.target : document;
		var displayText = function(pwd) {
			return ew.language.phrase("CurrentPassword") + pwd;
		}
		if ($.fn.pStrength && typeof ew.MIN_PASSWORD_STRENGTH != "undefined") {
			$(el).find(".ew-password-strength").each(function() {
				var $this = $(this);
				if (!$this.data("pStrength"))
					$this.pStrength({
						"changeBackground": false,
						"backgrounds": [],
						"passwordValidFrom": ew.MIN_PASSWORD_STRENGTH,
						"onPasswordStrengthChanged": function(strength, percentage) {
							var $this = $(this), $pst = $("[id='" + $this.attr("data-password-strength") + "']"), // Do not use #
								$pb = $pst.find(".progress-bar");
							$pst.width($this.outerWidth());
							if ($this.val()) {
								var pct = percentage + "%";
								if (percentage < 25) {
									$pb.addClass("bg-danger").removeClass("bg-warning bg-info bg-success");
								} else if (percentage < 50) {
									$pb.addClass("bg-warning").removeClass("bg-danger bg-info bg-success");
								} else if (percentage < 75) {
									$pb.addClass("bg-info").removeClass("bg-danger bg-warning bg-success");
								} else {
									$pb.addClass("bg-success").removeClass("bg-danger bg-warning bg-info");
								}
								$pb.css("width", pct);
								if (percentage > 25)
									pct = ew.language.phrase("PasswordStrength").replace("%p", pct);
								$pb.html(pct);
								$pst.removeClass("d-none").show();
								$this.data("validated", percentage >= ew.MIN_PASSWORD_STRENGTH);
							} else {
								$pst.addClass("d-none").hide();
								$this.data("validated", false);
							}
						}
					});
			});
		}
		if ($.fn.pGenerator) {
			$(el).find(".ew-password-generator").each(function() {
				var $this = $(this);
				if (!$this.data("pGenerator"))
					$this.pGenerator({
						"passwordLength": ew.GENERATE_PASSWORD_LENGTH,
						"uppercase": ew.GENERATE_PASSWORD_UPPERCASE,
						"lowercase": ew.GENERATE_PASSWORD_LOWERCASE,
						"numbers": ew.GENERATE_PASSWORD_NUMBER,
						"specialChars": ew.GENERATE_PASSWORD_SPECIALCHARS,
						"onPasswordGenerated": function(pwd) {
							var $this = $(this);
							$("#" + $this.attr("data-password-field")).val(pwd).change().focus().triggerHandler("click"); // Trigger click to remove "is-invalid" class (Do not use $this.data)
							$("#" + $this.attr("data-password-confirm")).val(pwd);
							$("#" + $this.attr("data-password-strength")).addClass("d-none").hide();
						}
					});
			});
		}
	}

	// Get API action URL
	function getApiUrl(action, query) {
		var url = ew.RELATIVE_PATH + ew.API_URL, params = new URLSearchParams(query);
		if (ew.USE_URL_REWRITE) {
			if ($.isString(action)) { // Route as string
				url += action ? action : "";
			} else if ($.isArray(action)) { // Route as array
				var route = action.map(function(v) {
					return encodeURIComponent(v);
				}).join("/");
				url += route ? route : "";
			}
		} else {
			if (action)
				params.set(ew.API_ACTION_NAME, action);
		}
		var qs = params.toString();
		return url + (qs ? "?" + qs : "");
	}

	// Set session timer
	function setSessionTimer() {
		var timeoutTime, timer1, timer2, timer3, counter, $dlg = $("#ew-timer"),
			useKeepAlive = (ew.SESSION_KEEP_ALIVE_INTERVAL > 0 || ew.IS_LOGGEDIN && ew.IS_AUTOLOGIN);
		// Keep alive
		var keepAlive =	function() {
			$.get(getApiUrl(ew.API_SESSION_ACTION), { "rnd": random() }, function(token) {
				ew.ANTIFORGERY_TOKEN = token;
				$("input:hidden[name=" + ew.TOKEN_NAME + "]").val(token);
			});
		};
		// Onclick handler of modal
		$dlg.find(".modal-footer .btn-primary").click(function(e) {
			if (timer2)
				timer2.cancel(); // Clear timer2
			$dlg.modal("hide");
			keepAlive();
			if (!useKeepAlive && ew.SESSION_TIMEOUT > 0)
				setTimer();
		});
		// Reset timer
		var resetTimer = function() {
			counter = ew.SESSION_TIMEOUT_COUNTDOWN;
			timeoutTime = ew.SESSION_TIMEOUT - ew.SESSION_TIMEOUT_COUNTDOWN;
			if (timeoutTime < 0) { // Timeout now
				timeoutTime = 0;
				counter = ew.SESSION_TIMEOUT;
			}
			if (timer2)
				timer2.cancel(); // Clear timer2
			if (timer1)
				timer1.cancel(); // Clear timer1
		};
		// Timeout
		var timeout = function() {
			if (timer3)
				timer3.cancel(); // Stop keep alive
			timer2 = $.later(1000, null, function() { // Create a timer that runs every second
				if (counter > 0) {
					$dlg.find(".modal-body").html('<p class="text-danger">' + ew.language.phrase("SessionWillExpire").replace("%s", counter) + '</p>');
					$dlg.modal("show");
				} else { // Counter = 0, log out
					$dlg.find(".modal-body").html('<p class="text-danger">' + ew.language.phrase("SessionExpired") + '</p>');
					resetTimer();
					setTimeout(function() {
						$dlg.modal("hide");
						window.location = ew.TIMEOUT_URL + "?expired=1";
					}, 1000); // Redirect after 1 second
				};
				counter--;
			}, null, true); // Periodic
		};
		// Set timer
		var setTimer = function() {
			resetTimer(); // Reset timer first
			timer1 = $.later(timeoutTime * 1000, null, timeout);
		};
		if (useKeepAlive) { // Keep alive
			var keepAliveInterval = (ew.SESSION_KEEP_ALIVE_INTERVAL > 0) ? ew.SESSION_KEEP_ALIVE_INTERVAL : ew.SESSION_TIMEOUT - ew.SESSION_TIMEOUT_COUNTDOWN;
			if (keepAliveInterval <= 0) keepAliveInterval = 60;
			timer3 = $.later(keepAliveInterval * 1000, null, keepAlive, null, true); // Periodic
		} else {
			if (ew.SESSION_TIMEOUT > 0) // Set session timeout
				setTimer();
		}
	}

	// Init export links
	function initExportLinks(e) {
		var el = (e && e.target) ? e.target : document;
		$(el).find(".ew-export-link[href]:not(.ew-email):not(.ew-print):not(.ew-xml)").click(function(e) {
			var $dlg, $this = $(this), href = $this.attr("href");
			if (href && href != "#")
				fileDownload(href);
			e.preventDefault();
		});
	}

	// Init multi-select checkboxes
	function initMultiSelectCheckboxes(e) {
		var el = (e && e.target) ? e.target : document,
			$el = $(el),
			$cbs = $el.find("input[type=checkbox].ew-multi-select");
		var _update = function(id) {
			var $els = $cbs.filter("[name^='" + id + "_']"), cnt = $els.length, len = $els.filter(":checked").length;
			$els.closest("form").find("input[type=checkbox]#" + id)
				.prop("checked", len == cnt).prop("indeterminate", len != cnt && len != 0);
		};
		$cbs.click(function(e) {
			_update(this.name.split("_")[0]);
		});
		$el.find("input[type=checkbox].ew-priv:not(.ew-multi-select)").each(function() {
			_update(this.id); // Init
		});
	}

	// Download file
	function fileDownload(href, data) {
		var $dlg, $ = (window.location != window.parent.location && window.parent.jQuery) ? window.parent.jQuery : jQuery;
		$body.css("cursor", "wait");
		if (ew.SHOW_EXPORT_DIALOG) {
			$dlg = $("#ew-message-box");
			$dlg.find(".modal-body").html("<p>" + ew.language.phrase("Exporting") + "</p>");
			$dlg.find(".modal-footer button").prop("disabled", true);
			$dlg.modal("show");
		}
		var method = (data) ? "POST" : "GET";
		$.fileDownload(href, {
			httpMethod: method,
			data: data || null,
			successCallback: function(url) {
				if (ew.SHOW_EXPORT_DIALOG)
					$dlg.modal("hide");
				$document.trigger("export", [{ "type": "done", "url": url }]);
			},
			failCallback: function(response, url) {
				if (ew.SHOW_EXPORT_DIALOG)
					$dlg.find(".modal-body").html("<div class='text-danger'><h4>" + ew.language.phrase("FailedToExport") + "</h4>" + response + "</div>");
				$document.trigger("export", [{ "type": "fail", "url": url }]);
			}
		}).always(function() {
			if (ew.SHOW_EXPORT_DIALOG)
				$dlg.find(".modal-footer button").prop("disabled", false);
			$body.css("cursor", "default");
			$document.trigger("export", [{ "type": "always", "url": href }]);
		});
	}

	// Lazy load images
	function lazyLoad(e) {
		if (!ew.LAZY_LOAD)
			return;
		var el = (e && e.target) ? e.target : document, $el = $(el),
			$els = $el.find("img.ew-lazy"), bundleIds = [];
		$els.each(function(index) {
			var self = this, $self = $(self), src = $self.data("src"), bundleId = ($el.attr("id") || "") +  "lazyload" + random();
			bundleIds.push(bundleId);
			loadjs("img!" + src, bundleId, {
				success: function() {
					self.src = src;
				},
				numRetries: ew.LAZY_LOAD_RETRIES
			});
		});
		loadjs.ready(bundleIds, function() {
			$document.trigger("lazyload"); // All images loaded
		});
	}

	// Colorboxes
	function initLightboxes(e) {
		if (!ew.USE_COLORBOX)
			return;
		var el = (e && e.target) ? e.target : document;
		var settings = ew.extend({}, ew.lightboxSettings, {
			title: ew.language.phrase("LightboxTitle"),
			current: ew.language.phrase("LightboxCurrent"),
			previous: ew.language.phrase("LightboxPrevious"),
			next: ew.language.phrase("LightboxNext"),
			close: ew.language.phrase("LightboxClose"),
			xhrError: ew.language.phrase("LightboxXhrError"),
			imgError: ew.language.phrase("LightboxImgError")
		});
		$(el).find(".ew-lightbox").each(function() {
			var $this = $(this);
			$this.colorbox(ew.extend({ rel: $this.data("rel") }, settings));
		});
	}

	// PDFObjects
	function initPdfObjects(e) {
		if (!ew.EMBED_PDF)
			return;
		var el = (e && e.target) ? e.target : document,
			options = ew.extend({}, ew.PDFObjectOptions);
		$(el).find(".ew-pdfobject").not(":has(.pdfobject)").each(function() { // Not already embedded
			var $this = $(this), url = $this.data("url"), html = $this.html();
			if (url)
				PDFObject.embed(url, this, ew.extend(options, { fallbackLink: html }));
		});
	}

	// Tooltips and popovers
	function initTooltips(e) {
		var el = (e && e.target) ? e.target : document, $el = $(el);
		$el.find("input[data-toggle=tooltip],textarea[data-toggle=tooltip],select[data-toggle=tooltip]").each(function() {
			var $this = $(this);
			$this.tooltip(ew.extend({ html: true, placement: "bottom", sanitizeFn: ew.sanitizeFn }, $this.data()));
		});
		$el.find("a.ew-tooltip-link").each(tooltip); // Init tooltips
		$el.find(".ew-tooltip").tooltip({ placement: "bottom", sanitizeFn: ew.sanitizeFn });
		$el.find(".ew-popover").popover({ sanitizeFn: ew.sanitizeFn });
	}

	// Parse JSON
	function parseJson(data) {
		if ($.isString(data)) {
			try {
				return JSON.parse(data);
			} catch(e) {
				return undefined;
			}
		}
		return data;
	}

	// Form class
	function Form(id, pageId) {
		var self = this,
			_initiated = false;

		this.id = id; // Same ID as the form
		this.pageId = pageId;
		this.$element = null;
		this._form = null; // HTML form
		this.initSearchPanel = false; // Expanded by default
		this.modified = false;
		this.validateRequired = true;
		this.validate = null;
		this.emptyRow = null; // Check empty row
		this.multiPage = null; // Multi-page
		this.autoSuggests = {}; // AutoSuggests

		// Disable form
		this.disableForm = function() {
			var form = this.getForm();
			$(form).find(":submit:not(.dropdown-toggle)").prop("disabled", true).addClass("disabled");
		}

		// Enable form
		this.enableForm = function() {
			var form = this.getForm();
			$(form).find(":submit:not(.dropdown-toggle)").prop("disabled", false).removeClass("disabled");
		}

		// Append hidden element with form name
		this.appendHidden = function(el) {
			var form = this.getForm(), $form = $(form), $dp = $(el).closest(".ew-form"), name = $dp.attr("id") + "$" + el.name;
			if ($form.find("input:hidden[name='" + name + "']")[0]) // Already appended
				return;
			var ar = $dp.find('[name="' + el.name + '"]').serializeArray();
			if (ar.length) {
				ar.forEach(function(o, i) {
					$('<input type="hidden" name="' + name + '">').val(o.value).appendTo($form);
				});
			} else {
				$('<input type="hidden" name="' + name + '">').val("").appendTo($form);
			}
		}

		// Can submit
		this.canSubmit = function() {
			var form = this.getForm(), $form = $(form);
			this.disableForm();
			this.updateTextArea();
			if (!this.validate || this.validate() && !$form.find(".is-invalid")[0]) {
				$form.find("input[name^=sv_], input[name^=p_], .ew-template input") // Do not submit these values
					.prop("disabled", true);
				$form.find("[data-readonly=1][disabled]").prop("disabled", false); // Submit readonly values
				var $dps = $($form.find("input[name='detailpage']").map(function(i, el) {
					return $form.find("#" + el.value).get();
				}));
				if ($dps.length > 1) { // Multiple Master/Detail, check element names
					$dps.each(function(i, dp) {
						$(dp).find(":input").each(function(j, el) {
							if (/^(fn_)?(x|o)\d*_/.test(el.name)) {
								var $els = $dps.not(dp).find(":input[name='" + el.name + "']");
								if ($els.length) { // Elements with same name found
									self.appendHidden(el); // Append element with form name
									$els.each(function() {
										self.appendHidden(this); // Append elements with same name and form name
									});
								}
							}
						});
					});
				}
				return true;
			} else {
				this.enableForm();
			}
			return false;
		}

		// Submit
		this.submit = function(action) {
			var form = this.getForm();
			if (this.canSubmit()) {
				if (action)
					form.action = action;
				form.submit();
			}
			return false;
		}

		// Dynamic selection lists
		this.lists = function(name) {
			name = name.replace(/^[xy](\d*|\$rowindex\$)_/, "x_"); // Fix element name prefix
			return this.lists[name];
		}

		// Compile templates
		this.compileTemplates = function() {
			for (var id in this.lists) {
				var list = this.lists[id];
				if (list.template && $.isString(list.template))
					list.template = $.templates(list.template);
			}
		}

		// Get the HTML form object
		this.getForm = function() {
			if (!this._form) {
				this.$element = $("#" + this.id);
				if (this.$element.is("form")) { // HTML form
					this._form = this.$element[0];
				} else if (this.$element.is("div")) { // HTML div => Grid page
					this._form = this.$element.closest("form")[0];
				}
			}
			return this._form;
		}

		// Get form element as single element
		this.getElement = function(name) {
			if (!this.$element)
				this.$element = $("#" + this.id);
			return (name) ? getElement(name, this.$element) : this.$element[0];
		}

		// Get form element(s) as single element or array of radio/checkbox
		this.getElements = function(name) {
			if (!this.$element)
				this.$element = $("#" + this.id);
			var selector = "[name='" + name + "']";
			selector = "input" + selector + ",select" + selector + ",textarea" + selector + ",button" + selector;
			var $els = this.$element.find(selector);
			return ($els.length == 0) ? null : ($els.length == 1 && $els.is(":not([type=checkbox]):not([type=radio])")) ? $els[0] : $els.get();
		}

		/**
		 * Update selection lists
		 *
		 * @param {(null|undefined|number)*} rowindex Row index
		 * @returns
		 */
		this.updateLists = function(rowindex) {
			if (rowindex === $rowindex$) // null
				return;
			var form = this.getForm(), // Set up $element and _form
				withIndex = !$.isUndefined(rowindex),
				confirm = form.querySelector("input#confirm");
			if (confirm && confirm.value == "confirm") { // Confirm page
				removeSpinner();
				return;
			}
			var _fixIndex = function(id) {
				return (withIndex) ? id.replace(/^x_/, "x" + rowindex + "_") : id;
			};
			var selector = Object.keys(this.lists).map(function(id) {
				return "[name='" + _fixIndex(id) + "']";
			}).join();
			if (!selector || !form.querySelector(selector)) { // Lists not found
				removeSpinner();
				return;
			}
			var actions = [], promises = [];
			this.compileTemplates(); // For grid where updateList() called before init()
			for (var id in this.lists) {
				var parents = this.lists[id].parentFields.slice(); // Clone
				var ajax = this.lists[id].ajax;
				if (withIndex) {
					id = _fixIndex(id);
					for (var i = 0, len = parents.length; i < len; i++)
						parents[i] = _fixIndex(parents[i]);
				}
				if ($.isBoolean(ajax)) { // Ajax
					var pvalues = parents.map(function(parent) {
						return getOptionValues(parent, form); // Save the initial values of the parent lists
					});
					actions.push([id, pvalues, ajax, false]);
				} else { // Non-Ajax
					updateOptions.call(this, id, parents, null, false);
				}
			}
			// Update the Ajax lists
			for (var i = 0; i < actions.length; i++) {
				promises.push(new Promise(function(resolve, reject) {
					setTimeout(function() {
						resolve(updateOptions.apply(self, actions.shift()));
					}, ew.AJAX_DELAY * i); // Delay a little in case of large number of lists
				}));
			}
			Promise.all(promises).then(function() {
				$document.trigger("updatedone", [{source: self, target: form}]);
			}).catch(function(error) {
				console.log(error);
			});
		}

		// Create AutoSuggest
		this.createAutoSuggest = function(settings) {
			var id = settings.id;
			settings.form = this;
			var options = ew.extend({}, ew.autoSuggestSettings, { limit: ew.AUTO_SUGGEST_MAX_ENTRIES }, settings); // Global settings + field specific settings
			var nid = id.replace(/^[xy](\d*|\$rowindex\$)_/, "x_");
			var data = ew.extend({}, self.lists[nid], { options: null, template: null });
			if (!(self.autoSuggests[id] instanceof AutoSuggest))
				options.data = data;
			self.autoSuggests[id] = new AutoSuggest(options);
		}

		// Init editors
		this.initEditors = function() {
			var form = this.getForm();
			$(form.elements).filter("textarea.editor").each(function(i, el) {
				var ed = $(el).data("editor");
				if (ed && !ed.active && !ed.name.includes("$rowindex$"))
					ed.create();
			});
		}

		// Update textareas
		this.updateTextArea = function(name) {
			var form = this.getForm();
			$(form.elements).filter("textarea.editor").each(function(i, el) {
				var ed = $(el).data("editor");
				if (!ed || name && ed.name != name)
					return true; // Continue
				ed.save();
				if (name)
					return false; // Break
			});
		}

		// Destroy editor(s)
		this.destroyEditor = function(name) {
			var form = this.getForm();
			$(form.elements).filter("textarea.editor").each(function(i, el) {
				var ed = $(el).data("editor");
				if (!ed || name && ed.name != name)
					return true; // Continue
				ed.destroy();
				if (name)
					return false; // Break
			});
		}

		// Show error message
		this.onError = function(el, msg) {
			return onError(this, el, msg);
		}

		// Init file upload
		this.initUpload = function() {
			var form = this.getForm();
			$(form.elements).filter("input:file:not([name*='$rowindex$'],[id='importfiles'])").each(function(index) {
				$.later(ew.AJAX_DELAY * index, null, upload, this); // Delay a little in case of large number of upload fields
			});
		}

		// Set up filters
		this.setupFilters = function(e, filters) {
			var id = this.id, data = this.filterList ? this.filterList.data : null, $sf = $(".ew-save-filter[data-form=" + id + "]").toggleClass("disabled", !data),
				$df = $(".ew-delete-filter[data-form=" + id + "]").toggleClass("disabled", !filters.length).toggleClass("dropdown-toggle", !!filters.length),
				$delete = $df.parent("li").toggleClass("dropdown-submenu dropdown-hover", !!filters.length).toggleClass("disabled", !filters.length),
				$save = $sf.parent("li").toggleClass("disabled", !data),
				$btn = $(e.target);
			var saveFilters = function(id, filters) {
				if (ew.SEARCH_FILTER_OPTION == "Client") {
					window.localStorage.setItem(id + "_filters", JSON.stringify(filters));
				} else if (ew.SEARCH_FILTER_OPTION == "Server") {
					$body.css("cursor", "wait");
					$.ajax(currentPage(), {
						type: "POST",
						dataType: "json",
						data: { "ajax": "savefilters", "filters": JSON.stringify(filters) }
					}).done(function(result) {
						if (result[0] && result[0].success)
							self.filterList.filters = filters; // Save filters
					}).always(function() {
						$body.css("cursor", "default");
					});
				}
			}
			$save.off("click.ew").on("click.ew", function(e) { // Save filter
				if ($save.hasClass("disabled"))
					return false;
				_prompt(ew.language.phrase("EnterFilterName"), function(name) {
					filters.push([name, data]);
					saveFilters(id, filters);
				}, true);
			}).prevAll().remove();
			$df.next("ul.dropdown-menu").remove();
			if (filters.length) {
				var $menu = $df.closest("ul.dropdown-menu");
				var $submenu = $("<ul class='dropdown-menu'></ul>");
				for (var i in filters) {
					if (!$.isArray(filters[i]))
						continue;
					$('<li><a class="dropdown-item" data-index="' + i + '" href="#" onclick="return false;">' + filters[i][0] + '</a></li>').on("click", function(e) { // Delete
						var i = $(this).find("a[data-index]").data("index");
						_prompt(ew.language.phrase("DeleteFilterConfirm").replace("%s", filters[i][0]), function(result) {
							if (result) {
								filters.splice(i, 1);
								saveFilters(id, filters);
							}
						});
					}).appendTo($submenu);
					$('<li><a class="dropdown-item ew-filter-list" data-index="' + i + '" href="#" onclick="return false;">' + filters[i][0] + '</a></li>').insertBefore($save).on("click", function(e) {
						var i = $(this).find("a[data-index]").data("index");
						$("<form>").attr({method: "post", action: currentPage()})
							.append($("<input type='hidden'>").attr({name: "cmd", value: "resetfilter"}),
								$("<input type='hidden'>").attr({name: ew.TOKEN_NAME, value: ew.ANTIFORGERY_TOKEN}),
								$("<input type='hidden'>").attr({name: "filter", value: JSON.stringify(filters[i][1])}))
							.appendTo("body").submit();
					});
				}
				$("<li class='dropdown-divider'></li>").insertBefore($save);
				$delete.append($submenu);
			}
		}

		// Init form
		this.init = function() {
			if (this._initiated)
				return;

			// Filters button
			if (ew.SEARCH_FILTER_OPTION == "Client" && window.localStorage || ew.SEARCH_FILTER_OPTION == "Server" && ew.IS_LOGGEDIN && !ew.IS_SYS_ADMIN && ew.CURRENT_USER_NAME != "") {
				$(".ew-filter-option." + this.id + " .ew-btn-dropdown").on("show.bs.dropdown", function(e) {
					var filters = [];
					if (ew.SEARCH_FILTER_OPTION == "Client") {
						var item = window.localStorage.getItem(self.id + "_filters");
						if (item)
							filters = parseJson(item) || [];
					} else if (ew.SEARCH_FILTER_OPTION == "Server")
						filters = self.filterList && self.filterList.filters ? self.filterList.filters : [];
					var ar = $.grep(filters, function(val) {
						if ($.isArray(val) && val.length == 2)
							return val;
					});
					self.setupFilters(e, ar);
				});
				$(".ew-filter-option").show();
			} else {
				$(".ew-filter-option").hide();
			}

			// Check form
			var form = this.getForm(), $form = $(form);
			if (!form)
				return;

			// Compile templates
			this.compileTemplates();

			// Check if Search panel
			var isSearch = /s(ea)?rch$/.test(this.id);

			// Search panel
			if (isSearch && this.initSearchPanel && !hasFormData(form))
				$("#" + this.id + "-search-panel").removeClass("show");

			// Search panel toggle
			$(".ew-search-toggle[data-form=" + this.id + "]").on("click.bs.button", function() {
				$("#" + $(this).data("form") + "-search-panel").collapse("toggle");
			});

			// Hide search operator column
			if (!$(".ew-table .ew-search-operator").text().trim())
				$(".ew-table .ew-search-operator").parent("td").hide();

			// Highlight button
			if (isSearch) {
				$(".ew-highlight[data-form=" + this.id + "]").on("click.bs.button", function() {
					$("span." + $(this).data("name")).toggleClass("ew-highlight-search");
				});
			}

			// Search operators
			if (isSearch) { // Search form
				$form.find("select[id^=z_]").each(function() {
					var $this = $(this).change();
					if ($this.val() != "BETWEEN")
						$form.find("#w_" + this.id.substr(2)).change();
				});
			}

			// Multi-page
			if (this.multiPage)
				this.multiPage.render();

			// HTML editors
			loadjs.ready(["editor"], this.initEditors.bind(this));

			// Dynamic selection lists
			this.updateLists();

			// Init file upload
			this.initUpload();

			// Submit/Cancel
			if (this.$element.is("form")) { // Not Grid page
				// Detail pages
				this.$element.find(".ew-detail-pages .ew-nav-tabs a[data-toggle=tab]").on("shown.bs.tab", function(e) {
					var $tab = $(e.target.getAttribute("href")),
						$panel = $tab.find(".table-responsive.ew-grid-middle-panel"),
						$container = $tab.closest(".container-fluid");
					if ($panel.width() >= $container.width())
						$panel.width($container.width() + "px");
					else
						$panel.width("auto");
				});
				$form.submit(function(e) { // Bind submit event
					return self.submit();
				});
				$form.find("[data-field], .ew-priv").change(function() {
					if (ew.CONFIRM_CANCEL)
						self.modified = true;
				});
				$form.find("#btn-cancel[data-href]").click(function() { // Cancel
					self.updateTextArea();
					var href = $(this).data("href");
					if (self.modified && hasFormData(form)) {
						_prompt(ew.language.phrase("ConfirmCancel"), function(result) {
							if (result)
								window.location = href;
						});
					} else {
						window.location = href;
					}
				});
			}

			this._initiated = true;

			// Store form object as data
			this.$element.data("form", this);
		}

		// Add to the global forms object
		forms[this.id] = this;
	}

	// Change search operator
	function searchOperatorChanged(el) {
		var $el = $(el), $p = $el.closest("[id^=r_], [id^=xsc_]"), parm = el.id.substr(2),
			$fld = $p.find(".ew-search-field"), $x = $fld.find("[name='x_" + parm + "'], [name='x_" + parm + "[]']"),
			$fld2 = $p.find(".ew-search-field2"), $y = $fld2.find("[name='y_" + parm + "'], [name='y_" + parm + "[]']"), hasY = $y.length,
			$cond = $p.find(".ew-search-cond"), hasCond = $cond.length, // Has condition and operator 2
			$and = $p.find(".ew-search-and"),
			$opr = $p.find(".ew-search-operator"), opr = $opr.find("[name='z_" + parm + "']").val(),
			$opr2 = $p.find(".ew-search-operator2"), opr2 = $opr2.find("[name='w_" + parm + "']").val(),
			isBetween = opr == "BETWEEN", // Can only be operator 1
			isNullOpr = ["IS NULL", "IS NOT NULL"].includes(opr), isNullOpr2 = ["IS NULL", "IS NOT NULL"].includes(opr2),
			hideOpr2 = !hasY || isBetween, hideX = isNullOpr, hideY = !isBetween && (!hasCond || isNullOpr2);
		$cond.toggleClass("d-none", hideOpr2).find(":input").prop("disabled", hideOpr2);
		$and.toggleClass("d-none", !isBetween);
		$opr2.toggleClass("d-none", hideOpr2).find(":input").prop("disabled", hideOpr2);
		$fld.toggleClass("d-none", hideX).find(":input").prop("disabled", hideX);
		$fld2.toggleClass("d-none", hideY).find(":input").prop("disabled", hideY);
	}

	// Init forms
	function initForms(e) {
		var el = (e && e.target) ? e.target : document, $el = $(el);
		for (var id in forms) {
			if ($el.find("#" + id))
				forms[id].init();
		}
	}

	// Prompt/Confirm/Alert
	function _prompt(text, cb, input) {
		var $dlg = $("#ew-prompt"), $bd = $dlg.find(".modal-body").empty();
		if (input) { // Prompt
			$bd.append('<div class="form-group row">' +
				'<label class="col-form-label">' + text + '</label>' +
				'<input type="text" class="form-control d-block w-100"></div>');
			var $input = $bd.find("input").click(function() {
				$input.removeClass("is-invalid");
			});
			$dlg.find(".modal-footer .btn-primary").off().click(function(e) { // OK button
				var val = $input.val().trim();
				if (val == "") {
					$input.addClass("is-invalid");
					$input[0].focus();
				} else {
					$dlg.modal("hide");
					if ($.isFunction(cb))
						cb(val);
				}
			});
			$dlg.on("shown.bs.modal", function(e) {
				$input[0].focus();
			});
		} else { // Confirm or Alert
			$bd.append("<div>" + text + "</div>");
			$dlg.find(".modal-footer .btn-primary").off().click(function(e) { // OK button
				$dlg.modal("hide");
				if ($.isFunction(cb))
					cb(true);
			});
			if (cb) { // Confirm
				$dlg.find(".modal-footer .btn-default").off().click(function(e) { // Cancel button
					$dlg.modal("hide");
					if ($.isFunction(cb))
						cb(false);
				}).show();
			} else { // Alert
				$dlg.find(".modal-footer .btn-default").hide();
			}
		}
		$dlg.modal("show");
	}

	// Get .ew-form element (form/div)
	function getForm(el) {
		if (el instanceof Form)
			return el.$element[0];
		var $el = $(el), $f = $el.closest(".ew-form");
		if (!$f[0]) // Element not inside form
			$f = $el.closest(".ew-grid, .ew-multi-column-grid").find(".ew-form").not(".ew-pager-form");
		return $f[0];
	}

	// Check form data
	function hasFormData(form) {
		var selector = "[name^=x_][value!='{value}'],[name^=y_],[name^=z_],[name^=w_],[name=psearch]",
			els = $(form).find(selector).filter(":enabled").get();
		for (var i = 0, len = els.length; i < len; i++) {
			var el = els[i];
			if (/^(z|w)_/.test(el.name)) {
				if (/^IS/.test($(el).val()))
					return true;
			} else if (el.type == "checkbox" || el.type == "radio") {
				if (el.checked)
					return true;
			} else if (el.type == "select-one" || el.type == "select-multiple") {
				if (!!$(el).val())
					return true;
			} else if (el.type == "text" || el.type == "hidden" || el.type == "textarea") {
				if (el.value)
					return true;
			}
		}
		return false;
	}

	// Set search type
	function setSearchType(el, val) {
		var $this = $(el), $form = $this.closest("form"), text = "";
		$form.find("input[name=psearchtype]").val(val || "");
		if (val == "=") {
			text = ew.language.phrase("QuickSearchExactShort");
		} else if (val == "AND") {
			text = ew.language.phrase("QuickSearchAllShort");
		} else if (val == "OR") {
			text = ew.language.phrase("QuickSearchAnyShort");
		} else {
			text = ew.language.phrase("QuickSearchAutoShort");
		}
		$form.find("#searchtype").html(text + ((text) ? "&nbsp;" : ""));
		$this.closest("ul").find("li").removeClass("active");
		$this.closest("li").addClass("active");
		return false;
	}

	/**
	 * Update a dynamic selection list
	 *
	 * @param {(HTMLElement|HTMLElement[]|string|string[])} obj - Target HTML element(s) or the ID of the element(s)
	 * @param {(string[]|array[])} parentId - Parent field element names or data
	 * @param {(boolean|null)} async - async(true) or sync(false) or non-Ajax(null)
	 * @param {boolean} change - Trigger onchange event
	 * @returns
	 */
	function updateOptions(obj, parentId, async, change) {
		var f = (this.$element) ? this.$element[0] : (this.form) ? this.form : null; // Get form/div element from this
		if (!f)
			return;
		var frm = (this._form) ? this : forms[f.id]; // Get Form object
		if (!frm)
			return;
		if (this.form && $.isUndefined(obj)) // Target unspecified
			obj = forms(this).lists[this.name.replace(/^(sv_)?[xy]\d*_/, "x_")].childFields.slice(); // Clone
		else if ($.isString(obj))
			obj = getElements(obj, f);
		if (!obj || $.isArray(obj) && obj.length == 0)
			return;
		var self = this, promise = Promise.resolve();
		if ($.isArray(obj) && $.isString(obj[0])) { // Array of id (onchange/onclick event)
			for (var i = 0, len = obj.length; i < len; i++) {
				var ar = obj[i].split(" ");
				if (ar.length == 1 && self.form) { // Parent/Child fields in the same table
					var m = getId(self, false).match(/^([xy]\d*_)/);
					if (m)
						obj[i] = obj[i].replace(/^([xy]\d*_)/, m[1]);
				}
				var el = getElements(obj[i], f), names = [];
				if (ar.length == 2 && $.isArray(el)) { // Check if id is "tblvar fldvar" and multiple inputs
					var $el = $(el);
					$el.each(function() {
						if (!names.includes(this.name)) {
							names.push(this.name);
							var $elf = $el.filter("[name='" + this.name + "']"), typ = $elf.attr("type"),
								elf = ["radio", "checkbox"].includes(typ) ? $elf.get() : $elf[0];
							promise = promise.then(_updateOptions.bind(self, elf, parentId, async, change));
						}
					});
				} else {
					promise = promise.then(_updateOptions.bind(self, el, parentId, async, change));
				}
			}
			var list = forms(self).lists[self.name.replace(/^[xy]\d*_/, "x_")];
			if (list && $.isArray(list.autoFillTargetFields) && list.autoFillTargetFields[0]) // AutoFill
				promise = promise.then(autoFill.bind(null, self));
		} else {
			promise = promise.then(_updateOptions.bind(self, obj, parentId, async, change));
		}
		return promise.then(function() { $document.trigger("updatedone", [{ source: self, target: obj }]); });
	}

	/**
	 * Update a dynamic selection list
	 *
	 * @param {(HTMLElement|HTMLElement[]} obj - Target HTML element(s) or the ID of the element(s)
	 * @param {(string[]|array[])} parentId - Parent field element names or data
	 * @param {(boolean|null)} async - async(true) or sync(false) or non-Ajax(null)
	 * @param {boolean} change - Trigger onchange event
	 * @returns Promise
	 */
	function _updateOptions(obj, parentId, async, change) {
		var self = this,
			args = $.makeArray(arguments),
			ar = getOptionValues(obj),
			oid = getId(obj, false);
		if (!oid)
			return;
		var fo = getForm(obj); // Get form/div element from obj
		if (!fo || !fo.id)
			return;
		var frmo = forms[fo.id];
		if (!frmo)
			return;
		var m = oid.match(/^([xy])(\d*)_/),
			prefix = (m) ? m[1] : "",
			rowindex = (m) ? m[2] : "",
			nid = oid.replace(/^([xy])(\d*)_/, "x_"),
			arp = [],
			list = frmo.lists[nid];
		if ($.isUndefined(parentId)) { // Parent IDs not specified, use default
			parentId = list.parentFields.slice(); // Clone
			if (rowindex != "") {
				for (var i = 0, len = parentId.length; i < len; i++) {
					var arr = parentId[i].split(" ");
					if (arr.length == 1) // Parent field in the same table, add row index
						parentId[i] = parentId[i].replace(/^x_/, "x" + rowindex + "_");
				}
			}
		}
		if ($.isArray(parentId) && parentId.length > 0) {
			if ($.isArray(parentId[0])) { // Array of array => data
				arp = parentId;
			} else if ($.isString(parentId[0])) { // Array of string => Parent IDs
				for (var i = 0, len = parentId.length; i < len; i++)
					arp.push(getOptionValues(parentId[i], fo));
			}
		}
		if (!isAutoSuggest(obj)) // Do not clear Auto-Suggest
			clearOptions(obj);
		var addOpt = function(results) {
			var name = getId(obj);
			results.forEach(function(result) {
				var args = {"data": result, "parents": arp, "valid": true, "name": name, "form": fo};
				$document.trigger("addoption", [args]);
				if (args.valid)
					newOption(obj, result, fo);
			});
			if (!obj.options && obj.length) { // Radio/Checkbox list
				renderOption(obj);
				obj = getElements(oid, fo); // Update the list
			}
			selectOption(obj, ar);
			if (change !== false) {
				if (!obj.options && obj.length)
					$(obj).first().triggerHandler("click");
				else
					$(obj).first().change();
			}
		}
		if ($.isUndefined(async)) // Async not specified, use default
			async = list.ajax;
		var _updateSibling = function() { // Update the y_* element
			if (/s(ea)?rch$/.test(fo.id) && prefix == "x") { // Search form
				args[0] = oid.replace(/^x_/, "y_");
				updateOptions.apply(self, args); // args[0] is string, use updateOptions()
			}
		}
		if (!$.isBoolean(async) || $.isArray(list.options) && list.options.length > 0) { // Non-Ajax or Options loaded
			var ds = list.options;
			addOpt(ds);
			_updateSibling();
			return ds;
		} else { // Ajax
			var name = getId(obj), data = ew.extend({
				page: list.page,
				field: list.field,
				ajax: "updateoption",
				language: ew.LANGUAGE_ID,
				name: name // Name of the target element
			}, getUserParams("#p_" + oid, fo)); // Add user parameters
			if (isAutoSuggest(obj) && self._form) // Auto-Suggest (init form or auto-fill)
				data["v0"] = ar[0] ? ar[0] : random(); // Filter by the current value
			else if (isModalLookup(obj)) // Modal-Lookup
				data["v0"] = ar[0] ? ($(obj).data("multiple") ? ar.join(ew.MULTIPLE_OPTION_SEPARATOR) : ar[0]) : random(); // Filter by the current value
			for (var i = 0, cnt = arp.length; i < cnt; i++) // Filter by parent fields
				data["v" + (i + 1)] = arp[i].join(ew.MULTIPLE_OPTION_SEPARATOR);
			return $.ajax(getApiUrl(ew.API_LOOKUP_ACTION), {
					"type": "POST", "dataType": "json", "data": data, "async": async
				}).done(function(result) {
					var ds = result.records || [];
					addOpt(ds);
					_updateSibling();
					return ds;
				});
		}
	}

	// Get user parameters from id
	function getUserParams(id, root) {
		var id = id.replace(/\[\]$/, ""), o = {};
		var root = !$.isString(root) ? root : /^#/.test(root) ? root : "#" + root;
		var $els = (root) ? $(root).find(id) : $(id);
		var val = $els.val();
		if (val) {
			var params = new URLSearchParams(val);
			params.forEach(function(value, key) {
				o[key] = value;
			});
		}
		return o;
	}

	// Apply client side template to a DIV
	function applyTemplate(divId, tmplId, classId, exportType, data) { // Note: classId = fileName
		var $tmpl, args = {"data": data || {}, "id": divId, "template": tmplId, "class": classId, "export": exportType, "enabled": true};
		if ($.views && tmplId && ($tmpl = $("#" + tmplId))[0]) {
			if (!$tmpl.attr("type")) // Not script
				$tmpl.attr("type", "text/html");
			$document.trigger("rendertemplate", [args]);
			if (args.enabled)
				$("#" + divId).html($tmpl.render(args.data, ew.jsRenderHelpers));
		}
		if (exportType && exportType != "print") { // Export custom
			$(function() {
				var $meta = $("meta[http-equiv='Content-Type']"),
					html = "<html><head>",
					$div = $("#" + divId);
				if ($div.children(0).is("div[id^=ct_]")) // Remove first div tag
					$div = $div.children(0);
				if ($meta[0])
					html += "<meta http-equiv='Content-Type' content='" + $meta.attr("content") + "'>";
				if (exportType == "pdf") {
					html += "<link rel='stylesheet' type='text/css' href='" + ew.PDF_STYLESHEET_FILENAME + "'>";
				} else {
					html += "<style>" + $.ajax({async: false, type: "GET", url: ew.PROJECT_STYLESHEET_FILENAME}).responseText + "</style>";
				}
				html += "</" + "head><body>";
				$(".ew-chart-top").each(function() {
					html += $(this).html();
				});
				html += $div.html();
				$(".ew-chart-bottom").each(function() {
					html += $(this).html();
				});
				html += "</body></html>";
				var url = currentPage(),
					data = { "customexport": exportType, "data": html, "filename": args.class };
				data[ew.TOKEN_NAME] = ew.ANTIFORGERY_TOKEN;
				if (exportType == "email") {
					var str = currentUrl.searchParams.toString() + "&" + $.param(data); // Add data
					$.post(url, str, function(result) {
						showMessage(result);
					});
				} else {
					fileDownload(url, data);
				}
				if (window.location != window.parent.location && window.parent.jQuery) // In iframe
					window.parent.jQuery("body").css("cursor", "default");
			});
		}
	}

	// Toggle group
	function toggleGroup(el) {
		var $el = $(el), $tr = $el.closest("tr"), selector = "tr", level;
		for (var i = 1; i <= 6; i++) {
			var idx = (i == 1) ? "" : "-" + i;
			var data = $tr.data("group" + idx);
			if ($.isValue(data)) {
				level = i;
				if (data != "")
					selector += "[data-group" + idx + "='" + String(data).replace(/'/g, "\\'") + "']";
			}
		}
		if ($el.hasClass("icon-collapse")) { // Hide
			$(selector).slice(1).addClass("ew-rpt-grp-hide-" + level);
			$el.toggleClass("icon-expand icon-collapse");
		} else {
			$(selector).slice(1).removeClass("ew-rpt-grp-hide-" + level);
			$el.toggleClass("icon-expand icon-collapse");
		}
	}

	// Show template
	function showTemplates(classname) {
		$("script" + ((classname) ? "." + classname : "") + "[type='text/html']").each(function() {
			var $scr = $(this),
				m = $scr.html().match(/^\s*(<(td|th)[\s\S]*>[\s\S]*<\/\2>)\s*$/i);
			if (m) { // Table cells
				$scr.next().before(m[1]);
			} else {
				$(this).after($("<span></span>").addClass($scr.attr("class")).html($scr.html()));
			}
			$scr.closest(".ew-table, .ew-view-table, .ew-grid").removeClass("d-none").show();
		});
	}

	// Check if boolean value is true
	function convertToBool(value) {
		return value && ["1", "y", "t", "true"].includes(value.toLowerCase());
	}

	// Check if element value changed
	function valueChanged(fobj, infix, fld, bool) {
		var nelm = getElements("x" + infix + "_" + fld, fobj);
		var oelm = getElement("o" + infix + "_" + fld, fobj); // Hidden element
		var fnelm = getElement("fn_x" + infix + "_" + fld, fobj); // Hidden element
		if (!oelm && (!nelm || $.isArray(nelm) && nelm.length == 0))
			return false;
		var getvalue = function(obj) {
			return getOptionValues(obj).join();
		}
		if (oelm && nelm) {
			if (bool) {
				if (convertToBool(getvalue(oelm)) === convertToBool(getvalue(nelm)))
					return false;
			} else {
				var oldvalue = getvalue(oelm);
				var newvalue = (fnelm) ? getvalue(fnelm) : getvalue(nelm);
				if (oldvalue == newvalue)
					return false;
			}
		}
		return true;
	}

	// Set language
	function setLanguage(el) {
		var $el = $(el), val = $el.val() || $el.data("language");
		if (!val)
			return;
		var params = new URLSearchParams();
		currentUrl.searchParams.forEach(function(value, key) {
			params.append(key, ew.sanitize(value));
		});
		params.set("language", ew.sanitize(val));
		currentUrl.search = params.toString();
		window.location = currentUrl.toString();
	}

	/**
	 * Submit action
	 *
	 * @param {Event} e
	 * @param {Object} args - Arguments
	 * @param {HTMLElement} args.f - HTML form (default is the form of the source element)
	 * @param {string} args.url - URL to which the request is sent (default is current page)
	 * @param {Object} args.key - Key as object (for single record only)
	 * @param {string} args.msg - Confirm message
	 * @param {string} args.action - Custom action name
	 * @param {string} args.select - "single"|"s" (single record) or "multiple"|"m" (multiple records, default)
	 * @param {string} args.method - "ajax"|"a" (Ajax by HTTP POST) or "post"|"p" (HTTP POST, default)
	 * @param {Object} args.data - Object of user data that is sent to the server
	 * @param {string|callback|Object} success - Function to be called if the request succeeds, or settings for jQuery.ajax() (for Ajax only)
	 * @returns
	 */
	function submitAction(e, args) {
		var el = e.target || e.srcElement, $el = $(el),
			f = args.f || $el.closest("form")[0] || currentForm, $f = $(f),
			key = args.key, action = args.action, url = args.url || currentPage(),
			msg = args.msg, data = args.data, success = args.success,
			isPost = !args.method || sameText(args.method[0], "p"),
			isMultiple = !args.select && !args.key || args.select && sameText(args.select[0], "m");
		if (isMultiple && !$f[0])
			return false;
		if (isMultiple && !keySelected($f[0])) {
			_prompt("<p class=\"text-danger\">" + ew.language.phrase("NoRecordSelected") + "</p>");
			return false;
		}
		var _success = function(result) {
			showMessage(result);
		};
		var _submit = function() {
			if (isPost) { // Post back
				if (action) // Action
					$("<input>").attr({type: "hidden", name: "useraction", value: action}).appendTo($f);
				if ($.isObject(data)) { // User data
					for (var k in data) {
						var $input = $f.find("input[type=hidden][name='" + k + "']");
						if ($input[0])
							$input.val(data[k]);
						else
							$("<input>").attr({type: "hidden", name: k, value: data[k]}).appendTo($f);
					}
				}
				if (!isMultiple && $.isObject(key)) { // Key
					for (var k in key)
						$("<input>").attr({type: "hidden", name: k, value: key[k]}).appendTo($f);
				}
				$f.prop("action", url).submit();
				if (action) // Action
					$f.find("input[type=hidden][name=useraction]").remove(); // Remove the "useraction" element
			} else { // Ajax
				data = $.isObject(data) ? $.param(data) : $.isString(data) ? data : ""; // User data
				if (action)
					data += "&useraction=" + action + "&ajax=" + action; // Action
				if (isMultiple) // Multiple records
					data += "&" + $f.find("input[name='key_m[]']:checked").serialize(); // Keys
				else if (key) // Single record
					data += "&" + ($.isObject(key) ? $.param(key) : key); // Key
				if (success && $.isString(success))
					success = window[success];
				if ($.isFunction(success)) {
					$.post(url, data, success);
				} else if ($.isObject(success)) { // "success" is Ajax settings
					success.data = data;
					success.method = success.method || "POST";
					success.success = success.success || _success;
					$.ajax(url, success);
				} else {
					$.post(url, data, _success);
				}
			}
		};
		if (msg) {
			_prompt(msg, function(result) {
				if (result)
					_submit();
			});
		} else {
			_submit();
		}
		return false;
	}

	/**
	 * Export with selected records and/or Custom Template
	 *
	 * @param {string} f - Form ID
	 * @param {string} url - Form action
	 * @param {string} type - Export type
	 * @param {boolean} custom - Using Custom Template
	 * @param {boolean} sel - Selected records only
	 * @param {Object} fobj - email form object
	 * @returns false
	 */
	function _export(f, url, type, custom, sel, fobj) {
		if (!f)
			return false;
		var $f = $(f),
			target = $f.attr("target"),
			action = $f.attr("action"),
			cb = sel && $f.find("input[type=checkbox][name='key_m[]']")[0];
		if (cb && !keySelected(f)) {
			_alert(ew.language.phrase("NoRecordSelected"));
			return false;
		}
		if (custom) { // Use Custom Template
			$("iframe.ew-export").remove();
			if (type == "email")
				url += ("&" + $(fobj).serialize()).replace(/&export=email/i, ""); // Remove duplicate export=email
			if (cb) {
				$("<iframe>").attr("name", "ew-export-frame").addClass("ew-export d-none").appendTo($body);
				try {
					$f.append($("<input type='hidden'>").attr({name: "custom", value: "1"}))
						.attr({ "action": url, "target": "ew-export-frame" }).find("input[name=exporttype]").val(type).end().submit();
				} finally { // Reset
					$f.attr({ "target": target || "", "action": action }).find("input[name=custom]").remove();
				}
			} else {
				$("<iframe>").attr({ name: "ew-export-frame", src: url }).addClass("ew-export d-none").appendTo($body);
			}
		} else { // No Custom Template
			$f.find("input[name=exporttype]").val(type);
			if (["xml", "print"].includes(type))
				$f.submit(); // Submit the form directly
			else
				fileDownload(action, $f.serialize());
		}
		return false;
	}

	// Remove spaces
	function removeSpaces(value) {
		return (/^(<(p|br)\/?>(&nbsp;)?(<\/p>)?)?$/i.test(value.replace(/\s/g, ""))) ? "" : value;
	}

	// Check if hidden text area (HTML editor)
	function isHiddenTextArea(el) {
		var $el = $(el);
		return (el && $el.is(":hidden") && $el.data("editor"));
	}

	// Check if modal lookup
	function isModalLookup(el) {
		var $el = $(el);
		return (el && $el.is(":hidden") && $el.data("lookup"));
	}

	// Check if hidden textbox (Auto-Suggest)
	function isAutoSuggest(el) {
		var $el = $(el);
		return $el[0] && $el.is(":hidden") && $el.data("autosuggest");
	}

	// Get AutoSuggest instance
	function getAutoSuggest(el) {
		return forms(el).autoSuggests[el.id];
	}

	/**
	 * Alert
	 *
	 * @param {string} msg - Message
	 * @param {callback} cb - Callback function
	 * @param {string} type - CSS class: "muted|primary|success|info|warning|danger"
	 */
	function _alert(msg, cb, type) {
		if (ew.IS_MOBILE) {
			alert(msg.replace(/<[^>]*>/g, "")); // Remove HTML
			if (cb)
				setTimeout(cb, 100); // Focus later to make sure editors are created
		} else {
			var $dlg = $("#ew-message-box");
			$dlg.find(".modal-body").html('<p class="text-' + (type || 'danger') + '">' + msg + '</p>');
			$dlg.modal("show");
			if (cb)
				$dlg.off("hidden.bs.modal").on("hidden.bs.modal", cb);
		}
	}

	// Show error message
	function onError(frm, el, msg) {
		if (el.jquery) { // el is jQuery object
			var typ = el.attr("type");
			el = (typ == "checkbox" || typ == "radio") ? el.get() : el[0];
		}
		_alert(msg, function() {
			setFocus(el);
		});
		if (frm) {
			if (frm.multiPage) { // Multi-page
				frm.multiPage.gotoPageByElement(el);
			} else if (frm.$element.is("div")) { // Multiple Master/Detail
				var $pane = frm.$element.closest(".tab-pane");
				if ($pane[0] && !$pane.hasClass("active"))
					$pane.closest(".tabbable, .ew-nav-tabs").find("a[data-toggle=tab][href='#" + $pane.attr("id") + "']").click();
			}
		}
		return false;
	}

	// Set focus
	function setFocus(obj) {
		if (!obj)
			return;
		var $obj = $(obj);
		if (isHiddenTextArea(obj)) { // HTML editor
			return $obj.data("editor").focus();
		} else if (!obj.options && obj.length) { // Radio/Checkbox list
			obj = $obj.filter("[value!='{value}']")[0];
		} else if (isAutoSuggest(obj)) { // Auto-Suggest
			obj = getAutoSuggest(obj).input;
		}
		var $cg = $obj.closest(".form-group, [id^='el']");
		if (isModalLookup(obj)) {
			$cg.find(":button").on("click", function() {
				$cg.find(".is-invalid").removeClass("is-invalid");
			});
		} else {
			if (obj.type == "checkbox" || obj.type == "radio") {
				$obj.filter("[value!='{value}']").addClass("is-invalid").focus().one("click keypress keyup", function() {
					$cg.find(".is-invalid").removeClass("is-invalid");
				});
			} else {
				$(obj).addClass("is-invalid").focus().select().parent().one("click keypress keyup", function() {
					$cg.find(".is-invalid").removeClass("is-invalid");
				});
			}
		}
	}

	// Check if object has value
	function hasValue(obj) {
		return getOptionValues(obj).join("") != "";
	}

	// Get Ctrl key for multiple column sort
	function sort(e, url, type) {
		if (type == 2 && e.ctrlKey)
			url += "&ctrl=1";
		location = url;
		return true;
	}

	// Confirm Delete Message
	function confirmDelete(el) {
		clickDelete(el);
		_prompt(ew.language.phrase("DeleteConfirmMsg"), function(result) {
			(result && el.href) ? window.location = el.href : clearDelete(el);
		});
		return false;
	}

	// Check if any key selected // PHP
	function keySelected(f) {
		return $(f).find("input[type=checkbox][name='key_m[]']:checked", f).length > 0;
	}

	// Select all key
	function selectAllKey(cb) {
		selectAll(cb);
		var tbl = $(cb).closest(".ew-table")[0];
		if (!tbl)
			return;
		$(tbl.tBodies).each(function() {
			$(this.rows).each(function(i, r) {
				var $r = $(r);
				if ($r.is(":not(.ew-template):not(.ew-table-preview-row)")) {
					$r.data({ selected: cb.checked, checked: cb.checked });
					setColor(i, r);
				}
			});
		});
	}

	// Select all related checkboxes
	function selectAll(cb) {
		if (!cb || !cb.form)
			return;
		$(cb.form.elements).filter("input[type=checkbox][name^=" + cb.name + "_], [type=checkbox][name=" + cb.name + "]").not(cb).not(":disabled").prop("checked", cb.checked);
	}

	// Update selected checkbox
	function updateSelected(f) {
		return $(f).find("input[type=checkbox][name^=u_]:checked,input:hidden[name^=u_][value=1]").length > 0;
	}

	// Set row color
	function setColor(index, row) {
		var $row = $(row), $tbl = $row.closest(".ew-table");
		if (!$tbl[0])
			return;
		if ($row.data("selected")) {
			$row.removeClass($tbl.data("rowhighlightclass") || "ew-table-highlight-row")
				.removeClass($tbl.data("roweditclass") || "ew-table-edit-row")
				.addClass($tbl.data("rowselectclass") || "ew-table-select-row");
		} else if ([ew.ROWTYPE_ADD, ew.ROWTYPE_EDIT].includes($row.data("rowtype"))) {
			$row.removeClass($tbl.data("rowselectclass") || "ew-table-select-row")
				.removeClass($tbl.data("rowhighlightclass") || "ew-table-highlight-row")
				.addClass($tbl.data("roweditclass") || "ew-table-edit-row");
		} else {
			$row.removeClass($tbl.data("rowselectclass") || "ew-table-select-row")
				.removeClass($tbl.data("roweditclass") || "ew-table-edit-row")
				.removeClass($tbl.data("rowhighlightclass") || "ew-table-highlight-row");
		}
	}

	// Clear selected rows color
	function clearSelected(tbl) {
		$(tbl.rows).each(function(i, r) {
			var $r = $(r);
			if (!$r.data("checked") && $r.data("selected")) {
				$r.data("selected", false);
				setColor(i, r);
			}
		});
	}

	// Clear all row delete status
	function clearDelete(el) {
		var $el = $(el), tbl = $el.closest(".ew-table")[0];
		if (!tbl)
			return;
		var $tr = $el.closest(".ew-table > tbody > tr");
		$tr.siblings("[data-rowindex='" + $tr.data("rowindex") + "']").addBack().each(function(i, r) {
			var $r = $(r);
			$r.data("selected", $r.data("checked"));
		});
	}

	// Click single delete link
	function clickDelete(el) {
		var $el = $(el), tbl = $el.closest(".ew-table")[0];
		if (!tbl)
			return;
		clearSelected(tbl);
		var $tr = $el.closest(".ew-table > tbody > tr");
		$tr.siblings("[data-rowindex='" + $tr.data("rowindex") + "']").addBack().each(function(i, r) {
			$(r).data("selected", true);
			setColor(i, r);
		});
	}

	// Click multiple checkbox
	function clickMultiCheckbox(e) {
		var cb = e.target || e.srcElement, $cb = $(cb), tbl = $cb.closest(".ew-table")[0];
		if (!tbl)
			return;
		clearSelected(tbl);
		var $tr = $cb.closest(".ew-table > tbody > tr");
		$tr.siblings("[data-rowindex='" + $tr.data("rowindex") + "']").addBack().each(function(i, r) {
			$(r).data("checked", cb.checked).data("selected", cb.checked).find("input[type=checkbox][name='key_m[]']").each(function() {
				if (this != cb) this.checked = cb.checked;
			});
			setColor(i, r);
		});
		e.stopPropagation();
	}

	// Setup table
	function setupTable(index, tbl, force) {
		var $tbl = $(tbl), $rows = $(tbl.rows);
		if (!tbl || !tbl.rows || !force && $tbl.data("isset") || tbl.tBodies.length == 0)
			return;

		// Set mouse over color
		var mouseOver = function(e) {
			var $this = $(this);
			if (!$this.data("selected") && ![ew.ROWTYPE_ADD, ew.ROWTYPE_EDIT].includes($this.data("rowtype"))) {
				var $tbl = $this.closest(".ew-table");
				if (!$tbl[0])
					return;
				$this.siblings("[data-rowindex='" + $this.data("rowindex") + "']").addBack().each(function(i, r) {
					$(r).addClass($tbl.data("rowhighlightclass") || "ew-table-highlight-row");
				});
			}
		}

		// Set mouse out color
		var mouseOut = function(e) {
			var $this = $(this);
			if (!$this.data("selected") && ![ew.ROWTYPE_ADD, ew.ROWTYPE_EDIT].includes($this.data("rowtype")))
				$this.siblings("[data-rowindex='" + $this.data("rowindex") + "']").addBack().each(setColor);
		}

		// Set selected row color
		var click = function(e) {
			var $this = $(this), tbl = $this.closest(".ew-table")[0],
				$target = $(e.target);
			if (!tbl || $target.hasClass("btn") || $target.hasClass("ew-preview-row-btn") || $target.is(":input"))
				return;
			if (!$this.data("checked")) {
				var selected = $this.data("selected");
				clearSelected(tbl); // Clear all other selected rows
				$this.siblings("[data-rowindex='" + $this.data("rowindex") + "']").addBack().each(function(i, r) {
					$(r).data("selected", !selected); // Toggle
					setColor(i, r);
				});
			}
		}

		var n = $rows.filter("[data-rowindex=1]").length || $rows.filter("[data-rowindex=0]").length || 1; // Alternate color every n rows
		var rows = $rows
			.filter(":not(.ew-template)")
			.each(function() {
				$(this.cells).removeClass("ew-table-last-row").last().addClass("ew-table-last-col"); // Cell of last column
			}).get();
		var div = $tbl.parentsUntil(".ew-grid", "." + ew.RESPONSIVE_TABLE_CLASS)[0];
		if (rows.length) {
			for (var i = 1; i <= n; i++) {
				var r = rows[rows.length - i]; // Last rows
				$(r.cells).each(function() {
					if (this.rowSpan == i) // Cell of last row
						$(this).addClass("ew-table-last-row")
							.toggleClass("ew-table-border-bottom", !!div && div.clientHeight > tbl.offsetHeight);
				});
			}
		}
		var form = $tbl.closest("form")[0];
		var attach = form && $(form.elements).filter("input#action:not([value^=grid])").length > 0;
		$(tbl.tBodies[tbl.tBodies.length - 1].rows) // Use last TBODY (avoid Opera bug)
			.filter(":not(.ew-template):not(.ew-table-preview-row)")
			.each(function(i) {
				var $r = $(this);
				if (attach && !$r.data("isset")) {
					if ([ew.ROWTYPE_ADD, ew.ROWTYPE_EDIT].includes($r.data("rowtype"))) // Add/Edit row
						$r.on("mouseover", function() {this.edit = true;}).addClass("ew-table-edit-row");
					$r.on("mouseover", mouseOver).on("mouseout", mouseOut).on("click", click);
					$r.data("isset", true);
				}
				var sw = i % (2 * n) < n;
				$r.toggleClass("ew-table-row", sw).toggleClass("ew-table-alt-row", !sw);
			});
		setupGrid(index, $tbl.closest(".ew-grid")[0], force);
		$tbl.data("isset", true);
	}

	// Setup grid
	function setupGrid(index, grid, force) {
		var $grid = $(grid);
		if (!grid || !force && $grid.data("isset"))
			return;
		var multi = $grid.find("table.ew-multi-column-table").length, rowcnt;
		if (multi) {
			rowcnt = $grid.find("td[data-rowindex]").length;
		} else {
			rowcnt = $grid.find("table.ew-table > tbody:first > tr:not(.ew-table-preview-row, .ew-template)").length;
		}
		if (rowcnt == 0 && !$grid.find(".ew-grid-upper-panel, .ew-grid-lower-panel")[0])
			$grid.hide();
		// if (!$grid.find(".ew-grid-upper-panel:visible")[0])
		// 	$grid.css({"border-top-left-radius": 0, "border-top-right-radius": 0});
		// if (!$grid.find(".ew-grid-lower-panel:visible")[0])
		// 	$grid.css({"border-bottom-left-radius": 0, "border-bottom-right-radius": 0});
		if ($grid.find(".ew-grid-middle-panel:visible").hasClass(ew.RESPONSIVE_TABLE_CLASS) && $grid.width() > $(".content").width()) {
			$grid.addClass("d-flex");
			$grid.closest(".ew-detail-pages").addClass("d-block");
			$grid.closest(".ew-form").addClass("w-100");
			if (ew.USE_OVERLAY_SCROLLBARS)
				$grid.find(".ew-grid-middle-panel:not(.ew-preview-middle-panel)").overlayScrollbars(ew.sidebarScrollbarsOptions);
		}
		$grid.data("isset", true);
	}

	// Add a row to grid
	function addGridRow(el) {
		var $grid = $(el).closest(".ew-grid"),
			$tbl = $grid.find("table.ew-table").last(), $p = $tbl.parent("div"),
			$tpl = $tbl.find("tr.ew-template");
		if (!el || !$grid[0] || !$tbl[0] || !$tpl[0])
			return false;
		var $lastrow = $($tbl[0].rows).last();
		$tbl.find("td.ew-table-last-row").removeClass("ew-table-last-row");
		var $row = $tpl.clone(true, true).removeClass("ew-template");
		var $form = $grid.find("div.ew-form[id^=f][id$=grid]");
		if (!$form[0])
			$form = $grid.find("form.ew-form[id^=f][id$=list]");
		var suffix = ($form.is("div")) ? "_" + $form.attr("id") : "";
		var $elkeycnt = $form.find("#key_count" + suffix);
		var keycnt = parseInt($elkeycnt.val(), 10) + 1;
		$row.attr({ "id": "r" + keycnt + $row.attr("id").substring(2), "data-rowindex": keycnt });
		var $els = $tpl.find("script:contains('$rowindex$')"); // Get scripts with rowindex
		$row.children("td").each(function() {
			$(this).find("*").each(function() {
				$.each(this.attributes, function(i, attr) {
					attr.value = attr.value.replace(/\$rowindex\$/g, keycnt); // Replace row index
				});
			});
		});
		$row.find(".ew-icon").closest("a, button").removeData("bs.tooltip").tooltip({ container: "body", placement: "bottom", trigger: "hover", sanitizeFn: ew.sanitizeFn });
		$elkeycnt.val(keycnt).after($("<input>").attr({
			type: "hidden",
			id: "k" + keycnt + "_action" + suffix,
			name: "k" + keycnt + "_action" + suffix,
			value: "insert"
		}));
		$lastrow.after($row);
		$els.each(function() {
			addScript(this.text.replace(/\$rowindex\$/g, keycnt));
		});
		var frm = $form.data("form");
		if (frm) {
			frm.initEditors();
			frm.initUpload();
		}
		setupTable(-1, $tbl[0], true);
		$p.scrollTop($p[0].scrollHeight);
		return false;
	}

	// Delete a row from grid
	function deleteGridRow(el, infix) {
		var $el = $(el).tooltip("hide").removeData("bs.tooltip"),
			$grid = $el.closest(".ew-grid, .ew-multi-column-grid"),
			$row = $el.closest("tr, div[data-rowindex]"), $tbl = $row.closest(".ew-table");
		if (!el || !$grid[0] || !$row[0])
			return false;
		var rowidx = parseInt($row.data("rowindex"), 10);
		var $form = $grid.find("div.ew-form[id^=f][id$=grid]");
		if (!$form[0])
			$form = $grid.find("form.ew-form[id^=f][id$=list]");
		var frm = $form.data("form");
		if (!$form[0] || !frm)
			return false;
		var suffix = ($form.is("div")) ? "_" + $form.attr("id") : "";
		var keycntname = "#key_count" + suffix;
		var $elkeycnt = $form.find(keycntname);
		var _delete = function() {
			$row.remove();
			if ($grid.is(".ew-grid"))
				setupTable(-1, $tbl[0], true);
			if (rowidx > 0) {
				var $keyact = $form.find("#k" + rowidx + "_action" + suffix);
				if ($keyact[0]) {
					$keyact.val(($keyact.val() == "insert") ? "insertdelete" : "delete");
				} else {
					$form.find(keycntname).after($("<input>").attr({
						type: "hidden",
						id: "k" + rowidx + "_action" + suffix,
						name: "k" + rowidx + "_action" + suffix,
						value: "delete"
					}));
				}
			}
		};
		if ($.isFunction(frm.emptyRow) && frm.emptyRow(infix)) { // Empty row
			_delete();
		} else { // Confirm
			_prompt(ew.language.phrase("DeleteConfirmMsg"), function(result) {
				if (result)
					_delete();
			});
		}
		return false;
	}

	// HTML encode text
	function htmlEncode(text) {
		var str = String(text);
		str = str.replace(/&/g, '&amp;');
		str = str.replace(/\"/g, '&quot;');
		str = str.replace(/</g, '&lt;');
		str = str.replace(/>/g, '&gt;');
		return str;
	}

	// Clear search form
	function clearForm(form){
		$(form).find("[id^=x_],[id^=y_],[id^=n_]").each(function() {
			if (this.type == "checkbox" || this.type == "radio") {
				this.checked = false;
			} else if (this.type == "select-one") {
				this.selectedIndex = 0;
			} else if (this.type == "select-multiple") {
				$(this).find("option").prop("selected", false);
			} else if (this.type == "text" || this.type == "textarea" || this.type == "hidden" && isAutoSuggest(this)) {
				this.value = "";
				if (this.type == "hidden")
					getAutoSuggest(this).input.value = "";
			}
		});
	}

	// MultiPage class
	function MultiPage(formid) {
		var self = this;
		this.$form = null;
		this.formID = formid;
		this.pageIndex = 1;
		this.maxPageIndex = 0;
		this.minPageIndex = 0;
		this.pageIndexes = [];
		this.$pages = null;
		this.$collapses = null;
		this.isTab = false; // Is tabs
		this.isCollapse = false; // Is collapses (accordion)
		this.lastPageSubmit = false; // Enable submit button for the last page only
		this.hideDisabledButton = false; // Hide disabled submit button
		this.hideInactivePages = false; // Hide inactive pages
		this.lockTabs = false; // Set inactive tabs as disabled
		this.hideTabs = false; // Hide all tabs
		this.showPagerTop = false; // Show pager at top
		this.showPagerBottom = false; // Show pager at bottom
		this.pagerTemplate = '<nav><ul class="pagination"><li class="page-item previous ew-prev"><a href="#" class="page-link"><span class="icon-prev"></span> {Prev}</a></li><li class="page-item next ew-next"><a href="#" class="page-link">{Next} <span class="icon-next"></span></a></li></ul></nav>'; // Pager template

		// "show" handler (for disabled tabs)
		var _show = function(e) {
			e.preventDefault();
		};

		// Set properties
		var _properties = ["lastPageSubmit", "hideDisabledButton", "hideInactivePages", "lockTabs",
			"hideTabs", "showPagerTop", "showPagerBottom", "pagerTemplate"];
		this.set = function() {
			if (arguments.length == 1 && $.isObject(arguments[0])) {
				var obj = arguments[0];
				for (var i in obj) {
					var p = i[0].toLowerCase() + i.substr(1); // Camel case
					if (_properties.includes(p))
						this[p] = obj[i];
				}
			}
		}

		// DOM loaded
		this.init = function() {
			var tpl = this.pagerTemplate.replace(/\{prev\}/i, ew.language.phrase("Prev")).replace(/\{next\}/i, ew.language.phrase("Next"));
			if (this.isTab) {
				if (this.showPagerTop)
					this.$pages.closest(".tabbable, .ew-nav-tabs").before(tpl);
				if (this.showPagerBottom)
					this.$pages.closest(".tabbable, .ew-nav-tabs").after(tpl);
				this.$form.find(".ew-prev").click(function(e) {
					self.$pages.off("show.bs.tab", _show).filter(".active").parent()
						.prev(":has([data-toggle=tab]:not(.ew-hidden):not(.ew-disabled))")
						.find("[data-toggle=tab]").toggleClass("disabled d-none", false).click();
					return false;
				});
				this.$form.find(".ew-next").click(function(e) {
					self.$pages.off("show.bs.tab", _show).filter(".active").parent()
						.next(":has([data-toggle=tab]:not(.ew-hidden):not(.ew-disabled))")
						.find("[data-toggle=tab]").toggleClass("disabled d-none", false).click();
					return false;
				});
				if (this.hideTabs)
					this.$form.find(".ew-multi-page > .tabbable > .nav-tabs, .ew-multi-page > .ew-nav-tabs > .nav-tabs").hide();
			} else if (this.isCollapse) {
				if (this.showPagerTop)
					this.$collapses.closest(".ew-accordion").before(tpl);
				if (this.showPagerBottom)
					this.$collapses.closest(".ew-accordion").after(tpl);
				this.$form.find(".ew-prev").click(function(e) {
					self.$pages.closest(".card").filter(":has(.collapse.show)")
						.prev(":has([data-toggle=collapse]:not(.ew-hidden):not(.ew-disabled))")
						.toggleClass("disabled d-none", false)
						.find("[data-toggle=collapse]").click();
					return false;
				});
				this.$form.find(".ew-next").click(function(e) {
					self.$pages.closest(".card").filter(":has(.collapse.show)")
						.next(":has([data-toggle=collapse]:not(.ew-hidden):not(.ew-disabled))")
						.toggleClass("disabled d-none", false)
						.find("[data-toggle=collapse]").click();
					return false;
				});
			}
			this.pageShow();
		}

		// Page show
		this.pageShow = function() {
			if (this.isTab) {
				if (this.lockTabs)
					this.$pages.on("show.bs.tab", _show);
				this.$pages.each(function() {
					var $this = $(this);
					if (self.hideInactivePages)
						$this.toggleClass("d-none", !$this.hasClass("active"));
					if (self.lockTabs)
						$this.toggleClass("disabled", !$this.hasClass("active"));
				});
			} else if (this.isCollapse) {
				this.$pages.closest(".card").each(function() {
					var $this = $(this);
					if (self.hideInactivePages)
						$this.toggleClass("d-none", !$this.find(".collapse.show")[0]);
				});
			}
			var disabled = this.lastPageSubmit && this.pageIndex != this.maxPageIndex;
			var $btn = this.$form.closest(".content, .modal-content").find("#btn-action, button.ew-submit").prop("disabled", disabled).toggle(!this.hideDisabledButton || !disabled);
			$(".ew-captcha").toggle($btn.is(":visible:not(:disabled)")); // Re-captcha uses class "disabled", not "disabled" property.
			disabled = this.pageIndex <= this.minPageIndex;
			this.$form.find(".ew-prev").toggleClass("disabled", disabled);
			disabled = this.pageIndex >= this.maxPageIndex;
			this.$form.find(".ew-next").toggleClass("disabled", disabled);
		}

		// Go to page by index
		this.gotoPage = this.gotoPageByIndex = function(i) {
			if (i <= 0 || i < this.minPageIndex || i > this.maxPageIndex)
				return;
			if (this.pageIndex != i) {
				var $page = this.$pages.eq(i - 1);
				if (this.isTab) {
					if ($page.is(":not(.d-none):not(.disabled)"))
						$page.click();
					else
						$page.parent().next(":has([data-toggle=tab]):not(.d-none):not(.disabled)")
							.find("[data-toggle=tab]").toggleClass("disabled", false).click();
				} else if (this.isCollapse) {
					var $p = $page.closest(".card");
					if ($p.is(":not(.d-none)"))
						$page.click();
					else
						$p.next(":has([data-toggle=collapse]):not(.d-none)").find("[data-toggle=collapse]").click();
				}
				this.pageIndex = i;
			}
		}

		// Go to page by element
		this.gotoPageByElement = function(el) {
			this.gotoPage(parseInt($(el).data("page"), 10) || -1);
		}

		// Go to page by element's id or name or data-field attribute
		this.gotoPageByElementId = function(id) {
			var $el = this.$form.find("[data-page]").filter("[id='" + id + "'],[name='" + id + "'],[data-field='" + id + "']");
			this.gotoPageByElement($el);
		}

		// Toggle page
		this.togglePage = function(i, show) {
			if (this.isTab) {
				this.$pages.eq(i - 1).toggleClass("d-none", !show);
			} else if (this.isCollapse) {
				this.$pages.eq(i - 1).closest(".card").toggle("d-none", !show);
			}
		}

		// Render
		this.render = function() {
			this.$form = $("#" + formid);
			this.pageIndexes = this.$form.find("[data-page]").map(function() {
				var index = parseInt($(this).data("page"), 10);
				return (index > 0) ? index : null;
			}).get();
			this.pageIndexes.sort(function(a, b) {
				return a - b;
			});
			this.minPageIndex = this.pageIndexes[0];
			this.maxPageIndex = this.pageIndexes[this.pageIndexes.length - 1];
			var $tabs = this.$form.find("[data-toggle=tab]");
			if ($tabs[0]) {
				this.$pages = $tabs;
				this.isTab = true;
				$tabs.on("shown.bs.tab", function(e) {
					self.pageIndex = $tabs.index(e.target) + 1;
					self.pageShow();
					$($(this).attr("href")).find(".ew-google-map").each(function() {
						var m = ew.googleMaps[this.id];
						if (m && m["map"]) {
							google.maps.event.trigger(m["map"], "resize");
							m["map"].setCenter(m["latlng"]);
						}
					});
				});
				this.pageIndex = $tabs.index($tabs.parent(".active")) + 1;
			} else {
				this.$collapses = this.$form.find("[data-toggle=collapse]");
				if (this.$collapses[0]) {
					this.$pages = this.$collapses;
					this.isCollapse = true;
					var $bodies = this.$collapses.closest(".card-header").next();
					$bodies.on("shown.bs.collapse", function(e) {
						self.pageIndex = $bodies.index(e.target) + 1;
						self.pageShow();
						$(this).find(".ew-google-map").each(function() {
							var m = ew.googleMaps[this.id];
							if (m && m["map"]) {
								google.maps.event.trigger(m["map"], "resize");
								m["map"].setCenter(m["latlng"]);
							}
						});
					});
					this.pageIndex = $bodies.index($bodies.hasClass("show")) + 1;
				}
			}
			$(function() {
				self.init();
			});
		}
	}

	// Get form element(s) as single element or array of radio/checkbox
	function getElements(name, root) {
		var selector = "[name='" + name + "']";
		var ar = name.split(" "); // Check if "#id name"
		if (ar.length == 2)
			selector = "[data-table='" + ar[0] + "'][data-field='" + getId(ar[1]) + "']:not([name^=o]):not([name^='x$'])"; // Remove []
		var root = !$.isString(root) ? root : /^#/.test(root) ? root : "#" + root;
		selector = "input" + selector + ",select" + selector + ",textarea" + selector + ",button" + selector;
		var $els = (root) ? $(root).find(selector) : $(selector);
		if ($els.length == 1 && $els.is(":not([type=checkbox]):not([type=radio])"))
			return $els[0];
		return $els.get();
	}

	// Get first element (not necessarily form element)
	function getElement(name, root) {
		var root = $.isString(root) ? "#" + root : root,
			selector = "#" + name.replace(/([\$\[\]])/g, "\\$1") + ",[name='" + name + "']";
		return (root) ? $(root).find(selector)[0] : $(selector).first()[0];
	}

	// Get ancestor by function
	function getAncestorBy(node, method) {
		while (node = node.parentNode) {
			if (node && node.nodeType == 1 && (!method || method(node)))
				return node;
		}
		return null;
	}

	// Check if an element is hidden
	function isHidden(el) {
		return $(el).css("display") == "none" && !$(el).closest(".dropdown-menu")[0] && !isModalLookup(el) && !isAutoSuggest(el) && !isHiddenTextArea(el) || getAncestorBy(el, function(node) {
				var $node = $(node);
				return $node.css("display") == "none" && !$node.hasClass("tab-pane") && !$node.hasClass("collapse");
			}) != null;
	}

	// Check if same text
	function sameText(o1, o2) {
		return (String(o1).toLowerCase() == String(o2).toLowerCase());
	}

	// Check if same string
	function sameString(o1, o2) {
		return (String(o1) == String(o2));
	}

	// Get existing selected values as an array
	function getOptionValues(el, form) {
		var obj;
		if ($.isString(el)) {
			var ar = el.split(" ");
			if (ar.length == 2) { // Parent field in master table
				obj = getElements(el);
			} else {
				obj = getElements(el, form);
			}
		} else {
			obj = el;
		}
		if (obj.options) { // Selection list
			return $(obj).find("option:selected[value!='']").map(function() {
				return this.value;
			}).get();
		} else if ($.isNumber(obj.length)) { // Radio/Checkbox list, or element not found
			return $(obj).filter(":checked[value!='{value}']").map(function() {
				return this.value;
			}).get();
		} else { // text/hidden
			var data = $(obj).data();
			if (data.lookup && data.multiple) // Modal-Lookup
				return obj.value.split(ew.MULTIPLE_OPTION_SEPARATOR);
			else
				return [obj.value];
		}
	}

	// Get existing text of selected values as an array
	function getOptionTexts(el, form) {
		var obj;
		if ($.isString(el)) {
			var ar = el.split(" ");
			if (ar.length == 2) { // Parent field in master table
				obj = getElements(el);
			} else {
				obj = getElements(el, form);
			}
		} else {
			obj = el;
		}
		if (obj.options) { // Selection list
			return $(obj).find("option:selected[value!='']").map(function() {
				return this.text;
			}).get();
		} else if ($.isNumber(obj.length)) { // Radio/Checkbox list, or element not found
			return $(obj).filter(":checked[value!='{value}']").map(function() {
				return $(this).parent().text();
			}).get();
		} else if (isAutoSuggest(obj)) {
			return [getAutoSuggest(obj).input.value];
		} else if (isModalLookup(obj)) { // Modal-Lookup
			var $obj = $(obj);
			return $obj.parent().find(".ew-lookup-text .ew-option").map(function() {
				return $(this).text().trim();
			}).get();
		} else {
			return [obj.value];
		}
	}

	// Get container of radio/checkbox list
	function getContainer(obj) {
		var id = getId(obj);
		return $(obj).closest(".form-group, [id^=el][id$='" + id.replace(/^([xy]\d*_)/, '') + "']").find("#dsl_" + id);
	}

	// Clear existing options
	function clearOptions(obj) {
		if (obj.options) { // Selection list
			var lo = (obj.type == "select-multiple" || $(obj).data("pleaseselect") === false || obj.length > 0 && obj.options[0].value != "") ? 0 : 1; // multiple or data-pleaseselect="false" or non-empty first element => remove all
			for (var i = obj.length - 1; i >= lo; i--)
				obj.options[i] = null;
		} else if (obj.length) { // Radio/Checkbox list
			var id = getId(obj), $p = getContainer(obj);
			$p.data("options", []).find("div").first().empty();
		} else if (isAutoSuggest(obj)) {
			var o = getAutoSuggest(obj);
			o._options = [];
			o.input.value = "";
			obj.value = "";
		} else if (isModalLookup(obj)) { // Modal-Lookup
			$(obj).data("options", []);
		}
	}

	/**
	 * Get the name or id of an element
	 *
	 * @param {*} el - Element
	 * @param {boolean} [remove=true] - Remove square brackets
	 * @returns
	 */
	function getId(el, remove) {
		var id = ($.isString(el)) ? el : ($(el).attr("name") || $(el).attr("id")); // Use name first (id may have suffix)
		return (remove !== false) ? id.replace(/\[\]$/, "") : id;
	}

	// Get display value separator
	function valueSeparator(index, obj) {
		var sep = $(obj).data("value-separator");
		return ($.isArray(sep)) ? sep[index - 1] : (sep || ", ");
	}

	/**
	 * Get display value
	 *
	 * @param {Object} opt - Option being displayed
	 * @param {HTMLElment} obj - HTML element
	 * @returns {string} Display value
	 */
	function displayValue(opt, obj) {
		var text = opt.df;
		for (var i = 2; i <= 4; i++) {
			if (opt["df" + i] && opt["df" + i] != "") {
				var sep = valueSeparator(i - 1, obj);
				if ($.isUndefined(sep))
					break;
				if (text != "")
					text += sep;
				text += opt["df" + i];
			}
		}
		return text;
	}

	/**
	 * Get HTML for a single option
	 *
	 * @param {*} val - Value of the option
	 * @returns {string} HTML
	 */
	function optionHtml(val) {
		return ew.OPTION_HTML_TEMPLATE.replace(/\{value\}/g, val);
	}

	/**
	 * Get HTML for diplaying all options
	 *
	 * @param {string[]} options - Array of all options (HTML)
	 * @param {number} max - Maximum number of options to show
	 * @returns {string} HTML
	 */
	function optionsHtml(options, max) {
		if (options.length > (max || ew.MAX_OPTION_COUNT)) { // More than max option count
			return ew.language.phrase("CountSelected").replace("%s", options.length);
		} else if (options.length) { // Some options
			var html = "";
			for (var i = 0; i < options.length; i++)
				html += optionHtml(options[i]);
			return html;
		} else { // No options
			return ew.language.phrase("PleaseSelect");
		}
	}

	/**
	 * Create new option
	 *
	 * @param {(HTMLElement|array)} obj - Selection list
	 * @param {Object} opt - Object for the new option
	 * @param {form} f - form object of obj
	 * @returns
	 */
	function newOption(obj, opt, f) {
		var frm = forms[f.id], id = getId(obj), nid = getId(obj, false), text,
			value = opt.lf, item = { lf: opt.lf, df1: opt.df, df2: opt.df2, df3: opt.df3, df4: opt.df4 };
		if (frm.lists(nid).template && !isAutoSuggest(obj)) {
			text = frm.lists(nid).template.render(item, ew.jsRenderHelpers);
		} else {
			text = displayValue(opt, obj) || value;
		}
		var args = { "data": item, "name": id, "form": f.$element, "value": value, "text": text };
		if (obj.options) { // Selection list
			ew.extend(args, { "option": $("<option></option>").val(args.value).html(args.text) });
			$document.trigger("newoption", [args]); // Fire "newoption" event for selection list
			$(obj).append(args.option);
		} else if (obj.length) { // Radio/Checkbox list
			var $p = getContainer(obj), opts = $p.data("options"); // Parent element
			if ($p[0] && opts)
				opts.push({"val": args.value, "lbl": args.text});
		} else if (isAutoSuggest(obj)) { // Auto-Suggest
			var o = getAutoSuggest(obj);
			o._options.push({"val": args.value, "lbl": args.text});
		} else if (isModalLookup(obj)) { // Modal-Lookup
			var $obj = $(obj), opts = $obj.data("options") || [];
			opts.push({"val": args.value, "lbl": args.text});
			$obj.data("options", opts);
		}
		return args.text;
	}

	// Render the options
	function renderOption(obj) {
		var id = getId(obj), f = getForm(obj), $p = getContainer(obj);
		if (!$p[0] || !$p.data("options"))
			return;
		var $t = $p.parent().find("#tp_" + id);
		if (!$t[0])
			return;
		var cols = (!ew.IS_MOBILE) ? (parseInt($p.data("repeatcolumn"), 10) || 5) : 1;
		var $tpl = $t.contents(), opts = $p.data("options"), type = $tpl.attr("type");
		var $btn = $p.prevAll(".dropdown-toggle"), $clr = $p.closest(".ew-dropdown-list").find(".ew-dropdown-clear");
		if (opts && opts.length) {
			if (cols > 1 || type == "checkbox" || !$btn[0]) { // Use table
				var $tbl = $('<div class="d-table ew-item-table"></div>');
				if (type == "checkbox")
					$tbl.click(function(e) { e.stopPropagation(); });
				for (var i = 0, cnt = opts.length; i < cnt; i++) {
					var $tr;
					if (i % cols == 0)
						$tr = $('<div class="d-table-row"></div>');
					var $el = $tpl.clone(true).val(opts[i].val).click(function(e) {
						if ($btn[0]) {
							var $items = $tbl.find("input[name='" + this.name + "']:checked");
							var $vals = $items.map(function() {
								return $(this).parent().text();
							});
							$btn.html(optionsHtml($vals.get(), $(this).data("maxcount")));
							$clr.prop("disabled", $vals.length == 0);
						}
					});
					$el.attr("id", $el.attr("id") + "_" + i + "_" + random()); // Note: Make sure ID is unique
					var $lbl = $('<label class="custom-control-label"></label>').attr("for", $el.attr("id")).append(opts[i].lbl);
					var args = {"name": id, "form": f, "value": opts[i].val, "text": opts[i].lbl, "option": $('<div class="custom-control custom-' + type + '"></div>').append($el.add($lbl))};
					$document.trigger("newoption", [args]); // Fire "newoption" event for radio/checkbox list
					$('<div class="d-table-cell"></div>').append(args.option).appendTo($tr);
					if (i % cols == cols - 1) {
						$tbl.append($tr);
					} else if (i == cnt - 1) { // Last
						for (var j = (i % cols) + 1; j < cols; j++)
							$tr.append('<div class="d-table-cell"></div>');
						$tbl.append($tr);
					}
				}
				$p.find("div").first().append($tbl);
			} else { // Single column dropdown radio buttons => Use list group
				var $div = $('<div class="list-group"></div>');
				for (var i = 0, cnt = opts.length; i < cnt; i++) {
					var $el = $tpl.clone(true).val(opts[i].val).click(function(e) {
						var $li = $(this).closest(".list-group-item");
						if ($li.hasClass("active"))
							this.checked = false;
						$li.siblings(".list-group-item").removeClass("active");
						$li.toggleClass("active", this.checked);
						$btn.html(this.checked ? $li.text() : ew.language.phrase("PleaseSelect"));
						$clr.prop("disabled", !this.checked);
					});
					$el.attr("id", $el.attr("id") + "_" + i + "_" + random()); // Note: Make sure ID is unique
					var $lbl = $('<label class="custom-control-label"></label>').attr("for", $el.attr("id")).append(opts[i].lbl);
					var $opt = $('<a class="list-group-item list-group-item-action" href="#"></a>').append($el, $lbl);
					var args = {"name": id, "form": f, "value": opts[i].val, "text": opts[i].lbl, "option": $opt};
					$document.trigger("newoption", [args]); // Fire "newoption" event for radio list
					$div.append(args.option);
				}
				$p.find("div").first().append($div);
			}
			$clr.prop("disabled", $btn && ($btn.html() || "").trim() == ew.language.phrase("PleaseSelect")).off().click(function(e) {
				$p.find("[data-field][type=radio], [data-field][type=checkbox]").prop("checked", false).first().triggerHandler("click");
				$p.find(".list-group-item.active").removeClass("active");
				$btn.html(ew.language.phrase("PleaseSelect"));
			});
		}
		if (!$p.hasClass("dropdown-menu"))
			$p.removeClass("d-none");
		$p.data("options", []);
	}

	// Select combobox option
	function selectOption(obj, values) {
		if (!obj || !values)
			return;
		var $obj = $(obj);
		if ($.isArray(values)) {
			if (obj.options) { // Selection list
				$(obj).val(values);
				if (obj.type == "select-one" && obj.selectedIndex == -1)
					obj.selectedIndex = 0; // Make sure an option is selected (IE)
			} else if (obj.length) { // Radio/Checkbox list
				if (obj.length == 1 && obj[0].type == "checkbox" && obj[0].value != "{value}") { // Assume boolean field
					obj[0].checked = (convertToBool(obj[0].value) === convertToBool(values[0]));
				} else {
					$obj.val(values).closest(".ew-dropdown-list").find(".ew-dropdown-clear").prop("disabled", false);
				}
			} else if (isAutoSuggest(obj) && values.length == 1) {
				var o = getAutoSuggest(obj), opts = o._options || [];
				for (var i = 0, len = opts.length; i < len; i++) {
					if (opts[i].val == values[0]) {
						obj.value = opts[i].val;
						o.input.value = opts[i].lbl;
						break;
					}
				}
			} else if (isModalLookup(obj)) {
				var $obj = $(obj), vals = [], html = [], opts = $obj.data("options") || [];
				for (var j = 0, cnt = values.length; j < cnt; j++) {
					for (var i = 0, len = opts.length; i < len; i++) {
						if (values[j] == opts[i].val) {
							vals.push(opts[i].val);
							html.push(optionHtml(opts[i].lbl));
							break;
						}
					}
				}
				$obj.val(vals.join(ew.MULTIPLE_OPTION_SEPARATOR));
				$obj.parent().find(".ew-lookup-text").html(optionsHtml(html, $obj.data("maxcount")));
			} else if (obj.type) {
				obj.value = values.join(ew.MULTIPLE_OPTION_SEPARATOR);
			}
		}
		// Auto-select if only one option
		function isAutoSelect(el) {
			if (!$(el).data("autoselect")) // data-autoselect="false"
				return false;
			var form = getForm(el);
			if (form) {
				if (/s(ea)?rch$/.test(form.id)) // Search forms
					return false;
				var list = forms[form.id].lists(el.id);
				if (list && list.parentFields.length == 0) // No parent fields
					return false;
				return true;
			}
			return false;
		}
		if (obj.options) { // Selection List
			if (obj.type == "select-one" && obj.options.length == 2 && !obj.options[1].selected && isAutoSelect(obj)) {
				obj.options[1].selected = true;
			} else if (obj.type == "select-multiple" && obj.options.length == 1 && !obj.options[0].selected && isAutoSelect(obj)) {
				obj.options[0].selected = true;
			}
		} else if (obj.length) { // Radio/Checkbox list
			if (obj.length == 2 && isAutoSelect(obj[1]))
				obj[1].checked = true;
			if (obj[0].type == "radio")
				$obj.filter(":checked").closest(".list-group-item").addClass("active");
			var $div = $obj.closest(".dropdown-menu");
			var $btn = $div.closest(".ew-dropdown-list").find(".dropdown-toggle");
			if ($btn[0]) {
				var $items = $div.find("input[name='" + obj[0].name + "']:checked");
				var $vals = $items.map(function() {
					return $(this).parent().text();
				});
				$btn.html(optionsHtml($vals.get(), $obj.data("maxcount")));
			}
		} else if (isAutoSuggest(obj)) {
			var o = getAutoSuggest(obj), opts = o._options || [];
			if (opts.length == 1 && isAutoSelect(obj)) {
				obj.value = opts[0].val;
				o.input.value = opts[0].lbl;
			}
		}
	}

	// Ajax send
	$document.ajaxSend(function(event, jqxhr, settings) {
		var url = settings.url;
		if (url.match(/\w+preview(\w+)?(\.php)?\?/i)) // Preview page
			_removeSpinner(); // Preview has spinner already
		var apiUrl = getApiUrl(), isApi = url.startsWith(apiUrl), // Is API request
			allowed = isApi || url.startsWith(currentPage());
		if (!allowed && url.match(/^http/i)) {
			var objUrl = new URL(url);
			allowed = objUrl.hostname == currentUrl.hostname; // Same host name
		}
		if (allowed) {
			if (isApi && ew.API_JWT_TOKEN && !ew.IS_WINDOWS_AUTHENTICATION) // Do NOT set JWT authorization header if Windows Authentication
				jqxhr.setRequestHeader(ew.API_JWT_AUTHORIZATION_HEADER, "Bearer " + ew.API_JWT_TOKEN);
			if (settings.type == "GET") { // GET
				var ar = settings.url.split("?"), params = new URLSearchParams(ar[1]);
				params.set(ew.TOKEN_NAME, ew.ANTIFORGERY_TOKEN); // Add token
				ar[1] = params.toString();
				settings.url = ar[0] + (ar[1] ? "?" + ar[1] : "");
			} else { // POST
				if (settings.data instanceof FormData) { // FormData
					settings.data.set(ew.TOKEN_NAME, ew.ANTIFORGERY_TOKEN); // Add token
				} else {
					var params = new URLSearchParams(settings.data);
					params.set(ew.TOKEN_NAME, ew.ANTIFORGERY_TOKEN); // Add token
					settings.data = params.toString();
				}
			}
		}
	});

	// Ajax start
	$document.ajaxStart(function() {
		$document.data("_ajax", true);
		ew.addSpinner();
		$("form.ew-form").addClass("ew-wait").each(function() {
			var frm = forms[this.id];
			if (frm) {
				if (!frm.multiPage || !frm.multiPage.lastPageSubmit)
					frm.disableForm();
			}
		});
	});

	// Ajax stop (internal)
	function _ajaxStop() {
		$("form.ew-form.ew-wait").removeClass("ew-wait").each(function() {
			var frm = forms[this.id];
			if (frm) {
				if (!frm.multiPage || !frm.multiPage.lastPageSubmit)
					frm.enableForm();
			}
		});
		removeSpinner();
		$document.data("_ajax", false);
	}

	// Ajax stop/error
	$document.ajaxStop(_ajaxStop).ajaxError(_ajaxStop);

	// AutoSuggest class
	function AutoSuggest(settings) {
		var $input,
			$element,
			self = this,
			elValue = settings.id,
			frm = settings.form,
			forceSelection = settings.forceSelect,
			re = /^[xy](\d*|\$rowindex\$)_/,
			m = elValue.match(re),
			nid = elValue.replace(re, "x_"),
			rowindex = m ? m[1] : "",
			oEmpty = {typeahead:{}}; // Empty Auto-Suggest object
		if (rowindex == "$rowindex$")
			return oEmpty;
		var form = frm.getElement(); // HTML form or DIV
		var elInput = frm.getElement("sv_" + elValue);
		if (!elInput)
			return oEmpty;
		var elContainer = frm.getElement("sc_" + elValue);
		var elParent = frm.lists[nid].parentFields.slice(); // Clone

		for (var i = 0, len = elParent.length; i < len; i++) {
			var ar = elParent[i].split(" ");
			if (ar.length == 1) // Parent field in the same table, add row index
			elParent[i] = elParent[i].replace(/^x_/, "x" + rowindex + "_");
		}

		// Properties
		this.data = settings.data;
		this.minWidth = settings.minWidth;
		this.maxHeight = settings.maxHeight;
		this.highlight = settings.highlight;
		this.hint = settings.hint;
		this.minLength = settings.minLength;
		this.limit = settings.limit;
		this.templates = ew.extend({}, settings.templates); // Clone
		this.trigger = settings.trigger; // For loading more results
		this.delay = settings.delay; // For loading more results
		this.display = settings.display || "value";
		this.input = elInput;
		this.element = frm.getElement(elValue);
		this.$input = $input = $(this.input)
		this.$element = $element = $(this.element);
		this._options = [];
		this._recordCount = 0;

		// Save initial option
		if ($input.val() && $element.val())
			this._options.push({val: $element.val(), lbl: $input.val()});

		// Format display value in textbox
		this.formatResult = function(ar) {
			return displayValue(ar, this.element) || ar[0];
		};

		// Set the selected item to the actual field
		this.setValue = function(v) {
			v = v || $input.val();
			var ar = $input.data("results") ? $.map($input.data("results"), function(item, i) {
				if (item["value"] == v) // Value exists
					return i; // Return the index
			}) : [];
			if (ar.length == 0) { // Not found in results
				if (this._options && this._options.length && this._options[this._options.length - 1].lbl == v) // Option added by Add Option dialog or initial option
					return;
				if (forceSelection && v) { // Force selection and query not empty => error
					$input.typeahead("val", "").attr("placeholder", ew.language.phrase("ValueNotExist")).addClass("is-invalid");
					$element.val("").change();
					return;
				}
			} else { // Found in results
				if (!/s(ea)?rch$/.test(form.id) || forceSelection) { // Force selection or not search form
					var i = ar[0]; // Get the index
					if (i > -1)
						v = $input.data("results")[i]["lf"]; // Replace the display value by Link Field value
				}
			}
			if (v !== $element.val())
				$element.val(v).change(); // Set value to the actual field
		};

		// Generate request
		this.generateRequest = function() {
			var data = ew.extend({}, this.data, {
				name: this.element.name,
				ajax: "autosuggest",
				language: ew.LANGUAGE_ID
			}, getUserParams("#p_" + elValue, form));
			if (elParent.length > 0) {
				for (var i = 0, len = elParent.length; i < len; i++) {
					var arp = getOptionValues(elParent[i], form);
					data["v" + (i + 1)] = arp.join(ew.MULTIPLE_OPTION_SEPARATOR);
				}
			}
			return data;
		};

		// Prepare to send request
		this.prepare = function(query, start) {
			var settings = {};
			settings.data = this.generateRequest();
			settings.type = "POST";
			settings.dataType = "json";
			var params = new URLSearchParams({ "q": query, "n": this.limit, "rnd": random() });
			if ($.isNumber(start))
				params.set("start", start);
			settings.url = getApiUrl(ew.API_LOOKUP_ACTION, params.toString());
			return settings;
		};

		// Transform suggestion
		this.transform = function(data) {
			var results;
			if (data && data.result == "OK") {
				self._recordCount = data.totalRecordCount;
				results = data.records;
			}
			$input.data("results", results || []);
			var ar = $.map($input.data("results"), function(item) {
				var val = item["value"] = self.formatResult(item); // Format the item and save as property
				return { lf: item[0], df1: item[1], df2: item[2], df3: item[3], df4: item[4], value: val }; // Return as object
			});
			return ar;
		};

		// Get suggestions by Ajax
		this.source = function(query, syncResults, asyncResults) {
			self._recordCount = 0; // Reset
			var settings = self.prepare(query);
			$.ajax(settings).done(function(data) {
				asyncResults(self.transform(data));
			});
		};

		// Get current suggestion count
		this.count = function() {
			return self.typeahead.menu.$node.find(".tt-suggestion.tt-selectable").length;
		};

		// Get more suggestions by Ajax
		this.more = function() {
			$body.css("cursor", "wait");
			var ta = self.typeahead, query = ta.menu.query, dataset = ta.menu.datasets[0];
			var start = self.count();
			var settings = self.prepare(query, start);
			$.ajax(settings).done(function(data) {
				data = self.transform(data);
				dataset._append(query, data);
				ta.menu.$node.find(".tt-dataset").scrollTop(dataset.$lastSuggestion.outerHeight() * start);
			}).always(function() {
				$body.css("cursor", "default");
			});
		};

		// Add events
		$input.on("typeahead:select", function(e, d) {
			self.setValue(d.value);
		}).change(function(e) {
			var ta = $input.data("tt-typeahead");
			if (ta && ta.isOpen() && !ta.menu.empty()) {
				var $item = ta.menu.getActiveSelectable();
				if ($item) { // A suggestion is highlighted
					var i = $item.index();
					var val = $input.data("results")[i][1];
					$input.typeahead("val", val);
				}
			}
			self.setValue();
		}).blur(function(e) { // "change" fires before blur
			var ta = $input.data("tt-typeahead");
			if (ta && ta.isOpen())
				ta.menu.close();
		}).focus(function(e) {
			$input.attr("placeholder", $input.data("placeholder")).removeClass("is-invalid");
		});

		// Option template ("suggestion" template)
		var tpl;
		if (frm.lists[nid].template) {
			tpl = frm.lists[nid].template;
		} else {
			tpl = self.templates["suggestion"];
		}
		if (tpl && $.isString(tpl))
			tpl = $.templates(tpl);
		if (tpl)
			self.templates["suggestion"] = tpl.render.bind(tpl);

		// Save
		$element.data("autosuggest", this);

		// Create Typeahead
		$(function() {
			// Typeahead options and dataset
			var options = {
				highlight: self.highlight,
				minLength: self.minLength,
				hint: self.hint,
				trigger: self.trigger,
				delay: self.delay
			};
			var dataset = {
				name: frm.id + "-" + elValue,
				source: self.source,
				templates: self.templates,
				display: self.display,
				limit: self.limit,
				async: true
			};
			var args = [options, dataset];
			// Trigger "typeahead" event
			$element.trigger("typeahead", [args]);
			self.limit = dataset.limit;
			// Create Typeahead
			$input.typeahead.apply($input, args);
			$input.on("typeahead:rendered", function() {
				var $node = self.typeahead.menu.$node;
				var $more = $node.find(".tt-more").html(ew.language.phrase("More"));
				if (arguments.length > 1 && // Arguments: event, suggestion, suggestion, ...
					self._recordCount > self.count()) {
					var timer;
					$more.one(options.trigger, function(e) {
						if (timer)
							timer.cancel();
						setTimeout(function() {
							self.more();
						}, options.delay);
						e.preventDefault();
						e.stopPropagation();
					});
				} else {
					$more.hide();
				}
			});
			$input.off("blur.tt");
			self.typeahead = $input.data("tt-typeahead");
			var $menu = self.typeahead.menu.$node.css("z-index", 1000);
			if (self.minWidth)
				$menu.css("min-width", self.minWidth);
			var $dataset = $menu.find(".tt-dataset");
			var maxHeight = self.maxHeight ||
				(parseInt($dataset.css("line-height"), 10) + 6) * (dataset.limit + 1); // Match .tt-suggestion padding
			$dataset.css({"max-height": maxHeight, "overflow-y": "auto"});
		});
	}

	// Execute JavaScript in HTML loaded by Ajax
	function executeScript(html, id) {
		var ar, i = 0, re = /<script([^>]*)>([\s\S]*?)<\/script\s*>/ig;
		html = html.replace(/<head>[\s\S]*<\/head>/, "");
		while ((ar = re.exec(html)) != null) {
			var text = ar[2];
			if (/(\s+type\s*=\s*['"]*text\/javascript['"]*)|^((?!\s+type\s*=).)*$/i.test(ar[1]) && text)
				addScript(text, "scr_" + id + "_" + i++);
		}
	}

	// Strip JavaScript in HTML loaded by Ajax
	function stripScript(html) {
		var ar, re = /<script([^>]*)>([\s\S]*?)<\/script\s*>/ig;
		var str = html;
		while ((ar = re.exec(html)) != null) {
			var text = ar[0];
			if (/(\s+type\s*=\s*['"]*text\/javascript['"]*)|^((?!\s+type\s*=).)*$/i.test(ar[1]))
				str = str.replace(text, "");
		}
		return str;
	}

	// Add SCRIPT tag
	function addScript(text, id) {
		var scr = document.createElement("SCRIPT");
		if (id)
			scr.id = id;
		scr.text = text;
		return document.body.appendChild(scr); // Do not use jQuery so it can be removed
	}

	// Remove JavaScript added by Ajax
	function removeScript(id) {
		if (id)
			$("script[id^='scr_" + id + "_']").remove();
	}

	// Clean HTML loaded by Ajax for modal dialog
	function getContent(html) {
		var body = stripScript(html).match(/<body[\s\S]*>[\s\S]*<\/body>/i);
		return $(body[0]).not("div[id^=ew].modal, #ew-tooltip, #cookie-consent");
	}

	// Get all options of Selection list or Radio/Checkbox list as array [{ name: "name", value: "value" }, ...]
	function getOptions(obj) {
		if (obj.options) {
			return Array.prototype.map.call(obj.options, function(opt) {
				return { value: opt.value, name: opt.text };
			});
		} else if (obj.length) {
			return getContainer(obj).data("options") || [];
		}
		return [];
	}

	/**
	 * Show Add Option dialog
	 *
	 * @param {Object} args - Arguments
	 * @param {Object} args.frm - form object
	 * @param {HTMLElement} args.lnk - Add option anchor element
	 * @param {string} args.el - Form element name
	 * @param {string} args.url - URL of the Add form
	 * @returns
	 */
	function addOptionDialogShow(args) {

		// Hide dialog
		var _hide = function() {
			removeScript($dlg.data("args").el);
			var frm = $dlg.removeData("args").find(".modal-body form").data("form");
			if (frm)
				frm.destroyEditor();
			$dlg.find(".modal-body").html("");
			$dlg.find(".modal-footer .btn-primary").unbind();
			$dlg.data("showing", false);
		}

		var $dlg = ew.addOptionDialog || $("#ew-add-opt-dialog").on("hidden.bs.modal", _hide);
		if (!$dlg[0]) {
			_alert("DIV #ew-add-opt-dialog not found.");
			return;
		}
		if ($dlg.data("showing"))
			return;
		$dlg.data("showing", true);

		// Submission success
		var _submitSuccess = function(data) {
			var results = data,
				args = $dlg.data("args"),
				frm = forms(args.lnk), // form object
				objName = $dlg.find(".modal-body form input[name='" + ew.API_OBJECT_NAME + "']").val(), // Get object name from form
				el = args.el, // HTML element
				re = /^x(\d+)_/,
				m = el.match(re), // Check row index
				prefix = m ? m[0] : "x_",
				index = m ? m[1] : -1,
				name = el.replace(re, "x_"),
				list = frm.lists[name];
			if ($.isString(data))
				results = parseJson(data);
			if (results && results.success && results[objName]) {
				var result = results[objName];
				$dlg.modal("hide");
				var form = frm.$element[0]; // HTML form or DIV
				var obj = getElements(el, form);
				if (obj) {
					var name = el.replace(re, "x_");
					var lf = frm.lists[name].linkField,
						dfs = frm.lists[name].displayFields.slice(), // Clone
						ffs = frm.lists[name].filterFields.slice(), // Clone
						pfs = frm.lists[name].parentFields.slice(); // Clone
					for (var i = 0, len = pfs.length; i < len; i++) {
						var ar = pfs[i].split(" ");
						if (ar.length == 1) // Parent field in the same table, add row index
							pfs[i] = pfs[i].replace(/^x_/, prefix);
					}
					var lfv = (lf != "") ? result[lf] : "";
					var row = { lf: lfv };
					for (var i = 0, len = dfs.length; i < len; i++) {
						if (dfs[i] in result)
							row["df" + (i || "")] = result[dfs[i]];
					}
					for (var i = 0, len = ffs.length; i < len; i++) {
						if (ffs[i] in result)
							row["ff" + (i || "")] = result[ffs[i]];
					}
					if (lfv && dfs.length > 0 && row["df"]) {
						var id = getId(el, false), nid = id.replace(new RegExp("^" + prefix), "x_");
						if (frm.lists[nid].ajax === null) { // Non-Ajax
							var ar = frm.lists[nid].options;
							ar.push(row);
						}
						// Get the parent field values
						var arp = [];
						for (var i = 0, len = pfs.length; i < len; i++)
							arp.push(getOptionValues(pfs[i], form));
						var args = {"data": row, "parents": arp, "valid": true, "name": getId(obj), "form": form};
						$document.trigger("addoption", [args]);
						if (args.valid) { // Add the new option
							var ar = getOptions(obj), vals = [];
							if (!obj.options && obj.length) { // Radio/Checkbox list
								vals = getOptionValues(obj);
								getContainer(obj).find("div").first().empty();
							}
							var txt = newOption(obj, row, form);
							if (obj.options) {
								obj.options[obj.options.length-1].selected = true;
								$(obj).change().focus();
							} else if (obj.length) { // Radio/Checkbox list
								renderOption(obj);
								obj = getElements(id, form); // Update the list
								if (vals.length > 0)
									selectOption(obj, vals);
								if (obj.length > 0) {
									var el = $(obj).filter("[value!='{value}']").last()[0];
									if (el.type == "checkbox" || el.type == "radio")
										el.click(); // Select new option and trigger click event
									el.focus();
								}
							} else if (isAutoSuggest(obj)) {
								var o = getAutoSuggest(obj);
								$(obj).val(lfv).change();
								$(o.input).val(txt).focus();
							} else if (isModalLookup(obj)) {
								var $obj = $(obj), $lu = $(getElement("lu_" + args.name, form));
								if ($obj.data("multiple")) { // Add to existing values
									var val = $(obj).val(), vals = [], nv = String(lfv);
									if (val !== "")
										vals = val.split(ew.MULTIPLE_OPTION_SEPARATOR);
									if (!vals.includes(nv)) {
										vals.push(nv);
										$obj.val(vals.join()).change();
										var html = $lu.html(), arOpt = $lu.find(".ew-option").map(function() {
											return $(this).html();
										}).get();
										if (arOpt.length) { // Some options selected
											arOpt.push(txt);
											$lu.html(optionsHtml(arOpt, $obj.data("maxcount")));
										} else if (html == ew.language.phrase("PleaseSelect")) { // No options selected
											$lu.html(optionHtml(txt));
										} else if (html) { // Many options selected
											$lu.html(ew.language.phrase("CountSelected").replace("%s", vals.length));
										}
									}
								} else {
									$obj.val(lfv).change();
									$lu.html(txt);
								}
							}
							var $form = $(form), suffix = ($form.is("div")) ? "_" + $form.attr("id") : "";
							var cnt = $form.find("#key_count" + suffix).val();
							if (cnt > 0) { // Grid-Add/Edit, update other rows
								for (var i = 1; i <= cnt; i++) {
									if (i == index)
										continue;
									var obj2 = getElements(name.replace(/^x/, "x" + i), form);
									var ar2 = getOptions(obj2), vals = [];
									if (JSON.stringify(ar) != JSON.stringify(ar2)) // Not same options
										continue;
									if (!obj2.options && obj2.length) // Radio/Checkbox list
										vals = getOptionValues(obj2);
									newOption(obj2, row, form);
									if (!obj2.options && obj2.length) { // Radio/Checkbox list
										renderOption(obj2);
										if (vals.length > 0)
											selectOption(obj2, vals);
									}
								}
							}
						}
					}
				}
			} else {
				var msg, $div = $dlg.find("div.ew-message-dialog").html(""),
					$div2 = $("<div></div>").html(data).find("div.ew-message-dialog");
				if ($div2[0]) {
					msg = $div2.html();
				} else {
					msg = (results && results.failureMessage) ? results.failureMessage : data;
					if (!msg || String(msg).trim() == "")
						msg = ew.language.phrase("InsertFailed");
					msg = "<p class=\"text-danger\">" + msg + "</p>";
				}
				$div.html(msg).show();
			}
		}

		// Fail
		var _fail = function(o) {
			$dlg.modal("hide");
			_alert("Server Error " + o.status + ": " + o.statusText);
		}

		// Submit
		var _submit = function(e) {
			var $dlg = ew.addOptionDialog;
			var form = $dlg.find(".modal-body form")[0];
			var frm = forms[form.id];
			var btn = e ? e.target : null;
			if (btn) {
				frm.enableForm = function() {
					$(btn).prop("disabled", false).removeClass("disabled");
				};
				frm.disableForm = function() {
					$(btn).prop("disabled", true).addClass("disabled");
				};
			}
			if (frm.canSubmit())
				$.post(getApiUrl(ew.API_ADD_ACTION), $(form).serialize(), _submitSuccess).fail(_fail).always(function() {
					frm.enableForm();
				});
			return false;
		}

		$dlg.modal("hide");
		$dlg.data("args", args);

		// Get form HTML
		var success = function(data) {
			var frm = forms(args.lnk),
				prefix = "x_",
				m = args.el.match(/^(x\d+_)/);
			if (m) // Contains row index
				prefix = m[1];
			var name = args.el.replace(prefix, "x_");
			var pf = frm.lists[name].parentFields.slice(); // Clone
			var ff = frm.lists[name].filterFieldVars.slice(); // Clone
			var form = frm._form;
			var ar = [], ar2 = [];
			for (var i = 0, len = pf.length; i < len; i++) {
				var arr = pf[i].split(" ");
				if (arr.length == 1) // Parent field in the same table, add row index
					pf[i] = pf[i].replace(/^x_/, prefix);
			}
			for (var i = 0, len = pf.length; i < len; i++) {
				ar.push(getOptionValues(pf[i], form));
				ar2.push(getOptionTexts(pf[i], form));
			}
			$dlg.find(".modal-title").html($(args.lnk).closest(".ew-add-opt-btn").data("title"));
			$dlg.find(".modal-body").html(stripScript(data));
			var form = $dlg.find(".modal-body form")[0];
			if (form) { // Set the filter field value
				$(form).keypress(function(e) {
					if (e.which == 13 && e.target.nodeName != "TEXTAREA")
						return _submit();
				});
				var _sameObj = function(o1, o2) {
					return $.isArray(o1) && $.isArray(o2) && o1[0] && o2[0] &&
						o1.name == o2.name && o1.form == o2.form;
				}
				for (var i = 0, len = ar.length; i < len; i++) {
					(function() {
						var obj = getElements(ff[i], form), v = ar[i];
						if (obj) {
							if (obj.options || obj.length) { // Selection list
								$document.one("updatedone", function(e, args) {
									var target = args.target;
									if (obj == target || _sameObj(obj, target))
										selectOption(target, v);
								});
							} else {
								selectOption(obj, v);
							}
						}
					})();
				}
			}
			ew.addOptionDialog = $dlg.modal("show");
			$dlg.find(".modal-footer .btn-primary").click(_submit).focus();
			executeScript(data, args.el);
			if (form) { // Set the filter field value
				for (var i = 0, len = ar.length; i < len; i++) {
					var obj = getElements(ff[i], form);
					if (obj) {
						if (isAutoSuggest(obj)) { // AutoSuggest
							obj.value = ar[i][0];
							var o = getAutoSuggest(obj);
							o.input.value = ar2[i][0];
							o._options.push({"val": ar[i][0], "lbl": ar2[i][0]});
						} else if (isModalLookup(obj)) { // Modal-Lookup
							obj.value = ar[i][0];
							updateOptions.call(forms[form.id], obj);
						} else if (obj.options || obj.length) { // Selection list
							// Skip
						} else { // Text
							obj.value = ar[i][0];
						}
					}
				}
			}
			$dlg.trigger("load.ew");
		};
		$.get(args.url, success).fail(_fail);
	}

	// Hide Modal dialog
	function modalDialogHide(e) {
		var $dlg = $(this), args = $dlg.data("args");
		removeScript("ModalDialog");
		var frm = $dlg.removeData("args").find(".modal-body form").data("form");
		if (frm)
			frm.destroyEditor();
		var $bd = $dlg.find(".modal-body").html("");
		if ($bd.ewjtable && $bd.ewjtable("instance"))
			$bd.ewjtable("destroy");
		$dlg.find(".modal-footer .btn-primary").unbind();
		$dlg.find(".modal-dialog").removeClass(function(index, className) {
			var m = className.match(/table\-\w+/);
			return (m) ? m[0] : "";
		});
		$dlg.data("showing", false);
		$dlg.data("url", null);
		if (args && args.reload)
			window.location.reload(true);
	}

	/**
	 * Show modal dialog
	 *
	 * @param {Object} args - Arguments
	 * @param {HTMLFormElement} args.f - Form of List page
	 * @param {HTMLElement} args.lnk - Anchor element
	 * @param {string} args.url - URL of the form
	 * @param {string|null} args.btn - Button phrase ID
	 * @param {string} args.caption - Caption in dialog header
	 * @param {boolean} args.reload - Reload page after hiding dialog or not
	 * @param {string} args.size - Size of the dialog 'modal-sm'|''|modal-lg'|'modal-xl'(default)
	 * @returns false
	 */
	function modalDialogShow(args) {
		$(args.lnk).tooltip("hide");
		var f = args.f;
		if (f && !keySelected(f)) {
			_prompt("<p class=\"text-danger\">" + ew.language.phrase("NoRecordSelected") + "</p>");
			return false;
		}

		var $dlg = ew.modalDialog || $("#ew-modal-dialog").on("hidden.bs.modal", modalDialogHide); // div#ew-modal-dialog always exists
		if ($dlg.data("showing") && $dlg.data("url") == args.url)
			return false;
		$dlg.data({ showing: true, url: args.url });
		args.reload = false;

		// size
		if (args.size === "modal-sm") { // 300px
			$dlg.find(".modal-dialog").toggleClass("modal-sm", true).toggleClass("modal-lg modal-xl", false);
		} else if (args.size === "") { // 500px
			$dlg.find(".modal-dialog").toggleClass("modal-sm modal-lg modal-xl", false);
		} else if (args.size === "modal-lg") { // 800px
			$dlg.find(".modal-dialog").toggleClass("modal-lg", true).toggleClass("modal-sm modal-xl", false);
		} else { // Default = 1140px
			$dlg.find(".modal-dialog").toggleClass("modal-xl", true).toggleClass("modal-sm modal-lg", false);
		}

		// caption
		var _caption = function() {
			var args = $dlg.data("args");
			var $lnk = $(args.lnk);
			return args.caption || $lnk.data("caption") || $lnk.data("original-title") || "";
		};

		// button text
		var _button = function() {
			var args = $dlg.data("args");
			if ($.isNull(args.btn))
				return "";
			else if (args.btn && args.btn != "")
				return ew.language.phrase(args.btn);
			else
				return _caption();
		};

		// fail
		var _fail = function(o) {
			$dlg.modal("hide");
			if (o.status)
				_alert("Server Error " + o.status + ": " + o.statusText);
		}

		// always
		var _always = function(o) {
			$body.css("cursor", "default");
		}

		// check if current page
		var _current = function(url) {
			var a = $("<a>", { href: url })[0];
			return window.location.pathname.endsWith(a.pathname);
		}

		// submit success
		var _submitSuccess = function(data) {
			var result = parseJson(data);
			if ($.isObject(result)) {
				var url = result.url;
				if (result.modal && !_current(url)) {
					var args = $dlg.data("args");
					args.reload = true;
					if (result.caption)
						args.caption = result.caption;
					args.btn = result.view ? null : "";
					$dlg.data("args", args);
					url += (url.split("?").length > 1 ? "&" : "?") + "modal=1&rnd=" + random();
					$body.css("cursor", "wait");
					$.ajax(url).done(success).fail(_fail).always(_always);
				} else {
					$dlg.modal("hide");
					window.location = url;
				}
			} else {
				var body = getContent(data);
				var $bd = $dlg.find(".modal-body").html(body);
				var footer = "";
				var cf = $bd.find("#confirm");
				var ct = $bd.find("#conflict");
				if (ct && ct.val() == "1") { // Conflict page
					footer += "<button type=\"button\" id=\"btn-overwrite\" class=\"btn btn-primary ew-btn\">" + ew.language.phrase("OverwriteBtn") + "</button>";
					footer += "<button type=\"button\" id=\"btn-reload\" class=\"btn btn-default ew-btn\">" + ew.language.phrase("ReloadBtn") + "</button>";
					footer += "<button type=\"button\" class=\"btn btn-default ew-btn\" data-dismiss=\"modal\">" + ew.language.phrase("CancelBtn") + "</button>";
					$dlg.find(".modal-footer").html(footer);
					$dlg.find(".modal-footer #btn-overwrite").on('click', {action: 'overwrite'}, _submit);
					$dlg.find(".modal-footer #btn-reload").on('click', {action: 'show'}, _submit);
				} else if (cf && cf.val() == "confirm") { // Confirm page
					footer += "<button type=\"button\" class=\"btn btn-primary ew-btn\">" + ew.language.phrase("ConfirmBtn") + "</button>";
					footer += "<button type=\"button\" class=\"btn btn-default ew-btn\">" + ew.language.phrase("CancelBtn") + "</button>";
					$dlg.find(".modal-footer").html(footer);
					$dlg.find(".modal-footer .btn-primary").click(_submit).focus();
					$dlg.find(".modal-footer .btn-default").on("click", {action: "cancel"}, _submit);
				} else { // Normal page
					var btn = _button();
					if (btn)
						footer += "<button type=\"button\" class=\"btn btn-primary ew-btn\">" + btn + "</button>";
					footer += "<button type=\"button\" class=\"btn btn-default ew-btn\" data-dismiss=\"modal\">" + ew.language.phrase("CancelBtn") + "</button>";
					$dlg.find(".modal-footer").html(footer);
					$dlg.find(".modal-footer .btn-primary").addClass("ew-submit").click(_submit).focus();
				}
				executeScript(data, "ModalDialog");
				$dlg.trigger("load.ew"); // Trigger load event for, e.g. Use JavaScript popup message
			}
		}

		// submit
		var _submit = function(e) {
			var form = $dlg.find(".modal-body form")[0], $form = $(form);
			var frm = forms[form.id];
			var action = e && e.data ? e.data.action : null;
			var btn = e ? e.target : null;
			if (btn) {
				frm.enableForm = function() {
					$(btn).prop("disabled", false).removeClass("disabled");
				};
				frm.disableForm = function() {
					$(btn).prop("disabled", true).addClass("disabled");
				};
			}
			var input = form.elements["action"];
			if (action && input)
				input.value = action; // Update action
			if (action == "cancel") { // Cancel
				$.post($form.attr("action"), $form.serialize(), success).fail(_fail).always(_always);
			} else if (frm.canSubmit()) {
				$.post($form.attr("action"), $form.serialize(), _submitSuccess).fail(_fail);
			}
			return false;
		}

		$dlg.modal("hide");
		$dlg.data("args", args);

		var success = function(data) {
			var result = parseJson(data);
			if ($.isObject(result)) {
				if (result.error)
					_alert(result.error);
			} else {
				var args = $dlg.data("args");
				var $data = $(data), $lnk = $(args.lnk);
				$dlg.find(".modal-title").html(_caption());
				var footer = "";
				var btn = _button();
				if (btn)
					footer += "<button type=\"button\" class=\"btn btn-primary ew-btn\">" + btn + "</button>";
				if (footer != "")
					footer += "<button type=\"button\" class=\"btn btn-default ew-btn\" data-dismiss=\"modal\">" + ew.language.phrase("CancelBtn") + "</button>";
				else
					footer = "<button type=\"button\" class=\"btn btn-default ew-btn\" data-dismiss=\"modal\">" + ew.language.phrase("CloseBtn") + "</button>";
				$dlg.find(".modal-footer").html(footer);
				var body = getContent(data);
				$dlg.find(".modal-body").html(body);
				$dlg.find(".modal-body form").keypress(function(e) {
					if (e.which == 13 && e.target.nodeName != "TEXTAREA")
						return _submit();
				});
				ew.modalDialog = $dlg.modal("show");
				$dlg.find(".modal-dialog").addClass("table-" + $lnk.data("table"));
				$dlg.find(".modal-footer .btn-primary").addClass("ew-submit").click(_submit).focus();
				executeScript(data, "ModalDialog");
				$dlg.trigger("load.ew"); // Trigger load event for, e.g. YouTube videos, ReCAPTCHA and Google maps
			}
		};

		$body.css("cursor", "wait");

		var url = args.url;
		if (f) { // Post form
			var $f = $(f);
			if (!f.elements.modal)
				$("<input>").attr({type: "hidden", name: "modal", value: "1"}).appendTo($f);
			$.post(url, $f.serialize(), success).fail(_fail).always(_always);
		} else {
			url += (url.split("?").length > 1 ? "&" : "?") + "modal=1&rnd=" + random();
			$.get(url, success).fail(_fail).always(_always);
		}

		return false;
	}

	// Show Modal Lookup
	function modalLookupShow(args) {
		var el = args.el, f = getForm(args.lnk);
		if (!f || !el)
			return;

		var $dlg = ew.modalLookupDialog || $("#ew-modal-lookup-dialog").on("hidden.bs.modal", modalDialogHide);
		if (!$dlg[0]) {
			_alert("DIV #ew-modal-lookup-dialog not found.");
			return;
		}
		if ($dlg.data("showing"))
			return;
		$dlg.data("showing", true);

		var id = getId(el, true),
			$f = $(f),
			$input = $f.find("[id='" + el + "']"), // id may contains "[]"
			$bd = $dlg.find(".modal-body"),
			$lnk = $(args.lnk),
			$lu = $lnk.closest(".ew-lookup-list").find(".ew-lookup-text").focus(),
			oid = getId(el, false),
			m = oid.match(/^([xy])(\d*)_/),
			prefix = (m) ? m[1] : "",
			rowindex = (m) ? m[2] : "",
			nid = oid.replace(/^([xy])(\d*)_/, "x_"),
			list = forms[f.id].lists(nid);

		// Format data
		var _format = function(data) {
			if (data.result == "OK" && $.isArray(data.records)) {
				data.records.forEach(function(ar, index) {
					var item;
					if ($.isArray(ar))
						item = { "lf": ar[0], "df1": ar[1], "df2": ar[2], "df3": ar[3], "df4": ar[4] };
					else if ($.isObject(ar))
						item = { lf: ar.lf, df1: ar.df, df2: ar.df2, df3: ar.df3, df4: ar.df4 };
					var txt = displayValue(ar, $input);
					if (list.template) {
						item["df"] = list.template.render(item, ew.jsRenderHelpers);
					} else {
						item["df"] = txt;
					}
					item["txt"] = txt;
					data.records[index] = item;
				});
			}
			return data;
		}

		// Set AutoSuggest
		var setAutoSuggest = function(value, text) {
			if (!isAutoSuggest($input))
				return;
			var o = getAutoSuggest($input[0]);
			o._options.push({"val": value, "lbl": text});
			o.input.value = text;
		}

		// Add option
		var addOpt = function(ar) {
			// Check if selected records are in the current page
			var vals = [], html = [], opts = [], txts = [], useText = !args.m && args.srch;
			$bd.ewjtable("selectedRows").each(function() {
				var record = $(this).data("record");
				vals.push(record.lf);
				html.push(record.df);
				opts.push(record.df);
				txts.push(record.txt); // Text for Auto-Suggest
			});
			if (ar.sort().join() === vals.sort().join()) { // All selected records are from the current page
				$lu.html(optionsHtml(opts, $input.data("maxcount")));
				setAutoSuggest(vals.join(), txts.join(", "));
				$input.val(useText ? html.join(", ") : vals.join()).change();
			} else { // Get selected records from server
				var data = ew.extend({ page: list.page, field: list.field, ajax: "modal", keys: ar }, getUserParams('#p_' + oid, f));
				$body.css("cursor", "wait");
				$.ajax(getApiUrl(ew.API_LOOKUP_ACTION), {
					type: "POST",
					dataType: "json",
					data: data
				}).done(_format).then(function(data) {
					if (data.result == "OK" && $.isArray(data.records)) {
						var vals = [], html = [], opts = [], txts = [], results = data.records;
						for (var i = 0, cnt = results.length; i < cnt; i++) {
							var result = results[i];
							vals.push(result.lf);
							html.push(result.df)
							opts.push(result.df);
							txts.push(result.txt); // Text for Auto-Suggest
						}
						$lu.html(optionsHtml(opts, $input.data("maxcount")));
						setAutoSuggest(vals.join(), txts.join(", "));
						$input.val(useText ? html.join(", ") : vals.join()).change();
					}
				}).always(function() {
					$body.css("cursor", "default");
				});
			}
		}

		// Submit
		var _submit = function() {
			addOpt(arLinkValue);
			$dlg.modal("hide");
			return false;
		}

		// Hide
		$dlg.modal("hide");
		$dlg.data("args", args);
		var _timer, $search;

		// Success
		var success = function(data) {
			if (data.result == "OK") {
				$dlg.find(".modal-title").html($lnk.attr("title") || $lnk.data("original-title"));
				$dlg.find(".modal-footer").html('<button type="button" id="btn-select" class="btn btn-primary ew-btn">' + ew.language.phrase("SelectBtn") + '</button>' +
					'<button type="button" class="btn btn-default ew-btn" data-dismiss="modal">' + ew.language.phrase("CancelBtn") + '</button>');
				$search = $('<input type="search" name="sv" class="form-control mb-2" placeholder="' + ew.language.phrase("Search") + '">')
					.prependTo($bd).on("keyup", function(e) {
						if (_timer)
							_timer.cancel();
						_timer = $.later(ew.LOOKUP_DELAY, null, function() {
							$bd.ewjtable("load", { "sv": $search.val() });
						});
					});
				$dlg.find(".modal-footer #btn-select").click(_submit); // Select
				ew.modalLookupDialog = $dlg.modal("show");
				$dlg.find("[name=sv]").focus();
			} else {
				_alert(data.message);
			}
		};

		var arp = [];
		var linkValue = $input.val(); // Link values
		var arLinkValue = (linkValue !== "") ? linkValue.split(ew.MULTIPLE_OPTION_SEPARATOR) : [];
		var data = ew.extend({ page: list.page, field: list.field }, getUserParams('#p_' + oid, f));

		// Add parent field values
		var parentId = list.parentFields.slice(); // Clone
		if (rowindex != "") {
			for (var i = 0, len = parentId.length; i < len; i++) {
				var ar = parentId[i].split(" ");
				if (ar.length == 1) // Parent field in the same table, add row index
					parentId[i] = parentId[i].replace(/^x_/, "x" + rowindex + "_");
			}
		}
		if (parentId.length > 0) {
			for (var i = 0, len = parentId.length; i < len; i++)
				arp.push(getOptionValues(parentId[i], f));
		}
		for (var i = 0, cnt = arp.length; i < cnt; i++) // Filter by parent fields
			data["v" + (i + 1)] = arp[i].join(ew.MULTIPLE_OPTION_SEPARATOR);

		$body.css("cursor", "wait");
		$bd.ewjtable({
			paging: true,
			pageSize: args.n,
			pageSizes: [],
			pageSizeChangeArea: false,
			pageList: "minimal",
			selecting: true,
			selectingCheckboxes: true,
			multiselect: !!args.m,
			actions: {
				"listAction": function(postData, jtParams) {
					var _data = ew.extend({}, data, {
						ajax: "modal",
						start: jtParams.start,
						recperpage: jtParams.recperpage
					});
					if ($.isObject(postData)) // Search
						ew.extend(_data, postData);
					return $.ajax(getApiUrl(ew.API_LOOKUP_ACTION), {
							type: "POST",
							dataType: "json",
							data: _data
						}).done(_format).always(function() {
							$body.css("cursor", "default");
						});
				}
			},
			messages: {
				serverCommunicationError: ew.language.phrase("ServerCommunicationError"),
				loadingMessage: '<div class="' + ew.spinnerClass + ' m-3 ew-loading" role="status"><span class="sr-only">' + ew.language.phrase("Loading") + '</span></div>',
				noDataAvailable: ew.language.phrase("NoRecord"),
				close: ew.language.phrase("CloseBtn"),
				pagingInfo: ew.language.phrase("Record") + " {0}-{1} " + ew.language.phrase("Of") + " {2}",
				pageSizeChangeLabel: ew.language.phrase("RecordsPerPage"),
				gotoPageLabel: ew.language.phrase("Page")
			},
			fields: {
				"lf": { key: true, list: false},
				"df": {}
			},
			recordsLoaded: function(e, data) {
				var selectedRows = $(e.target).find(".ewjtable-data-row").filter(function() {
					return arLinkValue.includes(String($(this).data("record-key")));
				});
				$(e.target).ewjtable("selectRows", selectedRows);
			},
			selectionChanged: function(e, data) {
				var $rows = data.rows;
				if ($rows) {
					if (!args.m)
						arLinkValue = [];
					$rows.each(function() {
						var $row = $(this);
						var key = String($row.data("record-key"));
						var index = arLinkValue.indexOf(key);
						var selected = $row.hasClass("ewjtable-row-selected");
						if (selected && index == -1)
							arLinkValue.push(key);
						else if (!selected && index > -1)
							arLinkValue.splice(index, 1);
					});
				}
			}
		}).ewjtable("load", null, success);
	}

	/**
	 * Show dialog for import
	 *
	 * @param {Object} args - Arguments
	 * @param {string} args.hdr - Dialog header
	 * @param {HTMLElement} args.lnk - Anchor element
	 * @returns
	 */
	function importDialogShow(args) {
		$(args.lnk).tooltip("hide");
		var $dlg = ew.importDialog || $("#ew-import-dialog");
		if (!$dlg[0]) {
			_alert("DIV #ew-import-dialog not found.");
			return false;
		}

		var $input = $dlg.find("#importfiles"),
			$bd = $dlg.find(".modal-body"),
			$data = $bd.find(":input[id!=importfiles]"),
			$message = $bd.find(".message"),
			$progress = $bd.find(".progress"),
			timer;

		// Disable buttons
		var disableButtons = function() {
			$dlg.find(".modal-footer .btn").prop("disabled", true);
		}

		// Enable buttons
		var enableButtons = function() {
			$dlg.find(".modal-footer .btn").prop("disabled", false);
		}

		// Show message
		var showMessage = function(msg, classname) {
			$msg = $("<div>" + msg + "</div>");
			if (classname)
				$msg.addClass(classname);
			$message.removeClass("d-none").html($msg);
			if (classname == "text-danger")
				enableButtons();
		}

		// Hide message
		var hideMessage = function() {
			$message.addClass("d-none").html("");
		}

		// Show progress
		var showProgress = function(pc, classname) {
			$progress.removeClass("d-none").find(".progress-bar").removeClass("bg-success bg-info").addClass(classname || "bg-success")
				.attr("aria-valuenow", pc).css("width", pc + "%").html(pc + "%");
		}

		// Hide progress
		var hideProgress = function() {
			$progress.addClass("d-none").find(".progress-bar").attr("aria-valuenow", 0).css("width", "0%").html("0%");
		}

		// Upload progress
		var uploadProgress = function(data) {
			var pc = parseInt(100 * data.loaded / data.total);
			showProgress(pc, "bg-info");
			if (pc === 100) {
				showMessage(ew.language.phrase("ImportMessageUploadComplete"), "text-info");
			} else {
				showMessage(ew.language.phrase("ImportMessageUploadProgress").replace("%p", pc), "text-info");
			}
		}

		// Update progress (import)
		var updateProgress = function(result) {
			try {
				var cnt = parseInt(result.count), tcnt = parseInt(result.totalCount), filename = result.file;
				if (tcnt > 0 && $dlg.find(".modal-footer .ew-close-btn").data("import-progress")) { // Show progress
					var pc = parseInt(100 * cnt / tcnt);
					showProgress(pc);
					showMessage(ew.language.phrase("ImportMessageProgress").replace("%t", tcnt).replace("%c", cnt).replace("%f", filename), "text-info");
				}
			} catch(e) {}
		}

		// Import progress
		var importProgress = function() {
			var url = getApiUrl(ew.API_PROGRESS_ACTION), data = { "rnd": random() };
			data[ew.API_FILE_TOKEN_NAME] = $input.data(ew.API_FILE_TOKEN_NAME);
			$.get(url, data, updateProgress, "json");
		}

		// Import complete
		var importComplete = function(result) {
			var maxErrorCount = 5;
			var msg = "";
			showProgress(100);
			var fileResults = result.files;
			$dlg.find(".modal-footer .ew-close-btn").data("import-progress", false); // Stop import progress
			if ($.isArray(fileResults)) {
				for (var i = 0, len = fileResults.length; i < len; i++) {
					var fileResult = fileResults[i],
						tcnt = fileResult.totalCount || 0,
						cnt = fileResult.count || 0,
						scnt = fileResult.successCount || 0,
						fcnt = fileResult.failCount || 0;
					if (msg != "")
						msg += "<br>";
					if (fileResult.success) {
						msg += ew.language.phrase("ImportMessageSuccess").replace("%t", tcnt).replace("%c", cnt).replace("%f", fileResult.file);
					} else {
						msg += ew.language.phrase("ImportMessageError1").replace("%t", tcnt).replace("%c", cnt).replace("%f", fileResult.file).replace("%s", scnt).replace("%e", fcnt);
						if (fileResult.error)
							msg += ew.language.phrase("ImportMessageError2").replace("%e", fileResult.error);
						var showLog = true;
						if (fileResult.failList) {
							var ecnt = 0;
							for (var i = 1; i <= cnt; i++) {
								if (fileResult.failList["row" + i]) {
									ecnt += 1;
									msg += "<br>" + ew.language.phrase("ImportMessageError3").replace("%i", i).replace("%d", fileResult.failList["row" + i]);
								}
								if (ecnt >= maxErrorCount)
									break;
							}
							if (fcnt > maxErrorCount)
								msg += "<br>" + ew.language.phrase("ImportMessageMore").replace("%s", fcnt - maxErrorCount);
							else
								showLog = false;
						}
						if (fileResult.log && showLog)
							msg += "<br>" + ew.language.phrase("ImportMessageError4").replace("%l", fileResult.log);
						showMessage(msg, "text-danger"); // Show error message
					}
				}
			}
			if (result.success) {
				showMessage(msg, "text-success");
				$dlg.find(".modal-footer .ew-close-btn").data("imported", true);
			} else {
				if (result.error)
					msg = result.error;
				showMessage(msg, "text-danger"); // Show error message
			}
			hideProgress();
		}

		// Import fail
		var importFail = function(o) {
			$dlg.find(".modal-footer .ew-close-btn").data("import-progress", false); // Stop import progress
			showMessage(ew.language.phrase("ImportMessageServerError").replace("%s", o.status).replace("%t", o.statusText), "text-danger");
		}

		// Import file
		var importFiles = function(filetoken) {
			$body.css("cursor", "wait");
			$input.data(ew.API_FILE_TOKEN_NAME, filetoken);
			$dlg.find(".modal-footer .ew-close-btn").data("import-progress", true); // Show import progress
			var data = ew.API_ACTION_NAME + "=import&" + ew.API_FILE_TOKEN_NAME + "=" + encodeURIComponent(filetoken);
			if ($data.length)
				data += "&" + $data.serialize();
			$.ajax(currentPage(), {
				"data": data,
				"method": "POST",
				"dataType": "json",
				"beforeSend": function(xhr, settings) {
					timer = $.later(100, null, importProgress, null, true); // Use time to show progress periodically
				}
			}).done(importComplete).fail(importFail).always(function() {
				$body.css("cursor", "default");
				if (timer)
					timer.cancel(); // Clear timer
			});
		}

		var formData = { session: ew.SESSION_ID };
		formData[ew.TOKEN_NAME] = ew.ANTIFORGERY_TOKEN; // Add token for $.ajax() sent by jQuery File Upload (not by ajaxSend)
		var options = ew.importUploadOptions;
		if (!options.acceptFileTypes)
			options.acceptFileTypes = new RegExp('\\.(' + ew.IMPORT_FILE_ALLOWED_EXT.replace(/,/g, '|') + ')$', 'i');

		if (!$input.data("blueimpFileupload")) {
			$input.fileupload(ew.extend({
					url: getApiUrl(ew.API_UPLOAD_ACTION),
					dataType: "json",
					autoUpload: true,
					formData: formData,
					singleFileUploads: false,
					messages: {
						acceptFileTypes: ew.language.phrase("UploadErrMsgAcceptFileTypes"),
						maxFileSize: ew.language.phrase("UploadErrMsgMaxFileSize"),
						maxNumberOfFiles: ew.language.phrase("UploadErrMsgMaxNumberOfFiles"),
						minFileSize: ew.language.phrase("UploadErrMsgMinFileSize")
					},
					done: function(e, data) {
						if (data.result && data.result.files && $.isArray(data.result.files.importfiles)) {
							var ok = true;
							data.result.files.importfiles.forEach(function(file, index) {
								if (file.error) {
									showMessage(ew.language.phrase("ImportMessageUploadError").replace("%f", file.name).replace("%s", file.error), "text-danger");
									ok = false;
								}
							}); // Show upload errors for each file
							if (ok)
								importFiles(data.result[ew.API_FILE_TOKEN_NAME]); // Import uploaded files
						}
					},
					change: function(e, data) {
						hideMessage();
					},
					processfail: function(e, data) {
						data.files.forEach(function(file, index) {
							if (file.error)
								showMessage(ew.language.phrase("ImportMessageUploadError").replace("%f", file.name).replace("%s", file.error), "text-danger");
						}); // Show process errors for each file
					},
					fail: function(e, data) {
						showMessage(ew.language.phrase("ImportMessageServerError").replace("%s", data.textStatus).replace("%t", data.errorThrown), "text-danger");
					},
					progressall: function(e, data) {
						uploadProgress(data);
					}
			}, options));
		}

		$dlg.modal("hide").find(".modal-title").html(args.hdr);
		$dlg.find(".modal-footer .ew-close-btn").off("click.ew").on("click.ew", function() {
			var $this = $(this);
			if ($this.data("imported")) {
				$this.data("imported", false);
				window.location.reload(true);
			}
		});
		hideMessage();
		ew.importDialog = $dlg.modal("show");
		return false;
	}

	// Auto-fill
	function autoFill(el) {
		var f = forms(el).$element[0];
		if (!f)
			return;
		var ar = getOptionValues(el),
			id = getId(el),
			m = id.match(/^([xy])(\d*)_/),
			prefix = (m) ? m[1] : "",
			rowindex = (m) ? m[2] : "",
			nid = id.replace(/^([xy])(\d*)_/, "x_"),
			list = forms(el).lists[nid],
			dest_array = list.autoFillTargetFields;
		var success = function(data) {
			var results = data && data.records || "";
			var result = (results) ? results[0] : [];
			for (var j = 0; j < dest_array.length; j++) {
				var destEl = getElements(dest_array[j].replace(/^x_/, "x" + rowindex + "_"), f);
				if (destEl) {
					var val = ($.isValue(result["af" + j])) ? result["af" + j] : "";
					var args = {results: results, result: result, data: val, form: f, name: id, target: dest_array[j], cancel: false, trigger: true};
					$(el).trigger("autofill", [args]); // Fire event
					if (args.cancel)
						continue;
					val = args.data; // Process the value
					if (destEl.options || destEl.length && destEl[0].type == "radio") { // Selection/Radio list
						selectOption(destEl, val.split(","));
					} else if (destEl.length && destEl[0].type == "checkbox") { // Checkbox list
						selectOption(destEl, val.split(","));
					} else if (isAutoSuggest(destEl)) { // Auto-Suggest
						destEl.value = val;
						getAutoSuggest(destEl).input.value = val;
						updateOptions.call(forms[f.id], destEl);
					} else if (isModalLookup(destEl)) { // Modal-Lookup
						destEl.value = val;
						//$(destEl).parent().find(".ew-lookup-text").html(val);
						updateOptions.call(forms[f.id], destEl);
					} else if (isHiddenTextArea(destEl)) { // HTML editor
						destEl.value = val;
						$(destEl).data("editor").set();
					} else {
						destEl.value = val;
					}
					if (args.trigger)
						$(destEl).change();
				}
			}
			return result;
		};
		if (ar.length > 0 && ar[0] != "") {
			var data = ew.extend({
				page: list.page,
				field: list.field,
				ajax: "autofill",
				v0: ar[0],
				language: ew.LANGUAGE_ID
			}, getUserParams('#p_' + id, f));
			// Add parent field values
			var parentId = list.parentFields.slice(); // Clone
			if (rowindex != "") {
				for (var i = 0, len = parentId.length; i < len; i++) {
					var ar = parentId[i].split(" ");
					if (ar.length == 1) // Parent field in the same table, add row index
						parentId[i] = parentId[i].replace(/^x_/, "x" + rowindex + "_");
				}
			}
			var arp = parentId.map(function(pid) {
				return getOptionValues(pid, f);
			});
			for (var i = 0, cnt = arp.length; i < cnt; i++) // Filter by parent fields
				data["v" + (i + 1)] = arp[i].join(ew.MULTIPLE_OPTION_SEPARATOR);
			return $.post(getApiUrl(ew.API_LOOKUP_ACTION), data, success, "json");
		}
		return success();
	}

	// Setup tooltip links
	function tooltip(i, el) {
		var $this = $(el), $tt = $("#" + $this.data("tooltip-id")),
			trig = $this.data("trigger") || "hover", dir = $this.data("placement") || (ew.CSS_FLIP ? "left" : "right"); // dir = "left|right"
		if (!$tt[0] || $tt.text().trim() == "" && !$tt.find("img[src!='']")[0])
			return;
		if (!$this.data("bs.popover")) {
			$this.popover({
				html: true,
				placement: dir,
				trigger: trig,
				delay: 100,
				container: $("#ew-tooltip")[0],
				content: $tt.html(),
				sanitizeFn: ew.sanitizeFn
			}).on("show.bs.popover", function(e) {
				var wd, $tip = $($this.data("bs.popover").getTipElement()).css("z-index", 9999); // Make z-index higher than modal dialog
				if (wd = $this.data("tooltip-width")) // Set width before show
					$tip.css("max-width", parseInt(wd, 10) + "px");
			});
		}
	}

	/**
	 * Show dialog for email sending
	 *
	 * @param {Object} args - Arguments
	 * @param {string} args.lnk - Email link ID
	 * @param {string} args.hdr - Dialog header
	 * @param {string} args.url - URL of the email content
	 * @param {HTMLElement} args.f - Form
	 * @param {Object} args.key - Key as object
	 * @param {boolean} args.sel - Exported selected
	 * @returns false
	 */
	function emailDialogShow(args) {
		var $dlg = ew.emailDialog || $("#ew-email-dialog");
		if (!$dlg[0]) {
			_alert("DIV #ew-email-dialog not found.");
			return false;
		}
		if (args.sel && !keySelected(args.f)) {
			_alert(ew.language.phrase("NoRecordSelected"));
			return false;
		}
		var $f = $dlg.find(".modal-body form"),
			frm = $f.data("form");
		if (!frm) {
			frm = new Form($f.attr("id"));
			frm.validate = function() {
				var elm, fobj = this.getForm();
				elm = fobj.elements["sender"];
				if (elm && !hasValue(elm))
					return this.onError(elm, ew.language.phrase("EnterSenderEmail"));
				if (elm && !checkEmails(elm.value, 1))
					return this.onError(elm, ew.language.phrase("EnterProperSenderEmail"));
				elm = fobj.elements["recipient"];
				if (elm && !hasValue(elm))
					return this.onError(elm, ew.language.phrase("EnterRecipientEmail"));
				if (elm && !checkEmails(elm.value, ew.MAX_EMAIL_RECIPIENT))
					return this.onError(elm, ew.language.phrase("EnterProperRecipientEmail"));
				elm = fobj.elements["cc"];
				if (elm && !checkEmails(elm.value, ew.MAX_EMAIL_RECIPIENT))
					return this.onError(elm, ew.language.phrase("EnterProperCcEmail"));
				elm = fobj.elements["bcc"];
				if (elm && !checkEmails(elm.value, ew.MAX_EMAIL_RECIPIENT))
					return this.onError(elm, ew.language.phrase("EnterProperBccEmail"));
				elm = fobj.elements["subject"];
				if (elm && !hasValue(elm))
					return this.onError(elm, ew.language.phrase("EnterSubject"));
				return true;
			};
			frm.submit = function() {
				if (!this.validate())
					return false;
				var qs = $f.serialize(), data = "";
				if (args.f && args.sel) // Export selected
					data = $(args.f).find("input[type=checkbox][name='key_m[]']:checked").serialize();
				if (args.key)
					qs += "&" + $.param(args.key);
				var fobj = this.getForm();
				if (args.url) { // Custom Template
					$dlg.modal("hide");
					if (args.exportid)
						ew.exportWithCharts(args.el, args.url, args.exportid, fobj);
					else
						_export(args.f, args.url, "email", true, args.sel, fobj);
				} else {
					$.post($(args.f).attr("action"), qs + "&" + data, function(result) {
						showMessage(result);
					});
				}
				return true;
			};
			$f.data("form", frm);
		}
		$dlg.modal("hide").find(".modal-title").html(args.hdr);
		$dlg.find(".modal-footer .btn-primary").unbind().click(function(e) {
			e.preventDefault();
			if (frm.submit())
				$dlg.modal("hide");
		});
		ew.emailDialog = $dlg.modal("show");
		return false;
	}

	// Show drill down
	function showDrillDown(e, obj, url, id, hdr) {
		if (e && e.ctrlKey) {
			var arUrl = url.split("?"), params = new URLSearchParams(arUrl[1]);
			params.set("d", "2");  // Change d parameter to 2
			ew.redirect(arUrl[0] + "?" + params.toString());
			return false;
		}
		var $obj = ($.isString(obj)) ? $("#" + obj) : $(obj);
		var pos = $obj.data("drilldown-placement") || ($obj.hasClass("ew-chart-canvas") ? (ew.CSS_FLIP ? "left" : "right") : "bottom");
		$obj.tooltip("hide");
		var args = {"obj": $obj[0], "id": id, "url": url, "hdr": hdr, "placement": pos};
		$document.trigger("drilldown", [args]);
		var ar = args.url.split("?");
		args.file = ar[0] || "";
		args.data = ar[1] || "";
		if (!$obj.data("bs.popover")) {
			$obj.popover({
				html: true,
				placement: args.placement,
				trigger: "manual",
				template: '<div class="popover"><h3 class="popover-header d-none" style="cursor: move;"></h3><div class="popover-body"></div></div>',
				content: '<div class="' + ew.spinnerClass + ' m-3 ew-loading" role="status"><span class="sr-only">' + ew.language.phrase("Loading") + '</span></div>',
				container: $("#ew-drilldown-panel"),
				sanitizeFn: ew.sanitizeFn,
				boundary: "viewport"
			}).on("show.bs.popover", function(e) {
				$obj.attr("data-original-title", "");
			}).on("shown.bs.popover", function(e) {
				if (!$obj.data("args"))
					return;
				var data = $obj.data("args").data;
				data += (data ? "&" : "") + ew.TOKEN_NAME + "=" + ew.ANTIFORGERY_TOKEN; // Add token
				$.ajax({
					cache: false,
					dataType: "html",
					type: "POST",
					data: data,
					url: $obj.data("args").file,
					success: function(data) {
						var $tip = $($obj.data("bs.popover").getTipElement()).on("mousedown", function(e) {
							var $this = $(this).addClass("drag"),
								height = $this.outerHeight(),
								width = $this.outerWidth(),
								ypos = $this.offset().top + height - e.pageY,
								xpos = $this.offset().left + width - e.pageX;
							$body.on("mousemove", function(e) {
								var top = e.pageY + ypos - height,
									left = e.pageX + xpos - width;
								if ($this.hasClass("drag"))
									$this.offset({top: top, left: left});
							}).on("mouseup", function(e){
								$this.removeClass("drag");
							});
						});
						if (args.hdr)
							$tip.find(".popover-header").empty().removeClass("d-none")
								.append('<button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button>' + args.hdr)
								.find(".close").click(function() {
									$obj.popover("hide");
								});
						var m = data.match(/<body[^>]*>([\s\S]*?)<\/body\s*>/i); // Use HTML in document body only
						data = m ? m[0] : data;
						var html = ew.stripScript(data);
						$tip.find(".popover-body").html($("<div></div>").html(html).find("#ew-report")) // Insert the container table only
							.find(".ew-table").each(ew.setupTable);
						ew.executeScript(data, id);
						$obj.popover("update");
					},
					error: function(o) {
						if (o.responseText) {
							var $tip = $($el.data("bs.popover").getTipElement());
							$tip.find(".popover-body").empty().append('<p class="text-danger">' + o.responseText + '</p>');
						}
					}
				});
			}).on("hidden.bs.popover", function(e) {
				$.each(ew.drillDownCharts, function(key, cht) { // Dispose charts
					cht.dispose();
				});
				ew.drillDownCharts = {};
				ew.removeScript(id);
			});
		}
		$obj.data("args", args).popover("show");
	}

	/**
	 * Ajax query
	 * @param {Object} data - object to passed to API
	 * @param {callback} callback - Callback function for async request (see http://api.jquery.com/jQuery.post/), empty for sync request
	 * @returns {string|string[]}
	 */
	function ajax(data, callback) {
		if (!$.isObject(data))
			return undefined;
		var action = data.action;
		if (!action)
			return undefined;
		delete data.action;
		var obj = ew.extend({}, data);
		var _convert = function(response) {
			if ($.isObject(response) && response.result == "OK") {
				var results = response.records;
				if ($.isArray(results) && results.length == 1) { // Single row
					results = results[0];
					if ($.isArray(results) && results.length == 1) // Single column
						return results[0]; // Return a value
					else
						return results; // Return a row
				}
				return results;
			}
			return response;
		};
		var url = getApiUrl(action); // URL
		obj.type = obj.type || "POST";
		if ($.isFunction(callback)) { // Async
			obj.url = url;
			obj.dataType = "json";
			obj.success = function(response) {
				callback(_convert(response));
			};
			$.ajax(obj);
		} else { // Sync
			var type = obj.type;
			delete obj.type;
			var response = $.ajax({ url: url, async: false, type: type, data: obj }).responseText;
			response = parseJson(response);
			return _convert(response);
		}
	}

	// Get URL of current page
	function currentPage() {
		return location.href.split("#")[0].split("?")[0];
	}

	// Toggle search operator
	function toggleSearchOperator(id, value) {
		var el = this.form.elements[id];
		if (!el)
			return;
		el.value = (el.value != value) ? value : "=";
	}

	// Validators
	// Check US Date format (mm/dd/yyyy)
	function checkUSDate(object_value) {
		return checkDateEx(object_value, "us", ew.DATE_SEPARATOR);
	}

	// Check US Date format (mm/dd/yy)
	function checkShortUSDate(object_value) {
		return checkDateEx(object_value, "usshort", ew.DATE_SEPARATOR);
	}

	// Check Date format (yyyy/mm/dd)
	function checkDate(object_value) {
		return checkDateEx(object_value, "std", ew.DATE_SEPARATOR);
	}

	// Check Date format (yy/mm/dd)
	function checkShortDate(object_value) {
		return checkDateEx(object_value, "stdshort", ew.DATE_SEPARATOR);
	}

	// Check Euro Date format (dd/mm/yyyy)
	function checkEuroDate(object_value) {
		return checkDateEx(object_value, "euro", ew.DATE_SEPARATOR);
	}

	// Check Euro Date format (dd/mm/yy)
	function checkShortEuroDate(object_value) {
		return checkDateEx(object_value, "euroshort", ew.DATE_SEPARATOR);
	}

	// Check default date format
	function checkDateDef(object_value) {
		if (ew.DATE_FORMAT.match(/^yyyy/))
			return checkDate(object_value);
		else if (ew.DATE_FORMAT.match(/^yy/))
			return checkShortDate(object_value);
		else if (ew.DATE_FORMAT.match(/^m/) && ew.DATE_FORMAT.match(/yyyy$/))
			return checkUSDate(object_value);
		else if (ew.DATE_FORMAT.match(/^m/) && ew.DATE_FORMAT.match(/yy$/))
			return checkShortUSDate(object_value);
		else if (ew.DATE_FORMAT.match(/^d/) && ew.DATE_FORMAT.match(/yyyy$/))
			return checkEuroDate(object_value);
		else if (ew.DATE_FORMAT.match(/^d/) && ew.DATE_FORMAT.match(/yy$/))
			return checkShortEuroDate(object_value);
		return false;
	}

	// Check date format
	// format: std/stdshort/us/usshort/euro/euroshort
	function checkDateEx(value, format, sep) {
		if (!value || value.length == "")
			return true;
		value = value.replace(/ +/g, " ").trim();
		var arDT = value.split(" ");
		if (arDT.length > 0) {
			var re, ar, sYear, sMonth, sDay;
			re = /^(\d{4})-([0][1-9]|[1][0-2])-([0][1-9]|[1|2]\d|[3][0|1])$/;
			if (ar = re.exec(arDT[0])) {
				sYear = ar[1];
				sMonth = ar[2];
				sDay = ar[3];
			} else {
				var wrksep = escapeRegExChars(sep);
				switch (format) {
					case "std":
						re = new RegExp("^(\\d{4})" + wrksep + "([0]?[1-9]|[1][0-2])" + wrksep + "([0]?[1-9]|[1|2]\\d|[3][0|1])$");
						break;
					case "stdshort":
						re = new RegExp("^(\\d{2})" + wrksep + "([0]?[1-9]|[1][0-2])" + wrksep + "([0]?[1-9]|[1|2]\\d|[3][0|1])$");
						break;
					case "us":
						re = new RegExp("^([0]?[1-9]|[1][0-2])" + wrksep + "([0]?[1-9]|[1|2]\\d|[3][0|1])" + wrksep + "(\\d{4})$");
						break;
					case "usshort":
						re = new RegExp("^([0]?[1-9]|[1][0-2])" + wrksep + "([0]?[1-9]|[1|2]\\d|[3][0|1])" + wrksep + "(\\d{2})$");
						break;
					case "euro":
						re = new RegExp("^([0]?[1-9]|[1|2]\\d|[3][0|1])" + wrksep + "([0]?[1-9]|[1][0-2])" + wrksep + "(\\d{4})$");
						break;
					case "euroshort":
						re = new RegExp("^([0]?[1-9]|[1|2]\\d|[3][0|1])" + wrksep + "([0]?[1-9]|[1][0-2])" + wrksep + "(\\d{2})$");
						break;
				}
				if (!re.test(arDT[0]))
					return false;
				var arD = arDT[0].split(sep);
				switch (format) {
					case "std":
					case "stdshort":
						sYear = unformatYear(arD[0]);
						sMonth = arD[1];
						sDay = arD[2];
						break;
					case "us":
					case "usshort":
						sYear = unformatYear(arD[2]);
						sMonth = arD[0];
						sDay = arD[1];
						break;
					case "euro":
					case "euroshort":
						sYear = unformatYear(arD[2]);
						sMonth = arD[1];
						sDay = arD[0];
						break;
				}
			}
			if (!checkDay(sYear, sMonth, sDay))
				return false;
		}
		if (arDT.length > 1 && !checkTime(arDT[1]))
			return false;
		return true;
	}

	// Unformat 2 digit year to 4 digit year
	function unformatYear(yr) {
		if (yr.length == 2)
			return (yr > ew.UNFORMAT_YEAR) ? "19" + yr : "20" + yr;
		return yr;
	}

	// Check day
	function checkDay(checkYear, checkMonth, checkDay) {
		checkYear = parseInt(checkYear, 10);
		checkMonth = parseInt(checkMonth, 10);
		checkDay = parseInt(checkDay, 10);
		var maxDay = [4, 6, 9, 11].includes(checkMonth) ? 30 : 31;
		if (checkMonth == 2)
			maxDay = (checkYear % 4 > 0 || checkYear % 100 == 0 && checkYear % 400 > 0) ? 28 : 29;
		return checkRange(checkDay, 1, maxDay);
	}

	// Check integer
	function checkInteger(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		if (object_value.includes(ew.DECIMAL_POINT))
			return false;
		return checkNumber(object_value);
	}

	// Check number
	function checkNumber(object_value) {
		object_value = String(object_value);
		if (!object_value || object_value.length == 0)
			return true;
		object_value = object_value.trim();
		var ts = escapeRegExChars(ew.THOUSANDS_SEP), dp = escapeRegExChars(ew.DECIMAL_POINT),
			re = new RegExp("^[+-]?(\\d{1,3}(" + (ts ? ts + "?" : "") + "\\d{3})*(" + dp + "\\d+)?|" + dp + "\\d+)$");
		return re.test(object_value);
	}

	// Convert to float
	function stringToFloat(object_value) {
		object_value = String(object_value);
		if (ew.THOUSANDS_SEP != "") {
			var re = new RegExp(escapeRegExChars(ew.THOUSANDS_SEP), "g");
			object_value = object_value.replace(re, "");
		}
		if (ew.DECIMAL_POINT != "")
			object_value = object_value.replace(ew.DECIMAL_POINT, ".");
		return parseFloat(object_value);
	}

	// Convert string (yyyy-mm-dd hh:mm:ss) to date object
	function stringToDate(object_value) {
		var re = /^(\d{4})-([0][1-9]|[1][0-2])-([0][1-9]|[1|2]\d|[3][0|1]) (?:(0\d|1\d|2[0-3]):([0-5]\d):([0-5]\d))?$/;
		var ar = object_value.replace(re, "$1 $2 $3 $4 $5 $6").split(" ");
		return new Date(ar[0], ar[1]-1, ar[2], ar[3], ar[4], ar[5]);
	}

	// Escape regular expression chars
	function escapeRegExChars(str) {
		return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
	}

	// Check range
	function checkRange(object_value, min_value, max_value) {
		if (!object_value || object_value.length == 0)
			return true;
		if ($.isNumber(min_value) || $.isNumber(max_value)) { // Number
			if (checkNumber(object_value))
				object_value = stringToFloat(object_value);
		}
		if (!$.isNull(min_value) && object_value < min_value)
			return false;
		if (!$.isNull(max_value) && object_value > max_value)
			return false;
		return true;
	}

	// Check time
	function checkTime(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		object_value = object_value.trim();
		var re = new RegExp('^(0\\d|1\\d|2[0-3])' + escapeRegExChars(ew.TIME_SEPARATOR) + '[0-5]\\d(( (' + escapeRegExChars(ew.language.phrase("AM")) + '|' + escapeRegExChars(ew.language.phrase("PM")) + '))|(' + escapeRegExChars(ew.TIME_SEPARATOR) + '[0-5]\\d(\\.\\d+)?)?)$', 'i');
		return re.test(object_value);
	}

	// Check phone
	function checkPhone(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		return /^\(\d{3}\) ?\d{3}( |-)?\d{4}|^\d{3}( |-)?\d{3}( |-)?\d{4}$/.test(object_value.trim());
	}

	// Check zip
	function checkZip(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		return /^\d{5}$|^\d{5}-\d{4}$/.test(object_value.trim());
	}

	// Check credit card
	function checkCreditCard(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		var creditcard_string = object_value.replace(/\D/g, "");
		if (creditcard_string.length == 0)
			return false;
		var doubledigit = creditcard_string.length % 2 == 1 ? false : true;
		var tempdigit, checkdigit = 0;
		for (var i = 0, len = creditcard_string.length; i < len; i++) {
			tempdigit = parseInt(creditcard_string.charAt(i), 10);
			if (doubledigit) {
				tempdigit *= 2;
				checkdigit += (tempdigit % 10);
				if (tempdigit / 10 >= 1.0)
					checkdigit++;
				doubledigit = false;
			}	else {
				checkdigit += tempdigit;
				doubledigit = true;
			}
		}
		return (checkdigit % 10 == 0);
	}

	// Check social security number
	function checkSsc(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		return /^(?!000)([0-6]\d{2}|7([0-6]\d|7[012]))([ -]?)(?!00)\d\d\3(?!0000)\d{4}$/.test(object_value.trim());
	}

	// Check emails
	function checkEmails(object_value, email_cnt) {
		if (!object_value || object_value.length == 0)
			return true;
		var arEmails = object_value.replace(/,/g, ";").split(";");
		for (var i = 0, len = arEmails.length; i < len; i++) {
			if (email_cnt > 0 && len > email_cnt)
				return false;
			if (!checkEmail(arEmails[i]))
				return false;
		}
		return true;
	}

	// Check email
	function checkEmail(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		return /^[\w.%+-]+@[\w.-]+\.[A-Z]{2,18}$/i.test(object_value.trim());
	}

	// Check GUID {xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx}
	function checkGuid(object_value) {
		if (!object_value || object_value.length == 0)
			return true;
		return /^(\{\w{8}-\w{4}-\w{4}-\w{4}-\w{12}\}|\w{8}-\w{4}-\w{4}-\w{4}-\w{12})$/.test(object_value.trim());
	}

	// Check by regular expression
	function checkByRegEx(object_value, pattern) {
		if (!object_value || object_value.length == 0)
			return true;
		return !!object_value.match(pattern);
	}

	/**
	 * Show message dialog
	 *
	 * @param {Event|string} arg - Event or message
	 * @returns
	 */
	function showMessage(arg) {
		if (window.location != window.parent.location && parent.showMessage) // In iframe
			return parent.showMessage(arg);
		var p = (arg && arg.target) ? arg.target : document,
			$div = $(p).find("div.ew-message-dialog:hidden:first"),
			msg = $.isString(arg) ? arg.replace(/<[^>]*>/g, "") : ($div.length ? $div.text() : ""); // Text only
		if (msg.trim() == "")
			return;
		if ($div.length) {
			["success", "info", "warning", "danger"].forEach(function(value, index) {
				var $alert = $div.find(".alert-" + value).toggleClass("alert-" + value),
					$heading = $alert.find(".alert-heading").detach(),
					$content = $alert.children(":not(.icon)");
				$alert.find(".icon").remove();
				if ($alert[0]) {
					if (ew.IS_MOBILE) {
						alert($alert.text());
					} else {
						var $toast = $(ew.toastTemplate),
							$header = $toast.find(".toast-header").addClass("bg-" + value);
						if ($heading[0])
							$header.find("strong").html($heading.html());
						else
							$header.find("strong").html(ew.language.phrase(value));
						var w = parseInt($content.css("width"), 10); // Width specified
						if (w > 0) {
							$content.first().css("width", "auto");
							$toast.css("max-width", w); // Override bootstrap .toast max-width
						}
						var msg = $alert.html();
						$toast.find(".toast-body").html(msg);
						var options = {
							animation: true,
							autohide: (value == "success") ? ew.autoHideSuccessMessage : false, // Autohide for success message
							delay: (value == "success") ? ew.autoHideSuccessMessageDelay: 500
						};
						if (!$("#toast-container")[0])
							$body.append('<div id="toast-container"></div>');
						var $container = $("#toast-container").append($toast);
						$toast.toast(options).toast("show").on("hidden.bs.toast", function() {
							if ($container[0] && !$container.find(".toast.show")[0])
								$container.remove();
						});
					}
				}
			});
		} else { // Fallback to message box
			if (ew.IS_MOBILE) {
				alert(msg);
			} else {
				var $dlg = $("#ew-message-box");
				$dlg.find(".modal-body").html(msg);
				$dlg.modal("show");
			}
		}
	}

	// Random number
	function random() {
		return Math.floor(Math.random() * 100001) + 100000;
	}

	// File upload
	function upload(input) {
		var $input = $(input);
		if ($input.data("blueimpFileupload"))
			return;
		var id = $input.attr("name"), nid = id.replace(/\$/g, "\\$"), tbl = $input.data("table"),
			multiple = $input.is("[multiple]"), $p = $input.closest(".form-group, [id^='el']"),
			readonly = $input.prop("disabled") || $input.closest("form").find("#confirm").val() == "confirm",
			$ft = $p.find("#ft_" + nid), $fn = $p.find("#fn_" + nid), $fa = $p.find("#fa_" + nid), $fs = $p.find("#fs_" + nid),
			$exts = $p.find("#fx_" + nid), $maxsize = $p.find("#fm_" + nid), $maxfilecount = $p.find("#fc_" + nid),
			$label = $p.find(".custom-file-label"), label = $label.html();
		var _done = function(e, data) {
			if (data.result.files[0].error)
				return;
			var name = data.result.files[0].name;
			var ar = (multiple) ? ($fn.val() ? $fn.val().split(ew.MULTIPLE_UPLOAD_SEPARATOR) : []) : [];
			ar.push(name);
			$fn.val(ar.join(ew.MULTIPLE_UPLOAD_SEPARATOR));
			$fa.val("0");
			if (!multiple) // Remove other entries if not multiple upload
				$ft.find("tr:not(:last)").remove();
		};
		var _deleted = function(e, data) {
			var url = $(e.originalEvent.target).data("url"),
				param = new URLSearchParams(url.split("?")[1]),
				fid = param.get("id"),
				name = param.get(fid);
			if (name) {
				var ar = $fn.val() ? $fn.val().split(ew.MULTIPLE_UPLOAD_SEPARATOR) : [];
				var index = ar.indexOf(name);
				if (index > -1)
					ar.splice(index, 1);
				$fn.val(ar.join(ew.MULTIPLE_UPLOAD_SEPARATOR));
				$fa.val("0");
			}
		};
		var _change = function(e, data) {
			var ar = $fn.val() ? $fn.val().split(ew.MULTIPLE_UPLOAD_SEPARATOR) : [];
			for (var i = 0; i < data.files.length; i++)
				ar.push(data.files[i].name);
			var cnt = parseInt($maxfilecount.val(), 10);
			if ($.isNumber(cnt) && cnt > 0 && ar.length > cnt) {
				_alert(ew.language.phrase("UploadErrMsgMaxNumberOfFiles"));
				return false;
			}
			var l = parseInt($fs.val(), 10);
			if ($.isNumber(l) && l > 0 && ar.join(ew.MULTIPLE_UPLOAD_SEPARATOR).length > l) {
				_alert(ew.language.phrase("UploadErrMsgMaxFileLength"));
				return false;
			}
		};
		var _confirmDelete = function(e) {
			if (!multiple && $fn.val()) {
				if (!confirm(ew.language.phrase("UploadOverwrite"))) {
					e.preventDefault();
					e.stopPropagation();
				}
			}
		};
		var _changed = function() {
			$ft.css("margin-top", ($ft.find("tr")[0] && !readonly) ? "10px" : "0");
			var ar = $fn.val() ? $fn.val().split(ew.MULTIPLE_UPLOAD_SEPARATOR) : [];
			$label.html(ar.join(", ") || label);
		};
		var _clicked = function() {
			$input.closest("span.fileinput-button").tooltip("hide");
		};
		var _processfail = function(e, data) {
			if (data.files && data.files.error)
				_alert(data.files[0].error);
		};
		var _downloadTemplate = $.templates("#template-download");
		var _uploadTemplate = $.templates("#template-upload");
		var _completed = function(e, data) { // After download template rendered
			var e = { target: data.context };
			initLightboxes(e);
			initPdfObjects(e);
		};
		var _added = function(e, data) { // After upload template rendered
			data.context.find(".start").click(_confirmDelete);
		};
		// Hide input button if readonly
		var form = getForm(input), $form = $(form);
		var readonly = $form.find("#confirm").val() == "confirm";
		if (readonly)
			$form.find("span.fileinput-button").hide();
		var cnt = parseInt($maxfilecount.val(), 10);
		var uploadUrl = getApiUrl(ew.API_JQUERY_UPLOAD_ACTION);
		var formData = {
			id: id,
			table: tbl,
			session: ew.SESSION_ID,
			replace: (multiple ? "0" : "1"),
			exts: $exts.val(),
			maxsize: $maxsize.val(),
			maxfilecount: $maxfilecount.val()
		};
		$input.fileupload({
			url: uploadUrl,
			type: "POST",
			multipart: true,
			autoUpload: true, // Comment out to disable auto upload
			loadImageFileTypes: /^image\/(gif|jpe?g|png)$/i,
			loadVideoFileTypes: /^video\/mp4$/i,
			loadAudioFileTypes: /^audio\/(mpeg|mp3)$/i,
			acceptFileTypes: ($exts.val()) ? new RegExp('\\.(' + $exts.val().replace(/,/g, '|') + ')$', 'i') : null,
			maxFileSize: parseInt($maxsize.val(), 10),
			maxNumberOfFiles: (cnt > 1) ? cnt : null,
			filesContainer: $ft,
			formData: formData,
			uploadTemplateId: null,
			downloadTemplateId: null,
			uploadTemplate: _uploadTemplate.render.bind(_uploadTemplate),
			downloadTemplate: _downloadTemplate.render.bind(_downloadTemplate),
			previewMaxWidth: ew.UPLOAD_THUMBNAIL_WIDTH,
			previewMaxHeight: ew.UPLOAD_THUMBNAIL_HEIGHT,
			dropZone: $p,
			pasteZone: $p,
			messages: {
				acceptFileTypes: ew.language.phrase("UploadErrMsgAcceptFileTypes"),
				maxFileSize: ew.language.phrase("UploadErrMsgMaxFileSize"),
				maxNumberOfFiles: ew.language.phrase("UploadErrMsgMaxNumberOfFiles"),
				minFileSize: ew.language.phrase("UploadErrMsgMinFileSize")
			},
			readOnly: readonly // Custom
		}).on("fileuploaddone", _done)
			.on("fileuploaddestroy", _deleted)
			.on("fileuploadchange", _change)
			.on("fileuploadadded fileuploadfinished fileuploaddestroyed", _changed)
			.on("fileuploadprocessfail", _processfail)
			.on('fileuploadadded', _added)
			.on('fileuploadcompleted', _completed)
			.click(_clicked);
		if ($fn.val()) {
			$.ajax({
				url: uploadUrl,
				data: { id: id, table: tbl, session: ew.SESSION_ID },
				dataType: "json",
				context: this,
				success: function(result) {
					if (result && result[id]) {
						var done = $input.fileupload("option", "done");
						if (done)
							done.call(input, $.Event(), { result: { files: result[id] } }); // Use "files"
					}
					if (readonly) // Hide delete button if readonly
						$ft.find("td.delete").hide();
				}
			});
		}
	}

	/**
	 * Convert data to number
	 *
	 * @param {*} data - Data being converted
	 * @param {Object} [config] - Configuration
	 * @param {string} config.decimalSeparator - Decimal separator
	 * @param {string} config.thousandsSeparator - Thousands separator
	 * @returns {(number|null)}
	 */
	function parseNumber(data, config) {
		if ($.isString(data)) {
			config = config || {"thousandsSeparator": ew.THOUSANDS_SEP, "decimalSeparator": ew.DECIMAL_POINT};
			var regexBits = [], regex, separator = config.thousandsSeparator, decimal = config.decimalSeparator;
			if (separator)
				regexBits.push(escapeRegExChars(separator) + "(?=\\d)");
			regex = new RegExp("(?:" + regexBits.join("|") + ")", "g");
			if (decimal === ".")
				decimal = null;
			data = data.replace(regex, "");
			data = (decimal) ? data.replace(decimal, ".") : data;
		}
		if ($.isString(data) && data.trim() !== "")
			data = +data;
		if (!$.isNumber || !isFinite(data)) // Catch NaN and Infinity
			data = null;
		return data;
	}

	/**
	 * Format a Number to string for display
	 *
	 * @param {*} data - Data being converted
	 * @param {Object} [config] - Configuration
	 * @param {number} config.decimalPlaces - Number of decimal places to round. Must be a number 0 to 20.
	 * @param {string} config.decimalSeparator - Decimal separator
	 * @param {string} config.thousandsSeparator - Thousands separator
	 * @returns {string} Note: null, undefined, NaN and "" returns as "".
	 */
	function formatNumber(data, config) {
		if ($.isNumber(data)) {
			config = config || {"thousandsSeparator": ew.THOUSANDS_SEP, "decimalSeparator": ew.DECIMAL_POINT};
			var isNeg = (data < 0), output = data + "", decPlaces = config.decimalPlaces,
				decSep = config.decimalSeparator || ".", thouSep = config.thousandsSeparator,
				decIndex, newOutput, count, i;
			if ($.isNumber(decPlaces) && (decPlaces >= 0) && (decPlaces <= 20)) // Decimal precision
				output = data.toFixed(decPlaces);
			if (decSep !== ".") // Decimal separator
				output = output.replace(".", decSep);
			if (thouSep) { // Add the thousands separator
				decIndex = output.lastIndexOf(decSep); // Find the dot or where it would be
				decIndex = (decIndex > -1) ? decIndex : output.length;
				newOutput = output.substring(decIndex); // Start with the dot and everything to the right
				for (count = 0, i = decIndex; i > 0; i--) { // Working left, every third time add a separator, every time add a digit
					if (count%3 === 0 && i !== decIndex && (!isNeg || i > 1))
						newOutput = thouSep + newOutput;
					newOutput = output.charAt(i-1) + newOutput;
					count++;
				}
				output = newOutput;
			}
			return output;
		} else { // Not a Number, return as string
			return ($.isValue(data) && data.toString) ? data.toString() : "";
		}
	}

	/**
	 * Convert data to Moment object (see http://momentjs.com/docs/)
	 *
	 * @param {*} data - Data being converted
	 * @param {number} format - Date format matching server side FormatDateTime()
	 * @returns {Moment}
	 */
	function parseDate(data, format) {
		var args = $.makeArray(arguments);
		if ($.isNumber(format) && format >=0 && format <= 17) {
			var f, def = ew.DATE_FORMAT.toUpperCase(), sep = ew.DATE_SEPARATOR, timesep = ew.TIME_SEPARATOR;
			switch (format) {
				case 0: case 1: case 2: case 8: f = def + " HH" + timesep + "mm" + timesep + "ss"; break; // ew.DATE_FORMAT + " %H:%M:%S"
				case 3: f = "hh:mm:ss A"; break; // "%I:%M:%S %p"
				case 4: f = "HH:mm:ss"; break; // "%H:%M:%S"
				case 5: f = "YYYY" + sep + "MM" + sep + "DD"; break; // "%Y" + sep + "%m" + sep + "%d"
				case 6: f = "MM" + sep + "DD" + sep + "YYYY"; break; // "%m" + sep + "%d" + sep + "%Y"
				case 7: f = "DD" + sep + "MM" + sep + "YYYY"; break; // "%d" + sep + "%m" + sep + "%Y"
				case 9: f = "YYYY" + sep + "MM" + sep + "DD HH" + timesep + "mm" + timesep + "ss"; break; // "%Y" + sep + "%m" + sep + "%d %H:%M:%S"
				case 10: f = "MM" + sep + "DD" + sep + "YYYY HH" + timesep + "mm" + timesep + "ss"; break; // "%m" + sep + "%d" + sep + "%Y %H:%M:%S"
				case 11: f = "DD" + sep + "MM" + sep + "YYYY HH" + timesep + "mm" + timesep + "ss"; break; // "%d" + sep + "%m" + sep + "%Y %H:%M:%S"
				case 12: f = "YY" + sep + "MM" + sep + "DD"; break; // "%y" + sep + "%m" + sep + "%d"
				case 13: f = "MM" + sep + "DD" + sep + "YY"; break; // "%m" + sep + "%d" + sep + "%y"
				case 14: f = "DD" + sep + "MM" + sep + "YY"; break; // "%d" + sep + "%m" + sep + "%y"
				case 15: f = "YY" + sep + "MM" + sep + "DD HH" + timesep + "mm" + timesep + "ss"; break; // "%y" + sep + "%m" + sep + "%d %H:%M:%S"
				case 16: f = "MM" + sep + "DD" + sep + "YY HH" + timesep + "mm" + timesep + "ss"; break; // "%m" + sep + "%d" + sep + "%y %H:%M:%S"
				case 17: f = "DD" + sep + "MM" + sep + "YY HH" + timesep + "mm" + timesep + "ss"; break; // "%d" + sep + "%m" + sep + "%y %H:%M:%S"
			}
			args[1] = [f, "YYYY-MM-DD HH" + timesep + "mm" + timesep + "ss"];
		}
		return moment.apply(this, args);
	}

	/**
	 * Format date time
	 *
	 * @param {*} data - Date being formatted
	 * @param {string} format - Date format (see http://momentjs.com/docs/#/displaying/format/)
	 * @returns {string}
	 */
	function formatDate(data, format) {
		return moment(data).format(format || ew.DATE_FORMAT.toUpperCase());
	}

	/**
	 * Init page
	 *
	 * @param {Event|undefined} e - Event
	 */
	function initPage(e) {
		var el = (e && e.target) ? e.target : document,
			$el = $(el),
			$tables = $el.find("table.ew-table:not(.ew-export-table)");
		Array.prototype.forEach.call(el.querySelectorAll(".ew-grid-upper-panel, .ew-grid-lower-panel"), ew.initGridPanel); // Init grid panels
		ew.renderJsTemplates(e);
		initForms(e);
		initTooltips(e);
		initPasswordOptions(e);
		initIcons(e);
		initLightboxes(e);
		initPdfObjects(e);
		$el.find("[data-widget='treeview']").each(function() {
			adminlte.Treeview._jQueryInterface.call($(this), "init");
		});
		$tables.each(setupTable); // Init tables
		$el.find(".ew-btn-dropdown").on("shown.bs.dropdown", function() {
			var $this = $(this).removeClass("dropup"), $window = $(window); $menu = $this.find("> .dropdown-menu");
			$this.toggleClass("dropup", $menu.offset().top + $menu.height() > $window.scrollTop() + $window.height());
		});
		$el.find("input[name=pageno]").keypress(function(e) {
			if (e.which == 13) {
				currentUrl.searchParams.append(this.name, parseInt(this.value));
				window.location = currentUrl.toString();
				return false;
			}
		});
		if (!ew.IS_SCREEN_SM_MIN) {
			$el.find("." + ew.RESPONSIVE_TABLE_CLASS + " [data-toggle='dropdown']").parent().on("shown.bs.dropdown", function() {
				var $this = $(this), $menu = $this.find(".dropdown-menu"), div = $this.closest("." + ew.RESPONSIVE_TABLE_CLASS)[0];
				if (div.scrollHeight - div.clientHeight) {
					var d = $menu.offset().top + $menu.outerHeight() - $(div).offset().top - div.clientHeight;
					if (d > 0)
						$menu.css(ew.CSS_FLIP ? "right" : "left", "100%").css("top", parseFloat($menu.css("top")) - d);
				}
			});
		}
		lazyLoad(e);
		initExportLinks(e);
		initMultiSelectCheckboxes(e);

		// Report
		var $rpt = $el.find(".ew-report");
		if ($rpt[0]) {
			$rpt.find(".card").on("collapsed.lte.widget", function() { // Fix min-height when .lte.widget is collapsed
				var $card = $(this), $div = $card.closest("[class^='col-']"), mh = $div.css("min-height");
				if (mh)
					$div.data("min-height", mh);
				$div.css("min-height", 0);
			}).on("expanded.lte.widget", function() { // Fix min-height when .lte.widget is expanded
				var $card = $(this), $div = $card.closest("[class^='col-']"), mh = $div.css("min-height");
				if (mh)
					$div.css("min-height", mh); // Restore min-height
			});
			// Group expand/collapse button
			$rpt.find("span.ew-group-toggle").on("click", function() {
				ew.toggleGroup(this);
			});
		}

		// Show message
		if (typeof ew.USE_JAVASCRIPT_MESSAGE != "undefined" && ew.USE_JAVASCRIPT_MESSAGE)
			showMessage(e);
	}

	// Redirect by HTTP GET or POST
	function redirect(url, f, method) {
		var ar = url.split("?"),
			params = new URLSearchParams(ar[1]);
		params.set(ew.TOKEN_NAME, ew.ANTIFORGERY_TOKEN);
		if (sameText(method, "post")) { // POST
			var $form = (f) ? $(f) : $("<form></form>").appendTo("body");
			$form.attr({ action: ar[0], method: "post" });
			params.forEach(function(value, key) {
				$('<input type="hidden">').attr({ name: key, value: sanitize(value) }).appendTo($form);
			});
			$form.submit();
		} else { // GET
			var search = params.toString();
			window.location = ar[0] + (search ? "?" + search : "");
		}
	}

	// Show/Hide password
	function togglePassword(e) {
		var $btn = $(e.currentTarget), $input = $btn.closest(".input-group").find("input"), $i = $btn.find("i");
		if ($input.attr("type") == "text") {
			$input.attr("type", "password");
			$i.toggleClass("fa-eye-slash fa-eye");
		} else if($input.attr("type") == "password"){
			$input.attr("type", "text");
			$i.toggleClass("fa-eye-slash fa-eye");
		}
	}

	// Export with charts
	function exportWithCharts(e, url, exportId, f) {
		var el = e.target;
		exportId += "_" + Date.now();
		url += (url.split("?").length > 1 ? "&" : "?") + "exportid=" + exportId;
		var p = currentPage(), rootPath = p.substring(0, p.lastIndexOf("/") + 1);
		url = rootPath + url; // Use full URL

		var $el = $(el), method = (f) ? "post" : "get";
		if ($el.is(".dropdown-menu a"))
			$el = $el.closest(".btn-group");

		var _export = function() {
			var exportUrl = url.replace(/&amp;/g, "&"),
				obj = new URL(exportUrl),
				params = obj.searchParams,
				custom = params.get("custom") == "1";
			if (f && !custom) { // Not custom
				var data = $(f).serialize(); // Add token
				$.post(exportUrl, data, function(result) {
					ew.showMessage(result);
				});
			} else { // Custom
				var exp = params.get("export");
				if (custom && ["word", "excel", "pdf", "email"].includes(exp)) {
					if (exp == "email") {
						params.delete("export"); // Remove duplicate export=email (exists in form)
						exportUrl = obj.toString() + "&" + $(f).serialize();
					}
					$("iframe.ew-export").remove();
					$("<iframe></iframe>").addClass("ew-export d-none").attr("src", exportUrl).appendTo($body.css("cursor", "wait"));
					setTimeout(function() { $body.css("cursor", "default"); }, 5000);
				} else if (exp == "print") {
					ew.redirect(exportUrl, f, method);
				} else {
					ew.fileDownload(exportUrl, null);
				}
			}
			return false;
		};

		var keys = Object.keys(window.exportCharts);
		if (keys.length == 0) // No charts, just submit the form
			return _export();

		// Success callback
		var success = function(result) {
			if ($.isString(result))
				result = parseJson(result);
			if (result.success) {
				_export();
			} else {
				ew.alert(result.error);
			}
		};

		// Failure callback
		var fail = function(xhr, status, error) {
			ew.alert(error + ": " + xhr.responseText); // Show detailed export error message
		};

		// Export charts
		$body.css("cursor", "wait");
		var charts = [];
		for (var i = 0; i < keys.length; i++) {
			var id = keys[i], o = window.exportCharts[id],
				params = "exportfilename=" + exportId + "_" + id + ".png|exportformat=png|exportaction=download|exportparameters=undefined";
			if (o && o.toBase64Image) // Chart.js chart
				charts.push({ "chart_engine": "Chart.js", "stream_type": "base64", "stream": o.toBase64Image(), "parameters": params });
		}
		$.ajax({
			"url": getApiUrl(ew.API_EXPORT_CHART_ACTION),
			"data": { "charts": JSON.stringify(charts) },
			"cache": false,
			"type": "POST"
		}).done(success).fail(fail).always(function() {
			$("#ew-message-box").find(".modal-footer button").prop("disabled", false); // Enable the button disabled by fileDownload()
			$body.css("cursor", "default");
		});
		return false;
	}

	// Init Treeview later
	$(window).off("load.lte.treeview");

	// Layout
	var Layout = adminlte.Layout, Treeview = adminlte.Treeview, $wrapper, _fixLayoutHeightTimer;

	// Fix layout height
	function fixLayoutHeight() {
		if (_fixLayoutHeightTimer)
			_fixLayoutHeightTimer.cancel(); // Clear timer
		_fixLayoutHeightTimer = $.later(50, null, function() {
			var layout = $body.data("lte.layout");
			if (layout)
				layout.fixLayoutHeight();
		});
	}

	// Treeview
	Treeview.prototype._toggle = Treeview.prototype.toggle;
	Treeview.prototype.toggle = function toggle(event) {
		var $relativeTarget = $(event.currentTarget), treeviewMenu = $relativeTarget.next(),
			href = $relativeTarget.attr("href"), $text = $(event.target).closest(".menu-item-text");
		if (!treeviewMenu.is(".nav-treeview") || $text[0] && href && href != "#" && href != "javascript:void(0);") // Menu text with href
			return;
		this._toggle(event);
	};

	// Init document
	loadjs.ready("load", function() {
		$.views.settings.debugMode(ew.DEBUG);
		setSessionTimer();
		initPage();
		$("#ew-modal-dialog").on("load.ew", initPage);
		$("#ew-add-opt-dialog").on("load.ew", initPage);
		var hash = currentUrl.searchParams.get("hash");
		if (hash)
			$("html, body").animate({ scrollTop: $("#" + hash).offset().top }, 800);
		removeSpinner();
		$document.trigger("load");
	});

	// Default "addoption" event (fired before adding new option to selection list)
	$document.on("addoption", function(e, args) {
		var row = args.data; // New row to be validated
		var arp = args.parents; // Parent field values
		for (var i = 0, cnt = arp.length; i < cnt; i++) { // Iterate parent values
			var p = arp[i];
			if (!p.length) // Empty parent
				//continue; // Allow
				return args.valid = false; // Disallow
			var val = row["ff" + ((i > 0) ? i + 1 : "")]; // Filter fields start from the 6th field
			if (!$.isUndefined(val) && !p.includes(String(val))) // Filter field value not in parent field values
				return args.valid = false; // Returns false if invalid
		}
	});

	// Fix z-index of multiple modals
	$document.on("show.bs.modal", ".modal", function() {
		var zIndex = 1040 + $(".modal:visible").length;
		$(this).css("z-index", zIndex);
		setTimeout(function() {
			$(".modal-backdrop").not(".modal-stack").css("z-index", zIndex - 1).addClass("modal-stack");
		}, 0);
	});

	// Fix scrolling of multiple modals
	$document.on("hidden.bs.modal", ".modal", function() {
		$(".modal:visible").length && $body.addClass("modal-open");
	});

	// Return
	return {
		currentUrl: currentUrl,
		removeSpinner: removeSpinner,
		forms: forms,
		searchOperatorChanged: searchOperatorChanged,
		initIcons: initIcons,
		initPasswordOptions: initPasswordOptions,
		getApiUrl: getApiUrl,
		setSessionTimer: setSessionTimer,
		initExportLinks: initExportLinks,
		initMultiSelectCheckboxes: initMultiSelectCheckboxes,
		fileDownload: fileDownload,
		lazyLoad: lazyLoad,
		initLightboxes: initLightboxes,
		initPdfObjects: initPdfObjects,
		initTooltips: initTooltips,
		Form: Form,
		prompt: _prompt,
		getForm: getForm,
		hasFormData: hasFormData,
		setSearchType: setSearchType,
		updateOptions: updateOptions,
		getUserParams: getUserParams,
		applyTemplate: applyTemplate,
		showTemplates: showTemplates,
		convertToBool: convertToBool,
		valueChanged: valueChanged,
		setLanguage: setLanguage,
		submitAction: submitAction,
		export: _export,
		removeSpaces: removeSpaces,
		isHiddenTextArea: isHiddenTextArea,
		isModalLookup: isModalLookup,
		isAutoSuggest: isAutoSuggest,
		getAutoSuggest: getAutoSuggest,
		alert: _alert,
		onError: onError,
		setFocus: setFocus,
		hasValue: hasValue,
		sort: sort,
		confirmDelete: confirmDelete,
		keySelected: keySelected,
		selectAllKey: selectAllKey,
		selectAll: selectAll,
		updateSelected: updateSelected,
		setColor: setColor,
		clearSelected: clearSelected,
		clearDelete: clearDelete,
		clickDelete: clickDelete,
		clickMultiCheckbox: clickMultiCheckbox,
		setupTable: setupTable,
		setupGrid: setupGrid,
		addGridRow: addGridRow,
		deleteGridRow: deleteGridRow,
		htmlEncode: htmlEncode,
		clearForm: clearForm,
		MultiPage: MultiPage,
		getElements: getElements,
		getElement: getElement,
		getAncestorBy: getAncestorBy,
		isHidden: isHidden,
		sameText: sameText,
		sameString: sameString,
		getOptionValues: getOptionValues,
		getOptionTexts: getOptionTexts,
		clearOptions: clearOptions,
		getId: getId,
		valueSeparator: valueSeparator,
		displayValue: displayValue,
		optionHtml: optionHtml,
		optionsHtml: optionsHtml,
		newOption: newOption,
		renderOption: renderOption,
		selectOption: selectOption,
		AutoSuggest: AutoSuggest,
		executeScript: executeScript,
		stripScript: stripScript,
		addScript: addScript,
		removeScript: removeScript,
		getContent: getContent,
		getOptions: getOptions,
		addOptionDialogShow: addOptionDialogShow,
		modalDialogHide: modalDialogHide,
		modalDialogShow: modalDialogShow,
		modalLookupShow: modalLookupShow,
		importDialogShow: importDialogShow,
		autoFill: autoFill,
		tooltip: tooltip,
		emailDialogShow: emailDialogShow,
		showDrillDown: showDrillDown,
		toggleGroup: toggleGroup,
		exportWithCharts: exportWithCharts,
		redirect: redirect,
		togglePassword: togglePassword,
		ajax: ajax,
		currentPage: currentPage,
		toggleSearchOperator: toggleSearchOperator,
		checkUSDate: checkUSDate,
		checkShortUSDate: checkShortUSDate,
		checkDate: checkDate,
		checkShortDate: checkShortDate,
		checkEuroDate: checkEuroDate,
		checkShortEuroDate: checkShortEuroDate,
		checkDateDef: checkDateDef,
		checkDateEx: checkDateEx,
		unformatYear: unformatYear,
		checkDay: checkDay,
		checkInteger: checkInteger,
		checkNumber: checkNumber,
		stringToFloat: stringToFloat,
		stringToDate: stringToDate,
		escapeRegExChars: escapeRegExChars,
		checkRange: checkRange,
		checkTime: checkTime,
		checkPhone: checkPhone,
		checkZip: checkZip,
		checkCreditCard: checkCreditCard,
		checkSsc: checkSsc,
		checkEmails: checkEmails,
		checkEmail: checkEmail,
		checkGuid: checkGuid,
		checkByRegEx: checkByRegEx,
		showMessage: showMessage,
		random: random,
		upload: upload,
		parseNumber: parseNumber,
		formatNumber: formatNumber,
		parseDate: parseDate,
		formatDate: formatDate,
		fixLayoutHeight: fixLayoutHeight,
		Layout: Layout
	};

})(jQuery, ew));

// Extend jQuery
jQuery.extend({
	isBoolean: function(o) {
		return typeof o === 'boolean';
	},
	isNull: function(o) {
		return o === null;
	},
	isNumber: function(o) {
		return typeof o === 'number' && isFinite(o);
	},
	isObject: function(o) {
		return (o && (typeof o === 'object' || this.isFunction(o))) || false;
	},
	isString: function(o) {
		return typeof o === 'string';
	},
	isUndefined: function(o) {
		return typeof o === 'undefined';
	},
	isValue: function(o) {
		return (this.isObject(o) || this.isString(o) || this.isNumber(o) || this.isBoolean(o));
	},
	isDate: function(o) {
		return this.type(o) === 'date' && o.toString() !== 'Invalid Date' && !isNaN(o);
	},
	later: function(when, o, fn, data, periodic) {
		when = when || 0;
		o = o || {};
		var m = fn, d = data, f, r;
		if (this.isString(fn))
			m = o[fn];
		if (!m)
			return;
		if (!this.isUndefined(data) && !this.isArray(d))
			d = [data];
		f = function() {
			m.apply(o, d || []);
		};
		r = (periodic) ? setInterval(f, when) : setTimeout(f, when);
		return {
			interval: periodic,
			cancel: function() {
				if (this.interval) {
					clearInterval(r);
				} else {
					clearTimeout(r);
				}
			}
		};
	}
});

// jQuery plugins
(function($, ew) {
	/**
	 * .fields() plugin
	 *
	 * @param {string|undefined} fldvar - Field variable name or undefined
	 *  If field variable name, returns jQuery object of the specified field element(s).
	 *  If unspecified, returns object of jQuery objects of all fields.
	 * @returns jQuery object
	 */
	$.fn.fields = function(fldvar) { // Note: fldvar has NO "x_" prefix
		var rec = {},
			id = this.attr("id"),
			obj = this[0],
			m = id.match(/^[xy](\d*)_/),
			f, tbl, infix;
		if (m) { // "this" is input element
			f = ew.getForm(obj); // form
			tbl = this.data("table"); // table var
			infix = m[1]; // row index
		} else if (obj && obj._form) { // "this" is form
			f = obj.$element; // form
			tbl = obj.id.replace(new RegExp("^f|" + obj.pageId + "$", "g"), ""); // table var
			infix = $(obj._form).data("rowindex"); // row index
		}
		var selector = "[data-table" + (tbl ? "=" + tbl : "") + "][data-field" + (fldvar ? "=x_" + fldvar : "") + "]";
		if ($.isValue(infix))
			selector += "[name^=x" + infix + "_]";
		if (f && selector) {
			$(f).find(selector).each(function() {
				var key = this.getAttribute("data-field").substr(2), name = this.getAttribute("name");
				key = (/^y_/.test(name)) ? "y_" + key : key; // Use "y_fldvar" as key for 2nd search input
				rec[key] = (rec[key]) ? rec[key].add(this) : $(this); // Create jQuery object for each field
			});
		}
		return (fldvar) ? rec[fldvar] : rec;
	};
	$.fn.extend({
		// Get jQuery object of the row (<div> or <tr>)
		row: function() {
			var $row = this.closest("#r_" + this.data("field").substr(2));
			if (!$row[0])
				$row = this.closest(".ew-table > tbody > tr"); // Grid page
			return $row;
		},
		// Show/Hide field
		visible: function(v) {
			var $el = this.closest("#r_" + this.data("field").substr(2)); // Find the row
			if (!$el[0]) // If not found, find the <span>
				$el = this.closest("[id^=el]");
			if (typeof(v) != "undefined") {
				$el.toggle(v);
				return this;
			} else {
				return $el.is(":visible");
			}
		},
		// Get/Set field "readonly" attribute
		// Note: This attribute is ignored if the value of the type attribute is hidden, range, color, checkbox, radio, file, or a button type
		readonly: function(v) {
			if (typeof(v) != "undefined") {
				this.prop("readOnly", v);
				return this;
			} else {
				return this.prop("readOnly");
			}
		},
		// Get/Set field "disabled" attribute
		// Note: A disabled control's value isn't submitted with the form
		disabled: function(v) {
			if (typeof(v) != "undefined") {
				this.prop("disabled", v);
				return this;
			} else {
				return this.prop("disabled");
			}
		},
		// Get/Set field value(s)
		// Note: Return array if select-multiple
		value: function(v) {
			var type = this.attr("type");
			if (typeof(v) != "undefined") {
				if (!$.isArray(v))
					v = [v];
				var type = this.attr("type");
				var el = (type == "radio" || type == "checkbox") ? this.get() : this[0];
				if (ew.isHiddenTextArea(this))
					this.val(v).data("editor").save();
				else
					ew.selectOption(el, v);
				return this;
			} else {
				if (type == "checkbox") {
					return ew.getOptionValues(this.get());
				} else if (type == "radio") {
					return ew.getOptionValues(this.get()).join();
				} else if (ew.isHiddenTextArea(this)) {
					this.data("editor").save();
					return this.val();
				} else {
					return this.val();
				}
			}
		},
		// Get field value as number
		toNumber: function() {
			return ew.parseNumber(this.value());
		},
		// Get field value as moment object
		toDate: function() {
			return ew.parseDate(this.value(), this.data("format"));
		},
		// Get field value as native Date object
		toJsDate: function() {
			return ew.parseDate(this.value(), this.data("format")).toDate();
		}
	});
})(jQuery, ew);

// Dropdown menu parent item with href // Override AdminLTE
(function($, ew) {

	$("ul.dropdown-menu [data-toggle=dropdown]").on("click", function(e) {
		var href = $(this).attr("href");
		if (href && href != "#" && e.target.nodeName == "SPAN")
			window.location = href;
	});

})(jQuery, ew);