<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$fonction_view = new fonction_view();

// Run the page
$fonction_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$fonction_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$fonction_view->isExport()) { ?>
<script>
var ffonctionview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	ffonctionview = currentForm = new ew.Form("ffonctionview", "view");
	loadjs.done("ffonctionview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$fonction_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $fonction_view->ExportOptions->render("body") ?>
<?php $fonction_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $fonction_view->showPageHeader(); ?>
<?php
$fonction_view->showMessage();
?>
<?php if (!$fonction_view->IsModal) { ?>
<?php if (!$fonction_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $fonction_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="ffonctionview" id="ffonctionview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="fonction">
<input type="hidden" name="modal" value="<?php echo (int)$fonction_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($fonction_view->idfct->Visible) { // idfct ?>
	<tr id="r_idfct">
		<td class="<?php echo $fonction_view->TableLeftColumnClass ?>"><span id="elh_fonction_idfct"><?php echo $fonction_view->idfct->caption() ?></span></td>
		<td data-name="idfct" <?php echo $fonction_view->idfct->cellAttributes() ?>>
<span id="el_fonction_idfct">
<span<?php echo $fonction_view->idfct->viewAttributes() ?>><?php echo $fonction_view->idfct->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fonction_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $fonction_view->TableLeftColumnClass ?>"><span id="elh_fonction_ident"><?php echo $fonction_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $fonction_view->ident->cellAttributes() ?>>
<span id="el_fonction_ident">
<span<?php echo $fonction_view->ident->viewAttributes() ?>><?php echo $fonction_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($fonction_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $fonction_view->TableLeftColumnClass ?>"><span id="elh_fonction_descrip"><?php echo $fonction_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $fonction_view->descrip->cellAttributes() ?>>
<span id="el_fonction_descrip">
<span<?php echo $fonction_view->descrip->viewAttributes() ?>><?php echo $fonction_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$fonction_view->IsModal) { ?>
<?php if (!$fonction_view->isExport()) { ?>
<?php echo $fonction_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$fonction_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$fonction_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$fonction_view->terminate();
?>