<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$fonction_list = new fonction_list();

// Run the page
$fonction_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$fonction_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$fonction_list->isExport()) { ?>
<script>
var ffonctionlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	ffonctionlist = currentForm = new ew.Form("ffonctionlist", "list");
	ffonctionlist.formKeyCountName = '<?php echo $fonction_list->FormKeyCountName ?>';
	loadjs.done("ffonctionlist");
});
var ffonctionlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	ffonctionlistsrch = currentSearchForm = new ew.Form("ffonctionlistsrch");

	// Dynamic selection lists
	// Filters

	ffonctionlistsrch.filterList = <?php echo $fonction_list->getFilterList() ?>;
	loadjs.done("ffonctionlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$fonction_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($fonction_list->TotalRecords > 0 && $fonction_list->ExportOptions->visible()) { ?>
<?php $fonction_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($fonction_list->ImportOptions->visible()) { ?>
<?php $fonction_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($fonction_list->SearchOptions->visible()) { ?>
<?php $fonction_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($fonction_list->FilterOptions->visible()) { ?>
<?php $fonction_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$fonction_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$fonction_list->isExport() && !$fonction->CurrentAction) { ?>
<form name="ffonctionlistsrch" id="ffonctionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="ffonctionlistsrch-search-panel" class="<?php echo $fonction_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="fonction">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $fonction_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($fonction_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($fonction_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $fonction_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($fonction_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($fonction_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($fonction_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($fonction_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $fonction_list->showPageHeader(); ?>
<?php
$fonction_list->showMessage();
?>
<?php if ($fonction_list->TotalRecords > 0 || $fonction->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($fonction_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> fonction">
<?php if (!$fonction_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$fonction_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $fonction_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $fonction_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ffonctionlist" id="ffonctionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="fonction">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_fonction" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($fonction_list->TotalRecords > 0 || $fonction_list->isGridEdit()) { ?>
<table id="tbl_fonctionlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$fonction->RowType = ROWTYPE_HEADER;

// Render list options
$fonction_list->renderListOptions();

// Render list options (header, left)
$fonction_list->ListOptions->render("header", "left");
?>
<?php if ($fonction_list->idfct->Visible) { // idfct ?>
	<?php if ($fonction_list->SortUrl($fonction_list->idfct) == "") { ?>
		<th data-name="idfct" class="<?php echo $fonction_list->idfct->headerCellClass() ?>"><div id="elh_fonction_idfct" class="fonction_idfct"><div class="ew-table-header-caption"><?php echo $fonction_list->idfct->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idfct" class="<?php echo $fonction_list->idfct->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $fonction_list->SortUrl($fonction_list->idfct) ?>', 1);"><div id="elh_fonction_idfct" class="fonction_idfct">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $fonction_list->idfct->caption() ?></span><span class="ew-table-header-sort"><?php if ($fonction_list->idfct->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($fonction_list->idfct->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($fonction_list->ident->Visible) { // ident ?>
	<?php if ($fonction_list->SortUrl($fonction_list->ident) == "") { ?>
		<th data-name="ident" class="<?php echo $fonction_list->ident->headerCellClass() ?>"><div id="elh_fonction_ident" class="fonction_ident"><div class="ew-table-header-caption"><?php echo $fonction_list->ident->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ident" class="<?php echo $fonction_list->ident->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $fonction_list->SortUrl($fonction_list->ident) ?>', 1);"><div id="elh_fonction_ident" class="fonction_ident">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $fonction_list->ident->caption() ?></span><span class="ew-table-header-sort"><?php if ($fonction_list->ident->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($fonction_list->ident->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($fonction_list->descrip->Visible) { // descrip ?>
	<?php if ($fonction_list->SortUrl($fonction_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $fonction_list->descrip->headerCellClass() ?>"><div id="elh_fonction_descrip" class="fonction_descrip"><div class="ew-table-header-caption"><?php echo $fonction_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $fonction_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $fonction_list->SortUrl($fonction_list->descrip) ?>', 1);"><div id="elh_fonction_descrip" class="fonction_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $fonction_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($fonction_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($fonction_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$fonction_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($fonction_list->ExportAll && $fonction_list->isExport()) {
	$fonction_list->StopRecord = $fonction_list->TotalRecords;
} else {

	// Set the last record to display
	if ($fonction_list->TotalRecords > $fonction_list->StartRecord + $fonction_list->DisplayRecords - 1)
		$fonction_list->StopRecord = $fonction_list->StartRecord + $fonction_list->DisplayRecords - 1;
	else
		$fonction_list->StopRecord = $fonction_list->TotalRecords;
}
$fonction_list->RecordCount = $fonction_list->StartRecord - 1;
if ($fonction_list->Recordset && !$fonction_list->Recordset->EOF) {
	$fonction_list->Recordset->moveFirst();
	$selectLimit = $fonction_list->UseSelectLimit;
	if (!$selectLimit && $fonction_list->StartRecord > 1)
		$fonction_list->Recordset->move($fonction_list->StartRecord - 1);
} elseif (!$fonction->AllowAddDeleteRow && $fonction_list->StopRecord == 0) {
	$fonction_list->StopRecord = $fonction->GridAddRowCount;
}

// Initialize aggregate
$fonction->RowType = ROWTYPE_AGGREGATEINIT;
$fonction->resetAttributes();
$fonction_list->renderRow();
while ($fonction_list->RecordCount < $fonction_list->StopRecord) {
	$fonction_list->RecordCount++;
	if ($fonction_list->RecordCount >= $fonction_list->StartRecord) {
		$fonction_list->RowCount++;

		// Set up key count
		$fonction_list->KeyCount = $fonction_list->RowIndex;

		// Init row class and style
		$fonction->resetAttributes();
		$fonction->CssClass = "";
		if ($fonction_list->isGridAdd()) {
		} else {
			$fonction_list->loadRowValues($fonction_list->Recordset); // Load row values
		}
		$fonction->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$fonction->RowAttrs->merge(["data-rowindex" => $fonction_list->RowCount, "id" => "r" . $fonction_list->RowCount . "_fonction", "data-rowtype" => $fonction->RowType]);

		// Render row
		$fonction_list->renderRow();

		// Render list options
		$fonction_list->renderListOptions();
?>
	<tr <?php echo $fonction->rowAttributes() ?>>
<?php

// Render list options (body, left)
$fonction_list->ListOptions->render("body", "left", $fonction_list->RowCount);
?>
	<?php if ($fonction_list->idfct->Visible) { // idfct ?>
		<td data-name="idfct" <?php echo $fonction_list->idfct->cellAttributes() ?>>
<span id="el<?php echo $fonction_list->RowCount ?>_fonction_idfct">
<span<?php echo $fonction_list->idfct->viewAttributes() ?>><?php echo $fonction_list->idfct->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($fonction_list->ident->Visible) { // ident ?>
		<td data-name="ident" <?php echo $fonction_list->ident->cellAttributes() ?>>
<span id="el<?php echo $fonction_list->RowCount ?>_fonction_ident">
<span<?php echo $fonction_list->ident->viewAttributes() ?>><?php echo $fonction_list->ident->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($fonction_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $fonction_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $fonction_list->RowCount ?>_fonction_descrip">
<span<?php echo $fonction_list->descrip->viewAttributes() ?>><?php echo $fonction_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$fonction_list->ListOptions->render("body", "right", $fonction_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$fonction_list->isGridAdd())
		$fonction_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$fonction->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($fonction_list->Recordset)
	$fonction_list->Recordset->Close();
?>
<?php if (!$fonction_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$fonction_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $fonction_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $fonction_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($fonction_list->TotalRecords == 0 && !$fonction->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $fonction_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$fonction_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$fonction_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$fonction_list->terminate();
?>