<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$fonction_edit = new fonction_edit();

// Run the page
$fonction_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$fonction_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var ffonctionedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	ffonctionedit = currentForm = new ew.Form("ffonctionedit", "edit");

	// Validate form
	ffonctionedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($fonction_edit->idfct->Required) { ?>
				elm = this.getElements("x" + infix + "_idfct");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fonction_edit->idfct->caption(), $fonction_edit->idfct->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($fonction_edit->ident->Required) { ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fonction_edit->ident->caption(), $fonction_edit->ident->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($fonction_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $fonction_edit->descrip->caption(), $fonction_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	ffonctionedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	ffonctionedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("ffonctionedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $fonction_edit->showPageHeader(); ?>
<?php
$fonction_edit->showMessage();
?>
<form name="ffonctionedit" id="ffonctionedit" class="<?php echo $fonction_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="fonction">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$fonction_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($fonction_edit->idfct->Visible) { // idfct ?>
	<div id="r_idfct" class="form-group row">
		<label id="elh_fonction_idfct" class="<?php echo $fonction_edit->LeftColumnClass ?>"><?php echo $fonction_edit->idfct->caption() ?><?php echo $fonction_edit->idfct->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fonction_edit->RightColumnClass ?>"><div <?php echo $fonction_edit->idfct->cellAttributes() ?>>
<span id="el_fonction_idfct">
<span<?php echo $fonction_edit->idfct->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($fonction_edit->idfct->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="fonction" data-field="x_idfct" name="x_idfct" id="x_idfct" value="<?php echo HtmlEncode($fonction_edit->idfct->CurrentValue) ?>">
<?php echo $fonction_edit->idfct->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fonction_edit->ident->Visible) { // ident ?>
	<div id="r_ident" class="form-group row">
		<label id="elh_fonction_ident" for="x_ident" class="<?php echo $fonction_edit->LeftColumnClass ?>"><?php echo $fonction_edit->ident->caption() ?><?php echo $fonction_edit->ident->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fonction_edit->RightColumnClass ?>"><div <?php echo $fonction_edit->ident->cellAttributes() ?>>
<span id="el_fonction_ident">
<input type="text" data-table="fonction" data-field="x_ident" name="x_ident" id="x_ident" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($fonction_edit->ident->getPlaceHolder()) ?>" value="<?php echo $fonction_edit->ident->EditValue ?>"<?php echo $fonction_edit->ident->editAttributes() ?>>
</span>
<?php echo $fonction_edit->ident->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($fonction_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_fonction_descrip" for="x_descrip" class="<?php echo $fonction_edit->LeftColumnClass ?>"><?php echo $fonction_edit->descrip->caption() ?><?php echo $fonction_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $fonction_edit->RightColumnClass ?>"><div <?php echo $fonction_edit->descrip->cellAttributes() ?>>
<span id="el_fonction_descrip">
<input type="text" data-table="fonction" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($fonction_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $fonction_edit->descrip->EditValue ?>"<?php echo $fonction_edit->descrip->editAttributes() ?>>
</span>
<?php echo $fonction_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$fonction_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $fonction_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $fonction_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$fonction_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$fonction_edit->terminate();
?>