<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employee_view = new employee_view();

// Run the page
$employee_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employee_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$employee_view->isExport()) { ?>
<script>
var femployeeview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	femployeeview = currentForm = new ew.Form("femployeeview", "view");
	loadjs.done("femployeeview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$employee_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $employee_view->ExportOptions->render("body") ?>
<?php $employee_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $employee_view->showPageHeader(); ?>
<?php
$employee_view->showMessage();
?>
<?php if (!$employee_view->IsModal) { ?>
<?php if (!$employee_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $employee_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="femployeeview" id="femployeeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employee">
<input type="hidden" name="modal" value="<?php echo (int)$employee_view->IsModal ?>">
<?php if (!$employee_view->isExport()) { ?>
<div class="ew-multi-page">
<div class="ew-nav-tabs" id="employee_view"><!-- multi-page tabs -->
	<ul class="<?php echo $employee_view->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $employee_view->MultiPages->pageStyle(1) ?>" href="#tab_employee1" data-toggle="tab"><?php echo $employee->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $employee_view->MultiPages->pageStyle(2) ?>" href="#tab_employee2" data-toggle="tab"><?php echo $employee->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $employee_view->MultiPages->pageStyle(3) ?>" href="#tab_employee3" data-toggle="tab"><?php echo $employee->pageCaption(3) ?></a></li>
	</ul>
	<div class="tab-content">
<?php } ?>
<?php if (!$employee_view->isExport()) { ?>
		<div class="tab-pane<?php echo $employee_view->MultiPages->pageStyle(1) ?>" id="tab_employee1"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($employee_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_idemp"><?php echo $employee_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $employee_view->idemp->cellAttributes() ?>>
<span id="el_employee_idemp" data-page="1">
<span<?php echo $employee_view->idemp->viewAttributes() ?>><?php echo $employee_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->noemp->Visible) { // noemp ?>
	<tr id="r_noemp">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_noemp"><?php echo $employee_view->noemp->caption() ?></span></td>
		<td data-name="noemp" <?php echo $employee_view->noemp->cellAttributes() ?>>
<span id="el_employee_noemp" data-page="1">
<span<?php echo $employee_view->noemp->viewAttributes() ?>><?php if (!EmptyString($employee_view->noemp->getViewValue()) && $employee_view->noemp->linkAttributes() != "") { ?>
<a<?php echo $employee_view->noemp->linkAttributes() ?>><?php echo $employee_view->noemp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $employee_view->noemp->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->lastname->Visible) { // lastname ?>
	<tr id="r_lastname">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_lastname"><?php echo $employee_view->lastname->caption() ?></span></td>
		<td data-name="lastname" <?php echo $employee_view->lastname->cellAttributes() ?>>
<span id="el_employee_lastname" data-page="1">
<span<?php echo $employee_view->lastname->viewAttributes() ?>><?php echo $employee_view->lastname->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->firstname->Visible) { // firstname ?>
	<tr id="r_firstname">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_firstname"><?php echo $employee_view->firstname->caption() ?></span></td>
		<td data-name="firstname" <?php echo $employee_view->firstname->cellAttributes() ?>>
<span id="el_employee_firstname" data-page="1">
<span<?php echo $employee_view->firstname->viewAttributes() ?>><?php echo $employee_view->firstname->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->basicsalary->Visible) { // basicsalary ?>
	<tr id="r_basicsalary">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_basicsalary"><?php echo $employee_view->basicsalary->caption() ?></span></td>
		<td data-name="basicsalary" <?php echo $employee_view->basicsalary->cellAttributes() ?>>
<span id="el_employee_basicsalary" data-page="1">
<span<?php echo $employee_view->basicsalary->viewAttributes() ?>><?php echo $employee_view->basicsalary->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->nifcin->Visible) { // nifcin ?>
	<tr id="r_nifcin">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_nifcin"><?php echo $employee_view->nifcin->caption() ?></span></td>
		<td data-name="nifcin" <?php echo $employee_view->nifcin->cellAttributes() ?>>
<span id="el_employee_nifcin" data-page="1">
<span<?php echo $employee_view->nifcin->viewAttributes() ?>><?php echo $employee_view->nifcin->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->gender->Visible) { // gender ?>
	<tr id="r_gender">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_gender"><?php echo $employee_view->gender->caption() ?></span></td>
		<td data-name="gender" <?php echo $employee_view->gender->cellAttributes() ?>>
<span id="el_employee_gender" data-page="1">
<span<?php echo $employee_view->gender->viewAttributes() ?>><?php echo $employee_view->gender->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->civilstatus->Visible) { // civilstatus ?>
	<tr id="r_civilstatus">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_civilstatus"><?php echo $employee_view->civilstatus->caption() ?></span></td>
		<td data-name="civilstatus" <?php echo $employee_view->civilstatus->cellAttributes() ?>>
<span id="el_employee_civilstatus" data-page="1">
<span<?php echo $employee_view->civilstatus->viewAttributes() ?>><?php echo $employee_view->civilstatus->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->joindate->Visible) { // joindate ?>
	<tr id="r_joindate">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_joindate"><?php echo $employee_view->joindate->caption() ?></span></td>
		<td data-name="joindate" <?php echo $employee_view->joindate->cellAttributes() ?>>
<span id="el_employee_joindate" data-page="1">
<span<?php echo $employee_view->joindate->viewAttributes() ?>><?php echo $employee_view->joindate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->leavingdate->Visible) { // leavingdate ?>
	<tr id="r_leavingdate">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_leavingdate"><?php echo $employee_view->leavingdate->caption() ?></span></td>
		<td data-name="leavingdate" <?php echo $employee_view->leavingdate->cellAttributes() ?>>
<span id="el_employee_leavingdate" data-page="1">
<span<?php echo $employee_view->leavingdate->viewAttributes() ?>><?php echo $employee_view->leavingdate->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->leavingmotif->Visible) { // leavingmotif ?>
	<tr id="r_leavingmotif">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_leavingmotif"><?php echo $employee_view->leavingmotif->caption() ?></span></td>
		<td data-name="leavingmotif" <?php echo $employee_view->leavingmotif->cellAttributes() ?>>
<span id="el_employee_leavingmotif" data-page="1">
<span<?php echo $employee_view->leavingmotif->viewAttributes() ?>><?php echo $employee_view->leavingmotif->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->qualif->Visible) { // qualif ?>
	<tr id="r_qualif">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_qualif"><?php echo $employee_view->qualif->caption() ?></span></td>
		<td data-name="qualif" <?php echo $employee_view->qualif->cellAttributes() ?>>
<span id="el_employee_qualif" data-page="1">
<span<?php echo $employee_view->qualif->viewAttributes() ?>><?php echo $employee_view->qualif->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->listpolicy->Visible) { // listpolicy ?>
	<tr id="r_listpolicy">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_listpolicy"><?php echo $employee_view->listpolicy->caption() ?></span></td>
		<td data-name="listpolicy" <?php echo $employee_view->listpolicy->cellAttributes() ?>>
<span id="el_employee_listpolicy" data-page="1">
<span<?php echo $employee_view->listpolicy->viewAttributes() ?>><?php echo $employee_view->listpolicy->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$employee_view->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$employee_view->isExport()) { ?>
		<div class="tab-pane<?php echo $employee_view->MultiPages->pageStyle(2) ?>" id="tab_employee2"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($employee_view->idtype->Visible) { // idtype ?>
	<tr id="r_idtype">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_idtype"><?php echo $employee_view->idtype->caption() ?></span></td>
		<td data-name="idtype" <?php echo $employee_view->idtype->cellAttributes() ?>>
<span id="el_employee_idtype" data-page="2">
<span<?php echo $employee_view->idtype->viewAttributes() ?>><?php echo $employee_view->idtype->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->idstatus->Visible) { // idstatus ?>
	<tr id="r_idstatus">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_idstatus"><?php echo $employee_view->idstatus->caption() ?></span></td>
		<td data-name="idstatus" <?php echo $employee_view->idstatus->cellAttributes() ?>>
<span id="el_employee_idstatus" data-page="2">
<span<?php echo $employee_view->idstatus->viewAttributes() ?>><?php echo $employee_view->idstatus->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->idfct->Visible) { // idfct ?>
	<tr id="r_idfct">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_idfct"><?php echo $employee_view->idfct->caption() ?></span></td>
		<td data-name="idfct" <?php echo $employee_view->idfct->cellAttributes() ?>>
<span id="el_employee_idfct" data-page="2">
<span<?php echo $employee_view->idfct->viewAttributes() ?>><?php echo $employee_view->idfct->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->idsect->Visible) { // idsect ?>
	<tr id="r_idsect">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_idsect"><?php echo $employee_view->idsect->caption() ?></span></td>
		<td data-name="idsect" <?php echo $employee_view->idsect->cellAttributes() ?>>
<span id="el_employee_idsect" data-page="2">
<span<?php echo $employee_view->idsect->viewAttributes() ?>><?php echo $employee_view->idsect->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->iddep->Visible) { // iddep ?>
	<tr id="r_iddep">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_iddep"><?php echo $employee_view->iddep->caption() ?></span></td>
		<td data-name="iddep" <?php echo $employee_view->iddep->cellAttributes() ?>>
<span id="el_employee_iddep" data-page="2">
<span<?php echo $employee_view->iddep->viewAttributes() ?>><?php echo $employee_view->iddep->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->iddesig->Visible) { // iddesig ?>
	<tr id="r_iddesig">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_iddesig"><?php echo $employee_view->iddesig->caption() ?></span></td>
		<td data-name="iddesig" <?php echo $employee_view->iddesig->cellAttributes() ?>>
<span id="el_employee_iddesig" data-page="2">
<span<?php echo $employee_view->iddesig->viewAttributes() ?>><?php echo $employee_view->iddesig->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$employee_view->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$employee_view->isExport()) { ?>
		<div class="tab-pane<?php echo $employee_view->MultiPages->pageStyle(3) ?>" id="tab_employee3"><!-- multi-page .tab-pane -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($employee_view->depend->Visible) { // depend ?>
	<tr id="r_depend">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_depend"><?php echo $employee_view->depend->caption() ?></span></td>
		<td data-name="depend" <?php echo $employee_view->depend->cellAttributes() ?>>
<span id="el_employee_depend" data-page="3">
<span<?php echo $employee_view->depend->viewAttributes() ?>><?php echo $employee_view->depend->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->datenais->Visible) { // datenais ?>
	<tr id="r_datenais">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_datenais"><?php echo $employee_view->datenais->caption() ?></span></td>
		<td data-name="datenais" <?php echo $employee_view->datenais->cellAttributes() ?>>
<span id="el_employee_datenais" data-page="3">
<span<?php echo $employee_view->datenais->viewAttributes() ?>><?php echo $employee_view->datenais->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->lieunais->Visible) { // lieunais ?>
	<tr id="r_lieunais">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_lieunais"><?php echo $employee_view->lieunais->caption() ?></span></td>
		<td data-name="lieunais" <?php echo $employee_view->lieunais->cellAttributes() ?>>
<span id="el_employee_lieunais" data-page="3">
<span<?php echo $employee_view->lieunais->viewAttributes() ?>><?php echo $employee_view->lieunais->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->adresse->Visible) { // adresse ?>
	<tr id="r_adresse">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_adresse"><?php echo $employee_view->adresse->caption() ?></span></td>
		<td data-name="adresse" <?php echo $employee_view->adresse->cellAttributes() ?>>
<span id="el_employee_adresse" data-page="3">
<span<?php echo $employee_view->adresse->viewAttributes() ?>><?php echo $employee_view->adresse->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->phone->Visible) { // phone ?>
	<tr id="r_phone">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_phone"><?php echo $employee_view->phone->caption() ?></span></td>
		<td data-name="phone" <?php echo $employee_view->phone->cellAttributes() ?>>
<span id="el_employee_phone" data-page="3">
<span<?php echo $employee_view->phone->viewAttributes() ?>><?php echo $employee_view->phone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->reference->Visible) { // reference ?>
	<tr id="r_reference">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_reference"><?php echo $employee_view->reference->caption() ?></span></td>
		<td data-name="reference" <?php echo $employee_view->reference->cellAttributes() ?>>
<span id="el_employee_reference" data-page="3">
<span<?php echo $employee_view->reference->viewAttributes() ?>><?php echo $employee_view->reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->refphone->Visible) { // refphone ?>
	<tr id="r_refphone">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_refphone"><?php echo $employee_view->refphone->caption() ?></span></td>
		<td data-name="refphone" <?php echo $employee_view->refphone->cellAttributes() ?>>
<span id="el_employee_refphone" data-page="3">
<span<?php echo $employee_view->refphone->viewAttributes() ?>><?php echo $employee_view->refphone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->urgence->Visible) { // urgence ?>
	<tr id="r_urgence">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_urgence"><?php echo $employee_view->urgence->caption() ?></span></td>
		<td data-name="urgence" <?php echo $employee_view->urgence->cellAttributes() ?>>
<span id="el_employee_urgence" data-page="3">
<span<?php echo $employee_view->urgence->viewAttributes() ?>><?php echo $employee_view->urgence->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($employee_view->urgphone->Visible) { // urgphone ?>
	<tr id="r_urgphone">
		<td class="<?php echo $employee_view->TableLeftColumnClass ?>"><span id="elh_employee_urgphone"><?php echo $employee_view->urgphone->caption() ?></span></td>
		<td data-name="urgphone" <?php echo $employee_view->urgphone->cellAttributes() ?>>
<span id="el_employee_urgphone" data-page="3">
<span<?php echo $employee_view->urgphone->viewAttributes() ?>><?php echo $employee_view->urgphone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$employee_view->isExport()) { ?>
		</div>
<?php } ?>
<?php if (!$employee_view->isExport()) { ?>
	</div>
</div>
</div>
<?php } ?>
<?php if (!$employee_view->IsModal) { ?>
<?php if (!$employee_view->isExport()) { ?>
<?php echo $employee_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php
	if (in_array("policyemp", explode(",", $employee->getCurrentDetailTable())) && $policyemp->DetailView) {
?>
<?php if ($employee->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("policyemp", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employee_view->policyemp_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "policyempgrid.php" ?>
<?php } ?>
<?php
	if (in_array("detailpayroll", explode(",", $employee->getCurrentDetailTable())) && $detailpayroll->DetailView) {
?>
<?php if ($employee->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("detailpayroll", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $employee_view->detailpayroll_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "detailpayrollgrid.php" ?>
<?php } ?>
</form>
<?php
$employee_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$employee_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$employee_view->terminate();
?>