<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employee_list = new employee_list();

// Run the page
$employee_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employee_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$employee_list->isExport()) { ?>
<script>
var femployeelist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	femployeelist = currentForm = new ew.Form("femployeelist", "list");
	femployeelist.formKeyCountName = '<?php echo $employee_list->FormKeyCountName ?>';
	loadjs.done("femployeelist");
});
var femployeelistsrch;
loadjs.ready("head", function() {

	// Form object for search
	femployeelistsrch = currentSearchForm = new ew.Form("femployeelistsrch");

	// Dynamic selection lists
	// Filters

	femployeelistsrch.filterList = <?php echo $employee_list->getFilterList() ?>;
	loadjs.done("femployeelistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$employee_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($employee_list->TotalRecords > 0 && $employee_list->ExportOptions->visible()) { ?>
<?php $employee_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($employee_list->ImportOptions->visible()) { ?>
<?php $employee_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($employee_list->SearchOptions->visible()) { ?>
<?php $employee_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($employee_list->FilterOptions->visible()) { ?>
<?php $employee_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$employee_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$employee_list->isExport() && !$employee->CurrentAction) { ?>
<form name="femployeelistsrch" id="femployeelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="femployeelistsrch-search-panel" class="<?php echo $employee_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="employee">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $employee_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($employee_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($employee_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $employee_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($employee_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($employee_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($employee_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($employee_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $employee_list->showPageHeader(); ?>
<?php
$employee_list->showMessage();
?>
<?php if ($employee_list->TotalRecords > 0 || $employee->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($employee_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> employee">
<?php if (!$employee_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$employee_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $employee_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employee_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="femployeelist" id="femployeelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employee">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_employee" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($employee_list->TotalRecords > 0 || $employee_list->isGridEdit()) { ?>
<table id="tbl_employeelist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$employee->RowType = ROWTYPE_HEADER;

// Render list options
$employee_list->renderListOptions();

// Render list options (header, left)
$employee_list->ListOptions->render("header", "left");
?>
<?php if ($employee_list->noemp->Visible) { // noemp ?>
	<?php if ($employee_list->SortUrl($employee_list->noemp) == "") { ?>
		<th data-name="noemp" class="<?php echo $employee_list->noemp->headerCellClass() ?>"><div id="elh_employee_noemp" class="employee_noemp"><div class="ew-table-header-caption"><?php echo $employee_list->noemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="noemp" class="<?php echo $employee_list->noemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->noemp) ?>', 1);"><div id="elh_employee_noemp" class="employee_noemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->noemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($employee_list->noemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->noemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->lastname->Visible) { // lastname ?>
	<?php if ($employee_list->SortUrl($employee_list->lastname) == "") { ?>
		<th data-name="lastname" class="<?php echo $employee_list->lastname->headerCellClass() ?>"><div id="elh_employee_lastname" class="employee_lastname"><div class="ew-table-header-caption"><?php echo $employee_list->lastname->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lastname" class="<?php echo $employee_list->lastname->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->lastname) ?>', 1);"><div id="elh_employee_lastname" class="employee_lastname">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->lastname->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employee_list->lastname->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->lastname->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->firstname->Visible) { // firstname ?>
	<?php if ($employee_list->SortUrl($employee_list->firstname) == "") { ?>
		<th data-name="firstname" class="<?php echo $employee_list->firstname->headerCellClass() ?>"><div id="elh_employee_firstname" class="employee_firstname"><div class="ew-table-header-caption"><?php echo $employee_list->firstname->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="firstname" class="<?php echo $employee_list->firstname->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->firstname) ?>', 1);"><div id="elh_employee_firstname" class="employee_firstname">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->firstname->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employee_list->firstname->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->firstname->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->basicsalary->Visible) { // basicsalary ?>
	<?php if ($employee_list->SortUrl($employee_list->basicsalary) == "") { ?>
		<th data-name="basicsalary" class="<?php echo $employee_list->basicsalary->headerCellClass() ?>"><div id="elh_employee_basicsalary" class="employee_basicsalary"><div class="ew-table-header-caption"><?php echo $employee_list->basicsalary->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="basicsalary" class="<?php echo $employee_list->basicsalary->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->basicsalary) ?>', 1);"><div id="elh_employee_basicsalary" class="employee_basicsalary">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->basicsalary->caption() ?></span><span class="ew-table-header-sort"><?php if ($employee_list->basicsalary->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->basicsalary->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->joindate->Visible) { // joindate ?>
	<?php if ($employee_list->SortUrl($employee_list->joindate) == "") { ?>
		<th data-name="joindate" class="<?php echo $employee_list->joindate->headerCellClass() ?>"><div id="elh_employee_joindate" class="employee_joindate"><div class="ew-table-header-caption"><?php echo $employee_list->joindate->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="joindate" class="<?php echo $employee_list->joindate->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->joindate) ?>', 1);"><div id="elh_employee_joindate" class="employee_joindate">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->joindate->caption() ?></span><span class="ew-table-header-sort"><?php if ($employee_list->joindate->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->joindate->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->idtype->Visible) { // idtype ?>
	<?php if ($employee_list->SortUrl($employee_list->idtype) == "") { ?>
		<th data-name="idtype" class="<?php echo $employee_list->idtype->headerCellClass() ?>"><div id="elh_employee_idtype" class="employee_idtype"><div class="ew-table-header-caption"><?php echo $employee_list->idtype->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idtype" class="<?php echo $employee_list->idtype->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->idtype) ?>', 1);"><div id="elh_employee_idtype" class="employee_idtype">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->idtype->caption() ?></span><span class="ew-table-header-sort"><?php if ($employee_list->idtype->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->idtype->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->idstatus->Visible) { // idstatus ?>
	<?php if ($employee_list->SortUrl($employee_list->idstatus) == "") { ?>
		<th data-name="idstatus" class="<?php echo $employee_list->idstatus->headerCellClass() ?>"><div id="elh_employee_idstatus" class="employee_idstatus"><div class="ew-table-header-caption"><?php echo $employee_list->idstatus->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idstatus" class="<?php echo $employee_list->idstatus->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->idstatus) ?>', 1);"><div id="elh_employee_idstatus" class="employee_idstatus">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->idstatus->caption() ?></span><span class="ew-table-header-sort"><?php if ($employee_list->idstatus->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->idstatus->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->iddep->Visible) { // iddep ?>
	<?php if ($employee_list->SortUrl($employee_list->iddep) == "") { ?>
		<th data-name="iddep" class="<?php echo $employee_list->iddep->headerCellClass() ?>"><div id="elh_employee_iddep" class="employee_iddep"><div class="ew-table-header-caption"><?php echo $employee_list->iddep->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddep" class="<?php echo $employee_list->iddep->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->iddep) ?>', 1);"><div id="elh_employee_iddep" class="employee_iddep">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->iddep->caption() ?></span><span class="ew-table-header-sort"><?php if ($employee_list->iddep->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->iddep->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($employee_list->listpolicy->Visible) { // listpolicy ?>
	<?php if ($employee_list->SortUrl($employee_list->listpolicy) == "") { ?>
		<th data-name="listpolicy" class="<?php echo $employee_list->listpolicy->headerCellClass() ?>"><div id="elh_employee_listpolicy" class="employee_listpolicy"><div class="ew-table-header-caption"><?php echo $employee_list->listpolicy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="listpolicy" class="<?php echo $employee_list->listpolicy->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $employee_list->SortUrl($employee_list->listpolicy) ?>', 1);"><div id="elh_employee_listpolicy" class="employee_listpolicy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $employee_list->listpolicy->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($employee_list->listpolicy->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($employee_list->listpolicy->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$employee_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($employee_list->ExportAll && $employee_list->isExport()) {
	$employee_list->StopRecord = $employee_list->TotalRecords;
} else {

	// Set the last record to display
	if ($employee_list->TotalRecords > $employee_list->StartRecord + $employee_list->DisplayRecords - 1)
		$employee_list->StopRecord = $employee_list->StartRecord + $employee_list->DisplayRecords - 1;
	else
		$employee_list->StopRecord = $employee_list->TotalRecords;
}
$employee_list->RecordCount = $employee_list->StartRecord - 1;
if ($employee_list->Recordset && !$employee_list->Recordset->EOF) {
	$employee_list->Recordset->moveFirst();
	$selectLimit = $employee_list->UseSelectLimit;
	if (!$selectLimit && $employee_list->StartRecord > 1)
		$employee_list->Recordset->move($employee_list->StartRecord - 1);
} elseif (!$employee->AllowAddDeleteRow && $employee_list->StopRecord == 0) {
	$employee_list->StopRecord = $employee->GridAddRowCount;
}

// Initialize aggregate
$employee->RowType = ROWTYPE_AGGREGATEINIT;
$employee->resetAttributes();
$employee_list->renderRow();
while ($employee_list->RecordCount < $employee_list->StopRecord) {
	$employee_list->RecordCount++;
	if ($employee_list->RecordCount >= $employee_list->StartRecord) {
		$employee_list->RowCount++;

		// Set up key count
		$employee_list->KeyCount = $employee_list->RowIndex;

		// Init row class and style
		$employee->resetAttributes();
		$employee->CssClass = "";
		if ($employee_list->isGridAdd()) {
		} else {
			$employee_list->loadRowValues($employee_list->Recordset); // Load row values
		}
		$employee->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$employee->RowAttrs->merge(["data-rowindex" => $employee_list->RowCount, "id" => "r" . $employee_list->RowCount . "_employee", "data-rowtype" => $employee->RowType]);

		// Render row
		$employee_list->renderRow();

		// Render list options
		$employee_list->renderListOptions();
?>
	<tr <?php echo $employee->rowAttributes() ?>>
<?php

// Render list options (body, left)
$employee_list->ListOptions->render("body", "left", $employee_list->RowCount);
?>
	<?php if ($employee_list->noemp->Visible) { // noemp ?>
		<td data-name="noemp" <?php echo $employee_list->noemp->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_noemp">
<span<?php echo $employee_list->noemp->viewAttributes() ?>><?php if (!EmptyString($employee_list->noemp->getViewValue()) && $employee_list->noemp->linkAttributes() != "") { ?>
<a<?php echo $employee_list->noemp->linkAttributes() ?>><?php echo $employee_list->noemp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $employee_list->noemp->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->lastname->Visible) { // lastname ?>
		<td data-name="lastname" <?php echo $employee_list->lastname->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_lastname">
<span<?php echo $employee_list->lastname->viewAttributes() ?>><?php echo $employee_list->lastname->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->firstname->Visible) { // firstname ?>
		<td data-name="firstname" <?php echo $employee_list->firstname->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_firstname">
<span<?php echo $employee_list->firstname->viewAttributes() ?>><?php echo $employee_list->firstname->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->basicsalary->Visible) { // basicsalary ?>
		<td data-name="basicsalary" <?php echo $employee_list->basicsalary->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_basicsalary">
<span<?php echo $employee_list->basicsalary->viewAttributes() ?>><?php echo $employee_list->basicsalary->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->joindate->Visible) { // joindate ?>
		<td data-name="joindate" <?php echo $employee_list->joindate->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_joindate">
<span<?php echo $employee_list->joindate->viewAttributes() ?>><?php echo $employee_list->joindate->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->idtype->Visible) { // idtype ?>
		<td data-name="idtype" <?php echo $employee_list->idtype->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_idtype">
<span<?php echo $employee_list->idtype->viewAttributes() ?>><?php echo $employee_list->idtype->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->idstatus->Visible) { // idstatus ?>
		<td data-name="idstatus" <?php echo $employee_list->idstatus->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_idstatus">
<span<?php echo $employee_list->idstatus->viewAttributes() ?>><?php echo $employee_list->idstatus->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->iddep->Visible) { // iddep ?>
		<td data-name="iddep" <?php echo $employee_list->iddep->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_iddep">
<span<?php echo $employee_list->iddep->viewAttributes() ?>><?php echo $employee_list->iddep->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($employee_list->listpolicy->Visible) { // listpolicy ?>
		<td data-name="listpolicy" <?php echo $employee_list->listpolicy->cellAttributes() ?>>
<span id="el<?php echo $employee_list->RowCount ?>_employee_listpolicy">
<span<?php echo $employee_list->listpolicy->viewAttributes() ?>><?php echo $employee_list->listpolicy->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$employee_list->ListOptions->render("body", "right", $employee_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$employee_list->isGridAdd())
		$employee_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$employee->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($employee_list->Recordset)
	$employee_list->Recordset->Close();
?>
<?php if (!$employee_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$employee_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $employee_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $employee_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($employee_list->TotalRecords == 0 && !$employee->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $employee_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$employee_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$employee_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$employee_list->terminate();
?>