<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employee_edit = new employee_edit();

// Run the page
$employee_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employee_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var femployeeedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	femployeeedit = currentForm = new ew.Form("femployeeedit", "edit");

	// Validate form
	femployeeedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($employee_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->idemp->caption(), $employee_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->noemp->Required) { ?>
				elm = this.getElements("x" + infix + "_noemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->noemp->caption(), $employee_edit->noemp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_noemp");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_edit->noemp->errorMessage()) ?>");
			<?php if ($employee_edit->lastname->Required) { ?>
				elm = this.getElements("x" + infix + "_lastname");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->lastname->caption(), $employee_edit->lastname->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->firstname->Required) { ?>
				elm = this.getElements("x" + infix + "_firstname");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->firstname->caption(), $employee_edit->firstname->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->basicsalary->Required) { ?>
				elm = this.getElements("x" + infix + "_basicsalary");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->basicsalary->caption(), $employee_edit->basicsalary->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_basicsalary");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_edit->basicsalary->errorMessage()) ?>");
			<?php if ($employee_edit->nifcin->Required) { ?>
				elm = this.getElements("x" + infix + "_nifcin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->nifcin->caption(), $employee_edit->nifcin->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->gender->Required) { ?>
				elm = this.getElements("x" + infix + "_gender");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->gender->caption(), $employee_edit->gender->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->civilstatus->Required) { ?>
				elm = this.getElements("x" + infix + "_civilstatus");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->civilstatus->caption(), $employee_edit->civilstatus->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->depend->Required) { ?>
				elm = this.getElements("x" + infix + "_depend");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->depend->caption(), $employee_edit->depend->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_depend");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_edit->depend->errorMessage()) ?>");
			<?php if ($employee_edit->datenais->Required) { ?>
				elm = this.getElements("x" + infix + "_datenais");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->datenais->caption(), $employee_edit->datenais->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datenais");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_edit->datenais->errorMessage()) ?>");
			<?php if ($employee_edit->lieunais->Required) { ?>
				elm = this.getElements("x" + infix + "_lieunais");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->lieunais->caption(), $employee_edit->lieunais->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->adresse->Required) { ?>
				elm = this.getElements("x" + infix + "_adresse");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->adresse->caption(), $employee_edit->adresse->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->phone->Required) { ?>
				elm = this.getElements("x" + infix + "_phone");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->phone->caption(), $employee_edit->phone->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->reference->Required) { ?>
				elm = this.getElements("x" + infix + "_reference");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->reference->caption(), $employee_edit->reference->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->refphone->Required) { ?>
				elm = this.getElements("x" + infix + "_refphone");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->refphone->caption(), $employee_edit->refphone->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->urgence->Required) { ?>
				elm = this.getElements("x" + infix + "_urgence");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->urgence->caption(), $employee_edit->urgence->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->urgphone->Required) { ?>
				elm = this.getElements("x" + infix + "_urgphone");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->urgphone->caption(), $employee_edit->urgphone->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->joindate->Required) { ?>
				elm = this.getElements("x" + infix + "_joindate");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->joindate->caption(), $employee_edit->joindate->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_joindate");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_edit->joindate->errorMessage()) ?>");
			<?php if ($employee_edit->leavingdate->Required) { ?>
				elm = this.getElements("x" + infix + "_leavingdate");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->leavingdate->caption(), $employee_edit->leavingdate->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_leavingdate");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_edit->leavingdate->errorMessage()) ?>");
			<?php if ($employee_edit->leavingmotif->Required) { ?>
				elm = this.getElements("x" + infix + "_leavingmotif");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->leavingmotif->caption(), $employee_edit->leavingmotif->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->idtype->Required) { ?>
				elm = this.getElements("x" + infix + "_idtype");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->idtype->caption(), $employee_edit->idtype->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->idstatus->Required) { ?>
				elm = this.getElements("x" + infix + "_idstatus");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->idstatus->caption(), $employee_edit->idstatus->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->idfct->Required) { ?>
				elm = this.getElements("x" + infix + "_idfct");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->idfct->caption(), $employee_edit->idfct->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->idsect->Required) { ?>
				elm = this.getElements("x" + infix + "_idsect");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->idsect->caption(), $employee_edit->idsect->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->iddep->Required) { ?>
				elm = this.getElements("x" + infix + "_iddep");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->iddep->caption(), $employee_edit->iddep->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->iddesig->Required) { ?>
				elm = this.getElements("x" + infix + "_iddesig");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->iddesig->caption(), $employee_edit->iddesig->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_edit->qualif->Required) { ?>
				elm = this.getElements("x" + infix + "_qualif");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_edit->qualif->caption(), $employee_edit->qualif->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	femployeeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	femployeeedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Multi-Page
	femployeeedit.multiPage = new ew.MultiPage("femployeeedit");

	// Dynamic selection lists
	femployeeedit.lists["x_gender"] = <?php echo $employee_edit->gender->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_gender"].options = <?php echo JsonEncode($employee_edit->gender->options(FALSE, TRUE)) ?>;
	femployeeedit.lists["x_civilstatus"] = <?php echo $employee_edit->civilstatus->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_civilstatus"].options = <?php echo JsonEncode($employee_edit->civilstatus->options(FALSE, TRUE)) ?>;
	femployeeedit.lists["x_idtype"] = <?php echo $employee_edit->idtype->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_idtype"].options = <?php echo JsonEncode($employee_edit->idtype->lookupOptions()) ?>;
	femployeeedit.lists["x_idstatus"] = <?php echo $employee_edit->idstatus->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_idstatus"].options = <?php echo JsonEncode($employee_edit->idstatus->lookupOptions()) ?>;
	femployeeedit.lists["x_idfct"] = <?php echo $employee_edit->idfct->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_idfct"].options = <?php echo JsonEncode($employee_edit->idfct->lookupOptions()) ?>;
	femployeeedit.lists["x_idsect"] = <?php echo $employee_edit->idsect->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_idsect"].options = <?php echo JsonEncode($employee_edit->idsect->lookupOptions()) ?>;
	femployeeedit.lists["x_iddep"] = <?php echo $employee_edit->iddep->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_iddep"].options = <?php echo JsonEncode($employee_edit->iddep->lookupOptions()) ?>;
	femployeeedit.lists["x_iddesig"] = <?php echo $employee_edit->iddesig->Lookup->toClientList($employee_edit) ?>;
	femployeeedit.lists["x_iddesig"].options = <?php echo JsonEncode($employee_edit->iddesig->lookupOptions()) ?>;
	loadjs.done("femployeeedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $employee_edit->showPageHeader(); ?>
<?php
$employee_edit->showMessage();
?>
<form name="femployeeedit" id="femployeeedit" class="<?php echo $employee_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employee">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$employee_edit->IsModal ?>">
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="employee_edit"><!-- multi-page tabs -->
	<ul class="<?php echo $employee_edit->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $employee_edit->MultiPages->pageStyle(1) ?>" href="#tab_employee1" data-toggle="tab"><?php echo $employee->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $employee_edit->MultiPages->pageStyle(2) ?>" href="#tab_employee2" data-toggle="tab"><?php echo $employee->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $employee_edit->MultiPages->pageStyle(3) ?>" href="#tab_employee3" data-toggle="tab"><?php echo $employee->pageCaption(3) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $employee_edit->MultiPages->pageStyle(1) ?>" id="tab_employee1"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($employee_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_employee_idemp" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->idemp->caption() ?><?php echo $employee_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->idemp->cellAttributes() ?>>
<span id="el_employee_idemp">
<span<?php echo $employee_edit->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($employee_edit->idemp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="employee" data-field="x_idemp" data-page="1" name="x_idemp" id="x_idemp" value="<?php echo HtmlEncode($employee_edit->idemp->CurrentValue) ?>">
<?php echo $employee_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->noemp->Visible) { // noemp ?>
	<div id="r_noemp" class="form-group row">
		<label id="elh_employee_noemp" for="x_noemp" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->noemp->caption() ?><?php echo $employee_edit->noemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->noemp->cellAttributes() ?>>
<span id="el_employee_noemp">
<input type="text" data-table="employee" data-field="x_noemp" data-page="1" name="x_noemp" id="x_noemp" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($employee_edit->noemp->getPlaceHolder()) ?>" value="<?php echo $employee_edit->noemp->EditValue ?>"<?php echo $employee_edit->noemp->editAttributes() ?>>
</span>
<?php echo $employee_edit->noemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->lastname->Visible) { // lastname ?>
	<div id="r_lastname" class="form-group row">
		<label id="elh_employee_lastname" for="x_lastname" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->lastname->caption() ?><?php echo $employee_edit->lastname->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->lastname->cellAttributes() ?>>
<span id="el_employee_lastname">
<input type="text" data-table="employee" data-field="x_lastname" data-page="1" name="x_lastname" id="x_lastname" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_edit->lastname->getPlaceHolder()) ?>" value="<?php echo $employee_edit->lastname->EditValue ?>"<?php echo $employee_edit->lastname->editAttributes() ?>>
</span>
<?php echo $employee_edit->lastname->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->firstname->Visible) { // firstname ?>
	<div id="r_firstname" class="form-group row">
		<label id="elh_employee_firstname" for="x_firstname" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->firstname->caption() ?><?php echo $employee_edit->firstname->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->firstname->cellAttributes() ?>>
<span id="el_employee_firstname">
<input type="text" data-table="employee" data-field="x_firstname" data-page="1" name="x_firstname" id="x_firstname" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_edit->firstname->getPlaceHolder()) ?>" value="<?php echo $employee_edit->firstname->EditValue ?>"<?php echo $employee_edit->firstname->editAttributes() ?>>
</span>
<?php echo $employee_edit->firstname->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->basicsalary->Visible) { // basicsalary ?>
	<div id="r_basicsalary" class="form-group row">
		<label id="elh_employee_basicsalary" for="x_basicsalary" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->basicsalary->caption() ?><?php echo $employee_edit->basicsalary->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->basicsalary->cellAttributes() ?>>
<span id="el_employee_basicsalary">
<input type="text" data-table="employee" data-field="x_basicsalary" data-page="1" name="x_basicsalary" id="x_basicsalary" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($employee_edit->basicsalary->getPlaceHolder()) ?>" value="<?php echo $employee_edit->basicsalary->EditValue ?>"<?php echo $employee_edit->basicsalary->editAttributes() ?>>
</span>
<?php echo $employee_edit->basicsalary->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->nifcin->Visible) { // nifcin ?>
	<div id="r_nifcin" class="form-group row">
		<label id="elh_employee_nifcin" for="x_nifcin" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->nifcin->caption() ?><?php echo $employee_edit->nifcin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->nifcin->cellAttributes() ?>>
<span id="el_employee_nifcin">
<input type="text" data-table="employee" data-field="x_nifcin" data-page="1" name="x_nifcin" id="x_nifcin" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_edit->nifcin->getPlaceHolder()) ?>" value="<?php echo $employee_edit->nifcin->EditValue ?>"<?php echo $employee_edit->nifcin->editAttributes() ?>>
</span>
<?php echo $employee_edit->nifcin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_employee_gender" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->gender->caption() ?><?php echo $employee_edit->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->gender->cellAttributes() ?>>
<span id="el_employee_gender">
<div id="tp_x_gender" class="ew-template"><input type="radio" class="custom-control-input" data-table="employee" data-field="x_gender" data-page="1" data-value-separator="<?php echo $employee_edit->gender->displayValueSeparatorAttribute() ?>" name="x_gender" id="x_gender" value="{value}"<?php echo $employee_edit->gender->editAttributes() ?>></div>
<div id="dsl_x_gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employee_edit->gender->radioButtonListHtml(FALSE, "x_gender", 1) ?>
</div></div>
</span>
<?php echo $employee_edit->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->civilstatus->Visible) { // civilstatus ?>
	<div id="r_civilstatus" class="form-group row">
		<label id="elh_employee_civilstatus" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->civilstatus->caption() ?><?php echo $employee_edit->civilstatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->civilstatus->cellAttributes() ?>>
<span id="el_employee_civilstatus">
<div id="tp_x_civilstatus" class="ew-template"><input type="radio" class="custom-control-input" data-table="employee" data-field="x_civilstatus" data-page="1" data-value-separator="<?php echo $employee_edit->civilstatus->displayValueSeparatorAttribute() ?>" name="x_civilstatus" id="x_civilstatus" value="{value}"<?php echo $employee_edit->civilstatus->editAttributes() ?>></div>
<div id="dsl_x_civilstatus" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employee_edit->civilstatus->radioButtonListHtml(FALSE, "x_civilstatus", 1) ?>
</div></div>
</span>
<?php echo $employee_edit->civilstatus->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->joindate->Visible) { // joindate ?>
	<div id="r_joindate" class="form-group row">
		<label id="elh_employee_joindate" for="x_joindate" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->joindate->caption() ?><?php echo $employee_edit->joindate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->joindate->cellAttributes() ?>>
<span id="el_employee_joindate">
<input type="text" data-table="employee" data-field="x_joindate" data-page="1" name="x_joindate" id="x_joindate" maxlength="10" placeholder="<?php echo HtmlEncode($employee_edit->joindate->getPlaceHolder()) ?>" value="<?php echo $employee_edit->joindate->EditValue ?>"<?php echo $employee_edit->joindate->editAttributes() ?>>
<?php if (!$employee_edit->joindate->ReadOnly && !$employee_edit->joindate->Disabled && !isset($employee_edit->joindate->EditAttrs["readonly"]) && !isset($employee_edit->joindate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["femployeeedit", "datetimepicker"], function() {
	ew.createDateTimePicker("femployeeedit", "x_joindate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $employee_edit->joindate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->leavingdate->Visible) { // leavingdate ?>
	<div id="r_leavingdate" class="form-group row">
		<label id="elh_employee_leavingdate" for="x_leavingdate" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->leavingdate->caption() ?><?php echo $employee_edit->leavingdate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->leavingdate->cellAttributes() ?>>
<span id="el_employee_leavingdate">
<input type="text" data-table="employee" data-field="x_leavingdate" data-page="1" name="x_leavingdate" id="x_leavingdate" maxlength="10" placeholder="<?php echo HtmlEncode($employee_edit->leavingdate->getPlaceHolder()) ?>" value="<?php echo $employee_edit->leavingdate->EditValue ?>"<?php echo $employee_edit->leavingdate->editAttributes() ?>>
<?php if (!$employee_edit->leavingdate->ReadOnly && !$employee_edit->leavingdate->Disabled && !isset($employee_edit->leavingdate->EditAttrs["readonly"]) && !isset($employee_edit->leavingdate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["femployeeedit", "datetimepicker"], function() {
	ew.createDateTimePicker("femployeeedit", "x_leavingdate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $employee_edit->leavingdate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->leavingmotif->Visible) { // leavingmotif ?>
	<div id="r_leavingmotif" class="form-group row">
		<label id="elh_employee_leavingmotif" for="x_leavingmotif" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->leavingmotif->caption() ?><?php echo $employee_edit->leavingmotif->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->leavingmotif->cellAttributes() ?>>
<span id="el_employee_leavingmotif">
<input type="text" data-table="employee" data-field="x_leavingmotif" data-page="1" name="x_leavingmotif" id="x_leavingmotif" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_edit->leavingmotif->getPlaceHolder()) ?>" value="<?php echo $employee_edit->leavingmotif->EditValue ?>"<?php echo $employee_edit->leavingmotif->editAttributes() ?>>
</span>
<?php echo $employee_edit->leavingmotif->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->qualif->Visible) { // qualif ?>
	<div id="r_qualif" class="form-group row">
		<label id="elh_employee_qualif" for="x_qualif" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->qualif->caption() ?><?php echo $employee_edit->qualif->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->qualif->cellAttributes() ?>>
<span id="el_employee_qualif">
<input type="text" data-table="employee" data-field="x_qualif" data-page="1" name="x_qualif" id="x_qualif" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_edit->qualif->getPlaceHolder()) ?>" value="<?php echo $employee_edit->qualif->EditValue ?>"<?php echo $employee_edit->qualif->editAttributes() ?>>
</span>
<?php echo $employee_edit->qualif->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $employee_edit->MultiPages->pageStyle(2) ?>" id="tab_employee2"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($employee_edit->idtype->Visible) { // idtype ?>
	<div id="r_idtype" class="form-group row">
		<label id="elh_employee_idtype" for="x_idtype" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->idtype->caption() ?><?php echo $employee_edit->idtype->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->idtype->cellAttributes() ?>>
<span id="el_employee_idtype">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employee" data-field="x_idtype" data-page="2" data-value-separator="<?php echo $employee_edit->idtype->displayValueSeparatorAttribute() ?>" id="x_idtype" name="x_idtype"<?php echo $employee_edit->idtype->editAttributes() ?>>
			<?php echo $employee_edit->idtype->selectOptionListHtml("x_idtype") ?>
		</select>
</div>
<?php echo $employee_edit->idtype->Lookup->getParamTag($employee_edit, "p_x_idtype") ?>
</span>
<?php echo $employee_edit->idtype->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->idstatus->Visible) { // idstatus ?>
	<div id="r_idstatus" class="form-group row">
		<label id="elh_employee_idstatus" for="x_idstatus" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->idstatus->caption() ?><?php echo $employee_edit->idstatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->idstatus->cellAttributes() ?>>
<span id="el_employee_idstatus">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employee" data-field="x_idstatus" data-page="2" data-value-separator="<?php echo $employee_edit->idstatus->displayValueSeparatorAttribute() ?>" id="x_idstatus" name="x_idstatus"<?php echo $employee_edit->idstatus->editAttributes() ?>>
			<?php echo $employee_edit->idstatus->selectOptionListHtml("x_idstatus") ?>
		</select>
</div>
<?php echo $employee_edit->idstatus->Lookup->getParamTag($employee_edit, "p_x_idstatus") ?>
</span>
<?php echo $employee_edit->idstatus->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->idfct->Visible) { // idfct ?>
	<div id="r_idfct" class="form-group row">
		<label id="elh_employee_idfct" for="x_idfct" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->idfct->caption() ?><?php echo $employee_edit->idfct->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->idfct->cellAttributes() ?>>
<span id="el_employee_idfct">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idfct"><?php echo EmptyValue(strval($employee_edit->idfct->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_edit->idfct->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_edit->idfct->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_edit->idfct->ReadOnly || $employee_edit->idfct->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idfct',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_edit->idfct->Lookup->getParamTag($employee_edit, "p_x_idfct") ?>
<input type="hidden" data-table="employee" data-field="x_idfct" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_edit->idfct->displayValueSeparatorAttribute() ?>" name="x_idfct" id="x_idfct" value="<?php echo $employee_edit->idfct->CurrentValue ?>"<?php echo $employee_edit->idfct->editAttributes() ?>>
</span>
<?php echo $employee_edit->idfct->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->idsect->Visible) { // idsect ?>
	<div id="r_idsect" class="form-group row">
		<label id="elh_employee_idsect" for="x_idsect" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->idsect->caption() ?><?php echo $employee_edit->idsect->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->idsect->cellAttributes() ?>>
<span id="el_employee_idsect">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idsect"><?php echo EmptyValue(strval($employee_edit->idsect->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_edit->idsect->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_edit->idsect->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_edit->idsect->ReadOnly || $employee_edit->idsect->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idsect',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_edit->idsect->Lookup->getParamTag($employee_edit, "p_x_idsect") ?>
<input type="hidden" data-table="employee" data-field="x_idsect" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_edit->idsect->displayValueSeparatorAttribute() ?>" name="x_idsect" id="x_idsect" value="<?php echo $employee_edit->idsect->CurrentValue ?>"<?php echo $employee_edit->idsect->editAttributes() ?>>
</span>
<?php echo $employee_edit->idsect->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->iddep->Visible) { // iddep ?>
	<div id="r_iddep" class="form-group row">
		<label id="elh_employee_iddep" for="x_iddep" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->iddep->caption() ?><?php echo $employee_edit->iddep->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->iddep->cellAttributes() ?>>
<span id="el_employee_iddep">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_iddep"><?php echo EmptyValue(strval($employee_edit->iddep->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_edit->iddep->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_edit->iddep->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_edit->iddep->ReadOnly || $employee_edit->iddep->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_iddep',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_edit->iddep->Lookup->getParamTag($employee_edit, "p_x_iddep") ?>
<input type="hidden" data-table="employee" data-field="x_iddep" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_edit->iddep->displayValueSeparatorAttribute() ?>" name="x_iddep" id="x_iddep" value="<?php echo $employee_edit->iddep->CurrentValue ?>"<?php echo $employee_edit->iddep->editAttributes() ?>>
</span>
<?php echo $employee_edit->iddep->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->iddesig->Visible) { // iddesig ?>
	<div id="r_iddesig" class="form-group row">
		<label id="elh_employee_iddesig" for="x_iddesig" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->iddesig->caption() ?><?php echo $employee_edit->iddesig->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->iddesig->cellAttributes() ?>>
<span id="el_employee_iddesig">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_iddesig"><?php echo EmptyValue(strval($employee_edit->iddesig->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_edit->iddesig->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_edit->iddesig->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_edit->iddesig->ReadOnly || $employee_edit->iddesig->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_iddesig',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_edit->iddesig->Lookup->getParamTag($employee_edit, "p_x_iddesig") ?>
<input type="hidden" data-table="employee" data-field="x_iddesig" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_edit->iddesig->displayValueSeparatorAttribute() ?>" name="x_iddesig" id="x_iddesig" value="<?php echo $employee_edit->iddesig->CurrentValue ?>"<?php echo $employee_edit->iddesig->editAttributes() ?>>
</span>
<?php echo $employee_edit->iddesig->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $employee_edit->MultiPages->pageStyle(3) ?>" id="tab_employee3"><!-- multi-page .tab-pane -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($employee_edit->depend->Visible) { // depend ?>
	<div id="r_depend" class="form-group row">
		<label id="elh_employee_depend" for="x_depend" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->depend->caption() ?><?php echo $employee_edit->depend->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->depend->cellAttributes() ?>>
<span id="el_employee_depend">
<input type="text" data-table="employee" data-field="x_depend" data-page="3" name="x_depend" id="x_depend" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($employee_edit->depend->getPlaceHolder()) ?>" value="<?php echo $employee_edit->depend->EditValue ?>"<?php echo $employee_edit->depend->editAttributes() ?>>
</span>
<?php echo $employee_edit->depend->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->datenais->Visible) { // datenais ?>
	<div id="r_datenais" class="form-group row">
		<label id="elh_employee_datenais" for="x_datenais" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->datenais->caption() ?><?php echo $employee_edit->datenais->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->datenais->cellAttributes() ?>>
<span id="el_employee_datenais">
<input type="text" data-table="employee" data-field="x_datenais" data-page="3" name="x_datenais" id="x_datenais" maxlength="10" placeholder="<?php echo HtmlEncode($employee_edit->datenais->getPlaceHolder()) ?>" value="<?php echo $employee_edit->datenais->EditValue ?>"<?php echo $employee_edit->datenais->editAttributes() ?>>
<?php if (!$employee_edit->datenais->ReadOnly && !$employee_edit->datenais->Disabled && !isset($employee_edit->datenais->EditAttrs["readonly"]) && !isset($employee_edit->datenais->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["femployeeedit", "datetimepicker"], function() {
	ew.createDateTimePicker("femployeeedit", "x_datenais", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $employee_edit->datenais->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->lieunais->Visible) { // lieunais ?>
	<div id="r_lieunais" class="form-group row">
		<label id="elh_employee_lieunais" for="x_lieunais" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->lieunais->caption() ?><?php echo $employee_edit->lieunais->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->lieunais->cellAttributes() ?>>
<span id="el_employee_lieunais">
<input type="text" data-table="employee" data-field="x_lieunais" data-page="3" name="x_lieunais" id="x_lieunais" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_edit->lieunais->getPlaceHolder()) ?>" value="<?php echo $employee_edit->lieunais->EditValue ?>"<?php echo $employee_edit->lieunais->editAttributes() ?>>
</span>
<?php echo $employee_edit->lieunais->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->adresse->Visible) { // adresse ?>
	<div id="r_adresse" class="form-group row">
		<label id="elh_employee_adresse" for="x_adresse" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->adresse->caption() ?><?php echo $employee_edit->adresse->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->adresse->cellAttributes() ?>>
<span id="el_employee_adresse">
<input type="text" data-table="employee" data-field="x_adresse" data-page="3" name="x_adresse" id="x_adresse" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_edit->adresse->getPlaceHolder()) ?>" value="<?php echo $employee_edit->adresse->EditValue ?>"<?php echo $employee_edit->adresse->editAttributes() ?>>
</span>
<?php echo $employee_edit->adresse->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->phone->Visible) { // phone ?>
	<div id="r_phone" class="form-group row">
		<label id="elh_employee_phone" for="x_phone" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->phone->caption() ?><?php echo $employee_edit->phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->phone->cellAttributes() ?>>
<span id="el_employee_phone">
<input type="text" data-table="employee" data-field="x_phone" data-page="3" name="x_phone" id="x_phone" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_edit->phone->getPlaceHolder()) ?>" value="<?php echo $employee_edit->phone->EditValue ?>"<?php echo $employee_edit->phone->editAttributes() ?>>
</span>
<?php echo $employee_edit->phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_employee_reference" for="x_reference" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->reference->caption() ?><?php echo $employee_edit->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->reference->cellAttributes() ?>>
<span id="el_employee_reference">
<input type="text" data-table="employee" data-field="x_reference" data-page="3" name="x_reference" id="x_reference" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_edit->reference->getPlaceHolder()) ?>" value="<?php echo $employee_edit->reference->EditValue ?>"<?php echo $employee_edit->reference->editAttributes() ?>>
</span>
<?php echo $employee_edit->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->refphone->Visible) { // refphone ?>
	<div id="r_refphone" class="form-group row">
		<label id="elh_employee_refphone" for="x_refphone" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->refphone->caption() ?><?php echo $employee_edit->refphone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->refphone->cellAttributes() ?>>
<span id="el_employee_refphone">
<input type="text" data-table="employee" data-field="x_refphone" data-page="3" name="x_refphone" id="x_refphone" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_edit->refphone->getPlaceHolder()) ?>" value="<?php echo $employee_edit->refphone->EditValue ?>"<?php echo $employee_edit->refphone->editAttributes() ?>>
</span>
<?php echo $employee_edit->refphone->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->urgence->Visible) { // urgence ?>
	<div id="r_urgence" class="form-group row">
		<label id="elh_employee_urgence" for="x_urgence" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->urgence->caption() ?><?php echo $employee_edit->urgence->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->urgence->cellAttributes() ?>>
<span id="el_employee_urgence">
<input type="text" data-table="employee" data-field="x_urgence" data-page="3" name="x_urgence" id="x_urgence" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_edit->urgence->getPlaceHolder()) ?>" value="<?php echo $employee_edit->urgence->EditValue ?>"<?php echo $employee_edit->urgence->editAttributes() ?>>
</span>
<?php echo $employee_edit->urgence->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_edit->urgphone->Visible) { // urgphone ?>
	<div id="r_urgphone" class="form-group row">
		<label id="elh_employee_urgphone" for="x_urgphone" class="<?php echo $employee_edit->LeftColumnClass ?>"><?php echo $employee_edit->urgphone->caption() ?><?php echo $employee_edit->urgphone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_edit->RightColumnClass ?>"><div <?php echo $employee_edit->urgphone->cellAttributes() ?>>
<span id="el_employee_urgphone">
<input type="text" data-table="employee" data-field="x_urgphone" data-page="3" name="x_urgphone" id="x_urgphone" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_edit->urgphone->getPlaceHolder()) ?>" value="<?php echo $employee_edit->urgphone->EditValue ?>"<?php echo $employee_edit->urgphone->editAttributes() ?>>
</span>
<?php echo $employee_edit->urgphone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php
	if (in_array("policyemp", explode(",", $employee->getCurrentDetailTable())) && $policyemp->DetailEdit) {
?>
<?php if ($employee->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("policyemp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "policyempgrid.php" ?>
<?php } ?>
<?php
	if (in_array("detailpayroll", explode(",", $employee->getCurrentDetailTable())) && $detailpayroll->DetailEdit) {
?>
<?php if ($employee->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("detailpayroll", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "detailpayrollgrid.php" ?>
<?php } ?>
<?php if (!$employee_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employee_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employee_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$employee_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$employee_edit->terminate();
?>