<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$employee_add = new employee_add();

// Run the page
$employee_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$employee_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var femployeeadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	femployeeadd = currentForm = new ew.Form("femployeeadd", "add");

	// Validate form
	femployeeadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($employee_add->noemp->Required) { ?>
				elm = this.getElements("x" + infix + "_noemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->noemp->caption(), $employee_add->noemp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_noemp");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_add->noemp->errorMessage()) ?>");
			<?php if ($employee_add->lastname->Required) { ?>
				elm = this.getElements("x" + infix + "_lastname");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->lastname->caption(), $employee_add->lastname->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->firstname->Required) { ?>
				elm = this.getElements("x" + infix + "_firstname");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->firstname->caption(), $employee_add->firstname->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->basicsalary->Required) { ?>
				elm = this.getElements("x" + infix + "_basicsalary");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->basicsalary->caption(), $employee_add->basicsalary->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_basicsalary");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_add->basicsalary->errorMessage()) ?>");
			<?php if ($employee_add->nifcin->Required) { ?>
				elm = this.getElements("x" + infix + "_nifcin");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->nifcin->caption(), $employee_add->nifcin->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->gender->Required) { ?>
				elm = this.getElements("x" + infix + "_gender");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->gender->caption(), $employee_add->gender->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->civilstatus->Required) { ?>
				elm = this.getElements("x" + infix + "_civilstatus");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->civilstatus->caption(), $employee_add->civilstatus->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->depend->Required) { ?>
				elm = this.getElements("x" + infix + "_depend");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->depend->caption(), $employee_add->depend->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_depend");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_add->depend->errorMessage()) ?>");
			<?php if ($employee_add->datenais->Required) { ?>
				elm = this.getElements("x" + infix + "_datenais");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->datenais->caption(), $employee_add->datenais->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datenais");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_add->datenais->errorMessage()) ?>");
			<?php if ($employee_add->lieunais->Required) { ?>
				elm = this.getElements("x" + infix + "_lieunais");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->lieunais->caption(), $employee_add->lieunais->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->adresse->Required) { ?>
				elm = this.getElements("x" + infix + "_adresse");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->adresse->caption(), $employee_add->adresse->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->phone->Required) { ?>
				elm = this.getElements("x" + infix + "_phone");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->phone->caption(), $employee_add->phone->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->reference->Required) { ?>
				elm = this.getElements("x" + infix + "_reference");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->reference->caption(), $employee_add->reference->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->refphone->Required) { ?>
				elm = this.getElements("x" + infix + "_refphone");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->refphone->caption(), $employee_add->refphone->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->urgence->Required) { ?>
				elm = this.getElements("x" + infix + "_urgence");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->urgence->caption(), $employee_add->urgence->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->urgphone->Required) { ?>
				elm = this.getElements("x" + infix + "_urgphone");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->urgphone->caption(), $employee_add->urgphone->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->joindate->Required) { ?>
				elm = this.getElements("x" + infix + "_joindate");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->joindate->caption(), $employee_add->joindate->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_joindate");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_add->joindate->errorMessage()) ?>");
			<?php if ($employee_add->leavingdate->Required) { ?>
				elm = this.getElements("x" + infix + "_leavingdate");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->leavingdate->caption(), $employee_add->leavingdate->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_leavingdate");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($employee_add->leavingdate->errorMessage()) ?>");
			<?php if ($employee_add->leavingmotif->Required) { ?>
				elm = this.getElements("x" + infix + "_leavingmotif");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->leavingmotif->caption(), $employee_add->leavingmotif->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->idtype->Required) { ?>
				elm = this.getElements("x" + infix + "_idtype");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->idtype->caption(), $employee_add->idtype->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->idstatus->Required) { ?>
				elm = this.getElements("x" + infix + "_idstatus");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->idstatus->caption(), $employee_add->idstatus->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->idfct->Required) { ?>
				elm = this.getElements("x" + infix + "_idfct");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->idfct->caption(), $employee_add->idfct->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->idsect->Required) { ?>
				elm = this.getElements("x" + infix + "_idsect");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->idsect->caption(), $employee_add->idsect->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->iddep->Required) { ?>
				elm = this.getElements("x" + infix + "_iddep");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->iddep->caption(), $employee_add->iddep->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->iddesig->Required) { ?>
				elm = this.getElements("x" + infix + "_iddesig");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->iddesig->caption(), $employee_add->iddesig->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($employee_add->qualif->Required) { ?>
				elm = this.getElements("x" + infix + "_qualif");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $employee_add->qualif->caption(), $employee_add->qualif->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	femployeeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	femployeeadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Multi-Page
	femployeeadd.multiPage = new ew.MultiPage("femployeeadd");

	// Dynamic selection lists
	femployeeadd.lists["x_gender"] = <?php echo $employee_add->gender->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_gender"].options = <?php echo JsonEncode($employee_add->gender->options(FALSE, TRUE)) ?>;
	femployeeadd.lists["x_civilstatus"] = <?php echo $employee_add->civilstatus->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_civilstatus"].options = <?php echo JsonEncode($employee_add->civilstatus->options(FALSE, TRUE)) ?>;
	femployeeadd.lists["x_idtype"] = <?php echo $employee_add->idtype->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_idtype"].options = <?php echo JsonEncode($employee_add->idtype->lookupOptions()) ?>;
	femployeeadd.lists["x_idstatus"] = <?php echo $employee_add->idstatus->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_idstatus"].options = <?php echo JsonEncode($employee_add->idstatus->lookupOptions()) ?>;
	femployeeadd.lists["x_idfct"] = <?php echo $employee_add->idfct->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_idfct"].options = <?php echo JsonEncode($employee_add->idfct->lookupOptions()) ?>;
	femployeeadd.lists["x_idsect"] = <?php echo $employee_add->idsect->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_idsect"].options = <?php echo JsonEncode($employee_add->idsect->lookupOptions()) ?>;
	femployeeadd.lists["x_iddep"] = <?php echo $employee_add->iddep->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_iddep"].options = <?php echo JsonEncode($employee_add->iddep->lookupOptions()) ?>;
	femployeeadd.lists["x_iddesig"] = <?php echo $employee_add->iddesig->Lookup->toClientList($employee_add) ?>;
	femployeeadd.lists["x_iddesig"].options = <?php echo JsonEncode($employee_add->iddesig->lookupOptions()) ?>;
	loadjs.done("femployeeadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $employee_add->showPageHeader(); ?>
<?php
$employee_add->showMessage();
?>
<form name="femployeeadd" id="femployeeadd" class="<?php echo $employee_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="employee">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$employee_add->IsModal ?>">
<div class="ew-multi-page"><!-- multi-page -->
<div class="ew-nav-tabs" id="employee_add"><!-- multi-page tabs -->
	<ul class="<?php echo $employee_add->MultiPages->navStyle() ?>">
		<li class="nav-item"><a class="nav-link<?php echo $employee_add->MultiPages->pageStyle(1) ?>" href="#tab_employee1" data-toggle="tab"><?php echo $employee->pageCaption(1) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $employee_add->MultiPages->pageStyle(2) ?>" href="#tab_employee2" data-toggle="tab"><?php echo $employee->pageCaption(2) ?></a></li>
		<li class="nav-item"><a class="nav-link<?php echo $employee_add->MultiPages->pageStyle(3) ?>" href="#tab_employee3" data-toggle="tab"><?php echo $employee->pageCaption(3) ?></a></li>
	</ul>
	<div class="tab-content"><!-- multi-page tabs .tab-content -->
		<div class="tab-pane<?php echo $employee_add->MultiPages->pageStyle(1) ?>" id="tab_employee1"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($employee_add->noemp->Visible) { // noemp ?>
	<div id="r_noemp" class="form-group row">
		<label id="elh_employee_noemp" for="x_noemp" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->noemp->caption() ?><?php echo $employee_add->noemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->noemp->cellAttributes() ?>>
<span id="el_employee_noemp">
<input type="text" data-table="employee" data-field="x_noemp" data-page="1" name="x_noemp" id="x_noemp" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($employee_add->noemp->getPlaceHolder()) ?>" value="<?php echo $employee_add->noemp->EditValue ?>"<?php echo $employee_add->noemp->editAttributes() ?>>
</span>
<?php echo $employee_add->noemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->lastname->Visible) { // lastname ?>
	<div id="r_lastname" class="form-group row">
		<label id="elh_employee_lastname" for="x_lastname" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->lastname->caption() ?><?php echo $employee_add->lastname->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->lastname->cellAttributes() ?>>
<span id="el_employee_lastname">
<input type="text" data-table="employee" data-field="x_lastname" data-page="1" name="x_lastname" id="x_lastname" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_add->lastname->getPlaceHolder()) ?>" value="<?php echo $employee_add->lastname->EditValue ?>"<?php echo $employee_add->lastname->editAttributes() ?>>
</span>
<?php echo $employee_add->lastname->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->firstname->Visible) { // firstname ?>
	<div id="r_firstname" class="form-group row">
		<label id="elh_employee_firstname" for="x_firstname" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->firstname->caption() ?><?php echo $employee_add->firstname->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->firstname->cellAttributes() ?>>
<span id="el_employee_firstname">
<input type="text" data-table="employee" data-field="x_firstname" data-page="1" name="x_firstname" id="x_firstname" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_add->firstname->getPlaceHolder()) ?>" value="<?php echo $employee_add->firstname->EditValue ?>"<?php echo $employee_add->firstname->editAttributes() ?>>
</span>
<?php echo $employee_add->firstname->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->basicsalary->Visible) { // basicsalary ?>
	<div id="r_basicsalary" class="form-group row">
		<label id="elh_employee_basicsalary" for="x_basicsalary" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->basicsalary->caption() ?><?php echo $employee_add->basicsalary->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->basicsalary->cellAttributes() ?>>
<span id="el_employee_basicsalary">
<input type="text" data-table="employee" data-field="x_basicsalary" data-page="1" name="x_basicsalary" id="x_basicsalary" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($employee_add->basicsalary->getPlaceHolder()) ?>" value="<?php echo $employee_add->basicsalary->EditValue ?>"<?php echo $employee_add->basicsalary->editAttributes() ?>>
</span>
<?php echo $employee_add->basicsalary->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->nifcin->Visible) { // nifcin ?>
	<div id="r_nifcin" class="form-group row">
		<label id="elh_employee_nifcin" for="x_nifcin" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->nifcin->caption() ?><?php echo $employee_add->nifcin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->nifcin->cellAttributes() ?>>
<span id="el_employee_nifcin">
<input type="text" data-table="employee" data-field="x_nifcin" data-page="1" name="x_nifcin" id="x_nifcin" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_add->nifcin->getPlaceHolder()) ?>" value="<?php echo $employee_add->nifcin->EditValue ?>"<?php echo $employee_add->nifcin->editAttributes() ?>>
</span>
<?php echo $employee_add->nifcin->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->gender->Visible) { // gender ?>
	<div id="r_gender" class="form-group row">
		<label id="elh_employee_gender" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->gender->caption() ?><?php echo $employee_add->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->gender->cellAttributes() ?>>
<span id="el_employee_gender">
<div id="tp_x_gender" class="ew-template"><input type="radio" class="custom-control-input" data-table="employee" data-field="x_gender" data-page="1" data-value-separator="<?php echo $employee_add->gender->displayValueSeparatorAttribute() ?>" name="x_gender" id="x_gender" value="{value}"<?php echo $employee_add->gender->editAttributes() ?>></div>
<div id="dsl_x_gender" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employee_add->gender->radioButtonListHtml(FALSE, "x_gender", 1) ?>
</div></div>
</span>
<?php echo $employee_add->gender->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->civilstatus->Visible) { // civilstatus ?>
	<div id="r_civilstatus" class="form-group row">
		<label id="elh_employee_civilstatus" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->civilstatus->caption() ?><?php echo $employee_add->civilstatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->civilstatus->cellAttributes() ?>>
<span id="el_employee_civilstatus">
<div id="tp_x_civilstatus" class="ew-template"><input type="radio" class="custom-control-input" data-table="employee" data-field="x_civilstatus" data-page="1" data-value-separator="<?php echo $employee_add->civilstatus->displayValueSeparatorAttribute() ?>" name="x_civilstatus" id="x_civilstatus" value="{value}"<?php echo $employee_add->civilstatus->editAttributes() ?>></div>
<div id="dsl_x_civilstatus" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $employee_add->civilstatus->radioButtonListHtml(FALSE, "x_civilstatus", 1) ?>
</div></div>
</span>
<?php echo $employee_add->civilstatus->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->joindate->Visible) { // joindate ?>
	<div id="r_joindate" class="form-group row">
		<label id="elh_employee_joindate" for="x_joindate" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->joindate->caption() ?><?php echo $employee_add->joindate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->joindate->cellAttributes() ?>>
<span id="el_employee_joindate">
<input type="text" data-table="employee" data-field="x_joindate" data-page="1" name="x_joindate" id="x_joindate" maxlength="10" placeholder="<?php echo HtmlEncode($employee_add->joindate->getPlaceHolder()) ?>" value="<?php echo $employee_add->joindate->EditValue ?>"<?php echo $employee_add->joindate->editAttributes() ?>>
<?php if (!$employee_add->joindate->ReadOnly && !$employee_add->joindate->Disabled && !isset($employee_add->joindate->EditAttrs["readonly"]) && !isset($employee_add->joindate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["femployeeadd", "datetimepicker"], function() {
	ew.createDateTimePicker("femployeeadd", "x_joindate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $employee_add->joindate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->leavingdate->Visible) { // leavingdate ?>
	<div id="r_leavingdate" class="form-group row">
		<label id="elh_employee_leavingdate" for="x_leavingdate" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->leavingdate->caption() ?><?php echo $employee_add->leavingdate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->leavingdate->cellAttributes() ?>>
<span id="el_employee_leavingdate">
<input type="text" data-table="employee" data-field="x_leavingdate" data-page="1" name="x_leavingdate" id="x_leavingdate" maxlength="10" placeholder="<?php echo HtmlEncode($employee_add->leavingdate->getPlaceHolder()) ?>" value="<?php echo $employee_add->leavingdate->EditValue ?>"<?php echo $employee_add->leavingdate->editAttributes() ?>>
<?php if (!$employee_add->leavingdate->ReadOnly && !$employee_add->leavingdate->Disabled && !isset($employee_add->leavingdate->EditAttrs["readonly"]) && !isset($employee_add->leavingdate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["femployeeadd", "datetimepicker"], function() {
	ew.createDateTimePicker("femployeeadd", "x_leavingdate", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $employee_add->leavingdate->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->leavingmotif->Visible) { // leavingmotif ?>
	<div id="r_leavingmotif" class="form-group row">
		<label id="elh_employee_leavingmotif" for="x_leavingmotif" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->leavingmotif->caption() ?><?php echo $employee_add->leavingmotif->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->leavingmotif->cellAttributes() ?>>
<span id="el_employee_leavingmotif">
<input type="text" data-table="employee" data-field="x_leavingmotif" data-page="1" name="x_leavingmotif" id="x_leavingmotif" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_add->leavingmotif->getPlaceHolder()) ?>" value="<?php echo $employee_add->leavingmotif->EditValue ?>"<?php echo $employee_add->leavingmotif->editAttributes() ?>>
</span>
<?php echo $employee_add->leavingmotif->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->qualif->Visible) { // qualif ?>
	<div id="r_qualif" class="form-group row">
		<label id="elh_employee_qualif" for="x_qualif" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->qualif->caption() ?><?php echo $employee_add->qualif->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->qualif->cellAttributes() ?>>
<span id="el_employee_qualif">
<input type="text" data-table="employee" data-field="x_qualif" data-page="1" name="x_qualif" id="x_qualif" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_add->qualif->getPlaceHolder()) ?>" value="<?php echo $employee_add->qualif->EditValue ?>"<?php echo $employee_add->qualif->editAttributes() ?>>
</span>
<?php echo $employee_add->qualif->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $employee_add->MultiPages->pageStyle(2) ?>" id="tab_employee2"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($employee_add->idtype->Visible) { // idtype ?>
	<div id="r_idtype" class="form-group row">
		<label id="elh_employee_idtype" for="x_idtype" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->idtype->caption() ?><?php echo $employee_add->idtype->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->idtype->cellAttributes() ?>>
<span id="el_employee_idtype">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employee" data-field="x_idtype" data-page="2" data-value-separator="<?php echo $employee_add->idtype->displayValueSeparatorAttribute() ?>" id="x_idtype" name="x_idtype"<?php echo $employee_add->idtype->editAttributes() ?>>
			<?php echo $employee_add->idtype->selectOptionListHtml("x_idtype") ?>
		</select>
</div>
<?php echo $employee_add->idtype->Lookup->getParamTag($employee_add, "p_x_idtype") ?>
</span>
<?php echo $employee_add->idtype->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->idstatus->Visible) { // idstatus ?>
	<div id="r_idstatus" class="form-group row">
		<label id="elh_employee_idstatus" for="x_idstatus" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->idstatus->caption() ?><?php echo $employee_add->idstatus->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->idstatus->cellAttributes() ?>>
<span id="el_employee_idstatus">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="employee" data-field="x_idstatus" data-page="2" data-value-separator="<?php echo $employee_add->idstatus->displayValueSeparatorAttribute() ?>" id="x_idstatus" name="x_idstatus"<?php echo $employee_add->idstatus->editAttributes() ?>>
			<?php echo $employee_add->idstatus->selectOptionListHtml("x_idstatus") ?>
		</select>
</div>
<?php echo $employee_add->idstatus->Lookup->getParamTag($employee_add, "p_x_idstatus") ?>
</span>
<?php echo $employee_add->idstatus->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->idfct->Visible) { // idfct ?>
	<div id="r_idfct" class="form-group row">
		<label id="elh_employee_idfct" for="x_idfct" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->idfct->caption() ?><?php echo $employee_add->idfct->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->idfct->cellAttributes() ?>>
<span id="el_employee_idfct">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idfct"><?php echo EmptyValue(strval($employee_add->idfct->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_add->idfct->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_add->idfct->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_add->idfct->ReadOnly || $employee_add->idfct->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idfct',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_add->idfct->Lookup->getParamTag($employee_add, "p_x_idfct") ?>
<input type="hidden" data-table="employee" data-field="x_idfct" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_add->idfct->displayValueSeparatorAttribute() ?>" name="x_idfct" id="x_idfct" value="<?php echo $employee_add->idfct->CurrentValue ?>"<?php echo $employee_add->idfct->editAttributes() ?>>
</span>
<?php echo $employee_add->idfct->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->idsect->Visible) { // idsect ?>
	<div id="r_idsect" class="form-group row">
		<label id="elh_employee_idsect" for="x_idsect" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->idsect->caption() ?><?php echo $employee_add->idsect->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->idsect->cellAttributes() ?>>
<span id="el_employee_idsect">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idsect"><?php echo EmptyValue(strval($employee_add->idsect->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_add->idsect->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_add->idsect->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_add->idsect->ReadOnly || $employee_add->idsect->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idsect',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_add->idsect->Lookup->getParamTag($employee_add, "p_x_idsect") ?>
<input type="hidden" data-table="employee" data-field="x_idsect" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_add->idsect->displayValueSeparatorAttribute() ?>" name="x_idsect" id="x_idsect" value="<?php echo $employee_add->idsect->CurrentValue ?>"<?php echo $employee_add->idsect->editAttributes() ?>>
</span>
<?php echo $employee_add->idsect->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->iddep->Visible) { // iddep ?>
	<div id="r_iddep" class="form-group row">
		<label id="elh_employee_iddep" for="x_iddep" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->iddep->caption() ?><?php echo $employee_add->iddep->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->iddep->cellAttributes() ?>>
<span id="el_employee_iddep">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_iddep"><?php echo EmptyValue(strval($employee_add->iddep->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_add->iddep->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_add->iddep->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_add->iddep->ReadOnly || $employee_add->iddep->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_iddep',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_add->iddep->Lookup->getParamTag($employee_add, "p_x_iddep") ?>
<input type="hidden" data-table="employee" data-field="x_iddep" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_add->iddep->displayValueSeparatorAttribute() ?>" name="x_iddep" id="x_iddep" value="<?php echo $employee_add->iddep->CurrentValue ?>"<?php echo $employee_add->iddep->editAttributes() ?>>
</span>
<?php echo $employee_add->iddep->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->iddesig->Visible) { // iddesig ?>
	<div id="r_iddesig" class="form-group row">
		<label id="elh_employee_iddesig" for="x_iddesig" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->iddesig->caption() ?><?php echo $employee_add->iddesig->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->iddesig->cellAttributes() ?>>
<span id="el_employee_iddesig">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_iddesig"><?php echo EmptyValue(strval($employee_add->iddesig->ViewValue)) ? $Language->phrase("PleaseSelect") : $employee_add->iddesig->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($employee_add->iddesig->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($employee_add->iddesig->ReadOnly || $employee_add->iddesig->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_iddesig',m:0,n:10});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $employee_add->iddesig->Lookup->getParamTag($employee_add, "p_x_iddesig") ?>
<input type="hidden" data-table="employee" data-field="x_iddesig" data-page="2" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $employee_add->iddesig->displayValueSeparatorAttribute() ?>" name="x_iddesig" id="x_iddesig" value="<?php echo $employee_add->iddesig->CurrentValue ?>"<?php echo $employee_add->iddesig->editAttributes() ?>>
</span>
<?php echo $employee_add->iddesig->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
		<div class="tab-pane<?php echo $employee_add->MultiPages->pageStyle(3) ?>" id="tab_employee3"><!-- multi-page .tab-pane -->
<div class="ew-add-div"><!-- page* -->
<?php if ($employee_add->depend->Visible) { // depend ?>
	<div id="r_depend" class="form-group row">
		<label id="elh_employee_depend" for="x_depend" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->depend->caption() ?><?php echo $employee_add->depend->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->depend->cellAttributes() ?>>
<span id="el_employee_depend">
<input type="text" data-table="employee" data-field="x_depend" data-page="3" name="x_depend" id="x_depend" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($employee_add->depend->getPlaceHolder()) ?>" value="<?php echo $employee_add->depend->EditValue ?>"<?php echo $employee_add->depend->editAttributes() ?>>
</span>
<?php echo $employee_add->depend->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->datenais->Visible) { // datenais ?>
	<div id="r_datenais" class="form-group row">
		<label id="elh_employee_datenais" for="x_datenais" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->datenais->caption() ?><?php echo $employee_add->datenais->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->datenais->cellAttributes() ?>>
<span id="el_employee_datenais">
<input type="text" data-table="employee" data-field="x_datenais" data-page="3" name="x_datenais" id="x_datenais" maxlength="10" placeholder="<?php echo HtmlEncode($employee_add->datenais->getPlaceHolder()) ?>" value="<?php echo $employee_add->datenais->EditValue ?>"<?php echo $employee_add->datenais->editAttributes() ?>>
<?php if (!$employee_add->datenais->ReadOnly && !$employee_add->datenais->Disabled && !isset($employee_add->datenais->EditAttrs["readonly"]) && !isset($employee_add->datenais->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["femployeeadd", "datetimepicker"], function() {
	ew.createDateTimePicker("femployeeadd", "x_datenais", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php echo $employee_add->datenais->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->lieunais->Visible) { // lieunais ?>
	<div id="r_lieunais" class="form-group row">
		<label id="elh_employee_lieunais" for="x_lieunais" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->lieunais->caption() ?><?php echo $employee_add->lieunais->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->lieunais->cellAttributes() ?>>
<span id="el_employee_lieunais">
<input type="text" data-table="employee" data-field="x_lieunais" data-page="3" name="x_lieunais" id="x_lieunais" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_add->lieunais->getPlaceHolder()) ?>" value="<?php echo $employee_add->lieunais->EditValue ?>"<?php echo $employee_add->lieunais->editAttributes() ?>>
</span>
<?php echo $employee_add->lieunais->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->adresse->Visible) { // adresse ?>
	<div id="r_adresse" class="form-group row">
		<label id="elh_employee_adresse" for="x_adresse" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->adresse->caption() ?><?php echo $employee_add->adresse->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->adresse->cellAttributes() ?>>
<span id="el_employee_adresse">
<input type="text" data-table="employee" data-field="x_adresse" data-page="3" name="x_adresse" id="x_adresse" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($employee_add->adresse->getPlaceHolder()) ?>" value="<?php echo $employee_add->adresse->EditValue ?>"<?php echo $employee_add->adresse->editAttributes() ?>>
</span>
<?php echo $employee_add->adresse->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->phone->Visible) { // phone ?>
	<div id="r_phone" class="form-group row">
		<label id="elh_employee_phone" for="x_phone" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->phone->caption() ?><?php echo $employee_add->phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->phone->cellAttributes() ?>>
<span id="el_employee_phone">
<input type="text" data-table="employee" data-field="x_phone" data-page="3" name="x_phone" id="x_phone" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_add->phone->getPlaceHolder()) ?>" value="<?php echo $employee_add->phone->EditValue ?>"<?php echo $employee_add->phone->editAttributes() ?>>
</span>
<?php echo $employee_add->phone->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_employee_reference" for="x_reference" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->reference->caption() ?><?php echo $employee_add->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->reference->cellAttributes() ?>>
<span id="el_employee_reference">
<input type="text" data-table="employee" data-field="x_reference" data-page="3" name="x_reference" id="x_reference" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($employee_add->reference->getPlaceHolder()) ?>" value="<?php echo $employee_add->reference->EditValue ?>"<?php echo $employee_add->reference->editAttributes() ?>>
</span>
<?php echo $employee_add->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->refphone->Visible) { // refphone ?>
	<div id="r_refphone" class="form-group row">
		<label id="elh_employee_refphone" for="x_refphone" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->refphone->caption() ?><?php echo $employee_add->refphone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->refphone->cellAttributes() ?>>
<span id="el_employee_refphone">
<input type="text" data-table="employee" data-field="x_refphone" data-page="3" name="x_refphone" id="x_refphone" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_add->refphone->getPlaceHolder()) ?>" value="<?php echo $employee_add->refphone->EditValue ?>"<?php echo $employee_add->refphone->editAttributes() ?>>
</span>
<?php echo $employee_add->refphone->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->urgence->Visible) { // urgence ?>
	<div id="r_urgence" class="form-group row">
		<label id="elh_employee_urgence" for="x_urgence" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->urgence->caption() ?><?php echo $employee_add->urgence->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->urgence->cellAttributes() ?>>
<span id="el_employee_urgence">
<input type="text" data-table="employee" data-field="x_urgence" data-page="3" name="x_urgence" id="x_urgence" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_add->urgence->getPlaceHolder()) ?>" value="<?php echo $employee_add->urgence->EditValue ?>"<?php echo $employee_add->urgence->editAttributes() ?>>
</span>
<?php echo $employee_add->urgence->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($employee_add->urgphone->Visible) { // urgphone ?>
	<div id="r_urgphone" class="form-group row">
		<label id="elh_employee_urgphone" for="x_urgphone" class="<?php echo $employee_add->LeftColumnClass ?>"><?php echo $employee_add->urgphone->caption() ?><?php echo $employee_add->urgphone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $employee_add->RightColumnClass ?>"><div <?php echo $employee_add->urgphone->cellAttributes() ?>>
<span id="el_employee_urgphone">
<input type="text" data-table="employee" data-field="x_urgphone" data-page="3" name="x_urgphone" id="x_urgphone" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($employee_add->urgphone->getPlaceHolder()) ?>" value="<?php echo $employee_add->urgphone->EditValue ?>"<?php echo $employee_add->urgphone->editAttributes() ?>>
</span>
<?php echo $employee_add->urgphone->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
		</div><!-- /multi-page .tab-pane -->
	</div><!-- /multi-page tabs .tab-content -->
</div><!-- /multi-page tabs -->
</div><!-- /multi-page -->
<?php
	if (in_array("policyemp", explode(",", $employee->getCurrentDetailTable())) && $policyemp->DetailAdd) {
?>
<?php if ($employee->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("policyemp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "policyempgrid.php" ?>
<?php } ?>
<?php
	if (in_array("detailpayroll", explode(",", $employee->getCurrentDetailTable())) && $detailpayroll->DetailAdd) {
?>
<?php if ($employee->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("detailpayroll", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "detailpayrollgrid.php" ?>
<?php } ?>
<?php if (!$employee_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $employee_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $employee_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$employee_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$employee_add->terminate();
?>