<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($ej_datatemps_grid))
	$ej_datatemps_grid = new ej_datatemps_grid();

// Run the page
$ej_datatemps_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ej_datatemps_grid->Page_Render();
?>
<?php if (!$ej_datatemps_grid->isExport()) { ?>
<script>
var fej_datatempsgrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fej_datatempsgrid = new ew.Form("fej_datatempsgrid", "grid");
	fej_datatempsgrid.formKeyCountName = '<?php echo $ej_datatemps_grid->FormKeyCountName ?>';

	// Validate form
	fej_datatempsgrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($ej_datatemps_grid->datejob->Required) { ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ej_datatemps_grid->datejob->caption(), $ej_datatemps_grid->datejob->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.checkDateDef(elm.value))
					return this.onError(elm, "<?php echo JsEncode($ej_datatemps_grid->datejob->errorMessage()) ?>");
			<?php if ($ej_datatemps_grid->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ej_datatemps_grid->idemp->caption(), $ej_datatemps_grid->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($ej_datatemps_grid->nbrheur->Required) { ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ej_datatemps_grid->nbrheur->caption(), $ej_datatemps_grid->nbrheur->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($ej_datatemps_grid->tauxh->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ej_datatemps_grid->tauxh->caption(), $ej_datatemps_grid->tauxh->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($ej_datatemps_grid->tauxh->errorMessage()) ?>");
			<?php if ($ej_datatemps_grid->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ej_datatemps_grid->SubTotal->caption(), $ej_datatemps_grid->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($ej_datatemps_grid->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fej_datatempsgrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "datejob", false)) return false;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "nbrheur", false)) return false;
		if (ew.valueChanged(fobj, infix, "tauxh", false)) return false;
		if (ew.valueChanged(fobj, infix, "SubTotal", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fej_datatempsgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fej_datatempsgrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fej_datatempsgrid.lists["x_idemp"] = <?php echo $ej_datatemps_grid->idemp->Lookup->toClientList($ej_datatemps_grid) ?>;
	fej_datatempsgrid.lists["x_idemp"].options = <?php echo JsonEncode($ej_datatemps_grid->idemp->lookupOptions()) ?>;
	loadjs.done("fej_datatempsgrid");
});
</script>
<?php } ?>
<?php
$ej_datatemps_grid->renderOtherOptions();
?>
<?php if ($ej_datatemps_grid->TotalRecords > 0 || $ej_datatemps->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ej_datatemps_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ej_datatemps">
<?php if ($ej_datatemps_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $ej_datatemps_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fej_datatempsgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_ej_datatemps" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_ej_datatempsgrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ej_datatemps->RowType = ROWTYPE_HEADER;

// Render list options
$ej_datatemps_grid->renderListOptions();

// Render list options (header, left)
$ej_datatemps_grid->ListOptions->render("header", "left");
?>
<?php if ($ej_datatemps_grid->datejob->Visible) { // datejob ?>
	<?php if ($ej_datatemps_grid->SortUrl($ej_datatemps_grid->datejob) == "") { ?>
		<th data-name="datejob" class="<?php echo $ej_datatemps_grid->datejob->headerCellClass() ?>"><div id="elh_ej_datatemps_datejob" class="ej_datatemps_datejob"><div class="ew-table-header-caption"><?php echo $ej_datatemps_grid->datejob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datejob" class="<?php echo $ej_datatemps_grid->datejob->headerCellClass() ?>"><div><div id="elh_ej_datatemps_datejob" class="ej_datatemps_datejob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ej_datatemps_grid->datejob->caption() ?></span><span class="ew-table-header-sort"><?php if ($ej_datatemps_grid->datejob->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ej_datatemps_grid->datejob->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ej_datatemps_grid->idemp->Visible) { // idemp ?>
	<?php if ($ej_datatemps_grid->SortUrl($ej_datatemps_grid->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $ej_datatemps_grid->idemp->headerCellClass() ?>"><div id="elh_ej_datatemps_idemp" class="ej_datatemps_idemp"><div class="ew-table-header-caption"><?php echo $ej_datatemps_grid->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $ej_datatemps_grid->idemp->headerCellClass() ?>"><div><div id="elh_ej_datatemps_idemp" class="ej_datatemps_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ej_datatemps_grid->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ej_datatemps_grid->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ej_datatemps_grid->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ej_datatemps_grid->nbrheur->Visible) { // nbrheur ?>
	<?php if ($ej_datatemps_grid->SortUrl($ej_datatemps_grid->nbrheur) == "") { ?>
		<th data-name="nbrheur" class="<?php echo $ej_datatemps_grid->nbrheur->headerCellClass() ?>"><div id="elh_ej_datatemps_nbrheur" class="ej_datatemps_nbrheur"><div class="ew-table-header-caption"><?php echo $ej_datatemps_grid->nbrheur->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nbrheur" class="<?php echo $ej_datatemps_grid->nbrheur->headerCellClass() ?>"><div><div id="elh_ej_datatemps_nbrheur" class="ej_datatemps_nbrheur">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ej_datatemps_grid->nbrheur->caption() ?></span><span class="ew-table-header-sort"><?php if ($ej_datatemps_grid->nbrheur->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ej_datatemps_grid->nbrheur->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ej_datatemps_grid->tauxh->Visible) { // tauxh ?>
	<?php if ($ej_datatemps_grid->SortUrl($ej_datatemps_grid->tauxh) == "") { ?>
		<th data-name="tauxh" class="<?php echo $ej_datatemps_grid->tauxh->headerCellClass() ?>"><div id="elh_ej_datatemps_tauxh" class="ej_datatemps_tauxh"><div class="ew-table-header-caption"><?php echo $ej_datatemps_grid->tauxh->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tauxh" class="<?php echo $ej_datatemps_grid->tauxh->headerCellClass() ?>"><div><div id="elh_ej_datatemps_tauxh" class="ej_datatemps_tauxh">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ej_datatemps_grid->tauxh->caption() ?></span><span class="ew-table-header-sort"><?php if ($ej_datatemps_grid->tauxh->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ej_datatemps_grid->tauxh->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ej_datatemps_grid->SubTotal->Visible) { // SubTotal ?>
	<?php if ($ej_datatemps_grid->SortUrl($ej_datatemps_grid->SubTotal) == "") { ?>
		<th data-name="SubTotal" class="<?php echo $ej_datatemps_grid->SubTotal->headerCellClass() ?>"><div id="elh_ej_datatemps_SubTotal" class="ej_datatemps_SubTotal"><div class="ew-table-header-caption"><?php echo $ej_datatemps_grid->SubTotal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SubTotal" class="<?php echo $ej_datatemps_grid->SubTotal->headerCellClass() ?>"><div><div id="elh_ej_datatemps_SubTotal" class="ej_datatemps_SubTotal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ej_datatemps_grid->SubTotal->caption() ?></span><span class="ew-table-header-sort"><?php if ($ej_datatemps_grid->SubTotal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ej_datatemps_grid->SubTotal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ej_datatemps_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$ej_datatemps_grid->StartRecord = 1;
$ej_datatemps_grid->StopRecord = $ej_datatemps_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($ej_datatemps->isConfirm() || $ej_datatemps_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($ej_datatemps_grid->FormKeyCountName) && ($ej_datatemps_grid->isGridAdd() || $ej_datatemps_grid->isGridEdit() || $ej_datatemps->isConfirm())) {
		$ej_datatemps_grid->KeyCount = $CurrentForm->getValue($ej_datatemps_grid->FormKeyCountName);
		$ej_datatemps_grid->StopRecord = $ej_datatemps_grid->StartRecord + $ej_datatemps_grid->KeyCount - 1;
	}
}
$ej_datatemps_grid->RecordCount = $ej_datatemps_grid->StartRecord - 1;
if ($ej_datatemps_grid->Recordset && !$ej_datatemps_grid->Recordset->EOF) {
	$ej_datatemps_grid->Recordset->moveFirst();
	$selectLimit = $ej_datatemps_grid->UseSelectLimit;
	if (!$selectLimit && $ej_datatemps_grid->StartRecord > 1)
		$ej_datatemps_grid->Recordset->move($ej_datatemps_grid->StartRecord - 1);
} elseif (!$ej_datatemps->AllowAddDeleteRow && $ej_datatemps_grid->StopRecord == 0) {
	$ej_datatemps_grid->StopRecord = $ej_datatemps->GridAddRowCount;
}

// Initialize aggregate
$ej_datatemps->RowType = ROWTYPE_AGGREGATEINIT;
$ej_datatemps->resetAttributes();
$ej_datatemps_grid->renderRow();
if ($ej_datatemps_grid->isGridAdd())
	$ej_datatemps_grid->RowIndex = 0;
if ($ej_datatemps_grid->isGridEdit())
	$ej_datatemps_grid->RowIndex = 0;
while ($ej_datatemps_grid->RecordCount < $ej_datatemps_grid->StopRecord) {
	$ej_datatemps_grid->RecordCount++;
	if ($ej_datatemps_grid->RecordCount >= $ej_datatemps_grid->StartRecord) {
		$ej_datatemps_grid->RowCount++;
		if ($ej_datatemps_grid->isGridAdd() || $ej_datatemps_grid->isGridEdit() || $ej_datatemps->isConfirm()) {
			$ej_datatemps_grid->RowIndex++;
			$CurrentForm->Index = $ej_datatemps_grid->RowIndex;
			if ($CurrentForm->hasValue($ej_datatemps_grid->FormActionName) && ($ej_datatemps->isConfirm() || $ej_datatemps_grid->EventCancelled))
				$ej_datatemps_grid->RowAction = strval($CurrentForm->getValue($ej_datatemps_grid->FormActionName));
			elseif ($ej_datatemps_grid->isGridAdd())
				$ej_datatemps_grid->RowAction = "insert";
			else
				$ej_datatemps_grid->RowAction = "";
		}

		// Set up key count
		$ej_datatemps_grid->KeyCount = $ej_datatemps_grid->RowIndex;

		// Init row class and style
		$ej_datatemps->resetAttributes();
		$ej_datatemps->CssClass = "";
		if ($ej_datatemps_grid->isGridAdd()) {
			if ($ej_datatemps->CurrentMode == "copy") {
				$ej_datatemps_grid->loadRowValues($ej_datatemps_grid->Recordset); // Load row values
				$ej_datatemps_grid->setRecordKey($ej_datatemps_grid->RowOldKey, $ej_datatemps_grid->Recordset); // Set old record key
			} else {
				$ej_datatemps_grid->loadRowValues(); // Load default values
				$ej_datatemps_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$ej_datatemps_grid->loadRowValues($ej_datatemps_grid->Recordset); // Load row values
		}
		$ej_datatemps->RowType = ROWTYPE_VIEW; // Render view
		if ($ej_datatemps_grid->isGridAdd()) // Grid add
			$ej_datatemps->RowType = ROWTYPE_ADD; // Render add
		if ($ej_datatemps_grid->isGridAdd() && $ej_datatemps->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$ej_datatemps_grid->restoreCurrentRowFormValues($ej_datatemps_grid->RowIndex); // Restore form values
		if ($ej_datatemps_grid->isGridEdit()) { // Grid edit
			if ($ej_datatemps->EventCancelled)
				$ej_datatemps_grid->restoreCurrentRowFormValues($ej_datatemps_grid->RowIndex); // Restore form values
			if ($ej_datatemps_grid->RowAction == "insert")
				$ej_datatemps->RowType = ROWTYPE_ADD; // Render add
			else
				$ej_datatemps->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($ej_datatemps_grid->isGridEdit() && ($ej_datatemps->RowType == ROWTYPE_EDIT || $ej_datatemps->RowType == ROWTYPE_ADD) && $ej_datatemps->EventCancelled) // Update failed
			$ej_datatemps_grid->restoreCurrentRowFormValues($ej_datatemps_grid->RowIndex); // Restore form values
		if ($ej_datatemps->RowType == ROWTYPE_EDIT) // Edit row
			$ej_datatemps_grid->EditRowCount++;
		if ($ej_datatemps->isConfirm()) // Confirm row
			$ej_datatemps_grid->restoreCurrentRowFormValues($ej_datatemps_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$ej_datatemps->RowAttrs->merge(["data-rowindex" => $ej_datatemps_grid->RowCount, "id" => "r" . $ej_datatemps_grid->RowCount . "_ej_datatemps", "data-rowtype" => $ej_datatemps->RowType]);

		// Render row
		$ej_datatemps_grid->renderRow();

		// Render list options
		$ej_datatemps_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($ej_datatemps_grid->RowAction != "delete" && $ej_datatemps_grid->RowAction != "insertdelete" && !($ej_datatemps_grid->RowAction == "insert" && $ej_datatemps->isConfirm() && $ej_datatemps_grid->emptyRow())) {
?>
	<tr <?php echo $ej_datatemps->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ej_datatemps_grid->ListOptions->render("body", "left", $ej_datatemps_grid->RowCount);
?>
	<?php if ($ej_datatemps_grid->datejob->Visible) { // datejob ?>
		<td data-name="datejob" <?php echo $ej_datatemps_grid->datejob->cellAttributes() ?>>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_datejob" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_datejob" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" maxlength="10" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->datejob->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->datejob->EditValue ?>"<?php echo $ej_datatemps_grid->datejob->editAttributes() ?>>
<?php if (!$ej_datatemps_grid->datejob->ReadOnly && !$ej_datatemps_grid->datejob->Disabled && !isset($ej_datatemps_grid->datejob->EditAttrs["readonly"]) && !isset($ej_datatemps_grid->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fej_datatempsgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fej_datatempsgrid", "x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->OldValue) ?>">
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_datejob" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_datejob" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" maxlength="10" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->datejob->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->datejob->EditValue ?>"<?php echo $ej_datatemps_grid->datejob->editAttributes() ?>>
<?php if (!$ej_datatemps_grid->datejob->ReadOnly && !$ej_datatemps_grid->datejob->Disabled && !isset($ej_datatemps_grid->datejob->EditAttrs["readonly"]) && !isset($ej_datatemps_grid->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fej_datatempsgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fej_datatempsgrid", "x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_datejob">
<span<?php echo $ej_datatemps_grid->datejob->viewAttributes() ?>><?php echo $ej_datatemps_grid->datejob->getViewValue() ?></span>
</span>
<?php if (!$ej_datatemps->isConfirm()) { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_idattdetail" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idattdetail" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idattdetail" value="<?php echo HtmlEncode($ej_datatemps_grid->idattdetail->CurrentValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_idattdetail" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_idattdetail" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_idattdetail" value="<?php echo HtmlEncode($ej_datatemps_grid->idattdetail->OldValue) ?>">
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_EDIT || $ej_datatemps->CurrentMode == "edit") { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_idattdetail" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idattdetail" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idattdetail" value="<?php echo HtmlEncode($ej_datatemps_grid->idattdetail->CurrentValue) ?>">
<?php } ?>
	<?php if ($ej_datatemps_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $ej_datatemps_grid->idemp->cellAttributes() ?>>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_idemp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ej_datatemps" data-field="x_idemp" data-value-separator="<?php echo $ej_datatemps_grid->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp"<?php echo $ej_datatemps_grid->idemp->editAttributes() ?>>
			<?php echo $ej_datatemps_grid->idemp->selectOptionListHtml("x{$ej_datatemps_grid->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $ej_datatemps_grid->idemp->Lookup->getParamTag($ej_datatemps_grid, "p_x" . $ej_datatemps_grid->RowIndex . "_idemp") ?>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->OldValue) ?>">
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_idemp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ej_datatemps" data-field="x_idemp" data-value-separator="<?php echo $ej_datatemps_grid->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp"<?php echo $ej_datatemps_grid->idemp->editAttributes() ?>>
			<?php echo $ej_datatemps_grid->idemp->selectOptionListHtml("x{$ej_datatemps_grid->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $ej_datatemps_grid->idemp->Lookup->getParamTag($ej_datatemps_grid, "p_x" . $ej_datatemps_grid->RowIndex . "_idemp") ?>
</span>
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_idemp">
<span<?php echo $ej_datatemps_grid->idemp->viewAttributes() ?>><?php echo $ej_datatemps_grid->idemp->getViewValue() ?></span>
</span>
<?php if (!$ej_datatemps->isConfirm()) { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur" <?php echo $ej_datatemps_grid->nbrheur->cellAttributes() ?>>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_nbrheur" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_nbrheur" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" size="30" maxlength="1" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->nbrheur->EditValue ?>"<?php echo $ej_datatemps_grid->nbrheur->editAttributes() ?>>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->OldValue) ?>">
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_nbrheur" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_nbrheur" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" size="30" maxlength="1" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->nbrheur->EditValue ?>"<?php echo $ej_datatemps_grid->nbrheur->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_nbrheur">
<span<?php echo $ej_datatemps_grid->nbrheur->viewAttributes() ?>><?php echo $ej_datatemps_grid->nbrheur->getViewValue() ?></span>
</span>
<?php if (!$ej_datatemps->isConfirm()) { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh" <?php echo $ej_datatemps_grid->tauxh->cellAttributes() ?>>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_tauxh" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_tauxh" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->tauxh->EditValue ?>"<?php echo $ej_datatemps_grid->tauxh->editAttributes() ?>>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->OldValue) ?>">
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_tauxh" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_tauxh" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->tauxh->EditValue ?>"<?php echo $ej_datatemps_grid->tauxh->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_tauxh">
<span<?php echo $ej_datatemps_grid->tauxh->viewAttributes() ?>><?php echo $ej_datatemps_grid->tauxh->getViewValue() ?></span>
</span>
<?php if (!$ej_datatemps->isConfirm()) { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" <?php echo $ej_datatemps_grid->SubTotal->cellAttributes() ?>>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_SubTotal" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_SubTotal" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" size="30" maxlength="13" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->SubTotal->EditValue ?>"<?php echo $ej_datatemps_grid->SubTotal->editAttributes() ?>>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->OldValue) ?>">
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_SubTotal" class="form-group">
<input type="text" data-table="ej_datatemps" data-field="x_SubTotal" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" size="30" maxlength="13" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->SubTotal->EditValue ?>"<?php echo $ej_datatemps_grid->SubTotal->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($ej_datatemps->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $ej_datatemps_grid->RowCount ?>_ej_datatemps_SubTotal">
<span<?php echo $ej_datatemps_grid->SubTotal->viewAttributes() ?>><?php echo $ej_datatemps_grid->SubTotal->getViewValue() ?></span>
</span>
<?php if (!$ej_datatemps->isConfirm()) { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="fej_datatempsgrid$x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->FormValue) ?>">
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="fej_datatempsgrid$o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ej_datatemps_grid->ListOptions->render("body", "right", $ej_datatemps_grid->RowCount);
?>
	</tr>
<?php if ($ej_datatemps->RowType == ROWTYPE_ADD || $ej_datatemps->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fej_datatempsgrid", "load"], function() {
	fej_datatempsgrid.updateLists(<?php echo $ej_datatemps_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$ej_datatemps_grid->isGridAdd() || $ej_datatemps->CurrentMode == "copy")
		if (!$ej_datatemps_grid->Recordset->EOF)
			$ej_datatemps_grid->Recordset->moveNext();
}
?>
<?php
	if ($ej_datatemps->CurrentMode == "add" || $ej_datatemps->CurrentMode == "copy" || $ej_datatemps->CurrentMode == "edit") {
		$ej_datatemps_grid->RowIndex = '$rowindex$';
		$ej_datatemps_grid->loadRowValues();

		// Set row properties
		$ej_datatemps->resetAttributes();
		$ej_datatemps->RowAttrs->merge(["data-rowindex" => $ej_datatemps_grid->RowIndex, "id" => "r0_ej_datatemps", "data-rowtype" => ROWTYPE_ADD]);
		$ej_datatemps->RowAttrs->appendClass("ew-template");
		$ej_datatemps->RowType = ROWTYPE_ADD;

		// Render row
		$ej_datatemps_grid->renderRow();

		// Render list options
		$ej_datatemps_grid->renderListOptions();
		$ej_datatemps_grid->StartRowCount = 0;
?>
	<tr <?php echo $ej_datatemps->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ej_datatemps_grid->ListOptions->render("body", "left", $ej_datatemps_grid->RowIndex);
?>
	<?php if ($ej_datatemps_grid->datejob->Visible) { // datejob ?>
		<td data-name="datejob">
<?php if (!$ej_datatemps->isConfirm()) { ?>
<span id="el$rowindex$_ej_datatemps_datejob" class="form-group ej_datatemps_datejob">
<input type="text" data-table="ej_datatemps" data-field="x_datejob" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" maxlength="10" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->datejob->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->datejob->EditValue ?>"<?php echo $ej_datatemps_grid->datejob->editAttributes() ?>>
<?php if (!$ej_datatemps_grid->datejob->ReadOnly && !$ej_datatemps_grid->datejob->Disabled && !isset($ej_datatemps_grid->datejob->EditAttrs["readonly"]) && !isset($ej_datatemps_grid->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fej_datatempsgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fej_datatempsgrid", "x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":0});
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_ej_datatemps_datejob" class="form-group ej_datatemps_datejob">
<span<?php echo $ej_datatemps_grid->datejob->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($ej_datatemps_grid->datejob->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_datejob" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($ej_datatemps_grid->datejob->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if (!$ej_datatemps->isConfirm()) { ?>
<span id="el$rowindex$_ej_datatemps_idemp" class="form-group ej_datatemps_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ej_datatemps" data-field="x_idemp" data-value-separator="<?php echo $ej_datatemps_grid->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp"<?php echo $ej_datatemps_grid->idemp->editAttributes() ?>>
			<?php echo $ej_datatemps_grid->idemp->selectOptionListHtml("x{$ej_datatemps_grid->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $ej_datatemps_grid->idemp->Lookup->getParamTag($ej_datatemps_grid, "p_x" . $ej_datatemps_grid->RowIndex . "_idemp") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_ej_datatemps_idemp" class="form-group ej_datatemps_idemp">
<span<?php echo $ej_datatemps_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($ej_datatemps_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_idemp" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($ej_datatemps_grid->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur">
<?php if (!$ej_datatemps->isConfirm()) { ?>
<span id="el$rowindex$_ej_datatemps_nbrheur" class="form-group ej_datatemps_nbrheur">
<input type="text" data-table="ej_datatemps" data-field="x_nbrheur" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" size="30" maxlength="1" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->nbrheur->EditValue ?>"<?php echo $ej_datatemps_grid->nbrheur->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_ej_datatemps_nbrheur" class="form-group ej_datatemps_nbrheur">
<span<?php echo $ej_datatemps_grid->nbrheur->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($ej_datatemps_grid->nbrheur->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_nbrheur" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($ej_datatemps_grid->nbrheur->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh">
<?php if (!$ej_datatemps->isConfirm()) { ?>
<span id="el$rowindex$_ej_datatemps_tauxh" class="form-group ej_datatemps_tauxh">
<input type="text" data-table="ej_datatemps" data-field="x_tauxh" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->tauxh->EditValue ?>"<?php echo $ej_datatemps_grid->tauxh->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_ej_datatemps_tauxh" class="form-group ej_datatemps_tauxh">
<span<?php echo $ej_datatemps_grid->tauxh->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($ej_datatemps_grid->tauxh->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_tauxh" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($ej_datatemps_grid->tauxh->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($ej_datatemps_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal">
<?php if (!$ej_datatemps->isConfirm()) { ?>
<span id="el$rowindex$_ej_datatemps_SubTotal" class="form-group ej_datatemps_SubTotal">
<input type="text" data-table="ej_datatemps" data-field="x_SubTotal" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" size="30" maxlength="13" placeholder="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $ej_datatemps_grid->SubTotal->EditValue ?>"<?php echo $ej_datatemps_grid->SubTotal->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_ej_datatemps_SubTotal" class="form-group ej_datatemps_SubTotal">
<span<?php echo $ej_datatemps_grid->SubTotal->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($ej_datatemps_grid->SubTotal->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="x<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="ej_datatemps" data-field="x_SubTotal" name="o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" id="o<?php echo $ej_datatemps_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($ej_datatemps_grid->SubTotal->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ej_datatemps_grid->ListOptions->render("body", "right", $ej_datatemps_grid->RowIndex);
?>
<script>
loadjs.ready(["fej_datatempsgrid", "load"], function() {
	fej_datatempsgrid.updateLists(<?php echo $ej_datatemps_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($ej_datatemps->CurrentMode == "add" || $ej_datatemps->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $ej_datatemps_grid->FormKeyCountName ?>" id="<?php echo $ej_datatemps_grid->FormKeyCountName ?>" value="<?php echo $ej_datatemps_grid->KeyCount ?>">
<?php echo $ej_datatemps_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($ej_datatemps->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $ej_datatemps_grid->FormKeyCountName ?>" id="<?php echo $ej_datatemps_grid->FormKeyCountName ?>" value="<?php echo $ej_datatemps_grid->KeyCount ?>">
<?php echo $ej_datatemps_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($ej_datatemps->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fej_datatempsgrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ej_datatemps_grid->Recordset)
	$ej_datatemps_grid->Recordset->Close();
?>
<?php if ($ej_datatemps_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $ej_datatemps_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ej_datatemps_grid->TotalRecords == 0 && !$ej_datatemps->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ej_datatemps_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$ej_datatemps_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php
$ej_datatemps_grid->terminate();
?>