<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_view = new detailpayroll_view();

// Run the page
$detailpayroll_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<script>
var fdetailpayrollview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdetailpayrollview = currentForm = new ew.Form("fdetailpayrollview", "view");
	loadjs.done("fdetailpayrollview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $detailpayroll_view->ExportOptions->render("body") ?>
<?php $detailpayroll_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $detailpayroll_view->showPageHeader(); ?>
<?php
$detailpayroll_view->showMessage();
?>
<?php if (!$detailpayroll_view->IsModal) { ?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $detailpayroll_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fdetailpayrollview" id="fdetailpayrollview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="modal" value="<?php echo (int)$detailpayroll_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($detailpayroll_view->iddp->Visible) { // iddp ?>
	<tr id="r_iddp">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_iddp"><?php echo $detailpayroll_view->iddp->caption() ?></span></td>
		<td data-name="iddp" <?php echo $detailpayroll_view->iddp->cellAttributes() ?>>
<span id="el_detailpayroll_iddp">
<span<?php echo $detailpayroll_view->iddp->viewAttributes() ?>><?php echo $detailpayroll_view->iddp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->idpayroll->Visible) { // idpayroll ?>
	<tr id="r_idpayroll">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_idpayroll"><?php echo $detailpayroll_view->idpayroll->caption() ?></span></td>
		<td data-name="idpayroll" <?php echo $detailpayroll_view->idpayroll->cellAttributes() ?>>
<span id="el_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_view->idpayroll->viewAttributes() ?>><?php echo $detailpayroll_view->idpayroll->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_idemp"><?php echo $detailpayroll_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $detailpayroll_view->idemp->cellAttributes() ?>>
<span id="el_detailpayroll_idemp">
<span<?php echo $detailpayroll_view->idemp->viewAttributes() ?>><?php echo $detailpayroll_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->salaryp->Visible) { // salaryp ?>
	<tr id="r_salaryp">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_salaryp"><?php echo $detailpayroll_view->salaryp->caption() ?></span></td>
		<td data-name="salaryp" <?php echo $detailpayroll_view->salaryp->cellAttributes() ?>>
<span id="el_detailpayroll_salaryp">
<span<?php echo $detailpayroll_view->salaryp->viewAttributes() ?>><?php echo $detailpayroll_view->salaryp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->mtap->Visible) { // mtap ?>
	<tr id="r_mtap">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_mtap"><?php echo $detailpayroll_view->mtap->caption() ?></span></td>
		<td data-name="mtap" <?php echo $detailpayroll_view->mtap->cellAttributes() ?>>
<span id="el_detailpayroll_mtap">
<span<?php echo $detailpayroll_view->mtap->viewAttributes() ?>><?php echo $detailpayroll_view->mtap->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->mtdp->Visible) { // mtdp ?>
	<tr id="r_mtdp">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_mtdp"><?php echo $detailpayroll_view->mtdp->caption() ?></span></td>
		<td data-name="mtdp" <?php echo $detailpayroll_view->mtdp->cellAttributes() ?>>
<span id="el_detailpayroll_mtdp">
<span<?php echo $detailpayroll_view->mtdp->viewAttributes() ?>><?php echo $detailpayroll_view->mtdp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->netpay->Visible) { // netpay ?>
	<tr id="r_netpay">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_netpay"><?php echo $detailpayroll_view->netpay->caption() ?></span></td>
		<td data-name="netpay" <?php echo $detailpayroll_view->netpay->cellAttributes() ?>>
<span id="el_detailpayroll_netpay">
<span<?php echo $detailpayroll_view->netpay->viewAttributes() ?>><?php echo $detailpayroll_view->netpay->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($detailpayroll_view->listpolicy->Visible) { // listpolicy ?>
	<tr id="r_listpolicy">
		<td class="<?php echo $detailpayroll_view->TableLeftColumnClass ?>"><span id="elh_detailpayroll_listpolicy"><?php echo $detailpayroll_view->listpolicy->caption() ?></span></td>
		<td data-name="listpolicy" <?php echo $detailpayroll_view->listpolicy->cellAttributes() ?>>
<span id="el_detailpayroll_listpolicy">
<span<?php echo $detailpayroll_view->listpolicy->viewAttributes() ?>><?php echo $detailpayroll_view->listpolicy->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$detailpayroll_view->IsModal) { ?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<?php echo $detailpayroll_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
<?php
	if (in_array("policydp", explode(",", $detailpayroll->getCurrentDetailTable())) && $policydp->DetailView) {
?>
<?php if ($detailpayroll->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("policydp", "TblCaption") ?>&nbsp;<?php echo str_replace("%c", $detailpayroll_view->policydp_Count, $Language->phrase("DetailCount")) ?></h4>
<?php } ?>
<?php include_once "policydpgrid.php" ?>
<?php } ?>
</form>
<?php
$detailpayroll_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$detailpayroll_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_view->terminate();
?>