<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_list = new detailpayroll_list();

// Run the page
$detailpayroll_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<script>
var fdetailpayrolllist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fdetailpayrolllist = currentForm = new ew.Form("fdetailpayrolllist", "list");
	fdetailpayrolllist.formKeyCountName = '<?php echo $detailpayroll_list->FormKeyCountName ?>';
	loadjs.done("fdetailpayrolllist");
});
var fdetailpayrolllistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fdetailpayrolllistsrch = currentSearchForm = new ew.Form("fdetailpayrolllistsrch");

	// Dynamic selection lists
	// Filters

	fdetailpayrolllistsrch.filterList = <?php echo $detailpayroll_list->getFilterList() ?>;
	loadjs.done("fdetailpayrolllistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($detailpayroll_list->TotalRecords > 0 && $detailpayroll_list->ExportOptions->visible()) { ?>
<?php $detailpayroll_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($detailpayroll_list->ImportOptions->visible()) { ?>
<?php $detailpayroll_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($detailpayroll_list->SearchOptions->visible()) { ?>
<?php $detailpayroll_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($detailpayroll_list->FilterOptions->visible()) { ?>
<?php $detailpayroll_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$detailpayroll_list->isExport() || Config("EXPORT_MASTER_RECORD") && $detailpayroll_list->isExport("print")) { ?>
<?php
if ($detailpayroll_list->DbMasterFilter != "" && $detailpayroll->getCurrentMasterTable() == "payroll") {
	if ($detailpayroll_list->MasterRecordExists) {
		include_once "payrollmaster.php";
	}
}
?>
<?php
if ($detailpayroll_list->DbMasterFilter != "" && $detailpayroll->getCurrentMasterTable() == "employee") {
	if ($detailpayroll_list->MasterRecordExists) {
		include_once "employeemaster.php";
	}
}
?>
<?php } ?>
<?php
$detailpayroll_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$detailpayroll_list->isExport() && !$detailpayroll->CurrentAction) { ?>
<form name="fdetailpayrolllistsrch" id="fdetailpayrolllistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fdetailpayrolllistsrch-search-panel" class="<?php echo $detailpayroll_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="detailpayroll">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $detailpayroll_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($detailpayroll_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($detailpayroll_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $detailpayroll_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($detailpayroll_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($detailpayroll_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($detailpayroll_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($detailpayroll_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $detailpayroll_list->showPageHeader(); ?>
<?php
$detailpayroll_list->showMessage();
?>
<?php if ($detailpayroll_list->TotalRecords > 0 || $detailpayroll->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($detailpayroll_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> detailpayroll">
<?php if (!$detailpayroll_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$detailpayroll_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $detailpayroll_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $detailpayroll_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdetailpayrolllist" id="fdetailpayrolllist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($detailpayroll->getCurrentMasterTable() == "payroll" && $detailpayroll->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="payroll">
<input type="hidden" name="fk_idpayroll" value="<?php echo HtmlEncode($detailpayroll_list->idpayroll->getSessionValue()) ?>">
<?php } ?>
<?php if ($detailpayroll->getCurrentMasterTable() == "employee" && $detailpayroll->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employee">
<input type="hidden" name="fk_idemp" value="<?php echo HtmlEncode($detailpayroll_list->idemp->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_detailpayroll" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($detailpayroll_list->TotalRecords > 0 || $detailpayroll_list->isGridEdit()) { ?>
<table id="tbl_detailpayrolllist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$detailpayroll->RowType = ROWTYPE_HEADER;

// Render list options
$detailpayroll_list->renderListOptions();

// Render list options (header, left)
$detailpayroll_list->ListOptions->render("header", "left");
?>
<?php if ($detailpayroll_list->idpayroll->Visible) { // idpayroll ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->idpayroll) == "") { ?>
		<th data-name="idpayroll" class="<?php echo $detailpayroll_list->idpayroll->headerCellClass() ?>"><div id="elh_detailpayroll_idpayroll" class="detailpayroll_idpayroll"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->idpayroll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpayroll" class="<?php echo $detailpayroll_list->idpayroll->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->idpayroll) ?>', 1);"><div id="elh_detailpayroll_idpayroll" class="detailpayroll_idpayroll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->idpayroll->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->idpayroll->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->idpayroll->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->idemp->Visible) { // idemp ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $detailpayroll_list->idemp->headerCellClass() ?>"><div id="elh_detailpayroll_idemp" class="detailpayroll_idemp"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $detailpayroll_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->idemp) ?>', 1);"><div id="elh_detailpayroll_idemp" class="detailpayroll_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->salaryp->Visible) { // salaryp ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->salaryp) == "") { ?>
		<th data-name="salaryp" class="<?php echo $detailpayroll_list->salaryp->headerCellClass() ?>"><div id="elh_detailpayroll_salaryp" class="detailpayroll_salaryp"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->salaryp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="salaryp" class="<?php echo $detailpayroll_list->salaryp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->salaryp) ?>', 1);"><div id="elh_detailpayroll_salaryp" class="detailpayroll_salaryp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->salaryp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->salaryp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->salaryp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->mtap->Visible) { // mtap ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->mtap) == "") { ?>
		<th data-name="mtap" class="<?php echo $detailpayroll_list->mtap->headerCellClass() ?>"><div id="elh_detailpayroll_mtap" class="detailpayroll_mtap"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->mtap->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mtap" class="<?php echo $detailpayroll_list->mtap->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->mtap) ?>', 1);"><div id="elh_detailpayroll_mtap" class="detailpayroll_mtap">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->mtap->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->mtap->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->mtap->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->mtdp->Visible) { // mtdp ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->mtdp) == "") { ?>
		<th data-name="mtdp" class="<?php echo $detailpayroll_list->mtdp->headerCellClass() ?>"><div id="elh_detailpayroll_mtdp" class="detailpayroll_mtdp"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->mtdp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mtdp" class="<?php echo $detailpayroll_list->mtdp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->mtdp) ?>', 1);"><div id="elh_detailpayroll_mtdp" class="detailpayroll_mtdp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->mtdp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->mtdp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->mtdp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->netpay->Visible) { // netpay ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->netpay) == "") { ?>
		<th data-name="netpay" class="<?php echo $detailpayroll_list->netpay->headerCellClass() ?>"><div id="elh_detailpayroll_netpay" class="detailpayroll_netpay"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->netpay->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="netpay" class="<?php echo $detailpayroll_list->netpay->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->netpay) ?>', 1);"><div id="elh_detailpayroll_netpay" class="detailpayroll_netpay">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->netpay->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->netpay->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->netpay->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_list->listpolicy->Visible) { // listpolicy ?>
	<?php if ($detailpayroll_list->SortUrl($detailpayroll_list->listpolicy) == "") { ?>
		<th data-name="listpolicy" class="<?php echo $detailpayroll_list->listpolicy->headerCellClass() ?>"><div id="elh_detailpayroll_listpolicy" class="detailpayroll_listpolicy"><div class="ew-table-header-caption"><?php echo $detailpayroll_list->listpolicy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="listpolicy" class="<?php echo $detailpayroll_list->listpolicy->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $detailpayroll_list->SortUrl($detailpayroll_list->listpolicy) ?>', 1);"><div id="elh_detailpayroll_listpolicy" class="detailpayroll_listpolicy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_list->listpolicy->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_list->listpolicy->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_list->listpolicy->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$detailpayroll_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($detailpayroll_list->ExportAll && $detailpayroll_list->isExport()) {
	$detailpayroll_list->StopRecord = $detailpayroll_list->TotalRecords;
} else {

	// Set the last record to display
	if ($detailpayroll_list->TotalRecords > $detailpayroll_list->StartRecord + $detailpayroll_list->DisplayRecords - 1)
		$detailpayroll_list->StopRecord = $detailpayroll_list->StartRecord + $detailpayroll_list->DisplayRecords - 1;
	else
		$detailpayroll_list->StopRecord = $detailpayroll_list->TotalRecords;
}
$detailpayroll_list->RecordCount = $detailpayroll_list->StartRecord - 1;
if ($detailpayroll_list->Recordset && !$detailpayroll_list->Recordset->EOF) {
	$detailpayroll_list->Recordset->moveFirst();
	$selectLimit = $detailpayroll_list->UseSelectLimit;
	if (!$selectLimit && $detailpayroll_list->StartRecord > 1)
		$detailpayroll_list->Recordset->move($detailpayroll_list->StartRecord - 1);
} elseif (!$detailpayroll->AllowAddDeleteRow && $detailpayroll_list->StopRecord == 0) {
	$detailpayroll_list->StopRecord = $detailpayroll->GridAddRowCount;
}

// Initialize aggregate
$detailpayroll->RowType = ROWTYPE_AGGREGATEINIT;
$detailpayroll->resetAttributes();
$detailpayroll_list->renderRow();
while ($detailpayroll_list->RecordCount < $detailpayroll_list->StopRecord) {
	$detailpayroll_list->RecordCount++;
	if ($detailpayroll_list->RecordCount >= $detailpayroll_list->StartRecord) {
		$detailpayroll_list->RowCount++;

		// Set up key count
		$detailpayroll_list->KeyCount = $detailpayroll_list->RowIndex;

		// Init row class and style
		$detailpayroll->resetAttributes();
		$detailpayroll->CssClass = "";
		if ($detailpayroll_list->isGridAdd()) {
		} else {
			$detailpayroll_list->loadRowValues($detailpayroll_list->Recordset); // Load row values
		}
		$detailpayroll->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$detailpayroll->RowAttrs->merge(["data-rowindex" => $detailpayroll_list->RowCount, "id" => "r" . $detailpayroll_list->RowCount . "_detailpayroll", "data-rowtype" => $detailpayroll->RowType]);

		// Render row
		$detailpayroll_list->renderRow();

		// Render list options
		$detailpayroll_list->renderListOptions();
?>
	<tr <?php echo $detailpayroll->rowAttributes() ?>>
<?php

// Render list options (body, left)
$detailpayroll_list->ListOptions->render("body", "left", $detailpayroll_list->RowCount);
?>
	<?php if ($detailpayroll_list->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll" <?php echo $detailpayroll_list->idpayroll->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_list->idpayroll->viewAttributes() ?>><?php echo $detailpayroll_list->idpayroll->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $detailpayroll_list->idemp->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_idemp">
<span<?php echo $detailpayroll_list->idemp->viewAttributes() ?>><?php echo $detailpayroll_list->idemp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->salaryp->Visible) { // salaryp ?>
		<td data-name="salaryp" <?php echo $detailpayroll_list->salaryp->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_salaryp">
<span<?php echo $detailpayroll_list->salaryp->viewAttributes() ?>><?php echo $detailpayroll_list->salaryp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->mtap->Visible) { // mtap ?>
		<td data-name="mtap" <?php echo $detailpayroll_list->mtap->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_mtap">
<span<?php echo $detailpayroll_list->mtap->viewAttributes() ?>><?php echo $detailpayroll_list->mtap->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->mtdp->Visible) { // mtdp ?>
		<td data-name="mtdp" <?php echo $detailpayroll_list->mtdp->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_mtdp">
<span<?php echo $detailpayroll_list->mtdp->viewAttributes() ?>><?php echo $detailpayroll_list->mtdp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->netpay->Visible) { // netpay ?>
		<td data-name="netpay" <?php echo $detailpayroll_list->netpay->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_netpay">
<span<?php echo $detailpayroll_list->netpay->viewAttributes() ?>><?php echo $detailpayroll_list->netpay->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($detailpayroll_list->listpolicy->Visible) { // listpolicy ?>
		<td data-name="listpolicy" <?php echo $detailpayroll_list->listpolicy->cellAttributes() ?>>
<span id="el<?php echo $detailpayroll_list->RowCount ?>_detailpayroll_listpolicy">
<span<?php echo $detailpayroll_list->listpolicy->viewAttributes() ?>><?php echo $detailpayroll_list->listpolicy->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$detailpayroll_list->ListOptions->render("body", "right", $detailpayroll_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$detailpayroll_list->isGridAdd())
		$detailpayroll_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$detailpayroll->RowType = ROWTYPE_AGGREGATE;
$detailpayroll->resetAttributes();
$detailpayroll_list->renderRow();
?>
<?php if ($detailpayroll_list->TotalRecords > 0 && !$detailpayroll_list->isGridAdd() && !$detailpayroll_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$detailpayroll_list->renderListOptions();

// Render list options (footer, left)
$detailpayroll_list->ListOptions->render("footer", "left");
?>
	<?php if ($detailpayroll_list->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll" class="<?php echo $detailpayroll_list->idpayroll->footerCellClass() ?>"><span id="elf_detailpayroll_idpayroll" class="detailpayroll_idpayroll">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_list->idpayroll->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" class="<?php echo $detailpayroll_list->idemp->footerCellClass() ?>"><span id="elf_detailpayroll_idemp" class="detailpayroll_idemp">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_list->idemp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_list->salaryp->Visible) { // salaryp ?>
		<td data-name="salaryp" class="<?php echo $detailpayroll_list->salaryp->footerCellClass() ?>"><span id="elf_detailpayroll_salaryp" class="detailpayroll_salaryp">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_list->salaryp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_list->mtap->Visible) { // mtap ?>
		<td data-name="mtap" class="<?php echo $detailpayroll_list->mtap->footerCellClass() ?>"><span id="elf_detailpayroll_mtap" class="detailpayroll_mtap">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_list->mtap->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_list->mtdp->Visible) { // mtdp ?>
		<td data-name="mtdp" class="<?php echo $detailpayroll_list->mtdp->footerCellClass() ?>"><span id="elf_detailpayroll_mtdp" class="detailpayroll_mtdp">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_list->mtdp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_list->netpay->Visible) { // netpay ?>
		<td data-name="netpay" class="<?php echo $detailpayroll_list->netpay->footerCellClass() ?>"><span id="elf_detailpayroll_netpay" class="detailpayroll_netpay">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_list->netpay->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_list->listpolicy->Visible) { // listpolicy ?>
		<td data-name="listpolicy" class="<?php echo $detailpayroll_list->listpolicy->footerCellClass() ?>"><span id="elf_detailpayroll_listpolicy" class="detailpayroll_listpolicy">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$detailpayroll_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$detailpayroll->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($detailpayroll_list->Recordset)
	$detailpayroll_list->Recordset->Close();
?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$detailpayroll_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $detailpayroll_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $detailpayroll_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($detailpayroll_list->TotalRecords == 0 && !$detailpayroll->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $detailpayroll_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$detailpayroll_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$detailpayroll_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_list->terminate();
?>