<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($detailpayroll_grid))
	$detailpayroll_grid = new detailpayroll_grid();

// Run the page
$detailpayroll_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_grid->Page_Render();
?>
<?php if (!$detailpayroll_grid->isExport()) { ?>
<script>
var fdetailpayrollgrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fdetailpayrollgrid = new ew.Form("fdetailpayrollgrid", "grid");
	fdetailpayrollgrid.formKeyCountName = '<?php echo $detailpayroll_grid->FormKeyCountName ?>';

	// Validate form
	fdetailpayrollgrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($detailpayroll_grid->idpayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->idpayroll->caption(), $detailpayroll_grid->idpayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_grid->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->idemp->caption(), $detailpayroll_grid->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_grid->salaryp->Required) { ?>
				elm = this.getElements("x" + infix + "_salaryp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->salaryp->caption(), $detailpayroll_grid->salaryp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_salaryp");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_grid->salaryp->errorMessage()) ?>");
			<?php if ($detailpayroll_grid->mtap->Required) { ?>
				elm = this.getElements("x" + infix + "_mtap");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->mtap->caption(), $detailpayroll_grid->mtap->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mtap");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_grid->mtap->errorMessage()) ?>");
			<?php if ($detailpayroll_grid->mtdp->Required) { ?>
				elm = this.getElements("x" + infix + "_mtdp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->mtdp->caption(), $detailpayroll_grid->mtdp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_mtdp");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_grid->mtdp->errorMessage()) ?>");
			<?php if ($detailpayroll_grid->netpay->Required) { ?>
				elm = this.getElements("x" + infix + "_netpay");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->netpay->caption(), $detailpayroll_grid->netpay->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_netpay");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_grid->netpay->errorMessage()) ?>");
			<?php if ($detailpayroll_grid->listpolicy->Required) { ?>
				elm = this.getElements("x" + infix + "_listpolicy");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_grid->listpolicy->caption(), $detailpayroll_grid->listpolicy->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fdetailpayrollgrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "idpayroll", false)) return false;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "salaryp", false)) return false;
		if (ew.valueChanged(fobj, infix, "mtap", false)) return false;
		if (ew.valueChanged(fobj, infix, "mtdp", false)) return false;
		if (ew.valueChanged(fobj, infix, "netpay", false)) return false;
		if (ew.valueChanged(fobj, infix, "listpolicy", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fdetailpayrollgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdetailpayrollgrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdetailpayrollgrid.lists["x_idpayroll"] = <?php echo $detailpayroll_grid->idpayroll->Lookup->toClientList($detailpayroll_grid) ?>;
	fdetailpayrollgrid.lists["x_idpayroll"].options = <?php echo JsonEncode($detailpayroll_grid->idpayroll->lookupOptions()) ?>;
	fdetailpayrollgrid.lists["x_idemp"] = <?php echo $detailpayroll_grid->idemp->Lookup->toClientList($detailpayroll_grid) ?>;
	fdetailpayrollgrid.lists["x_idemp"].options = <?php echo JsonEncode($detailpayroll_grid->idemp->lookupOptions()) ?>;
	loadjs.done("fdetailpayrollgrid");
});
</script>
<?php } ?>
<?php
$detailpayroll_grid->renderOtherOptions();
?>
<?php if ($detailpayroll_grid->TotalRecords > 0 || $detailpayroll->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($detailpayroll_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> detailpayroll">
<?php if ($detailpayroll_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $detailpayroll_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fdetailpayrollgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_detailpayroll" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_detailpayrollgrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$detailpayroll->RowType = ROWTYPE_HEADER;

// Render list options
$detailpayroll_grid->renderListOptions();

// Render list options (header, left)
$detailpayroll_grid->ListOptions->render("header", "left");
?>
<?php if ($detailpayroll_grid->idpayroll->Visible) { // idpayroll ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->idpayroll) == "") { ?>
		<th data-name="idpayroll" class="<?php echo $detailpayroll_grid->idpayroll->headerCellClass() ?>"><div id="elh_detailpayroll_idpayroll" class="detailpayroll_idpayroll"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->idpayroll->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idpayroll" class="<?php echo $detailpayroll_grid->idpayroll->headerCellClass() ?>"><div><div id="elh_detailpayroll_idpayroll" class="detailpayroll_idpayroll">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->idpayroll->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->idpayroll->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->idpayroll->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_grid->idemp->Visible) { // idemp ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $detailpayroll_grid->idemp->headerCellClass() ?>"><div id="elh_detailpayroll_idemp" class="detailpayroll_idemp"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $detailpayroll_grid->idemp->headerCellClass() ?>"><div><div id="elh_detailpayroll_idemp" class="detailpayroll_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_grid->salaryp->Visible) { // salaryp ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->salaryp) == "") { ?>
		<th data-name="salaryp" class="<?php echo $detailpayroll_grid->salaryp->headerCellClass() ?>"><div id="elh_detailpayroll_salaryp" class="detailpayroll_salaryp"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->salaryp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="salaryp" class="<?php echo $detailpayroll_grid->salaryp->headerCellClass() ?>"><div><div id="elh_detailpayroll_salaryp" class="detailpayroll_salaryp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->salaryp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->salaryp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->salaryp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_grid->mtap->Visible) { // mtap ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->mtap) == "") { ?>
		<th data-name="mtap" class="<?php echo $detailpayroll_grid->mtap->headerCellClass() ?>"><div id="elh_detailpayroll_mtap" class="detailpayroll_mtap"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->mtap->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mtap" class="<?php echo $detailpayroll_grid->mtap->headerCellClass() ?>"><div><div id="elh_detailpayroll_mtap" class="detailpayroll_mtap">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->mtap->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->mtap->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->mtap->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_grid->mtdp->Visible) { // mtdp ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->mtdp) == "") { ?>
		<th data-name="mtdp" class="<?php echo $detailpayroll_grid->mtdp->headerCellClass() ?>"><div id="elh_detailpayroll_mtdp" class="detailpayroll_mtdp"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->mtdp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mtdp" class="<?php echo $detailpayroll_grid->mtdp->headerCellClass() ?>"><div><div id="elh_detailpayroll_mtdp" class="detailpayroll_mtdp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->mtdp->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->mtdp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->mtdp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_grid->netpay->Visible) { // netpay ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->netpay) == "") { ?>
		<th data-name="netpay" class="<?php echo $detailpayroll_grid->netpay->headerCellClass() ?>"><div id="elh_detailpayroll_netpay" class="detailpayroll_netpay"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->netpay->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="netpay" class="<?php echo $detailpayroll_grid->netpay->headerCellClass() ?>"><div><div id="elh_detailpayroll_netpay" class="detailpayroll_netpay">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->netpay->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->netpay->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->netpay->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($detailpayroll_grid->listpolicy->Visible) { // listpolicy ?>
	<?php if ($detailpayroll_grid->SortUrl($detailpayroll_grid->listpolicy) == "") { ?>
		<th data-name="listpolicy" class="<?php echo $detailpayroll_grid->listpolicy->headerCellClass() ?>"><div id="elh_detailpayroll_listpolicy" class="detailpayroll_listpolicy"><div class="ew-table-header-caption"><?php echo $detailpayroll_grid->listpolicy->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="listpolicy" class="<?php echo $detailpayroll_grid->listpolicy->headerCellClass() ?>"><div><div id="elh_detailpayroll_listpolicy" class="detailpayroll_listpolicy">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $detailpayroll_grid->listpolicy->caption() ?></span><span class="ew-table-header-sort"><?php if ($detailpayroll_grid->listpolicy->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($detailpayroll_grid->listpolicy->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$detailpayroll_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$detailpayroll_grid->StartRecord = 1;
$detailpayroll_grid->StopRecord = $detailpayroll_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($detailpayroll->isConfirm() || $detailpayroll_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($detailpayroll_grid->FormKeyCountName) && ($detailpayroll_grid->isGridAdd() || $detailpayroll_grid->isGridEdit() || $detailpayroll->isConfirm())) {
		$detailpayroll_grid->KeyCount = $CurrentForm->getValue($detailpayroll_grid->FormKeyCountName);
		$detailpayroll_grid->StopRecord = $detailpayroll_grid->StartRecord + $detailpayroll_grid->KeyCount - 1;
	}
}
$detailpayroll_grid->RecordCount = $detailpayroll_grid->StartRecord - 1;
if ($detailpayroll_grid->Recordset && !$detailpayroll_grid->Recordset->EOF) {
	$detailpayroll_grid->Recordset->moveFirst();
	$selectLimit = $detailpayroll_grid->UseSelectLimit;
	if (!$selectLimit && $detailpayroll_grid->StartRecord > 1)
		$detailpayroll_grid->Recordset->move($detailpayroll_grid->StartRecord - 1);
} elseif (!$detailpayroll->AllowAddDeleteRow && $detailpayroll_grid->StopRecord == 0) {
	$detailpayroll_grid->StopRecord = $detailpayroll->GridAddRowCount;
}

// Initialize aggregate
$detailpayroll->RowType = ROWTYPE_AGGREGATEINIT;
$detailpayroll->resetAttributes();
$detailpayroll_grid->renderRow();
if ($detailpayroll_grid->isGridAdd())
	$detailpayroll_grid->RowIndex = 0;
if ($detailpayroll_grid->isGridEdit())
	$detailpayroll_grid->RowIndex = 0;
while ($detailpayroll_grid->RecordCount < $detailpayroll_grid->StopRecord) {
	$detailpayroll_grid->RecordCount++;
	if ($detailpayroll_grid->RecordCount >= $detailpayroll_grid->StartRecord) {
		$detailpayroll_grid->RowCount++;
		if ($detailpayroll_grid->isGridAdd() || $detailpayroll_grid->isGridEdit() || $detailpayroll->isConfirm()) {
			$detailpayroll_grid->RowIndex++;
			$CurrentForm->Index = $detailpayroll_grid->RowIndex;
			if ($CurrentForm->hasValue($detailpayroll_grid->FormActionName) && ($detailpayroll->isConfirm() || $detailpayroll_grid->EventCancelled))
				$detailpayroll_grid->RowAction = strval($CurrentForm->getValue($detailpayroll_grid->FormActionName));
			elseif ($detailpayroll_grid->isGridAdd())
				$detailpayroll_grid->RowAction = "insert";
			else
				$detailpayroll_grid->RowAction = "";
		}

		// Set up key count
		$detailpayroll_grid->KeyCount = $detailpayroll_grid->RowIndex;

		// Init row class and style
		$detailpayroll->resetAttributes();
		$detailpayroll->CssClass = "";
		if ($detailpayroll_grid->isGridAdd()) {
			if ($detailpayroll->CurrentMode == "copy") {
				$detailpayroll_grid->loadRowValues($detailpayroll_grid->Recordset); // Load row values
				$detailpayroll_grid->setRecordKey($detailpayroll_grid->RowOldKey, $detailpayroll_grid->Recordset); // Set old record key
			} else {
				$detailpayroll_grid->loadRowValues(); // Load default values
				$detailpayroll_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$detailpayroll_grid->loadRowValues($detailpayroll_grid->Recordset); // Load row values
		}
		$detailpayroll->RowType = ROWTYPE_VIEW; // Render view
		if ($detailpayroll_grid->isGridAdd()) // Grid add
			$detailpayroll->RowType = ROWTYPE_ADD; // Render add
		if ($detailpayroll_grid->isGridAdd() && $detailpayroll->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$detailpayroll_grid->restoreCurrentRowFormValues($detailpayroll_grid->RowIndex); // Restore form values
		if ($detailpayroll_grid->isGridEdit()) { // Grid edit
			if ($detailpayroll->EventCancelled)
				$detailpayroll_grid->restoreCurrentRowFormValues($detailpayroll_grid->RowIndex); // Restore form values
			if ($detailpayroll_grid->RowAction == "insert")
				$detailpayroll->RowType = ROWTYPE_ADD; // Render add
			else
				$detailpayroll->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($detailpayroll_grid->isGridEdit() && ($detailpayroll->RowType == ROWTYPE_EDIT || $detailpayroll->RowType == ROWTYPE_ADD) && $detailpayroll->EventCancelled) // Update failed
			$detailpayroll_grid->restoreCurrentRowFormValues($detailpayroll_grid->RowIndex); // Restore form values
		if ($detailpayroll->RowType == ROWTYPE_EDIT) // Edit row
			$detailpayroll_grid->EditRowCount++;
		if ($detailpayroll->isConfirm()) // Confirm row
			$detailpayroll_grid->restoreCurrentRowFormValues($detailpayroll_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$detailpayroll->RowAttrs->merge(["data-rowindex" => $detailpayroll_grid->RowCount, "id" => "r" . $detailpayroll_grid->RowCount . "_detailpayroll", "data-rowtype" => $detailpayroll->RowType]);

		// Render row
		$detailpayroll_grid->renderRow();

		// Render list options
		$detailpayroll_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($detailpayroll_grid->RowAction != "delete" && $detailpayroll_grid->RowAction != "insertdelete" && !($detailpayroll_grid->RowAction == "insert" && $detailpayroll->isConfirm() && $detailpayroll_grid->emptyRow())) {
?>
	<tr <?php echo $detailpayroll->rowAttributes() ?>>
<?php

// Render list options (body, left)
$detailpayroll_grid->ListOptions->render("body", "left", $detailpayroll_grid->RowCount);
?>
	<?php if ($detailpayroll_grid->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll" <?php echo $detailpayroll_grid->idpayroll->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($detailpayroll_grid->idpayroll->getSessionValue() != "") { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idpayroll" class="form-group">
<span<?php echo $detailpayroll_grid->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idpayroll->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idpayroll" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idpayroll" data-value-separator="<?php echo $detailpayroll_grid->idpayroll->displayValueSeparatorAttribute() ?>" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll"<?php echo $detailpayroll_grid->idpayroll->editAttributes() ?>>
			<?php echo $detailpayroll_grid->idpayroll->selectOptionListHtml("x{$detailpayroll_grid->RowIndex}_idpayroll") ?>
		</select>
</div>
<?php echo $detailpayroll_grid->idpayroll->Lookup->getParamTag($detailpayroll_grid, "p_x" . $detailpayroll_grid->RowIndex . "_idpayroll") ?>
</span>
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($detailpayroll_grid->idpayroll->getSessionValue() != "") { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idpayroll" class="form-group">
<span<?php echo $detailpayroll_grid->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idpayroll->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idpayroll" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idpayroll" data-value-separator="<?php echo $detailpayroll_grid->idpayroll->displayValueSeparatorAttribute() ?>" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll"<?php echo $detailpayroll_grid->idpayroll->editAttributes() ?>>
			<?php echo $detailpayroll_grid->idpayroll->selectOptionListHtml("x{$detailpayroll_grid->RowIndex}_idpayroll") ?>
		</select>
</div>
<?php echo $detailpayroll_grid->idpayroll->Lookup->getParamTag($detailpayroll_grid, "p_x" . $detailpayroll_grid->RowIndex . "_idpayroll") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_grid->idpayroll->viewAttributes() ?>><?php echo $detailpayroll_grid->idpayroll->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<input type="hidden" data-table="detailpayroll" data-field="x_iddp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_iddp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($detailpayroll_grid->iddp->CurrentValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_iddp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_iddp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($detailpayroll_grid->iddp->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT || $detailpayroll->CurrentMode == "edit") { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_iddp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_iddp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_iddp" value="<?php echo HtmlEncode($detailpayroll_grid->iddp->CurrentValue) ?>">
<?php } ?>
	<?php if ($detailpayroll_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $detailpayroll_grid->idemp->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<?php if ($detailpayroll_grid->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idemp" class="form-group">
<span<?php echo $detailpayroll_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idemp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idemp" data-value-separator="<?php echo $detailpayroll_grid->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp"<?php echo $detailpayroll_grid->idemp->editAttributes() ?>>
			<?php echo $detailpayroll_grid->idemp->selectOptionListHtml("x{$detailpayroll_grid->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $detailpayroll_grid->idemp->Lookup->getParamTag($detailpayroll_grid, "p_x" . $detailpayroll_grid->RowIndex . "_idemp") ?>
</span>
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<?php if ($detailpayroll_grid->idemp->getSessionValue() != "") { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idemp" class="form-group">
<span<?php echo $detailpayroll_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idemp" class="form-group">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idemp" data-value-separator="<?php echo $detailpayroll_grid->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp"<?php echo $detailpayroll_grid->idemp->editAttributes() ?>>
			<?php echo $detailpayroll_grid->idemp->selectOptionListHtml("x{$detailpayroll_grid->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $detailpayroll_grid->idemp->Lookup->getParamTag($detailpayroll_grid, "p_x" . $detailpayroll_grid->RowIndex . "_idemp") ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_idemp">
<span<?php echo $detailpayroll_grid->idemp->viewAttributes() ?>><?php echo $detailpayroll_grid->idemp->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->salaryp->Visible) { // salaryp ?>
		<td data-name="salaryp" <?php echo $detailpayroll_grid->salaryp->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_salaryp" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_salaryp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->salaryp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->salaryp->EditValue ?>"<?php echo $detailpayroll_grid->salaryp->editAttributes() ?>>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_salaryp" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_salaryp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->salaryp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->salaryp->EditValue ?>"<?php echo $detailpayroll_grid->salaryp->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_salaryp">
<span<?php echo $detailpayroll_grid->salaryp->viewAttributes() ?>><?php echo $detailpayroll_grid->salaryp->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->mtap->Visible) { // mtap ?>
		<td data-name="mtap" <?php echo $detailpayroll_grid->mtap->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_mtap" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_mtap" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->mtap->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->mtap->EditValue ?>"<?php echo $detailpayroll_grid->mtap->editAttributes() ?>>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_mtap" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_mtap" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->mtap->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->mtap->EditValue ?>"<?php echo $detailpayroll_grid->mtap->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_mtap">
<span<?php echo $detailpayroll_grid->mtap->viewAttributes() ?>><?php echo $detailpayroll_grid->mtap->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->mtdp->Visible) { // mtdp ?>
		<td data-name="mtdp" <?php echo $detailpayroll_grid->mtdp->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_mtdp" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_mtdp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->mtdp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->mtdp->EditValue ?>"<?php echo $detailpayroll_grid->mtdp->editAttributes() ?>>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_mtdp" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_mtdp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->mtdp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->mtdp->EditValue ?>"<?php echo $detailpayroll_grid->mtdp->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_mtdp">
<span<?php echo $detailpayroll_grid->mtdp->viewAttributes() ?>><?php echo $detailpayroll_grid->mtdp->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->netpay->Visible) { // netpay ?>
		<td data-name="netpay" <?php echo $detailpayroll_grid->netpay->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_netpay" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_netpay" name="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" size="30" maxlength="17" placeholder="<?php echo HtmlEncode($detailpayroll_grid->netpay->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->netpay->EditValue ?>"<?php echo $detailpayroll_grid->netpay->editAttributes() ?>>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_netpay" class="form-group">
<input type="text" data-table="detailpayroll" data-field="x_netpay" name="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" size="30" maxlength="17" placeholder="<?php echo HtmlEncode($detailpayroll_grid->netpay->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->netpay->EditValue ?>"<?php echo $detailpayroll_grid->netpay->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_netpay">
<span<?php echo $detailpayroll_grid->netpay->viewAttributes() ?>><?php echo $detailpayroll_grid->netpay->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->listpolicy->Visible) { // listpolicy ?>
		<td data-name="listpolicy" <?php echo $detailpayroll_grid->listpolicy->cellAttributes() ?>>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_listpolicy" class="form-group">
<textarea data-table="detailpayroll" data-field="x_listpolicy" name="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" cols="35" rows="4" placeholder="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->getPlaceHolder()) ?>"<?php echo $detailpayroll_grid->listpolicy->editAttributes() ?>><?php echo $detailpayroll_grid->listpolicy->EditValue ?></textarea>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->OldValue) ?>">
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_listpolicy" class="form-group">
<textarea data-table="detailpayroll" data-field="x_listpolicy" name="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" cols="35" rows="4" placeholder="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->getPlaceHolder()) ?>"<?php echo $detailpayroll_grid->listpolicy->editAttributes() ?>><?php echo $detailpayroll_grid->listpolicy->EditValue ?></textarea>
</span>
<?php } ?>
<?php if ($detailpayroll->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $detailpayroll_grid->RowCount ?>_detailpayroll_listpolicy">
<span<?php echo $detailpayroll_grid->listpolicy->viewAttributes() ?>><?php echo $detailpayroll_grid->listpolicy->getViewValue() ?></span>
</span>
<?php if (!$detailpayroll->isConfirm()) { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="fdetailpayrollgrid$x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->FormValue) ?>">
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="fdetailpayrollgrid$o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$detailpayroll_grid->ListOptions->render("body", "right", $detailpayroll_grid->RowCount);
?>
	</tr>
<?php if ($detailpayroll->RowType == ROWTYPE_ADD || $detailpayroll->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fdetailpayrollgrid", "load"], function() {
	fdetailpayrollgrid.updateLists(<?php echo $detailpayroll_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$detailpayroll_grid->isGridAdd() || $detailpayroll->CurrentMode == "copy")
		if (!$detailpayroll_grid->Recordset->EOF)
			$detailpayroll_grid->Recordset->moveNext();
}
?>
<?php
	if ($detailpayroll->CurrentMode == "add" || $detailpayroll->CurrentMode == "copy" || $detailpayroll->CurrentMode == "edit") {
		$detailpayroll_grid->RowIndex = '$rowindex$';
		$detailpayroll_grid->loadRowValues();

		// Set row properties
		$detailpayroll->resetAttributes();
		$detailpayroll->RowAttrs->merge(["data-rowindex" => $detailpayroll_grid->RowIndex, "id" => "r0_detailpayroll", "data-rowtype" => ROWTYPE_ADD]);
		$detailpayroll->RowAttrs->appendClass("ew-template");
		$detailpayroll->RowType = ROWTYPE_ADD;

		// Render row
		$detailpayroll_grid->renderRow();

		// Render list options
		$detailpayroll_grid->renderListOptions();
		$detailpayroll_grid->StartRowCount = 0;
?>
	<tr <?php echo $detailpayroll->rowAttributes() ?>>
<?php

// Render list options (body, left)
$detailpayroll_grid->ListOptions->render("body", "left", $detailpayroll_grid->RowIndex);
?>
	<?php if ($detailpayroll_grid->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll">
<?php if (!$detailpayroll->isConfirm()) { ?>
<?php if ($detailpayroll_grid->idpayroll->getSessionValue() != "") { ?>
<span id="el$rowindex$_detailpayroll_idpayroll" class="form-group detailpayroll_idpayroll">
<span<?php echo $detailpayroll_grid->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idpayroll->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_idpayroll" class="form-group detailpayroll_idpayroll">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idpayroll" data-value-separator="<?php echo $detailpayroll_grid->idpayroll->displayValueSeparatorAttribute() ?>" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll"<?php echo $detailpayroll_grid->idpayroll->editAttributes() ?>>
			<?php echo $detailpayroll_grid->idpayroll->selectOptionListHtml("x{$detailpayroll_grid->RowIndex}_idpayroll") ?>
		</select>
</div>
<?php echo $detailpayroll_grid->idpayroll->Lookup->getParamTag($detailpayroll_grid, "p_x" . $detailpayroll_grid->RowIndex . "_idpayroll") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_idpayroll" class="form-group detailpayroll_idpayroll">
<span<?php echo $detailpayroll_grid->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idpayroll->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idpayroll" name="o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" id="o<?php echo $detailpayroll_grid->RowIndex ?>_idpayroll" value="<?php echo HtmlEncode($detailpayroll_grid->idpayroll->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if (!$detailpayroll->isConfirm()) { ?>
<?php if ($detailpayroll_grid->idemp->getSessionValue() != "") { ?>
<span id="el$rowindex$_detailpayroll_idemp" class="form-group detailpayroll_idemp">
<span<?php echo $detailpayroll_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_idemp" class="form-group detailpayroll_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idemp" data-value-separator="<?php echo $detailpayroll_grid->idemp->displayValueSeparatorAttribute() ?>" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp"<?php echo $detailpayroll_grid->idemp->editAttributes() ?>>
			<?php echo $detailpayroll_grid->idemp->selectOptionListHtml("x{$detailpayroll_grid->RowIndex}_idemp") ?>
		</select>
</div>
<?php echo $detailpayroll_grid->idemp->Lookup->getParamTag($detailpayroll_grid, "p_x" . $detailpayroll_grid->RowIndex . "_idemp") ?>
</span>
<?php } ?>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_idemp" class="form-group detailpayroll_idemp">
<span<?php echo $detailpayroll_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_idemp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($detailpayroll_grid->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->salaryp->Visible) { // salaryp ?>
		<td data-name="salaryp">
<?php if (!$detailpayroll->isConfirm()) { ?>
<span id="el$rowindex$_detailpayroll_salaryp" class="form-group detailpayroll_salaryp">
<input type="text" data-table="detailpayroll" data-field="x_salaryp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->salaryp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->salaryp->EditValue ?>"<?php echo $detailpayroll_grid->salaryp->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_salaryp" class="form-group detailpayroll_salaryp">
<span<?php echo $detailpayroll_grid->salaryp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->salaryp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_salaryp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_salaryp" value="<?php echo HtmlEncode($detailpayroll_grid->salaryp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->mtap->Visible) { // mtap ?>
		<td data-name="mtap">
<?php if (!$detailpayroll->isConfirm()) { ?>
<span id="el$rowindex$_detailpayroll_mtap" class="form-group detailpayroll_mtap">
<input type="text" data-table="detailpayroll" data-field="x_mtap" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->mtap->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->mtap->EditValue ?>"<?php echo $detailpayroll_grid->mtap->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_mtap" class="form-group detailpayroll_mtap">
<span<?php echo $detailpayroll_grid->mtap->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->mtap->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_mtap" name="o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" id="o<?php echo $detailpayroll_grid->RowIndex ?>_mtap" value="<?php echo HtmlEncode($detailpayroll_grid->mtap->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->mtdp->Visible) { // mtdp ?>
		<td data-name="mtdp">
<?php if (!$detailpayroll->isConfirm()) { ?>
<span id="el$rowindex$_detailpayroll_mtdp" class="form-group detailpayroll_mtdp">
<input type="text" data-table="detailpayroll" data-field="x_mtdp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_grid->mtdp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->mtdp->EditValue ?>"<?php echo $detailpayroll_grid->mtdp->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_mtdp" class="form-group detailpayroll_mtdp">
<span<?php echo $detailpayroll_grid->mtdp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->mtdp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="x<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_mtdp" name="o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" id="o<?php echo $detailpayroll_grid->RowIndex ?>_mtdp" value="<?php echo HtmlEncode($detailpayroll_grid->mtdp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->netpay->Visible) { // netpay ?>
		<td data-name="netpay">
<?php if (!$detailpayroll->isConfirm()) { ?>
<span id="el$rowindex$_detailpayroll_netpay" class="form-group detailpayroll_netpay">
<input type="text" data-table="detailpayroll" data-field="x_netpay" name="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" size="30" maxlength="17" placeholder="<?php echo HtmlEncode($detailpayroll_grid->netpay->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_grid->netpay->EditValue ?>"<?php echo $detailpayroll_grid->netpay->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_netpay" class="form-group detailpayroll_netpay">
<span<?php echo $detailpayroll_grid->netpay->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_grid->netpay->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="x<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_netpay" name="o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" id="o<?php echo $detailpayroll_grid->RowIndex ?>_netpay" value="<?php echo HtmlEncode($detailpayroll_grid->netpay->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($detailpayroll_grid->listpolicy->Visible) { // listpolicy ?>
		<td data-name="listpolicy">
<?php if (!$detailpayroll->isConfirm()) { ?>
<span id="el$rowindex$_detailpayroll_listpolicy" class="form-group detailpayroll_listpolicy">
<textarea data-table="detailpayroll" data-field="x_listpolicy" name="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" cols="35" rows="4" placeholder="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->getPlaceHolder()) ?>"<?php echo $detailpayroll_grid->listpolicy->editAttributes() ?>><?php echo $detailpayroll_grid->listpolicy->EditValue ?></textarea>
</span>
<?php } else { ?>
<span id="el$rowindex$_detailpayroll_listpolicy" class="form-group detailpayroll_listpolicy">
<span<?php echo $detailpayroll_grid->listpolicy->viewAttributes() ?>><?php echo $detailpayroll_grid->listpolicy->ViewValue ?></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="x<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="detailpayroll" data-field="x_listpolicy" name="o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" id="o<?php echo $detailpayroll_grid->RowIndex ?>_listpolicy" value="<?php echo HtmlEncode($detailpayroll_grid->listpolicy->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$detailpayroll_grid->ListOptions->render("body", "right", $detailpayroll_grid->RowIndex);
?>
<script>
loadjs.ready(["fdetailpayrollgrid", "load"], function() {
	fdetailpayrollgrid.updateLists(<?php echo $detailpayroll_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
<?php

// Render aggregate row
$detailpayroll->RowType = ROWTYPE_AGGREGATE;
$detailpayroll->resetAttributes();
$detailpayroll_grid->renderRow();
?>
<?php if ($detailpayroll_grid->TotalRecords > 0 && $detailpayroll->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$detailpayroll_grid->renderListOptions();

// Render list options (footer, left)
$detailpayroll_grid->ListOptions->render("footer", "left");
?>
	<?php if ($detailpayroll_grid->idpayroll->Visible) { // idpayroll ?>
		<td data-name="idpayroll" class="<?php echo $detailpayroll_grid->idpayroll->footerCellClass() ?>"><span id="elf_detailpayroll_idpayroll" class="detailpayroll_idpayroll">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_grid->idpayroll->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" class="<?php echo $detailpayroll_grid->idemp->footerCellClass() ?>"><span id="elf_detailpayroll_idemp" class="detailpayroll_idemp">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_grid->idemp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_grid->salaryp->Visible) { // salaryp ?>
		<td data-name="salaryp" class="<?php echo $detailpayroll_grid->salaryp->footerCellClass() ?>"><span id="elf_detailpayroll_salaryp" class="detailpayroll_salaryp">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_grid->salaryp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_grid->mtap->Visible) { // mtap ?>
		<td data-name="mtap" class="<?php echo $detailpayroll_grid->mtap->footerCellClass() ?>"><span id="elf_detailpayroll_mtap" class="detailpayroll_mtap">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_grid->mtap->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_grid->mtdp->Visible) { // mtdp ?>
		<td data-name="mtdp" class="<?php echo $detailpayroll_grid->mtdp->footerCellClass() ?>"><span id="elf_detailpayroll_mtdp" class="detailpayroll_mtdp">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_grid->mtdp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_grid->netpay->Visible) { // netpay ?>
		<td data-name="netpay" class="<?php echo $detailpayroll_grid->netpay->footerCellClass() ?>"><span id="elf_detailpayroll_netpay" class="detailpayroll_netpay">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $detailpayroll_grid->netpay->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($detailpayroll_grid->listpolicy->Visible) { // listpolicy ?>
		<td data-name="listpolicy" class="<?php echo $detailpayroll_grid->listpolicy->footerCellClass() ?>"><span id="elf_detailpayroll_listpolicy" class="detailpayroll_listpolicy">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$detailpayroll_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($detailpayroll->CurrentMode == "add" || $detailpayroll->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $detailpayroll_grid->FormKeyCountName ?>" id="<?php echo $detailpayroll_grid->FormKeyCountName ?>" value="<?php echo $detailpayroll_grid->KeyCount ?>">
<?php echo $detailpayroll_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($detailpayroll->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $detailpayroll_grid->FormKeyCountName ?>" id="<?php echo $detailpayroll_grid->FormKeyCountName ?>" value="<?php echo $detailpayroll_grid->KeyCount ?>">
<?php echo $detailpayroll_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($detailpayroll->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fdetailpayrollgrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($detailpayroll_grid->Recordset)
	$detailpayroll_grid->Recordset->Close();
?>
<?php if ($detailpayroll_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $detailpayroll_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($detailpayroll_grid->TotalRecords == 0 && !$detailpayroll->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $detailpayroll_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$detailpayroll_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php
$detailpayroll_grid->terminate();
?>