<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_edit = new detailpayroll_edit();

// Run the page
$detailpayroll_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdetailpayrolledit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fdetailpayrolledit = currentForm = new ew.Form("fdetailpayrolledit", "edit");

	// Validate form
	fdetailpayrolledit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($detailpayroll_edit->iddp->Required) { ?>
				elm = this.getElements("x" + infix + "_iddp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->iddp->caption(), $detailpayroll_edit->iddp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_edit->idpayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->idpayroll->caption(), $detailpayroll_edit->idpayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->idemp->caption(), $detailpayroll_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_edit->salaryp->Required) { ?>
				elm = this.getElements("x" + infix + "_salaryp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_edit->salaryp->caption(), $detailpayroll_edit->salaryp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_salaryp");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_edit->salaryp->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdetailpayrolledit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdetailpayrolledit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdetailpayrolledit.lists["x_idpayroll"] = <?php echo $detailpayroll_edit->idpayroll->Lookup->toClientList($detailpayroll_edit) ?>;
	fdetailpayrolledit.lists["x_idpayroll"].options = <?php echo JsonEncode($detailpayroll_edit->idpayroll->lookupOptions()) ?>;
	fdetailpayrolledit.lists["x_idemp"] = <?php echo $detailpayroll_edit->idemp->Lookup->toClientList($detailpayroll_edit) ?>;
	fdetailpayrolledit.lists["x_idemp"].options = <?php echo JsonEncode($detailpayroll_edit->idemp->lookupOptions()) ?>;
	loadjs.done("fdetailpayrolledit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $detailpayroll_edit->showPageHeader(); ?>
<?php
$detailpayroll_edit->showMessage();
?>
<form name="fdetailpayrolledit" id="fdetailpayrolledit" class="<?php echo $detailpayroll_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$detailpayroll_edit->IsModal ?>">
<?php if ($detailpayroll->getCurrentMasterTable() == "payroll") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="payroll">
<input type="hidden" name="fk_idpayroll" value="<?php echo HtmlEncode($detailpayroll_edit->idpayroll->getSessionValue()) ?>">
<?php } ?>
<?php if ($detailpayroll->getCurrentMasterTable() == "employee") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employee">
<input type="hidden" name="fk_idemp" value="<?php echo HtmlEncode($detailpayroll_edit->idemp->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($detailpayroll_edit->iddp->Visible) { // iddp ?>
	<div id="r_iddp" class="form-group row">
		<label id="elh_detailpayroll_iddp" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->iddp->caption() ?><?php echo $detailpayroll_edit->iddp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->iddp->cellAttributes() ?>>
<span id="el_detailpayroll_iddp">
<span<?php echo $detailpayroll_edit->iddp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_edit->iddp->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="detailpayroll" data-field="x_iddp" name="x_iddp" id="x_iddp" value="<?php echo HtmlEncode($detailpayroll_edit->iddp->CurrentValue) ?>">
<?php echo $detailpayroll_edit->iddp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_edit->idpayroll->Visible) { // idpayroll ?>
	<div id="r_idpayroll" class="form-group row">
		<label id="elh_detailpayroll_idpayroll" for="x_idpayroll" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->idpayroll->caption() ?><?php echo $detailpayroll_edit->idpayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->idpayroll->cellAttributes() ?>>
<?php if ($detailpayroll_edit->idpayroll->getSessionValue() != "") { ?>
<span id="el_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_edit->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_edit->idpayroll->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idpayroll" name="x_idpayroll" value="<?php echo HtmlEncode($detailpayroll_edit->idpayroll->CurrentValue) ?>">
<?php } else { ?>
<span id="el_detailpayroll_idpayroll">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idpayroll" data-value-separator="<?php echo $detailpayroll_edit->idpayroll->displayValueSeparatorAttribute() ?>" id="x_idpayroll" name="x_idpayroll"<?php echo $detailpayroll_edit->idpayroll->editAttributes() ?>>
			<?php echo $detailpayroll_edit->idpayroll->selectOptionListHtml("x_idpayroll") ?>
		</select>
</div>
<?php echo $detailpayroll_edit->idpayroll->Lookup->getParamTag($detailpayroll_edit, "p_x_idpayroll") ?>
</span>
<?php } ?>
<?php echo $detailpayroll_edit->idpayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_detailpayroll_idemp" for="x_idemp" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->idemp->caption() ?><?php echo $detailpayroll_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->idemp->cellAttributes() ?>>
<?php if ($detailpayroll_edit->idemp->getSessionValue() != "") { ?>
<span id="el_detailpayroll_idemp">
<span<?php echo $detailpayroll_edit->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_edit->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idemp" name="x_idemp" value="<?php echo HtmlEncode($detailpayroll_edit->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_detailpayroll_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idemp" data-value-separator="<?php echo $detailpayroll_edit->idemp->displayValueSeparatorAttribute() ?>" id="x_idemp" name="x_idemp"<?php echo $detailpayroll_edit->idemp->editAttributes() ?>>
			<?php echo $detailpayroll_edit->idemp->selectOptionListHtml("x_idemp") ?>
		</select>
</div>
<?php echo $detailpayroll_edit->idemp->Lookup->getParamTag($detailpayroll_edit, "p_x_idemp") ?>
</span>
<?php } ?>
<?php echo $detailpayroll_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_edit->salaryp->Visible) { // salaryp ?>
	<div id="r_salaryp" class="form-group row">
		<label id="elh_detailpayroll_salaryp" for="x_salaryp" class="<?php echo $detailpayroll_edit->LeftColumnClass ?>"><?php echo $detailpayroll_edit->salaryp->caption() ?><?php echo $detailpayroll_edit->salaryp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_edit->RightColumnClass ?>"><div <?php echo $detailpayroll_edit->salaryp->cellAttributes() ?>>
<span id="el_detailpayroll_salaryp">
<input type="text" data-table="detailpayroll" data-field="x_salaryp" name="x_salaryp" id="x_salaryp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_edit->salaryp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_edit->salaryp->EditValue ?>"<?php echo $detailpayroll_edit->salaryp->editAttributes() ?>>
</span>
<?php echo $detailpayroll_edit->salaryp->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("policydp", explode(",", $detailpayroll->getCurrentDetailTable())) && $policydp->DetailEdit) {
?>
<?php if ($detailpayroll->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("policydp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "policydpgrid.php" ?>
<?php } ?>
<?php if (!$detailpayroll_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $detailpayroll_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $detailpayroll_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$detailpayroll_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_edit->terminate();
?>