<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$detailpayroll_add = new detailpayroll_add();

// Run the page
$detailpayroll_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$detailpayroll_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdetailpayrolladd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fdetailpayrolladd = currentForm = new ew.Form("fdetailpayrolladd", "add");

	// Validate form
	fdetailpayrolladd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($detailpayroll_add->idpayroll->Required) { ?>
				elm = this.getElements("x" + infix + "_idpayroll");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->idpayroll->caption(), $detailpayroll_add->idpayroll->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_add->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->idemp->caption(), $detailpayroll_add->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($detailpayroll_add->salaryp->Required) { ?>
				elm = this.getElements("x" + infix + "_salaryp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $detailpayroll_add->salaryp->caption(), $detailpayroll_add->salaryp->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_salaryp");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($detailpayroll_add->salaryp->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdetailpayrolladd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdetailpayrolladd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdetailpayrolladd.lists["x_idpayroll"] = <?php echo $detailpayroll_add->idpayroll->Lookup->toClientList($detailpayroll_add) ?>;
	fdetailpayrolladd.lists["x_idpayroll"].options = <?php echo JsonEncode($detailpayroll_add->idpayroll->lookupOptions()) ?>;
	fdetailpayrolladd.lists["x_idemp"] = <?php echo $detailpayroll_add->idemp->Lookup->toClientList($detailpayroll_add) ?>;
	fdetailpayrolladd.lists["x_idemp"].options = <?php echo JsonEncode($detailpayroll_add->idemp->lookupOptions()) ?>;
	loadjs.done("fdetailpayrolladd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $detailpayroll_add->showPageHeader(); ?>
<?php
$detailpayroll_add->showMessage();
?>
<form name="fdetailpayrolladd" id="fdetailpayrolladd" class="<?php echo $detailpayroll_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="detailpayroll">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$detailpayroll_add->IsModal ?>">
<?php if ($detailpayroll->getCurrentMasterTable() == "payroll") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="payroll">
<input type="hidden" name="fk_idpayroll" value="<?php echo HtmlEncode($detailpayroll_add->idpayroll->getSessionValue()) ?>">
<?php } ?>
<?php if ($detailpayroll->getCurrentMasterTable() == "employee") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="employee">
<input type="hidden" name="fk_idemp" value="<?php echo HtmlEncode($detailpayroll_add->idemp->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($detailpayroll_add->idpayroll->Visible) { // idpayroll ?>
	<div id="r_idpayroll" class="form-group row">
		<label id="elh_detailpayroll_idpayroll" for="x_idpayroll" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->idpayroll->caption() ?><?php echo $detailpayroll_add->idpayroll->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->idpayroll->cellAttributes() ?>>
<?php if ($detailpayroll_add->idpayroll->getSessionValue() != "") { ?>
<span id="el_detailpayroll_idpayroll">
<span<?php echo $detailpayroll_add->idpayroll->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_add->idpayroll->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idpayroll" name="x_idpayroll" value="<?php echo HtmlEncode($detailpayroll_add->idpayroll->CurrentValue) ?>">
<?php } else { ?>
<span id="el_detailpayroll_idpayroll">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idpayroll" data-value-separator="<?php echo $detailpayroll_add->idpayroll->displayValueSeparatorAttribute() ?>" id="x_idpayroll" name="x_idpayroll"<?php echo $detailpayroll_add->idpayroll->editAttributes() ?>>
			<?php echo $detailpayroll_add->idpayroll->selectOptionListHtml("x_idpayroll") ?>
		</select>
</div>
<?php echo $detailpayroll_add->idpayroll->Lookup->getParamTag($detailpayroll_add, "p_x_idpayroll") ?>
</span>
<?php } ?>
<?php echo $detailpayroll_add->idpayroll->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_add->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_detailpayroll_idemp" for="x_idemp" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->idemp->caption() ?><?php echo $detailpayroll_add->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->idemp->cellAttributes() ?>>
<?php if ($detailpayroll_add->idemp->getSessionValue() != "") { ?>
<span id="el_detailpayroll_idemp">
<span<?php echo $detailpayroll_add->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($detailpayroll_add->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" id="x_idemp" name="x_idemp" value="<?php echo HtmlEncode($detailpayroll_add->idemp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_detailpayroll_idemp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="detailpayroll" data-field="x_idemp" data-value-separator="<?php echo $detailpayroll_add->idemp->displayValueSeparatorAttribute() ?>" id="x_idemp" name="x_idemp"<?php echo $detailpayroll_add->idemp->editAttributes() ?>>
			<?php echo $detailpayroll_add->idemp->selectOptionListHtml("x_idemp") ?>
		</select>
</div>
<?php echo $detailpayroll_add->idemp->Lookup->getParamTag($detailpayroll_add, "p_x_idemp") ?>
</span>
<?php } ?>
<?php echo $detailpayroll_add->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($detailpayroll_add->salaryp->Visible) { // salaryp ?>
	<div id="r_salaryp" class="form-group row">
		<label id="elh_detailpayroll_salaryp" for="x_salaryp" class="<?php echo $detailpayroll_add->LeftColumnClass ?>"><?php echo $detailpayroll_add->salaryp->caption() ?><?php echo $detailpayroll_add->salaryp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $detailpayroll_add->RightColumnClass ?>"><div <?php echo $detailpayroll_add->salaryp->cellAttributes() ?>>
<span id="el_detailpayroll_salaryp">
<input type="text" data-table="detailpayroll" data-field="x_salaryp" name="x_salaryp" id="x_salaryp" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($detailpayroll_add->salaryp->getPlaceHolder()) ?>" value="<?php echo $detailpayroll_add->salaryp->EditValue ?>"<?php echo $detailpayroll_add->salaryp->editAttributes() ?>>
</span>
<?php echo $detailpayroll_add->salaryp->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php
	if (in_array("policydp", explode(",", $detailpayroll->getCurrentDetailTable())) && $policydp->DetailAdd) {
?>
<?php if ($detailpayroll->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->tablePhrase("policydp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "policydpgrid.php" ?>
<?php } ?>
<?php if (!$detailpayroll_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $detailpayroll_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $detailpayroll_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$detailpayroll_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$detailpayroll_add->terminate();
?>