<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$designation_view = new designation_view();

// Run the page
$designation_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$designation_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$designation_view->isExport()) { ?>
<script>
var fdesignationview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdesignationview = currentForm = new ew.Form("fdesignationview", "view");
	loadjs.done("fdesignationview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$designation_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $designation_view->ExportOptions->render("body") ?>
<?php $designation_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $designation_view->showPageHeader(); ?>
<?php
$designation_view->showMessage();
?>
<?php if (!$designation_view->IsModal) { ?>
<?php if (!$designation_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $designation_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fdesignationview" id="fdesignationview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="designation">
<input type="hidden" name="modal" value="<?php echo (int)$designation_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($designation_view->iddesig->Visible) { // iddesig ?>
	<tr id="r_iddesig">
		<td class="<?php echo $designation_view->TableLeftColumnClass ?>"><span id="elh_designation_iddesig"><?php echo $designation_view->iddesig->caption() ?></span></td>
		<td data-name="iddesig" <?php echo $designation_view->iddesig->cellAttributes() ?>>
<span id="el_designation_iddesig">
<span<?php echo $designation_view->iddesig->viewAttributes() ?>><?php echo $designation_view->iddesig->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($designation_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $designation_view->TableLeftColumnClass ?>"><span id="elh_designation_ident"><?php echo $designation_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $designation_view->ident->cellAttributes() ?>>
<span id="el_designation_ident">
<span<?php echo $designation_view->ident->viewAttributes() ?>><?php echo $designation_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($designation_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $designation_view->TableLeftColumnClass ?>"><span id="elh_designation_descrip"><?php echo $designation_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $designation_view->descrip->cellAttributes() ?>>
<span id="el_designation_descrip">
<span<?php echo $designation_view->descrip->viewAttributes() ?>><?php echo $designation_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$designation_view->IsModal) { ?>
<?php if (!$designation_view->isExport()) { ?>
<?php echo $designation_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$designation_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$designation_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$designation_view->terminate();
?>