<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$designation_list = new designation_list();

// Run the page
$designation_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$designation_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$designation_list->isExport()) { ?>
<script>
var fdesignationlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fdesignationlist = currentForm = new ew.Form("fdesignationlist", "list");
	fdesignationlist.formKeyCountName = '<?php echo $designation_list->FormKeyCountName ?>';
	loadjs.done("fdesignationlist");
});
var fdesignationlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fdesignationlistsrch = currentSearchForm = new ew.Form("fdesignationlistsrch");

	// Dynamic selection lists
	// Filters

	fdesignationlistsrch.filterList = <?php echo $designation_list->getFilterList() ?>;
	loadjs.done("fdesignationlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$designation_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($designation_list->TotalRecords > 0 && $designation_list->ExportOptions->visible()) { ?>
<?php $designation_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($designation_list->ImportOptions->visible()) { ?>
<?php $designation_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($designation_list->SearchOptions->visible()) { ?>
<?php $designation_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($designation_list->FilterOptions->visible()) { ?>
<?php $designation_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$designation_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$designation_list->isExport() && !$designation->CurrentAction) { ?>
<form name="fdesignationlistsrch" id="fdesignationlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fdesignationlistsrch-search-panel" class="<?php echo $designation_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="designation">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $designation_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($designation_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($designation_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $designation_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($designation_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($designation_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($designation_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($designation_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $designation_list->showPageHeader(); ?>
<?php
$designation_list->showMessage();
?>
<?php if ($designation_list->TotalRecords > 0 || $designation->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($designation_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> designation">
<?php if (!$designation_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$designation_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $designation_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $designation_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdesignationlist" id="fdesignationlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="designation">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_designation" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($designation_list->TotalRecords > 0 || $designation_list->isGridEdit()) { ?>
<table id="tbl_designationlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$designation->RowType = ROWTYPE_HEADER;

// Render list options
$designation_list->renderListOptions();

// Render list options (header, left)
$designation_list->ListOptions->render("header", "left");
?>
<?php if ($designation_list->iddesig->Visible) { // iddesig ?>
	<?php if ($designation_list->SortUrl($designation_list->iddesig) == "") { ?>
		<th data-name="iddesig" class="<?php echo $designation_list->iddesig->headerCellClass() ?>"><div id="elh_designation_iddesig" class="designation_iddesig"><div class="ew-table-header-caption"><?php echo $designation_list->iddesig->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddesig" class="<?php echo $designation_list->iddesig->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $designation_list->SortUrl($designation_list->iddesig) ?>', 1);"><div id="elh_designation_iddesig" class="designation_iddesig">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $designation_list->iddesig->caption() ?></span><span class="ew-table-header-sort"><?php if ($designation_list->iddesig->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($designation_list->iddesig->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($designation_list->ident->Visible) { // ident ?>
	<?php if ($designation_list->SortUrl($designation_list->ident) == "") { ?>
		<th data-name="ident" class="<?php echo $designation_list->ident->headerCellClass() ?>"><div id="elh_designation_ident" class="designation_ident"><div class="ew-table-header-caption"><?php echo $designation_list->ident->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ident" class="<?php echo $designation_list->ident->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $designation_list->SortUrl($designation_list->ident) ?>', 1);"><div id="elh_designation_ident" class="designation_ident">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $designation_list->ident->caption() ?></span><span class="ew-table-header-sort"><?php if ($designation_list->ident->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($designation_list->ident->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($designation_list->descrip->Visible) { // descrip ?>
	<?php if ($designation_list->SortUrl($designation_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $designation_list->descrip->headerCellClass() ?>"><div id="elh_designation_descrip" class="designation_descrip"><div class="ew-table-header-caption"><?php echo $designation_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $designation_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $designation_list->SortUrl($designation_list->descrip) ?>', 1);"><div id="elh_designation_descrip" class="designation_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $designation_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($designation_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($designation_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$designation_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($designation_list->ExportAll && $designation_list->isExport()) {
	$designation_list->StopRecord = $designation_list->TotalRecords;
} else {

	// Set the last record to display
	if ($designation_list->TotalRecords > $designation_list->StartRecord + $designation_list->DisplayRecords - 1)
		$designation_list->StopRecord = $designation_list->StartRecord + $designation_list->DisplayRecords - 1;
	else
		$designation_list->StopRecord = $designation_list->TotalRecords;
}
$designation_list->RecordCount = $designation_list->StartRecord - 1;
if ($designation_list->Recordset && !$designation_list->Recordset->EOF) {
	$designation_list->Recordset->moveFirst();
	$selectLimit = $designation_list->UseSelectLimit;
	if (!$selectLimit && $designation_list->StartRecord > 1)
		$designation_list->Recordset->move($designation_list->StartRecord - 1);
} elseif (!$designation->AllowAddDeleteRow && $designation_list->StopRecord == 0) {
	$designation_list->StopRecord = $designation->GridAddRowCount;
}

// Initialize aggregate
$designation->RowType = ROWTYPE_AGGREGATEINIT;
$designation->resetAttributes();
$designation_list->renderRow();
while ($designation_list->RecordCount < $designation_list->StopRecord) {
	$designation_list->RecordCount++;
	if ($designation_list->RecordCount >= $designation_list->StartRecord) {
		$designation_list->RowCount++;

		// Set up key count
		$designation_list->KeyCount = $designation_list->RowIndex;

		// Init row class and style
		$designation->resetAttributes();
		$designation->CssClass = "";
		if ($designation_list->isGridAdd()) {
		} else {
			$designation_list->loadRowValues($designation_list->Recordset); // Load row values
		}
		$designation->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$designation->RowAttrs->merge(["data-rowindex" => $designation_list->RowCount, "id" => "r" . $designation_list->RowCount . "_designation", "data-rowtype" => $designation->RowType]);

		// Render row
		$designation_list->renderRow();

		// Render list options
		$designation_list->renderListOptions();
?>
	<tr <?php echo $designation->rowAttributes() ?>>
<?php

// Render list options (body, left)
$designation_list->ListOptions->render("body", "left", $designation_list->RowCount);
?>
	<?php if ($designation_list->iddesig->Visible) { // iddesig ?>
		<td data-name="iddesig" <?php echo $designation_list->iddesig->cellAttributes() ?>>
<span id="el<?php echo $designation_list->RowCount ?>_designation_iddesig">
<span<?php echo $designation_list->iddesig->viewAttributes() ?>><?php echo $designation_list->iddesig->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($designation_list->ident->Visible) { // ident ?>
		<td data-name="ident" <?php echo $designation_list->ident->cellAttributes() ?>>
<span id="el<?php echo $designation_list->RowCount ?>_designation_ident">
<span<?php echo $designation_list->ident->viewAttributes() ?>><?php echo $designation_list->ident->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($designation_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $designation_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $designation_list->RowCount ?>_designation_descrip">
<span<?php echo $designation_list->descrip->viewAttributes() ?>><?php echo $designation_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$designation_list->ListOptions->render("body", "right", $designation_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$designation_list->isGridAdd())
		$designation_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$designation->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($designation_list->Recordset)
	$designation_list->Recordset->Close();
?>
<?php if (!$designation_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$designation_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $designation_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $designation_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($designation_list->TotalRecords == 0 && !$designation->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $designation_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$designation_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$designation_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$designation_list->terminate();
?>