<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$designation_delete = new designation_delete();

// Run the page
$designation_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$designation_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdesignationdelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fdesignationdelete = currentForm = new ew.Form("fdesignationdelete", "delete");
	loadjs.done("fdesignationdelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $designation_delete->showPageHeader(); ?>
<?php
$designation_delete->showMessage();
?>
<form name="fdesignationdelete" id="fdesignationdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="designation">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($designation_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($designation_delete->iddesig->Visible) { // iddesig ?>
		<th class="<?php echo $designation_delete->iddesig->headerCellClass() ?>"><span id="elh_designation_iddesig" class="designation_iddesig"><?php echo $designation_delete->iddesig->caption() ?></span></th>
<?php } ?>
<?php if ($designation_delete->ident->Visible) { // ident ?>
		<th class="<?php echo $designation_delete->ident->headerCellClass() ?>"><span id="elh_designation_ident" class="designation_ident"><?php echo $designation_delete->ident->caption() ?></span></th>
<?php } ?>
<?php if ($designation_delete->descrip->Visible) { // descrip ?>
		<th class="<?php echo $designation_delete->descrip->headerCellClass() ?>"><span id="elh_designation_descrip" class="designation_descrip"><?php echo $designation_delete->descrip->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$designation_delete->RecordCount = 0;
$i = 0;
while (!$designation_delete->Recordset->EOF) {
	$designation_delete->RecordCount++;
	$designation_delete->RowCount++;

	// Set row properties
	$designation->resetAttributes();
	$designation->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$designation_delete->loadRowValues($designation_delete->Recordset);

	// Render row
	$designation_delete->renderRow();
?>
	<tr <?php echo $designation->rowAttributes() ?>>
<?php if ($designation_delete->iddesig->Visible) { // iddesig ?>
		<td <?php echo $designation_delete->iddesig->cellAttributes() ?>>
<span id="el<?php echo $designation_delete->RowCount ?>_designation_iddesig" class="designation_iddesig">
<span<?php echo $designation_delete->iddesig->viewAttributes() ?>><?php echo $designation_delete->iddesig->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($designation_delete->ident->Visible) { // ident ?>
		<td <?php echo $designation_delete->ident->cellAttributes() ?>>
<span id="el<?php echo $designation_delete->RowCount ?>_designation_ident" class="designation_ident">
<span<?php echo $designation_delete->ident->viewAttributes() ?>><?php echo $designation_delete->ident->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($designation_delete->descrip->Visible) { // descrip ?>
		<td <?php echo $designation_delete->descrip->cellAttributes() ?>>
<span id="el<?php echo $designation_delete->RowCount ?>_designation_descrip" class="designation_descrip">
<span<?php echo $designation_delete->descrip->viewAttributes() ?>><?php echo $designation_delete->descrip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$designation_delete->Recordset->moveNext();
}
$designation_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $designation_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$designation_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$designation_delete->terminate();
?>