<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$deptement_view = new deptement_view();

// Run the page
$deptement_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$deptement_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$deptement_view->isExport()) { ?>
<script>
var fdeptementview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdeptementview = currentForm = new ew.Form("fdeptementview", "view");
	loadjs.done("fdeptementview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$deptement_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $deptement_view->ExportOptions->render("body") ?>
<?php $deptement_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $deptement_view->showPageHeader(); ?>
<?php
$deptement_view->showMessage();
?>
<?php if (!$deptement_view->IsModal) { ?>
<?php if (!$deptement_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $deptement_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fdeptementview" id="fdeptementview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="deptement">
<input type="hidden" name="modal" value="<?php echo (int)$deptement_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($deptement_view->iddep->Visible) { // iddep ?>
	<tr id="r_iddep">
		<td class="<?php echo $deptement_view->TableLeftColumnClass ?>"><span id="elh_deptement_iddep"><?php echo $deptement_view->iddep->caption() ?></span></td>
		<td data-name="iddep" <?php echo $deptement_view->iddep->cellAttributes() ?>>
<span id="el_deptement_iddep">
<span<?php echo $deptement_view->iddep->viewAttributes() ?>><?php echo $deptement_view->iddep->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($deptement_view->ident->Visible) { // ident ?>
	<tr id="r_ident">
		<td class="<?php echo $deptement_view->TableLeftColumnClass ?>"><span id="elh_deptement_ident"><?php echo $deptement_view->ident->caption() ?></span></td>
		<td data-name="ident" <?php echo $deptement_view->ident->cellAttributes() ?>>
<span id="el_deptement_ident">
<span<?php echo $deptement_view->ident->viewAttributes() ?>><?php echo $deptement_view->ident->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($deptement_view->descrip->Visible) { // descrip ?>
	<tr id="r_descrip">
		<td class="<?php echo $deptement_view->TableLeftColumnClass ?>"><span id="elh_deptement_descrip"><?php echo $deptement_view->descrip->caption() ?></span></td>
		<td data-name="descrip" <?php echo $deptement_view->descrip->cellAttributes() ?>>
<span id="el_deptement_descrip">
<span<?php echo $deptement_view->descrip->viewAttributes() ?>><?php echo $deptement_view->descrip->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$deptement_view->IsModal) { ?>
<?php if (!$deptement_view->isExport()) { ?>
<?php echo $deptement_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$deptement_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$deptement_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$deptement_view->terminate();
?>