<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$deptement_list = new deptement_list();

// Run the page
$deptement_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$deptement_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$deptement_list->isExport()) { ?>
<script>
var fdeptementlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fdeptementlist = currentForm = new ew.Form("fdeptementlist", "list");
	fdeptementlist.formKeyCountName = '<?php echo $deptement_list->FormKeyCountName ?>';
	loadjs.done("fdeptementlist");
});
var fdeptementlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fdeptementlistsrch = currentSearchForm = new ew.Form("fdeptementlistsrch");

	// Dynamic selection lists
	// Filters

	fdeptementlistsrch.filterList = <?php echo $deptement_list->getFilterList() ?>;
	loadjs.done("fdeptementlistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$deptement_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($deptement_list->TotalRecords > 0 && $deptement_list->ExportOptions->visible()) { ?>
<?php $deptement_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($deptement_list->ImportOptions->visible()) { ?>
<?php $deptement_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($deptement_list->SearchOptions->visible()) { ?>
<?php $deptement_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($deptement_list->FilterOptions->visible()) { ?>
<?php $deptement_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$deptement_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$deptement_list->isExport() && !$deptement->CurrentAction) { ?>
<form name="fdeptementlistsrch" id="fdeptementlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fdeptementlistsrch-search-panel" class="<?php echo $deptement_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="deptement">
	<div class="ew-extended-search">
<div id="xsr_<?php echo $deptement_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($deptement_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($deptement_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $deptement_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($deptement_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($deptement_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($deptement_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($deptement_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $deptement_list->showPageHeader(); ?>
<?php
$deptement_list->showMessage();
?>
<?php if ($deptement_list->TotalRecords > 0 || $deptement->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($deptement_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> deptement">
<?php if (!$deptement_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$deptement_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $deptement_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $deptement_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdeptementlist" id="fdeptementlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="deptement">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_deptement" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($deptement_list->TotalRecords > 0 || $deptement_list->isGridEdit()) { ?>
<table id="tbl_deptementlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$deptement->RowType = ROWTYPE_HEADER;

// Render list options
$deptement_list->renderListOptions();

// Render list options (header, left)
$deptement_list->ListOptions->render("header", "left");
?>
<?php if ($deptement_list->iddep->Visible) { // iddep ?>
	<?php if ($deptement_list->SortUrl($deptement_list->iddep) == "") { ?>
		<th data-name="iddep" class="<?php echo $deptement_list->iddep->headerCellClass() ?>"><div id="elh_deptement_iddep" class="deptement_iddep"><div class="ew-table-header-caption"><?php echo $deptement_list->iddep->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddep" class="<?php echo $deptement_list->iddep->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $deptement_list->SortUrl($deptement_list->iddep) ?>', 1);"><div id="elh_deptement_iddep" class="deptement_iddep">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $deptement_list->iddep->caption() ?></span><span class="ew-table-header-sort"><?php if ($deptement_list->iddep->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($deptement_list->iddep->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($deptement_list->ident->Visible) { // ident ?>
	<?php if ($deptement_list->SortUrl($deptement_list->ident) == "") { ?>
		<th data-name="ident" class="<?php echo $deptement_list->ident->headerCellClass() ?>"><div id="elh_deptement_ident" class="deptement_ident"><div class="ew-table-header-caption"><?php echo $deptement_list->ident->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ident" class="<?php echo $deptement_list->ident->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $deptement_list->SortUrl($deptement_list->ident) ?>', 1);"><div id="elh_deptement_ident" class="deptement_ident">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $deptement_list->ident->caption() ?></span><span class="ew-table-header-sort"><?php if ($deptement_list->ident->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($deptement_list->ident->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($deptement_list->descrip->Visible) { // descrip ?>
	<?php if ($deptement_list->SortUrl($deptement_list->descrip) == "") { ?>
		<th data-name="descrip" class="<?php echo $deptement_list->descrip->headerCellClass() ?>"><div id="elh_deptement_descrip" class="deptement_descrip"><div class="ew-table-header-caption"><?php echo $deptement_list->descrip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="descrip" class="<?php echo $deptement_list->descrip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $deptement_list->SortUrl($deptement_list->descrip) ?>', 1);"><div id="elh_deptement_descrip" class="deptement_descrip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $deptement_list->descrip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($deptement_list->descrip->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($deptement_list->descrip->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$deptement_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($deptement_list->ExportAll && $deptement_list->isExport()) {
	$deptement_list->StopRecord = $deptement_list->TotalRecords;
} else {

	// Set the last record to display
	if ($deptement_list->TotalRecords > $deptement_list->StartRecord + $deptement_list->DisplayRecords - 1)
		$deptement_list->StopRecord = $deptement_list->StartRecord + $deptement_list->DisplayRecords - 1;
	else
		$deptement_list->StopRecord = $deptement_list->TotalRecords;
}
$deptement_list->RecordCount = $deptement_list->StartRecord - 1;
if ($deptement_list->Recordset && !$deptement_list->Recordset->EOF) {
	$deptement_list->Recordset->moveFirst();
	$selectLimit = $deptement_list->UseSelectLimit;
	if (!$selectLimit && $deptement_list->StartRecord > 1)
		$deptement_list->Recordset->move($deptement_list->StartRecord - 1);
} elseif (!$deptement->AllowAddDeleteRow && $deptement_list->StopRecord == 0) {
	$deptement_list->StopRecord = $deptement->GridAddRowCount;
}

// Initialize aggregate
$deptement->RowType = ROWTYPE_AGGREGATEINIT;
$deptement->resetAttributes();
$deptement_list->renderRow();
while ($deptement_list->RecordCount < $deptement_list->StopRecord) {
	$deptement_list->RecordCount++;
	if ($deptement_list->RecordCount >= $deptement_list->StartRecord) {
		$deptement_list->RowCount++;

		// Set up key count
		$deptement_list->KeyCount = $deptement_list->RowIndex;

		// Init row class and style
		$deptement->resetAttributes();
		$deptement->CssClass = "";
		if ($deptement_list->isGridAdd()) {
		} else {
			$deptement_list->loadRowValues($deptement_list->Recordset); // Load row values
		}
		$deptement->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$deptement->RowAttrs->merge(["data-rowindex" => $deptement_list->RowCount, "id" => "r" . $deptement_list->RowCount . "_deptement", "data-rowtype" => $deptement->RowType]);

		// Render row
		$deptement_list->renderRow();

		// Render list options
		$deptement_list->renderListOptions();
?>
	<tr <?php echo $deptement->rowAttributes() ?>>
<?php

// Render list options (body, left)
$deptement_list->ListOptions->render("body", "left", $deptement_list->RowCount);
?>
	<?php if ($deptement_list->iddep->Visible) { // iddep ?>
		<td data-name="iddep" <?php echo $deptement_list->iddep->cellAttributes() ?>>
<span id="el<?php echo $deptement_list->RowCount ?>_deptement_iddep">
<span<?php echo $deptement_list->iddep->viewAttributes() ?>><?php echo $deptement_list->iddep->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($deptement_list->ident->Visible) { // ident ?>
		<td data-name="ident" <?php echo $deptement_list->ident->cellAttributes() ?>>
<span id="el<?php echo $deptement_list->RowCount ?>_deptement_ident">
<span<?php echo $deptement_list->ident->viewAttributes() ?>><?php echo $deptement_list->ident->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($deptement_list->descrip->Visible) { // descrip ?>
		<td data-name="descrip" <?php echo $deptement_list->descrip->cellAttributes() ?>>
<span id="el<?php echo $deptement_list->RowCount ?>_deptement_descrip">
<span<?php echo $deptement_list->descrip->viewAttributes() ?>><?php echo $deptement_list->descrip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$deptement_list->ListOptions->render("body", "right", $deptement_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$deptement_list->isGridAdd())
		$deptement_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$deptement->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($deptement_list->Recordset)
	$deptement_list->Recordset->Close();
?>
<?php if (!$deptement_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$deptement_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $deptement_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $deptement_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($deptement_list->TotalRecords == 0 && !$deptement->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $deptement_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$deptement_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$deptement_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$deptement_list->terminate();
?>