<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$deptement_edit = new deptement_edit();

// Run the page
$deptement_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$deptement_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdeptementedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fdeptementedit = currentForm = new ew.Form("fdeptementedit", "edit");

	// Validate form
	fdeptementedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($deptement_edit->iddep->Required) { ?>
				elm = this.getElements("x" + infix + "_iddep");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $deptement_edit->iddep->caption(), $deptement_edit->iddep->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($deptement_edit->ident->Required) { ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $deptement_edit->ident->caption(), $deptement_edit->ident->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($deptement_edit->ident->errorMessage()) ?>");
			<?php if ($deptement_edit->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $deptement_edit->descrip->caption(), $deptement_edit->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdeptementedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdeptementedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fdeptementedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $deptement_edit->showPageHeader(); ?>
<?php
$deptement_edit->showMessage();
?>
<form name="fdeptementedit" id="fdeptementedit" class="<?php echo $deptement_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="deptement">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$deptement_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($deptement_edit->iddep->Visible) { // iddep ?>
	<div id="r_iddep" class="form-group row">
		<label id="elh_deptement_iddep" class="<?php echo $deptement_edit->LeftColumnClass ?>"><?php echo $deptement_edit->iddep->caption() ?><?php echo $deptement_edit->iddep->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $deptement_edit->RightColumnClass ?>"><div <?php echo $deptement_edit->iddep->cellAttributes() ?>>
<span id="el_deptement_iddep">
<span<?php echo $deptement_edit->iddep->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($deptement_edit->iddep->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="deptement" data-field="x_iddep" name="x_iddep" id="x_iddep" value="<?php echo HtmlEncode($deptement_edit->iddep->CurrentValue) ?>">
<?php echo $deptement_edit->iddep->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($deptement_edit->ident->Visible) { // ident ?>
	<div id="r_ident" class="form-group row">
		<label id="elh_deptement_ident" for="x_ident" class="<?php echo $deptement_edit->LeftColumnClass ?>"><?php echo $deptement_edit->ident->caption() ?><?php echo $deptement_edit->ident->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $deptement_edit->RightColumnClass ?>"><div <?php echo $deptement_edit->ident->cellAttributes() ?>>
<span id="el_deptement_ident">
<input type="text" data-table="deptement" data-field="x_ident" name="x_ident" id="x_ident" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($deptement_edit->ident->getPlaceHolder()) ?>" value="<?php echo $deptement_edit->ident->EditValue ?>"<?php echo $deptement_edit->ident->editAttributes() ?>>
</span>
<?php echo $deptement_edit->ident->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($deptement_edit->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_deptement_descrip" for="x_descrip" class="<?php echo $deptement_edit->LeftColumnClass ?>"><?php echo $deptement_edit->descrip->caption() ?><?php echo $deptement_edit->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $deptement_edit->RightColumnClass ?>"><div <?php echo $deptement_edit->descrip->cellAttributes() ?>>
<span id="el_deptement_descrip">
<input type="text" data-table="deptement" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($deptement_edit->descrip->getPlaceHolder()) ?>" value="<?php echo $deptement_edit->descrip->EditValue ?>"<?php echo $deptement_edit->descrip->editAttributes() ?>>
</span>
<?php echo $deptement_edit->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$deptement_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $deptement_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $deptement_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$deptement_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$deptement_edit->terminate();
?>