<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$deptement_delete = new deptement_delete();

// Run the page
$deptement_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$deptement_delete->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdeptementdelete, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "delete";
	fdeptementdelete = currentForm = new ew.Form("fdeptementdelete", "delete");
	loadjs.done("fdeptementdelete");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $deptement_delete->showPageHeader(); ?>
<?php
$deptement_delete->showMessage();
?>
<form name="fdeptementdelete" id="fdeptementdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="deptement">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($deptement_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($deptement_delete->iddep->Visible) { // iddep ?>
		<th class="<?php echo $deptement_delete->iddep->headerCellClass() ?>"><span id="elh_deptement_iddep" class="deptement_iddep"><?php echo $deptement_delete->iddep->caption() ?></span></th>
<?php } ?>
<?php if ($deptement_delete->ident->Visible) { // ident ?>
		<th class="<?php echo $deptement_delete->ident->headerCellClass() ?>"><span id="elh_deptement_ident" class="deptement_ident"><?php echo $deptement_delete->ident->caption() ?></span></th>
<?php } ?>
<?php if ($deptement_delete->descrip->Visible) { // descrip ?>
		<th class="<?php echo $deptement_delete->descrip->headerCellClass() ?>"><span id="elh_deptement_descrip" class="deptement_descrip"><?php echo $deptement_delete->descrip->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$deptement_delete->RecordCount = 0;
$i = 0;
while (!$deptement_delete->Recordset->EOF) {
	$deptement_delete->RecordCount++;
	$deptement_delete->RowCount++;

	// Set row properties
	$deptement->resetAttributes();
	$deptement->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$deptement_delete->loadRowValues($deptement_delete->Recordset);

	// Render row
	$deptement_delete->renderRow();
?>
	<tr <?php echo $deptement->rowAttributes() ?>>
<?php if ($deptement_delete->iddep->Visible) { // iddep ?>
		<td <?php echo $deptement_delete->iddep->cellAttributes() ?>>
<span id="el<?php echo $deptement_delete->RowCount ?>_deptement_iddep" class="deptement_iddep">
<span<?php echo $deptement_delete->iddep->viewAttributes() ?>><?php echo $deptement_delete->iddep->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($deptement_delete->ident->Visible) { // ident ?>
		<td <?php echo $deptement_delete->ident->cellAttributes() ?>>
<span id="el<?php echo $deptement_delete->RowCount ?>_deptement_ident" class="deptement_ident">
<span<?php echo $deptement_delete->ident->viewAttributes() ?>><?php echo $deptement_delete->ident->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($deptement_delete->descrip->Visible) { // descrip ?>
		<td <?php echo $deptement_delete->descrip->cellAttributes() ?>>
<span id="el<?php echo $deptement_delete->RowCount ?>_deptement_descrip" class="deptement_descrip">
<span<?php echo $deptement_delete->descrip->viewAttributes() ?>><?php echo $deptement_delete->descrip->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$deptement_delete->Recordset->moveNext();
}
$deptement_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $deptement_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$deptement_delete->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$deptement_delete->terminate();
?>