<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$deptement_add = new deptement_add();

// Run the page
$deptement_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$deptement_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdeptementadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fdeptementadd = currentForm = new ew.Form("fdeptementadd", "add");

	// Validate form
	fdeptementadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($deptement_add->ident->Required) { ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $deptement_add->ident->caption(), $deptement_add->ident->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_ident");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($deptement_add->ident->errorMessage()) ?>");
			<?php if ($deptement_add->descrip->Required) { ?>
				elm = this.getElements("x" + infix + "_descrip");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $deptement_add->descrip->caption(), $deptement_add->descrip->RequiredErrorMessage)) ?>");
			<?php } ?>

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdeptementadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdeptementadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	loadjs.done("fdeptementadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $deptement_add->showPageHeader(); ?>
<?php
$deptement_add->showMessage();
?>
<form name="fdeptementadd" id="fdeptementadd" class="<?php echo $deptement_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="deptement">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$deptement_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($deptement_add->ident->Visible) { // ident ?>
	<div id="r_ident" class="form-group row">
		<label id="elh_deptement_ident" for="x_ident" class="<?php echo $deptement_add->LeftColumnClass ?>"><?php echo $deptement_add->ident->caption() ?><?php echo $deptement_add->ident->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $deptement_add->RightColumnClass ?>"><div <?php echo $deptement_add->ident->cellAttributes() ?>>
<span id="el_deptement_ident">
<input type="text" data-table="deptement" data-field="x_ident" name="x_ident" id="x_ident" size="30" maxlength="11" placeholder="<?php echo HtmlEncode($deptement_add->ident->getPlaceHolder()) ?>" value="<?php echo $deptement_add->ident->EditValue ?>"<?php echo $deptement_add->ident->editAttributes() ?>>
</span>
<?php echo $deptement_add->ident->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($deptement_add->descrip->Visible) { // descrip ?>
	<div id="r_descrip" class="form-group row">
		<label id="elh_deptement_descrip" for="x_descrip" class="<?php echo $deptement_add->LeftColumnClass ?>"><?php echo $deptement_add->descrip->caption() ?><?php echo $deptement_add->descrip->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $deptement_add->RightColumnClass ?>"><div <?php echo $deptement_add->descrip->cellAttributes() ?>>
<span id="el_deptement_descrip">
<input type="text" data-table="deptement" data-field="x_descrip" name="x_descrip" id="x_descrip" size="30" maxlength="150" placeholder="<?php echo HtmlEncode($deptement_add->descrip->getPlaceHolder()) ?>" value="<?php echo $deptement_add->descrip->EditValue ?>"<?php echo $deptement_add->descrip->editAttributes() ?>>
</span>
<?php echo $deptement_add->descrip->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$deptement_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $deptement_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $deptement_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$deptement_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$deptement_add->terminate();
?>