<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$datatemp_view = new datatemp_view();

// Run the page
$datatemp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$datatemp_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$datatemp_view->isExport()) { ?>
<script>
var fdatatempview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdatatempview = currentForm = new ew.Form("fdatatempview", "view");
	loadjs.done("fdatatempview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$datatemp_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $datatemp_view->ExportOptions->render("body") ?>
<?php $datatemp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $datatemp_view->showPageHeader(); ?>
<?php
$datatemp_view->showMessage();
?>
<?php if (!$datatemp_view->IsModal) { ?>
<?php if (!$datatemp_view->isExport()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $datatemp_view->Pager->render() ?>
<div class="clearfix"></div>
</form>
<?php } ?>
<?php } ?>
<form name="fdatatempview" id="fdatatempview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="datatemp">
<input type="hidden" name="modal" value="<?php echo (int)$datatemp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($datatemp_view->iddt->Visible) { // iddt ?>
	<tr id="r_iddt">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_iddt"><?php echo $datatemp_view->iddt->caption() ?></span></td>
		<td data-name="iddt" <?php echo $datatemp_view->iddt->cellAttributes() ?>>
<span id="el_datatemp_iddt">
<span<?php echo $datatemp_view->iddt->viewAttributes() ?>><?php echo $datatemp_view->iddt->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->datejob->Visible) { // datejob ?>
	<tr id="r_datejob">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_datejob"><?php echo $datatemp_view->datejob->caption() ?></span></td>
		<td data-name="datejob" <?php echo $datatemp_view->datejob->cellAttributes() ?>>
<span id="el_datatemp_datejob">
<span<?php echo $datatemp_view->datejob->viewAttributes() ?>><?php echo $datatemp_view->datejob->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->idemp->Visible) { // idemp ?>
	<tr id="r_idemp">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_idemp"><?php echo $datatemp_view->idemp->caption() ?></span></td>
		<td data-name="idemp" <?php echo $datatemp_view->idemp->cellAttributes() ?>>
<span id="el_datatemp_idemp">
<span<?php echo $datatemp_view->idemp->viewAttributes() ?>><?php echo $datatemp_view->idemp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->dept->Visible) { // dept ?>
	<tr id="r_dept">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_dept"><?php echo $datatemp_view->dept->caption() ?></span></td>
		<td data-name="dept" <?php echo $datatemp_view->dept->cellAttributes() ?>>
<span id="el_datatemp_dept">
<span<?php echo $datatemp_view->dept->viewAttributes() ?>><?php echo $datatemp_view->dept->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_type"><?php echo $datatemp_view->type->caption() ?></span></td>
		<td data-name="type" <?php echo $datatemp_view->type->cellAttributes() ?>>
<span id="el_datatemp_type">
<span<?php echo $datatemp_view->type->viewAttributes() ?>><?php echo $datatemp_view->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->nbrheur->Visible) { // nbrheur ?>
	<tr id="r_nbrheur">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_nbrheur"><?php echo $datatemp_view->nbrheur->caption() ?></span></td>
		<td data-name="nbrheur" <?php echo $datatemp_view->nbrheur->cellAttributes() ?>>
<span id="el_datatemp_nbrheur">
<span<?php echo $datatemp_view->nbrheur->viewAttributes() ?>><?php echo $datatemp_view->nbrheur->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->tauxh->Visible) { // tauxh ?>
	<tr id="r_tauxh">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_tauxh"><?php echo $datatemp_view->tauxh->caption() ?></span></td>
		<td data-name="tauxh" <?php echo $datatemp_view->tauxh->cellAttributes() ?>>
<span id="el_datatemp_tauxh">
<span<?php echo $datatemp_view->tauxh->viewAttributes() ?>><?php echo $datatemp_view->tauxh->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($datatemp_view->SubTotal->Visible) { // SubTotal ?>
	<tr id="r_SubTotal">
		<td class="<?php echo $datatemp_view->TableLeftColumnClass ?>"><span id="elh_datatemp_SubTotal"><?php echo $datatemp_view->SubTotal->caption() ?></span></td>
		<td data-name="SubTotal" <?php echo $datatemp_view->SubTotal->cellAttributes() ?>>
<span id="el_datatemp_SubTotal">
<span<?php echo $datatemp_view->SubTotal->viewAttributes() ?>><?php echo $datatemp_view->SubTotal->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$datatemp_view->IsModal) { ?>
<?php if (!$datatemp_view->isExport()) { ?>
<?php echo $datatemp_view->Pager->render() ?>
<div class="clearfix"></div>
<?php } ?>
<?php } ?>
</form>
<?php
$datatemp_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$datatemp_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$datatemp_view->terminate();
?>