<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$datatemp_list = new datatemp_list();

// Run the page
$datatemp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$datatemp_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$datatemp_list->isExport()) { ?>
<script>
var fdatatemplist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fdatatemplist = currentForm = new ew.Form("fdatatemplist", "list");
	fdatatemplist.formKeyCountName = '<?php echo $datatemp_list->FormKeyCountName ?>';

	// Validate form
	fdatatemplist.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($datatemp_list->iddt->Required) { ?>
				elm = this.getElements("x" + infix + "_iddt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->iddt->caption(), $datatemp_list->iddt->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_list->datejob->Required) { ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->datejob->caption(), $datatemp_list->datejob->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_list->datejob->errorMessage()) ?>");
			<?php if ($datatemp_list->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->idemp->caption(), $datatemp_list->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_list->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->dept->caption(), $datatemp_list->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_list->dept->errorMessage()) ?>");
			<?php if ($datatemp_list->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->type->caption(), $datatemp_list->type->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_list->type->errorMessage()) ?>");
			<?php if ($datatemp_list->nbrheur->Required) { ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->nbrheur->caption(), $datatemp_list->nbrheur->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_list->nbrheur->errorMessage()) ?>");
			<?php if ($datatemp_list->tauxh->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->tauxh->caption(), $datatemp_list->tauxh->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_list->tauxh->errorMessage()) ?>");
			<?php if ($datatemp_list->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_list->SubTotal->caption(), $datatemp_list->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_list->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		if (gridinsert && addcnt == 0) { // No row added
			ew.alert(ew.language.phrase("NoAddRecord"));
			return false;
		}
		return true;
	}

	// Check empty row
	fdatatemplist.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "datejob", false)) return false;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "dept", false)) return false;
		if (ew.valueChanged(fobj, infix, "type", false)) return false;
		if (ew.valueChanged(fobj, infix, "nbrheur", false)) return false;
		if (ew.valueChanged(fobj, infix, "tauxh", false)) return false;
		if (ew.valueChanged(fobj, infix, "SubTotal", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fdatatemplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdatatemplist.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdatatemplist.lists["x_idemp"] = <?php echo $datatemp_list->idemp->Lookup->toClientList($datatemp_list) ?>;
	fdatatemplist.lists["x_idemp"].options = <?php echo JsonEncode($datatemp_list->idemp->lookupOptions()) ?>;
	fdatatemplist.lists["x_dept"] = <?php echo $datatemp_list->dept->Lookup->toClientList($datatemp_list) ?>;
	fdatatemplist.lists["x_dept"].options = <?php echo JsonEncode($datatemp_list->dept->lookupOptions()) ?>;
	fdatatemplist.autoSuggests["x_dept"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	fdatatemplist.lists["x_type"] = <?php echo $datatemp_list->type->Lookup->toClientList($datatemp_list) ?>;
	fdatatemplist.lists["x_type"].options = <?php echo JsonEncode($datatemp_list->type->lookupOptions()) ?>;
	fdatatemplist.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	loadjs.done("fdatatemplist");
});
var fdatatemplistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fdatatemplistsrch = currentSearchForm = new ew.Form("fdatatemplistsrch");

	// Validate function for search
	fdatatemplistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_datejob");
		if (elm && !ew.checkEuroDate(elm.value))
			return this.onError(elm, "<?php echo JsEncode($datatemp_list->datejob->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fdatatemplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdatatemplistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdatatemplistsrch.lists["x_idemp"] = <?php echo $datatemp_list->idemp->Lookup->toClientList($datatemp_list) ?>;
	fdatatemplistsrch.lists["x_idemp"].options = <?php echo JsonEncode($datatemp_list->idemp->lookupOptions()) ?>;

	// Filters
	fdatatemplistsrch.filterList = <?php echo $datatemp_list->getFilterList() ?>;
	loadjs.done("fdatatemplistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$datatemp_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($datatemp_list->TotalRecords > 0 && $datatemp_list->ExportOptions->visible()) { ?>
<?php $datatemp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($datatemp_list->ImportOptions->visible()) { ?>
<?php $datatemp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($datatemp_list->SearchOptions->visible()) { ?>
<?php $datatemp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($datatemp_list->FilterOptions->visible()) { ?>
<?php $datatemp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$datatemp_list->isExport() || Config("EXPORT_MASTER_RECORD") && $datatemp_list->isExport("print")) { ?>
<?php
if ($datatemp_list->DbMasterFilter != "" && $datatemp->getCurrentMasterTable() == "attendance") {
	if ($datatemp_list->MasterRecordExists) {
		include_once "attendancemaster.php";
	}
}
?>
<?php } ?>
<?php
$datatemp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$datatemp_list->isExport() && !$datatemp->CurrentAction) { ?>
<form name="fdatatemplistsrch" id="fdatatemplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fdatatemplistsrch-search-panel" class="<?php echo $datatemp_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="datatemp">
	<div class="ew-extended-search">
<?php

// Render search row
$datatemp->RowType = ROWTYPE_SEARCH;
$datatemp->resetAttributes();
$datatemp_list->renderRow();
?>
<?php if ($datatemp_list->datejob->Visible) { // datejob ?>
	<?php
		$datatemp_list->SearchColumnCount++;
		if (($datatemp_list->SearchColumnCount - 1) % $datatemp_list->SearchFieldsPerRow == 0) {
			$datatemp_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $datatemp_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_datejob" class="ew-cell form-group">
		<label for="x_datejob" class="ew-search-caption ew-label"><?php echo $datatemp_list->datejob->caption() ?></label>
		<span class="ew-search-operator">
<select name="z_datejob" id="z_datejob" class="custom-select" onchange="ew.searchOperatorChanged(this);">
<option value="="<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "=" ? " selected" : "" ?>><?php echo $Language->phrase("EQUAL") ?></option>
<option value="<>"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "<>" ? " selected" : "" ?>><?php echo $Language->phrase("<>") ?></option>
<option value="<"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "<" ? " selected" : "" ?>><?php echo $Language->phrase("<") ?></option>
<option value="<="<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "<=" ? " selected" : "" ?>><?php echo $Language->phrase("<=") ?></option>
<option value=">"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == ">" ? " selected" : "" ?>><?php echo $Language->phrase(">") ?></option>
<option value=">="<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == ">=" ? " selected" : "" ?>><?php echo $Language->phrase(">=") ?></option>
<option value="IS NULL"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "IS NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NULL") ?></option>
<option value="IS NOT NULL"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "IS NOT NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NOT NULL") ?></option>
<option value="BETWEEN"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator == "BETWEEN" ? " selected" : "" ?>><?php echo $Language->phrase("BETWEEN") ?></option>
</select>
</span>
		<span id="el_datatemp_datejob" class="ew-search-field">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x_datejob" id="x_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_list->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->datejob->EditValue ?>"<?php echo $datatemp_list->datejob->editAttributes() ?>>
<?php if (!$datatemp_list->datejob->ReadOnly && !$datatemp_list->datejob->Disabled && !isset($datatemp_list->datejob->EditAttrs["readonly"]) && !isset($datatemp_list->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatemplistsrch", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatemplistsrch", "x_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond">
<div class="custom-control custom-radio custom-control-inline"><input class="custom-control-input" type="radio" id="v_datejob_1" name="v_datejob" value="AND"<?php if ($datatemp_list->datejob->AdvancedSearch->SearchCondition != "OR") echo " checked" ?>><label class="custom-control-label" for="v_datejob_1"><?php echo $Language->phrase("AND") ?></label></div>
<div class="custom-control custom-radio custom-control-inline"><input class="custom-control-input" type="radio" id="v_datejob_2" name="v_datejob" value="OR"<?php if ($datatemp_list->datejob->AdvancedSearch->SearchCondition == "OR") echo " checked" ?>><label class="custom-control-label" for="v_datejob_2"><?php echo $Language->phrase("OR") ?></label></div></span>
		<span class="ew-search-and d-none"><label><?php echo $Language->phrase("AND") ?></label></span>
		<span class="ew-search-operator2">
<select name="w_datejob" id="w_datejob" class="custom-select" onchange="ew.searchOperatorChanged(this);">
<option value="="<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == "=" ? " selected" : "" ?>><?php echo $Language->phrase("EQUAL") ?></option>
<option value="<>"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == "<>" ? " selected" : "" ?>><?php echo $Language->phrase("<>") ?></option>
<option value="<"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == "<" ? " selected" : "" ?>><?php echo $Language->phrase("<") ?></option>
<option value="<="<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == "<=" ? " selected" : "" ?>><?php echo $Language->phrase("<=") ?></option>
<option value=">"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == ">" ? " selected" : "" ?>><?php echo $Language->phrase(">") ?></option>
<option value=">="<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == ">=" ? " selected" : "" ?>><?php echo $Language->phrase(">=") ?></option>
<option value="IS NULL"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == "IS NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NULL") ?></option>
<option value="IS NOT NULL"<?php echo $datatemp_list->datejob->AdvancedSearch->SearchOperator2 == "IS NOT NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NOT NULL") ?></option>
</select>
</span>
		<span id="el2_datatemp_datejob" class="ew-search-field2">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="y_datejob" id="y_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_list->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->datejob->EditValue2 ?>"<?php echo $datatemp_list->datejob->editAttributes() ?>>
<?php if (!$datatemp_list->datejob->ReadOnly && !$datatemp_list->datejob->Disabled && !isset($datatemp_list->datejob->EditAttrs["readonly"]) && !isset($datatemp_list->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatemplistsrch", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatemplistsrch", "y_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
	</div>
	<?php if ($datatemp_list->SearchColumnCount % $datatemp_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->idemp->Visible) { // idemp ?>
	<?php
		$datatemp_list->SearchColumnCount++;
		if (($datatemp_list->SearchColumnCount - 1) % $datatemp_list->SearchFieldsPerRow == 0) {
			$datatemp_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $datatemp_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_idemp" class="ew-cell form-group">
		<label for="x_idemp" class="ew-search-caption ew-label"><?php echo $datatemp_list->idemp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_idemp" id="z_idemp" value="=">
</span>
		<span id="el_datatemp_idemp" class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($datatemp_list->idemp->AdvancedSearch->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_list->idemp->AdvancedSearch->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_list->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_list->idemp->ReadOnly || $datatemp_list->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_list->idemp->Lookup->getParamTag($datatemp_list, "p_x_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_list->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $datatemp_list->idemp->AdvancedSearch->SearchValue ?>"<?php echo $datatemp_list->idemp->editAttributes() ?>>
</span>
	</div>
	<?php if ($datatemp_list->SearchColumnCount % $datatemp_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($datatemp_list->SearchColumnCount % $datatemp_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $datatemp_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($datatemp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($datatemp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $datatemp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($datatemp_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($datatemp_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($datatemp_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($datatemp_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $datatemp_list->showPageHeader(); ?>
<?php
$datatemp_list->showMessage();
?>
<?php if ($datatemp_list->TotalRecords > 0 || $datatemp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($datatemp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> datatemp">
<?php if (!$datatemp_list->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$datatemp_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $datatemp_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $datatemp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fdatatemplist" id="fdatatemplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="datatemp">
<input type="hidden" name="exporttype" id="exporttype" value="">
<?php if ($datatemp->getCurrentMasterTable() == "attendance" && $datatemp->CurrentAction) { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="attendance">
<input type="hidden" name="fk_idatt" value="<?php echo HtmlEncode($datatemp_list->idatt->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_datatemp" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($datatemp_list->TotalRecords > 0 || $datatemp_list->isGridEdit()) { ?>
<table id="tbl_datatemplist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$datatemp->RowType = ROWTYPE_HEADER;

// Render list options
$datatemp_list->renderListOptions();

// Render list options (header, left)
$datatemp_list->ListOptions->render("header", "left");
?>
<?php if ($datatemp_list->iddt->Visible) { // iddt ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->iddt) == "") { ?>
		<th data-name="iddt" class="<?php echo $datatemp_list->iddt->headerCellClass() ?>" style="width: 4px;"><div id="elh_datatemp_iddt" class="datatemp_iddt"><div class="ew-table-header-caption"><?php echo $datatemp_list->iddt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddt" class="<?php echo $datatemp_list->iddt->headerCellClass() ?>" style="width: 4px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->iddt) ?>', 1);"><div id="elh_datatemp_iddt" class="datatemp_iddt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->iddt->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->iddt->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->iddt->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->datejob->Visible) { // datejob ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->datejob) == "") { ?>
		<th data-name="datejob" class="<?php echo $datatemp_list->datejob->headerCellClass() ?>" style="width: 8px;"><div id="elh_datatemp_datejob" class="datatemp_datejob"><div class="ew-table-header-caption"><?php echo $datatemp_list->datejob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datejob" class="<?php echo $datatemp_list->datejob->headerCellClass() ?>" style="width: 8px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->datejob) ?>', 1);"><div id="elh_datatemp_datejob" class="datatemp_datejob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->datejob->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->datejob->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->datejob->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->idemp->Visible) { // idemp ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $datatemp_list->idemp->headerCellClass() ?>"><div id="elh_datatemp_idemp" class="datatemp_idemp"><div class="ew-table-header-caption"><?php echo $datatemp_list->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $datatemp_list->idemp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->idemp) ?>', 1);"><div id="elh_datatemp_idemp" class="datatemp_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->dept->Visible) { // dept ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->dept) == "") { ?>
		<th data-name="dept" class="<?php echo $datatemp_list->dept->headerCellClass() ?>" style="width: 30px;"><div id="elh_datatemp_dept" class="datatemp_dept"><div class="ew-table-header-caption"><?php echo $datatemp_list->dept->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dept" class="<?php echo $datatemp_list->dept->headerCellClass() ?>" style="width: 30px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->dept) ?>', 1);"><div id="elh_datatemp_dept" class="datatemp_dept">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->dept->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->dept->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->dept->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->type->Visible) { // type ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->type) == "") { ?>
		<th data-name="type" class="<?php echo $datatemp_list->type->headerCellClass() ?>" style="width: 1px;"><div id="elh_datatemp_type" class="datatemp_type"><div class="ew-table-header-caption"><?php echo $datatemp_list->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $datatemp_list->type->headerCellClass() ?>" style="width: 1px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->type) ?>', 1);"><div id="elh_datatemp_type" class="datatemp_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->nbrheur->Visible) { // nbrheur ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->nbrheur) == "") { ?>
		<th data-name="nbrheur" class="<?php echo $datatemp_list->nbrheur->headerCellClass() ?>" style="width: 2px;"><div id="elh_datatemp_nbrheur" class="datatemp_nbrheur"><div class="ew-table-header-caption"><?php echo $datatemp_list->nbrheur->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nbrheur" class="<?php echo $datatemp_list->nbrheur->headerCellClass() ?>" style="width: 2px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->nbrheur) ?>', 1);"><div id="elh_datatemp_nbrheur" class="datatemp_nbrheur">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->nbrheur->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->nbrheur->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->nbrheur->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->tauxh->Visible) { // tauxh ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->tauxh) == "") { ?>
		<th data-name="tauxh" class="<?php echo $datatemp_list->tauxh->headerCellClass() ?>" style="width: 5px;"><div id="elh_datatemp_tauxh" class="datatemp_tauxh"><div class="ew-table-header-caption"><?php echo $datatemp_list->tauxh->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tauxh" class="<?php echo $datatemp_list->tauxh->headerCellClass() ?>" style="width: 5px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->tauxh) ?>', 1);"><div id="elh_datatemp_tauxh" class="datatemp_tauxh">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->tauxh->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->tauxh->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->tauxh->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_list->SubTotal->Visible) { // SubTotal ?>
	<?php if ($datatemp_list->SortUrl($datatemp_list->SubTotal) == "") { ?>
		<th data-name="SubTotal" class="<?php echo $datatemp_list->SubTotal->headerCellClass() ?>" style="width: 5px;"><div id="elh_datatemp_SubTotal" class="datatemp_SubTotal"><div class="ew-table-header-caption"><?php echo $datatemp_list->SubTotal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SubTotal" class="<?php echo $datatemp_list->SubTotal->headerCellClass() ?>" style="width: 5px;"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $datatemp_list->SortUrl($datatemp_list->SubTotal) ?>', 1);"><div id="elh_datatemp_SubTotal" class="datatemp_SubTotal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_list->SubTotal->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_list->SubTotal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_list->SubTotal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$datatemp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($datatemp_list->ExportAll && $datatemp_list->isExport()) {
	$datatemp_list->StopRecord = $datatemp_list->TotalRecords;
} else {

	// Set the last record to display
	if ($datatemp_list->TotalRecords > $datatemp_list->StartRecord + $datatemp_list->DisplayRecords - 1)
		$datatemp_list->StopRecord = $datatemp_list->StartRecord + $datatemp_list->DisplayRecords - 1;
	else
		$datatemp_list->StopRecord = $datatemp_list->TotalRecords;
}

// Restore number of post back records
if ($CurrentForm && ($datatemp->isConfirm() || $datatemp_list->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($datatemp_list->FormKeyCountName) && ($datatemp_list->isGridAdd() || $datatemp_list->isGridEdit() || $datatemp->isConfirm())) {
		$datatemp_list->KeyCount = $CurrentForm->getValue($datatemp_list->FormKeyCountName);
		$datatemp_list->StopRecord = $datatemp_list->StartRecord + $datatemp_list->KeyCount - 1;
	}
}
$datatemp_list->RecordCount = $datatemp_list->StartRecord - 1;
if ($datatemp_list->Recordset && !$datatemp_list->Recordset->EOF) {
	$datatemp_list->Recordset->moveFirst();
	$selectLimit = $datatemp_list->UseSelectLimit;
	if (!$selectLimit && $datatemp_list->StartRecord > 1)
		$datatemp_list->Recordset->move($datatemp_list->StartRecord - 1);
} elseif (!$datatemp->AllowAddDeleteRow && $datatemp_list->StopRecord == 0) {
	$datatemp_list->StopRecord = $datatemp->GridAddRowCount;
}

// Initialize aggregate
$datatemp->RowType = ROWTYPE_AGGREGATEINIT;
$datatemp->resetAttributes();
$datatemp_list->renderRow();
if ($datatemp_list->isGridAdd())
	$datatemp_list->RowIndex = 0;
if ($datatemp_list->isGridEdit())
	$datatemp_list->RowIndex = 0;
while ($datatemp_list->RecordCount < $datatemp_list->StopRecord) {
	$datatemp_list->RecordCount++;
	if ($datatemp_list->RecordCount >= $datatemp_list->StartRecord) {
		$datatemp_list->RowCount++;
		if ($datatemp_list->isGridAdd() || $datatemp_list->isGridEdit() || $datatemp->isConfirm()) {
			$datatemp_list->RowIndex++;
			$CurrentForm->Index = $datatemp_list->RowIndex;
			if ($CurrentForm->hasValue($datatemp_list->FormActionName) && ($datatemp->isConfirm() || $datatemp_list->EventCancelled))
				$datatemp_list->RowAction = strval($CurrentForm->getValue($datatemp_list->FormActionName));
			elseif ($datatemp_list->isGridAdd())
				$datatemp_list->RowAction = "insert";
			else
				$datatemp_list->RowAction = "";
		}

		// Set up key count
		$datatemp_list->KeyCount = $datatemp_list->RowIndex;

		// Init row class and style
		$datatemp->resetAttributes();
		$datatemp->CssClass = "";
		if ($datatemp_list->isGridAdd()) {
			$datatemp_list->loadRowValues(); // Load default values
		} else {
			$datatemp_list->loadRowValues($datatemp_list->Recordset); // Load row values
		}
		$datatemp->RowType = ROWTYPE_VIEW; // Render view
		if ($datatemp_list->isGridAdd()) // Grid add
			$datatemp->RowType = ROWTYPE_ADD; // Render add
		if ($datatemp_list->isGridAdd() && $datatemp->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$datatemp_list->restoreCurrentRowFormValues($datatemp_list->RowIndex); // Restore form values
		if ($datatemp_list->isGridEdit()) { // Grid edit
			if ($datatemp->EventCancelled)
				$datatemp_list->restoreCurrentRowFormValues($datatemp_list->RowIndex); // Restore form values
			if ($datatemp_list->RowAction == "insert")
				$datatemp->RowType = ROWTYPE_ADD; // Render add
			else
				$datatemp->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($datatemp_list->isGridEdit() && ($datatemp->RowType == ROWTYPE_EDIT || $datatemp->RowType == ROWTYPE_ADD) && $datatemp->EventCancelled) // Update failed
			$datatemp_list->restoreCurrentRowFormValues($datatemp_list->RowIndex); // Restore form values
		if ($datatemp->RowType == ROWTYPE_EDIT) // Edit row
			$datatemp_list->EditRowCount++;

		// Set up row id / data-rowindex
		$datatemp->RowAttrs->merge(["data-rowindex" => $datatemp_list->RowCount, "id" => "r" . $datatemp_list->RowCount . "_datatemp", "data-rowtype" => $datatemp->RowType]);

		// Render row
		$datatemp_list->renderRow();

		// Render list options
		$datatemp_list->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($datatemp_list->RowAction != "delete" && $datatemp_list->RowAction != "insertdelete" && !($datatemp_list->RowAction == "insert" && $datatemp->isConfirm() && $datatemp_list->emptyRow())) {
?>
	<tr <?php echo $datatemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$datatemp_list->ListOptions->render("body", "left", $datatemp_list->RowCount);
?>
	<?php if ($datatemp_list->iddt->Visible) { // iddt ?>
		<td data-name="iddt" <?php echo $datatemp_list->iddt->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_iddt" class="form-group"></span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="o<?php echo $datatemp_list->RowIndex ?>_iddt" id="o<?php echo $datatemp_list->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_list->iddt->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_iddt" class="form-group">
<span<?php echo $datatemp_list->iddt->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_list->iddt->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="x<?php echo $datatemp_list->RowIndex ?>_iddt" id="x<?php echo $datatemp_list->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_list->iddt->CurrentValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_iddt">
<span<?php echo $datatemp_list->iddt->viewAttributes() ?>><?php echo $datatemp_list->iddt->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->datejob->Visible) { // datejob ?>
		<td data-name="datejob" <?php echo $datatemp_list->datejob->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_datejob" class="form-group">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x<?php echo $datatemp_list->RowIndex ?>_datejob" id="x<?php echo $datatemp_list->RowIndex ?>_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_list->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->datejob->EditValue ?>"<?php echo $datatemp_list->datejob->editAttributes() ?>>
<?php if (!$datatemp_list->datejob->ReadOnly && !$datatemp_list->datejob->Disabled && !isset($datatemp_list->datejob->EditAttrs["readonly"]) && !isset($datatemp_list->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatemplist", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatemplist", "x<?php echo $datatemp_list->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="o<?php echo $datatemp_list->RowIndex ?>_datejob" id="o<?php echo $datatemp_list->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_list->datejob->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_datejob" class="form-group">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x<?php echo $datatemp_list->RowIndex ?>_datejob" id="x<?php echo $datatemp_list->RowIndex ?>_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_list->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->datejob->EditValue ?>"<?php echo $datatemp_list->datejob->editAttributes() ?>>
<?php if (!$datatemp_list->datejob->ReadOnly && !$datatemp_list->datejob->Disabled && !isset($datatemp_list->datejob->EditAttrs["readonly"]) && !isset($datatemp_list->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatemplist", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatemplist", "x<?php echo $datatemp_list->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_datejob">
<span<?php echo $datatemp_list->datejob->viewAttributes() ?>><?php echo $datatemp_list->datejob->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $datatemp_list->idemp->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_idemp" class="form-group">
<?php $datatemp_list->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $datatemp_list->RowIndex ?>_idemp"><?php echo EmptyValue(strval($datatemp_list->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_list->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_list->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_list->idemp->ReadOnly || $datatemp_list->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $datatemp_list->RowIndex ?>_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_list->idemp->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_list->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_idemp" id="x<?php echo $datatemp_list->RowIndex ?>_idemp" value="<?php echo $datatemp_list->idemp->CurrentValue ?>"<?php echo $datatemp_list->idemp->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="o<?php echo $datatemp_list->RowIndex ?>_idemp" id="o<?php echo $datatemp_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_list->idemp->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_idemp" class="form-group">
<?php $datatemp_list->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $datatemp_list->RowIndex ?>_idemp"><?php echo EmptyValue(strval($datatemp_list->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_list->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_list->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_list->idemp->ReadOnly || $datatemp_list->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $datatemp_list->RowIndex ?>_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_list->idemp->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_list->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_idemp" id="x<?php echo $datatemp_list->RowIndex ?>_idemp" value="<?php echo $datatemp_list->idemp->CurrentValue ?>"<?php echo $datatemp_list->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_idemp">
<span<?php echo $datatemp_list->idemp->viewAttributes() ?>><?php echo $datatemp_list->idemp->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->dept->Visible) { // dept ?>
		<td data-name="dept" <?php echo $datatemp_list->dept->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_dept" class="form-group">
<?php
$onchange = $datatemp_list->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_list->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_list->RowIndex ?>_dept">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_list->RowIndex ?>_dept" id="sv_x<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo RemoveHtml($datatemp_list->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_list->dept->getPlaceHolder()) ?>"<?php echo $datatemp_list->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_list->dept->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_dept" id="x<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_list->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatemplist"], function() {
	fdatatemplist.createAutoSuggest({"id":"x<?php echo $datatemp_list->RowIndex ?>_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_list->dept->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_dept") ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="o<?php echo $datatemp_list->RowIndex ?>_dept" id="o<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_list->dept->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_dept" class="form-group">
<?php
$onchange = $datatemp_list->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_list->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_list->RowIndex ?>_dept">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_list->RowIndex ?>_dept" id="sv_x<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo RemoveHtml($datatemp_list->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_list->dept->getPlaceHolder()) ?>"<?php echo $datatemp_list->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_list->dept->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_dept" id="x<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_list->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatemplist"], function() {
	fdatatemplist.createAutoSuggest({"id":"x<?php echo $datatemp_list->RowIndex ?>_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_list->dept->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_dept") ?>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_dept">
<span<?php echo $datatemp_list->dept->viewAttributes() ?>><?php echo $datatemp_list->dept->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->type->Visible) { // type ?>
		<td data-name="type" <?php echo $datatemp_list->type->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_type" class="form-group">
<?php
$onchange = $datatemp_list->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_list->type->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_list->RowIndex ?>_type">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_list->RowIndex ?>_type" id="sv_x<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo RemoveHtml($datatemp_list->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_list->type->getPlaceHolder()) ?>"<?php echo $datatemp_list->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_list->type->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_type" id="x<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_list->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatemplist"], function() {
	fdatatemplist.createAutoSuggest({"id":"x<?php echo $datatemp_list->RowIndex ?>_type","forceSelect":false});
});
</script>
<?php echo $datatemp_list->type->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_type") ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" name="o<?php echo $datatemp_list->RowIndex ?>_type" id="o<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_list->type->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_type" class="form-group">
<?php
$onchange = $datatemp_list->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_list->type->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_list->RowIndex ?>_type">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_list->RowIndex ?>_type" id="sv_x<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo RemoveHtml($datatemp_list->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_list->type->getPlaceHolder()) ?>"<?php echo $datatemp_list->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_list->type->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_type" id="x<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_list->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatemplist"], function() {
	fdatatemplist.createAutoSuggest({"id":"x<?php echo $datatemp_list->RowIndex ?>_type","forceSelect":false});
});
</script>
<?php echo $datatemp_list->type->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_type") ?>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_type">
<span<?php echo $datatemp_list->type->viewAttributes() ?>><?php echo $datatemp_list->type->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur" <?php echo $datatemp_list->nbrheur->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_nbrheur" class="form-group">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_list->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_list->RowIndex ?>_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->nbrheur->EditValue ?>"<?php echo $datatemp_list->nbrheur->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="o<?php echo $datatemp_list->RowIndex ?>_nbrheur" id="o<?php echo $datatemp_list->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_list->nbrheur->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_nbrheur" class="form-group">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_list->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_list->RowIndex ?>_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->nbrheur->EditValue ?>"<?php echo $datatemp_list->nbrheur->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_nbrheur">
<span<?php echo $datatemp_list->nbrheur->viewAttributes() ?>><?php echo $datatemp_list->nbrheur->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh" <?php echo $datatemp_list->tauxh->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_tauxh" class="form-group">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_list->RowIndex ?>_tauxh" id="x<?php echo $datatemp_list->RowIndex ?>_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_list->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->tauxh->EditValue ?>"<?php echo $datatemp_list->tauxh->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="o<?php echo $datatemp_list->RowIndex ?>_tauxh" id="o<?php echo $datatemp_list->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_list->tauxh->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_tauxh" class="form-group">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_list->RowIndex ?>_tauxh" id="x<?php echo $datatemp_list->RowIndex ?>_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_list->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->tauxh->EditValue ?>"<?php echo $datatemp_list->tauxh->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_tauxh">
<span<?php echo $datatemp_list->tauxh->viewAttributes() ?>><?php echo $datatemp_list->tauxh->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_list->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" <?php echo $datatemp_list->SubTotal->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_SubTotal" class="form-group">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_list->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_list->RowIndex ?>_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_list->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->SubTotal->EditValue ?>"<?php echo $datatemp_list->SubTotal->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="o<?php echo $datatemp_list->RowIndex ?>_SubTotal" id="o<?php echo $datatemp_list->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_list->SubTotal->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_SubTotal" class="form-group">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_list->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_list->RowIndex ?>_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_list->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->SubTotal->EditValue ?>"<?php echo $datatemp_list->SubTotal->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_list->RowCount ?>_datatemp_SubTotal">
<span<?php echo $datatemp_list->SubTotal->viewAttributes() ?>><?php echo $datatemp_list->SubTotal->getViewValue() ?></span>
</span>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$datatemp_list->ListOptions->render("body", "right", $datatemp_list->RowCount);
?>
	</tr>
<?php if ($datatemp->RowType == ROWTYPE_ADD || $datatemp->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fdatatemplist", "load"], function() {
	fdatatemplist.updateLists(<?php echo $datatemp_list->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$datatemp_list->isGridAdd())
		if (!$datatemp_list->Recordset->EOF)
			$datatemp_list->Recordset->moveNext();
}
?>
<?php
	if ($datatemp_list->isGridAdd() || $datatemp_list->isGridEdit()) {
		$datatemp_list->RowIndex = '$rowindex$';
		$datatemp_list->loadRowValues();

		// Set row properties
		$datatemp->resetAttributes();
		$datatemp->RowAttrs->merge(["data-rowindex" => $datatemp_list->RowIndex, "id" => "r0_datatemp", "data-rowtype" => ROWTYPE_ADD]);
		$datatemp->RowAttrs->appendClass("ew-template");
		$datatemp->RowType = ROWTYPE_ADD;

		// Render row
		$datatemp_list->renderRow();

		// Render list options
		$datatemp_list->renderListOptions();
		$datatemp_list->StartRowCount = 0;
?>
	<tr <?php echo $datatemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$datatemp_list->ListOptions->render("body", "left", $datatemp_list->RowIndex);
?>
	<?php if ($datatemp_list->iddt->Visible) { // iddt ?>
		<td data-name="iddt">
<span id="el$rowindex$_datatemp_iddt" class="form-group datatemp_iddt"></span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="o<?php echo $datatemp_list->RowIndex ?>_iddt" id="o<?php echo $datatemp_list->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_list->iddt->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->datejob->Visible) { // datejob ?>
		<td data-name="datejob">
<span id="el$rowindex$_datatemp_datejob" class="form-group datatemp_datejob">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x<?php echo $datatemp_list->RowIndex ?>_datejob" id="x<?php echo $datatemp_list->RowIndex ?>_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_list->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->datejob->EditValue ?>"<?php echo $datatemp_list->datejob->editAttributes() ?>>
<?php if (!$datatemp_list->datejob->ReadOnly && !$datatemp_list->datejob->Disabled && !isset($datatemp_list->datejob->EditAttrs["readonly"]) && !isset($datatemp_list->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatemplist", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatemplist", "x<?php echo $datatemp_list->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="o<?php echo $datatemp_list->RowIndex ?>_datejob" id="o<?php echo $datatemp_list->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_list->datejob->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<span id="el$rowindex$_datatemp_idemp" class="form-group datatemp_idemp">
<?php $datatemp_list->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $datatemp_list->RowIndex ?>_idemp"><?php echo EmptyValue(strval($datatemp_list->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_list->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_list->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_list->idemp->ReadOnly || $datatemp_list->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $datatemp_list->RowIndex ?>_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_list->idemp->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_list->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_idemp" id="x<?php echo $datatemp_list->RowIndex ?>_idemp" value="<?php echo $datatemp_list->idemp->CurrentValue ?>"<?php echo $datatemp_list->idemp->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="o<?php echo $datatemp_list->RowIndex ?>_idemp" id="o<?php echo $datatemp_list->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_list->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->dept->Visible) { // dept ?>
		<td data-name="dept">
<span id="el$rowindex$_datatemp_dept" class="form-group datatemp_dept">
<?php
$onchange = $datatemp_list->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_list->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_list->RowIndex ?>_dept">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_list->RowIndex ?>_dept" id="sv_x<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo RemoveHtml($datatemp_list->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_list->dept->getPlaceHolder()) ?>"<?php echo $datatemp_list->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_list->dept->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_dept" id="x<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_list->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatemplist"], function() {
	fdatatemplist.createAutoSuggest({"id":"x<?php echo $datatemp_list->RowIndex ?>_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_list->dept->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_dept") ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="o<?php echo $datatemp_list->RowIndex ?>_dept" id="o<?php echo $datatemp_list->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_list->dept->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->type->Visible) { // type ?>
		<td data-name="type">
<span id="el$rowindex$_datatemp_type" class="form-group datatemp_type">
<?php
$onchange = $datatemp_list->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_list->type->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_list->RowIndex ?>_type">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_list->RowIndex ?>_type" id="sv_x<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo RemoveHtml($datatemp_list->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_list->type->getPlaceHolder()) ?>"<?php echo $datatemp_list->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_list->type->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_list->RowIndex ?>_type" id="x<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_list->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatemplist"], function() {
	fdatatemplist.createAutoSuggest({"id":"x<?php echo $datatemp_list->RowIndex ?>_type","forceSelect":false});
});
</script>
<?php echo $datatemp_list->type->Lookup->getParamTag($datatemp_list, "p_x" . $datatemp_list->RowIndex . "_type") ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" name="o<?php echo $datatemp_list->RowIndex ?>_type" id="o<?php echo $datatemp_list->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_list->type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur">
<span id="el$rowindex$_datatemp_nbrheur" class="form-group datatemp_nbrheur">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_list->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_list->RowIndex ?>_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_list->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->nbrheur->EditValue ?>"<?php echo $datatemp_list->nbrheur->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="o<?php echo $datatemp_list->RowIndex ?>_nbrheur" id="o<?php echo $datatemp_list->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_list->nbrheur->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh">
<span id="el$rowindex$_datatemp_tauxh" class="form-group datatemp_tauxh">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_list->RowIndex ?>_tauxh" id="x<?php echo $datatemp_list->RowIndex ?>_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_list->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->tauxh->EditValue ?>"<?php echo $datatemp_list->tauxh->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="o<?php echo $datatemp_list->RowIndex ?>_tauxh" id="o<?php echo $datatemp_list->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_list->tauxh->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_list->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal">
<span id="el$rowindex$_datatemp_SubTotal" class="form-group datatemp_SubTotal">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_list->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_list->RowIndex ?>_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_list->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_list->SubTotal->EditValue ?>"<?php echo $datatemp_list->SubTotal->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="o<?php echo $datatemp_list->RowIndex ?>_SubTotal" id="o<?php echo $datatemp_list->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_list->SubTotal->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$datatemp_list->ListOptions->render("body", "right", $datatemp_list->RowIndex);
?>
<script>
loadjs.ready(["fdatatemplist", "load"], function() {
	fdatatemplist.updateLists(<?php echo $datatemp_list->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
<?php

// Render aggregate row
$datatemp->RowType = ROWTYPE_AGGREGATE;
$datatemp->resetAttributes();
$datatemp_list->renderRow();
?>
<?php if ($datatemp_list->TotalRecords > 0 && !$datatemp_list->isGridAdd() && !$datatemp_list->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$datatemp_list->renderListOptions();

// Render list options (footer, left)
$datatemp_list->ListOptions->render("footer", "left");
?>
	<?php if ($datatemp_list->iddt->Visible) { // iddt ?>
		<td data-name="iddt" class="<?php echo $datatemp_list->iddt->footerCellClass() ?>"><span id="elf_datatemp_iddt" class="datatemp_iddt">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->datejob->Visible) { // datejob ?>
		<td data-name="datejob" class="<?php echo $datatemp_list->datejob->footerCellClass() ?>"><span id="elf_datatemp_datejob" class="datatemp_datejob">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->idemp->Visible) { // idemp ?>
		<td data-name="idemp" class="<?php echo $datatemp_list->idemp->footerCellClass() ?>"><span id="elf_datatemp_idemp" class="datatemp_idemp">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $datatemp_list->idemp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->dept->Visible) { // dept ?>
		<td data-name="dept" class="<?php echo $datatemp_list->dept->footerCellClass() ?>"><span id="elf_datatemp_dept" class="datatemp_dept">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $datatemp_list->type->footerCellClass() ?>"><span id="elf_datatemp_type" class="datatemp_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur" class="<?php echo $datatemp_list->nbrheur->footerCellClass() ?>"><span id="elf_datatemp_nbrheur" class="datatemp_nbrheur">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh" class="<?php echo $datatemp_list->tauxh->footerCellClass() ?>"><span id="elf_datatemp_tauxh" class="datatemp_tauxh">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_list->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" class="<?php echo $datatemp_list->SubTotal->footerCellClass() ?>"><span id="elf_datatemp_SubTotal" class="datatemp_SubTotal">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $datatemp_list->SubTotal->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$datatemp_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($datatemp_list->isGridAdd()) { ?>
<input type="hidden" name="action" id="action" value="gridinsert">
<input type="hidden" name="<?php echo $datatemp_list->FormKeyCountName ?>" id="<?php echo $datatemp_list->FormKeyCountName ?>" value="<?php echo $datatemp_list->KeyCount ?>">
<?php echo $datatemp_list->MultiSelectKey ?>
<?php } ?>
<?php if ($datatemp_list->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<input type="hidden" name="<?php echo $datatemp_list->FormKeyCountName ?>" id="<?php echo $datatemp_list->FormKeyCountName ?>" value="<?php echo $datatemp_list->KeyCount ?>">
<?php echo $datatemp_list->MultiSelectKey ?>
<?php } ?>
<?php if (!$datatemp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($datatemp_list->Recordset)
	$datatemp_list->Recordset->Close();
?>
<?php if (!$datatemp_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$datatemp_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $datatemp_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $datatemp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($datatemp_list->TotalRecords == 0 && !$datatemp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $datatemp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$datatemp_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$datatemp_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

	$("div.form-control.ew-lookup-text").css("min-width", "15em");
});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$datatemp_list->terminate();
?>