<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Write header
WriteHeader(FALSE);

// Create page object
if (!isset($datatemp_grid))
	$datatemp_grid = new datatemp_grid();

// Run the page
$datatemp_grid->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$datatemp_grid->Page_Render();
?>
<?php if (!$datatemp_grid->isExport()) { ?>
<script>
var fdatatempgrid, currentPageID;
loadjs.ready("head", function() {

	// Form object
	fdatatempgrid = new ew.Form("fdatatempgrid", "grid");
	fdatatempgrid.formKeyCountName = '<?php echo $datatemp_grid->FormKeyCountName ?>';

	// Validate form
	fdatatempgrid.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			var checkrow = (gridinsert) ? !this.emptyRow(infix) : true;
			if (checkrow) {
				addcnt++;
			<?php if ($datatemp_grid->iddt->Required) { ?>
				elm = this.getElements("x" + infix + "_iddt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->iddt->caption(), $datatemp_grid->iddt->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_grid->datejob->Required) { ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->datejob->caption(), $datatemp_grid->datejob->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_grid->datejob->errorMessage()) ?>");
			<?php if ($datatemp_grid->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->idemp->caption(), $datatemp_grid->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_grid->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->dept->caption(), $datatemp_grid->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_grid->dept->errorMessage()) ?>");
			<?php if ($datatemp_grid->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->type->caption(), $datatemp_grid->type->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_grid->type->errorMessage()) ?>");
			<?php if ($datatemp_grid->nbrheur->Required) { ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->nbrheur->caption(), $datatemp_grid->nbrheur->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_grid->nbrheur->errorMessage()) ?>");
			<?php if ($datatemp_grid->tauxh->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->tauxh->caption(), $datatemp_grid->tauxh->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_grid->tauxh->errorMessage()) ?>");
			<?php if ($datatemp_grid->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_grid->SubTotal->caption(), $datatemp_grid->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_grid->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
			} // End Grid Add checking
		}
		return true;
	}

	// Check empty row
	fdatatempgrid.emptyRow = function(infix) {
		var fobj = this._form;
		if (ew.valueChanged(fobj, infix, "datejob", false)) return false;
		if (ew.valueChanged(fobj, infix, "idemp", false)) return false;
		if (ew.valueChanged(fobj, infix, "dept", false)) return false;
		if (ew.valueChanged(fobj, infix, "type", false)) return false;
		if (ew.valueChanged(fobj, infix, "nbrheur", false)) return false;
		if (ew.valueChanged(fobj, infix, "tauxh", false)) return false;
		if (ew.valueChanged(fobj, infix, "SubTotal", false)) return false;
		return true;
	}

	// Form_CustomValidate
	fdatatempgrid.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdatatempgrid.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdatatempgrid.lists["x_idemp"] = <?php echo $datatemp_grid->idemp->Lookup->toClientList($datatemp_grid) ?>;
	fdatatempgrid.lists["x_idemp"].options = <?php echo JsonEncode($datatemp_grid->idemp->lookupOptions()) ?>;
	fdatatempgrid.lists["x_dept"] = <?php echo $datatemp_grid->dept->Lookup->toClientList($datatemp_grid) ?>;
	fdatatempgrid.lists["x_dept"].options = <?php echo JsonEncode($datatemp_grid->dept->lookupOptions()) ?>;
	fdatatempgrid.autoSuggests["x_dept"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	fdatatempgrid.lists["x_type"] = <?php echo $datatemp_grid->type->Lookup->toClientList($datatemp_grid) ?>;
	fdatatempgrid.lists["x_type"].options = <?php echo JsonEncode($datatemp_grid->type->lookupOptions()) ?>;
	fdatatempgrid.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	loadjs.done("fdatatempgrid");
});
</script>
<?php } ?>
<?php
$datatemp_grid->renderOtherOptions();
?>
<?php if ($datatemp_grid->TotalRecords > 0 || $datatemp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($datatemp_grid->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> datatemp">
<?php if ($datatemp_grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $datatemp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<div id="fdatatempgrid" class="ew-form ew-list-form form-inline">
<div id="gmp_datatemp" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<table id="tbl_datatempgrid" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$datatemp->RowType = ROWTYPE_HEADER;

// Render list options
$datatemp_grid->renderListOptions();

// Render list options (header, left)
$datatemp_grid->ListOptions->render("header", "left");
?>
<?php if ($datatemp_grid->iddt->Visible) { // iddt ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->iddt) == "") { ?>
		<th data-name="iddt" class="<?php echo $datatemp_grid->iddt->headerCellClass() ?>" style="width: 4px;"><div id="elh_datatemp_iddt" class="datatemp_iddt"><div class="ew-table-header-caption"><?php echo $datatemp_grid->iddt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="iddt" class="<?php echo $datatemp_grid->iddt->headerCellClass() ?>" style="width: 4px;"><div><div id="elh_datatemp_iddt" class="datatemp_iddt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->iddt->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->iddt->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->iddt->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->datejob->Visible) { // datejob ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->datejob) == "") { ?>
		<th data-name="datejob" class="<?php echo $datatemp_grid->datejob->headerCellClass() ?>" style="width: 8px;"><div id="elh_datatemp_datejob" class="datatemp_datejob"><div class="ew-table-header-caption"><?php echo $datatemp_grid->datejob->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datejob" class="<?php echo $datatemp_grid->datejob->headerCellClass() ?>" style="width: 8px;"><div><div id="elh_datatemp_datejob" class="datatemp_datejob">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->datejob->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->datejob->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->datejob->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->idemp->Visible) { // idemp ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->idemp) == "") { ?>
		<th data-name="idemp" class="<?php echo $datatemp_grid->idemp->headerCellClass() ?>"><div id="elh_datatemp_idemp" class="datatemp_idemp"><div class="ew-table-header-caption"><?php echo $datatemp_grid->idemp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="idemp" class="<?php echo $datatemp_grid->idemp->headerCellClass() ?>"><div><div id="elh_datatemp_idemp" class="datatemp_idemp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->idemp->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->idemp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->idemp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->dept->Visible) { // dept ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->dept) == "") { ?>
		<th data-name="dept" class="<?php echo $datatemp_grid->dept->headerCellClass() ?>" style="width: 30px;"><div id="elh_datatemp_dept" class="datatemp_dept"><div class="ew-table-header-caption"><?php echo $datatemp_grid->dept->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dept" class="<?php echo $datatemp_grid->dept->headerCellClass() ?>" style="width: 30px;"><div><div id="elh_datatemp_dept" class="datatemp_dept">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->dept->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->dept->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->dept->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->type->Visible) { // type ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->type) == "") { ?>
		<th data-name="type" class="<?php echo $datatemp_grid->type->headerCellClass() ?>" style="width: 1px;"><div id="elh_datatemp_type" class="datatemp_type"><div class="ew-table-header-caption"><?php echo $datatemp_grid->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $datatemp_grid->type->headerCellClass() ?>" style="width: 1px;"><div><div id="elh_datatemp_type" class="datatemp_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->type->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->type->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->nbrheur->Visible) { // nbrheur ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->nbrheur) == "") { ?>
		<th data-name="nbrheur" class="<?php echo $datatemp_grid->nbrheur->headerCellClass() ?>" style="width: 2px;"><div id="elh_datatemp_nbrheur" class="datatemp_nbrheur"><div class="ew-table-header-caption"><?php echo $datatemp_grid->nbrheur->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nbrheur" class="<?php echo $datatemp_grid->nbrheur->headerCellClass() ?>" style="width: 2px;"><div><div id="elh_datatemp_nbrheur" class="datatemp_nbrheur">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->nbrheur->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->nbrheur->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->nbrheur->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->tauxh->Visible) { // tauxh ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->tauxh) == "") { ?>
		<th data-name="tauxh" class="<?php echo $datatemp_grid->tauxh->headerCellClass() ?>" style="width: 5px;"><div id="elh_datatemp_tauxh" class="datatemp_tauxh"><div class="ew-table-header-caption"><?php echo $datatemp_grid->tauxh->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tauxh" class="<?php echo $datatemp_grid->tauxh->headerCellClass() ?>" style="width: 5px;"><div><div id="elh_datatemp_tauxh" class="datatemp_tauxh">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->tauxh->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->tauxh->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->tauxh->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($datatemp_grid->SubTotal->Visible) { // SubTotal ?>
	<?php if ($datatemp_grid->SortUrl($datatemp_grid->SubTotal) == "") { ?>
		<th data-name="SubTotal" class="<?php echo $datatemp_grid->SubTotal->headerCellClass() ?>" style="width: 5px;"><div id="elh_datatemp_SubTotal" class="datatemp_SubTotal"><div class="ew-table-header-caption"><?php echo $datatemp_grid->SubTotal->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="SubTotal" class="<?php echo $datatemp_grid->SubTotal->headerCellClass() ?>" style="width: 5px;"><div><div id="elh_datatemp_SubTotal" class="datatemp_SubTotal">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $datatemp_grid->SubTotal->caption() ?></span><span class="ew-table-header-sort"><?php if ($datatemp_grid->SubTotal->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($datatemp_grid->SubTotal->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$datatemp_grid->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
$datatemp_grid->StartRecord = 1;
$datatemp_grid->StopRecord = $datatemp_grid->TotalRecords; // Show all records

// Restore number of post back records
if ($CurrentForm && ($datatemp->isConfirm() || $datatemp_grid->EventCancelled)) {
	$CurrentForm->Index = -1;
	if ($CurrentForm->hasValue($datatemp_grid->FormKeyCountName) && ($datatemp_grid->isGridAdd() || $datatemp_grid->isGridEdit() || $datatemp->isConfirm())) {
		$datatemp_grid->KeyCount = $CurrentForm->getValue($datatemp_grid->FormKeyCountName);
		$datatemp_grid->StopRecord = $datatemp_grid->StartRecord + $datatemp_grid->KeyCount - 1;
	}
}
$datatemp_grid->RecordCount = $datatemp_grid->StartRecord - 1;
if ($datatemp_grid->Recordset && !$datatemp_grid->Recordset->EOF) {
	$datatemp_grid->Recordset->moveFirst();
	$selectLimit = $datatemp_grid->UseSelectLimit;
	if (!$selectLimit && $datatemp_grid->StartRecord > 1)
		$datatemp_grid->Recordset->move($datatemp_grid->StartRecord - 1);
} elseif (!$datatemp->AllowAddDeleteRow && $datatemp_grid->StopRecord == 0) {
	$datatemp_grid->StopRecord = $datatemp->GridAddRowCount;
}

// Initialize aggregate
$datatemp->RowType = ROWTYPE_AGGREGATEINIT;
$datatemp->resetAttributes();
$datatemp_grid->renderRow();
if ($datatemp_grid->isGridAdd())
	$datatemp_grid->RowIndex = 0;
if ($datatemp_grid->isGridEdit())
	$datatemp_grid->RowIndex = 0;
while ($datatemp_grid->RecordCount < $datatemp_grid->StopRecord) {
	$datatemp_grid->RecordCount++;
	if ($datatemp_grid->RecordCount >= $datatemp_grid->StartRecord) {
		$datatemp_grid->RowCount++;
		if ($datatemp_grid->isGridAdd() || $datatemp_grid->isGridEdit() || $datatemp->isConfirm()) {
			$datatemp_grid->RowIndex++;
			$CurrentForm->Index = $datatemp_grid->RowIndex;
			if ($CurrentForm->hasValue($datatemp_grid->FormActionName) && ($datatemp->isConfirm() || $datatemp_grid->EventCancelled))
				$datatemp_grid->RowAction = strval($CurrentForm->getValue($datatemp_grid->FormActionName));
			elseif ($datatemp_grid->isGridAdd())
				$datatemp_grid->RowAction = "insert";
			else
				$datatemp_grid->RowAction = "";
		}

		// Set up key count
		$datatemp_grid->KeyCount = $datatemp_grid->RowIndex;

		// Init row class and style
		$datatemp->resetAttributes();
		$datatemp->CssClass = "";
		if ($datatemp_grid->isGridAdd()) {
			if ($datatemp->CurrentMode == "copy") {
				$datatemp_grid->loadRowValues($datatemp_grid->Recordset); // Load row values
				$datatemp_grid->setRecordKey($datatemp_grid->RowOldKey, $datatemp_grid->Recordset); // Set old record key
			} else {
				$datatemp_grid->loadRowValues(); // Load default values
				$datatemp_grid->RowOldKey = ""; // Clear old key value
			}
		} else {
			$datatemp_grid->loadRowValues($datatemp_grid->Recordset); // Load row values
		}
		$datatemp->RowType = ROWTYPE_VIEW; // Render view
		if ($datatemp_grid->isGridAdd()) // Grid add
			$datatemp->RowType = ROWTYPE_ADD; // Render add
		if ($datatemp_grid->isGridAdd() && $datatemp->EventCancelled && !$CurrentForm->hasValue("k_blankrow")) // Insert failed
			$datatemp_grid->restoreCurrentRowFormValues($datatemp_grid->RowIndex); // Restore form values
		if ($datatemp_grid->isGridEdit()) { // Grid edit
			if ($datatemp->EventCancelled)
				$datatemp_grid->restoreCurrentRowFormValues($datatemp_grid->RowIndex); // Restore form values
			if ($datatemp_grid->RowAction == "insert")
				$datatemp->RowType = ROWTYPE_ADD; // Render add
			else
				$datatemp->RowType = ROWTYPE_EDIT; // Render edit
		}
		if ($datatemp_grid->isGridEdit() && ($datatemp->RowType == ROWTYPE_EDIT || $datatemp->RowType == ROWTYPE_ADD) && $datatemp->EventCancelled) // Update failed
			$datatemp_grid->restoreCurrentRowFormValues($datatemp_grid->RowIndex); // Restore form values
		if ($datatemp->RowType == ROWTYPE_EDIT) // Edit row
			$datatemp_grid->EditRowCount++;
		if ($datatemp->isConfirm()) // Confirm row
			$datatemp_grid->restoreCurrentRowFormValues($datatemp_grid->RowIndex); // Restore form values

		// Set up row id / data-rowindex
		$datatemp->RowAttrs->merge(["data-rowindex" => $datatemp_grid->RowCount, "id" => "r" . $datatemp_grid->RowCount . "_datatemp", "data-rowtype" => $datatemp->RowType]);

		// Render row
		$datatemp_grid->renderRow();

		// Render list options
		$datatemp_grid->renderListOptions();

		// Skip delete row / empty row for confirm page
		if ($datatemp_grid->RowAction != "delete" && $datatemp_grid->RowAction != "insertdelete" && !($datatemp_grid->RowAction == "insert" && $datatemp->isConfirm() && $datatemp_grid->emptyRow())) {
?>
	<tr <?php echo $datatemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$datatemp_grid->ListOptions->render("body", "left", $datatemp_grid->RowCount);
?>
	<?php if ($datatemp_grid->iddt->Visible) { // iddt ?>
		<td data-name="iddt" <?php echo $datatemp_grid->iddt->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_iddt" class="form-group"></span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="o<?php echo $datatemp_grid->RowIndex ?>_iddt" id="o<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_iddt" class="form-group">
<span<?php echo $datatemp_grid->iddt->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->iddt->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="x<?php echo $datatemp_grid->RowIndex ?>_iddt" id="x<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->CurrentValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_iddt">
<span<?php echo $datatemp_grid->iddt->viewAttributes() ?>><?php echo $datatemp_grid->iddt->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="x<?php echo $datatemp_grid->RowIndex ?>_iddt" id="x<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="o<?php echo $datatemp_grid->RowIndex ?>_iddt" id="o<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_iddt" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_iddt" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->datejob->Visible) { // datejob ?>
		<td data-name="datejob" <?php echo $datatemp_grid->datejob->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_datejob" class="form-group">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x<?php echo $datatemp_grid->RowIndex ?>_datejob" id="x<?php echo $datatemp_grid->RowIndex ?>_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_grid->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->datejob->EditValue ?>"<?php echo $datatemp_grid->datejob->editAttributes() ?>>
<?php if (!$datatemp_grid->datejob->ReadOnly && !$datatemp_grid->datejob->Disabled && !isset($datatemp_grid->datejob->EditAttrs["readonly"]) && !isset($datatemp_grid->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatempgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatempgrid", "x<?php echo $datatemp_grid->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="o<?php echo $datatemp_grid->RowIndex ?>_datejob" id="o<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_datejob" class="form-group">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x<?php echo $datatemp_grid->RowIndex ?>_datejob" id="x<?php echo $datatemp_grid->RowIndex ?>_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_grid->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->datejob->EditValue ?>"<?php echo $datatemp_grid->datejob->editAttributes() ?>>
<?php if (!$datatemp_grid->datejob->ReadOnly && !$datatemp_grid->datejob->Disabled && !isset($datatemp_grid->datejob->EditAttrs["readonly"]) && !isset($datatemp_grid->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatempgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatempgrid", "x<?php echo $datatemp_grid->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_datejob">
<span<?php echo $datatemp_grid->datejob->viewAttributes() ?>><?php echo $datatemp_grid->datejob->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="x<?php echo $datatemp_grid->RowIndex ?>_datejob" id="x<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="o<?php echo $datatemp_grid->RowIndex ?>_datejob" id="o<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_datejob" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_datejob" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" <?php echo $datatemp_grid->idemp->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_idemp" class="form-group">
<?php $datatemp_grid->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $datatemp_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($datatemp_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_grid->idemp->ReadOnly || $datatemp_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $datatemp_grid->RowIndex ?>_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_grid->idemp->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_idemp" id="x<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo $datatemp_grid->idemp->CurrentValue ?>"<?php echo $datatemp_grid->idemp->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="o<?php echo $datatemp_grid->RowIndex ?>_idemp" id="o<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_idemp" class="form-group">
<?php $datatemp_grid->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $datatemp_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($datatemp_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_grid->idemp->ReadOnly || $datatemp_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $datatemp_grid->RowIndex ?>_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_grid->idemp->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_idemp" id="x<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo $datatemp_grid->idemp->CurrentValue ?>"<?php echo $datatemp_grid->idemp->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_idemp">
<span<?php echo $datatemp_grid->idemp->viewAttributes() ?>><?php echo $datatemp_grid->idemp->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="x<?php echo $datatemp_grid->RowIndex ?>_idemp" id="x<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="o<?php echo $datatemp_grid->RowIndex ?>_idemp" id="o<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_idemp" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_idemp" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->dept->Visible) { // dept ?>
		<td data-name="dept" <?php echo $datatemp_grid->dept->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_dept" class="form-group">
<?php
$onchange = $datatemp_grid->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_grid->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_grid->RowIndex ?>_dept">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_grid->RowIndex ?>_dept" id="sv_x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo RemoveHtml($datatemp_grid->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_grid->dept->getPlaceHolder()) ?>"<?php echo $datatemp_grid->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_grid->dept->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_dept" id="x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempgrid"], function() {
	fdatatempgrid.createAutoSuggest({"id":"x<?php echo $datatemp_grid->RowIndex ?>_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_grid->dept->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_dept") ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="o<?php echo $datatemp_grid->RowIndex ?>_dept" id="o<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_dept" class="form-group">
<?php
$onchange = $datatemp_grid->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_grid->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_grid->RowIndex ?>_dept">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_grid->RowIndex ?>_dept" id="sv_x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo RemoveHtml($datatemp_grid->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_grid->dept->getPlaceHolder()) ?>"<?php echo $datatemp_grid->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_grid->dept->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_dept" id="x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempgrid"], function() {
	fdatatempgrid.createAutoSuggest({"id":"x<?php echo $datatemp_grid->RowIndex ?>_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_grid->dept->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_dept") ?>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_dept">
<span<?php echo $datatemp_grid->dept->viewAttributes() ?>><?php echo $datatemp_grid->dept->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="x<?php echo $datatemp_grid->RowIndex ?>_dept" id="x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_dept" name="o<?php echo $datatemp_grid->RowIndex ?>_dept" id="o<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_dept" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_dept" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_dept" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->type->Visible) { // type ?>
		<td data-name="type" <?php echo $datatemp_grid->type->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_type" class="form-group">
<?php
$onchange = $datatemp_grid->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_grid->type->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_grid->RowIndex ?>_type">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_grid->RowIndex ?>_type" id="sv_x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo RemoveHtml($datatemp_grid->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_grid->type->getPlaceHolder()) ?>"<?php echo $datatemp_grid->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_grid->type->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_type" id="x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempgrid"], function() {
	fdatatempgrid.createAutoSuggest({"id":"x<?php echo $datatemp_grid->RowIndex ?>_type","forceSelect":false});
});
</script>
<?php echo $datatemp_grid->type->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_type") ?>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" name="o<?php echo $datatemp_grid->RowIndex ?>_type" id="o<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_type" class="form-group">
<?php
$onchange = $datatemp_grid->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_grid->type->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_grid->RowIndex ?>_type">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_grid->RowIndex ?>_type" id="sv_x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo RemoveHtml($datatemp_grid->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_grid->type->getPlaceHolder()) ?>"<?php echo $datatemp_grid->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_grid->type->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_type" id="x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempgrid"], function() {
	fdatatempgrid.createAutoSuggest({"id":"x<?php echo $datatemp_grid->RowIndex ?>_type","forceSelect":false});
});
</script>
<?php echo $datatemp_grid->type->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_type") ?>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_type">
<span<?php echo $datatemp_grid->type->viewAttributes() ?>><?php echo $datatemp_grid->type->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_type" name="x<?php echo $datatemp_grid->RowIndex ?>_type" id="x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_type" name="o<?php echo $datatemp_grid->RowIndex ?>_type" id="o<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_type" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_type" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_type" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_type" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur" <?php echo $datatemp_grid->nbrheur->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_nbrheur" class="form-group">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->nbrheur->EditValue ?>"<?php echo $datatemp_grid->nbrheur->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_nbrheur" class="form-group">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->nbrheur->EditValue ?>"<?php echo $datatemp_grid->nbrheur->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_nbrheur">
<span<?php echo $datatemp_grid->nbrheur->viewAttributes() ?>><?php echo $datatemp_grid->nbrheur->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh" <?php echo $datatemp_grid->tauxh->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_tauxh" class="form-group">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_grid->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->tauxh->EditValue ?>"<?php echo $datatemp_grid->tauxh->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="o<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="o<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_tauxh" class="form-group">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_grid->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->tauxh->EditValue ?>"<?php echo $datatemp_grid->tauxh->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_tauxh">
<span<?php echo $datatemp_grid->tauxh->viewAttributes() ?>><?php echo $datatemp_grid->tauxh->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="o<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="o<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
	<?php if ($datatemp_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" <?php echo $datatemp_grid->SubTotal->cellAttributes() ?>>
<?php if ($datatemp->RowType == ROWTYPE_ADD) { // Add record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_SubTotal" class="form-group">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->SubTotal->EditValue ?>"<?php echo $datatemp_grid->SubTotal->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->OldValue) ?>">
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_EDIT) { // Edit record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_SubTotal" class="form-group">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->SubTotal->EditValue ?>"<?php echo $datatemp_grid->SubTotal->editAttributes() ?>>
</span>
<?php } ?>
<?php if ($datatemp->RowType == ROWTYPE_VIEW) { // View record ?>
<span id="el<?php echo $datatemp_grid->RowCount ?>_datatemp_SubTotal">
<span<?php echo $datatemp_grid->SubTotal->viewAttributes() ?>><?php echo $datatemp_grid->SubTotal->getViewValue() ?></span>
</span>
<?php if (!$datatemp->isConfirm()) { ?>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->OldValue) ?>">
<?php } else { ?>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="fdatatempgrid$x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->FormValue) ?>">
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="fdatatempgrid$o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$datatemp_grid->ListOptions->render("body", "right", $datatemp_grid->RowCount);
?>
	</tr>
<?php if ($datatemp->RowType == ROWTYPE_ADD || $datatemp->RowType == ROWTYPE_EDIT) { ?>
<script>
loadjs.ready(["fdatatempgrid", "load"], function() {
	fdatatempgrid.updateLists(<?php echo $datatemp_grid->RowIndex ?>);
});
</script>
<?php } ?>
<?php
	}
	} // End delete row checking
	if (!$datatemp_grid->isGridAdd() || $datatemp->CurrentMode == "copy")
		if (!$datatemp_grid->Recordset->EOF)
			$datatemp_grid->Recordset->moveNext();
}
?>
<?php
	if ($datatemp->CurrentMode == "add" || $datatemp->CurrentMode == "copy" || $datatemp->CurrentMode == "edit") {
		$datatemp_grid->RowIndex = '$rowindex$';
		$datatemp_grid->loadRowValues();

		// Set row properties
		$datatemp->resetAttributes();
		$datatemp->RowAttrs->merge(["data-rowindex" => $datatemp_grid->RowIndex, "id" => "r0_datatemp", "data-rowtype" => ROWTYPE_ADD]);
		$datatemp->RowAttrs->appendClass("ew-template");
		$datatemp->RowType = ROWTYPE_ADD;

		// Render row
		$datatemp_grid->renderRow();

		// Render list options
		$datatemp_grid->renderListOptions();
		$datatemp_grid->StartRowCount = 0;
?>
	<tr <?php echo $datatemp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$datatemp_grid->ListOptions->render("body", "left", $datatemp_grid->RowIndex);
?>
	<?php if ($datatemp_grid->iddt->Visible) { // iddt ?>
		<td data-name="iddt">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_iddt" class="form-group datatemp_iddt"></span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_iddt" class="form-group datatemp_iddt">
<span<?php echo $datatemp_grid->iddt->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->iddt->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="x<?php echo $datatemp_grid->RowIndex ?>_iddt" id="x<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="o<?php echo $datatemp_grid->RowIndex ?>_iddt" id="o<?php echo $datatemp_grid->RowIndex ?>_iddt" value="<?php echo HtmlEncode($datatemp_grid->iddt->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->datejob->Visible) { // datejob ?>
		<td data-name="datejob">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_datejob" class="form-group datatemp_datejob">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x<?php echo $datatemp_grid->RowIndex ?>_datejob" id="x<?php echo $datatemp_grid->RowIndex ?>_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_grid->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->datejob->EditValue ?>"<?php echo $datatemp_grid->datejob->editAttributes() ?>>
<?php if (!$datatemp_grid->datejob->ReadOnly && !$datatemp_grid->datejob->Disabled && !isset($datatemp_grid->datejob->EditAttrs["readonly"]) && !isset($datatemp_grid->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatempgrid", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatempgrid", "x<?php echo $datatemp_grid->RowIndex ?>_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_datejob" class="form-group datatemp_datejob">
<span<?php echo $datatemp_grid->datejob->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->datejob->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="x<?php echo $datatemp_grid->RowIndex ?>_datejob" id="x<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_datejob" name="o<?php echo $datatemp_grid->RowIndex ?>_datejob" id="o<?php echo $datatemp_grid->RowIndex ?>_datejob" value="<?php echo HtmlEncode($datatemp_grid->datejob->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_idemp" class="form-group datatemp_idemp">
<?php $datatemp_grid->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x<?php echo $datatemp_grid->RowIndex ?>_idemp"><?php echo EmptyValue(strval($datatemp_grid->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_grid->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_grid->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_grid->idemp->ReadOnly || $datatemp_grid->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x<?php echo $datatemp_grid->RowIndex ?>_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_grid->idemp->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_grid->idemp->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_idemp" id="x<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo $datatemp_grid->idemp->CurrentValue ?>"<?php echo $datatemp_grid->idemp->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_idemp" class="form-group datatemp_idemp">
<span<?php echo $datatemp_grid->idemp->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->idemp->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="x<?php echo $datatemp_grid->RowIndex ?>_idemp" id="x<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" name="o<?php echo $datatemp_grid->RowIndex ?>_idemp" id="o<?php echo $datatemp_grid->RowIndex ?>_idemp" value="<?php echo HtmlEncode($datatemp_grid->idemp->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->dept->Visible) { // dept ?>
		<td data-name="dept">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_dept" class="form-group datatemp_dept">
<?php
$onchange = $datatemp_grid->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_grid->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_grid->RowIndex ?>_dept">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_grid->RowIndex ?>_dept" id="sv_x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo RemoveHtml($datatemp_grid->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_grid->dept->getPlaceHolder()) ?>"<?php echo $datatemp_grid->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_grid->dept->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_dept" id="x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempgrid"], function() {
	fdatatempgrid.createAutoSuggest({"id":"x<?php echo $datatemp_grid->RowIndex ?>_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_grid->dept->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_dept") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_dept" class="form-group datatemp_dept">
<span<?php echo $datatemp_grid->dept->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->dept->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="x<?php echo $datatemp_grid->RowIndex ?>_dept" id="x<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_dept" name="o<?php echo $datatemp_grid->RowIndex ?>_dept" id="o<?php echo $datatemp_grid->RowIndex ?>_dept" value="<?php echo HtmlEncode($datatemp_grid->dept->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->type->Visible) { // type ?>
		<td data-name="type">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_type" class="form-group datatemp_type">
<?php
$onchange = $datatemp_grid->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_grid->type->EditAttrs["onchange"] = "";
?>
<span id="as_x<?php echo $datatemp_grid->RowIndex ?>_type">
	<input type="text" class="form-control" name="sv_x<?php echo $datatemp_grid->RowIndex ?>_type" id="sv_x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo RemoveHtml($datatemp_grid->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_grid->type->getPlaceHolder()) ?>"<?php echo $datatemp_grid->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_grid->type->displayValueSeparatorAttribute() ?>" name="x<?php echo $datatemp_grid->RowIndex ?>_type" id="x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempgrid"], function() {
	fdatatempgrid.createAutoSuggest({"id":"x<?php echo $datatemp_grid->RowIndex ?>_type","forceSelect":false});
});
</script>
<?php echo $datatemp_grid->type->Lookup->getParamTag($datatemp_grid, "p_x" . $datatemp_grid->RowIndex . "_type") ?>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_type" class="form-group datatemp_type">
<span<?php echo $datatemp_grid->type->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->type->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" name="x<?php echo $datatemp_grid->RowIndex ?>_type" id="x<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_type" name="o<?php echo $datatemp_grid->RowIndex ?>_type" id="o<?php echo $datatemp_grid->RowIndex ?>_type" value="<?php echo HtmlEncode($datatemp_grid->type->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_nbrheur" class="form-group datatemp_nbrheur">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_grid->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->nbrheur->EditValue ?>"<?php echo $datatemp_grid->nbrheur->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_nbrheur" class="form-group datatemp_nbrheur">
<span<?php echo $datatemp_grid->nbrheur->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->nbrheur->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="x<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_nbrheur" name="o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" id="o<?php echo $datatemp_grid->RowIndex ?>_nbrheur" value="<?php echo HtmlEncode($datatemp_grid->nbrheur->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_tauxh" class="form-group datatemp_tauxh">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_grid->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->tauxh->EditValue ?>"<?php echo $datatemp_grid->tauxh->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_tauxh" class="form-group datatemp_tauxh">
<span<?php echo $datatemp_grid->tauxh->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->tauxh->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="x<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_tauxh" name="o<?php echo $datatemp_grid->RowIndex ?>_tauxh" id="o<?php echo $datatemp_grid->RowIndex ?>_tauxh" value="<?php echo HtmlEncode($datatemp_grid->tauxh->OldValue) ?>">
</td>
	<?php } ?>
	<?php if ($datatemp_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal">
<?php if (!$datatemp->isConfirm()) { ?>
<span id="el$rowindex$_datatemp_SubTotal" class="form-group datatemp_SubTotal">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_grid->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_grid->SubTotal->EditValue ?>"<?php echo $datatemp_grid->SubTotal->editAttributes() ?>>
</span>
<?php } else { ?>
<span id="el$rowindex$_datatemp_SubTotal" class="form-group datatemp_SubTotal">
<span<?php echo $datatemp_grid->SubTotal->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_grid->SubTotal->ViewValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="x<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->FormValue) ?>">
<?php } ?>
<input type="hidden" data-table="datatemp" data-field="x_SubTotal" name="o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" id="o<?php echo $datatemp_grid->RowIndex ?>_SubTotal" value="<?php echo HtmlEncode($datatemp_grid->SubTotal->OldValue) ?>">
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$datatemp_grid->ListOptions->render("body", "right", $datatemp_grid->RowIndex);
?>
<script>
loadjs.ready(["fdatatempgrid", "load"], function() {
	fdatatempgrid.updateLists(<?php echo $datatemp_grid->RowIndex ?>);
});
</script>
	</tr>
<?php
	}
?>
</tbody>
<?php

// Render aggregate row
$datatemp->RowType = ROWTYPE_AGGREGATE;
$datatemp->resetAttributes();
$datatemp_grid->renderRow();
?>
<?php if ($datatemp_grid->TotalRecords > 0 && $datatemp->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$datatemp_grid->renderListOptions();

// Render list options (footer, left)
$datatemp_grid->ListOptions->render("footer", "left");
?>
	<?php if ($datatemp_grid->iddt->Visible) { // iddt ?>
		<td data-name="iddt" class="<?php echo $datatemp_grid->iddt->footerCellClass() ?>"><span id="elf_datatemp_iddt" class="datatemp_iddt">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->datejob->Visible) { // datejob ?>
		<td data-name="datejob" class="<?php echo $datatemp_grid->datejob->footerCellClass() ?>"><span id="elf_datatemp_datejob" class="datatemp_datejob">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->idemp->Visible) { // idemp ?>
		<td data-name="idemp" class="<?php echo $datatemp_grid->idemp->footerCellClass() ?>"><span id="elf_datatemp_idemp" class="datatemp_idemp">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $datatemp_grid->idemp->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->dept->Visible) { // dept ?>
		<td data-name="dept" class="<?php echo $datatemp_grid->dept->footerCellClass() ?>"><span id="elf_datatemp_dept" class="datatemp_dept">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->type->Visible) { // type ?>
		<td data-name="type" class="<?php echo $datatemp_grid->type->footerCellClass() ?>"><span id="elf_datatemp_type" class="datatemp_type">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->nbrheur->Visible) { // nbrheur ?>
		<td data-name="nbrheur" class="<?php echo $datatemp_grid->nbrheur->footerCellClass() ?>"><span id="elf_datatemp_nbrheur" class="datatemp_nbrheur">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->tauxh->Visible) { // tauxh ?>
		<td data-name="tauxh" class="<?php echo $datatemp_grid->tauxh->footerCellClass() ?>"><span id="elf_datatemp_tauxh" class="datatemp_tauxh">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($datatemp_grid->SubTotal->Visible) { // SubTotal ?>
		<td data-name="SubTotal" class="<?php echo $datatemp_grid->SubTotal->footerCellClass() ?>"><span id="elf_datatemp_SubTotal" class="datatemp_SubTotal">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $datatemp_grid->SubTotal->ViewValue ?></span>
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$datatemp_grid->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
</div><!-- /.ew-grid-middle-panel -->
<?php if ($datatemp->CurrentMode == "add" || $datatemp->CurrentMode == "copy") { ?>
<input type="hidden" name="<?php echo $datatemp_grid->FormKeyCountName ?>" id="<?php echo $datatemp_grid->FormKeyCountName ?>" value="<?php echo $datatemp_grid->KeyCount ?>">
<?php echo $datatemp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($datatemp->CurrentMode == "edit") { ?>
<input type="hidden" name="<?php echo $datatemp_grid->FormKeyCountName ?>" id="<?php echo $datatemp_grid->FormKeyCountName ?>" value="<?php echo $datatemp_grid->KeyCount ?>">
<?php echo $datatemp_grid->MultiSelectKey ?>
<?php } ?>
<?php if ($datatemp->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fdatatempgrid">
</div><!-- /.ew-list-form -->
<?php

// Close recordset
if ($datatemp_grid->Recordset)
	$datatemp_grid->Recordset->Close();
?>
<?php if ($datatemp_grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $datatemp_grid->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($datatemp_grid->TotalRecords == 0 && !$datatemp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $datatemp_grid->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php if (!$datatemp_grid->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

	$("div.form-control.ew-lookup-text").css("min-width", "15em");
});
</script>
<?php } ?>
<?php
$datatemp_grid->terminate();
?>