<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$datatemp_edit = new datatemp_edit();

// Run the page
$datatemp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$datatemp_edit->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdatatempedit, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "edit";
	fdatatempedit = currentForm = new ew.Form("fdatatempedit", "edit");

	// Validate form
	fdatatempedit.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($datatemp_edit->iddt->Required) { ?>
				elm = this.getElements("x" + infix + "_iddt");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->iddt->caption(), $datatemp_edit->iddt->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_edit->datejob->Required) { ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->datejob->caption(), $datatemp_edit->datejob->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_edit->datejob->errorMessage()) ?>");
			<?php if ($datatemp_edit->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->idemp->caption(), $datatemp_edit->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_edit->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->dept->caption(), $datatemp_edit->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_edit->dept->errorMessage()) ?>");
			<?php if ($datatemp_edit->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->type->caption(), $datatemp_edit->type->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_edit->type->errorMessage()) ?>");
			<?php if ($datatemp_edit->nbrheur->Required) { ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->nbrheur->caption(), $datatemp_edit->nbrheur->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_edit->nbrheur->errorMessage()) ?>");
			<?php if ($datatemp_edit->tauxh->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->tauxh->caption(), $datatemp_edit->tauxh->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_edit->tauxh->errorMessage()) ?>");
			<?php if ($datatemp_edit->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_edit->SubTotal->caption(), $datatemp_edit->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_edit->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdatatempedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdatatempedit.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdatatempedit.lists["x_idemp"] = <?php echo $datatemp_edit->idemp->Lookup->toClientList($datatemp_edit) ?>;
	fdatatempedit.lists["x_idemp"].options = <?php echo JsonEncode($datatemp_edit->idemp->lookupOptions()) ?>;
	fdatatempedit.lists["x_dept"] = <?php echo $datatemp_edit->dept->Lookup->toClientList($datatemp_edit) ?>;
	fdatatempedit.lists["x_dept"].options = <?php echo JsonEncode($datatemp_edit->dept->lookupOptions()) ?>;
	fdatatempedit.autoSuggests["x_dept"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	fdatatempedit.lists["x_type"] = <?php echo $datatemp_edit->type->Lookup->toClientList($datatemp_edit) ?>;
	fdatatempedit.lists["x_type"].options = <?php echo JsonEncode($datatemp_edit->type->lookupOptions()) ?>;
	fdatatempedit.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	loadjs.done("fdatatempedit");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $datatemp_edit->showPageHeader(); ?>
<?php
$datatemp_edit->showMessage();
?>
<form name="fdatatempedit" id="fdatatempedit" class="<?php echo $datatemp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="datatemp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$datatemp_edit->IsModal ?>">
<?php if ($datatemp->getCurrentMasterTable() == "attendance") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="attendance">
<input type="hidden" name="fk_idatt" value="<?php echo HtmlEncode($datatemp_edit->idatt->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($datatemp_edit->iddt->Visible) { // iddt ?>
	<div id="r_iddt" class="form-group row">
		<label id="elh_datatemp_iddt" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->iddt->caption() ?><?php echo $datatemp_edit->iddt->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->iddt->cellAttributes() ?>>
<span id="el_datatemp_iddt">
<span<?php echo $datatemp_edit->iddt->viewAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo HtmlEncode(RemoveHtml($datatemp_edit->iddt->EditValue)) ?>"></span>
</span>
<input type="hidden" data-table="datatemp" data-field="x_iddt" name="x_iddt" id="x_iddt" value="<?php echo HtmlEncode($datatemp_edit->iddt->CurrentValue) ?>">
<?php echo $datatemp_edit->iddt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->datejob->Visible) { // datejob ?>
	<div id="r_datejob" class="form-group row">
		<label id="elh_datatemp_datejob" for="x_datejob" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->datejob->caption() ?><?php echo $datatemp_edit->datejob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->datejob->cellAttributes() ?>>
<span id="el_datatemp_datejob">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x_datejob" id="x_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_edit->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_edit->datejob->EditValue ?>"<?php echo $datatemp_edit->datejob->editAttributes() ?>>
<?php if (!$datatemp_edit->datejob->ReadOnly && !$datatemp_edit->datejob->Disabled && !isset($datatemp_edit->datejob->EditAttrs["readonly"]) && !isset($datatemp_edit->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatempedit", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatempedit", "x_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $datatemp_edit->datejob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_datatemp_idemp" for="x_idemp" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->idemp->caption() ?><?php echo $datatemp_edit->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->idemp->cellAttributes() ?>>
<span id="el_datatemp_idemp">
<?php $datatemp_edit->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($datatemp_edit->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_edit->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_edit->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_edit->idemp->ReadOnly || $datatemp_edit->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_edit->idemp->Lookup->getParamTag($datatemp_edit, "p_x_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_edit->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $datatemp_edit->idemp->CurrentValue ?>"<?php echo $datatemp_edit->idemp->editAttributes() ?>>
</span>
<?php echo $datatemp_edit->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->dept->Visible) { // dept ?>
	<div id="r_dept" class="form-group row">
		<label id="elh_datatemp_dept" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->dept->caption() ?><?php echo $datatemp_edit->dept->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->dept->cellAttributes() ?>>
<span id="el_datatemp_dept">
<?php
$onchange = $datatemp_edit->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_edit->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x_dept">
	<input type="text" class="form-control" name="sv_x_dept" id="sv_x_dept" value="<?php echo RemoveHtml($datatemp_edit->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_edit->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_edit->dept->getPlaceHolder()) ?>"<?php echo $datatemp_edit->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_edit->dept->displayValueSeparatorAttribute() ?>" name="x_dept" id="x_dept" value="<?php echo HtmlEncode($datatemp_edit->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempedit"], function() {
	fdatatempedit.createAutoSuggest({"id":"x_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_edit->dept->Lookup->getParamTag($datatemp_edit, "p_x_dept") ?>
</span>
<?php echo $datatemp_edit->dept->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_datatemp_type" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->type->caption() ?><?php echo $datatemp_edit->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->type->cellAttributes() ?>>
<span id="el_datatemp_type">
<?php
$onchange = $datatemp_edit->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_edit->type->EditAttrs["onchange"] = "";
?>
<span id="as_x_type">
	<input type="text" class="form-control" name="sv_x_type" id="sv_x_type" value="<?php echo RemoveHtml($datatemp_edit->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_edit->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_edit->type->getPlaceHolder()) ?>"<?php echo $datatemp_edit->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_edit->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="<?php echo HtmlEncode($datatemp_edit->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempedit"], function() {
	fdatatempedit.createAutoSuggest({"id":"x_type","forceSelect":false});
});
</script>
<?php echo $datatemp_edit->type->Lookup->getParamTag($datatemp_edit, "p_x_type") ?>
</span>
<?php echo $datatemp_edit->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->nbrheur->Visible) { // nbrheur ?>
	<div id="r_nbrheur" class="form-group row">
		<label id="elh_datatemp_nbrheur" for="x_nbrheur" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->nbrheur->caption() ?><?php echo $datatemp_edit->nbrheur->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->nbrheur->cellAttributes() ?>>
<span id="el_datatemp_nbrheur">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x_nbrheur" id="x_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_edit->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_edit->nbrheur->EditValue ?>"<?php echo $datatemp_edit->nbrheur->editAttributes() ?>>
</span>
<?php echo $datatemp_edit->nbrheur->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->tauxh->Visible) { // tauxh ?>
	<div id="r_tauxh" class="form-group row">
		<label id="elh_datatemp_tauxh" for="x_tauxh" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->tauxh->caption() ?><?php echo $datatemp_edit->tauxh->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->tauxh->cellAttributes() ?>>
<span id="el_datatemp_tauxh">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x_tauxh" id="x_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_edit->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_edit->tauxh->EditValue ?>"<?php echo $datatemp_edit->tauxh->editAttributes() ?>>
</span>
<?php echo $datatemp_edit->tauxh->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_edit->SubTotal->Visible) { // SubTotal ?>
	<div id="r_SubTotal" class="form-group row">
		<label id="elh_datatemp_SubTotal" for="x_SubTotal" class="<?php echo $datatemp_edit->LeftColumnClass ?>"><?php echo $datatemp_edit->SubTotal->caption() ?><?php echo $datatemp_edit->SubTotal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_edit->RightColumnClass ?>"><div <?php echo $datatemp_edit->SubTotal->cellAttributes() ?>>
<span id="el_datatemp_SubTotal">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x_SubTotal" id="x_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_edit->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_edit->SubTotal->EditValue ?>"<?php echo $datatemp_edit->SubTotal->editAttributes() ?>>
</span>
<?php echo $datatemp_edit->SubTotal->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$datatemp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $datatemp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $datatemp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$datatemp_edit->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

	$("div.form-control.ew-lookup-text").css("min-width", "15em");

	   // $("div.input-group ew-lookup-list").css("min-width", "10em");
	   // $("span.form-group").css("min-width", "12em");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$datatemp_edit->terminate();
?>