<?php
namespace PHPMaker2020\intextdesign_proj_v0;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$datatemp_add = new datatemp_add();

// Run the page
$datatemp_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$datatemp_add->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fdatatempadd, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "add";
	fdatatempadd = currentForm = new ew.Form("fdatatempadd", "add");

	// Validate form
	fdatatempadd.validate = function() {
		if (!this.validateRequired)
			return true; // Ignore validation
		var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
		if ($fobj.find("#confirm").val() == "confirm")
			return true;
		var elm, felm, uelm, addcnt = 0;
		var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
		var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
		var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
		var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
		for (var i = startcnt; i <= rowcnt; i++) {
			var infix = ($k[0]) ? String(i) : "";
			$fobj.data("rowindex", infix);
			<?php if ($datatemp_add->datejob->Required) { ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->datejob->caption(), $datatemp_add->datejob->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_datejob");
				if (elm && !ew.checkEuroDate(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_add->datejob->errorMessage()) ?>");
			<?php if ($datatemp_add->idemp->Required) { ?>
				elm = this.getElements("x" + infix + "_idemp");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->idemp->caption(), $datatemp_add->idemp->RequiredErrorMessage)) ?>");
			<?php } ?>
			<?php if ($datatemp_add->dept->Required) { ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->dept->caption(), $datatemp_add->dept->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_dept");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_add->dept->errorMessage()) ?>");
			<?php if ($datatemp_add->type->Required) { ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->type->caption(), $datatemp_add->type->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_type");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_add->type->errorMessage()) ?>");
			<?php if ($datatemp_add->nbrheur->Required) { ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->nbrheur->caption(), $datatemp_add->nbrheur->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_nbrheur");
				if (elm && !ew.checkInteger(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_add->nbrheur->errorMessage()) ?>");
			<?php if ($datatemp_add->tauxh->Required) { ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->tauxh->caption(), $datatemp_add->tauxh->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_tauxh");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_add->tauxh->errorMessage()) ?>");
			<?php if ($datatemp_add->SubTotal->Required) { ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
					return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $datatemp_add->SubTotal->caption(), $datatemp_add->SubTotal->RequiredErrorMessage)) ?>");
			<?php } ?>
				elm = this.getElements("x" + infix + "_SubTotal");
				if (elm && !ew.checkNumber(elm.value))
					return this.onError(elm, "<?php echo JsEncode($datatemp_add->SubTotal->errorMessage()) ?>");

				// Call Form_CustomValidate event
				if (!this.Form_CustomValidate(fobj))
					return false;
		}

		// Process detail forms
		var dfs = $fobj.find("input[name='detailpage']").get();
		for (var i = 0; i < dfs.length; i++) {
			var df = dfs[i], val = df.value;
			if (val && ew.forms[val])
				if (!ew.forms[val].validate())
					return false;
		}
		return true;
	}

	// Form_CustomValidate
	fdatatempadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fdatatempadd.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fdatatempadd.lists["x_idemp"] = <?php echo $datatemp_add->idemp->Lookup->toClientList($datatemp_add) ?>;
	fdatatempadd.lists["x_idemp"].options = <?php echo JsonEncode($datatemp_add->idemp->lookupOptions()) ?>;
	fdatatempadd.lists["x_dept"] = <?php echo $datatemp_add->dept->Lookup->toClientList($datatemp_add) ?>;
	fdatatempadd.lists["x_dept"].options = <?php echo JsonEncode($datatemp_add->dept->lookupOptions()) ?>;
	fdatatempadd.autoSuggests["x_dept"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	fdatatempadd.lists["x_type"] = <?php echo $datatemp_add->type->Lookup->toClientList($datatemp_add) ?>;
	fdatatempadd.lists["x_type"].options = <?php echo JsonEncode($datatemp_add->type->lookupOptions()) ?>;
	fdatatempadd.autoSuggests["x_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
	loadjs.done("fdatatempadd");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $datatemp_add->showPageHeader(); ?>
<?php
$datatemp_add->showMessage();
?>
<form name="fdatatempadd" id="fdatatempadd" class="<?php echo $datatemp_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="datatemp">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$datatemp_add->IsModal ?>">
<?php if ($datatemp->getCurrentMasterTable() == "attendance") { ?>
<input type="hidden" name="<?php echo Config("TABLE_SHOW_MASTER") ?>" value="attendance">
<input type="hidden" name="fk_idatt" value="<?php echo HtmlEncode($datatemp_add->idatt->getSessionValue()) ?>">
<?php } ?>
<div class="ew-add-div"><!-- page* -->
<?php if ($datatemp_add->datejob->Visible) { // datejob ?>
	<div id="r_datejob" class="form-group row">
		<label id="elh_datatemp_datejob" for="x_datejob" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->datejob->caption() ?><?php echo $datatemp_add->datejob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->datejob->cellAttributes() ?>>
<span id="el_datatemp_datejob">
<input type="text" data-table="datatemp" data-field="x_datejob" data-format="7" name="x_datejob" id="x_datejob" size="8" maxlength="10" placeholder="<?php echo HtmlEncode($datatemp_add->datejob->getPlaceHolder()) ?>" value="<?php echo $datatemp_add->datejob->EditValue ?>"<?php echo $datatemp_add->datejob->editAttributes() ?>>
<?php if (!$datatemp_add->datejob->ReadOnly && !$datatemp_add->datejob->Disabled && !isset($datatemp_add->datejob->EditAttrs["readonly"]) && !isset($datatemp_add->datejob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fdatatempadd", "datetimepicker"], function() {
	ew.createDateTimePicker("fdatatempadd", "x_datejob", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
<?php echo $datatemp_add->datejob->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_add->idemp->Visible) { // idemp ?>
	<div id="r_idemp" class="form-group row">
		<label id="elh_datatemp_idemp" for="x_idemp" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->idemp->caption() ?><?php echo $datatemp_add->idemp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->idemp->cellAttributes() ?>>
<span id="el_datatemp_idemp">
<?php $datatemp_add->idemp->EditAttrs->prepend("onchange", "ew.autoFill(this);"); ?>
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_idemp"><?php echo EmptyValue(strval($datatemp_add->idemp->ViewValue)) ? $Language->phrase("PleaseSelect") : $datatemp_add->idemp->ViewValue ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($datatemp_add->idemp->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo ($datatemp_add->idemp->ReadOnly || $datatemp_add->idemp->Disabled) ? " disabled" : "" ?> onclick="ew.modalLookupShow({lnk:this,el:'x_idemp',m:0,n:20});"><i class="fas fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $datatemp_add->idemp->Lookup->getParamTag($datatemp_add, "p_x_idemp") ?>
<input type="hidden" data-table="datatemp" data-field="x_idemp" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $datatemp_add->idemp->displayValueSeparatorAttribute() ?>" name="x_idemp" id="x_idemp" value="<?php echo $datatemp_add->idemp->CurrentValue ?>"<?php echo $datatemp_add->idemp->editAttributes() ?>>
</span>
<?php echo $datatemp_add->idemp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_add->dept->Visible) { // dept ?>
	<div id="r_dept" class="form-group row">
		<label id="elh_datatemp_dept" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->dept->caption() ?><?php echo $datatemp_add->dept->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->dept->cellAttributes() ?>>
<span id="el_datatemp_dept">
<?php
$onchange = $datatemp_add->dept->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_add->dept->EditAttrs["onchange"] = "";
?>
<span id="as_x_dept">
	<input type="text" class="form-control" name="sv_x_dept" id="sv_x_dept" value="<?php echo RemoveHtml($datatemp_add->dept->EditValue) ?>" size="18" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_add->dept->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_add->dept->getPlaceHolder()) ?>"<?php echo $datatemp_add->dept->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_dept" data-value-separator="<?php echo $datatemp_add->dept->displayValueSeparatorAttribute() ?>" name="x_dept" id="x_dept" value="<?php echo HtmlEncode($datatemp_add->dept->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempadd"], function() {
	fdatatempadd.createAutoSuggest({"id":"x_dept","forceSelect":false});
});
</script>
<?php echo $datatemp_add->dept->Lookup->getParamTag($datatemp_add, "p_x_dept") ?>
</span>
<?php echo $datatemp_add->dept->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_add->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_datatemp_type" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->type->caption() ?><?php echo $datatemp_add->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->type->cellAttributes() ?>>
<span id="el_datatemp_type">
<?php
$onchange = $datatemp_add->type->EditAttrs->prepend("onchange", "");
$onchange = ($onchange) ? ' onchange="' . JsEncode($onchange) . '"' : '';
$datatemp_add->type->EditAttrs["onchange"] = "";
?>
<span id="as_x_type">
	<input type="text" class="form-control" name="sv_x_type" id="sv_x_type" value="<?php echo RemoveHtml($datatemp_add->type->EditValue) ?>" size="1" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_add->type->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($datatemp_add->type->getPlaceHolder()) ?>"<?php echo $datatemp_add->type->editAttributes() ?>>
</span>
<input type="hidden" data-table="datatemp" data-field="x_type" data-value-separator="<?php echo $datatemp_add->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="<?php echo HtmlEncode($datatemp_add->type->CurrentValue) ?>"<?php echo $onchange ?>>
<script>
loadjs.ready(["fdatatempadd"], function() {
	fdatatempadd.createAutoSuggest({"id":"x_type","forceSelect":false});
});
</script>
<?php echo $datatemp_add->type->Lookup->getParamTag($datatemp_add, "p_x_type") ?>
</span>
<?php echo $datatemp_add->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_add->nbrheur->Visible) { // nbrheur ?>
	<div id="r_nbrheur" class="form-group row">
		<label id="elh_datatemp_nbrheur" for="x_nbrheur" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->nbrheur->caption() ?><?php echo $datatemp_add->nbrheur->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->nbrheur->cellAttributes() ?>>
<span id="el_datatemp_nbrheur">
<input type="text" data-table="datatemp" data-field="x_nbrheur" name="x_nbrheur" id="x_nbrheur" size="2" maxlength="11" placeholder="<?php echo HtmlEncode($datatemp_add->nbrheur->getPlaceHolder()) ?>" value="<?php echo $datatemp_add->nbrheur->EditValue ?>"<?php echo $datatemp_add->nbrheur->editAttributes() ?>>
</span>
<?php echo $datatemp_add->nbrheur->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_add->tauxh->Visible) { // tauxh ?>
	<div id="r_tauxh" class="form-group row">
		<label id="elh_datatemp_tauxh" for="x_tauxh" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->tauxh->caption() ?><?php echo $datatemp_add->tauxh->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->tauxh->cellAttributes() ?>>
<span id="el_datatemp_tauxh">
<input type="text" data-table="datatemp" data-field="x_tauxh" name="x_tauxh" id="x_tauxh" size="5" maxlength="15" placeholder="<?php echo HtmlEncode($datatemp_add->tauxh->getPlaceHolder()) ?>" value="<?php echo $datatemp_add->tauxh->EditValue ?>"<?php echo $datatemp_add->tauxh->editAttributes() ?>>
</span>
<?php echo $datatemp_add->tauxh->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($datatemp_add->SubTotal->Visible) { // SubTotal ?>
	<div id="r_SubTotal" class="form-group row">
		<label id="elh_datatemp_SubTotal" for="x_SubTotal" class="<?php echo $datatemp_add->LeftColumnClass ?>"><?php echo $datatemp_add->SubTotal->caption() ?><?php echo $datatemp_add->SubTotal->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $datatemp_add->RightColumnClass ?>"><div <?php echo $datatemp_add->SubTotal->cellAttributes() ?>>
<span id="el_datatemp_SubTotal">
<input type="text" data-table="datatemp" data-field="x_SubTotal" name="x_SubTotal" id="x_SubTotal" size="10" maxlength="25" placeholder="<?php echo HtmlEncode($datatemp_add->SubTotal->getPlaceHolder()) ?>" value="<?php echo $datatemp_add->SubTotal->EditValue ?>"<?php echo $datatemp_add->SubTotal->editAttributes() ?>>
</span>
<?php echo $datatemp_add->SubTotal->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<?php if (strval($datatemp_add->idatt->getSessionValue()) != "") { ?>
	<input type="hidden" name="x_idatt" id="x_idatt" value="<?php echo HtmlEncode(strval($datatemp_add->idatt->getSessionValue())) ?>">
	<?php } ?>
<?php if (!$datatemp_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $datatemp_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $datatemp_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$datatemp_add->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$datatemp_add->terminate();
?>