<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class tabemp4_update extends tabemp4
{

	// Page ID
	public $PageID = "update";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'tabemp4';

	// Page object name
	public $PageObjName = "tabemp4_update";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tabemp4)
		if (!isset($GLOBALS["tabemp4"]) || get_class($GLOBALS["tabemp4"]) == PROJECT_NAMESPACE . "tabemp4") {
			$GLOBALS["tabemp4"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tabemp4"];
		}

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'update');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tabemp4');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tabemp4;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tabemp4);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tabemp4view.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['RN'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}
	public $FormClassName = "ew-horizontal ew-form ew-update-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $RecKeys;
	public $Disabled;
	public $UpdateCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tabemp4list.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->RN->setVisibility();
		$this->NO_EMP->setVisibility();
		$this->NOM_EMP->setVisibility();
		$this->SEXE->setVisibility();
		$this->ETAT_C->setVisibility();
		$this->DEPEND->setVisibility();
		$this->DTE_NAIS->setVisibility();
		$this->LIEU_NAIS->setVisibility();
		$this->NATION->setVisibility();
		$this->ADRESSE->setVisibility();
		$this->VILLE->setVisibility();
		$this->PAYS->setVisibility();
		$this->BOX->setVisibility();
		$this->PHONE->setVisibility();
		$this->REFERENCE->setVisibility();
		$this->QUALIF->setVisibility();
		$this->URGENCE->setVisibility();
		$this->PHONE_URG->setVisibility();
		$this->DATE_EMP->setVisibility();
		$this->SERVICE->setVisibility();
		$this->DEPT->setVisibility();
		$this->SECTION->setVisibility();
		$this->CATEGORIE->setVisibility();
		$this->FONCTION->setVisibility();
		$this->STATUT->setVisibility();
		$this->STA_DEBUT->setVisibility();
		$this->STA_FIN->setVisibility();
		$this->STA_MOTIF->setVisibility();
		$this->NO_NIF->setVisibility();
		$this->NO_ONA->setVisibility();
		$this->LIV_TRAV->setVisibility();
		$this->MT_SALAIRE->setVisibility();
		$this->MT_FRAIS->setVisibility();
		$this->MT_AUTRES->setVisibility();
		$this->MODE->setVisibility();
		$this->TYPE->setVisibility();
		$this->MT_IMPOT->setVisibility();
		$this->PER_IMPOT->setVisibility();
		$this->PRET_ONA->setVisibility();
		$this->PER_ONA->setVisibility();
		$this->RET_ASSUR->setVisibility();
		$this->PER_ASSUR->setVisibility();
		$this->PRET_SALAIRE->setVisibility();
		$this->PER_SALAIRE->setVisibility();
		$this->RET_PENSION->setVisibility();
		$this->PER_RETPENSION->setVisibility();
		$this->PRET_BANQUE->setVisibility();
		$this->PER_BANQUE->setVisibility();
		$this->RET_AVANC->setVisibility();
		$this->PER_AVANCE->setVisibility();
		$this->PRET_PENSION->setVisibility();
		$this->PER_PENSION->setVisibility();
		$this->RET_CAFET->setVisibility();
		$this->PER_CAFET->setVisibility();
		$this->RET_CITE->setVisibility();
		$this->PER_CITE->setVisibility();
		$this->RET_AUTRE->setVisibility();
		$this->PER_AUTRE->setVisibility();
		$this->ACQ_NB_CON->setVisibility();
		$this->ACC_MT_BRUT->setVisibility();
		$this->ACC_NB_CON->setVisibility();
		$this->ACC_NB_PCON->setVisibility();
		$this->ACC_MT_OVT->setVisibility();
		$this->ACQ_NB_MAL->setVisibility();
		$this->ACC_NB_MAL->setVisibility();
		$this->ACC_MT_CON->setVisibility();
		$this->ACC_NB_MAT->setVisibility();
		$this->ACC_MT_BONI->setVisibility();
		$this->ACC_NB_PER->setVisibility();
		$this->ACC_MT_AUT->setVisibility();
		$this->ACC_NB_COM->setVisibility();
		$this->ACC_BAL_SAL->setVisibility();
		$this->ACC_BAL_BAN->setVisibility();
		$this->ACC_NB_SUS->setVisibility();
		$this->ACC_BAL_ONA->setVisibility();
		$this->ACC_BAL_PENSION->setVisibility();
		$this->ACC_NB_ABS->setVisibility();
		$this->ACC_MT_QZ->setVisibility();
		$this->ACC_NB_TRA->setVisibility();
		$this->ACC_MT_AJST->setVisibility();
		$this->ACC_NB_TRA_ACT->setVisibility();
		$this->ACC1_MT_BRUT->setVisibility();
		$this->ACC_RENDEMENT->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-update-form ew-horizontal";

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Try to load keys from list form
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		if (Post("action") !== NULL && Post("action") !== "") {

			// Get action
			$this->CurrentAction = Post("action");
			$this->loadFormValues(); // Get form values

			// Validate form
			if (!$this->validateForm()) {
				$this->CurrentAction = "show"; // Form error, reset action
				$this->setFailureMessage($FormError);
			}
		} else {
			$this->loadMultiUpdateValues(); // Load initial values to form
		}
		if (count($this->RecKeys) <= 0)
			$this->terminate("tabemp4list.php"); // No records selected, return to list
		if ($this->isUpdate()) {
				if ($this->updateRows()) { // Update Records based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up update success message
					$this->terminate($this->getReturnUrl()); // Return to caller
				} else {
					$this->restoreFormValues(); // Restore form values
				}
		}

		// Render row
		$this->RowType = ROWTYPE_EDIT; // Render edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Load initial values to form if field values are identical in all selected records
	protected function loadMultiUpdateValues()
	{
		$this->CurrentFilter = $this->getFilterFromRecordKeys();

		// Load recordset
		if ($this->Recordset = $this->loadRecordset()) {
			$i = 1;
			while (!$this->Recordset->EOF) {
				if ($i == 1) {
					$this->id->setDbValue($this->Recordset->fields('id'));
					$this->RN->setDbValue($this->Recordset->fields('RN'));
					$this->NO_EMP->setDbValue($this->Recordset->fields('NO_EMP'));
					$this->NOM_EMP->setDbValue($this->Recordset->fields('NOM_EMP'));
					$this->SEXE->setDbValue($this->Recordset->fields('SEXE'));
					$this->ETAT_C->setDbValue($this->Recordset->fields('ETAT_C'));
					$this->DEPEND->setDbValue($this->Recordset->fields('DEPEND'));
					$this->DTE_NAIS->setDbValue($this->Recordset->fields('DTE_NAIS'));
					$this->LIEU_NAIS->setDbValue($this->Recordset->fields('LIEU_NAIS'));
					$this->NATION->setDbValue($this->Recordset->fields('NATION'));
					$this->ADRESSE->setDbValue($this->Recordset->fields('ADRESSE'));
					$this->VILLE->setDbValue($this->Recordset->fields('VILLE'));
					$this->PAYS->setDbValue($this->Recordset->fields('PAYS'));
					$this->BOX->setDbValue($this->Recordset->fields('BOX'));
					$this->PHONE->setDbValue($this->Recordset->fields('PHONE'));
					$this->REFERENCE->setDbValue($this->Recordset->fields('REFERENCE'));
					$this->QUALIF->setDbValue($this->Recordset->fields('QUALIF'));
					$this->URGENCE->setDbValue($this->Recordset->fields('URGENCE'));
					$this->PHONE_URG->setDbValue($this->Recordset->fields('PHONE_URG'));
					$this->DATE_EMP->setDbValue($this->Recordset->fields('DATE_EMP'));
					$this->SERVICE->setDbValue($this->Recordset->fields('SERVICE'));
					$this->DEPT->setDbValue($this->Recordset->fields('DEPT'));
					$this->SECTION->setDbValue($this->Recordset->fields('SECTION'));
					$this->CATEGORIE->setDbValue($this->Recordset->fields('CATEGORIE'));
					$this->FONCTION->setDbValue($this->Recordset->fields('FONCTION'));
					$this->STATUT->setDbValue($this->Recordset->fields('STATUT'));
					$this->STA_DEBUT->setDbValue($this->Recordset->fields('STA_DEBUT'));
					$this->STA_FIN->setDbValue($this->Recordset->fields('STA_FIN'));
					$this->STA_MOTIF->setDbValue($this->Recordset->fields('STA_MOTIF'));
					$this->NO_NIF->setDbValue($this->Recordset->fields('NO_NIF'));
					$this->NO_ONA->setDbValue($this->Recordset->fields('NO_ONA'));
					$this->LIV_TRAV->setDbValue($this->Recordset->fields('LIV_TRAV'));
					$this->MT_SALAIRE->setDbValue($this->Recordset->fields('MT_SALAIRE'));
					$this->MT_FRAIS->setDbValue($this->Recordset->fields('MT_FRAIS'));
					$this->MT_AUTRES->setDbValue($this->Recordset->fields('MT_AUTRES'));
					$this->MODE->setDbValue($this->Recordset->fields('MODE'));
					$this->TYPE->setDbValue($this->Recordset->fields('TYPE'));
					$this->MT_IMPOT->setDbValue($this->Recordset->fields('MT_IMPOT'));
					$this->PER_IMPOT->setDbValue($this->Recordset->fields('PER_IMPOT'));
					$this->PRET_ONA->setDbValue($this->Recordset->fields('PRET_ONA'));
					$this->PER_ONA->setDbValue($this->Recordset->fields('PER_ONA'));
					$this->RET_ASSUR->setDbValue($this->Recordset->fields('RET_ASSUR'));
					$this->PER_ASSUR->setDbValue($this->Recordset->fields('PER_ASSUR'));
					$this->PRET_SALAIRE->setDbValue($this->Recordset->fields('PRET_SALAIRE'));
					$this->PER_SALAIRE->setDbValue($this->Recordset->fields('PER_SALAIRE'));
					$this->RET_PENSION->setDbValue($this->Recordset->fields('RET_PENSION'));
					$this->PER_RETPENSION->setDbValue($this->Recordset->fields('PER_RETPENSION'));
					$this->PRET_BANQUE->setDbValue($this->Recordset->fields('PRET_BANQUE'));
					$this->PER_BANQUE->setDbValue($this->Recordset->fields('PER_BANQUE'));
					$this->RET_AVANC->setDbValue($this->Recordset->fields('RET_AVANC'));
					$this->PER_AVANCE->setDbValue($this->Recordset->fields('PER_AVANCE'));
					$this->PRET_PENSION->setDbValue($this->Recordset->fields('PRET_PENSION'));
					$this->PER_PENSION->setDbValue($this->Recordset->fields('PER_PENSION'));
					$this->RET_CAFET->setDbValue($this->Recordset->fields('RET_CAFET'));
					$this->PER_CAFET->setDbValue($this->Recordset->fields('PER_CAFET'));
					$this->RET_CITE->setDbValue($this->Recordset->fields('RET_CITE'));
					$this->PER_CITE->setDbValue($this->Recordset->fields('PER_CITE'));
					$this->RET_AUTRE->setDbValue($this->Recordset->fields('RET_AUTRE'));
					$this->PER_AUTRE->setDbValue($this->Recordset->fields('PER_AUTRE'));
					$this->ACQ_NB_CON->setDbValue($this->Recordset->fields('ACQ_NB_CON'));
					$this->ACC_MT_BRUT->setDbValue($this->Recordset->fields('ACC_MT_BRUT'));
					$this->ACC_NB_CON->setDbValue($this->Recordset->fields('ACC_NB_CON'));
					$this->ACC_NB_PCON->setDbValue($this->Recordset->fields('ACC_NB_PCON'));
					$this->ACC_MT_OVT->setDbValue($this->Recordset->fields('ACC_MT_OVT'));
					$this->ACQ_NB_MAL->setDbValue($this->Recordset->fields('ACQ_NB_MAL'));
					$this->ACC_NB_MAL->setDbValue($this->Recordset->fields('ACC_NB_MAL'));
					$this->ACC_MT_CON->setDbValue($this->Recordset->fields('ACC_MT_CON'));
					$this->ACC_NB_MAT->setDbValue($this->Recordset->fields('ACC_NB_MAT'));
					$this->ACC_MT_BONI->setDbValue($this->Recordset->fields('ACC_MT_BONI'));
					$this->ACC_NB_PER->setDbValue($this->Recordset->fields('ACC_NB_PER'));
					$this->ACC_MT_AUT->setDbValue($this->Recordset->fields('ACC_MT_AUT'));
					$this->ACC_NB_COM->setDbValue($this->Recordset->fields('ACC_NB_COM'));
					$this->ACC_BAL_SAL->setDbValue($this->Recordset->fields('ACC_BAL_SAL'));
					$this->ACC_BAL_BAN->setDbValue($this->Recordset->fields('ACC_BAL_BAN'));
					$this->ACC_NB_SUS->setDbValue($this->Recordset->fields('ACC_NB_SUS'));
					$this->ACC_BAL_ONA->setDbValue($this->Recordset->fields('ACC_BAL_ONA'));
					$this->ACC_BAL_PENSION->setDbValue($this->Recordset->fields('ACC_BAL_PENSION'));
					$this->ACC_NB_ABS->setDbValue($this->Recordset->fields('ACC_NB_ABS'));
					$this->ACC_MT_QZ->setDbValue($this->Recordset->fields('ACC_MT_QZ'));
					$this->ACC_NB_TRA->setDbValue($this->Recordset->fields('ACC_NB_TRA'));
					$this->ACC_MT_AJST->setDbValue($this->Recordset->fields('ACC_MT_AJST'));
					$this->ACC_NB_TRA_ACT->setDbValue($this->Recordset->fields('ACC_NB_TRA_ACT'));
					$this->ACC1_MT_BRUT->setDbValue($this->Recordset->fields('ACC1_MT_BRUT'));
					$this->ACC_RENDEMENT->setDbValue($this->Recordset->fields('ACC_RENDEMENT'));
				} else {
					if (!CompareValue($this->id->DbValue, $this->Recordset->fields('id')))
						$this->id->CurrentValue = NULL;
					if (!CompareValue($this->RN->DbValue, $this->Recordset->fields('RN')))
						$this->RN->CurrentValue = NULL;
					if (!CompareValue($this->NO_EMP->DbValue, $this->Recordset->fields('NO_EMP')))
						$this->NO_EMP->CurrentValue = NULL;
					if (!CompareValue($this->NOM_EMP->DbValue, $this->Recordset->fields('NOM_EMP')))
						$this->NOM_EMP->CurrentValue = NULL;
					if (!CompareValue($this->SEXE->DbValue, $this->Recordset->fields('SEXE')))
						$this->SEXE->CurrentValue = NULL;
					if (!CompareValue($this->ETAT_C->DbValue, $this->Recordset->fields('ETAT_C')))
						$this->ETAT_C->CurrentValue = NULL;
					if (!CompareValue($this->DEPEND->DbValue, $this->Recordset->fields('DEPEND')))
						$this->DEPEND->CurrentValue = NULL;
					if (!CompareValue($this->DTE_NAIS->DbValue, $this->Recordset->fields('DTE_NAIS')))
						$this->DTE_NAIS->CurrentValue = NULL;
					if (!CompareValue($this->LIEU_NAIS->DbValue, $this->Recordset->fields('LIEU_NAIS')))
						$this->LIEU_NAIS->CurrentValue = NULL;
					if (!CompareValue($this->NATION->DbValue, $this->Recordset->fields('NATION')))
						$this->NATION->CurrentValue = NULL;
					if (!CompareValue($this->ADRESSE->DbValue, $this->Recordset->fields('ADRESSE')))
						$this->ADRESSE->CurrentValue = NULL;
					if (!CompareValue($this->VILLE->DbValue, $this->Recordset->fields('VILLE')))
						$this->VILLE->CurrentValue = NULL;
					if (!CompareValue($this->PAYS->DbValue, $this->Recordset->fields('PAYS')))
						$this->PAYS->CurrentValue = NULL;
					if (!CompareValue($this->BOX->DbValue, $this->Recordset->fields('BOX')))
						$this->BOX->CurrentValue = NULL;
					if (!CompareValue($this->PHONE->DbValue, $this->Recordset->fields('PHONE')))
						$this->PHONE->CurrentValue = NULL;
					if (!CompareValue($this->REFERENCE->DbValue, $this->Recordset->fields('REFERENCE')))
						$this->REFERENCE->CurrentValue = NULL;
					if (!CompareValue($this->QUALIF->DbValue, $this->Recordset->fields('QUALIF')))
						$this->QUALIF->CurrentValue = NULL;
					if (!CompareValue($this->URGENCE->DbValue, $this->Recordset->fields('URGENCE')))
						$this->URGENCE->CurrentValue = NULL;
					if (!CompareValue($this->PHONE_URG->DbValue, $this->Recordset->fields('PHONE_URG')))
						$this->PHONE_URG->CurrentValue = NULL;
					if (!CompareValue($this->DATE_EMP->DbValue, $this->Recordset->fields('DATE_EMP')))
						$this->DATE_EMP->CurrentValue = NULL;
					if (!CompareValue($this->SERVICE->DbValue, $this->Recordset->fields('SERVICE')))
						$this->SERVICE->CurrentValue = NULL;
					if (!CompareValue($this->DEPT->DbValue, $this->Recordset->fields('DEPT')))
						$this->DEPT->CurrentValue = NULL;
					if (!CompareValue($this->SECTION->DbValue, $this->Recordset->fields('SECTION')))
						$this->SECTION->CurrentValue = NULL;
					if (!CompareValue($this->CATEGORIE->DbValue, $this->Recordset->fields('CATEGORIE')))
						$this->CATEGORIE->CurrentValue = NULL;
					if (!CompareValue($this->FONCTION->DbValue, $this->Recordset->fields('FONCTION')))
						$this->FONCTION->CurrentValue = NULL;
					if (!CompareValue($this->STATUT->DbValue, $this->Recordset->fields('STATUT')))
						$this->STATUT->CurrentValue = NULL;
					if (!CompareValue($this->STA_DEBUT->DbValue, $this->Recordset->fields('STA_DEBUT')))
						$this->STA_DEBUT->CurrentValue = NULL;
					if (!CompareValue($this->STA_FIN->DbValue, $this->Recordset->fields('STA_FIN')))
						$this->STA_FIN->CurrentValue = NULL;
					if (!CompareValue($this->STA_MOTIF->DbValue, $this->Recordset->fields('STA_MOTIF')))
						$this->STA_MOTIF->CurrentValue = NULL;
					if (!CompareValue($this->NO_NIF->DbValue, $this->Recordset->fields('NO_NIF')))
						$this->NO_NIF->CurrentValue = NULL;
					if (!CompareValue($this->NO_ONA->DbValue, $this->Recordset->fields('NO_ONA')))
						$this->NO_ONA->CurrentValue = NULL;
					if (!CompareValue($this->LIV_TRAV->DbValue, $this->Recordset->fields('LIV_TRAV')))
						$this->LIV_TRAV->CurrentValue = NULL;
					if (!CompareValue($this->MT_SALAIRE->DbValue, $this->Recordset->fields('MT_SALAIRE')))
						$this->MT_SALAIRE->CurrentValue = NULL;
					if (!CompareValue($this->MT_FRAIS->DbValue, $this->Recordset->fields('MT_FRAIS')))
						$this->MT_FRAIS->CurrentValue = NULL;
					if (!CompareValue($this->MT_AUTRES->DbValue, $this->Recordset->fields('MT_AUTRES')))
						$this->MT_AUTRES->CurrentValue = NULL;
					if (!CompareValue($this->MODE->DbValue, $this->Recordset->fields('MODE')))
						$this->MODE->CurrentValue = NULL;
					if (!CompareValue($this->TYPE->DbValue, $this->Recordset->fields('TYPE')))
						$this->TYPE->CurrentValue = NULL;
					if (!CompareValue($this->MT_IMPOT->DbValue, $this->Recordset->fields('MT_IMPOT')))
						$this->MT_IMPOT->CurrentValue = NULL;
					if (!CompareValue($this->PER_IMPOT->DbValue, $this->Recordset->fields('PER_IMPOT')))
						$this->PER_IMPOT->CurrentValue = NULL;
					if (!CompareValue($this->PRET_ONA->DbValue, $this->Recordset->fields('PRET_ONA')))
						$this->PRET_ONA->CurrentValue = NULL;
					if (!CompareValue($this->PER_ONA->DbValue, $this->Recordset->fields('PER_ONA')))
						$this->PER_ONA->CurrentValue = NULL;
					if (!CompareValue($this->RET_ASSUR->DbValue, $this->Recordset->fields('RET_ASSUR')))
						$this->RET_ASSUR->CurrentValue = NULL;
					if (!CompareValue($this->PER_ASSUR->DbValue, $this->Recordset->fields('PER_ASSUR')))
						$this->PER_ASSUR->CurrentValue = NULL;
					if (!CompareValue($this->PRET_SALAIRE->DbValue, $this->Recordset->fields('PRET_SALAIRE')))
						$this->PRET_SALAIRE->CurrentValue = NULL;
					if (!CompareValue($this->PER_SALAIRE->DbValue, $this->Recordset->fields('PER_SALAIRE')))
						$this->PER_SALAIRE->CurrentValue = NULL;
					if (!CompareValue($this->RET_PENSION->DbValue, $this->Recordset->fields('RET_PENSION')))
						$this->RET_PENSION->CurrentValue = NULL;
					if (!CompareValue($this->PER_RETPENSION->DbValue, $this->Recordset->fields('PER_RETPENSION')))
						$this->PER_RETPENSION->CurrentValue = NULL;
					if (!CompareValue($this->PRET_BANQUE->DbValue, $this->Recordset->fields('PRET_BANQUE')))
						$this->PRET_BANQUE->CurrentValue = NULL;
					if (!CompareValue($this->PER_BANQUE->DbValue, $this->Recordset->fields('PER_BANQUE')))
						$this->PER_BANQUE->CurrentValue = NULL;
					if (!CompareValue($this->RET_AVANC->DbValue, $this->Recordset->fields('RET_AVANC')))
						$this->RET_AVANC->CurrentValue = NULL;
					if (!CompareValue($this->PER_AVANCE->DbValue, $this->Recordset->fields('PER_AVANCE')))
						$this->PER_AVANCE->CurrentValue = NULL;
					if (!CompareValue($this->PRET_PENSION->DbValue, $this->Recordset->fields('PRET_PENSION')))
						$this->PRET_PENSION->CurrentValue = NULL;
					if (!CompareValue($this->PER_PENSION->DbValue, $this->Recordset->fields('PER_PENSION')))
						$this->PER_PENSION->CurrentValue = NULL;
					if (!CompareValue($this->RET_CAFET->DbValue, $this->Recordset->fields('RET_CAFET')))
						$this->RET_CAFET->CurrentValue = NULL;
					if (!CompareValue($this->PER_CAFET->DbValue, $this->Recordset->fields('PER_CAFET')))
						$this->PER_CAFET->CurrentValue = NULL;
					if (!CompareValue($this->RET_CITE->DbValue, $this->Recordset->fields('RET_CITE')))
						$this->RET_CITE->CurrentValue = NULL;
					if (!CompareValue($this->PER_CITE->DbValue, $this->Recordset->fields('PER_CITE')))
						$this->PER_CITE->CurrentValue = NULL;
					if (!CompareValue($this->RET_AUTRE->DbValue, $this->Recordset->fields('RET_AUTRE')))
						$this->RET_AUTRE->CurrentValue = NULL;
					if (!CompareValue($this->PER_AUTRE->DbValue, $this->Recordset->fields('PER_AUTRE')))
						$this->PER_AUTRE->CurrentValue = NULL;
					if (!CompareValue($this->ACQ_NB_CON->DbValue, $this->Recordset->fields('ACQ_NB_CON')))
						$this->ACQ_NB_CON->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_BRUT->DbValue, $this->Recordset->fields('ACC_MT_BRUT')))
						$this->ACC_MT_BRUT->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_CON->DbValue, $this->Recordset->fields('ACC_NB_CON')))
						$this->ACC_NB_CON->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_PCON->DbValue, $this->Recordset->fields('ACC_NB_PCON')))
						$this->ACC_NB_PCON->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_OVT->DbValue, $this->Recordset->fields('ACC_MT_OVT')))
						$this->ACC_MT_OVT->CurrentValue = NULL;
					if (!CompareValue($this->ACQ_NB_MAL->DbValue, $this->Recordset->fields('ACQ_NB_MAL')))
						$this->ACQ_NB_MAL->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_MAL->DbValue, $this->Recordset->fields('ACC_NB_MAL')))
						$this->ACC_NB_MAL->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_CON->DbValue, $this->Recordset->fields('ACC_MT_CON')))
						$this->ACC_MT_CON->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_MAT->DbValue, $this->Recordset->fields('ACC_NB_MAT')))
						$this->ACC_NB_MAT->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_BONI->DbValue, $this->Recordset->fields('ACC_MT_BONI')))
						$this->ACC_MT_BONI->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_PER->DbValue, $this->Recordset->fields('ACC_NB_PER')))
						$this->ACC_NB_PER->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_AUT->DbValue, $this->Recordset->fields('ACC_MT_AUT')))
						$this->ACC_MT_AUT->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_COM->DbValue, $this->Recordset->fields('ACC_NB_COM')))
						$this->ACC_NB_COM->CurrentValue = NULL;
					if (!CompareValue($this->ACC_BAL_SAL->DbValue, $this->Recordset->fields('ACC_BAL_SAL')))
						$this->ACC_BAL_SAL->CurrentValue = NULL;
					if (!CompareValue($this->ACC_BAL_BAN->DbValue, $this->Recordset->fields('ACC_BAL_BAN')))
						$this->ACC_BAL_BAN->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_SUS->DbValue, $this->Recordset->fields('ACC_NB_SUS')))
						$this->ACC_NB_SUS->CurrentValue = NULL;
					if (!CompareValue($this->ACC_BAL_ONA->DbValue, $this->Recordset->fields('ACC_BAL_ONA')))
						$this->ACC_BAL_ONA->CurrentValue = NULL;
					if (!CompareValue($this->ACC_BAL_PENSION->DbValue, $this->Recordset->fields('ACC_BAL_PENSION')))
						$this->ACC_BAL_PENSION->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_ABS->DbValue, $this->Recordset->fields('ACC_NB_ABS')))
						$this->ACC_NB_ABS->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_QZ->DbValue, $this->Recordset->fields('ACC_MT_QZ')))
						$this->ACC_MT_QZ->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_TRA->DbValue, $this->Recordset->fields('ACC_NB_TRA')))
						$this->ACC_NB_TRA->CurrentValue = NULL;
					if (!CompareValue($this->ACC_MT_AJST->DbValue, $this->Recordset->fields('ACC_MT_AJST')))
						$this->ACC_MT_AJST->CurrentValue = NULL;
					if (!CompareValue($this->ACC_NB_TRA_ACT->DbValue, $this->Recordset->fields('ACC_NB_TRA_ACT')))
						$this->ACC_NB_TRA_ACT->CurrentValue = NULL;
					if (!CompareValue($this->ACC1_MT_BRUT->DbValue, $this->Recordset->fields('ACC1_MT_BRUT')))
						$this->ACC1_MT_BRUT->CurrentValue = NULL;
					if (!CompareValue($this->ACC_RENDEMENT->DbValue, $this->Recordset->fields('ACC_RENDEMENT')))
						$this->ACC_RENDEMENT->CurrentValue = NULL;
				}
				$i++;
				$this->Recordset->moveNext();
			}
			$this->Recordset->close();
		}
	}

	// Set up key value
	protected function setupKeyValues($key)
	{
		$keyFld = $key;
		if (!is_numeric($keyFld))
			return FALSE;
		$this->RN->OldValue = $keyFld;
		return TRUE;
	}

	// Update all selected rows
	protected function updateRows()
	{
		global $Language;
		$conn = $this->getConnection();
		$conn->beginTrans();

		// Get old recordset
		$this->CurrentFilter = $this->getFilterFromRecordKeys(FALSE);
		$sql = $this->getCurrentSql();
		$rsold = $conn->execute($sql);

		// Update all rows
		$key = "";
		foreach ($this->RecKeys as $reckey) {
			if ($this->setupKeyValues($reckey)) {
				$thisKey = $reckey;
				$this->SendEmail = FALSE; // Do not send email on update success
				$this->UpdateCount += 1; // Update record count for records being updated
				$updateRows = $this->editRow(); // Update this row
			} else {
				$updateRows = FALSE;
			}
			if (!$updateRows)
				break; // Update failed
			if ($key != "")
				$key .= ", ";
			$key .= $thisKey;
		}

		// Check if all rows updated
		if ($updateRows) {
			$conn->commitTrans(); // Commit transaction

			// Get new recordset
			$rsnew = $conn->execute($sql);
		} else {
			$conn->rollbackTrans(); // Rollback transaction
		}
		return $updateRows;
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}
		$this->id->MultiUpdate = $CurrentForm->getValue("u_id");

		// Check field name 'RN' first before field var 'x_RN'
		$val = $CurrentForm->hasValue("RN") ? $CurrentForm->getValue("RN") : $CurrentForm->getValue("x_RN");
		if (!$this->RN->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RN->Visible = FALSE; // Disable update for API request
			else
				$this->RN->setFormValue($val);
		}
		$this->RN->MultiUpdate = $CurrentForm->getValue("u_RN");

		// Check field name 'NO_EMP' first before field var 'x_NO_EMP'
		$val = $CurrentForm->hasValue("NO_EMP") ? $CurrentForm->getValue("NO_EMP") : $CurrentForm->getValue("x_NO_EMP");
		if (!$this->NO_EMP->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NO_EMP->Visible = FALSE; // Disable update for API request
			else
				$this->NO_EMP->setFormValue($val);
		}
		$this->NO_EMP->MultiUpdate = $CurrentForm->getValue("u_NO_EMP");

		// Check field name 'NOM_EMP' first before field var 'x_NOM_EMP'
		$val = $CurrentForm->hasValue("NOM_EMP") ? $CurrentForm->getValue("NOM_EMP") : $CurrentForm->getValue("x_NOM_EMP");
		if (!$this->NOM_EMP->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NOM_EMP->Visible = FALSE; // Disable update for API request
			else
				$this->NOM_EMP->setFormValue($val);
		}
		$this->NOM_EMP->MultiUpdate = $CurrentForm->getValue("u_NOM_EMP");

		// Check field name 'SEXE' first before field var 'x_SEXE'
		$val = $CurrentForm->hasValue("SEXE") ? $CurrentForm->getValue("SEXE") : $CurrentForm->getValue("x_SEXE");
		if (!$this->SEXE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->SEXE->Visible = FALSE; // Disable update for API request
			else
				$this->SEXE->setFormValue($val);
		}
		$this->SEXE->MultiUpdate = $CurrentForm->getValue("u_SEXE");

		// Check field name 'ETAT_C' first before field var 'x_ETAT_C'
		$val = $CurrentForm->hasValue("ETAT_C") ? $CurrentForm->getValue("ETAT_C") : $CurrentForm->getValue("x_ETAT_C");
		if (!$this->ETAT_C->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ETAT_C->Visible = FALSE; // Disable update for API request
			else
				$this->ETAT_C->setFormValue($val);
		}
		$this->ETAT_C->MultiUpdate = $CurrentForm->getValue("u_ETAT_C");

		// Check field name 'DEPEND' first before field var 'x_DEPEND'
		$val = $CurrentForm->hasValue("DEPEND") ? $CurrentForm->getValue("DEPEND") : $CurrentForm->getValue("x_DEPEND");
		if (!$this->DEPEND->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->DEPEND->Visible = FALSE; // Disable update for API request
			else
				$this->DEPEND->setFormValue($val);
		}
		$this->DEPEND->MultiUpdate = $CurrentForm->getValue("u_DEPEND");

		// Check field name 'DTE_NAIS' first before field var 'x_DTE_NAIS'
		$val = $CurrentForm->hasValue("DTE_NAIS") ? $CurrentForm->getValue("DTE_NAIS") : $CurrentForm->getValue("x_DTE_NAIS");
		if (!$this->DTE_NAIS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->DTE_NAIS->Visible = FALSE; // Disable update for API request
			else
				$this->DTE_NAIS->setFormValue($val);
			$this->DTE_NAIS->CurrentValue = UnFormatDateTime($this->DTE_NAIS->CurrentValue, 0);
		}
		$this->DTE_NAIS->MultiUpdate = $CurrentForm->getValue("u_DTE_NAIS");

		// Check field name 'LIEU_NAIS' first before field var 'x_LIEU_NAIS'
		$val = $CurrentForm->hasValue("LIEU_NAIS") ? $CurrentForm->getValue("LIEU_NAIS") : $CurrentForm->getValue("x_LIEU_NAIS");
		if (!$this->LIEU_NAIS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->LIEU_NAIS->Visible = FALSE; // Disable update for API request
			else
				$this->LIEU_NAIS->setFormValue($val);
		}
		$this->LIEU_NAIS->MultiUpdate = $CurrentForm->getValue("u_LIEU_NAIS");

		// Check field name 'NATION' first before field var 'x_NATION'
		$val = $CurrentForm->hasValue("NATION") ? $CurrentForm->getValue("NATION") : $CurrentForm->getValue("x_NATION");
		if (!$this->NATION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NATION->Visible = FALSE; // Disable update for API request
			else
				$this->NATION->setFormValue($val);
		}
		$this->NATION->MultiUpdate = $CurrentForm->getValue("u_NATION");

		// Check field name 'ADRESSE' first before field var 'x_ADRESSE'
		$val = $CurrentForm->hasValue("ADRESSE") ? $CurrentForm->getValue("ADRESSE") : $CurrentForm->getValue("x_ADRESSE");
		if (!$this->ADRESSE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ADRESSE->Visible = FALSE; // Disable update for API request
			else
				$this->ADRESSE->setFormValue($val);
		}
		$this->ADRESSE->MultiUpdate = $CurrentForm->getValue("u_ADRESSE");

		// Check field name 'VILLE' first before field var 'x_VILLE'
		$val = $CurrentForm->hasValue("VILLE") ? $CurrentForm->getValue("VILLE") : $CurrentForm->getValue("x_VILLE");
		if (!$this->VILLE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->VILLE->Visible = FALSE; // Disable update for API request
			else
				$this->VILLE->setFormValue($val);
		}
		$this->VILLE->MultiUpdate = $CurrentForm->getValue("u_VILLE");

		// Check field name 'PAYS' first before field var 'x_PAYS'
		$val = $CurrentForm->hasValue("PAYS") ? $CurrentForm->getValue("PAYS") : $CurrentForm->getValue("x_PAYS");
		if (!$this->PAYS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PAYS->Visible = FALSE; // Disable update for API request
			else
				$this->PAYS->setFormValue($val);
		}
		$this->PAYS->MultiUpdate = $CurrentForm->getValue("u_PAYS");

		// Check field name 'BOX' first before field var 'x_BOX'
		$val = $CurrentForm->hasValue("BOX") ? $CurrentForm->getValue("BOX") : $CurrentForm->getValue("x_BOX");
		if (!$this->BOX->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->BOX->Visible = FALSE; // Disable update for API request
			else
				$this->BOX->setFormValue($val);
		}
		$this->BOX->MultiUpdate = $CurrentForm->getValue("u_BOX");

		// Check field name 'PHONE' first before field var 'x_PHONE'
		$val = $CurrentForm->hasValue("PHONE") ? $CurrentForm->getValue("PHONE") : $CurrentForm->getValue("x_PHONE");
		if (!$this->PHONE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PHONE->Visible = FALSE; // Disable update for API request
			else
				$this->PHONE->setFormValue($val);
		}
		$this->PHONE->MultiUpdate = $CurrentForm->getValue("u_PHONE");

		// Check field name 'REFERENCE' first before field var 'x_REFERENCE'
		$val = $CurrentForm->hasValue("REFERENCE") ? $CurrentForm->getValue("REFERENCE") : $CurrentForm->getValue("x_REFERENCE");
		if (!$this->REFERENCE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->REFERENCE->Visible = FALSE; // Disable update for API request
			else
				$this->REFERENCE->setFormValue($val);
		}
		$this->REFERENCE->MultiUpdate = $CurrentForm->getValue("u_REFERENCE");

		// Check field name 'QUALIF' first before field var 'x_QUALIF'
		$val = $CurrentForm->hasValue("QUALIF") ? $CurrentForm->getValue("QUALIF") : $CurrentForm->getValue("x_QUALIF");
		if (!$this->QUALIF->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->QUALIF->Visible = FALSE; // Disable update for API request
			else
				$this->QUALIF->setFormValue($val);
		}
		$this->QUALIF->MultiUpdate = $CurrentForm->getValue("u_QUALIF");

		// Check field name 'URGENCE' first before field var 'x_URGENCE'
		$val = $CurrentForm->hasValue("URGENCE") ? $CurrentForm->getValue("URGENCE") : $CurrentForm->getValue("x_URGENCE");
		if (!$this->URGENCE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->URGENCE->Visible = FALSE; // Disable update for API request
			else
				$this->URGENCE->setFormValue($val);
		}
		$this->URGENCE->MultiUpdate = $CurrentForm->getValue("u_URGENCE");

		// Check field name 'PHONE_URG' first before field var 'x_PHONE_URG'
		$val = $CurrentForm->hasValue("PHONE_URG") ? $CurrentForm->getValue("PHONE_URG") : $CurrentForm->getValue("x_PHONE_URG");
		if (!$this->PHONE_URG->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PHONE_URG->Visible = FALSE; // Disable update for API request
			else
				$this->PHONE_URG->setFormValue($val);
		}
		$this->PHONE_URG->MultiUpdate = $CurrentForm->getValue("u_PHONE_URG");

		// Check field name 'DATE_EMP' first before field var 'x_DATE_EMP'
		$val = $CurrentForm->hasValue("DATE_EMP") ? $CurrentForm->getValue("DATE_EMP") : $CurrentForm->getValue("x_DATE_EMP");
		if (!$this->DATE_EMP->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->DATE_EMP->Visible = FALSE; // Disable update for API request
			else
				$this->DATE_EMP->setFormValue($val);
			$this->DATE_EMP->CurrentValue = UnFormatDateTime($this->DATE_EMP->CurrentValue, 0);
		}
		$this->DATE_EMP->MultiUpdate = $CurrentForm->getValue("u_DATE_EMP");

		// Check field name 'SERVICE' first before field var 'x_SERVICE'
		$val = $CurrentForm->hasValue("SERVICE") ? $CurrentForm->getValue("SERVICE") : $CurrentForm->getValue("x_SERVICE");
		if (!$this->SERVICE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->SERVICE->Visible = FALSE; // Disable update for API request
			else
				$this->SERVICE->setFormValue($val);
		}
		$this->SERVICE->MultiUpdate = $CurrentForm->getValue("u_SERVICE");

		// Check field name 'DEPT' first before field var 'x_DEPT'
		$val = $CurrentForm->hasValue("DEPT") ? $CurrentForm->getValue("DEPT") : $CurrentForm->getValue("x_DEPT");
		if (!$this->DEPT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->DEPT->Visible = FALSE; // Disable update for API request
			else
				$this->DEPT->setFormValue($val);
		}
		$this->DEPT->MultiUpdate = $CurrentForm->getValue("u_DEPT");

		// Check field name 'SECTION' first before field var 'x_SECTION'
		$val = $CurrentForm->hasValue("SECTION") ? $CurrentForm->getValue("SECTION") : $CurrentForm->getValue("x_SECTION");
		if (!$this->SECTION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->SECTION->Visible = FALSE; // Disable update for API request
			else
				$this->SECTION->setFormValue($val);
		}
		$this->SECTION->MultiUpdate = $CurrentForm->getValue("u_SECTION");

		// Check field name 'CATEGORIE' first before field var 'x_CATEGORIE'
		$val = $CurrentForm->hasValue("CATEGORIE") ? $CurrentForm->getValue("CATEGORIE") : $CurrentForm->getValue("x_CATEGORIE");
		if (!$this->CATEGORIE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->CATEGORIE->Visible = FALSE; // Disable update for API request
			else
				$this->CATEGORIE->setFormValue($val);
		}
		$this->CATEGORIE->MultiUpdate = $CurrentForm->getValue("u_CATEGORIE");

		// Check field name 'FONCTION' first before field var 'x_FONCTION'
		$val = $CurrentForm->hasValue("FONCTION") ? $CurrentForm->getValue("FONCTION") : $CurrentForm->getValue("x_FONCTION");
		if (!$this->FONCTION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->FONCTION->Visible = FALSE; // Disable update for API request
			else
				$this->FONCTION->setFormValue($val);
		}
		$this->FONCTION->MultiUpdate = $CurrentForm->getValue("u_FONCTION");

		// Check field name 'STATUT' first before field var 'x_STATUT'
		$val = $CurrentForm->hasValue("STATUT") ? $CurrentForm->getValue("STATUT") : $CurrentForm->getValue("x_STATUT");
		if (!$this->STATUT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->STATUT->Visible = FALSE; // Disable update for API request
			else
				$this->STATUT->setFormValue($val);
		}
		$this->STATUT->MultiUpdate = $CurrentForm->getValue("u_STATUT");

		// Check field name 'STA_DEBUT' first before field var 'x_STA_DEBUT'
		$val = $CurrentForm->hasValue("STA_DEBUT") ? $CurrentForm->getValue("STA_DEBUT") : $CurrentForm->getValue("x_STA_DEBUT");
		if (!$this->STA_DEBUT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->STA_DEBUT->Visible = FALSE; // Disable update for API request
			else
				$this->STA_DEBUT->setFormValue($val);
			$this->STA_DEBUT->CurrentValue = UnFormatDateTime($this->STA_DEBUT->CurrentValue, 0);
		}
		$this->STA_DEBUT->MultiUpdate = $CurrentForm->getValue("u_STA_DEBUT");

		// Check field name 'STA_FIN' first before field var 'x_STA_FIN'
		$val = $CurrentForm->hasValue("STA_FIN") ? $CurrentForm->getValue("STA_FIN") : $CurrentForm->getValue("x_STA_FIN");
		if (!$this->STA_FIN->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->STA_FIN->Visible = FALSE; // Disable update for API request
			else
				$this->STA_FIN->setFormValue($val);
			$this->STA_FIN->CurrentValue = UnFormatDateTime($this->STA_FIN->CurrentValue, 0);
		}
		$this->STA_FIN->MultiUpdate = $CurrentForm->getValue("u_STA_FIN");

		// Check field name 'STA_MOTIF' first before field var 'x_STA_MOTIF'
		$val = $CurrentForm->hasValue("STA_MOTIF") ? $CurrentForm->getValue("STA_MOTIF") : $CurrentForm->getValue("x_STA_MOTIF");
		if (!$this->STA_MOTIF->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->STA_MOTIF->Visible = FALSE; // Disable update for API request
			else
				$this->STA_MOTIF->setFormValue($val);
		}
		$this->STA_MOTIF->MultiUpdate = $CurrentForm->getValue("u_STA_MOTIF");

		// Check field name 'NO_NIF' first before field var 'x_NO_NIF'
		$val = $CurrentForm->hasValue("NO_NIF") ? $CurrentForm->getValue("NO_NIF") : $CurrentForm->getValue("x_NO_NIF");
		if (!$this->NO_NIF->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NO_NIF->Visible = FALSE; // Disable update for API request
			else
				$this->NO_NIF->setFormValue($val);
		}
		$this->NO_NIF->MultiUpdate = $CurrentForm->getValue("u_NO_NIF");

		// Check field name 'NO_ONA' first before field var 'x_NO_ONA'
		$val = $CurrentForm->hasValue("NO_ONA") ? $CurrentForm->getValue("NO_ONA") : $CurrentForm->getValue("x_NO_ONA");
		if (!$this->NO_ONA->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NO_ONA->Visible = FALSE; // Disable update for API request
			else
				$this->NO_ONA->setFormValue($val);
		}
		$this->NO_ONA->MultiUpdate = $CurrentForm->getValue("u_NO_ONA");

		// Check field name 'LIV_TRAV' first before field var 'x_LIV_TRAV'
		$val = $CurrentForm->hasValue("LIV_TRAV") ? $CurrentForm->getValue("LIV_TRAV") : $CurrentForm->getValue("x_LIV_TRAV");
		if (!$this->LIV_TRAV->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->LIV_TRAV->Visible = FALSE; // Disable update for API request
			else
				$this->LIV_TRAV->setFormValue($val);
		}
		$this->LIV_TRAV->MultiUpdate = $CurrentForm->getValue("u_LIV_TRAV");

		// Check field name 'MT_SALAIRE' first before field var 'x_MT_SALAIRE'
		$val = $CurrentForm->hasValue("MT_SALAIRE") ? $CurrentForm->getValue("MT_SALAIRE") : $CurrentForm->getValue("x_MT_SALAIRE");
		if (!$this->MT_SALAIRE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->MT_SALAIRE->Visible = FALSE; // Disable update for API request
			else
				$this->MT_SALAIRE->setFormValue($val);
		}
		$this->MT_SALAIRE->MultiUpdate = $CurrentForm->getValue("u_MT_SALAIRE");

		// Check field name 'MT_FRAIS' first before field var 'x_MT_FRAIS'
		$val = $CurrentForm->hasValue("MT_FRAIS") ? $CurrentForm->getValue("MT_FRAIS") : $CurrentForm->getValue("x_MT_FRAIS");
		if (!$this->MT_FRAIS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->MT_FRAIS->Visible = FALSE; // Disable update for API request
			else
				$this->MT_FRAIS->setFormValue($val);
		}
		$this->MT_FRAIS->MultiUpdate = $CurrentForm->getValue("u_MT_FRAIS");

		// Check field name 'MT_AUTRES' first before field var 'x_MT_AUTRES'
		$val = $CurrentForm->hasValue("MT_AUTRES") ? $CurrentForm->getValue("MT_AUTRES") : $CurrentForm->getValue("x_MT_AUTRES");
		if (!$this->MT_AUTRES->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->MT_AUTRES->Visible = FALSE; // Disable update for API request
			else
				$this->MT_AUTRES->setFormValue($val);
		}
		$this->MT_AUTRES->MultiUpdate = $CurrentForm->getValue("u_MT_AUTRES");

		// Check field name 'MODE' first before field var 'x_MODE'
		$val = $CurrentForm->hasValue("MODE") ? $CurrentForm->getValue("MODE") : $CurrentForm->getValue("x_MODE");
		if (!$this->MODE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->MODE->Visible = FALSE; // Disable update for API request
			else
				$this->MODE->setFormValue($val);
		}
		$this->MODE->MultiUpdate = $CurrentForm->getValue("u_MODE");

		// Check field name 'TYPE' first before field var 'x_TYPE'
		$val = $CurrentForm->hasValue("TYPE") ? $CurrentForm->getValue("TYPE") : $CurrentForm->getValue("x_TYPE");
		if (!$this->TYPE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TYPE->Visible = FALSE; // Disable update for API request
			else
				$this->TYPE->setFormValue($val);
		}
		$this->TYPE->MultiUpdate = $CurrentForm->getValue("u_TYPE");

		// Check field name 'MT_IMPOT' first before field var 'x_MT_IMPOT'
		$val = $CurrentForm->hasValue("MT_IMPOT") ? $CurrentForm->getValue("MT_IMPOT") : $CurrentForm->getValue("x_MT_IMPOT");
		if (!$this->MT_IMPOT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->MT_IMPOT->Visible = FALSE; // Disable update for API request
			else
				$this->MT_IMPOT->setFormValue($val);
		}
		$this->MT_IMPOT->MultiUpdate = $CurrentForm->getValue("u_MT_IMPOT");

		// Check field name 'PER_IMPOT' first before field var 'x_PER_IMPOT'
		$val = $CurrentForm->hasValue("PER_IMPOT") ? $CurrentForm->getValue("PER_IMPOT") : $CurrentForm->getValue("x_PER_IMPOT");
		if (!$this->PER_IMPOT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_IMPOT->Visible = FALSE; // Disable update for API request
			else
				$this->PER_IMPOT->setFormValue($val);
		}
		$this->PER_IMPOT->MultiUpdate = $CurrentForm->getValue("u_PER_IMPOT");

		// Check field name 'PRET_ONA' first before field var 'x_PRET_ONA'
		$val = $CurrentForm->hasValue("PRET_ONA") ? $CurrentForm->getValue("PRET_ONA") : $CurrentForm->getValue("x_PRET_ONA");
		if (!$this->PRET_ONA->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PRET_ONA->Visible = FALSE; // Disable update for API request
			else
				$this->PRET_ONA->setFormValue($val);
		}
		$this->PRET_ONA->MultiUpdate = $CurrentForm->getValue("u_PRET_ONA");

		// Check field name 'PER_ONA' first before field var 'x_PER_ONA'
		$val = $CurrentForm->hasValue("PER_ONA") ? $CurrentForm->getValue("PER_ONA") : $CurrentForm->getValue("x_PER_ONA");
		if (!$this->PER_ONA->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_ONA->Visible = FALSE; // Disable update for API request
			else
				$this->PER_ONA->setFormValue($val);
		}
		$this->PER_ONA->MultiUpdate = $CurrentForm->getValue("u_PER_ONA");

		// Check field name 'RET_ASSUR' first before field var 'x_RET_ASSUR'
		$val = $CurrentForm->hasValue("RET_ASSUR") ? $CurrentForm->getValue("RET_ASSUR") : $CurrentForm->getValue("x_RET_ASSUR");
		if (!$this->RET_ASSUR->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RET_ASSUR->Visible = FALSE; // Disable update for API request
			else
				$this->RET_ASSUR->setFormValue($val);
		}
		$this->RET_ASSUR->MultiUpdate = $CurrentForm->getValue("u_RET_ASSUR");

		// Check field name 'PER_ASSUR' first before field var 'x_PER_ASSUR'
		$val = $CurrentForm->hasValue("PER_ASSUR") ? $CurrentForm->getValue("PER_ASSUR") : $CurrentForm->getValue("x_PER_ASSUR");
		if (!$this->PER_ASSUR->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_ASSUR->Visible = FALSE; // Disable update for API request
			else
				$this->PER_ASSUR->setFormValue($val);
		}
		$this->PER_ASSUR->MultiUpdate = $CurrentForm->getValue("u_PER_ASSUR");

		// Check field name 'PRET_SALAIRE' first before field var 'x_PRET_SALAIRE'
		$val = $CurrentForm->hasValue("PRET_SALAIRE") ? $CurrentForm->getValue("PRET_SALAIRE") : $CurrentForm->getValue("x_PRET_SALAIRE");
		if (!$this->PRET_SALAIRE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PRET_SALAIRE->Visible = FALSE; // Disable update for API request
			else
				$this->PRET_SALAIRE->setFormValue($val);
		}
		$this->PRET_SALAIRE->MultiUpdate = $CurrentForm->getValue("u_PRET_SALAIRE");

		// Check field name 'PER_SALAIRE' first before field var 'x_PER_SALAIRE'
		$val = $CurrentForm->hasValue("PER_SALAIRE") ? $CurrentForm->getValue("PER_SALAIRE") : $CurrentForm->getValue("x_PER_SALAIRE");
		if (!$this->PER_SALAIRE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_SALAIRE->Visible = FALSE; // Disable update for API request
			else
				$this->PER_SALAIRE->setFormValue($val);
		}
		$this->PER_SALAIRE->MultiUpdate = $CurrentForm->getValue("u_PER_SALAIRE");

		// Check field name 'RET_PENSION' first before field var 'x_RET_PENSION'
		$val = $CurrentForm->hasValue("RET_PENSION") ? $CurrentForm->getValue("RET_PENSION") : $CurrentForm->getValue("x_RET_PENSION");
		if (!$this->RET_PENSION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RET_PENSION->Visible = FALSE; // Disable update for API request
			else
				$this->RET_PENSION->setFormValue($val);
		}
		$this->RET_PENSION->MultiUpdate = $CurrentForm->getValue("u_RET_PENSION");

		// Check field name 'PER_RETPENSION' first before field var 'x_PER_RETPENSION'
		$val = $CurrentForm->hasValue("PER_RETPENSION") ? $CurrentForm->getValue("PER_RETPENSION") : $CurrentForm->getValue("x_PER_RETPENSION");
		if (!$this->PER_RETPENSION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_RETPENSION->Visible = FALSE; // Disable update for API request
			else
				$this->PER_RETPENSION->setFormValue($val);
		}
		$this->PER_RETPENSION->MultiUpdate = $CurrentForm->getValue("u_PER_RETPENSION");

		// Check field name 'PRET_BANQUE' first before field var 'x_PRET_BANQUE'
		$val = $CurrentForm->hasValue("PRET_BANQUE") ? $CurrentForm->getValue("PRET_BANQUE") : $CurrentForm->getValue("x_PRET_BANQUE");
		if (!$this->PRET_BANQUE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PRET_BANQUE->Visible = FALSE; // Disable update for API request
			else
				$this->PRET_BANQUE->setFormValue($val);
		}
		$this->PRET_BANQUE->MultiUpdate = $CurrentForm->getValue("u_PRET_BANQUE");

		// Check field name 'PER_BANQUE' first before field var 'x_PER_BANQUE'
		$val = $CurrentForm->hasValue("PER_BANQUE") ? $CurrentForm->getValue("PER_BANQUE") : $CurrentForm->getValue("x_PER_BANQUE");
		if (!$this->PER_BANQUE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_BANQUE->Visible = FALSE; // Disable update for API request
			else
				$this->PER_BANQUE->setFormValue($val);
		}
		$this->PER_BANQUE->MultiUpdate = $CurrentForm->getValue("u_PER_BANQUE");

		// Check field name 'RET_AVANC' first before field var 'x_RET_AVANC'
		$val = $CurrentForm->hasValue("RET_AVANC") ? $CurrentForm->getValue("RET_AVANC") : $CurrentForm->getValue("x_RET_AVANC");
		if (!$this->RET_AVANC->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RET_AVANC->Visible = FALSE; // Disable update for API request
			else
				$this->RET_AVANC->setFormValue($val);
		}
		$this->RET_AVANC->MultiUpdate = $CurrentForm->getValue("u_RET_AVANC");

		// Check field name 'PER_AVANCE' first before field var 'x_PER_AVANCE'
		$val = $CurrentForm->hasValue("PER_AVANCE") ? $CurrentForm->getValue("PER_AVANCE") : $CurrentForm->getValue("x_PER_AVANCE");
		if (!$this->PER_AVANCE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_AVANCE->Visible = FALSE; // Disable update for API request
			else
				$this->PER_AVANCE->setFormValue($val);
		}
		$this->PER_AVANCE->MultiUpdate = $CurrentForm->getValue("u_PER_AVANCE");

		// Check field name 'PRET_PENSION' first before field var 'x_PRET_PENSION'
		$val = $CurrentForm->hasValue("PRET_PENSION") ? $CurrentForm->getValue("PRET_PENSION") : $CurrentForm->getValue("x_PRET_PENSION");
		if (!$this->PRET_PENSION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PRET_PENSION->Visible = FALSE; // Disable update for API request
			else
				$this->PRET_PENSION->setFormValue($val);
		}
		$this->PRET_PENSION->MultiUpdate = $CurrentForm->getValue("u_PRET_PENSION");

		// Check field name 'PER_PENSION' first before field var 'x_PER_PENSION'
		$val = $CurrentForm->hasValue("PER_PENSION") ? $CurrentForm->getValue("PER_PENSION") : $CurrentForm->getValue("x_PER_PENSION");
		if (!$this->PER_PENSION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_PENSION->Visible = FALSE; // Disable update for API request
			else
				$this->PER_PENSION->setFormValue($val);
		}
		$this->PER_PENSION->MultiUpdate = $CurrentForm->getValue("u_PER_PENSION");

		// Check field name 'RET_CAFET' first before field var 'x_RET_CAFET'
		$val = $CurrentForm->hasValue("RET_CAFET") ? $CurrentForm->getValue("RET_CAFET") : $CurrentForm->getValue("x_RET_CAFET");
		if (!$this->RET_CAFET->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RET_CAFET->Visible = FALSE; // Disable update for API request
			else
				$this->RET_CAFET->setFormValue($val);
		}
		$this->RET_CAFET->MultiUpdate = $CurrentForm->getValue("u_RET_CAFET");

		// Check field name 'PER_CAFET' first before field var 'x_PER_CAFET'
		$val = $CurrentForm->hasValue("PER_CAFET") ? $CurrentForm->getValue("PER_CAFET") : $CurrentForm->getValue("x_PER_CAFET");
		if (!$this->PER_CAFET->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_CAFET->Visible = FALSE; // Disable update for API request
			else
				$this->PER_CAFET->setFormValue($val);
		}
		$this->PER_CAFET->MultiUpdate = $CurrentForm->getValue("u_PER_CAFET");

		// Check field name 'RET_CITE' first before field var 'x_RET_CITE'
		$val = $CurrentForm->hasValue("RET_CITE") ? $CurrentForm->getValue("RET_CITE") : $CurrentForm->getValue("x_RET_CITE");
		if (!$this->RET_CITE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RET_CITE->Visible = FALSE; // Disable update for API request
			else
				$this->RET_CITE->setFormValue($val);
		}
		$this->RET_CITE->MultiUpdate = $CurrentForm->getValue("u_RET_CITE");

		// Check field name 'PER_CITE' first before field var 'x_PER_CITE'
		$val = $CurrentForm->hasValue("PER_CITE") ? $CurrentForm->getValue("PER_CITE") : $CurrentForm->getValue("x_PER_CITE");
		if (!$this->PER_CITE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_CITE->Visible = FALSE; // Disable update for API request
			else
				$this->PER_CITE->setFormValue($val);
		}
		$this->PER_CITE->MultiUpdate = $CurrentForm->getValue("u_PER_CITE");

		// Check field name 'RET_AUTRE' first before field var 'x_RET_AUTRE'
		$val = $CurrentForm->hasValue("RET_AUTRE") ? $CurrentForm->getValue("RET_AUTRE") : $CurrentForm->getValue("x_RET_AUTRE");
		if (!$this->RET_AUTRE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->RET_AUTRE->Visible = FALSE; // Disable update for API request
			else
				$this->RET_AUTRE->setFormValue($val);
		}
		$this->RET_AUTRE->MultiUpdate = $CurrentForm->getValue("u_RET_AUTRE");

		// Check field name 'PER_AUTRE' first before field var 'x_PER_AUTRE'
		$val = $CurrentForm->hasValue("PER_AUTRE") ? $CurrentForm->getValue("PER_AUTRE") : $CurrentForm->getValue("x_PER_AUTRE");
		if (!$this->PER_AUTRE->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PER_AUTRE->Visible = FALSE; // Disable update for API request
			else
				$this->PER_AUTRE->setFormValue($val);
		}
		$this->PER_AUTRE->MultiUpdate = $CurrentForm->getValue("u_PER_AUTRE");

		// Check field name 'ACQ_NB_CON' first before field var 'x_ACQ_NB_CON'
		$val = $CurrentForm->hasValue("ACQ_NB_CON") ? $CurrentForm->getValue("ACQ_NB_CON") : $CurrentForm->getValue("x_ACQ_NB_CON");
		if (!$this->ACQ_NB_CON->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACQ_NB_CON->Visible = FALSE; // Disable update for API request
			else
				$this->ACQ_NB_CON->setFormValue($val);
		}
		$this->ACQ_NB_CON->MultiUpdate = $CurrentForm->getValue("u_ACQ_NB_CON");

		// Check field name 'ACC_MT_BRUT' first before field var 'x_ACC_MT_BRUT'
		$val = $CurrentForm->hasValue("ACC_MT_BRUT") ? $CurrentForm->getValue("ACC_MT_BRUT") : $CurrentForm->getValue("x_ACC_MT_BRUT");
		if (!$this->ACC_MT_BRUT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_BRUT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_BRUT->setFormValue($val);
		}
		$this->ACC_MT_BRUT->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_BRUT");

		// Check field name 'ACC_NB_CON' first before field var 'x_ACC_NB_CON'
		$val = $CurrentForm->hasValue("ACC_NB_CON") ? $CurrentForm->getValue("ACC_NB_CON") : $CurrentForm->getValue("x_ACC_NB_CON");
		if (!$this->ACC_NB_CON->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_CON->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_CON->setFormValue($val);
		}
		$this->ACC_NB_CON->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_CON");

		// Check field name 'ACC_NB_PCON' first before field var 'x_ACC_NB_PCON'
		$val = $CurrentForm->hasValue("ACC_NB_PCON") ? $CurrentForm->getValue("ACC_NB_PCON") : $CurrentForm->getValue("x_ACC_NB_PCON");
		if (!$this->ACC_NB_PCON->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_PCON->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_PCON->setFormValue($val);
		}
		$this->ACC_NB_PCON->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_PCON");

		// Check field name 'ACC_MT_OVT' first before field var 'x_ACC_MT_OVT'
		$val = $CurrentForm->hasValue("ACC_MT_OVT") ? $CurrentForm->getValue("ACC_MT_OVT") : $CurrentForm->getValue("x_ACC_MT_OVT");
		if (!$this->ACC_MT_OVT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_OVT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_OVT->setFormValue($val);
		}
		$this->ACC_MT_OVT->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_OVT");

		// Check field name 'ACQ_NB_MAL' first before field var 'x_ACQ_NB_MAL'
		$val = $CurrentForm->hasValue("ACQ_NB_MAL") ? $CurrentForm->getValue("ACQ_NB_MAL") : $CurrentForm->getValue("x_ACQ_NB_MAL");
		if (!$this->ACQ_NB_MAL->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACQ_NB_MAL->Visible = FALSE; // Disable update for API request
			else
				$this->ACQ_NB_MAL->setFormValue($val);
		}
		$this->ACQ_NB_MAL->MultiUpdate = $CurrentForm->getValue("u_ACQ_NB_MAL");

		// Check field name 'ACC_NB_MAL' first before field var 'x_ACC_NB_MAL'
		$val = $CurrentForm->hasValue("ACC_NB_MAL") ? $CurrentForm->getValue("ACC_NB_MAL") : $CurrentForm->getValue("x_ACC_NB_MAL");
		if (!$this->ACC_NB_MAL->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_MAL->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_MAL->setFormValue($val);
		}
		$this->ACC_NB_MAL->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_MAL");

		// Check field name 'ACC_MT_CON' first before field var 'x_ACC_MT_CON'
		$val = $CurrentForm->hasValue("ACC_MT_CON") ? $CurrentForm->getValue("ACC_MT_CON") : $CurrentForm->getValue("x_ACC_MT_CON");
		if (!$this->ACC_MT_CON->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_CON->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_CON->setFormValue($val);
		}
		$this->ACC_MT_CON->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_CON");

		// Check field name 'ACC_NB_MAT' first before field var 'x_ACC_NB_MAT'
		$val = $CurrentForm->hasValue("ACC_NB_MAT") ? $CurrentForm->getValue("ACC_NB_MAT") : $CurrentForm->getValue("x_ACC_NB_MAT");
		if (!$this->ACC_NB_MAT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_MAT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_MAT->setFormValue($val);
		}
		$this->ACC_NB_MAT->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_MAT");

		// Check field name 'ACC_MT_BONI' first before field var 'x_ACC_MT_BONI'
		$val = $CurrentForm->hasValue("ACC_MT_BONI") ? $CurrentForm->getValue("ACC_MT_BONI") : $CurrentForm->getValue("x_ACC_MT_BONI");
		if (!$this->ACC_MT_BONI->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_BONI->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_BONI->setFormValue($val);
		}
		$this->ACC_MT_BONI->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_BONI");

		// Check field name 'ACC_NB_PER' first before field var 'x_ACC_NB_PER'
		$val = $CurrentForm->hasValue("ACC_NB_PER") ? $CurrentForm->getValue("ACC_NB_PER") : $CurrentForm->getValue("x_ACC_NB_PER");
		if (!$this->ACC_NB_PER->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_PER->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_PER->setFormValue($val);
		}
		$this->ACC_NB_PER->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_PER");

		// Check field name 'ACC_MT_AUT' first before field var 'x_ACC_MT_AUT'
		$val = $CurrentForm->hasValue("ACC_MT_AUT") ? $CurrentForm->getValue("ACC_MT_AUT") : $CurrentForm->getValue("x_ACC_MT_AUT");
		if (!$this->ACC_MT_AUT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_AUT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_AUT->setFormValue($val);
		}
		$this->ACC_MT_AUT->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_AUT");

		// Check field name 'ACC_NB_COM' first before field var 'x_ACC_NB_COM'
		$val = $CurrentForm->hasValue("ACC_NB_COM") ? $CurrentForm->getValue("ACC_NB_COM") : $CurrentForm->getValue("x_ACC_NB_COM");
		if (!$this->ACC_NB_COM->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_COM->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_COM->setFormValue($val);
		}
		$this->ACC_NB_COM->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_COM");

		// Check field name 'ACC_BAL_SAL' first before field var 'x_ACC_BAL_SAL'
		$val = $CurrentForm->hasValue("ACC_BAL_SAL") ? $CurrentForm->getValue("ACC_BAL_SAL") : $CurrentForm->getValue("x_ACC_BAL_SAL");
		if (!$this->ACC_BAL_SAL->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_BAL_SAL->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_BAL_SAL->setFormValue($val);
		}
		$this->ACC_BAL_SAL->MultiUpdate = $CurrentForm->getValue("u_ACC_BAL_SAL");

		// Check field name 'ACC_BAL_BAN' first before field var 'x_ACC_BAL_BAN'
		$val = $CurrentForm->hasValue("ACC_BAL_BAN") ? $CurrentForm->getValue("ACC_BAL_BAN") : $CurrentForm->getValue("x_ACC_BAL_BAN");
		if (!$this->ACC_BAL_BAN->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_BAL_BAN->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_BAL_BAN->setFormValue($val);
		}
		$this->ACC_BAL_BAN->MultiUpdate = $CurrentForm->getValue("u_ACC_BAL_BAN");

		// Check field name 'ACC_NB_SUS' first before field var 'x_ACC_NB_SUS'
		$val = $CurrentForm->hasValue("ACC_NB_SUS") ? $CurrentForm->getValue("ACC_NB_SUS") : $CurrentForm->getValue("x_ACC_NB_SUS");
		if (!$this->ACC_NB_SUS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_SUS->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_SUS->setFormValue($val);
		}
		$this->ACC_NB_SUS->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_SUS");

		// Check field name 'ACC_BAL_ONA' first before field var 'x_ACC_BAL_ONA'
		$val = $CurrentForm->hasValue("ACC_BAL_ONA") ? $CurrentForm->getValue("ACC_BAL_ONA") : $CurrentForm->getValue("x_ACC_BAL_ONA");
		if (!$this->ACC_BAL_ONA->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_BAL_ONA->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_BAL_ONA->setFormValue($val);
		}
		$this->ACC_BAL_ONA->MultiUpdate = $CurrentForm->getValue("u_ACC_BAL_ONA");

		// Check field name 'ACC_BAL_PENSION' first before field var 'x_ACC_BAL_PENSION'
		$val = $CurrentForm->hasValue("ACC_BAL_PENSION") ? $CurrentForm->getValue("ACC_BAL_PENSION") : $CurrentForm->getValue("x_ACC_BAL_PENSION");
		if (!$this->ACC_BAL_PENSION->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_BAL_PENSION->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_BAL_PENSION->setFormValue($val);
		}
		$this->ACC_BAL_PENSION->MultiUpdate = $CurrentForm->getValue("u_ACC_BAL_PENSION");

		// Check field name 'ACC_NB_ABS' first before field var 'x_ACC_NB_ABS'
		$val = $CurrentForm->hasValue("ACC_NB_ABS") ? $CurrentForm->getValue("ACC_NB_ABS") : $CurrentForm->getValue("x_ACC_NB_ABS");
		if (!$this->ACC_NB_ABS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_ABS->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_ABS->setFormValue($val);
		}
		$this->ACC_NB_ABS->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_ABS");

		// Check field name 'ACC_MT_QZ' first before field var 'x_ACC_MT_QZ'
		$val = $CurrentForm->hasValue("ACC_MT_QZ") ? $CurrentForm->getValue("ACC_MT_QZ") : $CurrentForm->getValue("x_ACC_MT_QZ");
		if (!$this->ACC_MT_QZ->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_QZ->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_QZ->setFormValue($val);
		}
		$this->ACC_MT_QZ->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_QZ");

		// Check field name 'ACC_NB_TRA' first before field var 'x_ACC_NB_TRA'
		$val = $CurrentForm->hasValue("ACC_NB_TRA") ? $CurrentForm->getValue("ACC_NB_TRA") : $CurrentForm->getValue("x_ACC_NB_TRA");
		if (!$this->ACC_NB_TRA->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_TRA->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_TRA->setFormValue($val);
		}
		$this->ACC_NB_TRA->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_TRA");

		// Check field name 'ACC_MT_AJST' first before field var 'x_ACC_MT_AJST'
		$val = $CurrentForm->hasValue("ACC_MT_AJST") ? $CurrentForm->getValue("ACC_MT_AJST") : $CurrentForm->getValue("x_ACC_MT_AJST");
		if (!$this->ACC_MT_AJST->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_MT_AJST->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_MT_AJST->setFormValue($val);
		}
		$this->ACC_MT_AJST->MultiUpdate = $CurrentForm->getValue("u_ACC_MT_AJST");

		// Check field name 'ACC_NB_TRA_ACT' first before field var 'x_ACC_NB_TRA_ACT'
		$val = $CurrentForm->hasValue("ACC_NB_TRA_ACT") ? $CurrentForm->getValue("ACC_NB_TRA_ACT") : $CurrentForm->getValue("x_ACC_NB_TRA_ACT");
		if (!$this->ACC_NB_TRA_ACT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_NB_TRA_ACT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_NB_TRA_ACT->setFormValue($val);
		}
		$this->ACC_NB_TRA_ACT->MultiUpdate = $CurrentForm->getValue("u_ACC_NB_TRA_ACT");

		// Check field name 'ACC1_MT_BRUT' first before field var 'x_ACC1_MT_BRUT'
		$val = $CurrentForm->hasValue("ACC1_MT_BRUT") ? $CurrentForm->getValue("ACC1_MT_BRUT") : $CurrentForm->getValue("x_ACC1_MT_BRUT");
		if (!$this->ACC1_MT_BRUT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC1_MT_BRUT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC1_MT_BRUT->setFormValue($val);
		}
		$this->ACC1_MT_BRUT->MultiUpdate = $CurrentForm->getValue("u_ACC1_MT_BRUT");

		// Check field name 'ACC_RENDEMENT' first before field var 'x_ACC_RENDEMENT'
		$val = $CurrentForm->hasValue("ACC_RENDEMENT") ? $CurrentForm->getValue("ACC_RENDEMENT") : $CurrentForm->getValue("x_ACC_RENDEMENT");
		if (!$this->ACC_RENDEMENT->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->ACC_RENDEMENT->Visible = FALSE; // Disable update for API request
			else
				$this->ACC_RENDEMENT->setFormValue($val);
		}
		$this->ACC_RENDEMENT->MultiUpdate = $CurrentForm->getValue("u_ACC_RENDEMENT");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->RN->CurrentValue = $this->RN->FormValue;
		$this->NO_EMP->CurrentValue = $this->NO_EMP->FormValue;
		$this->NOM_EMP->CurrentValue = $this->NOM_EMP->FormValue;
		$this->SEXE->CurrentValue = $this->SEXE->FormValue;
		$this->ETAT_C->CurrentValue = $this->ETAT_C->FormValue;
		$this->DEPEND->CurrentValue = $this->DEPEND->FormValue;
		$this->DTE_NAIS->CurrentValue = $this->DTE_NAIS->FormValue;
		$this->DTE_NAIS->CurrentValue = UnFormatDateTime($this->DTE_NAIS->CurrentValue, 0);
		$this->LIEU_NAIS->CurrentValue = $this->LIEU_NAIS->FormValue;
		$this->NATION->CurrentValue = $this->NATION->FormValue;
		$this->ADRESSE->CurrentValue = $this->ADRESSE->FormValue;
		$this->VILLE->CurrentValue = $this->VILLE->FormValue;
		$this->PAYS->CurrentValue = $this->PAYS->FormValue;
		$this->BOX->CurrentValue = $this->BOX->FormValue;
		$this->PHONE->CurrentValue = $this->PHONE->FormValue;
		$this->REFERENCE->CurrentValue = $this->REFERENCE->FormValue;
		$this->QUALIF->CurrentValue = $this->QUALIF->FormValue;
		$this->URGENCE->CurrentValue = $this->URGENCE->FormValue;
		$this->PHONE_URG->CurrentValue = $this->PHONE_URG->FormValue;
		$this->DATE_EMP->CurrentValue = $this->DATE_EMP->FormValue;
		$this->DATE_EMP->CurrentValue = UnFormatDateTime($this->DATE_EMP->CurrentValue, 0);
		$this->SERVICE->CurrentValue = $this->SERVICE->FormValue;
		$this->DEPT->CurrentValue = $this->DEPT->FormValue;
		$this->SECTION->CurrentValue = $this->SECTION->FormValue;
		$this->CATEGORIE->CurrentValue = $this->CATEGORIE->FormValue;
		$this->FONCTION->CurrentValue = $this->FONCTION->FormValue;
		$this->STATUT->CurrentValue = $this->STATUT->FormValue;
		$this->STA_DEBUT->CurrentValue = $this->STA_DEBUT->FormValue;
		$this->STA_DEBUT->CurrentValue = UnFormatDateTime($this->STA_DEBUT->CurrentValue, 0);
		$this->STA_FIN->CurrentValue = $this->STA_FIN->FormValue;
		$this->STA_FIN->CurrentValue = UnFormatDateTime($this->STA_FIN->CurrentValue, 0);
		$this->STA_MOTIF->CurrentValue = $this->STA_MOTIF->FormValue;
		$this->NO_NIF->CurrentValue = $this->NO_NIF->FormValue;
		$this->NO_ONA->CurrentValue = $this->NO_ONA->FormValue;
		$this->LIV_TRAV->CurrentValue = $this->LIV_TRAV->FormValue;
		$this->MT_SALAIRE->CurrentValue = $this->MT_SALAIRE->FormValue;
		$this->MT_FRAIS->CurrentValue = $this->MT_FRAIS->FormValue;
		$this->MT_AUTRES->CurrentValue = $this->MT_AUTRES->FormValue;
		$this->MODE->CurrentValue = $this->MODE->FormValue;
		$this->TYPE->CurrentValue = $this->TYPE->FormValue;
		$this->MT_IMPOT->CurrentValue = $this->MT_IMPOT->FormValue;
		$this->PER_IMPOT->CurrentValue = $this->PER_IMPOT->FormValue;
		$this->PRET_ONA->CurrentValue = $this->PRET_ONA->FormValue;
		$this->PER_ONA->CurrentValue = $this->PER_ONA->FormValue;
		$this->RET_ASSUR->CurrentValue = $this->RET_ASSUR->FormValue;
		$this->PER_ASSUR->CurrentValue = $this->PER_ASSUR->FormValue;
		$this->PRET_SALAIRE->CurrentValue = $this->PRET_SALAIRE->FormValue;
		$this->PER_SALAIRE->CurrentValue = $this->PER_SALAIRE->FormValue;
		$this->RET_PENSION->CurrentValue = $this->RET_PENSION->FormValue;
		$this->PER_RETPENSION->CurrentValue = $this->PER_RETPENSION->FormValue;
		$this->PRET_BANQUE->CurrentValue = $this->PRET_BANQUE->FormValue;
		$this->PER_BANQUE->CurrentValue = $this->PER_BANQUE->FormValue;
		$this->RET_AVANC->CurrentValue = $this->RET_AVANC->FormValue;
		$this->PER_AVANCE->CurrentValue = $this->PER_AVANCE->FormValue;
		$this->PRET_PENSION->CurrentValue = $this->PRET_PENSION->FormValue;
		$this->PER_PENSION->CurrentValue = $this->PER_PENSION->FormValue;
		$this->RET_CAFET->CurrentValue = $this->RET_CAFET->FormValue;
		$this->PER_CAFET->CurrentValue = $this->PER_CAFET->FormValue;
		$this->RET_CITE->CurrentValue = $this->RET_CITE->FormValue;
		$this->PER_CITE->CurrentValue = $this->PER_CITE->FormValue;
		$this->RET_AUTRE->CurrentValue = $this->RET_AUTRE->FormValue;
		$this->PER_AUTRE->CurrentValue = $this->PER_AUTRE->FormValue;
		$this->ACQ_NB_CON->CurrentValue = $this->ACQ_NB_CON->FormValue;
		$this->ACC_MT_BRUT->CurrentValue = $this->ACC_MT_BRUT->FormValue;
		$this->ACC_NB_CON->CurrentValue = $this->ACC_NB_CON->FormValue;
		$this->ACC_NB_PCON->CurrentValue = $this->ACC_NB_PCON->FormValue;
		$this->ACC_MT_OVT->CurrentValue = $this->ACC_MT_OVT->FormValue;
		$this->ACQ_NB_MAL->CurrentValue = $this->ACQ_NB_MAL->FormValue;
		$this->ACC_NB_MAL->CurrentValue = $this->ACC_NB_MAL->FormValue;
		$this->ACC_MT_CON->CurrentValue = $this->ACC_MT_CON->FormValue;
		$this->ACC_NB_MAT->CurrentValue = $this->ACC_NB_MAT->FormValue;
		$this->ACC_MT_BONI->CurrentValue = $this->ACC_MT_BONI->FormValue;
		$this->ACC_NB_PER->CurrentValue = $this->ACC_NB_PER->FormValue;
		$this->ACC_MT_AUT->CurrentValue = $this->ACC_MT_AUT->FormValue;
		$this->ACC_NB_COM->CurrentValue = $this->ACC_NB_COM->FormValue;
		$this->ACC_BAL_SAL->CurrentValue = $this->ACC_BAL_SAL->FormValue;
		$this->ACC_BAL_BAN->CurrentValue = $this->ACC_BAL_BAN->FormValue;
		$this->ACC_NB_SUS->CurrentValue = $this->ACC_NB_SUS->FormValue;
		$this->ACC_BAL_ONA->CurrentValue = $this->ACC_BAL_ONA->FormValue;
		$this->ACC_BAL_PENSION->CurrentValue = $this->ACC_BAL_PENSION->FormValue;
		$this->ACC_NB_ABS->CurrentValue = $this->ACC_NB_ABS->FormValue;
		$this->ACC_MT_QZ->CurrentValue = $this->ACC_MT_QZ->FormValue;
		$this->ACC_NB_TRA->CurrentValue = $this->ACC_NB_TRA->FormValue;
		$this->ACC_MT_AJST->CurrentValue = $this->ACC_MT_AJST->FormValue;
		$this->ACC_NB_TRA_ACT->CurrentValue = $this->ACC_NB_TRA_ACT->FormValue;
		$this->ACC1_MT_BRUT->CurrentValue = $this->ACC1_MT_BRUT->FormValue;
		$this->ACC_RENDEMENT->CurrentValue = $this->ACC_RENDEMENT->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->RN->setDbValue($row['RN']);
		$this->NO_EMP->setDbValue($row['NO_EMP']);
		$this->NOM_EMP->setDbValue($row['NOM_EMP']);
		$this->SEXE->setDbValue($row['SEXE']);
		$this->ETAT_C->setDbValue($row['ETAT_C']);
		$this->DEPEND->setDbValue($row['DEPEND']);
		$this->DTE_NAIS->setDbValue($row['DTE_NAIS']);
		$this->LIEU_NAIS->setDbValue($row['LIEU_NAIS']);
		$this->NATION->setDbValue($row['NATION']);
		$this->ADRESSE->setDbValue($row['ADRESSE']);
		$this->VILLE->setDbValue($row['VILLE']);
		$this->PAYS->setDbValue($row['PAYS']);
		$this->BOX->setDbValue($row['BOX']);
		$this->PHONE->setDbValue($row['PHONE']);
		$this->REFERENCE->setDbValue($row['REFERENCE']);
		$this->QUALIF->setDbValue($row['QUALIF']);
		$this->URGENCE->setDbValue($row['URGENCE']);
		$this->PHONE_URG->setDbValue($row['PHONE_URG']);
		$this->DATE_EMP->setDbValue($row['DATE_EMP']);
		$this->SERVICE->setDbValue($row['SERVICE']);
		$this->DEPT->setDbValue($row['DEPT']);
		$this->SECTION->setDbValue($row['SECTION']);
		$this->CATEGORIE->setDbValue($row['CATEGORIE']);
		$this->FONCTION->setDbValue($row['FONCTION']);
		$this->STATUT->setDbValue($row['STATUT']);
		$this->STA_DEBUT->setDbValue($row['STA_DEBUT']);
		$this->STA_FIN->setDbValue($row['STA_FIN']);
		$this->STA_MOTIF->setDbValue($row['STA_MOTIF']);
		$this->NO_NIF->setDbValue($row['NO_NIF']);
		$this->NO_ONA->setDbValue($row['NO_ONA']);
		$this->LIV_TRAV->setDbValue($row['LIV_TRAV']);
		$this->MT_SALAIRE->setDbValue($row['MT_SALAIRE']);
		$this->MT_FRAIS->setDbValue($row['MT_FRAIS']);
		$this->MT_AUTRES->setDbValue($row['MT_AUTRES']);
		$this->MODE->setDbValue($row['MODE']);
		$this->TYPE->setDbValue($row['TYPE']);
		$this->MT_IMPOT->setDbValue($row['MT_IMPOT']);
		$this->PER_IMPOT->setDbValue($row['PER_IMPOT']);
		$this->PRET_ONA->setDbValue($row['PRET_ONA']);
		$this->PER_ONA->setDbValue($row['PER_ONA']);
		$this->RET_ASSUR->setDbValue($row['RET_ASSUR']);
		$this->PER_ASSUR->setDbValue($row['PER_ASSUR']);
		$this->PRET_SALAIRE->setDbValue($row['PRET_SALAIRE']);
		$this->PER_SALAIRE->setDbValue($row['PER_SALAIRE']);
		$this->RET_PENSION->setDbValue($row['RET_PENSION']);
		$this->PER_RETPENSION->setDbValue($row['PER_RETPENSION']);
		$this->PRET_BANQUE->setDbValue($row['PRET_BANQUE']);
		$this->PER_BANQUE->setDbValue($row['PER_BANQUE']);
		$this->RET_AVANC->setDbValue($row['RET_AVANC']);
		$this->PER_AVANCE->setDbValue($row['PER_AVANCE']);
		$this->PRET_PENSION->setDbValue($row['PRET_PENSION']);
		$this->PER_PENSION->setDbValue($row['PER_PENSION']);
		$this->RET_CAFET->setDbValue($row['RET_CAFET']);
		$this->PER_CAFET->setDbValue($row['PER_CAFET']);
		$this->RET_CITE->setDbValue($row['RET_CITE']);
		$this->PER_CITE->setDbValue($row['PER_CITE']);
		$this->RET_AUTRE->setDbValue($row['RET_AUTRE']);
		$this->PER_AUTRE->setDbValue($row['PER_AUTRE']);
		$this->ACQ_NB_CON->setDbValue($row['ACQ_NB_CON']);
		$this->ACC_MT_BRUT->setDbValue($row['ACC_MT_BRUT']);
		$this->ACC_NB_CON->setDbValue($row['ACC_NB_CON']);
		$this->ACC_NB_PCON->setDbValue($row['ACC_NB_PCON']);
		$this->ACC_MT_OVT->setDbValue($row['ACC_MT_OVT']);
		$this->ACQ_NB_MAL->setDbValue($row['ACQ_NB_MAL']);
		$this->ACC_NB_MAL->setDbValue($row['ACC_NB_MAL']);
		$this->ACC_MT_CON->setDbValue($row['ACC_MT_CON']);
		$this->ACC_NB_MAT->setDbValue($row['ACC_NB_MAT']);
		$this->ACC_MT_BONI->setDbValue($row['ACC_MT_BONI']);
		$this->ACC_NB_PER->setDbValue($row['ACC_NB_PER']);
		$this->ACC_MT_AUT->setDbValue($row['ACC_MT_AUT']);
		$this->ACC_NB_COM->setDbValue($row['ACC_NB_COM']);
		$this->ACC_BAL_SAL->setDbValue($row['ACC_BAL_SAL']);
		$this->ACC_BAL_BAN->setDbValue($row['ACC_BAL_BAN']);
		$this->ACC_NB_SUS->setDbValue($row['ACC_NB_SUS']);
		$this->ACC_BAL_ONA->setDbValue($row['ACC_BAL_ONA']);
		$this->ACC_BAL_PENSION->setDbValue($row['ACC_BAL_PENSION']);
		$this->ACC_NB_ABS->setDbValue($row['ACC_NB_ABS']);
		$this->ACC_MT_QZ->setDbValue($row['ACC_MT_QZ']);
		$this->ACC_NB_TRA->setDbValue($row['ACC_NB_TRA']);
		$this->ACC_MT_AJST->setDbValue($row['ACC_MT_AJST']);
		$this->ACC_NB_TRA_ACT->setDbValue($row['ACC_NB_TRA_ACT']);
		$this->ACC1_MT_BRUT->setDbValue($row['ACC1_MT_BRUT']);
		$this->ACC_RENDEMENT->setDbValue($row['ACC_RENDEMENT']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['RN'] = NULL;
		$row['NO_EMP'] = NULL;
		$row['NOM_EMP'] = NULL;
		$row['SEXE'] = NULL;
		$row['ETAT_C'] = NULL;
		$row['DEPEND'] = NULL;
		$row['DTE_NAIS'] = NULL;
		$row['LIEU_NAIS'] = NULL;
		$row['NATION'] = NULL;
		$row['ADRESSE'] = NULL;
		$row['VILLE'] = NULL;
		$row['PAYS'] = NULL;
		$row['BOX'] = NULL;
		$row['PHONE'] = NULL;
		$row['REFERENCE'] = NULL;
		$row['QUALIF'] = NULL;
		$row['URGENCE'] = NULL;
		$row['PHONE_URG'] = NULL;
		$row['DATE_EMP'] = NULL;
		$row['SERVICE'] = NULL;
		$row['DEPT'] = NULL;
		$row['SECTION'] = NULL;
		$row['CATEGORIE'] = NULL;
		$row['FONCTION'] = NULL;
		$row['STATUT'] = NULL;
		$row['STA_DEBUT'] = NULL;
		$row['STA_FIN'] = NULL;
		$row['STA_MOTIF'] = NULL;
		$row['NO_NIF'] = NULL;
		$row['NO_ONA'] = NULL;
		$row['LIV_TRAV'] = NULL;
		$row['MT_SALAIRE'] = NULL;
		$row['MT_FRAIS'] = NULL;
		$row['MT_AUTRES'] = NULL;
		$row['MODE'] = NULL;
		$row['TYPE'] = NULL;
		$row['MT_IMPOT'] = NULL;
		$row['PER_IMPOT'] = NULL;
		$row['PRET_ONA'] = NULL;
		$row['PER_ONA'] = NULL;
		$row['RET_ASSUR'] = NULL;
		$row['PER_ASSUR'] = NULL;
		$row['PRET_SALAIRE'] = NULL;
		$row['PER_SALAIRE'] = NULL;
		$row['RET_PENSION'] = NULL;
		$row['PER_RETPENSION'] = NULL;
		$row['PRET_BANQUE'] = NULL;
		$row['PER_BANQUE'] = NULL;
		$row['RET_AVANC'] = NULL;
		$row['PER_AVANCE'] = NULL;
		$row['PRET_PENSION'] = NULL;
		$row['PER_PENSION'] = NULL;
		$row['RET_CAFET'] = NULL;
		$row['PER_CAFET'] = NULL;
		$row['RET_CITE'] = NULL;
		$row['PER_CITE'] = NULL;
		$row['RET_AUTRE'] = NULL;
		$row['PER_AUTRE'] = NULL;
		$row['ACQ_NB_CON'] = NULL;
		$row['ACC_MT_BRUT'] = NULL;
		$row['ACC_NB_CON'] = NULL;
		$row['ACC_NB_PCON'] = NULL;
		$row['ACC_MT_OVT'] = NULL;
		$row['ACQ_NB_MAL'] = NULL;
		$row['ACC_NB_MAL'] = NULL;
		$row['ACC_MT_CON'] = NULL;
		$row['ACC_NB_MAT'] = NULL;
		$row['ACC_MT_BONI'] = NULL;
		$row['ACC_NB_PER'] = NULL;
		$row['ACC_MT_AUT'] = NULL;
		$row['ACC_NB_COM'] = NULL;
		$row['ACC_BAL_SAL'] = NULL;
		$row['ACC_BAL_BAN'] = NULL;
		$row['ACC_NB_SUS'] = NULL;
		$row['ACC_BAL_ONA'] = NULL;
		$row['ACC_BAL_PENSION'] = NULL;
		$row['ACC_NB_ABS'] = NULL;
		$row['ACC_MT_QZ'] = NULL;
		$row['ACC_NB_TRA'] = NULL;
		$row['ACC_MT_AJST'] = NULL;
		$row['ACC_NB_TRA_ACT'] = NULL;
		$row['ACC1_MT_BRUT'] = NULL;
		$row['ACC_RENDEMENT'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->id->FormValue == $this->id->CurrentValue && is_numeric(ConvertToFloatString($this->id->CurrentValue)))
			$this->id->CurrentValue = ConvertToFloatString($this->id->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RN->FormValue == $this->RN->CurrentValue && is_numeric(ConvertToFloatString($this->RN->CurrentValue)))
			$this->RN->CurrentValue = ConvertToFloatString($this->RN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->NO_EMP->FormValue == $this->NO_EMP->CurrentValue && is_numeric(ConvertToFloatString($this->NO_EMP->CurrentValue)))
			$this->NO_EMP->CurrentValue = ConvertToFloatString($this->NO_EMP->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DEPEND->FormValue == $this->DEPEND->CurrentValue && is_numeric(ConvertToFloatString($this->DEPEND->CurrentValue)))
			$this->DEPEND->CurrentValue = ConvertToFloatString($this->DEPEND->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DEPT->FormValue == $this->DEPT->CurrentValue && is_numeric(ConvertToFloatString($this->DEPT->CurrentValue)))
			$this->DEPT->CurrentValue = ConvertToFloatString($this->DEPT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->NO_NIF->FormValue == $this->NO_NIF->CurrentValue && is_numeric(ConvertToFloatString($this->NO_NIF->CurrentValue)))
			$this->NO_NIF->CurrentValue = ConvertToFloatString($this->NO_NIF->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_SALAIRE->FormValue == $this->MT_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->MT_SALAIRE->CurrentValue)))
			$this->MT_SALAIRE->CurrentValue = ConvertToFloatString($this->MT_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_FRAIS->FormValue == $this->MT_FRAIS->CurrentValue && is_numeric(ConvertToFloatString($this->MT_FRAIS->CurrentValue)))
			$this->MT_FRAIS->CurrentValue = ConvertToFloatString($this->MT_FRAIS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_AUTRES->FormValue == $this->MT_AUTRES->CurrentValue && is_numeric(ConvertToFloatString($this->MT_AUTRES->CurrentValue)))
			$this->MT_AUTRES->CurrentValue = ConvertToFloatString($this->MT_AUTRES->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_IMPOT->FormValue == $this->MT_IMPOT->CurrentValue && is_numeric(ConvertToFloatString($this->MT_IMPOT->CurrentValue)))
			$this->MT_IMPOT->CurrentValue = ConvertToFloatString($this->MT_IMPOT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_ONA->FormValue == $this->PRET_ONA->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_ONA->CurrentValue)))
			$this->PRET_ONA->CurrentValue = ConvertToFloatString($this->PRET_ONA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_ASSUR->FormValue == $this->RET_ASSUR->CurrentValue && is_numeric(ConvertToFloatString($this->RET_ASSUR->CurrentValue)))
			$this->RET_ASSUR->CurrentValue = ConvertToFloatString($this->RET_ASSUR->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_SALAIRE->FormValue == $this->PRET_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_SALAIRE->CurrentValue)))
			$this->PRET_SALAIRE->CurrentValue = ConvertToFloatString($this->PRET_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PER_SALAIRE->FormValue == $this->PER_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->PER_SALAIRE->CurrentValue)))
			$this->PER_SALAIRE->CurrentValue = ConvertToFloatString($this->PER_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_PENSION->FormValue == $this->RET_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->RET_PENSION->CurrentValue)))
			$this->RET_PENSION->CurrentValue = ConvertToFloatString($this->RET_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_BANQUE->FormValue == $this->PRET_BANQUE->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_BANQUE->CurrentValue)))
			$this->PRET_BANQUE->CurrentValue = ConvertToFloatString($this->PRET_BANQUE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PER_BANQUE->FormValue == $this->PER_BANQUE->CurrentValue && is_numeric(ConvertToFloatString($this->PER_BANQUE->CurrentValue)))
			$this->PER_BANQUE->CurrentValue = ConvertToFloatString($this->PER_BANQUE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_AVANC->FormValue == $this->RET_AVANC->CurrentValue && is_numeric(ConvertToFloatString($this->RET_AVANC->CurrentValue)))
			$this->RET_AVANC->CurrentValue = ConvertToFloatString($this->RET_AVANC->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_PENSION->FormValue == $this->PRET_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_PENSION->CurrentValue)))
			$this->PRET_PENSION->CurrentValue = ConvertToFloatString($this->PRET_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_CAFET->FormValue == $this->RET_CAFET->CurrentValue && is_numeric(ConvertToFloatString($this->RET_CAFET->CurrentValue)))
			$this->RET_CAFET->CurrentValue = ConvertToFloatString($this->RET_CAFET->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_CITE->FormValue == $this->RET_CITE->CurrentValue && is_numeric(ConvertToFloatString($this->RET_CITE->CurrentValue)))
			$this->RET_CITE->CurrentValue = ConvertToFloatString($this->RET_CITE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_AUTRE->FormValue == $this->RET_AUTRE->CurrentValue && is_numeric(ConvertToFloatString($this->RET_AUTRE->CurrentValue)))
			$this->RET_AUTRE->CurrentValue = ConvertToFloatString($this->RET_AUTRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACQ_NB_CON->FormValue == $this->ACQ_NB_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACQ_NB_CON->CurrentValue)))
			$this->ACQ_NB_CON->CurrentValue = ConvertToFloatString($this->ACQ_NB_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_BRUT->FormValue == $this->ACC_MT_BRUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_BRUT->CurrentValue)))
			$this->ACC_MT_BRUT->CurrentValue = ConvertToFloatString($this->ACC_MT_BRUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_CON->FormValue == $this->ACC_NB_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_CON->CurrentValue)))
			$this->ACC_NB_CON->CurrentValue = ConvertToFloatString($this->ACC_NB_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_PCON->FormValue == $this->ACC_NB_PCON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_PCON->CurrentValue)))
			$this->ACC_NB_PCON->CurrentValue = ConvertToFloatString($this->ACC_NB_PCON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_OVT->FormValue == $this->ACC_MT_OVT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_OVT->CurrentValue)))
			$this->ACC_MT_OVT->CurrentValue = ConvertToFloatString($this->ACC_MT_OVT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACQ_NB_MAL->FormValue == $this->ACQ_NB_MAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACQ_NB_MAL->CurrentValue)))
			$this->ACQ_NB_MAL->CurrentValue = ConvertToFloatString($this->ACQ_NB_MAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_MAL->FormValue == $this->ACC_NB_MAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_MAL->CurrentValue)))
			$this->ACC_NB_MAL->CurrentValue = ConvertToFloatString($this->ACC_NB_MAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_CON->FormValue == $this->ACC_MT_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_CON->CurrentValue)))
			$this->ACC_MT_CON->CurrentValue = ConvertToFloatString($this->ACC_MT_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_MAT->FormValue == $this->ACC_NB_MAT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_MAT->CurrentValue)))
			$this->ACC_NB_MAT->CurrentValue = ConvertToFloatString($this->ACC_NB_MAT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_BONI->FormValue == $this->ACC_MT_BONI->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_BONI->CurrentValue)))
			$this->ACC_MT_BONI->CurrentValue = ConvertToFloatString($this->ACC_MT_BONI->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_PER->FormValue == $this->ACC_NB_PER->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_PER->CurrentValue)))
			$this->ACC_NB_PER->CurrentValue = ConvertToFloatString($this->ACC_NB_PER->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_AUT->FormValue == $this->ACC_MT_AUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_AUT->CurrentValue)))
			$this->ACC_MT_AUT->CurrentValue = ConvertToFloatString($this->ACC_MT_AUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_COM->FormValue == $this->ACC_NB_COM->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_COM->CurrentValue)))
			$this->ACC_NB_COM->CurrentValue = ConvertToFloatString($this->ACC_NB_COM->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_SAL->FormValue == $this->ACC_BAL_SAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_SAL->CurrentValue)))
			$this->ACC_BAL_SAL->CurrentValue = ConvertToFloatString($this->ACC_BAL_SAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_BAN->FormValue == $this->ACC_BAL_BAN->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_BAN->CurrentValue)))
			$this->ACC_BAL_BAN->CurrentValue = ConvertToFloatString($this->ACC_BAL_BAN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_SUS->FormValue == $this->ACC_NB_SUS->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_SUS->CurrentValue)))
			$this->ACC_NB_SUS->CurrentValue = ConvertToFloatString($this->ACC_NB_SUS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_ONA->FormValue == $this->ACC_BAL_ONA->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_ONA->CurrentValue)))
			$this->ACC_BAL_ONA->CurrentValue = ConvertToFloatString($this->ACC_BAL_ONA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_PENSION->FormValue == $this->ACC_BAL_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_PENSION->CurrentValue)))
			$this->ACC_BAL_PENSION->CurrentValue = ConvertToFloatString($this->ACC_BAL_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_ABS->FormValue == $this->ACC_NB_ABS->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_ABS->CurrentValue)))
			$this->ACC_NB_ABS->CurrentValue = ConvertToFloatString($this->ACC_NB_ABS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_QZ->FormValue == $this->ACC_MT_QZ->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_QZ->CurrentValue)))
			$this->ACC_MT_QZ->CurrentValue = ConvertToFloatString($this->ACC_MT_QZ->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_TRA->FormValue == $this->ACC_NB_TRA->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_TRA->CurrentValue)))
			$this->ACC_NB_TRA->CurrentValue = ConvertToFloatString($this->ACC_NB_TRA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_AJST->FormValue == $this->ACC_MT_AJST->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_AJST->CurrentValue)))
			$this->ACC_MT_AJST->CurrentValue = ConvertToFloatString($this->ACC_MT_AJST->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_TRA_ACT->FormValue == $this->ACC_NB_TRA_ACT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_TRA_ACT->CurrentValue)))
			$this->ACC_NB_TRA_ACT->CurrentValue = ConvertToFloatString($this->ACC_NB_TRA_ACT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC1_MT_BRUT->FormValue == $this->ACC1_MT_BRUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC1_MT_BRUT->CurrentValue)))
			$this->ACC1_MT_BRUT->CurrentValue = ConvertToFloatString($this->ACC1_MT_BRUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_RENDEMENT->FormValue == $this->ACC_RENDEMENT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_RENDEMENT->CurrentValue)))
			$this->ACC_RENDEMENT->CurrentValue = ConvertToFloatString($this->ACC_RENDEMENT->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// RN
		// NO_EMP
		// NOM_EMP
		// SEXE
		// ETAT_C
		// DEPEND
		// DTE_NAIS
		// LIEU_NAIS
		// NATION
		// ADRESSE
		// VILLE
		// PAYS
		// BOX
		// PHONE
		// REFERENCE
		// QUALIF
		// URGENCE
		// PHONE_URG
		// DATE_EMP
		// SERVICE
		// DEPT
		// SECTION
		// CATEGORIE
		// FONCTION
		// STATUT
		// STA_DEBUT
		// STA_FIN
		// STA_MOTIF
		// NO_NIF
		// NO_ONA
		// LIV_TRAV
		// MT_SALAIRE
		// MT_FRAIS
		// MT_AUTRES
		// MODE
		// TYPE
		// MT_IMPOT
		// PER_IMPOT
		// PRET_ONA
		// PER_ONA
		// RET_ASSUR
		// PER_ASSUR
		// PRET_SALAIRE
		// PER_SALAIRE
		// RET_PENSION
		// PER_RETPENSION
		// PRET_BANQUE
		// PER_BANQUE
		// RET_AVANC
		// PER_AVANCE
		// PRET_PENSION
		// PER_PENSION
		// RET_CAFET
		// PER_CAFET
		// RET_CITE
		// PER_CITE
		// RET_AUTRE
		// PER_AUTRE
		// ACQ_NB_CON
		// ACC_MT_BRUT
		// ACC_NB_CON
		// ACC_NB_PCON
		// ACC_MT_OVT
		// ACQ_NB_MAL
		// ACC_NB_MAL
		// ACC_MT_CON
		// ACC_NB_MAT
		// ACC_MT_BONI
		// ACC_NB_PER
		// ACC_MT_AUT
		// ACC_NB_COM
		// ACC_BAL_SAL
		// ACC_BAL_BAN
		// ACC_NB_SUS
		// ACC_BAL_ONA
		// ACC_BAL_PENSION
		// ACC_NB_ABS
		// ACC_MT_QZ
		// ACC_NB_TRA
		// ACC_MT_AJST
		// ACC_NB_TRA_ACT
		// ACC1_MT_BRUT
		// ACC_RENDEMENT

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, Config("DEFAULT_DECIMAL_PRECISION"));
			$this->id->ViewCustomAttributes = "";

			// RN
			$this->RN->ViewValue = $this->RN->CurrentValue;
			$this->RN->ViewValue = FormatNumber($this->RN->ViewValue, Config("DEFAULT_DECIMAL_PRECISION"));
			$this->RN->ViewCustomAttributes = "";

			// NO_EMP
			$this->NO_EMP->ViewValue = $this->NO_EMP->CurrentValue;
			$this->NO_EMP->ViewValue = FormatNumber($this->NO_EMP->ViewValue, 2, -2, -2, -2);
			$this->NO_EMP->ViewCustomAttributes = "";

			// NOM_EMP
			$this->NOM_EMP->ViewValue = $this->NOM_EMP->CurrentValue;
			$this->NOM_EMP->ViewCustomAttributes = "";

			// SEXE
			$this->SEXE->ViewValue = $this->SEXE->CurrentValue;
			$this->SEXE->ViewCustomAttributes = "";

			// ETAT_C
			$this->ETAT_C->ViewValue = $this->ETAT_C->CurrentValue;
			$this->ETAT_C->ViewCustomAttributes = "";

			// DEPEND
			$this->DEPEND->ViewValue = $this->DEPEND->CurrentValue;
			$this->DEPEND->ViewValue = FormatNumber($this->DEPEND->ViewValue, 2, -2, -2, -2);
			$this->DEPEND->ViewCustomAttributes = "";

			// DTE_NAIS
			$this->DTE_NAIS->ViewValue = $this->DTE_NAIS->CurrentValue;
			$this->DTE_NAIS->ViewValue = FormatDateTime($this->DTE_NAIS->ViewValue, 0);
			$this->DTE_NAIS->ViewCustomAttributes = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->ViewValue = $this->LIEU_NAIS->CurrentValue;
			$this->LIEU_NAIS->ViewCustomAttributes = "";

			// NATION
			$this->NATION->ViewValue = $this->NATION->CurrentValue;
			$this->NATION->ViewCustomAttributes = "";

			// ADRESSE
			$this->ADRESSE->ViewValue = $this->ADRESSE->CurrentValue;
			$this->ADRESSE->ViewCustomAttributes = "";

			// VILLE
			$this->VILLE->ViewValue = $this->VILLE->CurrentValue;
			$this->VILLE->ViewCustomAttributes = "";

			// PAYS
			$this->PAYS->ViewValue = $this->PAYS->CurrentValue;
			$this->PAYS->ViewCustomAttributes = "";

			// BOX
			$this->BOX->ViewValue = $this->BOX->CurrentValue;
			$this->BOX->ViewCustomAttributes = "";

			// PHONE
			$this->PHONE->ViewValue = $this->PHONE->CurrentValue;
			$this->PHONE->ViewCustomAttributes = "";

			// REFERENCE
			$this->REFERENCE->ViewValue = $this->REFERENCE->CurrentValue;
			$this->REFERENCE->ViewCustomAttributes = "";

			// QUALIF
			$this->QUALIF->ViewValue = $this->QUALIF->CurrentValue;
			$this->QUALIF->ViewCustomAttributes = "";

			// URGENCE
			$this->URGENCE->ViewValue = $this->URGENCE->CurrentValue;
			$this->URGENCE->ViewCustomAttributes = "";

			// PHONE_URG
			$this->PHONE_URG->ViewValue = $this->PHONE_URG->CurrentValue;
			$this->PHONE_URG->ViewCustomAttributes = "";

			// DATE_EMP
			$this->DATE_EMP->ViewValue = $this->DATE_EMP->CurrentValue;
			$this->DATE_EMP->ViewValue = FormatDateTime($this->DATE_EMP->ViewValue, 0);
			$this->DATE_EMP->ViewCustomAttributes = "";

			// SERVICE
			$this->SERVICE->ViewValue = $this->SERVICE->CurrentValue;
			$this->SERVICE->ViewCustomAttributes = "";

			// DEPT
			$this->DEPT->ViewValue = $this->DEPT->CurrentValue;
			$this->DEPT->ViewValue = FormatNumber($this->DEPT->ViewValue, 2, -2, -2, -2);
			$this->DEPT->ViewCustomAttributes = "";

			// SECTION
			$this->SECTION->ViewValue = $this->SECTION->CurrentValue;
			$this->SECTION->ViewCustomAttributes = "";

			// CATEGORIE
			$this->CATEGORIE->ViewValue = $this->CATEGORIE->CurrentValue;
			$this->CATEGORIE->ViewCustomAttributes = "";

			// FONCTION
			$this->FONCTION->ViewValue = $this->FONCTION->CurrentValue;
			$this->FONCTION->ViewCustomAttributes = "";

			// STATUT
			$this->STATUT->ViewValue = $this->STATUT->CurrentValue;
			$this->STATUT->ViewCustomAttributes = "";

			// STA_DEBUT
			$this->STA_DEBUT->ViewValue = $this->STA_DEBUT->CurrentValue;
			$this->STA_DEBUT->ViewValue = FormatDateTime($this->STA_DEBUT->ViewValue, 0);
			$this->STA_DEBUT->ViewCustomAttributes = "";

			// STA_FIN
			$this->STA_FIN->ViewValue = $this->STA_FIN->CurrentValue;
			$this->STA_FIN->ViewValue = FormatDateTime($this->STA_FIN->ViewValue, 0);
			$this->STA_FIN->ViewCustomAttributes = "";

			// STA_MOTIF
			$this->STA_MOTIF->ViewValue = $this->STA_MOTIF->CurrentValue;
			$this->STA_MOTIF->ViewCustomAttributes = "";

			// NO_NIF
			$this->NO_NIF->ViewValue = $this->NO_NIF->CurrentValue;
			$this->NO_NIF->ViewValue = FormatNumber($this->NO_NIF->ViewValue, 2, -2, -2, -2);
			$this->NO_NIF->ViewCustomAttributes = "";

			// NO_ONA
			$this->NO_ONA->ViewValue = $this->NO_ONA->CurrentValue;
			$this->NO_ONA->ViewCustomAttributes = "";

			// LIV_TRAV
			$this->LIV_TRAV->ViewValue = $this->LIV_TRAV->CurrentValue;
			$this->LIV_TRAV->ViewCustomAttributes = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->ViewValue = $this->MT_SALAIRE->CurrentValue;
			$this->MT_SALAIRE->ViewValue = FormatNumber($this->MT_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->MT_SALAIRE->ViewCustomAttributes = "";

			// MT_FRAIS
			$this->MT_FRAIS->ViewValue = $this->MT_FRAIS->CurrentValue;
			$this->MT_FRAIS->ViewValue = FormatNumber($this->MT_FRAIS->ViewValue, 2, -2, -2, -2);
			$this->MT_FRAIS->ViewCustomAttributes = "";

			// MT_AUTRES
			$this->MT_AUTRES->ViewValue = $this->MT_AUTRES->CurrentValue;
			$this->MT_AUTRES->ViewValue = FormatNumber($this->MT_AUTRES->ViewValue, 2, -2, -2, -2);
			$this->MT_AUTRES->ViewCustomAttributes = "";

			// MODE
			$this->MODE->ViewValue = $this->MODE->CurrentValue;
			$this->MODE->ViewCustomAttributes = "";

			// TYPE
			$this->TYPE->ViewValue = $this->TYPE->CurrentValue;
			$this->TYPE->ViewCustomAttributes = "";

			// MT_IMPOT
			$this->MT_IMPOT->ViewValue = $this->MT_IMPOT->CurrentValue;
			$this->MT_IMPOT->ViewValue = FormatNumber($this->MT_IMPOT->ViewValue, 2, -2, -2, -2);
			$this->MT_IMPOT->ViewCustomAttributes = "";

			// PER_IMPOT
			$this->PER_IMPOT->ViewValue = $this->PER_IMPOT->CurrentValue;
			$this->PER_IMPOT->ViewCustomAttributes = "";

			// PRET_ONA
			$this->PRET_ONA->ViewValue = $this->PRET_ONA->CurrentValue;
			$this->PRET_ONA->ViewValue = FormatNumber($this->PRET_ONA->ViewValue, 2, -2, -2, -2);
			$this->PRET_ONA->ViewCustomAttributes = "";

			// PER_ONA
			$this->PER_ONA->ViewValue = $this->PER_ONA->CurrentValue;
			$this->PER_ONA->ViewCustomAttributes = "";

			// RET_ASSUR
			$this->RET_ASSUR->ViewValue = $this->RET_ASSUR->CurrentValue;
			$this->RET_ASSUR->ViewValue = FormatNumber($this->RET_ASSUR->ViewValue, 2, -2, -2, -2);
			$this->RET_ASSUR->ViewCustomAttributes = "";

			// PER_ASSUR
			$this->PER_ASSUR->ViewValue = $this->PER_ASSUR->CurrentValue;
			$this->PER_ASSUR->ViewCustomAttributes = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->ViewValue = $this->PRET_SALAIRE->CurrentValue;
			$this->PRET_SALAIRE->ViewValue = FormatNumber($this->PRET_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->PRET_SALAIRE->ViewCustomAttributes = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->ViewValue = $this->PER_SALAIRE->CurrentValue;
			$this->PER_SALAIRE->ViewValue = FormatNumber($this->PER_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->PER_SALAIRE->ViewCustomAttributes = "";

			// RET_PENSION
			$this->RET_PENSION->ViewValue = $this->RET_PENSION->CurrentValue;
			$this->RET_PENSION->ViewValue = FormatNumber($this->RET_PENSION->ViewValue, 2, -2, -2, -2);
			$this->RET_PENSION->ViewCustomAttributes = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->ViewValue = $this->PER_RETPENSION->CurrentValue;
			$this->PER_RETPENSION->ViewCustomAttributes = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->ViewValue = $this->PRET_BANQUE->CurrentValue;
			$this->PRET_BANQUE->ViewValue = FormatNumber($this->PRET_BANQUE->ViewValue, 2, -2, -2, -2);
			$this->PRET_BANQUE->ViewCustomAttributes = "";

			// PER_BANQUE
			$this->PER_BANQUE->ViewValue = $this->PER_BANQUE->CurrentValue;
			$this->PER_BANQUE->ViewValue = FormatNumber($this->PER_BANQUE->ViewValue, 2, -2, -2, -2);
			$this->PER_BANQUE->ViewCustomAttributes = "";

			// RET_AVANC
			$this->RET_AVANC->ViewValue = $this->RET_AVANC->CurrentValue;
			$this->RET_AVANC->ViewValue = FormatNumber($this->RET_AVANC->ViewValue, 2, -2, -2, -2);
			$this->RET_AVANC->ViewCustomAttributes = "";

			// PER_AVANCE
			$this->PER_AVANCE->ViewValue = $this->PER_AVANCE->CurrentValue;
			$this->PER_AVANCE->ViewCustomAttributes = "";

			// PRET_PENSION
			$this->PRET_PENSION->ViewValue = $this->PRET_PENSION->CurrentValue;
			$this->PRET_PENSION->ViewValue = FormatNumber($this->PRET_PENSION->ViewValue, 2, -2, -2, -2);
			$this->PRET_PENSION->ViewCustomAttributes = "";

			// PER_PENSION
			$this->PER_PENSION->ViewValue = $this->PER_PENSION->CurrentValue;
			$this->PER_PENSION->ViewCustomAttributes = "";

			// RET_CAFET
			$this->RET_CAFET->ViewValue = $this->RET_CAFET->CurrentValue;
			$this->RET_CAFET->ViewValue = FormatNumber($this->RET_CAFET->ViewValue, 2, -2, -2, -2);
			$this->RET_CAFET->ViewCustomAttributes = "";

			// PER_CAFET
			$this->PER_CAFET->ViewValue = $this->PER_CAFET->CurrentValue;
			$this->PER_CAFET->ViewCustomAttributes = "";

			// RET_CITE
			$this->RET_CITE->ViewValue = $this->RET_CITE->CurrentValue;
			$this->RET_CITE->ViewValue = FormatNumber($this->RET_CITE->ViewValue, 2, -2, -2, -2);
			$this->RET_CITE->ViewCustomAttributes = "";

			// PER_CITE
			$this->PER_CITE->ViewValue = $this->PER_CITE->CurrentValue;
			$this->PER_CITE->ViewCustomAttributes = "";

			// RET_AUTRE
			$this->RET_AUTRE->ViewValue = $this->RET_AUTRE->CurrentValue;
			$this->RET_AUTRE->ViewValue = FormatNumber($this->RET_AUTRE->ViewValue, 2, -2, -2, -2);
			$this->RET_AUTRE->ViewCustomAttributes = "";

			// PER_AUTRE
			$this->PER_AUTRE->ViewValue = $this->PER_AUTRE->CurrentValue;
			$this->PER_AUTRE->ViewCustomAttributes = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->ViewValue = $this->ACQ_NB_CON->CurrentValue;
			$this->ACQ_NB_CON->ViewValue = FormatNumber($this->ACQ_NB_CON->ViewValue, 2, -2, -2, -2);
			$this->ACQ_NB_CON->ViewCustomAttributes = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->ViewValue = $this->ACC_MT_BRUT->CurrentValue;
			$this->ACC_MT_BRUT->ViewValue = FormatNumber($this->ACC_MT_BRUT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_BRUT->ViewCustomAttributes = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->ViewValue = $this->ACC_NB_CON->CurrentValue;
			$this->ACC_NB_CON->ViewValue = FormatNumber($this->ACC_NB_CON->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_CON->ViewCustomAttributes = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->ViewValue = $this->ACC_NB_PCON->CurrentValue;
			$this->ACC_NB_PCON->ViewValue = FormatNumber($this->ACC_NB_PCON->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_PCON->ViewCustomAttributes = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->ViewValue = $this->ACC_MT_OVT->CurrentValue;
			$this->ACC_MT_OVT->ViewValue = FormatNumber($this->ACC_MT_OVT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_OVT->ViewCustomAttributes = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->ViewValue = $this->ACQ_NB_MAL->CurrentValue;
			$this->ACQ_NB_MAL->ViewValue = FormatNumber($this->ACQ_NB_MAL->ViewValue, 2, -2, -2, -2);
			$this->ACQ_NB_MAL->ViewCustomAttributes = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->ViewValue = $this->ACC_NB_MAL->CurrentValue;
			$this->ACC_NB_MAL->ViewValue = FormatNumber($this->ACC_NB_MAL->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_MAL->ViewCustomAttributes = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->ViewValue = $this->ACC_MT_CON->CurrentValue;
			$this->ACC_MT_CON->ViewValue = FormatNumber($this->ACC_MT_CON->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_CON->ViewCustomAttributes = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->ViewValue = $this->ACC_NB_MAT->CurrentValue;
			$this->ACC_NB_MAT->ViewValue = FormatNumber($this->ACC_NB_MAT->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_MAT->ViewCustomAttributes = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->ViewValue = $this->ACC_MT_BONI->CurrentValue;
			$this->ACC_MT_BONI->ViewValue = FormatNumber($this->ACC_MT_BONI->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_BONI->ViewCustomAttributes = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->ViewValue = $this->ACC_NB_PER->CurrentValue;
			$this->ACC_NB_PER->ViewValue = FormatNumber($this->ACC_NB_PER->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_PER->ViewCustomAttributes = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->ViewValue = $this->ACC_MT_AUT->CurrentValue;
			$this->ACC_MT_AUT->ViewValue = FormatNumber($this->ACC_MT_AUT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_AUT->ViewCustomAttributes = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->ViewValue = $this->ACC_NB_COM->CurrentValue;
			$this->ACC_NB_COM->ViewValue = FormatNumber($this->ACC_NB_COM->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_COM->ViewCustomAttributes = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->ViewValue = $this->ACC_BAL_SAL->CurrentValue;
			$this->ACC_BAL_SAL->ViewValue = FormatNumber($this->ACC_BAL_SAL->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_SAL->ViewCustomAttributes = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->ViewValue = $this->ACC_BAL_BAN->CurrentValue;
			$this->ACC_BAL_BAN->ViewValue = FormatNumber($this->ACC_BAL_BAN->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_BAN->ViewCustomAttributes = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->ViewValue = $this->ACC_NB_SUS->CurrentValue;
			$this->ACC_NB_SUS->ViewValue = FormatNumber($this->ACC_NB_SUS->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_SUS->ViewCustomAttributes = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->ViewValue = $this->ACC_BAL_ONA->CurrentValue;
			$this->ACC_BAL_ONA->ViewValue = FormatNumber($this->ACC_BAL_ONA->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_ONA->ViewCustomAttributes = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->ViewValue = $this->ACC_BAL_PENSION->CurrentValue;
			$this->ACC_BAL_PENSION->ViewValue = FormatNumber($this->ACC_BAL_PENSION->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_PENSION->ViewCustomAttributes = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->ViewValue = $this->ACC_NB_ABS->CurrentValue;
			$this->ACC_NB_ABS->ViewValue = FormatNumber($this->ACC_NB_ABS->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_ABS->ViewCustomAttributes = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->ViewValue = $this->ACC_MT_QZ->CurrentValue;
			$this->ACC_MT_QZ->ViewValue = FormatNumber($this->ACC_MT_QZ->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_QZ->ViewCustomAttributes = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->ViewValue = $this->ACC_NB_TRA->CurrentValue;
			$this->ACC_NB_TRA->ViewValue = FormatNumber($this->ACC_NB_TRA->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_TRA->ViewCustomAttributes = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->ViewValue = $this->ACC_MT_AJST->CurrentValue;
			$this->ACC_MT_AJST->ViewValue = FormatNumber($this->ACC_MT_AJST->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_AJST->ViewCustomAttributes = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->ViewValue = $this->ACC_NB_TRA_ACT->CurrentValue;
			$this->ACC_NB_TRA_ACT->ViewValue = FormatNumber($this->ACC_NB_TRA_ACT->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_TRA_ACT->ViewCustomAttributes = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->ViewValue = $this->ACC1_MT_BRUT->CurrentValue;
			$this->ACC1_MT_BRUT->ViewValue = FormatNumber($this->ACC1_MT_BRUT->ViewValue, 2, -2, -2, -2);
			$this->ACC1_MT_BRUT->ViewCustomAttributes = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->ViewValue = $this->ACC_RENDEMENT->CurrentValue;
			$this->ACC_RENDEMENT->ViewValue = FormatNumber($this->ACC_RENDEMENT->ViewValue, 2, -2, -2, -2);
			$this->ACC_RENDEMENT->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// RN
			$this->RN->LinkCustomAttributes = "";
			$this->RN->HrefValue = "";
			$this->RN->TooltipValue = "";

			// NO_EMP
			$this->NO_EMP->LinkCustomAttributes = "";
			$this->NO_EMP->HrefValue = "";
			$this->NO_EMP->TooltipValue = "";

			// NOM_EMP
			$this->NOM_EMP->LinkCustomAttributes = "";
			$this->NOM_EMP->HrefValue = "";
			$this->NOM_EMP->TooltipValue = "";

			// SEXE
			$this->SEXE->LinkCustomAttributes = "";
			$this->SEXE->HrefValue = "";
			$this->SEXE->TooltipValue = "";

			// ETAT_C
			$this->ETAT_C->LinkCustomAttributes = "";
			$this->ETAT_C->HrefValue = "";
			$this->ETAT_C->TooltipValue = "";

			// DEPEND
			$this->DEPEND->LinkCustomAttributes = "";
			$this->DEPEND->HrefValue = "";
			$this->DEPEND->TooltipValue = "";

			// DTE_NAIS
			$this->DTE_NAIS->LinkCustomAttributes = "";
			$this->DTE_NAIS->HrefValue = "";
			$this->DTE_NAIS->TooltipValue = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->LinkCustomAttributes = "";
			$this->LIEU_NAIS->HrefValue = "";
			$this->LIEU_NAIS->TooltipValue = "";

			// NATION
			$this->NATION->LinkCustomAttributes = "";
			$this->NATION->HrefValue = "";
			$this->NATION->TooltipValue = "";

			// ADRESSE
			$this->ADRESSE->LinkCustomAttributes = "";
			$this->ADRESSE->HrefValue = "";
			$this->ADRESSE->TooltipValue = "";

			// VILLE
			$this->VILLE->LinkCustomAttributes = "";
			$this->VILLE->HrefValue = "";
			$this->VILLE->TooltipValue = "";

			// PAYS
			$this->PAYS->LinkCustomAttributes = "";
			$this->PAYS->HrefValue = "";
			$this->PAYS->TooltipValue = "";

			// BOX
			$this->BOX->LinkCustomAttributes = "";
			$this->BOX->HrefValue = "";
			$this->BOX->TooltipValue = "";

			// PHONE
			$this->PHONE->LinkCustomAttributes = "";
			$this->PHONE->HrefValue = "";
			$this->PHONE->TooltipValue = "";

			// REFERENCE
			$this->REFERENCE->LinkCustomAttributes = "";
			$this->REFERENCE->HrefValue = "";
			$this->REFERENCE->TooltipValue = "";

			// QUALIF
			$this->QUALIF->LinkCustomAttributes = "";
			$this->QUALIF->HrefValue = "";
			$this->QUALIF->TooltipValue = "";

			// URGENCE
			$this->URGENCE->LinkCustomAttributes = "";
			$this->URGENCE->HrefValue = "";
			$this->URGENCE->TooltipValue = "";

			// PHONE_URG
			$this->PHONE_URG->LinkCustomAttributes = "";
			$this->PHONE_URG->HrefValue = "";
			$this->PHONE_URG->TooltipValue = "";

			// DATE_EMP
			$this->DATE_EMP->LinkCustomAttributes = "";
			$this->DATE_EMP->HrefValue = "";
			$this->DATE_EMP->TooltipValue = "";

			// SERVICE
			$this->SERVICE->LinkCustomAttributes = "";
			$this->SERVICE->HrefValue = "";
			$this->SERVICE->TooltipValue = "";

			// DEPT
			$this->DEPT->LinkCustomAttributes = "";
			$this->DEPT->HrefValue = "";
			$this->DEPT->TooltipValue = "";

			// SECTION
			$this->SECTION->LinkCustomAttributes = "";
			$this->SECTION->HrefValue = "";
			$this->SECTION->TooltipValue = "";

			// CATEGORIE
			$this->CATEGORIE->LinkCustomAttributes = "";
			$this->CATEGORIE->HrefValue = "";
			$this->CATEGORIE->TooltipValue = "";

			// FONCTION
			$this->FONCTION->LinkCustomAttributes = "";
			$this->FONCTION->HrefValue = "";
			$this->FONCTION->TooltipValue = "";

			// STATUT
			$this->STATUT->LinkCustomAttributes = "";
			$this->STATUT->HrefValue = "";
			$this->STATUT->TooltipValue = "";

			// STA_DEBUT
			$this->STA_DEBUT->LinkCustomAttributes = "";
			$this->STA_DEBUT->HrefValue = "";
			$this->STA_DEBUT->TooltipValue = "";

			// STA_FIN
			$this->STA_FIN->LinkCustomAttributes = "";
			$this->STA_FIN->HrefValue = "";
			$this->STA_FIN->TooltipValue = "";

			// STA_MOTIF
			$this->STA_MOTIF->LinkCustomAttributes = "";
			$this->STA_MOTIF->HrefValue = "";
			$this->STA_MOTIF->TooltipValue = "";

			// NO_NIF
			$this->NO_NIF->LinkCustomAttributes = "";
			$this->NO_NIF->HrefValue = "";
			$this->NO_NIF->TooltipValue = "";

			// NO_ONA
			$this->NO_ONA->LinkCustomAttributes = "";
			$this->NO_ONA->HrefValue = "";
			$this->NO_ONA->TooltipValue = "";

			// LIV_TRAV
			$this->LIV_TRAV->LinkCustomAttributes = "";
			$this->LIV_TRAV->HrefValue = "";
			$this->LIV_TRAV->TooltipValue = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->LinkCustomAttributes = "";
			$this->MT_SALAIRE->HrefValue = "";
			$this->MT_SALAIRE->TooltipValue = "";

			// MT_FRAIS
			$this->MT_FRAIS->LinkCustomAttributes = "";
			$this->MT_FRAIS->HrefValue = "";
			$this->MT_FRAIS->TooltipValue = "";

			// MT_AUTRES
			$this->MT_AUTRES->LinkCustomAttributes = "";
			$this->MT_AUTRES->HrefValue = "";
			$this->MT_AUTRES->TooltipValue = "";

			// MODE
			$this->MODE->LinkCustomAttributes = "";
			$this->MODE->HrefValue = "";
			$this->MODE->TooltipValue = "";

			// TYPE
			$this->TYPE->LinkCustomAttributes = "";
			$this->TYPE->HrefValue = "";
			$this->TYPE->TooltipValue = "";

			// MT_IMPOT
			$this->MT_IMPOT->LinkCustomAttributes = "";
			$this->MT_IMPOT->HrefValue = "";
			$this->MT_IMPOT->TooltipValue = "";

			// PER_IMPOT
			$this->PER_IMPOT->LinkCustomAttributes = "";
			$this->PER_IMPOT->HrefValue = "";
			$this->PER_IMPOT->TooltipValue = "";

			// PRET_ONA
			$this->PRET_ONA->LinkCustomAttributes = "";
			$this->PRET_ONA->HrefValue = "";
			$this->PRET_ONA->TooltipValue = "";

			// PER_ONA
			$this->PER_ONA->LinkCustomAttributes = "";
			$this->PER_ONA->HrefValue = "";
			$this->PER_ONA->TooltipValue = "";

			// RET_ASSUR
			$this->RET_ASSUR->LinkCustomAttributes = "";
			$this->RET_ASSUR->HrefValue = "";
			$this->RET_ASSUR->TooltipValue = "";

			// PER_ASSUR
			$this->PER_ASSUR->LinkCustomAttributes = "";
			$this->PER_ASSUR->HrefValue = "";
			$this->PER_ASSUR->TooltipValue = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->LinkCustomAttributes = "";
			$this->PRET_SALAIRE->HrefValue = "";
			$this->PRET_SALAIRE->TooltipValue = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->LinkCustomAttributes = "";
			$this->PER_SALAIRE->HrefValue = "";
			$this->PER_SALAIRE->TooltipValue = "";

			// RET_PENSION
			$this->RET_PENSION->LinkCustomAttributes = "";
			$this->RET_PENSION->HrefValue = "";
			$this->RET_PENSION->TooltipValue = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->LinkCustomAttributes = "";
			$this->PER_RETPENSION->HrefValue = "";
			$this->PER_RETPENSION->TooltipValue = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->LinkCustomAttributes = "";
			$this->PRET_BANQUE->HrefValue = "";
			$this->PRET_BANQUE->TooltipValue = "";

			// PER_BANQUE
			$this->PER_BANQUE->LinkCustomAttributes = "";
			$this->PER_BANQUE->HrefValue = "";
			$this->PER_BANQUE->TooltipValue = "";

			// RET_AVANC
			$this->RET_AVANC->LinkCustomAttributes = "";
			$this->RET_AVANC->HrefValue = "";
			$this->RET_AVANC->TooltipValue = "";

			// PER_AVANCE
			$this->PER_AVANCE->LinkCustomAttributes = "";
			$this->PER_AVANCE->HrefValue = "";
			$this->PER_AVANCE->TooltipValue = "";

			// PRET_PENSION
			$this->PRET_PENSION->LinkCustomAttributes = "";
			$this->PRET_PENSION->HrefValue = "";
			$this->PRET_PENSION->TooltipValue = "";

			// PER_PENSION
			$this->PER_PENSION->LinkCustomAttributes = "";
			$this->PER_PENSION->HrefValue = "";
			$this->PER_PENSION->TooltipValue = "";

			// RET_CAFET
			$this->RET_CAFET->LinkCustomAttributes = "";
			$this->RET_CAFET->HrefValue = "";
			$this->RET_CAFET->TooltipValue = "";

			// PER_CAFET
			$this->PER_CAFET->LinkCustomAttributes = "";
			$this->PER_CAFET->HrefValue = "";
			$this->PER_CAFET->TooltipValue = "";

			// RET_CITE
			$this->RET_CITE->LinkCustomAttributes = "";
			$this->RET_CITE->HrefValue = "";
			$this->RET_CITE->TooltipValue = "";

			// PER_CITE
			$this->PER_CITE->LinkCustomAttributes = "";
			$this->PER_CITE->HrefValue = "";
			$this->PER_CITE->TooltipValue = "";

			// RET_AUTRE
			$this->RET_AUTRE->LinkCustomAttributes = "";
			$this->RET_AUTRE->HrefValue = "";
			$this->RET_AUTRE->TooltipValue = "";

			// PER_AUTRE
			$this->PER_AUTRE->LinkCustomAttributes = "";
			$this->PER_AUTRE->HrefValue = "";
			$this->PER_AUTRE->TooltipValue = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->LinkCustomAttributes = "";
			$this->ACQ_NB_CON->HrefValue = "";
			$this->ACQ_NB_CON->TooltipValue = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC_MT_BRUT->HrefValue = "";
			$this->ACC_MT_BRUT->TooltipValue = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->LinkCustomAttributes = "";
			$this->ACC_NB_CON->HrefValue = "";
			$this->ACC_NB_CON->TooltipValue = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->LinkCustomAttributes = "";
			$this->ACC_NB_PCON->HrefValue = "";
			$this->ACC_NB_PCON->TooltipValue = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->LinkCustomAttributes = "";
			$this->ACC_MT_OVT->HrefValue = "";
			$this->ACC_MT_OVT->TooltipValue = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->LinkCustomAttributes = "";
			$this->ACQ_NB_MAL->HrefValue = "";
			$this->ACQ_NB_MAL->TooltipValue = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->LinkCustomAttributes = "";
			$this->ACC_NB_MAL->HrefValue = "";
			$this->ACC_NB_MAL->TooltipValue = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->LinkCustomAttributes = "";
			$this->ACC_MT_CON->HrefValue = "";
			$this->ACC_MT_CON->TooltipValue = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->LinkCustomAttributes = "";
			$this->ACC_NB_MAT->HrefValue = "";
			$this->ACC_NB_MAT->TooltipValue = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->LinkCustomAttributes = "";
			$this->ACC_MT_BONI->HrefValue = "";
			$this->ACC_MT_BONI->TooltipValue = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->LinkCustomAttributes = "";
			$this->ACC_NB_PER->HrefValue = "";
			$this->ACC_NB_PER->TooltipValue = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->LinkCustomAttributes = "";
			$this->ACC_MT_AUT->HrefValue = "";
			$this->ACC_MT_AUT->TooltipValue = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->LinkCustomAttributes = "";
			$this->ACC_NB_COM->HrefValue = "";
			$this->ACC_NB_COM->TooltipValue = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->LinkCustomAttributes = "";
			$this->ACC_BAL_SAL->HrefValue = "";
			$this->ACC_BAL_SAL->TooltipValue = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->LinkCustomAttributes = "";
			$this->ACC_BAL_BAN->HrefValue = "";
			$this->ACC_BAL_BAN->TooltipValue = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->LinkCustomAttributes = "";
			$this->ACC_NB_SUS->HrefValue = "";
			$this->ACC_NB_SUS->TooltipValue = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->LinkCustomAttributes = "";
			$this->ACC_BAL_ONA->HrefValue = "";
			$this->ACC_BAL_ONA->TooltipValue = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->LinkCustomAttributes = "";
			$this->ACC_BAL_PENSION->HrefValue = "";
			$this->ACC_BAL_PENSION->TooltipValue = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->LinkCustomAttributes = "";
			$this->ACC_NB_ABS->HrefValue = "";
			$this->ACC_NB_ABS->TooltipValue = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->LinkCustomAttributes = "";
			$this->ACC_MT_QZ->HrefValue = "";
			$this->ACC_MT_QZ->TooltipValue = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->LinkCustomAttributes = "";
			$this->ACC_NB_TRA->HrefValue = "";
			$this->ACC_NB_TRA->TooltipValue = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->LinkCustomAttributes = "";
			$this->ACC_MT_AJST->HrefValue = "";
			$this->ACC_MT_AJST->TooltipValue = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->LinkCustomAttributes = "";
			$this->ACC_NB_TRA_ACT->HrefValue = "";
			$this->ACC_NB_TRA_ACT->TooltipValue = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC1_MT_BRUT->HrefValue = "";
			$this->ACC1_MT_BRUT->TooltipValue = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->LinkCustomAttributes = "";
			$this->ACC_RENDEMENT->HrefValue = "";
			$this->ACC_RENDEMENT->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->CurrentValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());
			if (strval($this->id->EditValue) != "" && is_numeric($this->id->EditValue))
				$this->id->EditValue = FormatNumber($this->id->EditValue, -2, -1, -2, 0);
			

			// RN
			$this->RN->EditAttrs["class"] = "form-control";
			$this->RN->EditCustomAttributes = "";
			$this->RN->EditValue = HtmlEncode($this->RN->CurrentValue);
			$this->RN->PlaceHolder = RemoveHtml($this->RN->caption());

			// NO_EMP
			$this->NO_EMP->EditAttrs["class"] = "form-control";
			$this->NO_EMP->EditCustomAttributes = "";
			$this->NO_EMP->EditValue = HtmlEncode($this->NO_EMP->CurrentValue);
			$this->NO_EMP->PlaceHolder = RemoveHtml($this->NO_EMP->caption());
			if (strval($this->NO_EMP->EditValue) != "" && is_numeric($this->NO_EMP->EditValue))
				$this->NO_EMP->EditValue = FormatNumber($this->NO_EMP->EditValue, -2, -2, -2, -2);
			

			// NOM_EMP
			$this->NOM_EMP->EditAttrs["class"] = "form-control";
			$this->NOM_EMP->EditCustomAttributes = "";
			if (!$this->NOM_EMP->Raw)
				$this->NOM_EMP->CurrentValue = HtmlDecode($this->NOM_EMP->CurrentValue);
			$this->NOM_EMP->EditValue = HtmlEncode($this->NOM_EMP->CurrentValue);
			$this->NOM_EMP->PlaceHolder = RemoveHtml($this->NOM_EMP->caption());

			// SEXE
			$this->SEXE->EditAttrs["class"] = "form-control";
			$this->SEXE->EditCustomAttributes = "";
			if (!$this->SEXE->Raw)
				$this->SEXE->CurrentValue = HtmlDecode($this->SEXE->CurrentValue);
			$this->SEXE->EditValue = HtmlEncode($this->SEXE->CurrentValue);
			$this->SEXE->PlaceHolder = RemoveHtml($this->SEXE->caption());

			// ETAT_C
			$this->ETAT_C->EditAttrs["class"] = "form-control";
			$this->ETAT_C->EditCustomAttributes = "";
			if (!$this->ETAT_C->Raw)
				$this->ETAT_C->CurrentValue = HtmlDecode($this->ETAT_C->CurrentValue);
			$this->ETAT_C->EditValue = HtmlEncode($this->ETAT_C->CurrentValue);
			$this->ETAT_C->PlaceHolder = RemoveHtml($this->ETAT_C->caption());

			// DEPEND
			$this->DEPEND->EditAttrs["class"] = "form-control";
			$this->DEPEND->EditCustomAttributes = "";
			$this->DEPEND->EditValue = HtmlEncode($this->DEPEND->CurrentValue);
			$this->DEPEND->PlaceHolder = RemoveHtml($this->DEPEND->caption());
			if (strval($this->DEPEND->EditValue) != "" && is_numeric($this->DEPEND->EditValue))
				$this->DEPEND->EditValue = FormatNumber($this->DEPEND->EditValue, -2, -2, -2, -2);
			

			// DTE_NAIS
			$this->DTE_NAIS->EditAttrs["class"] = "form-control";
			$this->DTE_NAIS->EditCustomAttributes = "";
			$this->DTE_NAIS->EditValue = HtmlEncode(FormatDateTime($this->DTE_NAIS->CurrentValue, 8));
			$this->DTE_NAIS->PlaceHolder = RemoveHtml($this->DTE_NAIS->caption());

			// LIEU_NAIS
			$this->LIEU_NAIS->EditAttrs["class"] = "form-control";
			$this->LIEU_NAIS->EditCustomAttributes = "";
			if (!$this->LIEU_NAIS->Raw)
				$this->LIEU_NAIS->CurrentValue = HtmlDecode($this->LIEU_NAIS->CurrentValue);
			$this->LIEU_NAIS->EditValue = HtmlEncode($this->LIEU_NAIS->CurrentValue);
			$this->LIEU_NAIS->PlaceHolder = RemoveHtml($this->LIEU_NAIS->caption());

			// NATION
			$this->NATION->EditAttrs["class"] = "form-control";
			$this->NATION->EditCustomAttributes = "";
			if (!$this->NATION->Raw)
				$this->NATION->CurrentValue = HtmlDecode($this->NATION->CurrentValue);
			$this->NATION->EditValue = HtmlEncode($this->NATION->CurrentValue);
			$this->NATION->PlaceHolder = RemoveHtml($this->NATION->caption());

			// ADRESSE
			$this->ADRESSE->EditAttrs["class"] = "form-control";
			$this->ADRESSE->EditCustomAttributes = "";
			if (!$this->ADRESSE->Raw)
				$this->ADRESSE->CurrentValue = HtmlDecode($this->ADRESSE->CurrentValue);
			$this->ADRESSE->EditValue = HtmlEncode($this->ADRESSE->CurrentValue);
			$this->ADRESSE->PlaceHolder = RemoveHtml($this->ADRESSE->caption());

			// VILLE
			$this->VILLE->EditAttrs["class"] = "form-control";
			$this->VILLE->EditCustomAttributes = "";
			if (!$this->VILLE->Raw)
				$this->VILLE->CurrentValue = HtmlDecode($this->VILLE->CurrentValue);
			$this->VILLE->EditValue = HtmlEncode($this->VILLE->CurrentValue);
			$this->VILLE->PlaceHolder = RemoveHtml($this->VILLE->caption());

			// PAYS
			$this->PAYS->EditAttrs["class"] = "form-control";
			$this->PAYS->EditCustomAttributes = "";
			if (!$this->PAYS->Raw)
				$this->PAYS->CurrentValue = HtmlDecode($this->PAYS->CurrentValue);
			$this->PAYS->EditValue = HtmlEncode($this->PAYS->CurrentValue);
			$this->PAYS->PlaceHolder = RemoveHtml($this->PAYS->caption());

			// BOX
			$this->BOX->EditAttrs["class"] = "form-control";
			$this->BOX->EditCustomAttributes = "";
			if (!$this->BOX->Raw)
				$this->BOX->CurrentValue = HtmlDecode($this->BOX->CurrentValue);
			$this->BOX->EditValue = HtmlEncode($this->BOX->CurrentValue);
			$this->BOX->PlaceHolder = RemoveHtml($this->BOX->caption());

			// PHONE
			$this->PHONE->EditAttrs["class"] = "form-control";
			$this->PHONE->EditCustomAttributes = "";
			if (!$this->PHONE->Raw)
				$this->PHONE->CurrentValue = HtmlDecode($this->PHONE->CurrentValue);
			$this->PHONE->EditValue = HtmlEncode($this->PHONE->CurrentValue);
			$this->PHONE->PlaceHolder = RemoveHtml($this->PHONE->caption());

			// REFERENCE
			$this->REFERENCE->EditAttrs["class"] = "form-control";
			$this->REFERENCE->EditCustomAttributes = "";
			if (!$this->REFERENCE->Raw)
				$this->REFERENCE->CurrentValue = HtmlDecode($this->REFERENCE->CurrentValue);
			$this->REFERENCE->EditValue = HtmlEncode($this->REFERENCE->CurrentValue);
			$this->REFERENCE->PlaceHolder = RemoveHtml($this->REFERENCE->caption());

			// QUALIF
			$this->QUALIF->EditAttrs["class"] = "form-control";
			$this->QUALIF->EditCustomAttributes = "";
			if (!$this->QUALIF->Raw)
				$this->QUALIF->CurrentValue = HtmlDecode($this->QUALIF->CurrentValue);
			$this->QUALIF->EditValue = HtmlEncode($this->QUALIF->CurrentValue);
			$this->QUALIF->PlaceHolder = RemoveHtml($this->QUALIF->caption());

			// URGENCE
			$this->URGENCE->EditAttrs["class"] = "form-control";
			$this->URGENCE->EditCustomAttributes = "";
			if (!$this->URGENCE->Raw)
				$this->URGENCE->CurrentValue = HtmlDecode($this->URGENCE->CurrentValue);
			$this->URGENCE->EditValue = HtmlEncode($this->URGENCE->CurrentValue);
			$this->URGENCE->PlaceHolder = RemoveHtml($this->URGENCE->caption());

			// PHONE_URG
			$this->PHONE_URG->EditAttrs["class"] = "form-control";
			$this->PHONE_URG->EditCustomAttributes = "";
			if (!$this->PHONE_URG->Raw)
				$this->PHONE_URG->CurrentValue = HtmlDecode($this->PHONE_URG->CurrentValue);
			$this->PHONE_URG->EditValue = HtmlEncode($this->PHONE_URG->CurrentValue);
			$this->PHONE_URG->PlaceHolder = RemoveHtml($this->PHONE_URG->caption());

			// DATE_EMP
			$this->DATE_EMP->EditAttrs["class"] = "form-control";
			$this->DATE_EMP->EditCustomAttributes = "";
			$this->DATE_EMP->EditValue = HtmlEncode(FormatDateTime($this->DATE_EMP->CurrentValue, 8));
			$this->DATE_EMP->PlaceHolder = RemoveHtml($this->DATE_EMP->caption());

			// SERVICE
			$this->SERVICE->EditAttrs["class"] = "form-control";
			$this->SERVICE->EditCustomAttributes = "";
			if (!$this->SERVICE->Raw)
				$this->SERVICE->CurrentValue = HtmlDecode($this->SERVICE->CurrentValue);
			$this->SERVICE->EditValue = HtmlEncode($this->SERVICE->CurrentValue);
			$this->SERVICE->PlaceHolder = RemoveHtml($this->SERVICE->caption());

			// DEPT
			$this->DEPT->EditAttrs["class"] = "form-control";
			$this->DEPT->EditCustomAttributes = "";
			$this->DEPT->EditValue = HtmlEncode($this->DEPT->CurrentValue);
			$this->DEPT->PlaceHolder = RemoveHtml($this->DEPT->caption());
			if (strval($this->DEPT->EditValue) != "" && is_numeric($this->DEPT->EditValue))
				$this->DEPT->EditValue = FormatNumber($this->DEPT->EditValue, -2, -2, -2, -2);
			

			// SECTION
			$this->SECTION->EditAttrs["class"] = "form-control";
			$this->SECTION->EditCustomAttributes = "";
			if (!$this->SECTION->Raw)
				$this->SECTION->CurrentValue = HtmlDecode($this->SECTION->CurrentValue);
			$this->SECTION->EditValue = HtmlEncode($this->SECTION->CurrentValue);
			$this->SECTION->PlaceHolder = RemoveHtml($this->SECTION->caption());

			// CATEGORIE
			$this->CATEGORIE->EditAttrs["class"] = "form-control";
			$this->CATEGORIE->EditCustomAttributes = "";
			if (!$this->CATEGORIE->Raw)
				$this->CATEGORIE->CurrentValue = HtmlDecode($this->CATEGORIE->CurrentValue);
			$this->CATEGORIE->EditValue = HtmlEncode($this->CATEGORIE->CurrentValue);
			$this->CATEGORIE->PlaceHolder = RemoveHtml($this->CATEGORIE->caption());

			// FONCTION
			$this->FONCTION->EditAttrs["class"] = "form-control";
			$this->FONCTION->EditCustomAttributes = "";
			if (!$this->FONCTION->Raw)
				$this->FONCTION->CurrentValue = HtmlDecode($this->FONCTION->CurrentValue);
			$this->FONCTION->EditValue = HtmlEncode($this->FONCTION->CurrentValue);
			$this->FONCTION->PlaceHolder = RemoveHtml($this->FONCTION->caption());

			// STATUT
			$this->STATUT->EditAttrs["class"] = "form-control";
			$this->STATUT->EditCustomAttributes = "";
			if (!$this->STATUT->Raw)
				$this->STATUT->CurrentValue = HtmlDecode($this->STATUT->CurrentValue);
			$this->STATUT->EditValue = HtmlEncode($this->STATUT->CurrentValue);
			$this->STATUT->PlaceHolder = RemoveHtml($this->STATUT->caption());

			// STA_DEBUT
			$this->STA_DEBUT->EditAttrs["class"] = "form-control";
			$this->STA_DEBUT->EditCustomAttributes = "";
			$this->STA_DEBUT->EditValue = HtmlEncode(FormatDateTime($this->STA_DEBUT->CurrentValue, 8));
			$this->STA_DEBUT->PlaceHolder = RemoveHtml($this->STA_DEBUT->caption());

			// STA_FIN
			$this->STA_FIN->EditAttrs["class"] = "form-control";
			$this->STA_FIN->EditCustomAttributes = "";
			$this->STA_FIN->EditValue = HtmlEncode(FormatDateTime($this->STA_FIN->CurrentValue, 8));
			$this->STA_FIN->PlaceHolder = RemoveHtml($this->STA_FIN->caption());

			// STA_MOTIF
			$this->STA_MOTIF->EditAttrs["class"] = "form-control";
			$this->STA_MOTIF->EditCustomAttributes = "";
			if (!$this->STA_MOTIF->Raw)
				$this->STA_MOTIF->CurrentValue = HtmlDecode($this->STA_MOTIF->CurrentValue);
			$this->STA_MOTIF->EditValue = HtmlEncode($this->STA_MOTIF->CurrentValue);
			$this->STA_MOTIF->PlaceHolder = RemoveHtml($this->STA_MOTIF->caption());

			// NO_NIF
			$this->NO_NIF->EditAttrs["class"] = "form-control";
			$this->NO_NIF->EditCustomAttributes = "";
			$this->NO_NIF->EditValue = HtmlEncode($this->NO_NIF->CurrentValue);
			$this->NO_NIF->PlaceHolder = RemoveHtml($this->NO_NIF->caption());
			if (strval($this->NO_NIF->EditValue) != "" && is_numeric($this->NO_NIF->EditValue))
				$this->NO_NIF->EditValue = FormatNumber($this->NO_NIF->EditValue, -2, -2, -2, -2);
			

			// NO_ONA
			$this->NO_ONA->EditAttrs["class"] = "form-control";
			$this->NO_ONA->EditCustomAttributes = "";
			if (!$this->NO_ONA->Raw)
				$this->NO_ONA->CurrentValue = HtmlDecode($this->NO_ONA->CurrentValue);
			$this->NO_ONA->EditValue = HtmlEncode($this->NO_ONA->CurrentValue);
			$this->NO_ONA->PlaceHolder = RemoveHtml($this->NO_ONA->caption());

			// LIV_TRAV
			$this->LIV_TRAV->EditAttrs["class"] = "form-control";
			$this->LIV_TRAV->EditCustomAttributes = "";
			if (!$this->LIV_TRAV->Raw)
				$this->LIV_TRAV->CurrentValue = HtmlDecode($this->LIV_TRAV->CurrentValue);
			$this->LIV_TRAV->EditValue = HtmlEncode($this->LIV_TRAV->CurrentValue);
			$this->LIV_TRAV->PlaceHolder = RemoveHtml($this->LIV_TRAV->caption());

			// MT_SALAIRE
			$this->MT_SALAIRE->EditAttrs["class"] = "form-control";
			$this->MT_SALAIRE->EditCustomAttributes = "";
			$this->MT_SALAIRE->EditValue = HtmlEncode($this->MT_SALAIRE->CurrentValue);
			$this->MT_SALAIRE->PlaceHolder = RemoveHtml($this->MT_SALAIRE->caption());
			if (strval($this->MT_SALAIRE->EditValue) != "" && is_numeric($this->MT_SALAIRE->EditValue))
				$this->MT_SALAIRE->EditValue = FormatNumber($this->MT_SALAIRE->EditValue, -2, -2, -2, -2);
			

			// MT_FRAIS
			$this->MT_FRAIS->EditAttrs["class"] = "form-control";
			$this->MT_FRAIS->EditCustomAttributes = "";
			$this->MT_FRAIS->EditValue = HtmlEncode($this->MT_FRAIS->CurrentValue);
			$this->MT_FRAIS->PlaceHolder = RemoveHtml($this->MT_FRAIS->caption());
			if (strval($this->MT_FRAIS->EditValue) != "" && is_numeric($this->MT_FRAIS->EditValue))
				$this->MT_FRAIS->EditValue = FormatNumber($this->MT_FRAIS->EditValue, -2, -2, -2, -2);
			

			// MT_AUTRES
			$this->MT_AUTRES->EditAttrs["class"] = "form-control";
			$this->MT_AUTRES->EditCustomAttributes = "";
			$this->MT_AUTRES->EditValue = HtmlEncode($this->MT_AUTRES->CurrentValue);
			$this->MT_AUTRES->PlaceHolder = RemoveHtml($this->MT_AUTRES->caption());
			if (strval($this->MT_AUTRES->EditValue) != "" && is_numeric($this->MT_AUTRES->EditValue))
				$this->MT_AUTRES->EditValue = FormatNumber($this->MT_AUTRES->EditValue, -2, -2, -2, -2);
			

			// MODE
			$this->MODE->EditAttrs["class"] = "form-control";
			$this->MODE->EditCustomAttributes = "";
			if (!$this->MODE->Raw)
				$this->MODE->CurrentValue = HtmlDecode($this->MODE->CurrentValue);
			$this->MODE->EditValue = HtmlEncode($this->MODE->CurrentValue);
			$this->MODE->PlaceHolder = RemoveHtml($this->MODE->caption());

			// TYPE
			$this->TYPE->EditAttrs["class"] = "form-control";
			$this->TYPE->EditCustomAttributes = "";
			if (!$this->TYPE->Raw)
				$this->TYPE->CurrentValue = HtmlDecode($this->TYPE->CurrentValue);
			$this->TYPE->EditValue = HtmlEncode($this->TYPE->CurrentValue);
			$this->TYPE->PlaceHolder = RemoveHtml($this->TYPE->caption());

			// MT_IMPOT
			$this->MT_IMPOT->EditAttrs["class"] = "form-control";
			$this->MT_IMPOT->EditCustomAttributes = "";
			$this->MT_IMPOT->EditValue = HtmlEncode($this->MT_IMPOT->CurrentValue);
			$this->MT_IMPOT->PlaceHolder = RemoveHtml($this->MT_IMPOT->caption());
			if (strval($this->MT_IMPOT->EditValue) != "" && is_numeric($this->MT_IMPOT->EditValue))
				$this->MT_IMPOT->EditValue = FormatNumber($this->MT_IMPOT->EditValue, -2, -2, -2, -2);
			

			// PER_IMPOT
			$this->PER_IMPOT->EditAttrs["class"] = "form-control";
			$this->PER_IMPOT->EditCustomAttributes = "";
			if (!$this->PER_IMPOT->Raw)
				$this->PER_IMPOT->CurrentValue = HtmlDecode($this->PER_IMPOT->CurrentValue);
			$this->PER_IMPOT->EditValue = HtmlEncode($this->PER_IMPOT->CurrentValue);
			$this->PER_IMPOT->PlaceHolder = RemoveHtml($this->PER_IMPOT->caption());

			// PRET_ONA
			$this->PRET_ONA->EditAttrs["class"] = "form-control";
			$this->PRET_ONA->EditCustomAttributes = "";
			$this->PRET_ONA->EditValue = HtmlEncode($this->PRET_ONA->CurrentValue);
			$this->PRET_ONA->PlaceHolder = RemoveHtml($this->PRET_ONA->caption());
			if (strval($this->PRET_ONA->EditValue) != "" && is_numeric($this->PRET_ONA->EditValue))
				$this->PRET_ONA->EditValue = FormatNumber($this->PRET_ONA->EditValue, -2, -2, -2, -2);
			

			// PER_ONA
			$this->PER_ONA->EditAttrs["class"] = "form-control";
			$this->PER_ONA->EditCustomAttributes = "";
			if (!$this->PER_ONA->Raw)
				$this->PER_ONA->CurrentValue = HtmlDecode($this->PER_ONA->CurrentValue);
			$this->PER_ONA->EditValue = HtmlEncode($this->PER_ONA->CurrentValue);
			$this->PER_ONA->PlaceHolder = RemoveHtml($this->PER_ONA->caption());

			// RET_ASSUR
			$this->RET_ASSUR->EditAttrs["class"] = "form-control";
			$this->RET_ASSUR->EditCustomAttributes = "";
			$this->RET_ASSUR->EditValue = HtmlEncode($this->RET_ASSUR->CurrentValue);
			$this->RET_ASSUR->PlaceHolder = RemoveHtml($this->RET_ASSUR->caption());
			if (strval($this->RET_ASSUR->EditValue) != "" && is_numeric($this->RET_ASSUR->EditValue))
				$this->RET_ASSUR->EditValue = FormatNumber($this->RET_ASSUR->EditValue, -2, -2, -2, -2);
			

			// PER_ASSUR
			$this->PER_ASSUR->EditAttrs["class"] = "form-control";
			$this->PER_ASSUR->EditCustomAttributes = "";
			if (!$this->PER_ASSUR->Raw)
				$this->PER_ASSUR->CurrentValue = HtmlDecode($this->PER_ASSUR->CurrentValue);
			$this->PER_ASSUR->EditValue = HtmlEncode($this->PER_ASSUR->CurrentValue);
			$this->PER_ASSUR->PlaceHolder = RemoveHtml($this->PER_ASSUR->caption());

			// PRET_SALAIRE
			$this->PRET_SALAIRE->EditAttrs["class"] = "form-control";
			$this->PRET_SALAIRE->EditCustomAttributes = "";
			$this->PRET_SALAIRE->EditValue = HtmlEncode($this->PRET_SALAIRE->CurrentValue);
			$this->PRET_SALAIRE->PlaceHolder = RemoveHtml($this->PRET_SALAIRE->caption());
			if (strval($this->PRET_SALAIRE->EditValue) != "" && is_numeric($this->PRET_SALAIRE->EditValue))
				$this->PRET_SALAIRE->EditValue = FormatNumber($this->PRET_SALAIRE->EditValue, -2, -2, -2, -2);
			

			// PER_SALAIRE
			$this->PER_SALAIRE->EditAttrs["class"] = "form-control";
			$this->PER_SALAIRE->EditCustomAttributes = "";
			$this->PER_SALAIRE->EditValue = HtmlEncode($this->PER_SALAIRE->CurrentValue);
			$this->PER_SALAIRE->PlaceHolder = RemoveHtml($this->PER_SALAIRE->caption());
			if (strval($this->PER_SALAIRE->EditValue) != "" && is_numeric($this->PER_SALAIRE->EditValue))
				$this->PER_SALAIRE->EditValue = FormatNumber($this->PER_SALAIRE->EditValue, -2, -2, -2, -2);
			

			// RET_PENSION
			$this->RET_PENSION->EditAttrs["class"] = "form-control";
			$this->RET_PENSION->EditCustomAttributes = "";
			$this->RET_PENSION->EditValue = HtmlEncode($this->RET_PENSION->CurrentValue);
			$this->RET_PENSION->PlaceHolder = RemoveHtml($this->RET_PENSION->caption());
			if (strval($this->RET_PENSION->EditValue) != "" && is_numeric($this->RET_PENSION->EditValue))
				$this->RET_PENSION->EditValue = FormatNumber($this->RET_PENSION->EditValue, -2, -2, -2, -2);
			

			// PER_RETPENSION
			$this->PER_RETPENSION->EditAttrs["class"] = "form-control";
			$this->PER_RETPENSION->EditCustomAttributes = "";
			if (!$this->PER_RETPENSION->Raw)
				$this->PER_RETPENSION->CurrentValue = HtmlDecode($this->PER_RETPENSION->CurrentValue);
			$this->PER_RETPENSION->EditValue = HtmlEncode($this->PER_RETPENSION->CurrentValue);
			$this->PER_RETPENSION->PlaceHolder = RemoveHtml($this->PER_RETPENSION->caption());

			// PRET_BANQUE
			$this->PRET_BANQUE->EditAttrs["class"] = "form-control";
			$this->PRET_BANQUE->EditCustomAttributes = "";
			$this->PRET_BANQUE->EditValue = HtmlEncode($this->PRET_BANQUE->CurrentValue);
			$this->PRET_BANQUE->PlaceHolder = RemoveHtml($this->PRET_BANQUE->caption());
			if (strval($this->PRET_BANQUE->EditValue) != "" && is_numeric($this->PRET_BANQUE->EditValue))
				$this->PRET_BANQUE->EditValue = FormatNumber($this->PRET_BANQUE->EditValue, -2, -2, -2, -2);
			

			// PER_BANQUE
			$this->PER_BANQUE->EditAttrs["class"] = "form-control";
			$this->PER_BANQUE->EditCustomAttributes = "";
			$this->PER_BANQUE->EditValue = HtmlEncode($this->PER_BANQUE->CurrentValue);
			$this->PER_BANQUE->PlaceHolder = RemoveHtml($this->PER_BANQUE->caption());
			if (strval($this->PER_BANQUE->EditValue) != "" && is_numeric($this->PER_BANQUE->EditValue))
				$this->PER_BANQUE->EditValue = FormatNumber($this->PER_BANQUE->EditValue, -2, -2, -2, -2);
			

			// RET_AVANC
			$this->RET_AVANC->EditAttrs["class"] = "form-control";
			$this->RET_AVANC->EditCustomAttributes = "";
			$this->RET_AVANC->EditValue = HtmlEncode($this->RET_AVANC->CurrentValue);
			$this->RET_AVANC->PlaceHolder = RemoveHtml($this->RET_AVANC->caption());
			if (strval($this->RET_AVANC->EditValue) != "" && is_numeric($this->RET_AVANC->EditValue))
				$this->RET_AVANC->EditValue = FormatNumber($this->RET_AVANC->EditValue, -2, -2, -2, -2);
			

			// PER_AVANCE
			$this->PER_AVANCE->EditAttrs["class"] = "form-control";
			$this->PER_AVANCE->EditCustomAttributes = "";
			if (!$this->PER_AVANCE->Raw)
				$this->PER_AVANCE->CurrentValue = HtmlDecode($this->PER_AVANCE->CurrentValue);
			$this->PER_AVANCE->EditValue = HtmlEncode($this->PER_AVANCE->CurrentValue);
			$this->PER_AVANCE->PlaceHolder = RemoveHtml($this->PER_AVANCE->caption());

			// PRET_PENSION
			$this->PRET_PENSION->EditAttrs["class"] = "form-control";
			$this->PRET_PENSION->EditCustomAttributes = "";
			$this->PRET_PENSION->EditValue = HtmlEncode($this->PRET_PENSION->CurrentValue);
			$this->PRET_PENSION->PlaceHolder = RemoveHtml($this->PRET_PENSION->caption());
			if (strval($this->PRET_PENSION->EditValue) != "" && is_numeric($this->PRET_PENSION->EditValue))
				$this->PRET_PENSION->EditValue = FormatNumber($this->PRET_PENSION->EditValue, -2, -2, -2, -2);
			

			// PER_PENSION
			$this->PER_PENSION->EditAttrs["class"] = "form-control";
			$this->PER_PENSION->EditCustomAttributes = "";
			if (!$this->PER_PENSION->Raw)
				$this->PER_PENSION->CurrentValue = HtmlDecode($this->PER_PENSION->CurrentValue);
			$this->PER_PENSION->EditValue = HtmlEncode($this->PER_PENSION->CurrentValue);
			$this->PER_PENSION->PlaceHolder = RemoveHtml($this->PER_PENSION->caption());

			// RET_CAFET
			$this->RET_CAFET->EditAttrs["class"] = "form-control";
			$this->RET_CAFET->EditCustomAttributes = "";
			$this->RET_CAFET->EditValue = HtmlEncode($this->RET_CAFET->CurrentValue);
			$this->RET_CAFET->PlaceHolder = RemoveHtml($this->RET_CAFET->caption());
			if (strval($this->RET_CAFET->EditValue) != "" && is_numeric($this->RET_CAFET->EditValue))
				$this->RET_CAFET->EditValue = FormatNumber($this->RET_CAFET->EditValue, -2, -2, -2, -2);
			

			// PER_CAFET
			$this->PER_CAFET->EditAttrs["class"] = "form-control";
			$this->PER_CAFET->EditCustomAttributes = "";
			if (!$this->PER_CAFET->Raw)
				$this->PER_CAFET->CurrentValue = HtmlDecode($this->PER_CAFET->CurrentValue);
			$this->PER_CAFET->EditValue = HtmlEncode($this->PER_CAFET->CurrentValue);
			$this->PER_CAFET->PlaceHolder = RemoveHtml($this->PER_CAFET->caption());

			// RET_CITE
			$this->RET_CITE->EditAttrs["class"] = "form-control";
			$this->RET_CITE->EditCustomAttributes = "";
			$this->RET_CITE->EditValue = HtmlEncode($this->RET_CITE->CurrentValue);
			$this->RET_CITE->PlaceHolder = RemoveHtml($this->RET_CITE->caption());
			if (strval($this->RET_CITE->EditValue) != "" && is_numeric($this->RET_CITE->EditValue))
				$this->RET_CITE->EditValue = FormatNumber($this->RET_CITE->EditValue, -2, -2, -2, -2);
			

			// PER_CITE
			$this->PER_CITE->EditAttrs["class"] = "form-control";
			$this->PER_CITE->EditCustomAttributes = "";
			if (!$this->PER_CITE->Raw)
				$this->PER_CITE->CurrentValue = HtmlDecode($this->PER_CITE->CurrentValue);
			$this->PER_CITE->EditValue = HtmlEncode($this->PER_CITE->CurrentValue);
			$this->PER_CITE->PlaceHolder = RemoveHtml($this->PER_CITE->caption());

			// RET_AUTRE
			$this->RET_AUTRE->EditAttrs["class"] = "form-control";
			$this->RET_AUTRE->EditCustomAttributes = "";
			$this->RET_AUTRE->EditValue = HtmlEncode($this->RET_AUTRE->CurrentValue);
			$this->RET_AUTRE->PlaceHolder = RemoveHtml($this->RET_AUTRE->caption());
			if (strval($this->RET_AUTRE->EditValue) != "" && is_numeric($this->RET_AUTRE->EditValue))
				$this->RET_AUTRE->EditValue = FormatNumber($this->RET_AUTRE->EditValue, -2, -2, -2, -2);
			

			// PER_AUTRE
			$this->PER_AUTRE->EditAttrs["class"] = "form-control";
			$this->PER_AUTRE->EditCustomAttributes = "";
			if (!$this->PER_AUTRE->Raw)
				$this->PER_AUTRE->CurrentValue = HtmlDecode($this->PER_AUTRE->CurrentValue);
			$this->PER_AUTRE->EditValue = HtmlEncode($this->PER_AUTRE->CurrentValue);
			$this->PER_AUTRE->PlaceHolder = RemoveHtml($this->PER_AUTRE->caption());

			// ACQ_NB_CON
			$this->ACQ_NB_CON->EditAttrs["class"] = "form-control";
			$this->ACQ_NB_CON->EditCustomAttributes = "";
			$this->ACQ_NB_CON->EditValue = HtmlEncode($this->ACQ_NB_CON->CurrentValue);
			$this->ACQ_NB_CON->PlaceHolder = RemoveHtml($this->ACQ_NB_CON->caption());
			if (strval($this->ACQ_NB_CON->EditValue) != "" && is_numeric($this->ACQ_NB_CON->EditValue))
				$this->ACQ_NB_CON->EditValue = FormatNumber($this->ACQ_NB_CON->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->EditAttrs["class"] = "form-control";
			$this->ACC_MT_BRUT->EditCustomAttributes = "";
			$this->ACC_MT_BRUT->EditValue = HtmlEncode($this->ACC_MT_BRUT->CurrentValue);
			$this->ACC_MT_BRUT->PlaceHolder = RemoveHtml($this->ACC_MT_BRUT->caption());
			if (strval($this->ACC_MT_BRUT->EditValue) != "" && is_numeric($this->ACC_MT_BRUT->EditValue))
				$this->ACC_MT_BRUT->EditValue = FormatNumber($this->ACC_MT_BRUT->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_CON
			$this->ACC_NB_CON->EditAttrs["class"] = "form-control";
			$this->ACC_NB_CON->EditCustomAttributes = "";
			$this->ACC_NB_CON->EditValue = HtmlEncode($this->ACC_NB_CON->CurrentValue);
			$this->ACC_NB_CON->PlaceHolder = RemoveHtml($this->ACC_NB_CON->caption());
			if (strval($this->ACC_NB_CON->EditValue) != "" && is_numeric($this->ACC_NB_CON->EditValue))
				$this->ACC_NB_CON->EditValue = FormatNumber($this->ACC_NB_CON->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_PCON
			$this->ACC_NB_PCON->EditAttrs["class"] = "form-control";
			$this->ACC_NB_PCON->EditCustomAttributes = "";
			$this->ACC_NB_PCON->EditValue = HtmlEncode($this->ACC_NB_PCON->CurrentValue);
			$this->ACC_NB_PCON->PlaceHolder = RemoveHtml($this->ACC_NB_PCON->caption());
			if (strval($this->ACC_NB_PCON->EditValue) != "" && is_numeric($this->ACC_NB_PCON->EditValue))
				$this->ACC_NB_PCON->EditValue = FormatNumber($this->ACC_NB_PCON->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_OVT
			$this->ACC_MT_OVT->EditAttrs["class"] = "form-control";
			$this->ACC_MT_OVT->EditCustomAttributes = "";
			$this->ACC_MT_OVT->EditValue = HtmlEncode($this->ACC_MT_OVT->CurrentValue);
			$this->ACC_MT_OVT->PlaceHolder = RemoveHtml($this->ACC_MT_OVT->caption());
			if (strval($this->ACC_MT_OVT->EditValue) != "" && is_numeric($this->ACC_MT_OVT->EditValue))
				$this->ACC_MT_OVT->EditValue = FormatNumber($this->ACC_MT_OVT->EditValue, -2, -2, -2, -2);
			

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->EditAttrs["class"] = "form-control";
			$this->ACQ_NB_MAL->EditCustomAttributes = "";
			$this->ACQ_NB_MAL->EditValue = HtmlEncode($this->ACQ_NB_MAL->CurrentValue);
			$this->ACQ_NB_MAL->PlaceHolder = RemoveHtml($this->ACQ_NB_MAL->caption());
			if (strval($this->ACQ_NB_MAL->EditValue) != "" && is_numeric($this->ACQ_NB_MAL->EditValue))
				$this->ACQ_NB_MAL->EditValue = FormatNumber($this->ACQ_NB_MAL->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_MAL
			$this->ACC_NB_MAL->EditAttrs["class"] = "form-control";
			$this->ACC_NB_MAL->EditCustomAttributes = "";
			$this->ACC_NB_MAL->EditValue = HtmlEncode($this->ACC_NB_MAL->CurrentValue);
			$this->ACC_NB_MAL->PlaceHolder = RemoveHtml($this->ACC_NB_MAL->caption());
			if (strval($this->ACC_NB_MAL->EditValue) != "" && is_numeric($this->ACC_NB_MAL->EditValue))
				$this->ACC_NB_MAL->EditValue = FormatNumber($this->ACC_NB_MAL->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_CON
			$this->ACC_MT_CON->EditAttrs["class"] = "form-control";
			$this->ACC_MT_CON->EditCustomAttributes = "";
			$this->ACC_MT_CON->EditValue = HtmlEncode($this->ACC_MT_CON->CurrentValue);
			$this->ACC_MT_CON->PlaceHolder = RemoveHtml($this->ACC_MT_CON->caption());
			if (strval($this->ACC_MT_CON->EditValue) != "" && is_numeric($this->ACC_MT_CON->EditValue))
				$this->ACC_MT_CON->EditValue = FormatNumber($this->ACC_MT_CON->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_MAT
			$this->ACC_NB_MAT->EditAttrs["class"] = "form-control";
			$this->ACC_NB_MAT->EditCustomAttributes = "";
			$this->ACC_NB_MAT->EditValue = HtmlEncode($this->ACC_NB_MAT->CurrentValue);
			$this->ACC_NB_MAT->PlaceHolder = RemoveHtml($this->ACC_NB_MAT->caption());
			if (strval($this->ACC_NB_MAT->EditValue) != "" && is_numeric($this->ACC_NB_MAT->EditValue))
				$this->ACC_NB_MAT->EditValue = FormatNumber($this->ACC_NB_MAT->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_BONI
			$this->ACC_MT_BONI->EditAttrs["class"] = "form-control";
			$this->ACC_MT_BONI->EditCustomAttributes = "";
			$this->ACC_MT_BONI->EditValue = HtmlEncode($this->ACC_MT_BONI->CurrentValue);
			$this->ACC_MT_BONI->PlaceHolder = RemoveHtml($this->ACC_MT_BONI->caption());
			if (strval($this->ACC_MT_BONI->EditValue) != "" && is_numeric($this->ACC_MT_BONI->EditValue))
				$this->ACC_MT_BONI->EditValue = FormatNumber($this->ACC_MT_BONI->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_PER
			$this->ACC_NB_PER->EditAttrs["class"] = "form-control";
			$this->ACC_NB_PER->EditCustomAttributes = "";
			$this->ACC_NB_PER->EditValue = HtmlEncode($this->ACC_NB_PER->CurrentValue);
			$this->ACC_NB_PER->PlaceHolder = RemoveHtml($this->ACC_NB_PER->caption());
			if (strval($this->ACC_NB_PER->EditValue) != "" && is_numeric($this->ACC_NB_PER->EditValue))
				$this->ACC_NB_PER->EditValue = FormatNumber($this->ACC_NB_PER->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_AUT
			$this->ACC_MT_AUT->EditAttrs["class"] = "form-control";
			$this->ACC_MT_AUT->EditCustomAttributes = "";
			$this->ACC_MT_AUT->EditValue = HtmlEncode($this->ACC_MT_AUT->CurrentValue);
			$this->ACC_MT_AUT->PlaceHolder = RemoveHtml($this->ACC_MT_AUT->caption());
			if (strval($this->ACC_MT_AUT->EditValue) != "" && is_numeric($this->ACC_MT_AUT->EditValue))
				$this->ACC_MT_AUT->EditValue = FormatNumber($this->ACC_MT_AUT->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_COM
			$this->ACC_NB_COM->EditAttrs["class"] = "form-control";
			$this->ACC_NB_COM->EditCustomAttributes = "";
			$this->ACC_NB_COM->EditValue = HtmlEncode($this->ACC_NB_COM->CurrentValue);
			$this->ACC_NB_COM->PlaceHolder = RemoveHtml($this->ACC_NB_COM->caption());
			if (strval($this->ACC_NB_COM->EditValue) != "" && is_numeric($this->ACC_NB_COM->EditValue))
				$this->ACC_NB_COM->EditValue = FormatNumber($this->ACC_NB_COM->EditValue, -2, -2, -2, -2);
			

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->EditAttrs["class"] = "form-control";
			$this->ACC_BAL_SAL->EditCustomAttributes = "";
			$this->ACC_BAL_SAL->EditValue = HtmlEncode($this->ACC_BAL_SAL->CurrentValue);
			$this->ACC_BAL_SAL->PlaceHolder = RemoveHtml($this->ACC_BAL_SAL->caption());
			if (strval($this->ACC_BAL_SAL->EditValue) != "" && is_numeric($this->ACC_BAL_SAL->EditValue))
				$this->ACC_BAL_SAL->EditValue = FormatNumber($this->ACC_BAL_SAL->EditValue, -2, -2, -2, -2);
			

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->EditAttrs["class"] = "form-control";
			$this->ACC_BAL_BAN->EditCustomAttributes = "";
			$this->ACC_BAL_BAN->EditValue = HtmlEncode($this->ACC_BAL_BAN->CurrentValue);
			$this->ACC_BAL_BAN->PlaceHolder = RemoveHtml($this->ACC_BAL_BAN->caption());
			if (strval($this->ACC_BAL_BAN->EditValue) != "" && is_numeric($this->ACC_BAL_BAN->EditValue))
				$this->ACC_BAL_BAN->EditValue = FormatNumber($this->ACC_BAL_BAN->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_SUS
			$this->ACC_NB_SUS->EditAttrs["class"] = "form-control";
			$this->ACC_NB_SUS->EditCustomAttributes = "";
			$this->ACC_NB_SUS->EditValue = HtmlEncode($this->ACC_NB_SUS->CurrentValue);
			$this->ACC_NB_SUS->PlaceHolder = RemoveHtml($this->ACC_NB_SUS->caption());
			if (strval($this->ACC_NB_SUS->EditValue) != "" && is_numeric($this->ACC_NB_SUS->EditValue))
				$this->ACC_NB_SUS->EditValue = FormatNumber($this->ACC_NB_SUS->EditValue, -2, -2, -2, -2);
			

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->EditAttrs["class"] = "form-control";
			$this->ACC_BAL_ONA->EditCustomAttributes = "";
			$this->ACC_BAL_ONA->EditValue = HtmlEncode($this->ACC_BAL_ONA->CurrentValue);
			$this->ACC_BAL_ONA->PlaceHolder = RemoveHtml($this->ACC_BAL_ONA->caption());
			if (strval($this->ACC_BAL_ONA->EditValue) != "" && is_numeric($this->ACC_BAL_ONA->EditValue))
				$this->ACC_BAL_ONA->EditValue = FormatNumber($this->ACC_BAL_ONA->EditValue, -2, -2, -2, -2);
			

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->EditAttrs["class"] = "form-control";
			$this->ACC_BAL_PENSION->EditCustomAttributes = "";
			$this->ACC_BAL_PENSION->EditValue = HtmlEncode($this->ACC_BAL_PENSION->CurrentValue);
			$this->ACC_BAL_PENSION->PlaceHolder = RemoveHtml($this->ACC_BAL_PENSION->caption());
			if (strval($this->ACC_BAL_PENSION->EditValue) != "" && is_numeric($this->ACC_BAL_PENSION->EditValue))
				$this->ACC_BAL_PENSION->EditValue = FormatNumber($this->ACC_BAL_PENSION->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_ABS
			$this->ACC_NB_ABS->EditAttrs["class"] = "form-control";
			$this->ACC_NB_ABS->EditCustomAttributes = "";
			$this->ACC_NB_ABS->EditValue = HtmlEncode($this->ACC_NB_ABS->CurrentValue);
			$this->ACC_NB_ABS->PlaceHolder = RemoveHtml($this->ACC_NB_ABS->caption());
			if (strval($this->ACC_NB_ABS->EditValue) != "" && is_numeric($this->ACC_NB_ABS->EditValue))
				$this->ACC_NB_ABS->EditValue = FormatNumber($this->ACC_NB_ABS->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_QZ
			$this->ACC_MT_QZ->EditAttrs["class"] = "form-control";
			$this->ACC_MT_QZ->EditCustomAttributes = "";
			$this->ACC_MT_QZ->EditValue = HtmlEncode($this->ACC_MT_QZ->CurrentValue);
			$this->ACC_MT_QZ->PlaceHolder = RemoveHtml($this->ACC_MT_QZ->caption());
			if (strval($this->ACC_MT_QZ->EditValue) != "" && is_numeric($this->ACC_MT_QZ->EditValue))
				$this->ACC_MT_QZ->EditValue = FormatNumber($this->ACC_MT_QZ->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_TRA
			$this->ACC_NB_TRA->EditAttrs["class"] = "form-control";
			$this->ACC_NB_TRA->EditCustomAttributes = "";
			$this->ACC_NB_TRA->EditValue = HtmlEncode($this->ACC_NB_TRA->CurrentValue);
			$this->ACC_NB_TRA->PlaceHolder = RemoveHtml($this->ACC_NB_TRA->caption());
			if (strval($this->ACC_NB_TRA->EditValue) != "" && is_numeric($this->ACC_NB_TRA->EditValue))
				$this->ACC_NB_TRA->EditValue = FormatNumber($this->ACC_NB_TRA->EditValue, -2, -2, -2, -2);
			

			// ACC_MT_AJST
			$this->ACC_MT_AJST->EditAttrs["class"] = "form-control";
			$this->ACC_MT_AJST->EditCustomAttributes = "";
			$this->ACC_MT_AJST->EditValue = HtmlEncode($this->ACC_MT_AJST->CurrentValue);
			$this->ACC_MT_AJST->PlaceHolder = RemoveHtml($this->ACC_MT_AJST->caption());
			if (strval($this->ACC_MT_AJST->EditValue) != "" && is_numeric($this->ACC_MT_AJST->EditValue))
				$this->ACC_MT_AJST->EditValue = FormatNumber($this->ACC_MT_AJST->EditValue, -2, -2, -2, -2);
			

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->EditAttrs["class"] = "form-control";
			$this->ACC_NB_TRA_ACT->EditCustomAttributes = "";
			$this->ACC_NB_TRA_ACT->EditValue = HtmlEncode($this->ACC_NB_TRA_ACT->CurrentValue);
			$this->ACC_NB_TRA_ACT->PlaceHolder = RemoveHtml($this->ACC_NB_TRA_ACT->caption());
			if (strval($this->ACC_NB_TRA_ACT->EditValue) != "" && is_numeric($this->ACC_NB_TRA_ACT->EditValue))
				$this->ACC_NB_TRA_ACT->EditValue = FormatNumber($this->ACC_NB_TRA_ACT->EditValue, -2, -2, -2, -2);
			

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->EditAttrs["class"] = "form-control";
			$this->ACC1_MT_BRUT->EditCustomAttributes = "";
			$this->ACC1_MT_BRUT->EditValue = HtmlEncode($this->ACC1_MT_BRUT->CurrentValue);
			$this->ACC1_MT_BRUT->PlaceHolder = RemoveHtml($this->ACC1_MT_BRUT->caption());
			if (strval($this->ACC1_MT_BRUT->EditValue) != "" && is_numeric($this->ACC1_MT_BRUT->EditValue))
				$this->ACC1_MT_BRUT->EditValue = FormatNumber($this->ACC1_MT_BRUT->EditValue, -2, -2, -2, -2);
			

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->EditAttrs["class"] = "form-control";
			$this->ACC_RENDEMENT->EditCustomAttributes = "";
			$this->ACC_RENDEMENT->EditValue = HtmlEncode($this->ACC_RENDEMENT->CurrentValue);
			$this->ACC_RENDEMENT->PlaceHolder = RemoveHtml($this->ACC_RENDEMENT->caption());
			if (strval($this->ACC_RENDEMENT->EditValue) != "" && is_numeric($this->ACC_RENDEMENT->EditValue))
				$this->ACC_RENDEMENT->EditValue = FormatNumber($this->ACC_RENDEMENT->EditValue, -2, -2, -2, -2);
			

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// RN
			$this->RN->LinkCustomAttributes = "";
			$this->RN->HrefValue = "";

			// NO_EMP
			$this->NO_EMP->LinkCustomAttributes = "";
			$this->NO_EMP->HrefValue = "";

			// NOM_EMP
			$this->NOM_EMP->LinkCustomAttributes = "";
			$this->NOM_EMP->HrefValue = "";

			// SEXE
			$this->SEXE->LinkCustomAttributes = "";
			$this->SEXE->HrefValue = "";

			// ETAT_C
			$this->ETAT_C->LinkCustomAttributes = "";
			$this->ETAT_C->HrefValue = "";

			// DEPEND
			$this->DEPEND->LinkCustomAttributes = "";
			$this->DEPEND->HrefValue = "";

			// DTE_NAIS
			$this->DTE_NAIS->LinkCustomAttributes = "";
			$this->DTE_NAIS->HrefValue = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->LinkCustomAttributes = "";
			$this->LIEU_NAIS->HrefValue = "";

			// NATION
			$this->NATION->LinkCustomAttributes = "";
			$this->NATION->HrefValue = "";

			// ADRESSE
			$this->ADRESSE->LinkCustomAttributes = "";
			$this->ADRESSE->HrefValue = "";

			// VILLE
			$this->VILLE->LinkCustomAttributes = "";
			$this->VILLE->HrefValue = "";

			// PAYS
			$this->PAYS->LinkCustomAttributes = "";
			$this->PAYS->HrefValue = "";

			// BOX
			$this->BOX->LinkCustomAttributes = "";
			$this->BOX->HrefValue = "";

			// PHONE
			$this->PHONE->LinkCustomAttributes = "";
			$this->PHONE->HrefValue = "";

			// REFERENCE
			$this->REFERENCE->LinkCustomAttributes = "";
			$this->REFERENCE->HrefValue = "";

			// QUALIF
			$this->QUALIF->LinkCustomAttributes = "";
			$this->QUALIF->HrefValue = "";

			// URGENCE
			$this->URGENCE->LinkCustomAttributes = "";
			$this->URGENCE->HrefValue = "";

			// PHONE_URG
			$this->PHONE_URG->LinkCustomAttributes = "";
			$this->PHONE_URG->HrefValue = "";

			// DATE_EMP
			$this->DATE_EMP->LinkCustomAttributes = "";
			$this->DATE_EMP->HrefValue = "";

			// SERVICE
			$this->SERVICE->LinkCustomAttributes = "";
			$this->SERVICE->HrefValue = "";

			// DEPT
			$this->DEPT->LinkCustomAttributes = "";
			$this->DEPT->HrefValue = "";

			// SECTION
			$this->SECTION->LinkCustomAttributes = "";
			$this->SECTION->HrefValue = "";

			// CATEGORIE
			$this->CATEGORIE->LinkCustomAttributes = "";
			$this->CATEGORIE->HrefValue = "";

			// FONCTION
			$this->FONCTION->LinkCustomAttributes = "";
			$this->FONCTION->HrefValue = "";

			// STATUT
			$this->STATUT->LinkCustomAttributes = "";
			$this->STATUT->HrefValue = "";

			// STA_DEBUT
			$this->STA_DEBUT->LinkCustomAttributes = "";
			$this->STA_DEBUT->HrefValue = "";

			// STA_FIN
			$this->STA_FIN->LinkCustomAttributes = "";
			$this->STA_FIN->HrefValue = "";

			// STA_MOTIF
			$this->STA_MOTIF->LinkCustomAttributes = "";
			$this->STA_MOTIF->HrefValue = "";

			// NO_NIF
			$this->NO_NIF->LinkCustomAttributes = "";
			$this->NO_NIF->HrefValue = "";

			// NO_ONA
			$this->NO_ONA->LinkCustomAttributes = "";
			$this->NO_ONA->HrefValue = "";

			// LIV_TRAV
			$this->LIV_TRAV->LinkCustomAttributes = "";
			$this->LIV_TRAV->HrefValue = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->LinkCustomAttributes = "";
			$this->MT_SALAIRE->HrefValue = "";

			// MT_FRAIS
			$this->MT_FRAIS->LinkCustomAttributes = "";
			$this->MT_FRAIS->HrefValue = "";

			// MT_AUTRES
			$this->MT_AUTRES->LinkCustomAttributes = "";
			$this->MT_AUTRES->HrefValue = "";

			// MODE
			$this->MODE->LinkCustomAttributes = "";
			$this->MODE->HrefValue = "";

			// TYPE
			$this->TYPE->LinkCustomAttributes = "";
			$this->TYPE->HrefValue = "";

			// MT_IMPOT
			$this->MT_IMPOT->LinkCustomAttributes = "";
			$this->MT_IMPOT->HrefValue = "";

			// PER_IMPOT
			$this->PER_IMPOT->LinkCustomAttributes = "";
			$this->PER_IMPOT->HrefValue = "";

			// PRET_ONA
			$this->PRET_ONA->LinkCustomAttributes = "";
			$this->PRET_ONA->HrefValue = "";

			// PER_ONA
			$this->PER_ONA->LinkCustomAttributes = "";
			$this->PER_ONA->HrefValue = "";

			// RET_ASSUR
			$this->RET_ASSUR->LinkCustomAttributes = "";
			$this->RET_ASSUR->HrefValue = "";

			// PER_ASSUR
			$this->PER_ASSUR->LinkCustomAttributes = "";
			$this->PER_ASSUR->HrefValue = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->LinkCustomAttributes = "";
			$this->PRET_SALAIRE->HrefValue = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->LinkCustomAttributes = "";
			$this->PER_SALAIRE->HrefValue = "";

			// RET_PENSION
			$this->RET_PENSION->LinkCustomAttributes = "";
			$this->RET_PENSION->HrefValue = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->LinkCustomAttributes = "";
			$this->PER_RETPENSION->HrefValue = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->LinkCustomAttributes = "";
			$this->PRET_BANQUE->HrefValue = "";

			// PER_BANQUE
			$this->PER_BANQUE->LinkCustomAttributes = "";
			$this->PER_BANQUE->HrefValue = "";

			// RET_AVANC
			$this->RET_AVANC->LinkCustomAttributes = "";
			$this->RET_AVANC->HrefValue = "";

			// PER_AVANCE
			$this->PER_AVANCE->LinkCustomAttributes = "";
			$this->PER_AVANCE->HrefValue = "";

			// PRET_PENSION
			$this->PRET_PENSION->LinkCustomAttributes = "";
			$this->PRET_PENSION->HrefValue = "";

			// PER_PENSION
			$this->PER_PENSION->LinkCustomAttributes = "";
			$this->PER_PENSION->HrefValue = "";

			// RET_CAFET
			$this->RET_CAFET->LinkCustomAttributes = "";
			$this->RET_CAFET->HrefValue = "";

			// PER_CAFET
			$this->PER_CAFET->LinkCustomAttributes = "";
			$this->PER_CAFET->HrefValue = "";

			// RET_CITE
			$this->RET_CITE->LinkCustomAttributes = "";
			$this->RET_CITE->HrefValue = "";

			// PER_CITE
			$this->PER_CITE->LinkCustomAttributes = "";
			$this->PER_CITE->HrefValue = "";

			// RET_AUTRE
			$this->RET_AUTRE->LinkCustomAttributes = "";
			$this->RET_AUTRE->HrefValue = "";

			// PER_AUTRE
			$this->PER_AUTRE->LinkCustomAttributes = "";
			$this->PER_AUTRE->HrefValue = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->LinkCustomAttributes = "";
			$this->ACQ_NB_CON->HrefValue = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC_MT_BRUT->HrefValue = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->LinkCustomAttributes = "";
			$this->ACC_NB_CON->HrefValue = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->LinkCustomAttributes = "";
			$this->ACC_NB_PCON->HrefValue = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->LinkCustomAttributes = "";
			$this->ACC_MT_OVT->HrefValue = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->LinkCustomAttributes = "";
			$this->ACQ_NB_MAL->HrefValue = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->LinkCustomAttributes = "";
			$this->ACC_NB_MAL->HrefValue = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->LinkCustomAttributes = "";
			$this->ACC_MT_CON->HrefValue = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->LinkCustomAttributes = "";
			$this->ACC_NB_MAT->HrefValue = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->LinkCustomAttributes = "";
			$this->ACC_MT_BONI->HrefValue = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->LinkCustomAttributes = "";
			$this->ACC_NB_PER->HrefValue = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->LinkCustomAttributes = "";
			$this->ACC_MT_AUT->HrefValue = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->LinkCustomAttributes = "";
			$this->ACC_NB_COM->HrefValue = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->LinkCustomAttributes = "";
			$this->ACC_BAL_SAL->HrefValue = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->LinkCustomAttributes = "";
			$this->ACC_BAL_BAN->HrefValue = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->LinkCustomAttributes = "";
			$this->ACC_NB_SUS->HrefValue = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->LinkCustomAttributes = "";
			$this->ACC_BAL_ONA->HrefValue = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->LinkCustomAttributes = "";
			$this->ACC_BAL_PENSION->HrefValue = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->LinkCustomAttributes = "";
			$this->ACC_NB_ABS->HrefValue = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->LinkCustomAttributes = "";
			$this->ACC_MT_QZ->HrefValue = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->LinkCustomAttributes = "";
			$this->ACC_NB_TRA->HrefValue = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->LinkCustomAttributes = "";
			$this->ACC_MT_AJST->HrefValue = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->LinkCustomAttributes = "";
			$this->ACC_NB_TRA_ACT->HrefValue = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC1_MT_BRUT->HrefValue = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->LinkCustomAttributes = "";
			$this->ACC_RENDEMENT->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";
		$updateCnt = 0;
		if ($this->id->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RN->MultiUpdate == "1")
			$updateCnt++;
		if ($this->NO_EMP->MultiUpdate == "1")
			$updateCnt++;
		if ($this->NOM_EMP->MultiUpdate == "1")
			$updateCnt++;
		if ($this->SEXE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ETAT_C->MultiUpdate == "1")
			$updateCnt++;
		if ($this->DEPEND->MultiUpdate == "1")
			$updateCnt++;
		if ($this->DTE_NAIS->MultiUpdate == "1")
			$updateCnt++;
		if ($this->LIEU_NAIS->MultiUpdate == "1")
			$updateCnt++;
		if ($this->NATION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ADRESSE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->VILLE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PAYS->MultiUpdate == "1")
			$updateCnt++;
		if ($this->BOX->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PHONE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->REFERENCE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->QUALIF->MultiUpdate == "1")
			$updateCnt++;
		if ($this->URGENCE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PHONE_URG->MultiUpdate == "1")
			$updateCnt++;
		if ($this->DATE_EMP->MultiUpdate == "1")
			$updateCnt++;
		if ($this->SERVICE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->DEPT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->SECTION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->CATEGORIE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->FONCTION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->STATUT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->STA_DEBUT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->STA_FIN->MultiUpdate == "1")
			$updateCnt++;
		if ($this->STA_MOTIF->MultiUpdate == "1")
			$updateCnt++;
		if ($this->NO_NIF->MultiUpdate == "1")
			$updateCnt++;
		if ($this->NO_ONA->MultiUpdate == "1")
			$updateCnt++;
		if ($this->LIV_TRAV->MultiUpdate == "1")
			$updateCnt++;
		if ($this->MT_SALAIRE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->MT_FRAIS->MultiUpdate == "1")
			$updateCnt++;
		if ($this->MT_AUTRES->MultiUpdate == "1")
			$updateCnt++;
		if ($this->MODE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->TYPE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->MT_IMPOT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_IMPOT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PRET_ONA->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_ONA->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RET_ASSUR->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_ASSUR->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PRET_SALAIRE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_SALAIRE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RET_PENSION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_RETPENSION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PRET_BANQUE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_BANQUE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RET_AVANC->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_AVANCE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PRET_PENSION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_PENSION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RET_CAFET->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_CAFET->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RET_CITE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_CITE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->RET_AUTRE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->PER_AUTRE->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACQ_NB_CON->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_BRUT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_CON->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_PCON->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_OVT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACQ_NB_MAL->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_MAL->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_CON->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_MAT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_BONI->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_PER->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_AUT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_COM->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_BAL_SAL->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_BAL_BAN->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_SUS->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_BAL_ONA->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_BAL_PENSION->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_ABS->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_QZ->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_TRA->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_MT_AJST->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_NB_TRA_ACT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC1_MT_BRUT->MultiUpdate == "1")
			$updateCnt++;
		if ($this->ACC_RENDEMENT->MultiUpdate == "1")
			$updateCnt++;
		if ($updateCnt == 0) {
			$FormError = $Language->phrase("NoFieldSelected");
			return FALSE;
		}

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->id->Required) {
			if ($this->id->MultiUpdate != "" && !$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->id->MultiUpdate != "") {
			if (!CheckNumber($this->id->FormValue)) {
				AddMessage($FormError, $this->id->errorMessage());
			}
		}
		if ($this->RN->Required) {
			if ($this->RN->MultiUpdate != "" && !$this->RN->IsDetailKey && $this->RN->FormValue != NULL && $this->RN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RN->caption(), $this->RN->RequiredErrorMessage));
			}
		}
		if ($this->RN->MultiUpdate != "") {
			if (!CheckNumber($this->RN->FormValue)) {
				AddMessage($FormError, $this->RN->errorMessage());
			}
		}
		if ($this->NO_EMP->Required) {
			if ($this->NO_EMP->MultiUpdate != "" && !$this->NO_EMP->IsDetailKey && $this->NO_EMP->FormValue != NULL && $this->NO_EMP->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NO_EMP->caption(), $this->NO_EMP->RequiredErrorMessage));
			}
		}
		if ($this->NO_EMP->MultiUpdate != "") {
			if (!CheckNumber($this->NO_EMP->FormValue)) {
				AddMessage($FormError, $this->NO_EMP->errorMessage());
			}
		}
		if ($this->NOM_EMP->Required) {
			if ($this->NOM_EMP->MultiUpdate != "" && !$this->NOM_EMP->IsDetailKey && $this->NOM_EMP->FormValue != NULL && $this->NOM_EMP->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NOM_EMP->caption(), $this->NOM_EMP->RequiredErrorMessage));
			}
		}
		if ($this->SEXE->Required) {
			if ($this->SEXE->MultiUpdate != "" && !$this->SEXE->IsDetailKey && $this->SEXE->FormValue != NULL && $this->SEXE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SEXE->caption(), $this->SEXE->RequiredErrorMessage));
			}
		}
		if ($this->ETAT_C->Required) {
			if ($this->ETAT_C->MultiUpdate != "" && !$this->ETAT_C->IsDetailKey && $this->ETAT_C->FormValue != NULL && $this->ETAT_C->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ETAT_C->caption(), $this->ETAT_C->RequiredErrorMessage));
			}
		}
		if ($this->DEPEND->Required) {
			if ($this->DEPEND->MultiUpdate != "" && !$this->DEPEND->IsDetailKey && $this->DEPEND->FormValue != NULL && $this->DEPEND->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DEPEND->caption(), $this->DEPEND->RequiredErrorMessage));
			}
		}
		if ($this->DEPEND->MultiUpdate != "") {
			if (!CheckNumber($this->DEPEND->FormValue)) {
				AddMessage($FormError, $this->DEPEND->errorMessage());
			}
		}
		if ($this->DTE_NAIS->Required) {
			if ($this->DTE_NAIS->MultiUpdate != "" && !$this->DTE_NAIS->IsDetailKey && $this->DTE_NAIS->FormValue != NULL && $this->DTE_NAIS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DTE_NAIS->caption(), $this->DTE_NAIS->RequiredErrorMessage));
			}
		}
		if ($this->DTE_NAIS->MultiUpdate != "") {
			if (!CheckDate($this->DTE_NAIS->FormValue)) {
				AddMessage($FormError, $this->DTE_NAIS->errorMessage());
			}
		}
		if ($this->LIEU_NAIS->Required) {
			if ($this->LIEU_NAIS->MultiUpdate != "" && !$this->LIEU_NAIS->IsDetailKey && $this->LIEU_NAIS->FormValue != NULL && $this->LIEU_NAIS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LIEU_NAIS->caption(), $this->LIEU_NAIS->RequiredErrorMessage));
			}
		}
		if ($this->NATION->Required) {
			if ($this->NATION->MultiUpdate != "" && !$this->NATION->IsDetailKey && $this->NATION->FormValue != NULL && $this->NATION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NATION->caption(), $this->NATION->RequiredErrorMessage));
			}
		}
		if ($this->ADRESSE->Required) {
			if ($this->ADRESSE->MultiUpdate != "" && !$this->ADRESSE->IsDetailKey && $this->ADRESSE->FormValue != NULL && $this->ADRESSE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ADRESSE->caption(), $this->ADRESSE->RequiredErrorMessage));
			}
		}
		if ($this->VILLE->Required) {
			if ($this->VILLE->MultiUpdate != "" && !$this->VILLE->IsDetailKey && $this->VILLE->FormValue != NULL && $this->VILLE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->VILLE->caption(), $this->VILLE->RequiredErrorMessage));
			}
		}
		if ($this->PAYS->Required) {
			if ($this->PAYS->MultiUpdate != "" && !$this->PAYS->IsDetailKey && $this->PAYS->FormValue != NULL && $this->PAYS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PAYS->caption(), $this->PAYS->RequiredErrorMessage));
			}
		}
		if ($this->BOX->Required) {
			if ($this->BOX->MultiUpdate != "" && !$this->BOX->IsDetailKey && $this->BOX->FormValue != NULL && $this->BOX->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->BOX->caption(), $this->BOX->RequiredErrorMessage));
			}
		}
		if ($this->PHONE->Required) {
			if ($this->PHONE->MultiUpdate != "" && !$this->PHONE->IsDetailKey && $this->PHONE->FormValue != NULL && $this->PHONE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PHONE->caption(), $this->PHONE->RequiredErrorMessage));
			}
		}
		if ($this->REFERENCE->Required) {
			if ($this->REFERENCE->MultiUpdate != "" && !$this->REFERENCE->IsDetailKey && $this->REFERENCE->FormValue != NULL && $this->REFERENCE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->REFERENCE->caption(), $this->REFERENCE->RequiredErrorMessage));
			}
		}
		if ($this->QUALIF->Required) {
			if ($this->QUALIF->MultiUpdate != "" && !$this->QUALIF->IsDetailKey && $this->QUALIF->FormValue != NULL && $this->QUALIF->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->QUALIF->caption(), $this->QUALIF->RequiredErrorMessage));
			}
		}
		if ($this->URGENCE->Required) {
			if ($this->URGENCE->MultiUpdate != "" && !$this->URGENCE->IsDetailKey && $this->URGENCE->FormValue != NULL && $this->URGENCE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->URGENCE->caption(), $this->URGENCE->RequiredErrorMessage));
			}
		}
		if ($this->PHONE_URG->Required) {
			if ($this->PHONE_URG->MultiUpdate != "" && !$this->PHONE_URG->IsDetailKey && $this->PHONE_URG->FormValue != NULL && $this->PHONE_URG->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PHONE_URG->caption(), $this->PHONE_URG->RequiredErrorMessage));
			}
		}
		if ($this->DATE_EMP->Required) {
			if ($this->DATE_EMP->MultiUpdate != "" && !$this->DATE_EMP->IsDetailKey && $this->DATE_EMP->FormValue != NULL && $this->DATE_EMP->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DATE_EMP->caption(), $this->DATE_EMP->RequiredErrorMessage));
			}
		}
		if ($this->DATE_EMP->MultiUpdate != "") {
			if (!CheckDate($this->DATE_EMP->FormValue)) {
				AddMessage($FormError, $this->DATE_EMP->errorMessage());
			}
		}
		if ($this->SERVICE->Required) {
			if ($this->SERVICE->MultiUpdate != "" && !$this->SERVICE->IsDetailKey && $this->SERVICE->FormValue != NULL && $this->SERVICE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SERVICE->caption(), $this->SERVICE->RequiredErrorMessage));
			}
		}
		if ($this->DEPT->Required) {
			if ($this->DEPT->MultiUpdate != "" && !$this->DEPT->IsDetailKey && $this->DEPT->FormValue != NULL && $this->DEPT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DEPT->caption(), $this->DEPT->RequiredErrorMessage));
			}
		}
		if ($this->DEPT->MultiUpdate != "") {
			if (!CheckNumber($this->DEPT->FormValue)) {
				AddMessage($FormError, $this->DEPT->errorMessage());
			}
		}
		if ($this->SECTION->Required) {
			if ($this->SECTION->MultiUpdate != "" && !$this->SECTION->IsDetailKey && $this->SECTION->FormValue != NULL && $this->SECTION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SECTION->caption(), $this->SECTION->RequiredErrorMessage));
			}
		}
		if ($this->CATEGORIE->Required) {
			if ($this->CATEGORIE->MultiUpdate != "" && !$this->CATEGORIE->IsDetailKey && $this->CATEGORIE->FormValue != NULL && $this->CATEGORIE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->CATEGORIE->caption(), $this->CATEGORIE->RequiredErrorMessage));
			}
		}
		if ($this->FONCTION->Required) {
			if ($this->FONCTION->MultiUpdate != "" && !$this->FONCTION->IsDetailKey && $this->FONCTION->FormValue != NULL && $this->FONCTION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->FONCTION->caption(), $this->FONCTION->RequiredErrorMessage));
			}
		}
		if ($this->STATUT->Required) {
			if ($this->STATUT->MultiUpdate != "" && !$this->STATUT->IsDetailKey && $this->STATUT->FormValue != NULL && $this->STATUT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->STATUT->caption(), $this->STATUT->RequiredErrorMessage));
			}
		}
		if ($this->STA_DEBUT->Required) {
			if ($this->STA_DEBUT->MultiUpdate != "" && !$this->STA_DEBUT->IsDetailKey && $this->STA_DEBUT->FormValue != NULL && $this->STA_DEBUT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->STA_DEBUT->caption(), $this->STA_DEBUT->RequiredErrorMessage));
			}
		}
		if ($this->STA_DEBUT->MultiUpdate != "") {
			if (!CheckDate($this->STA_DEBUT->FormValue)) {
				AddMessage($FormError, $this->STA_DEBUT->errorMessage());
			}
		}
		if ($this->STA_FIN->Required) {
			if ($this->STA_FIN->MultiUpdate != "" && !$this->STA_FIN->IsDetailKey && $this->STA_FIN->FormValue != NULL && $this->STA_FIN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->STA_FIN->caption(), $this->STA_FIN->RequiredErrorMessage));
			}
		}
		if ($this->STA_FIN->MultiUpdate != "") {
			if (!CheckDate($this->STA_FIN->FormValue)) {
				AddMessage($FormError, $this->STA_FIN->errorMessage());
			}
		}
		if ($this->STA_MOTIF->Required) {
			if ($this->STA_MOTIF->MultiUpdate != "" && !$this->STA_MOTIF->IsDetailKey && $this->STA_MOTIF->FormValue != NULL && $this->STA_MOTIF->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->STA_MOTIF->caption(), $this->STA_MOTIF->RequiredErrorMessage));
			}
		}
		if ($this->NO_NIF->Required) {
			if ($this->NO_NIF->MultiUpdate != "" && !$this->NO_NIF->IsDetailKey && $this->NO_NIF->FormValue != NULL && $this->NO_NIF->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NO_NIF->caption(), $this->NO_NIF->RequiredErrorMessage));
			}
		}
		if ($this->NO_NIF->MultiUpdate != "") {
			if (!CheckNumber($this->NO_NIF->FormValue)) {
				AddMessage($FormError, $this->NO_NIF->errorMessage());
			}
		}
		if ($this->NO_ONA->Required) {
			if ($this->NO_ONA->MultiUpdate != "" && !$this->NO_ONA->IsDetailKey && $this->NO_ONA->FormValue != NULL && $this->NO_ONA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NO_ONA->caption(), $this->NO_ONA->RequiredErrorMessage));
			}
		}
		if ($this->LIV_TRAV->Required) {
			if ($this->LIV_TRAV->MultiUpdate != "" && !$this->LIV_TRAV->IsDetailKey && $this->LIV_TRAV->FormValue != NULL && $this->LIV_TRAV->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->LIV_TRAV->caption(), $this->LIV_TRAV->RequiredErrorMessage));
			}
		}
		if ($this->MT_SALAIRE->Required) {
			if ($this->MT_SALAIRE->MultiUpdate != "" && !$this->MT_SALAIRE->IsDetailKey && $this->MT_SALAIRE->FormValue != NULL && $this->MT_SALAIRE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MT_SALAIRE->caption(), $this->MT_SALAIRE->RequiredErrorMessage));
			}
		}
		if ($this->MT_SALAIRE->MultiUpdate != "") {
			if (!CheckNumber($this->MT_SALAIRE->FormValue)) {
				AddMessage($FormError, $this->MT_SALAIRE->errorMessage());
			}
		}
		if ($this->MT_FRAIS->Required) {
			if ($this->MT_FRAIS->MultiUpdate != "" && !$this->MT_FRAIS->IsDetailKey && $this->MT_FRAIS->FormValue != NULL && $this->MT_FRAIS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MT_FRAIS->caption(), $this->MT_FRAIS->RequiredErrorMessage));
			}
		}
		if ($this->MT_FRAIS->MultiUpdate != "") {
			if (!CheckNumber($this->MT_FRAIS->FormValue)) {
				AddMessage($FormError, $this->MT_FRAIS->errorMessage());
			}
		}
		if ($this->MT_AUTRES->Required) {
			if ($this->MT_AUTRES->MultiUpdate != "" && !$this->MT_AUTRES->IsDetailKey && $this->MT_AUTRES->FormValue != NULL && $this->MT_AUTRES->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MT_AUTRES->caption(), $this->MT_AUTRES->RequiredErrorMessage));
			}
		}
		if ($this->MT_AUTRES->MultiUpdate != "") {
			if (!CheckNumber($this->MT_AUTRES->FormValue)) {
				AddMessage($FormError, $this->MT_AUTRES->errorMessage());
			}
		}
		if ($this->MODE->Required) {
			if ($this->MODE->MultiUpdate != "" && !$this->MODE->IsDetailKey && $this->MODE->FormValue != NULL && $this->MODE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MODE->caption(), $this->MODE->RequiredErrorMessage));
			}
		}
		if ($this->TYPE->Required) {
			if ($this->TYPE->MultiUpdate != "" && !$this->TYPE->IsDetailKey && $this->TYPE->FormValue != NULL && $this->TYPE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TYPE->caption(), $this->TYPE->RequiredErrorMessage));
			}
		}
		if ($this->MT_IMPOT->Required) {
			if ($this->MT_IMPOT->MultiUpdate != "" && !$this->MT_IMPOT->IsDetailKey && $this->MT_IMPOT->FormValue != NULL && $this->MT_IMPOT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MT_IMPOT->caption(), $this->MT_IMPOT->RequiredErrorMessage));
			}
		}
		if ($this->MT_IMPOT->MultiUpdate != "") {
			if (!CheckNumber($this->MT_IMPOT->FormValue)) {
				AddMessage($FormError, $this->MT_IMPOT->errorMessage());
			}
		}
		if ($this->PER_IMPOT->Required) {
			if ($this->PER_IMPOT->MultiUpdate != "" && !$this->PER_IMPOT->IsDetailKey && $this->PER_IMPOT->FormValue != NULL && $this->PER_IMPOT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_IMPOT->caption(), $this->PER_IMPOT->RequiredErrorMessage));
			}
		}
		if ($this->PRET_ONA->Required) {
			if ($this->PRET_ONA->MultiUpdate != "" && !$this->PRET_ONA->IsDetailKey && $this->PRET_ONA->FormValue != NULL && $this->PRET_ONA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PRET_ONA->caption(), $this->PRET_ONA->RequiredErrorMessage));
			}
		}
		if ($this->PRET_ONA->MultiUpdate != "") {
			if (!CheckNumber($this->PRET_ONA->FormValue)) {
				AddMessage($FormError, $this->PRET_ONA->errorMessage());
			}
		}
		if ($this->PER_ONA->Required) {
			if ($this->PER_ONA->MultiUpdate != "" && !$this->PER_ONA->IsDetailKey && $this->PER_ONA->FormValue != NULL && $this->PER_ONA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_ONA->caption(), $this->PER_ONA->RequiredErrorMessage));
			}
		}
		if ($this->RET_ASSUR->Required) {
			if ($this->RET_ASSUR->MultiUpdate != "" && !$this->RET_ASSUR->IsDetailKey && $this->RET_ASSUR->FormValue != NULL && $this->RET_ASSUR->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RET_ASSUR->caption(), $this->RET_ASSUR->RequiredErrorMessage));
			}
		}
		if ($this->RET_ASSUR->MultiUpdate != "") {
			if (!CheckNumber($this->RET_ASSUR->FormValue)) {
				AddMessage($FormError, $this->RET_ASSUR->errorMessage());
			}
		}
		if ($this->PER_ASSUR->Required) {
			if ($this->PER_ASSUR->MultiUpdate != "" && !$this->PER_ASSUR->IsDetailKey && $this->PER_ASSUR->FormValue != NULL && $this->PER_ASSUR->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_ASSUR->caption(), $this->PER_ASSUR->RequiredErrorMessage));
			}
		}
		if ($this->PRET_SALAIRE->Required) {
			if ($this->PRET_SALAIRE->MultiUpdate != "" && !$this->PRET_SALAIRE->IsDetailKey && $this->PRET_SALAIRE->FormValue != NULL && $this->PRET_SALAIRE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PRET_SALAIRE->caption(), $this->PRET_SALAIRE->RequiredErrorMessage));
			}
		}
		if ($this->PRET_SALAIRE->MultiUpdate != "") {
			if (!CheckNumber($this->PRET_SALAIRE->FormValue)) {
				AddMessage($FormError, $this->PRET_SALAIRE->errorMessage());
			}
		}
		if ($this->PER_SALAIRE->Required) {
			if ($this->PER_SALAIRE->MultiUpdate != "" && !$this->PER_SALAIRE->IsDetailKey && $this->PER_SALAIRE->FormValue != NULL && $this->PER_SALAIRE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_SALAIRE->caption(), $this->PER_SALAIRE->RequiredErrorMessage));
			}
		}
		if ($this->PER_SALAIRE->MultiUpdate != "") {
			if (!CheckNumber($this->PER_SALAIRE->FormValue)) {
				AddMessage($FormError, $this->PER_SALAIRE->errorMessage());
			}
		}
		if ($this->RET_PENSION->Required) {
			if ($this->RET_PENSION->MultiUpdate != "" && !$this->RET_PENSION->IsDetailKey && $this->RET_PENSION->FormValue != NULL && $this->RET_PENSION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RET_PENSION->caption(), $this->RET_PENSION->RequiredErrorMessage));
			}
		}
		if ($this->RET_PENSION->MultiUpdate != "") {
			if (!CheckNumber($this->RET_PENSION->FormValue)) {
				AddMessage($FormError, $this->RET_PENSION->errorMessage());
			}
		}
		if ($this->PER_RETPENSION->Required) {
			if ($this->PER_RETPENSION->MultiUpdate != "" && !$this->PER_RETPENSION->IsDetailKey && $this->PER_RETPENSION->FormValue != NULL && $this->PER_RETPENSION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_RETPENSION->caption(), $this->PER_RETPENSION->RequiredErrorMessage));
			}
		}
		if ($this->PRET_BANQUE->Required) {
			if ($this->PRET_BANQUE->MultiUpdate != "" && !$this->PRET_BANQUE->IsDetailKey && $this->PRET_BANQUE->FormValue != NULL && $this->PRET_BANQUE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PRET_BANQUE->caption(), $this->PRET_BANQUE->RequiredErrorMessage));
			}
		}
		if ($this->PRET_BANQUE->MultiUpdate != "") {
			if (!CheckNumber($this->PRET_BANQUE->FormValue)) {
				AddMessage($FormError, $this->PRET_BANQUE->errorMessage());
			}
		}
		if ($this->PER_BANQUE->Required) {
			if ($this->PER_BANQUE->MultiUpdate != "" && !$this->PER_BANQUE->IsDetailKey && $this->PER_BANQUE->FormValue != NULL && $this->PER_BANQUE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_BANQUE->caption(), $this->PER_BANQUE->RequiredErrorMessage));
			}
		}
		if ($this->PER_BANQUE->MultiUpdate != "") {
			if (!CheckNumber($this->PER_BANQUE->FormValue)) {
				AddMessage($FormError, $this->PER_BANQUE->errorMessage());
			}
		}
		if ($this->RET_AVANC->Required) {
			if ($this->RET_AVANC->MultiUpdate != "" && !$this->RET_AVANC->IsDetailKey && $this->RET_AVANC->FormValue != NULL && $this->RET_AVANC->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RET_AVANC->caption(), $this->RET_AVANC->RequiredErrorMessage));
			}
		}
		if ($this->RET_AVANC->MultiUpdate != "") {
			if (!CheckNumber($this->RET_AVANC->FormValue)) {
				AddMessage($FormError, $this->RET_AVANC->errorMessage());
			}
		}
		if ($this->PER_AVANCE->Required) {
			if ($this->PER_AVANCE->MultiUpdate != "" && !$this->PER_AVANCE->IsDetailKey && $this->PER_AVANCE->FormValue != NULL && $this->PER_AVANCE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_AVANCE->caption(), $this->PER_AVANCE->RequiredErrorMessage));
			}
		}
		if ($this->PRET_PENSION->Required) {
			if ($this->PRET_PENSION->MultiUpdate != "" && !$this->PRET_PENSION->IsDetailKey && $this->PRET_PENSION->FormValue != NULL && $this->PRET_PENSION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PRET_PENSION->caption(), $this->PRET_PENSION->RequiredErrorMessage));
			}
		}
		if ($this->PRET_PENSION->MultiUpdate != "") {
			if (!CheckNumber($this->PRET_PENSION->FormValue)) {
				AddMessage($FormError, $this->PRET_PENSION->errorMessage());
			}
		}
		if ($this->PER_PENSION->Required) {
			if ($this->PER_PENSION->MultiUpdate != "" && !$this->PER_PENSION->IsDetailKey && $this->PER_PENSION->FormValue != NULL && $this->PER_PENSION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_PENSION->caption(), $this->PER_PENSION->RequiredErrorMessage));
			}
		}
		if ($this->RET_CAFET->Required) {
			if ($this->RET_CAFET->MultiUpdate != "" && !$this->RET_CAFET->IsDetailKey && $this->RET_CAFET->FormValue != NULL && $this->RET_CAFET->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RET_CAFET->caption(), $this->RET_CAFET->RequiredErrorMessage));
			}
		}
		if ($this->RET_CAFET->MultiUpdate != "") {
			if (!CheckNumber($this->RET_CAFET->FormValue)) {
				AddMessage($FormError, $this->RET_CAFET->errorMessage());
			}
		}
		if ($this->PER_CAFET->Required) {
			if ($this->PER_CAFET->MultiUpdate != "" && !$this->PER_CAFET->IsDetailKey && $this->PER_CAFET->FormValue != NULL && $this->PER_CAFET->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_CAFET->caption(), $this->PER_CAFET->RequiredErrorMessage));
			}
		}
		if ($this->RET_CITE->Required) {
			if ($this->RET_CITE->MultiUpdate != "" && !$this->RET_CITE->IsDetailKey && $this->RET_CITE->FormValue != NULL && $this->RET_CITE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RET_CITE->caption(), $this->RET_CITE->RequiredErrorMessage));
			}
		}
		if ($this->RET_CITE->MultiUpdate != "") {
			if (!CheckNumber($this->RET_CITE->FormValue)) {
				AddMessage($FormError, $this->RET_CITE->errorMessage());
			}
		}
		if ($this->PER_CITE->Required) {
			if ($this->PER_CITE->MultiUpdate != "" && !$this->PER_CITE->IsDetailKey && $this->PER_CITE->FormValue != NULL && $this->PER_CITE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_CITE->caption(), $this->PER_CITE->RequiredErrorMessage));
			}
		}
		if ($this->RET_AUTRE->Required) {
			if ($this->RET_AUTRE->MultiUpdate != "" && !$this->RET_AUTRE->IsDetailKey && $this->RET_AUTRE->FormValue != NULL && $this->RET_AUTRE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->RET_AUTRE->caption(), $this->RET_AUTRE->RequiredErrorMessage));
			}
		}
		if ($this->RET_AUTRE->MultiUpdate != "") {
			if (!CheckNumber($this->RET_AUTRE->FormValue)) {
				AddMessage($FormError, $this->RET_AUTRE->errorMessage());
			}
		}
		if ($this->PER_AUTRE->Required) {
			if ($this->PER_AUTRE->MultiUpdate != "" && !$this->PER_AUTRE->IsDetailKey && $this->PER_AUTRE->FormValue != NULL && $this->PER_AUTRE->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PER_AUTRE->caption(), $this->PER_AUTRE->RequiredErrorMessage));
			}
		}
		if ($this->ACQ_NB_CON->Required) {
			if ($this->ACQ_NB_CON->MultiUpdate != "" && !$this->ACQ_NB_CON->IsDetailKey && $this->ACQ_NB_CON->FormValue != NULL && $this->ACQ_NB_CON->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACQ_NB_CON->caption(), $this->ACQ_NB_CON->RequiredErrorMessage));
			}
		}
		if ($this->ACQ_NB_CON->MultiUpdate != "") {
			if (!CheckNumber($this->ACQ_NB_CON->FormValue)) {
				AddMessage($FormError, $this->ACQ_NB_CON->errorMessage());
			}
		}
		if ($this->ACC_MT_BRUT->Required) {
			if ($this->ACC_MT_BRUT->MultiUpdate != "" && !$this->ACC_MT_BRUT->IsDetailKey && $this->ACC_MT_BRUT->FormValue != NULL && $this->ACC_MT_BRUT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_BRUT->caption(), $this->ACC_MT_BRUT->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_BRUT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_BRUT->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_BRUT->errorMessage());
			}
		}
		if ($this->ACC_NB_CON->Required) {
			if ($this->ACC_NB_CON->MultiUpdate != "" && !$this->ACC_NB_CON->IsDetailKey && $this->ACC_NB_CON->FormValue != NULL && $this->ACC_NB_CON->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_CON->caption(), $this->ACC_NB_CON->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_CON->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_CON->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_CON->errorMessage());
			}
		}
		if ($this->ACC_NB_PCON->Required) {
			if ($this->ACC_NB_PCON->MultiUpdate != "" && !$this->ACC_NB_PCON->IsDetailKey && $this->ACC_NB_PCON->FormValue != NULL && $this->ACC_NB_PCON->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_PCON->caption(), $this->ACC_NB_PCON->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_PCON->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_PCON->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_PCON->errorMessage());
			}
		}
		if ($this->ACC_MT_OVT->Required) {
			if ($this->ACC_MT_OVT->MultiUpdate != "" && !$this->ACC_MT_OVT->IsDetailKey && $this->ACC_MT_OVT->FormValue != NULL && $this->ACC_MT_OVT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_OVT->caption(), $this->ACC_MT_OVT->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_OVT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_OVT->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_OVT->errorMessage());
			}
		}
		if ($this->ACQ_NB_MAL->Required) {
			if ($this->ACQ_NB_MAL->MultiUpdate != "" && !$this->ACQ_NB_MAL->IsDetailKey && $this->ACQ_NB_MAL->FormValue != NULL && $this->ACQ_NB_MAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACQ_NB_MAL->caption(), $this->ACQ_NB_MAL->RequiredErrorMessage));
			}
		}
		if ($this->ACQ_NB_MAL->MultiUpdate != "") {
			if (!CheckNumber($this->ACQ_NB_MAL->FormValue)) {
				AddMessage($FormError, $this->ACQ_NB_MAL->errorMessage());
			}
		}
		if ($this->ACC_NB_MAL->Required) {
			if ($this->ACC_NB_MAL->MultiUpdate != "" && !$this->ACC_NB_MAL->IsDetailKey && $this->ACC_NB_MAL->FormValue != NULL && $this->ACC_NB_MAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_MAL->caption(), $this->ACC_NB_MAL->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_MAL->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_MAL->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_MAL->errorMessage());
			}
		}
		if ($this->ACC_MT_CON->Required) {
			if ($this->ACC_MT_CON->MultiUpdate != "" && !$this->ACC_MT_CON->IsDetailKey && $this->ACC_MT_CON->FormValue != NULL && $this->ACC_MT_CON->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_CON->caption(), $this->ACC_MT_CON->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_CON->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_CON->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_CON->errorMessage());
			}
		}
		if ($this->ACC_NB_MAT->Required) {
			if ($this->ACC_NB_MAT->MultiUpdate != "" && !$this->ACC_NB_MAT->IsDetailKey && $this->ACC_NB_MAT->FormValue != NULL && $this->ACC_NB_MAT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_MAT->caption(), $this->ACC_NB_MAT->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_MAT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_MAT->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_MAT->errorMessage());
			}
		}
		if ($this->ACC_MT_BONI->Required) {
			if ($this->ACC_MT_BONI->MultiUpdate != "" && !$this->ACC_MT_BONI->IsDetailKey && $this->ACC_MT_BONI->FormValue != NULL && $this->ACC_MT_BONI->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_BONI->caption(), $this->ACC_MT_BONI->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_BONI->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_BONI->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_BONI->errorMessage());
			}
		}
		if ($this->ACC_NB_PER->Required) {
			if ($this->ACC_NB_PER->MultiUpdate != "" && !$this->ACC_NB_PER->IsDetailKey && $this->ACC_NB_PER->FormValue != NULL && $this->ACC_NB_PER->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_PER->caption(), $this->ACC_NB_PER->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_PER->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_PER->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_PER->errorMessage());
			}
		}
		if ($this->ACC_MT_AUT->Required) {
			if ($this->ACC_MT_AUT->MultiUpdate != "" && !$this->ACC_MT_AUT->IsDetailKey && $this->ACC_MT_AUT->FormValue != NULL && $this->ACC_MT_AUT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_AUT->caption(), $this->ACC_MT_AUT->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_AUT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_AUT->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_AUT->errorMessage());
			}
		}
		if ($this->ACC_NB_COM->Required) {
			if ($this->ACC_NB_COM->MultiUpdate != "" && !$this->ACC_NB_COM->IsDetailKey && $this->ACC_NB_COM->FormValue != NULL && $this->ACC_NB_COM->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_COM->caption(), $this->ACC_NB_COM->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_COM->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_COM->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_COM->errorMessage());
			}
		}
		if ($this->ACC_BAL_SAL->Required) {
			if ($this->ACC_BAL_SAL->MultiUpdate != "" && !$this->ACC_BAL_SAL->IsDetailKey && $this->ACC_BAL_SAL->FormValue != NULL && $this->ACC_BAL_SAL->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_BAL_SAL->caption(), $this->ACC_BAL_SAL->RequiredErrorMessage));
			}
		}
		if ($this->ACC_BAL_SAL->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_BAL_SAL->FormValue)) {
				AddMessage($FormError, $this->ACC_BAL_SAL->errorMessage());
			}
		}
		if ($this->ACC_BAL_BAN->Required) {
			if ($this->ACC_BAL_BAN->MultiUpdate != "" && !$this->ACC_BAL_BAN->IsDetailKey && $this->ACC_BAL_BAN->FormValue != NULL && $this->ACC_BAL_BAN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_BAL_BAN->caption(), $this->ACC_BAL_BAN->RequiredErrorMessage));
			}
		}
		if ($this->ACC_BAL_BAN->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_BAL_BAN->FormValue)) {
				AddMessage($FormError, $this->ACC_BAL_BAN->errorMessage());
			}
		}
		if ($this->ACC_NB_SUS->Required) {
			if ($this->ACC_NB_SUS->MultiUpdate != "" && !$this->ACC_NB_SUS->IsDetailKey && $this->ACC_NB_SUS->FormValue != NULL && $this->ACC_NB_SUS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_SUS->caption(), $this->ACC_NB_SUS->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_SUS->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_SUS->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_SUS->errorMessage());
			}
		}
		if ($this->ACC_BAL_ONA->Required) {
			if ($this->ACC_BAL_ONA->MultiUpdate != "" && !$this->ACC_BAL_ONA->IsDetailKey && $this->ACC_BAL_ONA->FormValue != NULL && $this->ACC_BAL_ONA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_BAL_ONA->caption(), $this->ACC_BAL_ONA->RequiredErrorMessage));
			}
		}
		if ($this->ACC_BAL_ONA->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_BAL_ONA->FormValue)) {
				AddMessage($FormError, $this->ACC_BAL_ONA->errorMessage());
			}
		}
		if ($this->ACC_BAL_PENSION->Required) {
			if ($this->ACC_BAL_PENSION->MultiUpdate != "" && !$this->ACC_BAL_PENSION->IsDetailKey && $this->ACC_BAL_PENSION->FormValue != NULL && $this->ACC_BAL_PENSION->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_BAL_PENSION->caption(), $this->ACC_BAL_PENSION->RequiredErrorMessage));
			}
		}
		if ($this->ACC_BAL_PENSION->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_BAL_PENSION->FormValue)) {
				AddMessage($FormError, $this->ACC_BAL_PENSION->errorMessage());
			}
		}
		if ($this->ACC_NB_ABS->Required) {
			if ($this->ACC_NB_ABS->MultiUpdate != "" && !$this->ACC_NB_ABS->IsDetailKey && $this->ACC_NB_ABS->FormValue != NULL && $this->ACC_NB_ABS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_ABS->caption(), $this->ACC_NB_ABS->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_ABS->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_ABS->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_ABS->errorMessage());
			}
		}
		if ($this->ACC_MT_QZ->Required) {
			if ($this->ACC_MT_QZ->MultiUpdate != "" && !$this->ACC_MT_QZ->IsDetailKey && $this->ACC_MT_QZ->FormValue != NULL && $this->ACC_MT_QZ->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_QZ->caption(), $this->ACC_MT_QZ->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_QZ->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_QZ->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_QZ->errorMessage());
			}
		}
		if ($this->ACC_NB_TRA->Required) {
			if ($this->ACC_NB_TRA->MultiUpdate != "" && !$this->ACC_NB_TRA->IsDetailKey && $this->ACC_NB_TRA->FormValue != NULL && $this->ACC_NB_TRA->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_TRA->caption(), $this->ACC_NB_TRA->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_TRA->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_TRA->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_TRA->errorMessage());
			}
		}
		if ($this->ACC_MT_AJST->Required) {
			if ($this->ACC_MT_AJST->MultiUpdate != "" && !$this->ACC_MT_AJST->IsDetailKey && $this->ACC_MT_AJST->FormValue != NULL && $this->ACC_MT_AJST->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_MT_AJST->caption(), $this->ACC_MT_AJST->RequiredErrorMessage));
			}
		}
		if ($this->ACC_MT_AJST->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_MT_AJST->FormValue)) {
				AddMessage($FormError, $this->ACC_MT_AJST->errorMessage());
			}
		}
		if ($this->ACC_NB_TRA_ACT->Required) {
			if ($this->ACC_NB_TRA_ACT->MultiUpdate != "" && !$this->ACC_NB_TRA_ACT->IsDetailKey && $this->ACC_NB_TRA_ACT->FormValue != NULL && $this->ACC_NB_TRA_ACT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_NB_TRA_ACT->caption(), $this->ACC_NB_TRA_ACT->RequiredErrorMessage));
			}
		}
		if ($this->ACC_NB_TRA_ACT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_NB_TRA_ACT->FormValue)) {
				AddMessage($FormError, $this->ACC_NB_TRA_ACT->errorMessage());
			}
		}
		if ($this->ACC1_MT_BRUT->Required) {
			if ($this->ACC1_MT_BRUT->MultiUpdate != "" && !$this->ACC1_MT_BRUT->IsDetailKey && $this->ACC1_MT_BRUT->FormValue != NULL && $this->ACC1_MT_BRUT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC1_MT_BRUT->caption(), $this->ACC1_MT_BRUT->RequiredErrorMessage));
			}
		}
		if ($this->ACC1_MT_BRUT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC1_MT_BRUT->FormValue)) {
				AddMessage($FormError, $this->ACC1_MT_BRUT->errorMessage());
			}
		}
		if ($this->ACC_RENDEMENT->Required) {
			if ($this->ACC_RENDEMENT->MultiUpdate != "" && !$this->ACC_RENDEMENT->IsDetailKey && $this->ACC_RENDEMENT->FormValue != NULL && $this->ACC_RENDEMENT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ACC_RENDEMENT->caption(), $this->ACC_RENDEMENT->RequiredErrorMessage));
			}
		}
		if ($this->ACC_RENDEMENT->MultiUpdate != "") {
			if (!CheckNumber($this->ACC_RENDEMENT->FormValue)) {
				AddMessage($FormError, $this->ACC_RENDEMENT->errorMessage());
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// id
			$this->id->setDbValueDef($rsnew, $this->id->CurrentValue, NULL, $this->id->ReadOnly || $this->id->MultiUpdate != "1");

			// RN
			$this->RN->setDbValueDef($rsnew, $this->RN->CurrentValue, NULL, $this->RN->ReadOnly || $this->RN->MultiUpdate != "1");

			// NO_EMP
			$this->NO_EMP->setDbValueDef($rsnew, $this->NO_EMP->CurrentValue, NULL, $this->NO_EMP->ReadOnly || $this->NO_EMP->MultiUpdate != "1");

			// NOM_EMP
			$this->NOM_EMP->setDbValueDef($rsnew, $this->NOM_EMP->CurrentValue, NULL, $this->NOM_EMP->ReadOnly || $this->NOM_EMP->MultiUpdate != "1");

			// SEXE
			$this->SEXE->setDbValueDef($rsnew, $this->SEXE->CurrentValue, NULL, $this->SEXE->ReadOnly || $this->SEXE->MultiUpdate != "1");

			// ETAT_C
			$this->ETAT_C->setDbValueDef($rsnew, $this->ETAT_C->CurrentValue, NULL, $this->ETAT_C->ReadOnly || $this->ETAT_C->MultiUpdate != "1");

			// DEPEND
			$this->DEPEND->setDbValueDef($rsnew, $this->DEPEND->CurrentValue, NULL, $this->DEPEND->ReadOnly || $this->DEPEND->MultiUpdate != "1");

			// DTE_NAIS
			$this->DTE_NAIS->setDbValueDef($rsnew, UnFormatDateTime($this->DTE_NAIS->CurrentValue, 0), NULL, $this->DTE_NAIS->ReadOnly || $this->DTE_NAIS->MultiUpdate != "1");

			// LIEU_NAIS
			$this->LIEU_NAIS->setDbValueDef($rsnew, $this->LIEU_NAIS->CurrentValue, NULL, $this->LIEU_NAIS->ReadOnly || $this->LIEU_NAIS->MultiUpdate != "1");

			// NATION
			$this->NATION->setDbValueDef($rsnew, $this->NATION->CurrentValue, NULL, $this->NATION->ReadOnly || $this->NATION->MultiUpdate != "1");

			// ADRESSE
			$this->ADRESSE->setDbValueDef($rsnew, $this->ADRESSE->CurrentValue, NULL, $this->ADRESSE->ReadOnly || $this->ADRESSE->MultiUpdate != "1");

			// VILLE
			$this->VILLE->setDbValueDef($rsnew, $this->VILLE->CurrentValue, NULL, $this->VILLE->ReadOnly || $this->VILLE->MultiUpdate != "1");

			// PAYS
			$this->PAYS->setDbValueDef($rsnew, $this->PAYS->CurrentValue, NULL, $this->PAYS->ReadOnly || $this->PAYS->MultiUpdate != "1");

			// BOX
			$this->BOX->setDbValueDef($rsnew, $this->BOX->CurrentValue, NULL, $this->BOX->ReadOnly || $this->BOX->MultiUpdate != "1");

			// PHONE
			$this->PHONE->setDbValueDef($rsnew, $this->PHONE->CurrentValue, NULL, $this->PHONE->ReadOnly || $this->PHONE->MultiUpdate != "1");

			// REFERENCE
			$this->REFERENCE->setDbValueDef($rsnew, $this->REFERENCE->CurrentValue, NULL, $this->REFERENCE->ReadOnly || $this->REFERENCE->MultiUpdate != "1");

			// QUALIF
			$this->QUALIF->setDbValueDef($rsnew, $this->QUALIF->CurrentValue, NULL, $this->QUALIF->ReadOnly || $this->QUALIF->MultiUpdate != "1");

			// URGENCE
			$this->URGENCE->setDbValueDef($rsnew, $this->URGENCE->CurrentValue, NULL, $this->URGENCE->ReadOnly || $this->URGENCE->MultiUpdate != "1");

			// PHONE_URG
			$this->PHONE_URG->setDbValueDef($rsnew, $this->PHONE_URG->CurrentValue, NULL, $this->PHONE_URG->ReadOnly || $this->PHONE_URG->MultiUpdate != "1");

			// DATE_EMP
			$this->DATE_EMP->setDbValueDef($rsnew, UnFormatDateTime($this->DATE_EMP->CurrentValue, 0), NULL, $this->DATE_EMP->ReadOnly || $this->DATE_EMP->MultiUpdate != "1");

			// SERVICE
			$this->SERVICE->setDbValueDef($rsnew, $this->SERVICE->CurrentValue, NULL, $this->SERVICE->ReadOnly || $this->SERVICE->MultiUpdate != "1");

			// DEPT
			$this->DEPT->setDbValueDef($rsnew, $this->DEPT->CurrentValue, NULL, $this->DEPT->ReadOnly || $this->DEPT->MultiUpdate != "1");

			// SECTION
			$this->SECTION->setDbValueDef($rsnew, $this->SECTION->CurrentValue, NULL, $this->SECTION->ReadOnly || $this->SECTION->MultiUpdate != "1");

			// CATEGORIE
			$this->CATEGORIE->setDbValueDef($rsnew, $this->CATEGORIE->CurrentValue, NULL, $this->CATEGORIE->ReadOnly || $this->CATEGORIE->MultiUpdate != "1");

			// FONCTION
			$this->FONCTION->setDbValueDef($rsnew, $this->FONCTION->CurrentValue, NULL, $this->FONCTION->ReadOnly || $this->FONCTION->MultiUpdate != "1");

			// STATUT
			$this->STATUT->setDbValueDef($rsnew, $this->STATUT->CurrentValue, NULL, $this->STATUT->ReadOnly || $this->STATUT->MultiUpdate != "1");

			// STA_DEBUT
			$this->STA_DEBUT->setDbValueDef($rsnew, UnFormatDateTime($this->STA_DEBUT->CurrentValue, 0), NULL, $this->STA_DEBUT->ReadOnly || $this->STA_DEBUT->MultiUpdate != "1");

			// STA_FIN
			$this->STA_FIN->setDbValueDef($rsnew, UnFormatDateTime($this->STA_FIN->CurrentValue, 0), NULL, $this->STA_FIN->ReadOnly || $this->STA_FIN->MultiUpdate != "1");

			// STA_MOTIF
			$this->STA_MOTIF->setDbValueDef($rsnew, $this->STA_MOTIF->CurrentValue, NULL, $this->STA_MOTIF->ReadOnly || $this->STA_MOTIF->MultiUpdate != "1");

			// NO_NIF
			$this->NO_NIF->setDbValueDef($rsnew, $this->NO_NIF->CurrentValue, NULL, $this->NO_NIF->ReadOnly || $this->NO_NIF->MultiUpdate != "1");

			// NO_ONA
			$this->NO_ONA->setDbValueDef($rsnew, $this->NO_ONA->CurrentValue, NULL, $this->NO_ONA->ReadOnly || $this->NO_ONA->MultiUpdate != "1");

			// LIV_TRAV
			$this->LIV_TRAV->setDbValueDef($rsnew, $this->LIV_TRAV->CurrentValue, NULL, $this->LIV_TRAV->ReadOnly || $this->LIV_TRAV->MultiUpdate != "1");

			// MT_SALAIRE
			$this->MT_SALAIRE->setDbValueDef($rsnew, $this->MT_SALAIRE->CurrentValue, NULL, $this->MT_SALAIRE->ReadOnly || $this->MT_SALAIRE->MultiUpdate != "1");

			// MT_FRAIS
			$this->MT_FRAIS->setDbValueDef($rsnew, $this->MT_FRAIS->CurrentValue, NULL, $this->MT_FRAIS->ReadOnly || $this->MT_FRAIS->MultiUpdate != "1");

			// MT_AUTRES
			$this->MT_AUTRES->setDbValueDef($rsnew, $this->MT_AUTRES->CurrentValue, NULL, $this->MT_AUTRES->ReadOnly || $this->MT_AUTRES->MultiUpdate != "1");

			// MODE
			$this->MODE->setDbValueDef($rsnew, $this->MODE->CurrentValue, NULL, $this->MODE->ReadOnly || $this->MODE->MultiUpdate != "1");

			// TYPE
			$this->TYPE->setDbValueDef($rsnew, $this->TYPE->CurrentValue, NULL, $this->TYPE->ReadOnly || $this->TYPE->MultiUpdate != "1");

			// MT_IMPOT
			$this->MT_IMPOT->setDbValueDef($rsnew, $this->MT_IMPOT->CurrentValue, NULL, $this->MT_IMPOT->ReadOnly || $this->MT_IMPOT->MultiUpdate != "1");

			// PER_IMPOT
			$this->PER_IMPOT->setDbValueDef($rsnew, $this->PER_IMPOT->CurrentValue, NULL, $this->PER_IMPOT->ReadOnly || $this->PER_IMPOT->MultiUpdate != "1");

			// PRET_ONA
			$this->PRET_ONA->setDbValueDef($rsnew, $this->PRET_ONA->CurrentValue, NULL, $this->PRET_ONA->ReadOnly || $this->PRET_ONA->MultiUpdate != "1");

			// PER_ONA
			$this->PER_ONA->setDbValueDef($rsnew, $this->PER_ONA->CurrentValue, NULL, $this->PER_ONA->ReadOnly || $this->PER_ONA->MultiUpdate != "1");

			// RET_ASSUR
			$this->RET_ASSUR->setDbValueDef($rsnew, $this->RET_ASSUR->CurrentValue, NULL, $this->RET_ASSUR->ReadOnly || $this->RET_ASSUR->MultiUpdate != "1");

			// PER_ASSUR
			$this->PER_ASSUR->setDbValueDef($rsnew, $this->PER_ASSUR->CurrentValue, NULL, $this->PER_ASSUR->ReadOnly || $this->PER_ASSUR->MultiUpdate != "1");

			// PRET_SALAIRE
			$this->PRET_SALAIRE->setDbValueDef($rsnew, $this->PRET_SALAIRE->CurrentValue, NULL, $this->PRET_SALAIRE->ReadOnly || $this->PRET_SALAIRE->MultiUpdate != "1");

			// PER_SALAIRE
			$this->PER_SALAIRE->setDbValueDef($rsnew, $this->PER_SALAIRE->CurrentValue, NULL, $this->PER_SALAIRE->ReadOnly || $this->PER_SALAIRE->MultiUpdate != "1");

			// RET_PENSION
			$this->RET_PENSION->setDbValueDef($rsnew, $this->RET_PENSION->CurrentValue, NULL, $this->RET_PENSION->ReadOnly || $this->RET_PENSION->MultiUpdate != "1");

			// PER_RETPENSION
			$this->PER_RETPENSION->setDbValueDef($rsnew, $this->PER_RETPENSION->CurrentValue, NULL, $this->PER_RETPENSION->ReadOnly || $this->PER_RETPENSION->MultiUpdate != "1");

			// PRET_BANQUE
			$this->PRET_BANQUE->setDbValueDef($rsnew, $this->PRET_BANQUE->CurrentValue, NULL, $this->PRET_BANQUE->ReadOnly || $this->PRET_BANQUE->MultiUpdate != "1");

			// PER_BANQUE
			$this->PER_BANQUE->setDbValueDef($rsnew, $this->PER_BANQUE->CurrentValue, NULL, $this->PER_BANQUE->ReadOnly || $this->PER_BANQUE->MultiUpdate != "1");

			// RET_AVANC
			$this->RET_AVANC->setDbValueDef($rsnew, $this->RET_AVANC->CurrentValue, NULL, $this->RET_AVANC->ReadOnly || $this->RET_AVANC->MultiUpdate != "1");

			// PER_AVANCE
			$this->PER_AVANCE->setDbValueDef($rsnew, $this->PER_AVANCE->CurrentValue, NULL, $this->PER_AVANCE->ReadOnly || $this->PER_AVANCE->MultiUpdate != "1");

			// PRET_PENSION
			$this->PRET_PENSION->setDbValueDef($rsnew, $this->PRET_PENSION->CurrentValue, NULL, $this->PRET_PENSION->ReadOnly || $this->PRET_PENSION->MultiUpdate != "1");

			// PER_PENSION
			$this->PER_PENSION->setDbValueDef($rsnew, $this->PER_PENSION->CurrentValue, NULL, $this->PER_PENSION->ReadOnly || $this->PER_PENSION->MultiUpdate != "1");

			// RET_CAFET
			$this->RET_CAFET->setDbValueDef($rsnew, $this->RET_CAFET->CurrentValue, NULL, $this->RET_CAFET->ReadOnly || $this->RET_CAFET->MultiUpdate != "1");

			// PER_CAFET
			$this->PER_CAFET->setDbValueDef($rsnew, $this->PER_CAFET->CurrentValue, NULL, $this->PER_CAFET->ReadOnly || $this->PER_CAFET->MultiUpdate != "1");

			// RET_CITE
			$this->RET_CITE->setDbValueDef($rsnew, $this->RET_CITE->CurrentValue, NULL, $this->RET_CITE->ReadOnly || $this->RET_CITE->MultiUpdate != "1");

			// PER_CITE
			$this->PER_CITE->setDbValueDef($rsnew, $this->PER_CITE->CurrentValue, NULL, $this->PER_CITE->ReadOnly || $this->PER_CITE->MultiUpdate != "1");

			// RET_AUTRE
			$this->RET_AUTRE->setDbValueDef($rsnew, $this->RET_AUTRE->CurrentValue, NULL, $this->RET_AUTRE->ReadOnly || $this->RET_AUTRE->MultiUpdate != "1");

			// PER_AUTRE
			$this->PER_AUTRE->setDbValueDef($rsnew, $this->PER_AUTRE->CurrentValue, NULL, $this->PER_AUTRE->ReadOnly || $this->PER_AUTRE->MultiUpdate != "1");

			// ACQ_NB_CON
			$this->ACQ_NB_CON->setDbValueDef($rsnew, $this->ACQ_NB_CON->CurrentValue, NULL, $this->ACQ_NB_CON->ReadOnly || $this->ACQ_NB_CON->MultiUpdate != "1");

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->setDbValueDef($rsnew, $this->ACC_MT_BRUT->CurrentValue, NULL, $this->ACC_MT_BRUT->ReadOnly || $this->ACC_MT_BRUT->MultiUpdate != "1");

			// ACC_NB_CON
			$this->ACC_NB_CON->setDbValueDef($rsnew, $this->ACC_NB_CON->CurrentValue, NULL, $this->ACC_NB_CON->ReadOnly || $this->ACC_NB_CON->MultiUpdate != "1");

			// ACC_NB_PCON
			$this->ACC_NB_PCON->setDbValueDef($rsnew, $this->ACC_NB_PCON->CurrentValue, NULL, $this->ACC_NB_PCON->ReadOnly || $this->ACC_NB_PCON->MultiUpdate != "1");

			// ACC_MT_OVT
			$this->ACC_MT_OVT->setDbValueDef($rsnew, $this->ACC_MT_OVT->CurrentValue, NULL, $this->ACC_MT_OVT->ReadOnly || $this->ACC_MT_OVT->MultiUpdate != "1");

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->setDbValueDef($rsnew, $this->ACQ_NB_MAL->CurrentValue, NULL, $this->ACQ_NB_MAL->ReadOnly || $this->ACQ_NB_MAL->MultiUpdate != "1");

			// ACC_NB_MAL
			$this->ACC_NB_MAL->setDbValueDef($rsnew, $this->ACC_NB_MAL->CurrentValue, NULL, $this->ACC_NB_MAL->ReadOnly || $this->ACC_NB_MAL->MultiUpdate != "1");

			// ACC_MT_CON
			$this->ACC_MT_CON->setDbValueDef($rsnew, $this->ACC_MT_CON->CurrentValue, NULL, $this->ACC_MT_CON->ReadOnly || $this->ACC_MT_CON->MultiUpdate != "1");

			// ACC_NB_MAT
			$this->ACC_NB_MAT->setDbValueDef($rsnew, $this->ACC_NB_MAT->CurrentValue, NULL, $this->ACC_NB_MAT->ReadOnly || $this->ACC_NB_MAT->MultiUpdate != "1");

			// ACC_MT_BONI
			$this->ACC_MT_BONI->setDbValueDef($rsnew, $this->ACC_MT_BONI->CurrentValue, NULL, $this->ACC_MT_BONI->ReadOnly || $this->ACC_MT_BONI->MultiUpdate != "1");

			// ACC_NB_PER
			$this->ACC_NB_PER->setDbValueDef($rsnew, $this->ACC_NB_PER->CurrentValue, NULL, $this->ACC_NB_PER->ReadOnly || $this->ACC_NB_PER->MultiUpdate != "1");

			// ACC_MT_AUT
			$this->ACC_MT_AUT->setDbValueDef($rsnew, $this->ACC_MT_AUT->CurrentValue, NULL, $this->ACC_MT_AUT->ReadOnly || $this->ACC_MT_AUT->MultiUpdate != "1");

			// ACC_NB_COM
			$this->ACC_NB_COM->setDbValueDef($rsnew, $this->ACC_NB_COM->CurrentValue, NULL, $this->ACC_NB_COM->ReadOnly || $this->ACC_NB_COM->MultiUpdate != "1");

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->setDbValueDef($rsnew, $this->ACC_BAL_SAL->CurrentValue, NULL, $this->ACC_BAL_SAL->ReadOnly || $this->ACC_BAL_SAL->MultiUpdate != "1");

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->setDbValueDef($rsnew, $this->ACC_BAL_BAN->CurrentValue, NULL, $this->ACC_BAL_BAN->ReadOnly || $this->ACC_BAL_BAN->MultiUpdate != "1");

			// ACC_NB_SUS
			$this->ACC_NB_SUS->setDbValueDef($rsnew, $this->ACC_NB_SUS->CurrentValue, NULL, $this->ACC_NB_SUS->ReadOnly || $this->ACC_NB_SUS->MultiUpdate != "1");

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->setDbValueDef($rsnew, $this->ACC_BAL_ONA->CurrentValue, NULL, $this->ACC_BAL_ONA->ReadOnly || $this->ACC_BAL_ONA->MultiUpdate != "1");

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->setDbValueDef($rsnew, $this->ACC_BAL_PENSION->CurrentValue, NULL, $this->ACC_BAL_PENSION->ReadOnly || $this->ACC_BAL_PENSION->MultiUpdate != "1");

			// ACC_NB_ABS
			$this->ACC_NB_ABS->setDbValueDef($rsnew, $this->ACC_NB_ABS->CurrentValue, NULL, $this->ACC_NB_ABS->ReadOnly || $this->ACC_NB_ABS->MultiUpdate != "1");

			// ACC_MT_QZ
			$this->ACC_MT_QZ->setDbValueDef($rsnew, $this->ACC_MT_QZ->CurrentValue, NULL, $this->ACC_MT_QZ->ReadOnly || $this->ACC_MT_QZ->MultiUpdate != "1");

			// ACC_NB_TRA
			$this->ACC_NB_TRA->setDbValueDef($rsnew, $this->ACC_NB_TRA->CurrentValue, NULL, $this->ACC_NB_TRA->ReadOnly || $this->ACC_NB_TRA->MultiUpdate != "1");

			// ACC_MT_AJST
			$this->ACC_MT_AJST->setDbValueDef($rsnew, $this->ACC_MT_AJST->CurrentValue, NULL, $this->ACC_MT_AJST->ReadOnly || $this->ACC_MT_AJST->MultiUpdate != "1");

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->setDbValueDef($rsnew, $this->ACC_NB_TRA_ACT->CurrentValue, NULL, $this->ACC_NB_TRA_ACT->ReadOnly || $this->ACC_NB_TRA_ACT->MultiUpdate != "1");

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->setDbValueDef($rsnew, $this->ACC1_MT_BRUT->CurrentValue, NULL, $this->ACC1_MT_BRUT->ReadOnly || $this->ACC1_MT_BRUT->MultiUpdate != "1");

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->setDbValueDef($rsnew, $this->ACC_RENDEMENT->CurrentValue, NULL, $this->ACC_RENDEMENT->ReadOnly || $this->ACC_RENDEMENT->MultiUpdate != "1");

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tabemp4list.php"), "", $this->TableVar, TRUE);
		$pageId = "update";
		$Breadcrumb->add("update", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>