<?php
namespace PHPMaker2020\intextdesign_proj_v0;

/**
 * Page class
 */
class tabemp4_list extends tabemp4
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{D5394950-A905-4BDF-B7DA-D47F92A453D8}";

	// Table name
	public $TableName = 'tabemp4';

	// Page object name
	public $PageObjName = "tabemp4_list";

	// Grid form hidden field names
	public $FormName = "ftabemp4list";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tabemp4)
		if (!isset($GLOBALS["tabemp4"]) || get_class($GLOBALS["tabemp4"]) == PROJECT_NAMESPACE . "tabemp4") {
			$GLOBALS["tabemp4"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tabemp4"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "tabemp4add.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "tabemp4delete.php";
		$this->MultiUpdateUrl = "tabemp4update.php";

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tabemp4');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option ftabemp4listsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tabemp4;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tabemp4);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0)
							$val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['RN'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		if (!$Security->isLoggedIn()) // Logged in
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "10,20,50,100,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canList()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom != "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (Config("USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (Config("USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->RN->setVisibility();
		$this->NO_EMP->setVisibility();
		$this->NOM_EMP->setVisibility();
		$this->SEXE->setVisibility();
		$this->ETAT_C->setVisibility();
		$this->DEPEND->setVisibility();
		$this->DTE_NAIS->setVisibility();
		$this->LIEU_NAIS->setVisibility();
		$this->NATION->setVisibility();
		$this->ADRESSE->setVisibility();
		$this->VILLE->setVisibility();
		$this->PAYS->setVisibility();
		$this->BOX->setVisibility();
		$this->PHONE->setVisibility();
		$this->REFERENCE->setVisibility();
		$this->QUALIF->setVisibility();
		$this->URGENCE->setVisibility();
		$this->PHONE_URG->setVisibility();
		$this->DATE_EMP->setVisibility();
		$this->SERVICE->setVisibility();
		$this->DEPT->setVisibility();
		$this->SECTION->setVisibility();
		$this->CATEGORIE->setVisibility();
		$this->FONCTION->setVisibility();
		$this->STATUT->setVisibility();
		$this->STA_DEBUT->setVisibility();
		$this->STA_FIN->setVisibility();
		$this->STA_MOTIF->setVisibility();
		$this->NO_NIF->setVisibility();
		$this->NO_ONA->setVisibility();
		$this->LIV_TRAV->setVisibility();
		$this->MT_SALAIRE->setVisibility();
		$this->MT_FRAIS->setVisibility();
		$this->MT_AUTRES->setVisibility();
		$this->MODE->setVisibility();
		$this->TYPE->setVisibility();
		$this->MT_IMPOT->setVisibility();
		$this->PER_IMPOT->setVisibility();
		$this->PRET_ONA->setVisibility();
		$this->PER_ONA->setVisibility();
		$this->RET_ASSUR->setVisibility();
		$this->PER_ASSUR->setVisibility();
		$this->PRET_SALAIRE->setVisibility();
		$this->PER_SALAIRE->setVisibility();
		$this->RET_PENSION->setVisibility();
		$this->PER_RETPENSION->setVisibility();
		$this->PRET_BANQUE->setVisibility();
		$this->PER_BANQUE->setVisibility();
		$this->RET_AVANC->setVisibility();
		$this->PER_AVANCE->setVisibility();
		$this->PRET_PENSION->setVisibility();
		$this->PER_PENSION->setVisibility();
		$this->RET_CAFET->setVisibility();
		$this->PER_CAFET->setVisibility();
		$this->RET_CITE->setVisibility();
		$this->PER_CITE->setVisibility();
		$this->RET_AUTRE->setVisibility();
		$this->PER_AUTRE->setVisibility();
		$this->ACQ_NB_CON->setVisibility();
		$this->ACC_MT_BRUT->setVisibility();
		$this->ACC_NB_CON->setVisibility();
		$this->ACC_NB_PCON->setVisibility();
		$this->ACC_MT_OVT->setVisibility();
		$this->ACQ_NB_MAL->setVisibility();
		$this->ACC_NB_MAL->setVisibility();
		$this->ACC_MT_CON->setVisibility();
		$this->ACC_NB_MAT->setVisibility();
		$this->ACC_MT_BONI->setVisibility();
		$this->ACC_NB_PER->setVisibility();
		$this->ACC_MT_AUT->setVisibility();
		$this->ACC_NB_COM->setVisibility();
		$this->ACC_BAL_SAL->setVisibility();
		$this->ACC_BAL_BAN->setVisibility();
		$this->ACC_NB_SUS->setVisibility();
		$this->ACC_BAL_ONA->setVisibility();
		$this->ACC_BAL_PENSION->setVisibility();
		$this->ACC_NB_ABS->setVisibility();
		$this->ACC_MT_QZ->setVisibility();
		$this->ACC_NB_TRA->setVisibility();
		$this->ACC_MT_AJST->setVisibility();
		$this->ACC_NB_TRA_ACT->setVisibility();
		$this->ACC1_MT_BRUT->setVisibility();
		$this->ACC_RENDEMENT->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new NumericPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->RN->setOldValue($arKeyFlds[0]);
			if (!is_numeric($this->RN->OldValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->RN->AdvancedSearch->toJson(), ","); // Field RN
		$filterList = Concat($filterList, $this->NO_EMP->AdvancedSearch->toJson(), ","); // Field NO_EMP
		$filterList = Concat($filterList, $this->NOM_EMP->AdvancedSearch->toJson(), ","); // Field NOM_EMP
		$filterList = Concat($filterList, $this->SEXE->AdvancedSearch->toJson(), ","); // Field SEXE
		$filterList = Concat($filterList, $this->ETAT_C->AdvancedSearch->toJson(), ","); // Field ETAT_C
		$filterList = Concat($filterList, $this->DEPEND->AdvancedSearch->toJson(), ","); // Field DEPEND
		$filterList = Concat($filterList, $this->DTE_NAIS->AdvancedSearch->toJson(), ","); // Field DTE_NAIS
		$filterList = Concat($filterList, $this->LIEU_NAIS->AdvancedSearch->toJson(), ","); // Field LIEU_NAIS
		$filterList = Concat($filterList, $this->NATION->AdvancedSearch->toJson(), ","); // Field NATION
		$filterList = Concat($filterList, $this->ADRESSE->AdvancedSearch->toJson(), ","); // Field ADRESSE
		$filterList = Concat($filterList, $this->VILLE->AdvancedSearch->toJson(), ","); // Field VILLE
		$filterList = Concat($filterList, $this->PAYS->AdvancedSearch->toJson(), ","); // Field PAYS
		$filterList = Concat($filterList, $this->BOX->AdvancedSearch->toJson(), ","); // Field BOX
		$filterList = Concat($filterList, $this->PHONE->AdvancedSearch->toJson(), ","); // Field PHONE
		$filterList = Concat($filterList, $this->REFERENCE->AdvancedSearch->toJson(), ","); // Field REFERENCE
		$filterList = Concat($filterList, $this->QUALIF->AdvancedSearch->toJson(), ","); // Field QUALIF
		$filterList = Concat($filterList, $this->URGENCE->AdvancedSearch->toJson(), ","); // Field URGENCE
		$filterList = Concat($filterList, $this->PHONE_URG->AdvancedSearch->toJson(), ","); // Field PHONE_URG
		$filterList = Concat($filterList, $this->DATE_EMP->AdvancedSearch->toJson(), ","); // Field DATE_EMP
		$filterList = Concat($filterList, $this->SERVICE->AdvancedSearch->toJson(), ","); // Field SERVICE
		$filterList = Concat($filterList, $this->DEPT->AdvancedSearch->toJson(), ","); // Field DEPT
		$filterList = Concat($filterList, $this->SECTION->AdvancedSearch->toJson(), ","); // Field SECTION
		$filterList = Concat($filterList, $this->CATEGORIE->AdvancedSearch->toJson(), ","); // Field CATEGORIE
		$filterList = Concat($filterList, $this->FONCTION->AdvancedSearch->toJson(), ","); // Field FONCTION
		$filterList = Concat($filterList, $this->STATUT->AdvancedSearch->toJson(), ","); // Field STATUT
		$filterList = Concat($filterList, $this->STA_DEBUT->AdvancedSearch->toJson(), ","); // Field STA_DEBUT
		$filterList = Concat($filterList, $this->STA_FIN->AdvancedSearch->toJson(), ","); // Field STA_FIN
		$filterList = Concat($filterList, $this->STA_MOTIF->AdvancedSearch->toJson(), ","); // Field STA_MOTIF
		$filterList = Concat($filterList, $this->NO_NIF->AdvancedSearch->toJson(), ","); // Field NO_NIF
		$filterList = Concat($filterList, $this->NO_ONA->AdvancedSearch->toJson(), ","); // Field NO_ONA
		$filterList = Concat($filterList, $this->LIV_TRAV->AdvancedSearch->toJson(), ","); // Field LIV_TRAV
		$filterList = Concat($filterList, $this->MT_SALAIRE->AdvancedSearch->toJson(), ","); // Field MT_SALAIRE
		$filterList = Concat($filterList, $this->MT_FRAIS->AdvancedSearch->toJson(), ","); // Field MT_FRAIS
		$filterList = Concat($filterList, $this->MT_AUTRES->AdvancedSearch->toJson(), ","); // Field MT_AUTRES
		$filterList = Concat($filterList, $this->MODE->AdvancedSearch->toJson(), ","); // Field MODE
		$filterList = Concat($filterList, $this->TYPE->AdvancedSearch->toJson(), ","); // Field TYPE
		$filterList = Concat($filterList, $this->MT_IMPOT->AdvancedSearch->toJson(), ","); // Field MT_IMPOT
		$filterList = Concat($filterList, $this->PER_IMPOT->AdvancedSearch->toJson(), ","); // Field PER_IMPOT
		$filterList = Concat($filterList, $this->PRET_ONA->AdvancedSearch->toJson(), ","); // Field PRET_ONA
		$filterList = Concat($filterList, $this->PER_ONA->AdvancedSearch->toJson(), ","); // Field PER_ONA
		$filterList = Concat($filterList, $this->RET_ASSUR->AdvancedSearch->toJson(), ","); // Field RET_ASSUR
		$filterList = Concat($filterList, $this->PER_ASSUR->AdvancedSearch->toJson(), ","); // Field PER_ASSUR
		$filterList = Concat($filterList, $this->PRET_SALAIRE->AdvancedSearch->toJson(), ","); // Field PRET_SALAIRE
		$filterList = Concat($filterList, $this->PER_SALAIRE->AdvancedSearch->toJson(), ","); // Field PER_SALAIRE
		$filterList = Concat($filterList, $this->RET_PENSION->AdvancedSearch->toJson(), ","); // Field RET_PENSION
		$filterList = Concat($filterList, $this->PER_RETPENSION->AdvancedSearch->toJson(), ","); // Field PER_RETPENSION
		$filterList = Concat($filterList, $this->PRET_BANQUE->AdvancedSearch->toJson(), ","); // Field PRET_BANQUE
		$filterList = Concat($filterList, $this->PER_BANQUE->AdvancedSearch->toJson(), ","); // Field PER_BANQUE
		$filterList = Concat($filterList, $this->RET_AVANC->AdvancedSearch->toJson(), ","); // Field RET_AVANC
		$filterList = Concat($filterList, $this->PER_AVANCE->AdvancedSearch->toJson(), ","); // Field PER_AVANCE
		$filterList = Concat($filterList, $this->PRET_PENSION->AdvancedSearch->toJson(), ","); // Field PRET_PENSION
		$filterList = Concat($filterList, $this->PER_PENSION->AdvancedSearch->toJson(), ","); // Field PER_PENSION
		$filterList = Concat($filterList, $this->RET_CAFET->AdvancedSearch->toJson(), ","); // Field RET_CAFET
		$filterList = Concat($filterList, $this->PER_CAFET->AdvancedSearch->toJson(), ","); // Field PER_CAFET
		$filterList = Concat($filterList, $this->RET_CITE->AdvancedSearch->toJson(), ","); // Field RET_CITE
		$filterList = Concat($filterList, $this->PER_CITE->AdvancedSearch->toJson(), ","); // Field PER_CITE
		$filterList = Concat($filterList, $this->RET_AUTRE->AdvancedSearch->toJson(), ","); // Field RET_AUTRE
		$filterList = Concat($filterList, $this->PER_AUTRE->AdvancedSearch->toJson(), ","); // Field PER_AUTRE
		$filterList = Concat($filterList, $this->ACQ_NB_CON->AdvancedSearch->toJson(), ","); // Field ACQ_NB_CON
		$filterList = Concat($filterList, $this->ACC_MT_BRUT->AdvancedSearch->toJson(), ","); // Field ACC_MT_BRUT
		$filterList = Concat($filterList, $this->ACC_NB_CON->AdvancedSearch->toJson(), ","); // Field ACC_NB_CON
		$filterList = Concat($filterList, $this->ACC_NB_PCON->AdvancedSearch->toJson(), ","); // Field ACC_NB_PCON
		$filterList = Concat($filterList, $this->ACC_MT_OVT->AdvancedSearch->toJson(), ","); // Field ACC_MT_OVT
		$filterList = Concat($filterList, $this->ACQ_NB_MAL->AdvancedSearch->toJson(), ","); // Field ACQ_NB_MAL
		$filterList = Concat($filterList, $this->ACC_NB_MAL->AdvancedSearch->toJson(), ","); // Field ACC_NB_MAL
		$filterList = Concat($filterList, $this->ACC_MT_CON->AdvancedSearch->toJson(), ","); // Field ACC_MT_CON
		$filterList = Concat($filterList, $this->ACC_NB_MAT->AdvancedSearch->toJson(), ","); // Field ACC_NB_MAT
		$filterList = Concat($filterList, $this->ACC_MT_BONI->AdvancedSearch->toJson(), ","); // Field ACC_MT_BONI
		$filterList = Concat($filterList, $this->ACC_NB_PER->AdvancedSearch->toJson(), ","); // Field ACC_NB_PER
		$filterList = Concat($filterList, $this->ACC_MT_AUT->AdvancedSearch->toJson(), ","); // Field ACC_MT_AUT
		$filterList = Concat($filterList, $this->ACC_NB_COM->AdvancedSearch->toJson(), ","); // Field ACC_NB_COM
		$filterList = Concat($filterList, $this->ACC_BAL_SAL->AdvancedSearch->toJson(), ","); // Field ACC_BAL_SAL
		$filterList = Concat($filterList, $this->ACC_BAL_BAN->AdvancedSearch->toJson(), ","); // Field ACC_BAL_BAN
		$filterList = Concat($filterList, $this->ACC_NB_SUS->AdvancedSearch->toJson(), ","); // Field ACC_NB_SUS
		$filterList = Concat($filterList, $this->ACC_BAL_ONA->AdvancedSearch->toJson(), ","); // Field ACC_BAL_ONA
		$filterList = Concat($filterList, $this->ACC_BAL_PENSION->AdvancedSearch->toJson(), ","); // Field ACC_BAL_PENSION
		$filterList = Concat($filterList, $this->ACC_NB_ABS->AdvancedSearch->toJson(), ","); // Field ACC_NB_ABS
		$filterList = Concat($filterList, $this->ACC_MT_QZ->AdvancedSearch->toJson(), ","); // Field ACC_MT_QZ
		$filterList = Concat($filterList, $this->ACC_NB_TRA->AdvancedSearch->toJson(), ","); // Field ACC_NB_TRA
		$filterList = Concat($filterList, $this->ACC_MT_AJST->AdvancedSearch->toJson(), ","); // Field ACC_MT_AJST
		$filterList = Concat($filterList, $this->ACC_NB_TRA_ACT->AdvancedSearch->toJson(), ","); // Field ACC_NB_TRA_ACT
		$filterList = Concat($filterList, $this->ACC1_MT_BRUT->AdvancedSearch->toJson(), ","); // Field ACC1_MT_BRUT
		$filterList = Concat($filterList, $this->ACC_RENDEMENT->AdvancedSearch->toJson(), ","); // Field ACC_RENDEMENT
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "ftabemp4listsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field RN
		$this->RN->AdvancedSearch->SearchValue = @$filter["x_RN"];
		$this->RN->AdvancedSearch->SearchOperator = @$filter["z_RN"];
		$this->RN->AdvancedSearch->SearchCondition = @$filter["v_RN"];
		$this->RN->AdvancedSearch->SearchValue2 = @$filter["y_RN"];
		$this->RN->AdvancedSearch->SearchOperator2 = @$filter["w_RN"];
		$this->RN->AdvancedSearch->save();

		// Field NO_EMP
		$this->NO_EMP->AdvancedSearch->SearchValue = @$filter["x_NO_EMP"];
		$this->NO_EMP->AdvancedSearch->SearchOperator = @$filter["z_NO_EMP"];
		$this->NO_EMP->AdvancedSearch->SearchCondition = @$filter["v_NO_EMP"];
		$this->NO_EMP->AdvancedSearch->SearchValue2 = @$filter["y_NO_EMP"];
		$this->NO_EMP->AdvancedSearch->SearchOperator2 = @$filter["w_NO_EMP"];
		$this->NO_EMP->AdvancedSearch->save();

		// Field NOM_EMP
		$this->NOM_EMP->AdvancedSearch->SearchValue = @$filter["x_NOM_EMP"];
		$this->NOM_EMP->AdvancedSearch->SearchOperator = @$filter["z_NOM_EMP"];
		$this->NOM_EMP->AdvancedSearch->SearchCondition = @$filter["v_NOM_EMP"];
		$this->NOM_EMP->AdvancedSearch->SearchValue2 = @$filter["y_NOM_EMP"];
		$this->NOM_EMP->AdvancedSearch->SearchOperator2 = @$filter["w_NOM_EMP"];
		$this->NOM_EMP->AdvancedSearch->save();

		// Field SEXE
		$this->SEXE->AdvancedSearch->SearchValue = @$filter["x_SEXE"];
		$this->SEXE->AdvancedSearch->SearchOperator = @$filter["z_SEXE"];
		$this->SEXE->AdvancedSearch->SearchCondition = @$filter["v_SEXE"];
		$this->SEXE->AdvancedSearch->SearchValue2 = @$filter["y_SEXE"];
		$this->SEXE->AdvancedSearch->SearchOperator2 = @$filter["w_SEXE"];
		$this->SEXE->AdvancedSearch->save();

		// Field ETAT_C
		$this->ETAT_C->AdvancedSearch->SearchValue = @$filter["x_ETAT_C"];
		$this->ETAT_C->AdvancedSearch->SearchOperator = @$filter["z_ETAT_C"];
		$this->ETAT_C->AdvancedSearch->SearchCondition = @$filter["v_ETAT_C"];
		$this->ETAT_C->AdvancedSearch->SearchValue2 = @$filter["y_ETAT_C"];
		$this->ETAT_C->AdvancedSearch->SearchOperator2 = @$filter["w_ETAT_C"];
		$this->ETAT_C->AdvancedSearch->save();

		// Field DEPEND
		$this->DEPEND->AdvancedSearch->SearchValue = @$filter["x_DEPEND"];
		$this->DEPEND->AdvancedSearch->SearchOperator = @$filter["z_DEPEND"];
		$this->DEPEND->AdvancedSearch->SearchCondition = @$filter["v_DEPEND"];
		$this->DEPEND->AdvancedSearch->SearchValue2 = @$filter["y_DEPEND"];
		$this->DEPEND->AdvancedSearch->SearchOperator2 = @$filter["w_DEPEND"];
		$this->DEPEND->AdvancedSearch->save();

		// Field DTE_NAIS
		$this->DTE_NAIS->AdvancedSearch->SearchValue = @$filter["x_DTE_NAIS"];
		$this->DTE_NAIS->AdvancedSearch->SearchOperator = @$filter["z_DTE_NAIS"];
		$this->DTE_NAIS->AdvancedSearch->SearchCondition = @$filter["v_DTE_NAIS"];
		$this->DTE_NAIS->AdvancedSearch->SearchValue2 = @$filter["y_DTE_NAIS"];
		$this->DTE_NAIS->AdvancedSearch->SearchOperator2 = @$filter["w_DTE_NAIS"];
		$this->DTE_NAIS->AdvancedSearch->save();

		// Field LIEU_NAIS
		$this->LIEU_NAIS->AdvancedSearch->SearchValue = @$filter["x_LIEU_NAIS"];
		$this->LIEU_NAIS->AdvancedSearch->SearchOperator = @$filter["z_LIEU_NAIS"];
		$this->LIEU_NAIS->AdvancedSearch->SearchCondition = @$filter["v_LIEU_NAIS"];
		$this->LIEU_NAIS->AdvancedSearch->SearchValue2 = @$filter["y_LIEU_NAIS"];
		$this->LIEU_NAIS->AdvancedSearch->SearchOperator2 = @$filter["w_LIEU_NAIS"];
		$this->LIEU_NAIS->AdvancedSearch->save();

		// Field NATION
		$this->NATION->AdvancedSearch->SearchValue = @$filter["x_NATION"];
		$this->NATION->AdvancedSearch->SearchOperator = @$filter["z_NATION"];
		$this->NATION->AdvancedSearch->SearchCondition = @$filter["v_NATION"];
		$this->NATION->AdvancedSearch->SearchValue2 = @$filter["y_NATION"];
		$this->NATION->AdvancedSearch->SearchOperator2 = @$filter["w_NATION"];
		$this->NATION->AdvancedSearch->save();

		// Field ADRESSE
		$this->ADRESSE->AdvancedSearch->SearchValue = @$filter["x_ADRESSE"];
		$this->ADRESSE->AdvancedSearch->SearchOperator = @$filter["z_ADRESSE"];
		$this->ADRESSE->AdvancedSearch->SearchCondition = @$filter["v_ADRESSE"];
		$this->ADRESSE->AdvancedSearch->SearchValue2 = @$filter["y_ADRESSE"];
		$this->ADRESSE->AdvancedSearch->SearchOperator2 = @$filter["w_ADRESSE"];
		$this->ADRESSE->AdvancedSearch->save();

		// Field VILLE
		$this->VILLE->AdvancedSearch->SearchValue = @$filter["x_VILLE"];
		$this->VILLE->AdvancedSearch->SearchOperator = @$filter["z_VILLE"];
		$this->VILLE->AdvancedSearch->SearchCondition = @$filter["v_VILLE"];
		$this->VILLE->AdvancedSearch->SearchValue2 = @$filter["y_VILLE"];
		$this->VILLE->AdvancedSearch->SearchOperator2 = @$filter["w_VILLE"];
		$this->VILLE->AdvancedSearch->save();

		// Field PAYS
		$this->PAYS->AdvancedSearch->SearchValue = @$filter["x_PAYS"];
		$this->PAYS->AdvancedSearch->SearchOperator = @$filter["z_PAYS"];
		$this->PAYS->AdvancedSearch->SearchCondition = @$filter["v_PAYS"];
		$this->PAYS->AdvancedSearch->SearchValue2 = @$filter["y_PAYS"];
		$this->PAYS->AdvancedSearch->SearchOperator2 = @$filter["w_PAYS"];
		$this->PAYS->AdvancedSearch->save();

		// Field BOX
		$this->BOX->AdvancedSearch->SearchValue = @$filter["x_BOX"];
		$this->BOX->AdvancedSearch->SearchOperator = @$filter["z_BOX"];
		$this->BOX->AdvancedSearch->SearchCondition = @$filter["v_BOX"];
		$this->BOX->AdvancedSearch->SearchValue2 = @$filter["y_BOX"];
		$this->BOX->AdvancedSearch->SearchOperator2 = @$filter["w_BOX"];
		$this->BOX->AdvancedSearch->save();

		// Field PHONE
		$this->PHONE->AdvancedSearch->SearchValue = @$filter["x_PHONE"];
		$this->PHONE->AdvancedSearch->SearchOperator = @$filter["z_PHONE"];
		$this->PHONE->AdvancedSearch->SearchCondition = @$filter["v_PHONE"];
		$this->PHONE->AdvancedSearch->SearchValue2 = @$filter["y_PHONE"];
		$this->PHONE->AdvancedSearch->SearchOperator2 = @$filter["w_PHONE"];
		$this->PHONE->AdvancedSearch->save();

		// Field REFERENCE
		$this->REFERENCE->AdvancedSearch->SearchValue = @$filter["x_REFERENCE"];
		$this->REFERENCE->AdvancedSearch->SearchOperator = @$filter["z_REFERENCE"];
		$this->REFERENCE->AdvancedSearch->SearchCondition = @$filter["v_REFERENCE"];
		$this->REFERENCE->AdvancedSearch->SearchValue2 = @$filter["y_REFERENCE"];
		$this->REFERENCE->AdvancedSearch->SearchOperator2 = @$filter["w_REFERENCE"];
		$this->REFERENCE->AdvancedSearch->save();

		// Field QUALIF
		$this->QUALIF->AdvancedSearch->SearchValue = @$filter["x_QUALIF"];
		$this->QUALIF->AdvancedSearch->SearchOperator = @$filter["z_QUALIF"];
		$this->QUALIF->AdvancedSearch->SearchCondition = @$filter["v_QUALIF"];
		$this->QUALIF->AdvancedSearch->SearchValue2 = @$filter["y_QUALIF"];
		$this->QUALIF->AdvancedSearch->SearchOperator2 = @$filter["w_QUALIF"];
		$this->QUALIF->AdvancedSearch->save();

		// Field URGENCE
		$this->URGENCE->AdvancedSearch->SearchValue = @$filter["x_URGENCE"];
		$this->URGENCE->AdvancedSearch->SearchOperator = @$filter["z_URGENCE"];
		$this->URGENCE->AdvancedSearch->SearchCondition = @$filter["v_URGENCE"];
		$this->URGENCE->AdvancedSearch->SearchValue2 = @$filter["y_URGENCE"];
		$this->URGENCE->AdvancedSearch->SearchOperator2 = @$filter["w_URGENCE"];
		$this->URGENCE->AdvancedSearch->save();

		// Field PHONE_URG
		$this->PHONE_URG->AdvancedSearch->SearchValue = @$filter["x_PHONE_URG"];
		$this->PHONE_URG->AdvancedSearch->SearchOperator = @$filter["z_PHONE_URG"];
		$this->PHONE_URG->AdvancedSearch->SearchCondition = @$filter["v_PHONE_URG"];
		$this->PHONE_URG->AdvancedSearch->SearchValue2 = @$filter["y_PHONE_URG"];
		$this->PHONE_URG->AdvancedSearch->SearchOperator2 = @$filter["w_PHONE_URG"];
		$this->PHONE_URG->AdvancedSearch->save();

		// Field DATE_EMP
		$this->DATE_EMP->AdvancedSearch->SearchValue = @$filter["x_DATE_EMP"];
		$this->DATE_EMP->AdvancedSearch->SearchOperator = @$filter["z_DATE_EMP"];
		$this->DATE_EMP->AdvancedSearch->SearchCondition = @$filter["v_DATE_EMP"];
		$this->DATE_EMP->AdvancedSearch->SearchValue2 = @$filter["y_DATE_EMP"];
		$this->DATE_EMP->AdvancedSearch->SearchOperator2 = @$filter["w_DATE_EMP"];
		$this->DATE_EMP->AdvancedSearch->save();

		// Field SERVICE
		$this->SERVICE->AdvancedSearch->SearchValue = @$filter["x_SERVICE"];
		$this->SERVICE->AdvancedSearch->SearchOperator = @$filter["z_SERVICE"];
		$this->SERVICE->AdvancedSearch->SearchCondition = @$filter["v_SERVICE"];
		$this->SERVICE->AdvancedSearch->SearchValue2 = @$filter["y_SERVICE"];
		$this->SERVICE->AdvancedSearch->SearchOperator2 = @$filter["w_SERVICE"];
		$this->SERVICE->AdvancedSearch->save();

		// Field DEPT
		$this->DEPT->AdvancedSearch->SearchValue = @$filter["x_DEPT"];
		$this->DEPT->AdvancedSearch->SearchOperator = @$filter["z_DEPT"];
		$this->DEPT->AdvancedSearch->SearchCondition = @$filter["v_DEPT"];
		$this->DEPT->AdvancedSearch->SearchValue2 = @$filter["y_DEPT"];
		$this->DEPT->AdvancedSearch->SearchOperator2 = @$filter["w_DEPT"];
		$this->DEPT->AdvancedSearch->save();

		// Field SECTION
		$this->SECTION->AdvancedSearch->SearchValue = @$filter["x_SECTION"];
		$this->SECTION->AdvancedSearch->SearchOperator = @$filter["z_SECTION"];
		$this->SECTION->AdvancedSearch->SearchCondition = @$filter["v_SECTION"];
		$this->SECTION->AdvancedSearch->SearchValue2 = @$filter["y_SECTION"];
		$this->SECTION->AdvancedSearch->SearchOperator2 = @$filter["w_SECTION"];
		$this->SECTION->AdvancedSearch->save();

		// Field CATEGORIE
		$this->CATEGORIE->AdvancedSearch->SearchValue = @$filter["x_CATEGORIE"];
		$this->CATEGORIE->AdvancedSearch->SearchOperator = @$filter["z_CATEGORIE"];
		$this->CATEGORIE->AdvancedSearch->SearchCondition = @$filter["v_CATEGORIE"];
		$this->CATEGORIE->AdvancedSearch->SearchValue2 = @$filter["y_CATEGORIE"];
		$this->CATEGORIE->AdvancedSearch->SearchOperator2 = @$filter["w_CATEGORIE"];
		$this->CATEGORIE->AdvancedSearch->save();

		// Field FONCTION
		$this->FONCTION->AdvancedSearch->SearchValue = @$filter["x_FONCTION"];
		$this->FONCTION->AdvancedSearch->SearchOperator = @$filter["z_FONCTION"];
		$this->FONCTION->AdvancedSearch->SearchCondition = @$filter["v_FONCTION"];
		$this->FONCTION->AdvancedSearch->SearchValue2 = @$filter["y_FONCTION"];
		$this->FONCTION->AdvancedSearch->SearchOperator2 = @$filter["w_FONCTION"];
		$this->FONCTION->AdvancedSearch->save();

		// Field STATUT
		$this->STATUT->AdvancedSearch->SearchValue = @$filter["x_STATUT"];
		$this->STATUT->AdvancedSearch->SearchOperator = @$filter["z_STATUT"];
		$this->STATUT->AdvancedSearch->SearchCondition = @$filter["v_STATUT"];
		$this->STATUT->AdvancedSearch->SearchValue2 = @$filter["y_STATUT"];
		$this->STATUT->AdvancedSearch->SearchOperator2 = @$filter["w_STATUT"];
		$this->STATUT->AdvancedSearch->save();

		// Field STA_DEBUT
		$this->STA_DEBUT->AdvancedSearch->SearchValue = @$filter["x_STA_DEBUT"];
		$this->STA_DEBUT->AdvancedSearch->SearchOperator = @$filter["z_STA_DEBUT"];
		$this->STA_DEBUT->AdvancedSearch->SearchCondition = @$filter["v_STA_DEBUT"];
		$this->STA_DEBUT->AdvancedSearch->SearchValue2 = @$filter["y_STA_DEBUT"];
		$this->STA_DEBUT->AdvancedSearch->SearchOperator2 = @$filter["w_STA_DEBUT"];
		$this->STA_DEBUT->AdvancedSearch->save();

		// Field STA_FIN
		$this->STA_FIN->AdvancedSearch->SearchValue = @$filter["x_STA_FIN"];
		$this->STA_FIN->AdvancedSearch->SearchOperator = @$filter["z_STA_FIN"];
		$this->STA_FIN->AdvancedSearch->SearchCondition = @$filter["v_STA_FIN"];
		$this->STA_FIN->AdvancedSearch->SearchValue2 = @$filter["y_STA_FIN"];
		$this->STA_FIN->AdvancedSearch->SearchOperator2 = @$filter["w_STA_FIN"];
		$this->STA_FIN->AdvancedSearch->save();

		// Field STA_MOTIF
		$this->STA_MOTIF->AdvancedSearch->SearchValue = @$filter["x_STA_MOTIF"];
		$this->STA_MOTIF->AdvancedSearch->SearchOperator = @$filter["z_STA_MOTIF"];
		$this->STA_MOTIF->AdvancedSearch->SearchCondition = @$filter["v_STA_MOTIF"];
		$this->STA_MOTIF->AdvancedSearch->SearchValue2 = @$filter["y_STA_MOTIF"];
		$this->STA_MOTIF->AdvancedSearch->SearchOperator2 = @$filter["w_STA_MOTIF"];
		$this->STA_MOTIF->AdvancedSearch->save();

		// Field NO_NIF
		$this->NO_NIF->AdvancedSearch->SearchValue = @$filter["x_NO_NIF"];
		$this->NO_NIF->AdvancedSearch->SearchOperator = @$filter["z_NO_NIF"];
		$this->NO_NIF->AdvancedSearch->SearchCondition = @$filter["v_NO_NIF"];
		$this->NO_NIF->AdvancedSearch->SearchValue2 = @$filter["y_NO_NIF"];
		$this->NO_NIF->AdvancedSearch->SearchOperator2 = @$filter["w_NO_NIF"];
		$this->NO_NIF->AdvancedSearch->save();

		// Field NO_ONA
		$this->NO_ONA->AdvancedSearch->SearchValue = @$filter["x_NO_ONA"];
		$this->NO_ONA->AdvancedSearch->SearchOperator = @$filter["z_NO_ONA"];
		$this->NO_ONA->AdvancedSearch->SearchCondition = @$filter["v_NO_ONA"];
		$this->NO_ONA->AdvancedSearch->SearchValue2 = @$filter["y_NO_ONA"];
		$this->NO_ONA->AdvancedSearch->SearchOperator2 = @$filter["w_NO_ONA"];
		$this->NO_ONA->AdvancedSearch->save();

		// Field LIV_TRAV
		$this->LIV_TRAV->AdvancedSearch->SearchValue = @$filter["x_LIV_TRAV"];
		$this->LIV_TRAV->AdvancedSearch->SearchOperator = @$filter["z_LIV_TRAV"];
		$this->LIV_TRAV->AdvancedSearch->SearchCondition = @$filter["v_LIV_TRAV"];
		$this->LIV_TRAV->AdvancedSearch->SearchValue2 = @$filter["y_LIV_TRAV"];
		$this->LIV_TRAV->AdvancedSearch->SearchOperator2 = @$filter["w_LIV_TRAV"];
		$this->LIV_TRAV->AdvancedSearch->save();

		// Field MT_SALAIRE
		$this->MT_SALAIRE->AdvancedSearch->SearchValue = @$filter["x_MT_SALAIRE"];
		$this->MT_SALAIRE->AdvancedSearch->SearchOperator = @$filter["z_MT_SALAIRE"];
		$this->MT_SALAIRE->AdvancedSearch->SearchCondition = @$filter["v_MT_SALAIRE"];
		$this->MT_SALAIRE->AdvancedSearch->SearchValue2 = @$filter["y_MT_SALAIRE"];
		$this->MT_SALAIRE->AdvancedSearch->SearchOperator2 = @$filter["w_MT_SALAIRE"];
		$this->MT_SALAIRE->AdvancedSearch->save();

		// Field MT_FRAIS
		$this->MT_FRAIS->AdvancedSearch->SearchValue = @$filter["x_MT_FRAIS"];
		$this->MT_FRAIS->AdvancedSearch->SearchOperator = @$filter["z_MT_FRAIS"];
		$this->MT_FRAIS->AdvancedSearch->SearchCondition = @$filter["v_MT_FRAIS"];
		$this->MT_FRAIS->AdvancedSearch->SearchValue2 = @$filter["y_MT_FRAIS"];
		$this->MT_FRAIS->AdvancedSearch->SearchOperator2 = @$filter["w_MT_FRAIS"];
		$this->MT_FRAIS->AdvancedSearch->save();

		// Field MT_AUTRES
		$this->MT_AUTRES->AdvancedSearch->SearchValue = @$filter["x_MT_AUTRES"];
		$this->MT_AUTRES->AdvancedSearch->SearchOperator = @$filter["z_MT_AUTRES"];
		$this->MT_AUTRES->AdvancedSearch->SearchCondition = @$filter["v_MT_AUTRES"];
		$this->MT_AUTRES->AdvancedSearch->SearchValue2 = @$filter["y_MT_AUTRES"];
		$this->MT_AUTRES->AdvancedSearch->SearchOperator2 = @$filter["w_MT_AUTRES"];
		$this->MT_AUTRES->AdvancedSearch->save();

		// Field MODE
		$this->MODE->AdvancedSearch->SearchValue = @$filter["x_MODE"];
		$this->MODE->AdvancedSearch->SearchOperator = @$filter["z_MODE"];
		$this->MODE->AdvancedSearch->SearchCondition = @$filter["v_MODE"];
		$this->MODE->AdvancedSearch->SearchValue2 = @$filter["y_MODE"];
		$this->MODE->AdvancedSearch->SearchOperator2 = @$filter["w_MODE"];
		$this->MODE->AdvancedSearch->save();

		// Field TYPE
		$this->TYPE->AdvancedSearch->SearchValue = @$filter["x_TYPE"];
		$this->TYPE->AdvancedSearch->SearchOperator = @$filter["z_TYPE"];
		$this->TYPE->AdvancedSearch->SearchCondition = @$filter["v_TYPE"];
		$this->TYPE->AdvancedSearch->SearchValue2 = @$filter["y_TYPE"];
		$this->TYPE->AdvancedSearch->SearchOperator2 = @$filter["w_TYPE"];
		$this->TYPE->AdvancedSearch->save();

		// Field MT_IMPOT
		$this->MT_IMPOT->AdvancedSearch->SearchValue = @$filter["x_MT_IMPOT"];
		$this->MT_IMPOT->AdvancedSearch->SearchOperator = @$filter["z_MT_IMPOT"];
		$this->MT_IMPOT->AdvancedSearch->SearchCondition = @$filter["v_MT_IMPOT"];
		$this->MT_IMPOT->AdvancedSearch->SearchValue2 = @$filter["y_MT_IMPOT"];
		$this->MT_IMPOT->AdvancedSearch->SearchOperator2 = @$filter["w_MT_IMPOT"];
		$this->MT_IMPOT->AdvancedSearch->save();

		// Field PER_IMPOT
		$this->PER_IMPOT->AdvancedSearch->SearchValue = @$filter["x_PER_IMPOT"];
		$this->PER_IMPOT->AdvancedSearch->SearchOperator = @$filter["z_PER_IMPOT"];
		$this->PER_IMPOT->AdvancedSearch->SearchCondition = @$filter["v_PER_IMPOT"];
		$this->PER_IMPOT->AdvancedSearch->SearchValue2 = @$filter["y_PER_IMPOT"];
		$this->PER_IMPOT->AdvancedSearch->SearchOperator2 = @$filter["w_PER_IMPOT"];
		$this->PER_IMPOT->AdvancedSearch->save();

		// Field PRET_ONA
		$this->PRET_ONA->AdvancedSearch->SearchValue = @$filter["x_PRET_ONA"];
		$this->PRET_ONA->AdvancedSearch->SearchOperator = @$filter["z_PRET_ONA"];
		$this->PRET_ONA->AdvancedSearch->SearchCondition = @$filter["v_PRET_ONA"];
		$this->PRET_ONA->AdvancedSearch->SearchValue2 = @$filter["y_PRET_ONA"];
		$this->PRET_ONA->AdvancedSearch->SearchOperator2 = @$filter["w_PRET_ONA"];
		$this->PRET_ONA->AdvancedSearch->save();

		// Field PER_ONA
		$this->PER_ONA->AdvancedSearch->SearchValue = @$filter["x_PER_ONA"];
		$this->PER_ONA->AdvancedSearch->SearchOperator = @$filter["z_PER_ONA"];
		$this->PER_ONA->AdvancedSearch->SearchCondition = @$filter["v_PER_ONA"];
		$this->PER_ONA->AdvancedSearch->SearchValue2 = @$filter["y_PER_ONA"];
		$this->PER_ONA->AdvancedSearch->SearchOperator2 = @$filter["w_PER_ONA"];
		$this->PER_ONA->AdvancedSearch->save();

		// Field RET_ASSUR
		$this->RET_ASSUR->AdvancedSearch->SearchValue = @$filter["x_RET_ASSUR"];
		$this->RET_ASSUR->AdvancedSearch->SearchOperator = @$filter["z_RET_ASSUR"];
		$this->RET_ASSUR->AdvancedSearch->SearchCondition = @$filter["v_RET_ASSUR"];
		$this->RET_ASSUR->AdvancedSearch->SearchValue2 = @$filter["y_RET_ASSUR"];
		$this->RET_ASSUR->AdvancedSearch->SearchOperator2 = @$filter["w_RET_ASSUR"];
		$this->RET_ASSUR->AdvancedSearch->save();

		// Field PER_ASSUR
		$this->PER_ASSUR->AdvancedSearch->SearchValue = @$filter["x_PER_ASSUR"];
		$this->PER_ASSUR->AdvancedSearch->SearchOperator = @$filter["z_PER_ASSUR"];
		$this->PER_ASSUR->AdvancedSearch->SearchCondition = @$filter["v_PER_ASSUR"];
		$this->PER_ASSUR->AdvancedSearch->SearchValue2 = @$filter["y_PER_ASSUR"];
		$this->PER_ASSUR->AdvancedSearch->SearchOperator2 = @$filter["w_PER_ASSUR"];
		$this->PER_ASSUR->AdvancedSearch->save();

		// Field PRET_SALAIRE
		$this->PRET_SALAIRE->AdvancedSearch->SearchValue = @$filter["x_PRET_SALAIRE"];
		$this->PRET_SALAIRE->AdvancedSearch->SearchOperator = @$filter["z_PRET_SALAIRE"];
		$this->PRET_SALAIRE->AdvancedSearch->SearchCondition = @$filter["v_PRET_SALAIRE"];
		$this->PRET_SALAIRE->AdvancedSearch->SearchValue2 = @$filter["y_PRET_SALAIRE"];
		$this->PRET_SALAIRE->AdvancedSearch->SearchOperator2 = @$filter["w_PRET_SALAIRE"];
		$this->PRET_SALAIRE->AdvancedSearch->save();

		// Field PER_SALAIRE
		$this->PER_SALAIRE->AdvancedSearch->SearchValue = @$filter["x_PER_SALAIRE"];
		$this->PER_SALAIRE->AdvancedSearch->SearchOperator = @$filter["z_PER_SALAIRE"];
		$this->PER_SALAIRE->AdvancedSearch->SearchCondition = @$filter["v_PER_SALAIRE"];
		$this->PER_SALAIRE->AdvancedSearch->SearchValue2 = @$filter["y_PER_SALAIRE"];
		$this->PER_SALAIRE->AdvancedSearch->SearchOperator2 = @$filter["w_PER_SALAIRE"];
		$this->PER_SALAIRE->AdvancedSearch->save();

		// Field RET_PENSION
		$this->RET_PENSION->AdvancedSearch->SearchValue = @$filter["x_RET_PENSION"];
		$this->RET_PENSION->AdvancedSearch->SearchOperator = @$filter["z_RET_PENSION"];
		$this->RET_PENSION->AdvancedSearch->SearchCondition = @$filter["v_RET_PENSION"];
		$this->RET_PENSION->AdvancedSearch->SearchValue2 = @$filter["y_RET_PENSION"];
		$this->RET_PENSION->AdvancedSearch->SearchOperator2 = @$filter["w_RET_PENSION"];
		$this->RET_PENSION->AdvancedSearch->save();

		// Field PER_RETPENSION
		$this->PER_RETPENSION->AdvancedSearch->SearchValue = @$filter["x_PER_RETPENSION"];
		$this->PER_RETPENSION->AdvancedSearch->SearchOperator = @$filter["z_PER_RETPENSION"];
		$this->PER_RETPENSION->AdvancedSearch->SearchCondition = @$filter["v_PER_RETPENSION"];
		$this->PER_RETPENSION->AdvancedSearch->SearchValue2 = @$filter["y_PER_RETPENSION"];
		$this->PER_RETPENSION->AdvancedSearch->SearchOperator2 = @$filter["w_PER_RETPENSION"];
		$this->PER_RETPENSION->AdvancedSearch->save();

		// Field PRET_BANQUE
		$this->PRET_BANQUE->AdvancedSearch->SearchValue = @$filter["x_PRET_BANQUE"];
		$this->PRET_BANQUE->AdvancedSearch->SearchOperator = @$filter["z_PRET_BANQUE"];
		$this->PRET_BANQUE->AdvancedSearch->SearchCondition = @$filter["v_PRET_BANQUE"];
		$this->PRET_BANQUE->AdvancedSearch->SearchValue2 = @$filter["y_PRET_BANQUE"];
		$this->PRET_BANQUE->AdvancedSearch->SearchOperator2 = @$filter["w_PRET_BANQUE"];
		$this->PRET_BANQUE->AdvancedSearch->save();

		// Field PER_BANQUE
		$this->PER_BANQUE->AdvancedSearch->SearchValue = @$filter["x_PER_BANQUE"];
		$this->PER_BANQUE->AdvancedSearch->SearchOperator = @$filter["z_PER_BANQUE"];
		$this->PER_BANQUE->AdvancedSearch->SearchCondition = @$filter["v_PER_BANQUE"];
		$this->PER_BANQUE->AdvancedSearch->SearchValue2 = @$filter["y_PER_BANQUE"];
		$this->PER_BANQUE->AdvancedSearch->SearchOperator2 = @$filter["w_PER_BANQUE"];
		$this->PER_BANQUE->AdvancedSearch->save();

		// Field RET_AVANC
		$this->RET_AVANC->AdvancedSearch->SearchValue = @$filter["x_RET_AVANC"];
		$this->RET_AVANC->AdvancedSearch->SearchOperator = @$filter["z_RET_AVANC"];
		$this->RET_AVANC->AdvancedSearch->SearchCondition = @$filter["v_RET_AVANC"];
		$this->RET_AVANC->AdvancedSearch->SearchValue2 = @$filter["y_RET_AVANC"];
		$this->RET_AVANC->AdvancedSearch->SearchOperator2 = @$filter["w_RET_AVANC"];
		$this->RET_AVANC->AdvancedSearch->save();

		// Field PER_AVANCE
		$this->PER_AVANCE->AdvancedSearch->SearchValue = @$filter["x_PER_AVANCE"];
		$this->PER_AVANCE->AdvancedSearch->SearchOperator = @$filter["z_PER_AVANCE"];
		$this->PER_AVANCE->AdvancedSearch->SearchCondition = @$filter["v_PER_AVANCE"];
		$this->PER_AVANCE->AdvancedSearch->SearchValue2 = @$filter["y_PER_AVANCE"];
		$this->PER_AVANCE->AdvancedSearch->SearchOperator2 = @$filter["w_PER_AVANCE"];
		$this->PER_AVANCE->AdvancedSearch->save();

		// Field PRET_PENSION
		$this->PRET_PENSION->AdvancedSearch->SearchValue = @$filter["x_PRET_PENSION"];
		$this->PRET_PENSION->AdvancedSearch->SearchOperator = @$filter["z_PRET_PENSION"];
		$this->PRET_PENSION->AdvancedSearch->SearchCondition = @$filter["v_PRET_PENSION"];
		$this->PRET_PENSION->AdvancedSearch->SearchValue2 = @$filter["y_PRET_PENSION"];
		$this->PRET_PENSION->AdvancedSearch->SearchOperator2 = @$filter["w_PRET_PENSION"];
		$this->PRET_PENSION->AdvancedSearch->save();

		// Field PER_PENSION
		$this->PER_PENSION->AdvancedSearch->SearchValue = @$filter["x_PER_PENSION"];
		$this->PER_PENSION->AdvancedSearch->SearchOperator = @$filter["z_PER_PENSION"];
		$this->PER_PENSION->AdvancedSearch->SearchCondition = @$filter["v_PER_PENSION"];
		$this->PER_PENSION->AdvancedSearch->SearchValue2 = @$filter["y_PER_PENSION"];
		$this->PER_PENSION->AdvancedSearch->SearchOperator2 = @$filter["w_PER_PENSION"];
		$this->PER_PENSION->AdvancedSearch->save();

		// Field RET_CAFET
		$this->RET_CAFET->AdvancedSearch->SearchValue = @$filter["x_RET_CAFET"];
		$this->RET_CAFET->AdvancedSearch->SearchOperator = @$filter["z_RET_CAFET"];
		$this->RET_CAFET->AdvancedSearch->SearchCondition = @$filter["v_RET_CAFET"];
		$this->RET_CAFET->AdvancedSearch->SearchValue2 = @$filter["y_RET_CAFET"];
		$this->RET_CAFET->AdvancedSearch->SearchOperator2 = @$filter["w_RET_CAFET"];
		$this->RET_CAFET->AdvancedSearch->save();

		// Field PER_CAFET
		$this->PER_CAFET->AdvancedSearch->SearchValue = @$filter["x_PER_CAFET"];
		$this->PER_CAFET->AdvancedSearch->SearchOperator = @$filter["z_PER_CAFET"];
		$this->PER_CAFET->AdvancedSearch->SearchCondition = @$filter["v_PER_CAFET"];
		$this->PER_CAFET->AdvancedSearch->SearchValue2 = @$filter["y_PER_CAFET"];
		$this->PER_CAFET->AdvancedSearch->SearchOperator2 = @$filter["w_PER_CAFET"];
		$this->PER_CAFET->AdvancedSearch->save();

		// Field RET_CITE
		$this->RET_CITE->AdvancedSearch->SearchValue = @$filter["x_RET_CITE"];
		$this->RET_CITE->AdvancedSearch->SearchOperator = @$filter["z_RET_CITE"];
		$this->RET_CITE->AdvancedSearch->SearchCondition = @$filter["v_RET_CITE"];
		$this->RET_CITE->AdvancedSearch->SearchValue2 = @$filter["y_RET_CITE"];
		$this->RET_CITE->AdvancedSearch->SearchOperator2 = @$filter["w_RET_CITE"];
		$this->RET_CITE->AdvancedSearch->save();

		// Field PER_CITE
		$this->PER_CITE->AdvancedSearch->SearchValue = @$filter["x_PER_CITE"];
		$this->PER_CITE->AdvancedSearch->SearchOperator = @$filter["z_PER_CITE"];
		$this->PER_CITE->AdvancedSearch->SearchCondition = @$filter["v_PER_CITE"];
		$this->PER_CITE->AdvancedSearch->SearchValue2 = @$filter["y_PER_CITE"];
		$this->PER_CITE->AdvancedSearch->SearchOperator2 = @$filter["w_PER_CITE"];
		$this->PER_CITE->AdvancedSearch->save();

		// Field RET_AUTRE
		$this->RET_AUTRE->AdvancedSearch->SearchValue = @$filter["x_RET_AUTRE"];
		$this->RET_AUTRE->AdvancedSearch->SearchOperator = @$filter["z_RET_AUTRE"];
		$this->RET_AUTRE->AdvancedSearch->SearchCondition = @$filter["v_RET_AUTRE"];
		$this->RET_AUTRE->AdvancedSearch->SearchValue2 = @$filter["y_RET_AUTRE"];
		$this->RET_AUTRE->AdvancedSearch->SearchOperator2 = @$filter["w_RET_AUTRE"];
		$this->RET_AUTRE->AdvancedSearch->save();

		// Field PER_AUTRE
		$this->PER_AUTRE->AdvancedSearch->SearchValue = @$filter["x_PER_AUTRE"];
		$this->PER_AUTRE->AdvancedSearch->SearchOperator = @$filter["z_PER_AUTRE"];
		$this->PER_AUTRE->AdvancedSearch->SearchCondition = @$filter["v_PER_AUTRE"];
		$this->PER_AUTRE->AdvancedSearch->SearchValue2 = @$filter["y_PER_AUTRE"];
		$this->PER_AUTRE->AdvancedSearch->SearchOperator2 = @$filter["w_PER_AUTRE"];
		$this->PER_AUTRE->AdvancedSearch->save();

		// Field ACQ_NB_CON
		$this->ACQ_NB_CON->AdvancedSearch->SearchValue = @$filter["x_ACQ_NB_CON"];
		$this->ACQ_NB_CON->AdvancedSearch->SearchOperator = @$filter["z_ACQ_NB_CON"];
		$this->ACQ_NB_CON->AdvancedSearch->SearchCondition = @$filter["v_ACQ_NB_CON"];
		$this->ACQ_NB_CON->AdvancedSearch->SearchValue2 = @$filter["y_ACQ_NB_CON"];
		$this->ACQ_NB_CON->AdvancedSearch->SearchOperator2 = @$filter["w_ACQ_NB_CON"];
		$this->ACQ_NB_CON->AdvancedSearch->save();

		// Field ACC_MT_BRUT
		$this->ACC_MT_BRUT->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_BRUT"];
		$this->ACC_MT_BRUT->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_BRUT"];
		$this->ACC_MT_BRUT->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_BRUT"];
		$this->ACC_MT_BRUT->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_BRUT"];
		$this->ACC_MT_BRUT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_BRUT"];
		$this->ACC_MT_BRUT->AdvancedSearch->save();

		// Field ACC_NB_CON
		$this->ACC_NB_CON->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_CON"];
		$this->ACC_NB_CON->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_CON"];
		$this->ACC_NB_CON->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_CON"];
		$this->ACC_NB_CON->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_CON"];
		$this->ACC_NB_CON->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_CON"];
		$this->ACC_NB_CON->AdvancedSearch->save();

		// Field ACC_NB_PCON
		$this->ACC_NB_PCON->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_PCON"];
		$this->ACC_NB_PCON->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_PCON"];
		$this->ACC_NB_PCON->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_PCON"];
		$this->ACC_NB_PCON->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_PCON"];
		$this->ACC_NB_PCON->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_PCON"];
		$this->ACC_NB_PCON->AdvancedSearch->save();

		// Field ACC_MT_OVT
		$this->ACC_MT_OVT->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_OVT"];
		$this->ACC_MT_OVT->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_OVT"];
		$this->ACC_MT_OVT->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_OVT"];
		$this->ACC_MT_OVT->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_OVT"];
		$this->ACC_MT_OVT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_OVT"];
		$this->ACC_MT_OVT->AdvancedSearch->save();

		// Field ACQ_NB_MAL
		$this->ACQ_NB_MAL->AdvancedSearch->SearchValue = @$filter["x_ACQ_NB_MAL"];
		$this->ACQ_NB_MAL->AdvancedSearch->SearchOperator = @$filter["z_ACQ_NB_MAL"];
		$this->ACQ_NB_MAL->AdvancedSearch->SearchCondition = @$filter["v_ACQ_NB_MAL"];
		$this->ACQ_NB_MAL->AdvancedSearch->SearchValue2 = @$filter["y_ACQ_NB_MAL"];
		$this->ACQ_NB_MAL->AdvancedSearch->SearchOperator2 = @$filter["w_ACQ_NB_MAL"];
		$this->ACQ_NB_MAL->AdvancedSearch->save();

		// Field ACC_NB_MAL
		$this->ACC_NB_MAL->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_MAL"];
		$this->ACC_NB_MAL->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_MAL"];
		$this->ACC_NB_MAL->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_MAL"];
		$this->ACC_NB_MAL->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_MAL"];
		$this->ACC_NB_MAL->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_MAL"];
		$this->ACC_NB_MAL->AdvancedSearch->save();

		// Field ACC_MT_CON
		$this->ACC_MT_CON->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_CON"];
		$this->ACC_MT_CON->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_CON"];
		$this->ACC_MT_CON->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_CON"];
		$this->ACC_MT_CON->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_CON"];
		$this->ACC_MT_CON->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_CON"];
		$this->ACC_MT_CON->AdvancedSearch->save();

		// Field ACC_NB_MAT
		$this->ACC_NB_MAT->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_MAT"];
		$this->ACC_NB_MAT->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_MAT"];
		$this->ACC_NB_MAT->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_MAT"];
		$this->ACC_NB_MAT->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_MAT"];
		$this->ACC_NB_MAT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_MAT"];
		$this->ACC_NB_MAT->AdvancedSearch->save();

		// Field ACC_MT_BONI
		$this->ACC_MT_BONI->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_BONI"];
		$this->ACC_MT_BONI->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_BONI"];
		$this->ACC_MT_BONI->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_BONI"];
		$this->ACC_MT_BONI->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_BONI"];
		$this->ACC_MT_BONI->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_BONI"];
		$this->ACC_MT_BONI->AdvancedSearch->save();

		// Field ACC_NB_PER
		$this->ACC_NB_PER->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_PER"];
		$this->ACC_NB_PER->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_PER"];
		$this->ACC_NB_PER->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_PER"];
		$this->ACC_NB_PER->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_PER"];
		$this->ACC_NB_PER->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_PER"];
		$this->ACC_NB_PER->AdvancedSearch->save();

		// Field ACC_MT_AUT
		$this->ACC_MT_AUT->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_AUT"];
		$this->ACC_MT_AUT->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_AUT"];
		$this->ACC_MT_AUT->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_AUT"];
		$this->ACC_MT_AUT->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_AUT"];
		$this->ACC_MT_AUT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_AUT"];
		$this->ACC_MT_AUT->AdvancedSearch->save();

		// Field ACC_NB_COM
		$this->ACC_NB_COM->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_COM"];
		$this->ACC_NB_COM->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_COM"];
		$this->ACC_NB_COM->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_COM"];
		$this->ACC_NB_COM->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_COM"];
		$this->ACC_NB_COM->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_COM"];
		$this->ACC_NB_COM->AdvancedSearch->save();

		// Field ACC_BAL_SAL
		$this->ACC_BAL_SAL->AdvancedSearch->SearchValue = @$filter["x_ACC_BAL_SAL"];
		$this->ACC_BAL_SAL->AdvancedSearch->SearchOperator = @$filter["z_ACC_BAL_SAL"];
		$this->ACC_BAL_SAL->AdvancedSearch->SearchCondition = @$filter["v_ACC_BAL_SAL"];
		$this->ACC_BAL_SAL->AdvancedSearch->SearchValue2 = @$filter["y_ACC_BAL_SAL"];
		$this->ACC_BAL_SAL->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_BAL_SAL"];
		$this->ACC_BAL_SAL->AdvancedSearch->save();

		// Field ACC_BAL_BAN
		$this->ACC_BAL_BAN->AdvancedSearch->SearchValue = @$filter["x_ACC_BAL_BAN"];
		$this->ACC_BAL_BAN->AdvancedSearch->SearchOperator = @$filter["z_ACC_BAL_BAN"];
		$this->ACC_BAL_BAN->AdvancedSearch->SearchCondition = @$filter["v_ACC_BAL_BAN"];
		$this->ACC_BAL_BAN->AdvancedSearch->SearchValue2 = @$filter["y_ACC_BAL_BAN"];
		$this->ACC_BAL_BAN->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_BAL_BAN"];
		$this->ACC_BAL_BAN->AdvancedSearch->save();

		// Field ACC_NB_SUS
		$this->ACC_NB_SUS->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_SUS"];
		$this->ACC_NB_SUS->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_SUS"];
		$this->ACC_NB_SUS->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_SUS"];
		$this->ACC_NB_SUS->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_SUS"];
		$this->ACC_NB_SUS->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_SUS"];
		$this->ACC_NB_SUS->AdvancedSearch->save();

		// Field ACC_BAL_ONA
		$this->ACC_BAL_ONA->AdvancedSearch->SearchValue = @$filter["x_ACC_BAL_ONA"];
		$this->ACC_BAL_ONA->AdvancedSearch->SearchOperator = @$filter["z_ACC_BAL_ONA"];
		$this->ACC_BAL_ONA->AdvancedSearch->SearchCondition = @$filter["v_ACC_BAL_ONA"];
		$this->ACC_BAL_ONA->AdvancedSearch->SearchValue2 = @$filter["y_ACC_BAL_ONA"];
		$this->ACC_BAL_ONA->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_BAL_ONA"];
		$this->ACC_BAL_ONA->AdvancedSearch->save();

		// Field ACC_BAL_PENSION
		$this->ACC_BAL_PENSION->AdvancedSearch->SearchValue = @$filter["x_ACC_BAL_PENSION"];
		$this->ACC_BAL_PENSION->AdvancedSearch->SearchOperator = @$filter["z_ACC_BAL_PENSION"];
		$this->ACC_BAL_PENSION->AdvancedSearch->SearchCondition = @$filter["v_ACC_BAL_PENSION"];
		$this->ACC_BAL_PENSION->AdvancedSearch->SearchValue2 = @$filter["y_ACC_BAL_PENSION"];
		$this->ACC_BAL_PENSION->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_BAL_PENSION"];
		$this->ACC_BAL_PENSION->AdvancedSearch->save();

		// Field ACC_NB_ABS
		$this->ACC_NB_ABS->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_ABS"];
		$this->ACC_NB_ABS->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_ABS"];
		$this->ACC_NB_ABS->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_ABS"];
		$this->ACC_NB_ABS->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_ABS"];
		$this->ACC_NB_ABS->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_ABS"];
		$this->ACC_NB_ABS->AdvancedSearch->save();

		// Field ACC_MT_QZ
		$this->ACC_MT_QZ->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_QZ"];
		$this->ACC_MT_QZ->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_QZ"];
		$this->ACC_MT_QZ->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_QZ"];
		$this->ACC_MT_QZ->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_QZ"];
		$this->ACC_MT_QZ->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_QZ"];
		$this->ACC_MT_QZ->AdvancedSearch->save();

		// Field ACC_NB_TRA
		$this->ACC_NB_TRA->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_TRA"];
		$this->ACC_NB_TRA->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_TRA"];
		$this->ACC_NB_TRA->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_TRA"];
		$this->ACC_NB_TRA->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_TRA"];
		$this->ACC_NB_TRA->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_TRA"];
		$this->ACC_NB_TRA->AdvancedSearch->save();

		// Field ACC_MT_AJST
		$this->ACC_MT_AJST->AdvancedSearch->SearchValue = @$filter["x_ACC_MT_AJST"];
		$this->ACC_MT_AJST->AdvancedSearch->SearchOperator = @$filter["z_ACC_MT_AJST"];
		$this->ACC_MT_AJST->AdvancedSearch->SearchCondition = @$filter["v_ACC_MT_AJST"];
		$this->ACC_MT_AJST->AdvancedSearch->SearchValue2 = @$filter["y_ACC_MT_AJST"];
		$this->ACC_MT_AJST->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_MT_AJST"];
		$this->ACC_MT_AJST->AdvancedSearch->save();

		// Field ACC_NB_TRA_ACT
		$this->ACC_NB_TRA_ACT->AdvancedSearch->SearchValue = @$filter["x_ACC_NB_TRA_ACT"];
		$this->ACC_NB_TRA_ACT->AdvancedSearch->SearchOperator = @$filter["z_ACC_NB_TRA_ACT"];
		$this->ACC_NB_TRA_ACT->AdvancedSearch->SearchCondition = @$filter["v_ACC_NB_TRA_ACT"];
		$this->ACC_NB_TRA_ACT->AdvancedSearch->SearchValue2 = @$filter["y_ACC_NB_TRA_ACT"];
		$this->ACC_NB_TRA_ACT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_NB_TRA_ACT"];
		$this->ACC_NB_TRA_ACT->AdvancedSearch->save();

		// Field ACC1_MT_BRUT
		$this->ACC1_MT_BRUT->AdvancedSearch->SearchValue = @$filter["x_ACC1_MT_BRUT"];
		$this->ACC1_MT_BRUT->AdvancedSearch->SearchOperator = @$filter["z_ACC1_MT_BRUT"];
		$this->ACC1_MT_BRUT->AdvancedSearch->SearchCondition = @$filter["v_ACC1_MT_BRUT"];
		$this->ACC1_MT_BRUT->AdvancedSearch->SearchValue2 = @$filter["y_ACC1_MT_BRUT"];
		$this->ACC1_MT_BRUT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC1_MT_BRUT"];
		$this->ACC1_MT_BRUT->AdvancedSearch->save();

		// Field ACC_RENDEMENT
		$this->ACC_RENDEMENT->AdvancedSearch->SearchValue = @$filter["x_ACC_RENDEMENT"];
		$this->ACC_RENDEMENT->AdvancedSearch->SearchOperator = @$filter["z_ACC_RENDEMENT"];
		$this->ACC_RENDEMENT->AdvancedSearch->SearchCondition = @$filter["v_ACC_RENDEMENT"];
		$this->ACC_RENDEMENT->AdvancedSearch->SearchValue2 = @$filter["y_ACC_RENDEMENT"];
		$this->ACC_RENDEMENT->AdvancedSearch->SearchOperator2 = @$filter["w_ACC_RENDEMENT"];
		$this->ACC_RENDEMENT->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->NOM_EMP, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SEXE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ETAT_C, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->LIEU_NAIS, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NATION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ADRESSE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->VILLE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PAYS, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->BOX, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PHONE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->REFERENCE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->QUALIF, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->URGENCE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PHONE_URG, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SERVICE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->SECTION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->CATEGORIE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->FONCTION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->STATUT, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->STA_MOTIF, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NO_ONA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->LIV_TRAV, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->MODE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TYPE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_IMPOT, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_ONA, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_ASSUR, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_RETPENSION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_AVANCE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_PENSION, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_CAFET, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_CITE, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PER_AUTRE, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id); // id
			$this->updateSort($this->RN); // RN
			$this->updateSort($this->NO_EMP); // NO_EMP
			$this->updateSort($this->NOM_EMP); // NOM_EMP
			$this->updateSort($this->SEXE); // SEXE
			$this->updateSort($this->ETAT_C); // ETAT_C
			$this->updateSort($this->DEPEND); // DEPEND
			$this->updateSort($this->DTE_NAIS); // DTE_NAIS
			$this->updateSort($this->LIEU_NAIS); // LIEU_NAIS
			$this->updateSort($this->NATION); // NATION
			$this->updateSort($this->ADRESSE); // ADRESSE
			$this->updateSort($this->VILLE); // VILLE
			$this->updateSort($this->PAYS); // PAYS
			$this->updateSort($this->BOX); // BOX
			$this->updateSort($this->PHONE); // PHONE
			$this->updateSort($this->REFERENCE); // REFERENCE
			$this->updateSort($this->QUALIF); // QUALIF
			$this->updateSort($this->URGENCE); // URGENCE
			$this->updateSort($this->PHONE_URG); // PHONE_URG
			$this->updateSort($this->DATE_EMP); // DATE_EMP
			$this->updateSort($this->SERVICE); // SERVICE
			$this->updateSort($this->DEPT); // DEPT
			$this->updateSort($this->SECTION); // SECTION
			$this->updateSort($this->CATEGORIE); // CATEGORIE
			$this->updateSort($this->FONCTION); // FONCTION
			$this->updateSort($this->STATUT); // STATUT
			$this->updateSort($this->STA_DEBUT); // STA_DEBUT
			$this->updateSort($this->STA_FIN); // STA_FIN
			$this->updateSort($this->STA_MOTIF); // STA_MOTIF
			$this->updateSort($this->NO_NIF); // NO_NIF
			$this->updateSort($this->NO_ONA); // NO_ONA
			$this->updateSort($this->LIV_TRAV); // LIV_TRAV
			$this->updateSort($this->MT_SALAIRE); // MT_SALAIRE
			$this->updateSort($this->MT_FRAIS); // MT_FRAIS
			$this->updateSort($this->MT_AUTRES); // MT_AUTRES
			$this->updateSort($this->MODE); // MODE
			$this->updateSort($this->TYPE); // TYPE
			$this->updateSort($this->MT_IMPOT); // MT_IMPOT
			$this->updateSort($this->PER_IMPOT); // PER_IMPOT
			$this->updateSort($this->PRET_ONA); // PRET_ONA
			$this->updateSort($this->PER_ONA); // PER_ONA
			$this->updateSort($this->RET_ASSUR); // RET_ASSUR
			$this->updateSort($this->PER_ASSUR); // PER_ASSUR
			$this->updateSort($this->PRET_SALAIRE); // PRET_SALAIRE
			$this->updateSort($this->PER_SALAIRE); // PER_SALAIRE
			$this->updateSort($this->RET_PENSION); // RET_PENSION
			$this->updateSort($this->PER_RETPENSION); // PER_RETPENSION
			$this->updateSort($this->PRET_BANQUE); // PRET_BANQUE
			$this->updateSort($this->PER_BANQUE); // PER_BANQUE
			$this->updateSort($this->RET_AVANC); // RET_AVANC
			$this->updateSort($this->PER_AVANCE); // PER_AVANCE
			$this->updateSort($this->PRET_PENSION); // PRET_PENSION
			$this->updateSort($this->PER_PENSION); // PER_PENSION
			$this->updateSort($this->RET_CAFET); // RET_CAFET
			$this->updateSort($this->PER_CAFET); // PER_CAFET
			$this->updateSort($this->RET_CITE); // RET_CITE
			$this->updateSort($this->PER_CITE); // PER_CITE
			$this->updateSort($this->RET_AUTRE); // RET_AUTRE
			$this->updateSort($this->PER_AUTRE); // PER_AUTRE
			$this->updateSort($this->ACQ_NB_CON); // ACQ_NB_CON
			$this->updateSort($this->ACC_MT_BRUT); // ACC_MT_BRUT
			$this->updateSort($this->ACC_NB_CON); // ACC_NB_CON
			$this->updateSort($this->ACC_NB_PCON); // ACC_NB_PCON
			$this->updateSort($this->ACC_MT_OVT); // ACC_MT_OVT
			$this->updateSort($this->ACQ_NB_MAL); // ACQ_NB_MAL
			$this->updateSort($this->ACC_NB_MAL); // ACC_NB_MAL
			$this->updateSort($this->ACC_MT_CON); // ACC_MT_CON
			$this->updateSort($this->ACC_NB_MAT); // ACC_NB_MAT
			$this->updateSort($this->ACC_MT_BONI); // ACC_MT_BONI
			$this->updateSort($this->ACC_NB_PER); // ACC_NB_PER
			$this->updateSort($this->ACC_MT_AUT); // ACC_MT_AUT
			$this->updateSort($this->ACC_NB_COM); // ACC_NB_COM
			$this->updateSort($this->ACC_BAL_SAL); // ACC_BAL_SAL
			$this->updateSort($this->ACC_BAL_BAN); // ACC_BAL_BAN
			$this->updateSort($this->ACC_NB_SUS); // ACC_NB_SUS
			$this->updateSort($this->ACC_BAL_ONA); // ACC_BAL_ONA
			$this->updateSort($this->ACC_BAL_PENSION); // ACC_BAL_PENSION
			$this->updateSort($this->ACC_NB_ABS); // ACC_NB_ABS
			$this->updateSort($this->ACC_MT_QZ); // ACC_MT_QZ
			$this->updateSort($this->ACC_NB_TRA); // ACC_NB_TRA
			$this->updateSort($this->ACC_MT_AJST); // ACC_MT_AJST
			$this->updateSort($this->ACC_NB_TRA_ACT); // ACC_NB_TRA_ACT
			$this->updateSort($this->ACC1_MT_BRUT); // ACC1_MT_BRUT
			$this->updateSort($this->ACC_RENDEMENT); // ACC_RENDEMENT
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->RN->setSort("");
				$this->NO_EMP->setSort("");
				$this->NOM_EMP->setSort("");
				$this->SEXE->setSort("");
				$this->ETAT_C->setSort("");
				$this->DEPEND->setSort("");
				$this->DTE_NAIS->setSort("");
				$this->LIEU_NAIS->setSort("");
				$this->NATION->setSort("");
				$this->ADRESSE->setSort("");
				$this->VILLE->setSort("");
				$this->PAYS->setSort("");
				$this->BOX->setSort("");
				$this->PHONE->setSort("");
				$this->REFERENCE->setSort("");
				$this->QUALIF->setSort("");
				$this->URGENCE->setSort("");
				$this->PHONE_URG->setSort("");
				$this->DATE_EMP->setSort("");
				$this->SERVICE->setSort("");
				$this->DEPT->setSort("");
				$this->SECTION->setSort("");
				$this->CATEGORIE->setSort("");
				$this->FONCTION->setSort("");
				$this->STATUT->setSort("");
				$this->STA_DEBUT->setSort("");
				$this->STA_FIN->setSort("");
				$this->STA_MOTIF->setSort("");
				$this->NO_NIF->setSort("");
				$this->NO_ONA->setSort("");
				$this->LIV_TRAV->setSort("");
				$this->MT_SALAIRE->setSort("");
				$this->MT_FRAIS->setSort("");
				$this->MT_AUTRES->setSort("");
				$this->MODE->setSort("");
				$this->TYPE->setSort("");
				$this->MT_IMPOT->setSort("");
				$this->PER_IMPOT->setSort("");
				$this->PRET_ONA->setSort("");
				$this->PER_ONA->setSort("");
				$this->RET_ASSUR->setSort("");
				$this->PER_ASSUR->setSort("");
				$this->PRET_SALAIRE->setSort("");
				$this->PER_SALAIRE->setSort("");
				$this->RET_PENSION->setSort("");
				$this->PER_RETPENSION->setSort("");
				$this->PRET_BANQUE->setSort("");
				$this->PER_BANQUE->setSort("");
				$this->RET_AVANC->setSort("");
				$this->PER_AVANCE->setSort("");
				$this->PRET_PENSION->setSort("");
				$this->PER_PENSION->setSort("");
				$this->RET_CAFET->setSort("");
				$this->PER_CAFET->setSort("");
				$this->RET_CITE->setSort("");
				$this->PER_CITE->setSort("");
				$this->RET_AUTRE->setSort("");
				$this->PER_AUTRE->setSort("");
				$this->ACQ_NB_CON->setSort("");
				$this->ACC_MT_BRUT->setSort("");
				$this->ACC_NB_CON->setSort("");
				$this->ACC_NB_PCON->setSort("");
				$this->ACC_MT_OVT->setSort("");
				$this->ACQ_NB_MAL->setSort("");
				$this->ACC_NB_MAL->setSort("");
				$this->ACC_MT_CON->setSort("");
				$this->ACC_NB_MAT->setSort("");
				$this->ACC_MT_BONI->setSort("");
				$this->ACC_NB_PER->setSort("");
				$this->ACC_MT_AUT->setSort("");
				$this->ACC_NB_COM->setSort("");
				$this->ACC_BAL_SAL->setSort("");
				$this->ACC_BAL_BAN->setSort("");
				$this->ACC_NB_SUS->setSort("");
				$this->ACC_BAL_ONA->setSort("");
				$this->ACC_BAL_PENSION->setSort("");
				$this->ACC_NB_ABS->setSort("");
				$this->ACC_MT_QZ->setSort("");
				$this->ACC_NB_TRA->setSort("");
				$this->ACC_MT_AJST->setSort("");
				$this->ACC_NB_TRA_ACT->setSort("");
				$this->ACC1_MT_BRUT->setSort("");
				$this->ACC_RENDEMENT->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = ($Security->canDelete() || $Security->canEdit());
		$item->OnLeft = TRUE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = TRUE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = $this->ListOptions["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->RN->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add multi delete
		$item = &$option->add("multidelete");
		$item->Body = "<a class=\"ew-action ew-multi-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" href=\"#\" onclick=\"return ew.submitAction(event, {f:document.ftabemp4list, url:'" . $this->MultiDeleteUrl . "', data:{action:'show'}});return false;\">" . $Language->phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = $Security->canDelete();

		// Add multi update
		$item = &$option->add("multiupdate");
		$item->Body = "<a class=\"ew-action ew-multi-update\" title=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" data-table=\"tabemp4\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateSelectedLink")) . "\" href=\"#\" onclick=\"return ew.submitAction(event, {f:document.ftabemp4list,url:'" . $this->MultiUpdateUrl . "'});return false;\">" . $Language->phrase("UpdateSelectedLink") . "</a>";
		$item->Visible = $Security->canEdit();

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"ftabemp4listsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"ftabemp4listsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.ftabemp4list}," . $listaction->toJson(TRUE) . "));\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->RN->setDbValue($row['RN']);
		$this->NO_EMP->setDbValue($row['NO_EMP']);
		$this->NOM_EMP->setDbValue($row['NOM_EMP']);
		$this->SEXE->setDbValue($row['SEXE']);
		$this->ETAT_C->setDbValue($row['ETAT_C']);
		$this->DEPEND->setDbValue($row['DEPEND']);
		$this->DTE_NAIS->setDbValue($row['DTE_NAIS']);
		$this->LIEU_NAIS->setDbValue($row['LIEU_NAIS']);
		$this->NATION->setDbValue($row['NATION']);
		$this->ADRESSE->setDbValue($row['ADRESSE']);
		$this->VILLE->setDbValue($row['VILLE']);
		$this->PAYS->setDbValue($row['PAYS']);
		$this->BOX->setDbValue($row['BOX']);
		$this->PHONE->setDbValue($row['PHONE']);
		$this->REFERENCE->setDbValue($row['REFERENCE']);
		$this->QUALIF->setDbValue($row['QUALIF']);
		$this->URGENCE->setDbValue($row['URGENCE']);
		$this->PHONE_URG->setDbValue($row['PHONE_URG']);
		$this->DATE_EMP->setDbValue($row['DATE_EMP']);
		$this->SERVICE->setDbValue($row['SERVICE']);
		$this->DEPT->setDbValue($row['DEPT']);
		$this->SECTION->setDbValue($row['SECTION']);
		$this->CATEGORIE->setDbValue($row['CATEGORIE']);
		$this->FONCTION->setDbValue($row['FONCTION']);
		$this->STATUT->setDbValue($row['STATUT']);
		$this->STA_DEBUT->setDbValue($row['STA_DEBUT']);
		$this->STA_FIN->setDbValue($row['STA_FIN']);
		$this->STA_MOTIF->setDbValue($row['STA_MOTIF']);
		$this->NO_NIF->setDbValue($row['NO_NIF']);
		$this->NO_ONA->setDbValue($row['NO_ONA']);
		$this->LIV_TRAV->setDbValue($row['LIV_TRAV']);
		$this->MT_SALAIRE->setDbValue($row['MT_SALAIRE']);
		$this->MT_FRAIS->setDbValue($row['MT_FRAIS']);
		$this->MT_AUTRES->setDbValue($row['MT_AUTRES']);
		$this->MODE->setDbValue($row['MODE']);
		$this->TYPE->setDbValue($row['TYPE']);
		$this->MT_IMPOT->setDbValue($row['MT_IMPOT']);
		$this->PER_IMPOT->setDbValue($row['PER_IMPOT']);
		$this->PRET_ONA->setDbValue($row['PRET_ONA']);
		$this->PER_ONA->setDbValue($row['PER_ONA']);
		$this->RET_ASSUR->setDbValue($row['RET_ASSUR']);
		$this->PER_ASSUR->setDbValue($row['PER_ASSUR']);
		$this->PRET_SALAIRE->setDbValue($row['PRET_SALAIRE']);
		$this->PER_SALAIRE->setDbValue($row['PER_SALAIRE']);
		$this->RET_PENSION->setDbValue($row['RET_PENSION']);
		$this->PER_RETPENSION->setDbValue($row['PER_RETPENSION']);
		$this->PRET_BANQUE->setDbValue($row['PRET_BANQUE']);
		$this->PER_BANQUE->setDbValue($row['PER_BANQUE']);
		$this->RET_AVANC->setDbValue($row['RET_AVANC']);
		$this->PER_AVANCE->setDbValue($row['PER_AVANCE']);
		$this->PRET_PENSION->setDbValue($row['PRET_PENSION']);
		$this->PER_PENSION->setDbValue($row['PER_PENSION']);
		$this->RET_CAFET->setDbValue($row['RET_CAFET']);
		$this->PER_CAFET->setDbValue($row['PER_CAFET']);
		$this->RET_CITE->setDbValue($row['RET_CITE']);
		$this->PER_CITE->setDbValue($row['PER_CITE']);
		$this->RET_AUTRE->setDbValue($row['RET_AUTRE']);
		$this->PER_AUTRE->setDbValue($row['PER_AUTRE']);
		$this->ACQ_NB_CON->setDbValue($row['ACQ_NB_CON']);
		$this->ACC_MT_BRUT->setDbValue($row['ACC_MT_BRUT']);
		$this->ACC_NB_CON->setDbValue($row['ACC_NB_CON']);
		$this->ACC_NB_PCON->setDbValue($row['ACC_NB_PCON']);
		$this->ACC_MT_OVT->setDbValue($row['ACC_MT_OVT']);
		$this->ACQ_NB_MAL->setDbValue($row['ACQ_NB_MAL']);
		$this->ACC_NB_MAL->setDbValue($row['ACC_NB_MAL']);
		$this->ACC_MT_CON->setDbValue($row['ACC_MT_CON']);
		$this->ACC_NB_MAT->setDbValue($row['ACC_NB_MAT']);
		$this->ACC_MT_BONI->setDbValue($row['ACC_MT_BONI']);
		$this->ACC_NB_PER->setDbValue($row['ACC_NB_PER']);
		$this->ACC_MT_AUT->setDbValue($row['ACC_MT_AUT']);
		$this->ACC_NB_COM->setDbValue($row['ACC_NB_COM']);
		$this->ACC_BAL_SAL->setDbValue($row['ACC_BAL_SAL']);
		$this->ACC_BAL_BAN->setDbValue($row['ACC_BAL_BAN']);
		$this->ACC_NB_SUS->setDbValue($row['ACC_NB_SUS']);
		$this->ACC_BAL_ONA->setDbValue($row['ACC_BAL_ONA']);
		$this->ACC_BAL_PENSION->setDbValue($row['ACC_BAL_PENSION']);
		$this->ACC_NB_ABS->setDbValue($row['ACC_NB_ABS']);
		$this->ACC_MT_QZ->setDbValue($row['ACC_MT_QZ']);
		$this->ACC_NB_TRA->setDbValue($row['ACC_NB_TRA']);
		$this->ACC_MT_AJST->setDbValue($row['ACC_MT_AJST']);
		$this->ACC_NB_TRA_ACT->setDbValue($row['ACC_NB_TRA_ACT']);
		$this->ACC1_MT_BRUT->setDbValue($row['ACC1_MT_BRUT']);
		$this->ACC_RENDEMENT->setDbValue($row['ACC_RENDEMENT']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['RN'] = NULL;
		$row['NO_EMP'] = NULL;
		$row['NOM_EMP'] = NULL;
		$row['SEXE'] = NULL;
		$row['ETAT_C'] = NULL;
		$row['DEPEND'] = NULL;
		$row['DTE_NAIS'] = NULL;
		$row['LIEU_NAIS'] = NULL;
		$row['NATION'] = NULL;
		$row['ADRESSE'] = NULL;
		$row['VILLE'] = NULL;
		$row['PAYS'] = NULL;
		$row['BOX'] = NULL;
		$row['PHONE'] = NULL;
		$row['REFERENCE'] = NULL;
		$row['QUALIF'] = NULL;
		$row['URGENCE'] = NULL;
		$row['PHONE_URG'] = NULL;
		$row['DATE_EMP'] = NULL;
		$row['SERVICE'] = NULL;
		$row['DEPT'] = NULL;
		$row['SECTION'] = NULL;
		$row['CATEGORIE'] = NULL;
		$row['FONCTION'] = NULL;
		$row['STATUT'] = NULL;
		$row['STA_DEBUT'] = NULL;
		$row['STA_FIN'] = NULL;
		$row['STA_MOTIF'] = NULL;
		$row['NO_NIF'] = NULL;
		$row['NO_ONA'] = NULL;
		$row['LIV_TRAV'] = NULL;
		$row['MT_SALAIRE'] = NULL;
		$row['MT_FRAIS'] = NULL;
		$row['MT_AUTRES'] = NULL;
		$row['MODE'] = NULL;
		$row['TYPE'] = NULL;
		$row['MT_IMPOT'] = NULL;
		$row['PER_IMPOT'] = NULL;
		$row['PRET_ONA'] = NULL;
		$row['PER_ONA'] = NULL;
		$row['RET_ASSUR'] = NULL;
		$row['PER_ASSUR'] = NULL;
		$row['PRET_SALAIRE'] = NULL;
		$row['PER_SALAIRE'] = NULL;
		$row['RET_PENSION'] = NULL;
		$row['PER_RETPENSION'] = NULL;
		$row['PRET_BANQUE'] = NULL;
		$row['PER_BANQUE'] = NULL;
		$row['RET_AVANC'] = NULL;
		$row['PER_AVANCE'] = NULL;
		$row['PRET_PENSION'] = NULL;
		$row['PER_PENSION'] = NULL;
		$row['RET_CAFET'] = NULL;
		$row['PER_CAFET'] = NULL;
		$row['RET_CITE'] = NULL;
		$row['PER_CITE'] = NULL;
		$row['RET_AUTRE'] = NULL;
		$row['PER_AUTRE'] = NULL;
		$row['ACQ_NB_CON'] = NULL;
		$row['ACC_MT_BRUT'] = NULL;
		$row['ACC_NB_CON'] = NULL;
		$row['ACC_NB_PCON'] = NULL;
		$row['ACC_MT_OVT'] = NULL;
		$row['ACQ_NB_MAL'] = NULL;
		$row['ACC_NB_MAL'] = NULL;
		$row['ACC_MT_CON'] = NULL;
		$row['ACC_NB_MAT'] = NULL;
		$row['ACC_MT_BONI'] = NULL;
		$row['ACC_NB_PER'] = NULL;
		$row['ACC_MT_AUT'] = NULL;
		$row['ACC_NB_COM'] = NULL;
		$row['ACC_BAL_SAL'] = NULL;
		$row['ACC_BAL_BAN'] = NULL;
		$row['ACC_NB_SUS'] = NULL;
		$row['ACC_BAL_ONA'] = NULL;
		$row['ACC_BAL_PENSION'] = NULL;
		$row['ACC_NB_ABS'] = NULL;
		$row['ACC_MT_QZ'] = NULL;
		$row['ACC_NB_TRA'] = NULL;
		$row['ACC_MT_AJST'] = NULL;
		$row['ACC_NB_TRA_ACT'] = NULL;
		$row['ACC1_MT_BRUT'] = NULL;
		$row['ACC_RENDEMENT'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("RN")) != "")
			$this->RN->OldValue = $this->getKey("RN"); // RN
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->id->FormValue == $this->id->CurrentValue && is_numeric(ConvertToFloatString($this->id->CurrentValue)))
			$this->id->CurrentValue = ConvertToFloatString($this->id->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RN->FormValue == $this->RN->CurrentValue && is_numeric(ConvertToFloatString($this->RN->CurrentValue)))
			$this->RN->CurrentValue = ConvertToFloatString($this->RN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->NO_EMP->FormValue == $this->NO_EMP->CurrentValue && is_numeric(ConvertToFloatString($this->NO_EMP->CurrentValue)))
			$this->NO_EMP->CurrentValue = ConvertToFloatString($this->NO_EMP->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DEPEND->FormValue == $this->DEPEND->CurrentValue && is_numeric(ConvertToFloatString($this->DEPEND->CurrentValue)))
			$this->DEPEND->CurrentValue = ConvertToFloatString($this->DEPEND->CurrentValue);

		// Convert decimal values if posted back
		if ($this->DEPT->FormValue == $this->DEPT->CurrentValue && is_numeric(ConvertToFloatString($this->DEPT->CurrentValue)))
			$this->DEPT->CurrentValue = ConvertToFloatString($this->DEPT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->NO_NIF->FormValue == $this->NO_NIF->CurrentValue && is_numeric(ConvertToFloatString($this->NO_NIF->CurrentValue)))
			$this->NO_NIF->CurrentValue = ConvertToFloatString($this->NO_NIF->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_SALAIRE->FormValue == $this->MT_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->MT_SALAIRE->CurrentValue)))
			$this->MT_SALAIRE->CurrentValue = ConvertToFloatString($this->MT_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_FRAIS->FormValue == $this->MT_FRAIS->CurrentValue && is_numeric(ConvertToFloatString($this->MT_FRAIS->CurrentValue)))
			$this->MT_FRAIS->CurrentValue = ConvertToFloatString($this->MT_FRAIS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_AUTRES->FormValue == $this->MT_AUTRES->CurrentValue && is_numeric(ConvertToFloatString($this->MT_AUTRES->CurrentValue)))
			$this->MT_AUTRES->CurrentValue = ConvertToFloatString($this->MT_AUTRES->CurrentValue);

		// Convert decimal values if posted back
		if ($this->MT_IMPOT->FormValue == $this->MT_IMPOT->CurrentValue && is_numeric(ConvertToFloatString($this->MT_IMPOT->CurrentValue)))
			$this->MT_IMPOT->CurrentValue = ConvertToFloatString($this->MT_IMPOT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_ONA->FormValue == $this->PRET_ONA->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_ONA->CurrentValue)))
			$this->PRET_ONA->CurrentValue = ConvertToFloatString($this->PRET_ONA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_ASSUR->FormValue == $this->RET_ASSUR->CurrentValue && is_numeric(ConvertToFloatString($this->RET_ASSUR->CurrentValue)))
			$this->RET_ASSUR->CurrentValue = ConvertToFloatString($this->RET_ASSUR->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_SALAIRE->FormValue == $this->PRET_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_SALAIRE->CurrentValue)))
			$this->PRET_SALAIRE->CurrentValue = ConvertToFloatString($this->PRET_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PER_SALAIRE->FormValue == $this->PER_SALAIRE->CurrentValue && is_numeric(ConvertToFloatString($this->PER_SALAIRE->CurrentValue)))
			$this->PER_SALAIRE->CurrentValue = ConvertToFloatString($this->PER_SALAIRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_PENSION->FormValue == $this->RET_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->RET_PENSION->CurrentValue)))
			$this->RET_PENSION->CurrentValue = ConvertToFloatString($this->RET_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_BANQUE->FormValue == $this->PRET_BANQUE->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_BANQUE->CurrentValue)))
			$this->PRET_BANQUE->CurrentValue = ConvertToFloatString($this->PRET_BANQUE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PER_BANQUE->FormValue == $this->PER_BANQUE->CurrentValue && is_numeric(ConvertToFloatString($this->PER_BANQUE->CurrentValue)))
			$this->PER_BANQUE->CurrentValue = ConvertToFloatString($this->PER_BANQUE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_AVANC->FormValue == $this->RET_AVANC->CurrentValue && is_numeric(ConvertToFloatString($this->RET_AVANC->CurrentValue)))
			$this->RET_AVANC->CurrentValue = ConvertToFloatString($this->RET_AVANC->CurrentValue);

		// Convert decimal values if posted back
		if ($this->PRET_PENSION->FormValue == $this->PRET_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->PRET_PENSION->CurrentValue)))
			$this->PRET_PENSION->CurrentValue = ConvertToFloatString($this->PRET_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_CAFET->FormValue == $this->RET_CAFET->CurrentValue && is_numeric(ConvertToFloatString($this->RET_CAFET->CurrentValue)))
			$this->RET_CAFET->CurrentValue = ConvertToFloatString($this->RET_CAFET->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_CITE->FormValue == $this->RET_CITE->CurrentValue && is_numeric(ConvertToFloatString($this->RET_CITE->CurrentValue)))
			$this->RET_CITE->CurrentValue = ConvertToFloatString($this->RET_CITE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->RET_AUTRE->FormValue == $this->RET_AUTRE->CurrentValue && is_numeric(ConvertToFloatString($this->RET_AUTRE->CurrentValue)))
			$this->RET_AUTRE->CurrentValue = ConvertToFloatString($this->RET_AUTRE->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACQ_NB_CON->FormValue == $this->ACQ_NB_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACQ_NB_CON->CurrentValue)))
			$this->ACQ_NB_CON->CurrentValue = ConvertToFloatString($this->ACQ_NB_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_BRUT->FormValue == $this->ACC_MT_BRUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_BRUT->CurrentValue)))
			$this->ACC_MT_BRUT->CurrentValue = ConvertToFloatString($this->ACC_MT_BRUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_CON->FormValue == $this->ACC_NB_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_CON->CurrentValue)))
			$this->ACC_NB_CON->CurrentValue = ConvertToFloatString($this->ACC_NB_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_PCON->FormValue == $this->ACC_NB_PCON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_PCON->CurrentValue)))
			$this->ACC_NB_PCON->CurrentValue = ConvertToFloatString($this->ACC_NB_PCON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_OVT->FormValue == $this->ACC_MT_OVT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_OVT->CurrentValue)))
			$this->ACC_MT_OVT->CurrentValue = ConvertToFloatString($this->ACC_MT_OVT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACQ_NB_MAL->FormValue == $this->ACQ_NB_MAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACQ_NB_MAL->CurrentValue)))
			$this->ACQ_NB_MAL->CurrentValue = ConvertToFloatString($this->ACQ_NB_MAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_MAL->FormValue == $this->ACC_NB_MAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_MAL->CurrentValue)))
			$this->ACC_NB_MAL->CurrentValue = ConvertToFloatString($this->ACC_NB_MAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_CON->FormValue == $this->ACC_MT_CON->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_CON->CurrentValue)))
			$this->ACC_MT_CON->CurrentValue = ConvertToFloatString($this->ACC_MT_CON->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_MAT->FormValue == $this->ACC_NB_MAT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_MAT->CurrentValue)))
			$this->ACC_NB_MAT->CurrentValue = ConvertToFloatString($this->ACC_NB_MAT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_BONI->FormValue == $this->ACC_MT_BONI->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_BONI->CurrentValue)))
			$this->ACC_MT_BONI->CurrentValue = ConvertToFloatString($this->ACC_MT_BONI->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_PER->FormValue == $this->ACC_NB_PER->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_PER->CurrentValue)))
			$this->ACC_NB_PER->CurrentValue = ConvertToFloatString($this->ACC_NB_PER->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_AUT->FormValue == $this->ACC_MT_AUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_AUT->CurrentValue)))
			$this->ACC_MT_AUT->CurrentValue = ConvertToFloatString($this->ACC_MT_AUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_COM->FormValue == $this->ACC_NB_COM->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_COM->CurrentValue)))
			$this->ACC_NB_COM->CurrentValue = ConvertToFloatString($this->ACC_NB_COM->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_SAL->FormValue == $this->ACC_BAL_SAL->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_SAL->CurrentValue)))
			$this->ACC_BAL_SAL->CurrentValue = ConvertToFloatString($this->ACC_BAL_SAL->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_BAN->FormValue == $this->ACC_BAL_BAN->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_BAN->CurrentValue)))
			$this->ACC_BAL_BAN->CurrentValue = ConvertToFloatString($this->ACC_BAL_BAN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_SUS->FormValue == $this->ACC_NB_SUS->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_SUS->CurrentValue)))
			$this->ACC_NB_SUS->CurrentValue = ConvertToFloatString($this->ACC_NB_SUS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_ONA->FormValue == $this->ACC_BAL_ONA->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_ONA->CurrentValue)))
			$this->ACC_BAL_ONA->CurrentValue = ConvertToFloatString($this->ACC_BAL_ONA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_BAL_PENSION->FormValue == $this->ACC_BAL_PENSION->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_BAL_PENSION->CurrentValue)))
			$this->ACC_BAL_PENSION->CurrentValue = ConvertToFloatString($this->ACC_BAL_PENSION->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_ABS->FormValue == $this->ACC_NB_ABS->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_ABS->CurrentValue)))
			$this->ACC_NB_ABS->CurrentValue = ConvertToFloatString($this->ACC_NB_ABS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_QZ->FormValue == $this->ACC_MT_QZ->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_QZ->CurrentValue)))
			$this->ACC_MT_QZ->CurrentValue = ConvertToFloatString($this->ACC_MT_QZ->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_TRA->FormValue == $this->ACC_NB_TRA->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_TRA->CurrentValue)))
			$this->ACC_NB_TRA->CurrentValue = ConvertToFloatString($this->ACC_NB_TRA->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_MT_AJST->FormValue == $this->ACC_MT_AJST->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_MT_AJST->CurrentValue)))
			$this->ACC_MT_AJST->CurrentValue = ConvertToFloatString($this->ACC_MT_AJST->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_NB_TRA_ACT->FormValue == $this->ACC_NB_TRA_ACT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_NB_TRA_ACT->CurrentValue)))
			$this->ACC_NB_TRA_ACT->CurrentValue = ConvertToFloatString($this->ACC_NB_TRA_ACT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC1_MT_BRUT->FormValue == $this->ACC1_MT_BRUT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC1_MT_BRUT->CurrentValue)))
			$this->ACC1_MT_BRUT->CurrentValue = ConvertToFloatString($this->ACC1_MT_BRUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ACC_RENDEMENT->FormValue == $this->ACC_RENDEMENT->CurrentValue && is_numeric(ConvertToFloatString($this->ACC_RENDEMENT->CurrentValue)))
			$this->ACC_RENDEMENT->CurrentValue = ConvertToFloatString($this->ACC_RENDEMENT->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// RN
		// NO_EMP
		// NOM_EMP
		// SEXE
		// ETAT_C
		// DEPEND
		// DTE_NAIS
		// LIEU_NAIS
		// NATION
		// ADRESSE
		// VILLE
		// PAYS
		// BOX
		// PHONE
		// REFERENCE
		// QUALIF
		// URGENCE
		// PHONE_URG
		// DATE_EMP
		// SERVICE
		// DEPT
		// SECTION
		// CATEGORIE
		// FONCTION
		// STATUT
		// STA_DEBUT
		// STA_FIN
		// STA_MOTIF
		// NO_NIF
		// NO_ONA
		// LIV_TRAV
		// MT_SALAIRE
		// MT_FRAIS
		// MT_AUTRES
		// MODE
		// TYPE
		// MT_IMPOT
		// PER_IMPOT
		// PRET_ONA
		// PER_ONA
		// RET_ASSUR
		// PER_ASSUR
		// PRET_SALAIRE
		// PER_SALAIRE
		// RET_PENSION
		// PER_RETPENSION
		// PRET_BANQUE
		// PER_BANQUE
		// RET_AVANC
		// PER_AVANCE
		// PRET_PENSION
		// PER_PENSION
		// RET_CAFET
		// PER_CAFET
		// RET_CITE
		// PER_CITE
		// RET_AUTRE
		// PER_AUTRE
		// ACQ_NB_CON
		// ACC_MT_BRUT
		// ACC_NB_CON
		// ACC_NB_PCON
		// ACC_MT_OVT
		// ACQ_NB_MAL
		// ACC_NB_MAL
		// ACC_MT_CON
		// ACC_NB_MAT
		// ACC_MT_BONI
		// ACC_NB_PER
		// ACC_MT_AUT
		// ACC_NB_COM
		// ACC_BAL_SAL
		// ACC_BAL_BAN
		// ACC_NB_SUS
		// ACC_BAL_ONA
		// ACC_BAL_PENSION
		// ACC_NB_ABS
		// ACC_MT_QZ
		// ACC_NB_TRA
		// ACC_MT_AJST
		// ACC_NB_TRA_ACT
		// ACC1_MT_BRUT
		// ACC_RENDEMENT

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, Config("DEFAULT_DECIMAL_PRECISION"));
			$this->id->ViewCustomAttributes = "";

			// RN
			$this->RN->ViewValue = $this->RN->CurrentValue;
			$this->RN->ViewValue = FormatNumber($this->RN->ViewValue, Config("DEFAULT_DECIMAL_PRECISION"));
			$this->RN->ViewCustomAttributes = "";

			// NO_EMP
			$this->NO_EMP->ViewValue = $this->NO_EMP->CurrentValue;
			$this->NO_EMP->ViewValue = FormatNumber($this->NO_EMP->ViewValue, 2, -2, -2, -2);
			$this->NO_EMP->ViewCustomAttributes = "";

			// NOM_EMP
			$this->NOM_EMP->ViewValue = $this->NOM_EMP->CurrentValue;
			$this->NOM_EMP->ViewCustomAttributes = "";

			// SEXE
			$this->SEXE->ViewValue = $this->SEXE->CurrentValue;
			$this->SEXE->ViewCustomAttributes = "";

			// ETAT_C
			$this->ETAT_C->ViewValue = $this->ETAT_C->CurrentValue;
			$this->ETAT_C->ViewCustomAttributes = "";

			// DEPEND
			$this->DEPEND->ViewValue = $this->DEPEND->CurrentValue;
			$this->DEPEND->ViewValue = FormatNumber($this->DEPEND->ViewValue, 2, -2, -2, -2);
			$this->DEPEND->ViewCustomAttributes = "";

			// DTE_NAIS
			$this->DTE_NAIS->ViewValue = $this->DTE_NAIS->CurrentValue;
			$this->DTE_NAIS->ViewValue = FormatDateTime($this->DTE_NAIS->ViewValue, 0);
			$this->DTE_NAIS->ViewCustomAttributes = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->ViewValue = $this->LIEU_NAIS->CurrentValue;
			$this->LIEU_NAIS->ViewCustomAttributes = "";

			// NATION
			$this->NATION->ViewValue = $this->NATION->CurrentValue;
			$this->NATION->ViewCustomAttributes = "";

			// ADRESSE
			$this->ADRESSE->ViewValue = $this->ADRESSE->CurrentValue;
			$this->ADRESSE->ViewCustomAttributes = "";

			// VILLE
			$this->VILLE->ViewValue = $this->VILLE->CurrentValue;
			$this->VILLE->ViewCustomAttributes = "";

			// PAYS
			$this->PAYS->ViewValue = $this->PAYS->CurrentValue;
			$this->PAYS->ViewCustomAttributes = "";

			// BOX
			$this->BOX->ViewValue = $this->BOX->CurrentValue;
			$this->BOX->ViewCustomAttributes = "";

			// PHONE
			$this->PHONE->ViewValue = $this->PHONE->CurrentValue;
			$this->PHONE->ViewCustomAttributes = "";

			// REFERENCE
			$this->REFERENCE->ViewValue = $this->REFERENCE->CurrentValue;
			$this->REFERENCE->ViewCustomAttributes = "";

			// QUALIF
			$this->QUALIF->ViewValue = $this->QUALIF->CurrentValue;
			$this->QUALIF->ViewCustomAttributes = "";

			// URGENCE
			$this->URGENCE->ViewValue = $this->URGENCE->CurrentValue;
			$this->URGENCE->ViewCustomAttributes = "";

			// PHONE_URG
			$this->PHONE_URG->ViewValue = $this->PHONE_URG->CurrentValue;
			$this->PHONE_URG->ViewCustomAttributes = "";

			// DATE_EMP
			$this->DATE_EMP->ViewValue = $this->DATE_EMP->CurrentValue;
			$this->DATE_EMP->ViewValue = FormatDateTime($this->DATE_EMP->ViewValue, 0);
			$this->DATE_EMP->ViewCustomAttributes = "";

			// SERVICE
			$this->SERVICE->ViewValue = $this->SERVICE->CurrentValue;
			$this->SERVICE->ViewCustomAttributes = "";

			// DEPT
			$this->DEPT->ViewValue = $this->DEPT->CurrentValue;
			$this->DEPT->ViewValue = FormatNumber($this->DEPT->ViewValue, 2, -2, -2, -2);
			$this->DEPT->ViewCustomAttributes = "";

			// SECTION
			$this->SECTION->ViewValue = $this->SECTION->CurrentValue;
			$this->SECTION->ViewCustomAttributes = "";

			// CATEGORIE
			$this->CATEGORIE->ViewValue = $this->CATEGORIE->CurrentValue;
			$this->CATEGORIE->ViewCustomAttributes = "";

			// FONCTION
			$this->FONCTION->ViewValue = $this->FONCTION->CurrentValue;
			$this->FONCTION->ViewCustomAttributes = "";

			// STATUT
			$this->STATUT->ViewValue = $this->STATUT->CurrentValue;
			$this->STATUT->ViewCustomAttributes = "";

			// STA_DEBUT
			$this->STA_DEBUT->ViewValue = $this->STA_DEBUT->CurrentValue;
			$this->STA_DEBUT->ViewValue = FormatDateTime($this->STA_DEBUT->ViewValue, 0);
			$this->STA_DEBUT->ViewCustomAttributes = "";

			// STA_FIN
			$this->STA_FIN->ViewValue = $this->STA_FIN->CurrentValue;
			$this->STA_FIN->ViewValue = FormatDateTime($this->STA_FIN->ViewValue, 0);
			$this->STA_FIN->ViewCustomAttributes = "";

			// STA_MOTIF
			$this->STA_MOTIF->ViewValue = $this->STA_MOTIF->CurrentValue;
			$this->STA_MOTIF->ViewCustomAttributes = "";

			// NO_NIF
			$this->NO_NIF->ViewValue = $this->NO_NIF->CurrentValue;
			$this->NO_NIF->ViewValue = FormatNumber($this->NO_NIF->ViewValue, 2, -2, -2, -2);
			$this->NO_NIF->ViewCustomAttributes = "";

			// NO_ONA
			$this->NO_ONA->ViewValue = $this->NO_ONA->CurrentValue;
			$this->NO_ONA->ViewCustomAttributes = "";

			// LIV_TRAV
			$this->LIV_TRAV->ViewValue = $this->LIV_TRAV->CurrentValue;
			$this->LIV_TRAV->ViewCustomAttributes = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->ViewValue = $this->MT_SALAIRE->CurrentValue;
			$this->MT_SALAIRE->ViewValue = FormatNumber($this->MT_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->MT_SALAIRE->ViewCustomAttributes = "";

			// MT_FRAIS
			$this->MT_FRAIS->ViewValue = $this->MT_FRAIS->CurrentValue;
			$this->MT_FRAIS->ViewValue = FormatNumber($this->MT_FRAIS->ViewValue, 2, -2, -2, -2);
			$this->MT_FRAIS->ViewCustomAttributes = "";

			// MT_AUTRES
			$this->MT_AUTRES->ViewValue = $this->MT_AUTRES->CurrentValue;
			$this->MT_AUTRES->ViewValue = FormatNumber($this->MT_AUTRES->ViewValue, 2, -2, -2, -2);
			$this->MT_AUTRES->ViewCustomAttributes = "";

			// MODE
			$this->MODE->ViewValue = $this->MODE->CurrentValue;
			$this->MODE->ViewCustomAttributes = "";

			// TYPE
			$this->TYPE->ViewValue = $this->TYPE->CurrentValue;
			$this->TYPE->ViewCustomAttributes = "";

			// MT_IMPOT
			$this->MT_IMPOT->ViewValue = $this->MT_IMPOT->CurrentValue;
			$this->MT_IMPOT->ViewValue = FormatNumber($this->MT_IMPOT->ViewValue, 2, -2, -2, -2);
			$this->MT_IMPOT->ViewCustomAttributes = "";

			// PER_IMPOT
			$this->PER_IMPOT->ViewValue = $this->PER_IMPOT->CurrentValue;
			$this->PER_IMPOT->ViewCustomAttributes = "";

			// PRET_ONA
			$this->PRET_ONA->ViewValue = $this->PRET_ONA->CurrentValue;
			$this->PRET_ONA->ViewValue = FormatNumber($this->PRET_ONA->ViewValue, 2, -2, -2, -2);
			$this->PRET_ONA->ViewCustomAttributes = "";

			// PER_ONA
			$this->PER_ONA->ViewValue = $this->PER_ONA->CurrentValue;
			$this->PER_ONA->ViewCustomAttributes = "";

			// RET_ASSUR
			$this->RET_ASSUR->ViewValue = $this->RET_ASSUR->CurrentValue;
			$this->RET_ASSUR->ViewValue = FormatNumber($this->RET_ASSUR->ViewValue, 2, -2, -2, -2);
			$this->RET_ASSUR->ViewCustomAttributes = "";

			// PER_ASSUR
			$this->PER_ASSUR->ViewValue = $this->PER_ASSUR->CurrentValue;
			$this->PER_ASSUR->ViewCustomAttributes = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->ViewValue = $this->PRET_SALAIRE->CurrentValue;
			$this->PRET_SALAIRE->ViewValue = FormatNumber($this->PRET_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->PRET_SALAIRE->ViewCustomAttributes = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->ViewValue = $this->PER_SALAIRE->CurrentValue;
			$this->PER_SALAIRE->ViewValue = FormatNumber($this->PER_SALAIRE->ViewValue, 2, -2, -2, -2);
			$this->PER_SALAIRE->ViewCustomAttributes = "";

			// RET_PENSION
			$this->RET_PENSION->ViewValue = $this->RET_PENSION->CurrentValue;
			$this->RET_PENSION->ViewValue = FormatNumber($this->RET_PENSION->ViewValue, 2, -2, -2, -2);
			$this->RET_PENSION->ViewCustomAttributes = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->ViewValue = $this->PER_RETPENSION->CurrentValue;
			$this->PER_RETPENSION->ViewCustomAttributes = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->ViewValue = $this->PRET_BANQUE->CurrentValue;
			$this->PRET_BANQUE->ViewValue = FormatNumber($this->PRET_BANQUE->ViewValue, 2, -2, -2, -2);
			$this->PRET_BANQUE->ViewCustomAttributes = "";

			// PER_BANQUE
			$this->PER_BANQUE->ViewValue = $this->PER_BANQUE->CurrentValue;
			$this->PER_BANQUE->ViewValue = FormatNumber($this->PER_BANQUE->ViewValue, 2, -2, -2, -2);
			$this->PER_BANQUE->ViewCustomAttributes = "";

			// RET_AVANC
			$this->RET_AVANC->ViewValue = $this->RET_AVANC->CurrentValue;
			$this->RET_AVANC->ViewValue = FormatNumber($this->RET_AVANC->ViewValue, 2, -2, -2, -2);
			$this->RET_AVANC->ViewCustomAttributes = "";

			// PER_AVANCE
			$this->PER_AVANCE->ViewValue = $this->PER_AVANCE->CurrentValue;
			$this->PER_AVANCE->ViewCustomAttributes = "";

			// PRET_PENSION
			$this->PRET_PENSION->ViewValue = $this->PRET_PENSION->CurrentValue;
			$this->PRET_PENSION->ViewValue = FormatNumber($this->PRET_PENSION->ViewValue, 2, -2, -2, -2);
			$this->PRET_PENSION->ViewCustomAttributes = "";

			// PER_PENSION
			$this->PER_PENSION->ViewValue = $this->PER_PENSION->CurrentValue;
			$this->PER_PENSION->ViewCustomAttributes = "";

			// RET_CAFET
			$this->RET_CAFET->ViewValue = $this->RET_CAFET->CurrentValue;
			$this->RET_CAFET->ViewValue = FormatNumber($this->RET_CAFET->ViewValue, 2, -2, -2, -2);
			$this->RET_CAFET->ViewCustomAttributes = "";

			// PER_CAFET
			$this->PER_CAFET->ViewValue = $this->PER_CAFET->CurrentValue;
			$this->PER_CAFET->ViewCustomAttributes = "";

			// RET_CITE
			$this->RET_CITE->ViewValue = $this->RET_CITE->CurrentValue;
			$this->RET_CITE->ViewValue = FormatNumber($this->RET_CITE->ViewValue, 2, -2, -2, -2);
			$this->RET_CITE->ViewCustomAttributes = "";

			// PER_CITE
			$this->PER_CITE->ViewValue = $this->PER_CITE->CurrentValue;
			$this->PER_CITE->ViewCustomAttributes = "";

			// RET_AUTRE
			$this->RET_AUTRE->ViewValue = $this->RET_AUTRE->CurrentValue;
			$this->RET_AUTRE->ViewValue = FormatNumber($this->RET_AUTRE->ViewValue, 2, -2, -2, -2);
			$this->RET_AUTRE->ViewCustomAttributes = "";

			// PER_AUTRE
			$this->PER_AUTRE->ViewValue = $this->PER_AUTRE->CurrentValue;
			$this->PER_AUTRE->ViewCustomAttributes = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->ViewValue = $this->ACQ_NB_CON->CurrentValue;
			$this->ACQ_NB_CON->ViewValue = FormatNumber($this->ACQ_NB_CON->ViewValue, 2, -2, -2, -2);
			$this->ACQ_NB_CON->ViewCustomAttributes = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->ViewValue = $this->ACC_MT_BRUT->CurrentValue;
			$this->ACC_MT_BRUT->ViewValue = FormatNumber($this->ACC_MT_BRUT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_BRUT->ViewCustomAttributes = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->ViewValue = $this->ACC_NB_CON->CurrentValue;
			$this->ACC_NB_CON->ViewValue = FormatNumber($this->ACC_NB_CON->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_CON->ViewCustomAttributes = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->ViewValue = $this->ACC_NB_PCON->CurrentValue;
			$this->ACC_NB_PCON->ViewValue = FormatNumber($this->ACC_NB_PCON->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_PCON->ViewCustomAttributes = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->ViewValue = $this->ACC_MT_OVT->CurrentValue;
			$this->ACC_MT_OVT->ViewValue = FormatNumber($this->ACC_MT_OVT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_OVT->ViewCustomAttributes = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->ViewValue = $this->ACQ_NB_MAL->CurrentValue;
			$this->ACQ_NB_MAL->ViewValue = FormatNumber($this->ACQ_NB_MAL->ViewValue, 2, -2, -2, -2);
			$this->ACQ_NB_MAL->ViewCustomAttributes = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->ViewValue = $this->ACC_NB_MAL->CurrentValue;
			$this->ACC_NB_MAL->ViewValue = FormatNumber($this->ACC_NB_MAL->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_MAL->ViewCustomAttributes = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->ViewValue = $this->ACC_MT_CON->CurrentValue;
			$this->ACC_MT_CON->ViewValue = FormatNumber($this->ACC_MT_CON->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_CON->ViewCustomAttributes = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->ViewValue = $this->ACC_NB_MAT->CurrentValue;
			$this->ACC_NB_MAT->ViewValue = FormatNumber($this->ACC_NB_MAT->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_MAT->ViewCustomAttributes = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->ViewValue = $this->ACC_MT_BONI->CurrentValue;
			$this->ACC_MT_BONI->ViewValue = FormatNumber($this->ACC_MT_BONI->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_BONI->ViewCustomAttributes = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->ViewValue = $this->ACC_NB_PER->CurrentValue;
			$this->ACC_NB_PER->ViewValue = FormatNumber($this->ACC_NB_PER->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_PER->ViewCustomAttributes = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->ViewValue = $this->ACC_MT_AUT->CurrentValue;
			$this->ACC_MT_AUT->ViewValue = FormatNumber($this->ACC_MT_AUT->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_AUT->ViewCustomAttributes = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->ViewValue = $this->ACC_NB_COM->CurrentValue;
			$this->ACC_NB_COM->ViewValue = FormatNumber($this->ACC_NB_COM->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_COM->ViewCustomAttributes = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->ViewValue = $this->ACC_BAL_SAL->CurrentValue;
			$this->ACC_BAL_SAL->ViewValue = FormatNumber($this->ACC_BAL_SAL->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_SAL->ViewCustomAttributes = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->ViewValue = $this->ACC_BAL_BAN->CurrentValue;
			$this->ACC_BAL_BAN->ViewValue = FormatNumber($this->ACC_BAL_BAN->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_BAN->ViewCustomAttributes = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->ViewValue = $this->ACC_NB_SUS->CurrentValue;
			$this->ACC_NB_SUS->ViewValue = FormatNumber($this->ACC_NB_SUS->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_SUS->ViewCustomAttributes = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->ViewValue = $this->ACC_BAL_ONA->CurrentValue;
			$this->ACC_BAL_ONA->ViewValue = FormatNumber($this->ACC_BAL_ONA->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_ONA->ViewCustomAttributes = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->ViewValue = $this->ACC_BAL_PENSION->CurrentValue;
			$this->ACC_BAL_PENSION->ViewValue = FormatNumber($this->ACC_BAL_PENSION->ViewValue, 2, -2, -2, -2);
			$this->ACC_BAL_PENSION->ViewCustomAttributes = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->ViewValue = $this->ACC_NB_ABS->CurrentValue;
			$this->ACC_NB_ABS->ViewValue = FormatNumber($this->ACC_NB_ABS->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_ABS->ViewCustomAttributes = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->ViewValue = $this->ACC_MT_QZ->CurrentValue;
			$this->ACC_MT_QZ->ViewValue = FormatNumber($this->ACC_MT_QZ->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_QZ->ViewCustomAttributes = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->ViewValue = $this->ACC_NB_TRA->CurrentValue;
			$this->ACC_NB_TRA->ViewValue = FormatNumber($this->ACC_NB_TRA->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_TRA->ViewCustomAttributes = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->ViewValue = $this->ACC_MT_AJST->CurrentValue;
			$this->ACC_MT_AJST->ViewValue = FormatNumber($this->ACC_MT_AJST->ViewValue, 2, -2, -2, -2);
			$this->ACC_MT_AJST->ViewCustomAttributes = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->ViewValue = $this->ACC_NB_TRA_ACT->CurrentValue;
			$this->ACC_NB_TRA_ACT->ViewValue = FormatNumber($this->ACC_NB_TRA_ACT->ViewValue, 2, -2, -2, -2);
			$this->ACC_NB_TRA_ACT->ViewCustomAttributes = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->ViewValue = $this->ACC1_MT_BRUT->CurrentValue;
			$this->ACC1_MT_BRUT->ViewValue = FormatNumber($this->ACC1_MT_BRUT->ViewValue, 2, -2, -2, -2);
			$this->ACC1_MT_BRUT->ViewCustomAttributes = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->ViewValue = $this->ACC_RENDEMENT->CurrentValue;
			$this->ACC_RENDEMENT->ViewValue = FormatNumber($this->ACC_RENDEMENT->ViewValue, 2, -2, -2, -2);
			$this->ACC_RENDEMENT->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// RN
			$this->RN->LinkCustomAttributes = "";
			$this->RN->HrefValue = "";
			$this->RN->TooltipValue = "";

			// NO_EMP
			$this->NO_EMP->LinkCustomAttributes = "";
			$this->NO_EMP->HrefValue = "";
			$this->NO_EMP->TooltipValue = "";

			// NOM_EMP
			$this->NOM_EMP->LinkCustomAttributes = "";
			$this->NOM_EMP->HrefValue = "";
			$this->NOM_EMP->TooltipValue = "";

			// SEXE
			$this->SEXE->LinkCustomAttributes = "";
			$this->SEXE->HrefValue = "";
			$this->SEXE->TooltipValue = "";

			// ETAT_C
			$this->ETAT_C->LinkCustomAttributes = "";
			$this->ETAT_C->HrefValue = "";
			$this->ETAT_C->TooltipValue = "";

			// DEPEND
			$this->DEPEND->LinkCustomAttributes = "";
			$this->DEPEND->HrefValue = "";
			$this->DEPEND->TooltipValue = "";

			// DTE_NAIS
			$this->DTE_NAIS->LinkCustomAttributes = "";
			$this->DTE_NAIS->HrefValue = "";
			$this->DTE_NAIS->TooltipValue = "";

			// LIEU_NAIS
			$this->LIEU_NAIS->LinkCustomAttributes = "";
			$this->LIEU_NAIS->HrefValue = "";
			$this->LIEU_NAIS->TooltipValue = "";

			// NATION
			$this->NATION->LinkCustomAttributes = "";
			$this->NATION->HrefValue = "";
			$this->NATION->TooltipValue = "";

			// ADRESSE
			$this->ADRESSE->LinkCustomAttributes = "";
			$this->ADRESSE->HrefValue = "";
			$this->ADRESSE->TooltipValue = "";

			// VILLE
			$this->VILLE->LinkCustomAttributes = "";
			$this->VILLE->HrefValue = "";
			$this->VILLE->TooltipValue = "";

			// PAYS
			$this->PAYS->LinkCustomAttributes = "";
			$this->PAYS->HrefValue = "";
			$this->PAYS->TooltipValue = "";

			// BOX
			$this->BOX->LinkCustomAttributes = "";
			$this->BOX->HrefValue = "";
			$this->BOX->TooltipValue = "";

			// PHONE
			$this->PHONE->LinkCustomAttributes = "";
			$this->PHONE->HrefValue = "";
			$this->PHONE->TooltipValue = "";

			// REFERENCE
			$this->REFERENCE->LinkCustomAttributes = "";
			$this->REFERENCE->HrefValue = "";
			$this->REFERENCE->TooltipValue = "";

			// QUALIF
			$this->QUALIF->LinkCustomAttributes = "";
			$this->QUALIF->HrefValue = "";
			$this->QUALIF->TooltipValue = "";

			// URGENCE
			$this->URGENCE->LinkCustomAttributes = "";
			$this->URGENCE->HrefValue = "";
			$this->URGENCE->TooltipValue = "";

			// PHONE_URG
			$this->PHONE_URG->LinkCustomAttributes = "";
			$this->PHONE_URG->HrefValue = "";
			$this->PHONE_URG->TooltipValue = "";

			// DATE_EMP
			$this->DATE_EMP->LinkCustomAttributes = "";
			$this->DATE_EMP->HrefValue = "";
			$this->DATE_EMP->TooltipValue = "";

			// SERVICE
			$this->SERVICE->LinkCustomAttributes = "";
			$this->SERVICE->HrefValue = "";
			$this->SERVICE->TooltipValue = "";

			// DEPT
			$this->DEPT->LinkCustomAttributes = "";
			$this->DEPT->HrefValue = "";
			$this->DEPT->TooltipValue = "";

			// SECTION
			$this->SECTION->LinkCustomAttributes = "";
			$this->SECTION->HrefValue = "";
			$this->SECTION->TooltipValue = "";

			// CATEGORIE
			$this->CATEGORIE->LinkCustomAttributes = "";
			$this->CATEGORIE->HrefValue = "";
			$this->CATEGORIE->TooltipValue = "";

			// FONCTION
			$this->FONCTION->LinkCustomAttributes = "";
			$this->FONCTION->HrefValue = "";
			$this->FONCTION->TooltipValue = "";

			// STATUT
			$this->STATUT->LinkCustomAttributes = "";
			$this->STATUT->HrefValue = "";
			$this->STATUT->TooltipValue = "";

			// STA_DEBUT
			$this->STA_DEBUT->LinkCustomAttributes = "";
			$this->STA_DEBUT->HrefValue = "";
			$this->STA_DEBUT->TooltipValue = "";

			// STA_FIN
			$this->STA_FIN->LinkCustomAttributes = "";
			$this->STA_FIN->HrefValue = "";
			$this->STA_FIN->TooltipValue = "";

			// STA_MOTIF
			$this->STA_MOTIF->LinkCustomAttributes = "";
			$this->STA_MOTIF->HrefValue = "";
			$this->STA_MOTIF->TooltipValue = "";

			// NO_NIF
			$this->NO_NIF->LinkCustomAttributes = "";
			$this->NO_NIF->HrefValue = "";
			$this->NO_NIF->TooltipValue = "";

			// NO_ONA
			$this->NO_ONA->LinkCustomAttributes = "";
			$this->NO_ONA->HrefValue = "";
			$this->NO_ONA->TooltipValue = "";

			// LIV_TRAV
			$this->LIV_TRAV->LinkCustomAttributes = "";
			$this->LIV_TRAV->HrefValue = "";
			$this->LIV_TRAV->TooltipValue = "";

			// MT_SALAIRE
			$this->MT_SALAIRE->LinkCustomAttributes = "";
			$this->MT_SALAIRE->HrefValue = "";
			$this->MT_SALAIRE->TooltipValue = "";

			// MT_FRAIS
			$this->MT_FRAIS->LinkCustomAttributes = "";
			$this->MT_FRAIS->HrefValue = "";
			$this->MT_FRAIS->TooltipValue = "";

			// MT_AUTRES
			$this->MT_AUTRES->LinkCustomAttributes = "";
			$this->MT_AUTRES->HrefValue = "";
			$this->MT_AUTRES->TooltipValue = "";

			// MODE
			$this->MODE->LinkCustomAttributes = "";
			$this->MODE->HrefValue = "";
			$this->MODE->TooltipValue = "";

			// TYPE
			$this->TYPE->LinkCustomAttributes = "";
			$this->TYPE->HrefValue = "";
			$this->TYPE->TooltipValue = "";

			// MT_IMPOT
			$this->MT_IMPOT->LinkCustomAttributes = "";
			$this->MT_IMPOT->HrefValue = "";
			$this->MT_IMPOT->TooltipValue = "";

			// PER_IMPOT
			$this->PER_IMPOT->LinkCustomAttributes = "";
			$this->PER_IMPOT->HrefValue = "";
			$this->PER_IMPOT->TooltipValue = "";

			// PRET_ONA
			$this->PRET_ONA->LinkCustomAttributes = "";
			$this->PRET_ONA->HrefValue = "";
			$this->PRET_ONA->TooltipValue = "";

			// PER_ONA
			$this->PER_ONA->LinkCustomAttributes = "";
			$this->PER_ONA->HrefValue = "";
			$this->PER_ONA->TooltipValue = "";

			// RET_ASSUR
			$this->RET_ASSUR->LinkCustomAttributes = "";
			$this->RET_ASSUR->HrefValue = "";
			$this->RET_ASSUR->TooltipValue = "";

			// PER_ASSUR
			$this->PER_ASSUR->LinkCustomAttributes = "";
			$this->PER_ASSUR->HrefValue = "";
			$this->PER_ASSUR->TooltipValue = "";

			// PRET_SALAIRE
			$this->PRET_SALAIRE->LinkCustomAttributes = "";
			$this->PRET_SALAIRE->HrefValue = "";
			$this->PRET_SALAIRE->TooltipValue = "";

			// PER_SALAIRE
			$this->PER_SALAIRE->LinkCustomAttributes = "";
			$this->PER_SALAIRE->HrefValue = "";
			$this->PER_SALAIRE->TooltipValue = "";

			// RET_PENSION
			$this->RET_PENSION->LinkCustomAttributes = "";
			$this->RET_PENSION->HrefValue = "";
			$this->RET_PENSION->TooltipValue = "";

			// PER_RETPENSION
			$this->PER_RETPENSION->LinkCustomAttributes = "";
			$this->PER_RETPENSION->HrefValue = "";
			$this->PER_RETPENSION->TooltipValue = "";

			// PRET_BANQUE
			$this->PRET_BANQUE->LinkCustomAttributes = "";
			$this->PRET_BANQUE->HrefValue = "";
			$this->PRET_BANQUE->TooltipValue = "";

			// PER_BANQUE
			$this->PER_BANQUE->LinkCustomAttributes = "";
			$this->PER_BANQUE->HrefValue = "";
			$this->PER_BANQUE->TooltipValue = "";

			// RET_AVANC
			$this->RET_AVANC->LinkCustomAttributes = "";
			$this->RET_AVANC->HrefValue = "";
			$this->RET_AVANC->TooltipValue = "";

			// PER_AVANCE
			$this->PER_AVANCE->LinkCustomAttributes = "";
			$this->PER_AVANCE->HrefValue = "";
			$this->PER_AVANCE->TooltipValue = "";

			// PRET_PENSION
			$this->PRET_PENSION->LinkCustomAttributes = "";
			$this->PRET_PENSION->HrefValue = "";
			$this->PRET_PENSION->TooltipValue = "";

			// PER_PENSION
			$this->PER_PENSION->LinkCustomAttributes = "";
			$this->PER_PENSION->HrefValue = "";
			$this->PER_PENSION->TooltipValue = "";

			// RET_CAFET
			$this->RET_CAFET->LinkCustomAttributes = "";
			$this->RET_CAFET->HrefValue = "";
			$this->RET_CAFET->TooltipValue = "";

			// PER_CAFET
			$this->PER_CAFET->LinkCustomAttributes = "";
			$this->PER_CAFET->HrefValue = "";
			$this->PER_CAFET->TooltipValue = "";

			// RET_CITE
			$this->RET_CITE->LinkCustomAttributes = "";
			$this->RET_CITE->HrefValue = "";
			$this->RET_CITE->TooltipValue = "";

			// PER_CITE
			$this->PER_CITE->LinkCustomAttributes = "";
			$this->PER_CITE->HrefValue = "";
			$this->PER_CITE->TooltipValue = "";

			// RET_AUTRE
			$this->RET_AUTRE->LinkCustomAttributes = "";
			$this->RET_AUTRE->HrefValue = "";
			$this->RET_AUTRE->TooltipValue = "";

			// PER_AUTRE
			$this->PER_AUTRE->LinkCustomAttributes = "";
			$this->PER_AUTRE->HrefValue = "";
			$this->PER_AUTRE->TooltipValue = "";

			// ACQ_NB_CON
			$this->ACQ_NB_CON->LinkCustomAttributes = "";
			$this->ACQ_NB_CON->HrefValue = "";
			$this->ACQ_NB_CON->TooltipValue = "";

			// ACC_MT_BRUT
			$this->ACC_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC_MT_BRUT->HrefValue = "";
			$this->ACC_MT_BRUT->TooltipValue = "";

			// ACC_NB_CON
			$this->ACC_NB_CON->LinkCustomAttributes = "";
			$this->ACC_NB_CON->HrefValue = "";
			$this->ACC_NB_CON->TooltipValue = "";

			// ACC_NB_PCON
			$this->ACC_NB_PCON->LinkCustomAttributes = "";
			$this->ACC_NB_PCON->HrefValue = "";
			$this->ACC_NB_PCON->TooltipValue = "";

			// ACC_MT_OVT
			$this->ACC_MT_OVT->LinkCustomAttributes = "";
			$this->ACC_MT_OVT->HrefValue = "";
			$this->ACC_MT_OVT->TooltipValue = "";

			// ACQ_NB_MAL
			$this->ACQ_NB_MAL->LinkCustomAttributes = "";
			$this->ACQ_NB_MAL->HrefValue = "";
			$this->ACQ_NB_MAL->TooltipValue = "";

			// ACC_NB_MAL
			$this->ACC_NB_MAL->LinkCustomAttributes = "";
			$this->ACC_NB_MAL->HrefValue = "";
			$this->ACC_NB_MAL->TooltipValue = "";

			// ACC_MT_CON
			$this->ACC_MT_CON->LinkCustomAttributes = "";
			$this->ACC_MT_CON->HrefValue = "";
			$this->ACC_MT_CON->TooltipValue = "";

			// ACC_NB_MAT
			$this->ACC_NB_MAT->LinkCustomAttributes = "";
			$this->ACC_NB_MAT->HrefValue = "";
			$this->ACC_NB_MAT->TooltipValue = "";

			// ACC_MT_BONI
			$this->ACC_MT_BONI->LinkCustomAttributes = "";
			$this->ACC_MT_BONI->HrefValue = "";
			$this->ACC_MT_BONI->TooltipValue = "";

			// ACC_NB_PER
			$this->ACC_NB_PER->LinkCustomAttributes = "";
			$this->ACC_NB_PER->HrefValue = "";
			$this->ACC_NB_PER->TooltipValue = "";

			// ACC_MT_AUT
			$this->ACC_MT_AUT->LinkCustomAttributes = "";
			$this->ACC_MT_AUT->HrefValue = "";
			$this->ACC_MT_AUT->TooltipValue = "";

			// ACC_NB_COM
			$this->ACC_NB_COM->LinkCustomAttributes = "";
			$this->ACC_NB_COM->HrefValue = "";
			$this->ACC_NB_COM->TooltipValue = "";

			// ACC_BAL_SAL
			$this->ACC_BAL_SAL->LinkCustomAttributes = "";
			$this->ACC_BAL_SAL->HrefValue = "";
			$this->ACC_BAL_SAL->TooltipValue = "";

			// ACC_BAL_BAN
			$this->ACC_BAL_BAN->LinkCustomAttributes = "";
			$this->ACC_BAL_BAN->HrefValue = "";
			$this->ACC_BAL_BAN->TooltipValue = "";

			// ACC_NB_SUS
			$this->ACC_NB_SUS->LinkCustomAttributes = "";
			$this->ACC_NB_SUS->HrefValue = "";
			$this->ACC_NB_SUS->TooltipValue = "";

			// ACC_BAL_ONA
			$this->ACC_BAL_ONA->LinkCustomAttributes = "";
			$this->ACC_BAL_ONA->HrefValue = "";
			$this->ACC_BAL_ONA->TooltipValue = "";

			// ACC_BAL_PENSION
			$this->ACC_BAL_PENSION->LinkCustomAttributes = "";
			$this->ACC_BAL_PENSION->HrefValue = "";
			$this->ACC_BAL_PENSION->TooltipValue = "";

			// ACC_NB_ABS
			$this->ACC_NB_ABS->LinkCustomAttributes = "";
			$this->ACC_NB_ABS->HrefValue = "";
			$this->ACC_NB_ABS->TooltipValue = "";

			// ACC_MT_QZ
			$this->ACC_MT_QZ->LinkCustomAttributes = "";
			$this->ACC_MT_QZ->HrefValue = "";
			$this->ACC_MT_QZ->TooltipValue = "";

			// ACC_NB_TRA
			$this->ACC_NB_TRA->LinkCustomAttributes = "";
			$this->ACC_NB_TRA->HrefValue = "";
			$this->ACC_NB_TRA->TooltipValue = "";

			// ACC_MT_AJST
			$this->ACC_MT_AJST->LinkCustomAttributes = "";
			$this->ACC_MT_AJST->HrefValue = "";
			$this->ACC_MT_AJST->TooltipValue = "";

			// ACC_NB_TRA_ACT
			$this->ACC_NB_TRA_ACT->LinkCustomAttributes = "";
			$this->ACC_NB_TRA_ACT->HrefValue = "";
			$this->ACC_NB_TRA_ACT->TooltipValue = "";

			// ACC1_MT_BRUT
			$this->ACC1_MT_BRUT->LinkCustomAttributes = "";
			$this->ACC1_MT_BRUT->HrefValue = "";
			$this->ACC1_MT_BRUT->TooltipValue = "";

			// ACC_RENDEMENT
			$this->ACC_RENDEMENT->LinkCustomAttributes = "";
			$this->ACC_RENDEMENT->HrefValue = "";
			$this->ACC_RENDEMENT->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.ftabemp4list, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.ftabemp4list, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.ftabemp4list, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "email")) {
			$url = $custom ? ",url:'" . $this->pageUrl() . "export=email&amp;custom=1'" : "";
			return '<button id="emf_tabemp4" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_tabemp4\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.ftabemp4list, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = TRUE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"ftabemp4listsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecords = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecords = $rs->RecordCount();
		}
		$this->StartRecord = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
			$this->DisplayRecords = $this->TotalRecords;
			$this->StopRecord = $this->TotalRecords;
		} else { // Export one page only
			$this->setupStartRecord(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecords <= 0) {
				$this->StopRecord = $this->TotalRecords;
			} else {
				$this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRecord = 1;
			$this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!Config("DEBUG") && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (Config("DEBUG") && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>